/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArchUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.arch.Processor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArchUtilsTest
extends AbstractLangTest {
    private static final String IA64 = "ia64";
    private static final String IA64_32 = "ia64_32";
    private static final String PPC = "ppc";
    private static final String PPC64 = "ppc64";
    private static final String X86 = "x86";
    private static final String X86_64 = "x86_64";
    private static final String AARCH_64 = "aarch64";
    private static final String RISCV_64 = "riscv64";
    private static final String RISCV_32 = "riscv32";

    private void assertEqualsArchNotNull(Processor.Arch arch, Processor processor) {
        Assertions.assertNotNull((Object)arch);
        Assertions.assertNotNull((Object)processor);
        Assertions.assertEquals((Object)arch, (Object)processor.getArch());
    }

    private void assertEqualsTypeNotNull(Processor.Type type, Processor processor) {
        Assertions.assertNotNull((Object)type);
        Assertions.assertNotNull((Object)processor);
        Assertions.assertEquals((Object)type, (Object)processor.getType());
    }

    private void assertNotEqualsArchNotNull(Processor.Arch arch, Processor processor) {
        Assertions.assertNotNull((Object)arch);
        Assertions.assertNotNull((Object)processor);
        Assertions.assertNotEquals((Object)arch, (Object)processor.getArch());
    }

    private void assertNotEqualsTypeNotNull(Processor.Type type, Processor processor) {
        Assertions.assertNotNull((Object)type);
        Assertions.assertNotNull((Object)processor);
        Assertions.assertNotEquals((Object)type, (Object)processor.getType());
    }

    @Test
    public void testArch() {
        Processor processor = ArchUtils.getProcessor((String)X86);
        this.assertEqualsTypeNotNull(Processor.Type.X86, processor);
        Assertions.assertTrue((boolean)processor.isX86());
        this.assertNotEqualsTypeNotNull(Processor.Type.PPC, processor);
        Assertions.assertFalse((boolean)processor.isPPC());
        processor = ArchUtils.getProcessor((String)X86_64);
        this.assertEqualsTypeNotNull(Processor.Type.X86, processor);
        Assertions.assertTrue((boolean)processor.isX86());
        processor = ArchUtils.getProcessor((String)IA64_32);
        this.assertEqualsTypeNotNull(Processor.Type.IA_64, processor);
        Assertions.assertTrue((boolean)processor.isIA64());
        processor = ArchUtils.getProcessor((String)IA64);
        this.assertEqualsTypeNotNull(Processor.Type.IA_64, processor);
        Assertions.assertTrue((boolean)processor.isIA64());
        this.assertNotEqualsTypeNotNull(Processor.Type.X86, processor);
        Assertions.assertFalse((boolean)processor.isX86());
        processor = ArchUtils.getProcessor((String)PPC);
        this.assertEqualsTypeNotNull(Processor.Type.PPC, processor);
        Assertions.assertTrue((boolean)processor.isPPC());
        this.assertNotEqualsTypeNotNull(Processor.Type.IA_64, processor);
        Assertions.assertFalse((boolean)processor.isIA64());
        processor = ArchUtils.getProcessor((String)PPC64);
        this.assertEqualsTypeNotNull(Processor.Type.PPC, processor);
        Assertions.assertTrue((boolean)processor.isPPC());
        processor = ArchUtils.getProcessor((String)AARCH_64);
        this.assertEqualsTypeNotNull(Processor.Type.AARCH_64, processor);
        Assertions.assertTrue((boolean)processor.isAarch64());
        processor = ArchUtils.getProcessor((String)RISCV_32);
        this.assertEqualsTypeNotNull(Processor.Type.RISC_V, processor);
        Assertions.assertTrue((boolean)processor.isRISCV());
        processor = ArchUtils.getProcessor((String)RISCV_64);
        this.assertEqualsTypeNotNull(Processor.Type.RISC_V, processor);
        Assertions.assertTrue((boolean)processor.isRISCV());
    }

    @Test
    public void testArchLabels() {
        for (Processor.Arch arch : Processor.Arch.values()) {
            Assertions.assertFalse((boolean)arch.getLabel().isEmpty());
        }
    }

    @Test
    public void testGetProcessor() {
        Assertions.assertNotNull((Object)ArchUtils.getProcessor((String)X86));
        Assertions.assertNull((Object)ArchUtils.getProcessor((String)"NA"));
        Assertions.assertNull((Object)ArchUtils.getProcessor(null));
        Processor processor = ArchUtils.getProcessor();
        Assertions.assertNotEquals((Object)ObjectUtils.identityToString((Object)processor), (Object)processor.toString());
    }

    @Test
    public void testIs32BitJVM() {
        Processor processor = ArchUtils.getProcessor((String)X86);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assertions.assertTrue((boolean)processor.is32Bit());
        processor = ArchUtils.getProcessor((String)IA64_32);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assertions.assertTrue((boolean)processor.is32Bit());
        processor = ArchUtils.getProcessor((String)PPC);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        processor.is32Bit();
        processor = ArchUtils.getProcessor((String)RISCV_32);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assertions.assertTrue((boolean)processor.is32Bit());
        processor = ArchUtils.getProcessor((String)X86_64);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assertions.assertFalse((boolean)processor.is32Bit());
        processor = ArchUtils.getProcessor((String)PPC64);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assertions.assertFalse((boolean)processor.is32Bit());
        processor = ArchUtils.getProcessor((String)IA64);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assertions.assertFalse((boolean)processor.is32Bit());
        processor = ArchUtils.getProcessor((String)RISCV_64);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assertions.assertFalse((boolean)processor.is32Bit());
    }

    @Test
    public void testIs64BitJVM() {
        Processor processor = ArchUtils.getProcessor((String)X86_64);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assertions.assertTrue((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)PPC64);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assertions.assertTrue((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)IA64);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assertions.assertTrue((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)RISCV_64);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assertions.assertTrue((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)X86);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assertions.assertFalse((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)PPC);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assertions.assertFalse((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)IA64_32);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assertions.assertFalse((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)RISCV_32);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assertions.assertFalse((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)AARCH_64);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assertions.assertTrue((boolean)processor.is64Bit());
        Assertions.assertFalse((boolean)processor.is32Bit());
    }

    @Test
    public void testTypeLabels() {
        for (Processor.Type type : Processor.Type.values()) {
            Assertions.assertFalse((boolean)type.getLabel().isEmpty());
        }
    }
}

