#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXMetaClass.h"
#include "FXTextCodec.h"
#include "FXCP869Codec.h"

namespace FX {

FXIMPLEMENT(FXCP869Codec,FXTextCodec,nullptr,0)


//// Created by codec tool on 03/25/2005 from: CP869.TXT ////
static const unsigned short forward_data[256]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   65533, 65533, 65533, 65533, 65533, 65533, 902,  65533, 183,  172,  166,  8216, 8217, 904,  8213, 905,
   906,  938,  908,  65533, 65533, 910,  939,  169,  911,  178,  179,  940,  163,  941,  942,  943,
   970,  912,  972,  973,  913,  914,  915,  916,  917,  918,  919,  189,  920,  921,  171,  187,
   9617, 9618, 9619, 9474, 9508, 922,  923,  924,  925,  9571, 9553, 9559, 9565, 926,  927,  9488,
   9492, 9524, 9516, 9500, 9472, 9532, 928,  929,  9562, 9556, 9577, 9574, 9568, 9552, 9580, 931,
   932,  933,  934,  935,  936,  937,  945,  946,  947,  9496, 9484, 9608, 9604, 948,  949,  9600,
   950,  951,  952,  953,  954,  955,  956,  957,  958,  959,  960,  961,  963,  962,  964,  900,
   173,  177,  965,  966,  967,  167,  968,  901,  176,  168,  969,  971,  944,  974,  9632, 160,
  };


static const unsigned char reverse_plane[17]={
  0, 10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
  };

static const unsigned char reverse_pages[74]={
  0,  61, 61, 61, 61, 61, 61, 61, 124,172,61, 61, 61, 61, 61, 61,
  61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
  61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
  61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
  61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
  };

static const unsigned short reverse_block[236]={
  0,   16,  32,  48,  64,  80,  96,  112, 128, 128, 144, 160, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 174, 190, 206, 222, 238, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 253, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 269, 285, 298, 311,
  128, 327, 343, 128, 359, 374, 390, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  };

static const unsigned char reverse_data[406]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   255,  26,   26,   156,  26,   26,   138,  245,  249,  151,  26,   174,  137,  240,  26,   26,
   248,  241,  153,  154,  26,   26,   26,   136,  26,   26,   26,   175,  26,   171,  26,   26,
   26,   26,   239,  247,  134,  26,   141,  143,  144,  26,   146,  26,   149,  152,  161,  164,
   165,  166,  167,  168,  169,  170,  172,  173,  181,  182,  183,  184,  189,  190,  198,  199,
   26,   207,  208,  209,  210,  211,  212,  213,  145,  150,  155,  157,  158,  159,  252,  214,
   215,  216,  221,  222,  224,  225,  226,  227,  228,  229,  230,  231,  232,  233,  234,  235,
   237,  236,  238,  242,  243,  244,  246,  250,  160,  251,  162,  163,  253,  26,   26,   26,
   26,   26,   142,  26,   26,   139,  140,  26,   26,   26,   26,   26,   26,   196,  26,   179,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   218,  26,   26,   26,   191,  26,   26,
   26,   192,  26,   26,   26,   217,  26,   26,   26,   195,  26,   26,   26,   26,   180,  26,
   26,   26,   26,   26,   26,   26,   194,  26,   26,   26,   26,   193,  26,   26,   26,   26,
   26,   26,   26,   197,  26,   26,   26,   205,  186,  26,   26,   201,  26,   26,   187,  26,
   26,   200,  26,   26,   188,  26,   26,   204,  26,   26,   185,  26,   26,   203,  26,   26,
   202,  26,   26,   206,  26,   26,   26,   223,  26,   26,   26,   220,  26,   26,   26,   219,
   26,   26,   26,   26,   26,   26,   26,   176,  177,  178,  26,   26,   26,   26,   26,   26,
   26,   26,   26,   26,   26,   26,   254,  26,   26,   26,   26,   26,   26,   26,   26,   26,
   26,   26,   26,   26,   26,   26,
  };


FXint FXCP869Codec::mb2wc(FXwchar& wc,const FXchar* src,FXint nsrc) const {
  if(nsrc<1) return -1;
  wc=forward_data[(FXuchar)src[0]];
  return 1;
  }


FXint FXCP869Codec::wc2mb(FXchar* dst,FXint ndst,FXwchar wc) const {
  if(ndst<1) return -1;
  dst[0]=reverse_data[reverse_block[reverse_pages[reverse_plane[wc>>16]+((wc>>10)&63)]+((wc>>4)&63)]+(wc&15)];
  return 1;
  }

FXint FXCP869Codec::mibEnum() const {
  return 2054;
  }


const FXchar* FXCP869Codec::name() const {
  return "IBM869";
  }


const FXchar* FXCP869Codec::mimeName() const {
  return "IBM869";
  }


const FXchar* const* FXCP869Codec::aliases() const {
  static const FXchar *const list[]={"microsoft-cp869","IBM869","cp869","869","cp-gr","csIBM869",nullptr};
  return list;
  }

}

