# Podman pods

Don't use the constructor directly. Instead use
```python
from python_on_whales import DockerClient

podman = DockerClient(client_call=["podman"])

my_pod = podman.pod.inspect("my-pod-name")

# or

my_pod = podman.pod.create("my-pod-name")
```

For type hints, use this
```python
from python_on_whales import Pod

def print_container_names(pod: Pod):
    print([ctr.name for ctr in pod.containers])
```

## Attributes

The attributes are the same that you get with the command line:
`podman pod inspect ...`

If you want to know the exact structure, you can go to the
[`podman pod inspect` reference page](https://docs.podman.io/en/stable/markdown/podman-pod-inspect.1.html)

An example is worth many lines of descriptions.

```
In [1]: from python_on_whales import DockerClient

In [2]: podman = DockerClient(client_call=["podman"])

In [3]: pod = podman.pod.create("my-pod")

In [4]: def super_print(obj):
   ...:     print(f"type={type(obj)}, value={obj}")
   ...:

@INSERT_GENERATED_CODE@
```

## Methods

{{autogenerated}}
