#!/bin/sh
. ./setup-test.sh

runtest_run() {
			# parse rootdev from kernel commandline if it begins with /
			case "$ROOT" in
				/*)

				# rewrite:
				# /dev/mapper/sys-rootfs -> /dev/sys/rootfs
				# /dev/mapper/blodnatt-blah--bleh -> /dev/blodnatt/blah-bleh
				# /dev/mapper/vg--meaw-root -> /dev/vg-meaw/root
				case "$ROOT" in
					/dev/mapper/*-*)
						# change "--" to / (as "/" is impossible in LV name)
						local dev=$(awk -vdev="${ROOT#/dev/mapper/}" 'BEGIN{gsub(/--/, "/", dev); print dev}')
						local VG=$(awk -vdev="$dev" 'BEGIN{split(dev, v, "-"); gsub("/", "-", v[1]); print v[1]}')
						local LV=$(awk -vdev="$dev" 'BEGIN{split(dev, v, "-"); gsub("/", "-", v[2]); print v[2]}')
						ROOT=/dev/$VG/$LV
					;;
				esac

				if [ "$ROOT" != "$ROOTDEV" ]; then
					ROOTDEV=$ROOT

					echo "LVM: Using 'root=$ROOTDEV' from kernel commandline"
					local tmp=${ROOTDEV#/dev/}
					if [ "$tmp" != "$ROOTDEV" ]; then
						ROOTVG=${tmp%/*}
						echo "LVM: Using Volume Group '$ROOTVG' for rootfs"
					fi
				fi
				;;
			esac
}

runtest ROOT=/dev/mapper/sys-rootfs OK=/dev/sys/rootfs <<'EOF'
LVM: Using 'root=/dev/sys/rootfs' from kernel commandline
LVM: Using Volume Group 'sys' for rootfs
EOF

runtest ROOT=/dev/mapper/blodnatt-blah--bleh OK=/dev/blodnatt/blah-bleh <<'EOF'
LVM: Using 'root=/dev/blodnatt/blah-bleh' from kernel commandline
LVM: Using Volume Group 'blodnatt' for rootfs
EOF

runtest ROOT=/dev/mapper/blodnatt-blah--bleh--blah OK=/dev/blodnatt/blah-bleh-blah <<'EOF'
LVM: Using 'root=/dev/blodnatt/blah-bleh-blah' from kernel commandline
LVM: Using Volume Group 'blodnatt' for rootfs
EOF

runtest ROOT=/dev/mapper/vg--meaw-root OK=/dev/vg-meaw/root <<'EOF'
LVM: Using 'root=/dev/vg-meaw/root' from kernel commandline
LVM: Using Volume Group 'vg-meaw' for rootfs
EOF

echo "OK: $ok; FAIL: $fail"
