/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright (C) 1999-2003 Lars Knoll (knoll@kde.org)
 *           (C) 1999 Antti Koivisto (koivisto@kde.org)
 *           (C) 2002 Apple Computer, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * $Id: render_box.h,v 1.72 2003/11/02 15:51:28 mueller Exp $
 */
#ifndef RENDER_BOX_H
#define RENDER_BOX_H

#include "render_container.h"

namespace khtml {

enum WidthType { Width, MinWidth, MaxWidth };

class RenderBox : public RenderContainer
{


// combines ElemImpl & PosElImpl (all rendering objects are positioned)
// should contain all border and padding handling

public:
    RenderBox(DOM::NodeImpl* node);
    virtual ~RenderBox();

    virtual const char *renderName() const { return "RenderBox"; }
    virtual bool isBox() const { return true; }

    virtual void setStyle(RenderStyle *style);
    virtual void paint(QPainter *p, int _x, int _y, int _w, int _h,
                       int _tx, int _ty, PaintAction paintAction);

    virtual void close();

    virtual void detach();

    virtual short minWidth() const { return m_minWidth; }
    virtual short maxWidth() const { return m_maxWidth; }

    virtual short contentWidth() const;
    virtual int contentHeight() const;

    virtual bool absolutePosition(int &xPos, int &yPos, bool f = false);

    virtual void setPos( int xPos, int yPos );

    virtual int xPos() const { return m_x; }
    virtual int yPos() const { return m_y; }
    virtual short width() const;
    virtual int height() const;

    virtual short marginTop() const { return m_marginTop; }
    virtual short marginBottom() const { return m_marginBottom; }
    virtual short marginLeft() const { return m_marginLeft; }
    virtual short marginRight() const { return m_marginRight; }

    virtual void setWidth( int width );
    virtual void setHeight( int height );

    virtual void position(InlineBox* box, int from, int len, bool reverse, int);

    virtual int lowestPosition() const;
    virtual short rightmostPosition() const;

    virtual void repaint(bool immediate=false);

    virtual void repaintRectangle(int x, int y, int w, int h, bool immediate=false, bool f=false);

    virtual void setPixmap(const QPixmap &, const QRect&, CachedImage *);

    virtual short containingBlockWidth() const;
    void relativePositionOffset(int &tx, int &ty) const;

    virtual void calcWidth();
    virtual void calcHeight();

    virtual short calcReplacedWidth() const;
    virtual int   calcReplacedHeight() const;

    virtual int availableHeight() const;

    void calcVerticalMargins();

    virtual RenderLayer* layer() const { return m_layer; }

    void setStaticX(short staticX);
    void setStaticY(int staticY);

    virtual void caretPos(int offset, bool override, int &_x, int &_y, int &width, int &height);

    void calcHorizontalMargins(const Length& ml, const Length& mr, int cw);

private:

    int calcWidthUsing(WidthType widthType, int cw, LengthType& lengthType);

protected:
    virtual void paintBoxDecorations(QPainter *p,int _x, int _y,
                                       int _w, int _h, int _tx, int _ty);
    void paintBackground(QPainter *p, const QColor &c, CachedImage *bg, int clipy, int cliph, int _tx, int _ty, int w, int h);
    virtual void paintBackgroundExtended(QPainter* /*p*/, const QColor& /*c*/, CachedImage* /*bg*/,
                                         int /*clipy*/, int /*cliph*/, int /*_tx*/, int /*_ty*/,
                                         int /*w*/, int /*height*/, int /*bleft*/, int /*bright*/ );

    void paintRootBoxDecorations( QPainter *p,int, int _y,
                                                int, int _h, int _tx, int _ty );

    void outlineBox(QPainter *p, int _tx, int _ty, const char *color = "red");

    virtual int borderTopExtra() { return 0; }
    virtual int borderBottomExtra() { return 0; }

    void calcAbsoluteHorizontal();
    void calcAbsoluteVertical();

    QRect getOverflowClipRect(int tx, int ty);
    QRect getClipRect(int tx, int ty);


    // the actual height of the contents + borders + padding
    int m_height;

    int m_y;

    short m_x;
    short m_width;

    short m_marginTop;
    short m_marginBottom;

    short m_marginLeft;
    short m_marginRight;

    /*
     * the minimum width the element needs, to be able to render
     * its content without clipping
     */
    short m_minWidth;
    /* The maximum width the element can fill horizontally
     * ( = the width of the element with line breaking disabled)
     */
    short m_maxWidth;

    // Cached normal flow values for absolute positioned elements with static left/top values.
    short m_staticX;
    int m_staticY;

    RenderLayer *m_layer;
};


} //namespace

#endif
