/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Hashtable;
import org.kde.kjas.server.KJASAppletClassLoader;
import org.kde.kjas.server.KJASAppletContext;
import org.kde.kjas.server.KJASAppletPanel;
import org.kde.kjas.server.Main;

public final class KJASAppletStub
implements AppletStub {
    private KJASAppletContext context;
    private Hashtable params;
    private URL codeBase;
    private URL docBase;
    private boolean active;
    private String appletName;
    private String appletID;
    private Dimension appletSize;
    private String windowName;
    private String className;
    private Class appletClass;
    private Frame frame;
    private boolean failed = false;
    public static final int UNKNOWN = 0;
    public static final int CLASS_LOADED = 1;
    public static final int INSTANCIATED = 2;
    public static final int INITIALIZED = 3;
    public static final int STARTED = 4;
    public static final int STOPPED = 5;
    public static final int DESTROYED = 6;
    private int state = 0;
    private KJASAppletClassLoader loader;
    private KJASAppletPanel panel;
    private Applet app;
    private Thread runThread;
    private Thread appletThread = null;
    private Thread destroyThread = null;
    KJASAppletStub me;

    public KJASAppletStub(KJASAppletContext kJASAppletContext, String string, URL uRL, URL uRL2, String string2, String string3, Dimension dimension, Hashtable hashtable, String string4, KJASAppletClassLoader kJASAppletClassLoader) {
        this.context = kJASAppletContext;
        this.appletID = string;
        this.codeBase = uRL;
        this.docBase = uRL2;
        this.active = false;
        this.state = 0;
        this.appletName = string2;
        this.className = string3.replace('/', '.');
        this.appletSize = dimension;
        this.params = hashtable;
        this.windowName = string4;
        this.loader = kJASAppletClassLoader;
        String string5 = string3;
        if (string3.endsWith(".class") || string3.endsWith(".CLASS")) {
            string5 = string3.substring(0, string3.length() - 6);
        } else if (string3.endsWith(".java") || string3.endsWith(".JAVA")) {
            string5 = string3.substring(0, string3.length() - 5);
        }
        this.className = string5.replace('/', '.');
        this.appletClass = null;
        this.me = this;
    }

    private void tryToStopThread(Thread thread) {
        try {
            thread.interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (thread.isAlive()) {
            try {
                thread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void stateChange(int n) {
        if (this.failed) {
            return;
        }
        this.state = n;
        Main.protocol.sendAppletStateNotification(this.context.getID(), this.appletID, n);
    }

    private void setFailed(String string) {
        this.failed = true;
        this.loader.removeStatusListener(this.panel);
        this.panel.stopAnimation();
        this.panel.showFailed();
        Main.protocol.sendAppletFailed(this.context.getID(), this.appletID, string);
    }

    void createApplet() {
        this.panel = new KJASAppletPanel();
        this.frame = new Frame(this.windowName);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                KJASAppletStub.this.me.destroyApplet();
            }
        });
        this.frame.add((Component)this.panel, "Center");
        this.frame.setUndecorated(true);
        this.frame.setLocation(0, 0);
        this.frame.pack();
        this.frame.setVisible(true);
        this.loader.addStatusListener(this.panel);
        this.runThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    KJASAppletStub.this.appletClass = KJASAppletStub.this.loader.loadClass(KJASAppletStub.this.className);
                }
                catch (Exception exception) {
                    Main.kjas_err("Class could not be loaded: " + KJASAppletStub.this.className, exception);
                    KJASAppletStub.this.setFailed(exception.toString());
                    return;
                }
                if (Thread.interrupted()) {
                    return;
                }
                KJASAppletStub.this.stateChange(1);
                Object var1_2 = null;
                try {
                    Class clazz = KJASAppletStub.this.appletClass;
                    synchronized (clazz) {
                        var1_2 = KJASAppletStub.this.appletClass.newInstance();
                        KJASAppletStub.this.app = var1_2;
                    }
                }
                catch (InstantiationException instantiationException) {
                    Main.kjas_err("Could not instantiate applet", instantiationException);
                    KJASAppletStub.this.setFailed(instantiationException.toString());
                    return;
                }
                catch (IllegalAccessException illegalAccessException) {
                    Main.kjas_err("Could not instantiate applet", illegalAccessException);
                    KJASAppletStub.this.setFailed(illegalAccessException.toString());
                    return;
                }
                catch (ClassCastException classCastException) {
                    if (var1_2 != null && var1_2 instanceof Component) {
                        KJASAppletStub.this.app = new Applet();
                        KJASAppletStub.this.app.setLayout(new BorderLayout());
                        KJASAppletStub.this.app.add((Component)var1_2, "Center");
                    }
                    KJASAppletStub.this.setFailed(classCastException.toString());
                    return;
                }
                catch (Throwable throwable) {
                    KJASAppletStub.this.setFailed(throwable.toString());
                    return;
                }
                if (Thread.interrupted()) {
                    return;
                }
                KJASAppletStub.this.app.setStub(KJASAppletStub.this.me);
                KJASAppletStub.this.stateChange(2);
                KJASAppletStub.this.app.setVisible(false);
                KJASAppletStub.this.panel.setApplet(KJASAppletStub.this.app);
                if (KJASAppletStub.this.appletSize.getWidth() > 0.0) {
                    KJASAppletStub.this.app.setBounds(0, 0, ((KJASAppletStub)KJASAppletStub.this).appletSize.width, ((KJASAppletStub)KJASAppletStub.this).appletSize.height);
                } else {
                    KJASAppletStub.this.app.setBounds(0, 0, ((KJASAppletStub)KJASAppletStub.this).panel.getSize().width, ((KJASAppletStub)KJASAppletStub.this).panel.getSize().height);
                }
                try {
                    KJASAppletStub.this.app.init();
                }
                catch (Error error) {
                    Main.info("Error " + error.toString() + " during applet initialization");
                    error.printStackTrace();
                    KJASAppletStub.this.setFailed(error.toString());
                    return;
                }
                catch (Exception exception) {
                    Main.info("Exception " + exception.toString() + " during applet initialization");
                    exception.printStackTrace();
                    KJASAppletStub.this.setFailed(exception.toString());
                    return;
                }
                if (Thread.interrupted()) {
                    return;
                }
                KJASAppletStub.this.stateChange(3);
                KJASAppletStub.this.loader.removeStatusListener(KJASAppletStub.this.panel);
                KJASAppletStub.this.app.setVisible(true);
                KJASAppletStub.this.panel.stopAnimation();
            }
        }, "KJAS-AppletStub-" + this.appletID + "-" + this.appletName);
        this.runThread.setContextClassLoader(this.loader);
        this.runThread.start();
    }

    void startApplet() {
        if (this.app != null && this.state == 3) {
            this.active = true;
            if (this.appletThread == null) {
                this.appletThread = new Thread("KJAS-Applet-" + this.appletID + "-" + this.appletName){

                    public void run() {
                        KJASAppletStub.this.frame.validate();
                        KJASAppletStub.this.app.start();
                        KJASAppletStub.this.app.repaint();
                        KJASAppletStub.this.appletThread = null;
                    }
                };
                this.appletThread.start();
            }
            this.stateChange(4);
        }
    }

    void stopApplet() {
        if (this.app != null) {
            if (this.appletThread != null && this.appletThread.isAlive()) {
                Main.debug("appletThread is active when stop is called");
                this.tryToStopThread(this.appletThread);
            }
            this.appletThread = null;
            this.active = false;
            this.app.stop();
            this.stateChange(5);
            WindowListener[] windowListenerArray = this.frame.getWindowListeners();
            for (int i = 0; windowListenerArray != null && i < windowListenerArray.length; ++i) {
                this.frame.removeWindowListener(windowListenerArray[i]);
            }
            this.frame.hide();
        }
    }

    void initApplet() {
        if (this.app != null) {
            this.app.init();
        }
        this.stateChange(3);
    }

    synchronized void destroyApplet() {
        if (this.state >= 6 || this.destroyThread != null) {
            return;
        }
        this.destroyThread = new Thread("applet destroy thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (KJASAppletStub.this.runThread != null && KJASAppletStub.this.runThread.isAlive()) {
                    Main.debug("runThread is active when stub is dying");
                    KJASAppletStub.this.tryToStopThread(KJASAppletStub.this.runThread);
                    KJASAppletStub.this.runThread = null;
                    KJASAppletStub.this.panel.stopAnimation();
                    KJASAppletStub.this.loader.removeStatusListener(KJASAppletStub.this.panel);
                }
                if (KJASAppletStub.this.app != null) {
                    Applet applet = KJASAppletStub.this.app;
                    synchronized (applet) {
                        if (KJASAppletStub.this.active) {
                            try {
                                KJASAppletStub.this.stopApplet();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        try {
                            KJASAppletStub.this.app.destroy();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    KJASAppletStub.this.frame.dispose();
                    KJASAppletStub.this.app = null;
                    KJASAppletStub.this.stateChange(6);
                }
                KJASAppletStub.this.loader = null;
                KJASAppletStub.this.context = null;
                KJASAppletStub.this.destroyThread = null;
            }
        };
        this.destroyThread.start();
    }

    Applet getApplet() {
        return this.app;
    }

    public String getParameter(String string) {
        return (String)this.params.get(string.toUpperCase());
    }

    public boolean isActive() {
        return this.active;
    }

    boolean isLoaded() {
        return this.state >= 2;
    }

    public void appletResize(int n, int n2) {
        if (this.active && n >= 0 && n2 >= 0) {
            Main.debug("Applet #" + this.appletID + ": appletResize to : (" + n + ", " + n2 + ")");
            Main.protocol.sendResizeAppletCmd(this.context.getID(), this.appletID, n, n2);
            this.appletSize = new Dimension(n, n2);
        }
    }

    public AppletContext getAppletContext() {
        return this.context;
    }

    public URL getCodeBase() {
        return this.codeBase;
    }

    public URL getDocumentBase() {
        return this.docBase;
    }

    public String getAppletName() {
        return this.appletName;
    }

    class KJASAppletThread
    extends Thread {
        private KJASAppletStub stub;

        public KJASAppletThread(KJASAppletStub kJASAppletStub2, String string) {
            super(string);
            this.stub = kJASAppletStub2;
        }

        public void run() {
            this.stub.startApplet();
        }
    }
}

