# PlayStation Remote Play for Everyone

!!! Abstract "Site Purpose"

    This site serves to get you up and running with chiaki-ng!

## Getting Started

Start by visiting the [Setup section](setup/index.md){target="_blank" rel="noopener"} and following each of the subsections to learn how to setup `chiaki-ng`.

## Supporting

[Buy me a coffee](https://buymeacoffee.com/streetpea){target="_blank" rel="noopener"}

## Getting Updates

Visit [chiaki-ng Releases](updates/releases.md){target="_blank" rel="noopener"} for instructions on updating to the newest release, with notes for each release.

## Additional Information

### About Chiaki

[Chiaki](https://git.sr.ht/~thestr4ng3r/chiaki){target="_blank" rel="noopener"} is a "Free and Open Source PlayStation Remote Play Client" licensed under the [GNU Affero General Public License version 3](https://www.gnu.org/licenses/agpl-3.0.html){target="_blank" rel="noopener"} (AGPL V3). This license enables anyone to share and modify the source code to add additional features on the condition that they make those publicly available (copy-left) and also license them under the same AGPL V3 license.

### About `chiaki-ng`

`chiaki-ng` aims to serve as a next generation of Chiaki bringing new features and changes to the existing project which is now in maintenance mode. It is available on Linux, Windows, and MacOS.

!!! Question "Where is `chiaki-ng` available?"

    There is a flatpak on flathub for Linux (https://flathub.org/apps/io.github.streetpea.Chiaki4deck){target="_blank" rel="noopener"} as well as packages for Linux, Windows, and MacOS (amd64 and arm64) on the [releases page](https://github.com/streetpea/chiaki4deck/releases){target="_blank" rel="noopener"}. See the [Installation section](setup/installation.md){target="_blank" rel="noopener"} to get started.
    
For users that want to build from source, I have also provided the updated source code on the accompanying GitHub repo (the link to the GitHub is on the top right [top left menu on mobile] of the site banner you see if you scroll to the top of any page). Instructions for this are in the [DIY section](diy/buildit.md){target="_blank" rel="noopener"}. As it stands, a lot of the documentation applies to the general Chiaki flatpak in addition to the `chiaki-ng` flatpak, but instructions are specifically tailored to `chiaki-ng` and the updates included therein. To use this documentation with the Chiaki flatpak replace `io.github.streetpea.Chiaki4deck` with `re.chiaki.Chiaki` where applicable and note that the features listed in the [Updates section](updates/done.md){target="_blank" rel="noopener"} will not work with that version (they only work with `chiaki-ng` until the main `Chiaki` flatpak gets an update.)

## Submitting Documentation Updates

If you want to update the documentation to add helpful information of your own, you can scroll to the top of the page you want to edit and click the paper with pencil icon on the top right (to the right of the current page's title). This will enable you to make edits and submit them for approval. If you have more detailed edits or a new contribution, you can build the documentation locally and see the changes rendered as you make and save them by following the [Building the Documentation Yourself section](diy/builddocs.md){target="_blank" rel="noopener"}.

## Making Suggestions for Improvements to the Documentation

Please submit general issues to the [chiaki-ng GitHub](https://github.com/streetpea/chiaki-ng/issues){target="_blank" rel="noopener"} as well as specific issues related to a given page by clicking the :material-heart-broken: underneath "Was this page helpful?" and opening the feedback form for the page you think needs updating.

## Acknowledgements

* Thanks to the following individuals:
    - Chiaki Authors (including but not limited to Florian Märkl)
    - Reddit users and others who have helped me in my personal Chiaki journey such as u/mintcu7000 with his getting started guide on Reddit
    - Egoistically for the RGB update patch
    - Florian Grill for his gracious help with reverse engineering the PlayStation remote play protocols
    - Kirin Ghost for creating chiaki-ng artwork

* Thanks to the following open-source projects for inspiration around Steam Deck gyro and haptics:
    - [Steam Controller Singer](https://github.com/Roboron3042/SteamControllerSinger){target="_blank" rel="noopener"}
    - [Steam Deck Gyro DSU](https://github.com/kmicki/SteamDeckGyroDSU){target="_blank" rel="noopener"}

## Maintainer

* [Street Pea](https://www.reddit.com/message/compose/?to=Street_Pea_6693){target="_blank" rel="noopener"}

## Contributors

* [Johannes Baiter](https://github.com/jbaiter){target="_blank" rel="noopener"}
* [Jamie Bartlett](https://github.com/Nikorag?tab=repositories){target="_blank" rel="noopener"}
* [Joni Bimbashi](https://github.com/jonibim){target="_blank" rel="noopener"}
* [David Rosca](https://github.com/nowrep){target="_blank" rel="noopener"}
* [Street Pea](https://github.com/streetpea){target="_blank" rel="noopener"}
