# RK3576 Release Note

## rk3576_spl_v1.08.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :----------------------- | ----------- | -------- |
| 2025-06-09 | rk3576_spl_v1.08.bin | 60e6e79d7a0   | important     |

### New

1. Modify load address of spl bin.
2. Add sdmmc pinctrl support.

------

## rk3576_bl31_v1.20.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-05-13 | rk3576_bl31_v1.20.elf | 4d7e811c6 | important |

### New

1. Change the base address of BL31 to 0x60000.
2. Enhance the stability of system reboot.

------

## rk3576_bl32_v1.06.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-05-12 | rk3576_bl32_v1.06.bin | 667b54418    | important |

### New

1. Add support for verify config ip.
2. Add OEM OTP KEY hmac support for user ta.

### Fixed

| Index | Severity  | Update                                                   | Issue description                                     | Issue source |
| ----- | --------- | -------------------------------------------------------- | ----------------------------------------------------- | ------------ |
| 1     | important | Merge official security patches                          | Address potential security risks                      | -            |
| 2     | important | Support automatic file recovery after abnormal power off | Abnormal power off causes user ta cannot run normally | 517988       |

------

## rk3576_bl31_v1.19.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-03-21 | rk3576_bl31_v1.19.elf | f3570ca5d | important |

### New

1. Enhanced usb1 stability for rk3576_s1.

------

## rk3576_bl31_v1.18.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-03-14 | rk3576_bl31_v1.18.elf | b072a1255 | important |

### New

1. Supports SCU1_AUTO_PD function to be enabled dynamically.
2. Supports panic and wdt reset under MOS.

------

## rk3576_bl31_v1.17.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-03-03 | rk3576_bl31_v1.17.elf | 70d3deb59    | important |

### New

1. Support to configure gpio-group.
2. Reduce the BL31 firmware size..

------

## rk3576_bl31_v1.16.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-02-13 | rk3576_bl31_v1.16.elf | fab0f0345    | important |

### New

1. Optimize speed of system resume.
2. Optimize the flow of detecting  external 32k clock.

------

## rk3576_boost_v1.03.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ----------- | -------- |
| 2025-01-24 | rk3576_boost_v1.03.bin | 8a55316839   | moderate |

### Fixed

| Index | Severity  | Update                  | Issue description                    | Issue source |
| ----- | --------- | ----------------------- | ------------------------------------ | ------------ |
| 1     | moderate | accelerate UFS boot speed. | The boot speed of UFS is relatively slow. | -            |

------

## rk3576_bl31_v1.15.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-01-03 | rk3576_bl31_v1.15.elf | bf841fed1    | important |

### New

1. Support dual system.
2. Support wake source after virtual-poweroff.
3. Enhanced otp stability after ultra sleep.

------

## rk3576_bl31_v1.14.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-11-08 | rk3576_bl31_v1.14.elf | c481e5368    | important |

### New

1. Support RK3576 j/m.
2. Support reset arch timer after system resume.

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.09.bin

| Date       | File                                                          | Build commit | Severity  |
| ---------- | :------------------------------------------------------------ | ------------ | --------- |
| 2024-11-07 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.09.bin | 2f85f4b2d4   | important |

### New

1. Add support RK3576J and RK3576M.
2. Optimize DDR performance.
3. Hptimer support 1G frequency.

------

## rk3576_usbplug_v1.04.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-11-07 | rk3576_usbplug_v1.04.bin | 13ceb2afdcb | important     |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Add 1Ghz arch timer support, and usbplug is adjusted to get current arch timer frequency from preloader by default. | Delay in usbplug is inaccurate. | -            |

------

## rk3576_spl_v1.07.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-11-07 | rk3576_spl_v1.07.bin | 13ceb2afdcb | important     |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Add 1Ghz arch timer support, and SPL is adjusted to get current arch timer frequency from preloader by default. | Delay in SPL is inaccurate, and time print at the end is inaccurate too. | -            |

------

## rk3576_bl32_v1.05.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-11-01 | rk3576_bl32_v1.05.bin | 9f2aca7d1    | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | check whether the rpmb key has been burned before changing security level | upgrading from weak security level to strong security level may result in rpmb key verification failure | -            |
| 2     | important | fixed RSA OAEP MGF1 algorithm                                | TA will report an error when using RSA algorithm OAEP MGF1 padding method | -            |
| 3     | important | fixed condition of whether secure boot is enabled            | Under unstable hardware conditions, it may be mistakenly believed that secure boot is enabled | -            |

------

## rk3576_bl31_v1.13.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-10-31 | rk3576_bl31_v1.13.elf | b21ffefc7    | important |

### New

1. Add control for PLDO2 in the system suspend/resume.

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.08.bin

| Date       | File                                                          | Build commit | Severity  |
| ---------- | :------------------------------------------------------------ | ------------ | --------- |
| 2024-10-09 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.08.bin | fcb0cfd52f   | important |

### New

1. Add support RK3576S.

------

## rk3576_bl31_v1.12.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-10-09 | rk3576_bl31_v1.12.elf | 2535b79ce    | important |

### New

1. Support fast-boot.
2. Support RK3576S1.

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.07.bin

| Date       | File                                                         | Build commit | Severity  |
| ---------- | :----------------------------------------------------------- | ------------ | --------- |
| 2024-09-26 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.07.bin | 584efc13bf   | important |

### New

1. Enable dvfs/periodic training in loader.

### Fixed

| Index | Severity  | Update                                          | Issue description                                            | Issue source |
| ----- | --------- | ----------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Fix rd_dqs_vref_training                        | A few chips rd_dqs_vref_training results may be unreasonable, resulting in abnormal DDR | -            |
| 2     | important | Fix LPDDR5 ultra suspend resume failure issue   | -                                                            | -            |
| 3     | moderate  | Update the criteria of the eye scan result pass | -                                                            | -            |

------

## rk3576_usbplug_fspi1_v1.03.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :----------------------- | ----------- | -------- |
| 2024-09-18 | rk3576_usbplug_fspi1_v1.03.bin | 4546bd092ab5 | important     |

### New

1. Support GPT bakcup.

------

## rk3576_bl31_v1.11.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-09-21 | rk3576_bl31_v1.11.elf | 5ed489867    | important |

### New

1. Support non-CPU0 interrupt wake up when system suspend.
2. Pull up pmu_sleep pin1 by default when system suspend.
3. Support AMP OS.

------

## rk3576_spl_v1.06.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :----------------------- | ----------- | -------- |
| 2024-09-13 | rk3576_spl_v1.06.bin | 8532be3569c   | important     |

### New

1. Modify the erase protection function, and vendor storage data can also be erased.
2. Modify the MPHY power supply judgment to solve some UFS support exception issues.
3. Add CRU reset to the controller to solve individual UFS initialization issues.

------

## rk3576_usbplug_v1.03.bin

| Date        | File                     | Build commit | Severity  |
| ----------- | :----------------------- | ------------ | --------- |
| 2024-09-013 | rk3576_usbplug_v1.03.bin | 8532be356    | important |

### New

1. Modify the erase protection function, and vendor storage data can also be erased.
2. Modify the MPHY power supply judgment to solve some UFS support exception issues.
3. Add CRU reset to the controller to solve individual UFS initialization issues.

------

## rk3576_bl32_v1.04.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-09-02 | rk3576_bl32_v1.04.bin | 6c78a7d8c    | important |

### New

1. Supports reading and writing OTP data for Non Protected OEM Zone.
2. Support software TA encryption key, customers can use TA encryption function without burning the key.

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.06.bin

| Date       | File                                                         | Build commit | Severity  |
| ---------- | :----------------------------------------------------------- | ------------ | --------- |
| 2024-07-27 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.06.bin | a6303af65c   | important |

### New

1. Support x16, x8 die mixed package LPDDR4(X).
2. Add JEDEC Rx Mask for eyescan.

### Fixed

| Index | Severity  | Update                                                 | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Optimize LPDDR5 stability                              | -                                                            | -            |
| 2     | important | Fix ultra suspend low probability resume failure issue | ultra suspend resume fails with a low probability            | -            |
| 3     | moderate  | Optimize uart printing speed                           | -                                                            | -            |
| 4     | moderate  | Increased force jtag time to 1 second                  | Individual boards with problematic uart hardware design will be switched to jtag mode | -            |

------

## rk3576_bl32_v1.03.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-07-22 | rk3576_bl32_v1.03.bin | 1bfd9b503    | important |

### New

1. Support block reading of RPMB data.
2. Close Keylad function for get otp zero count.

------

## rk3576_bl31_v1.10.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-07-20 | rk3576_bl31_v1.10.elf | 6130bb51a    | important |

### New

1. Support gpio0 debounce interrupt wake up when system suspend.
2. Support access mem_os_reg.
3. Save global reset status in mem_os_reg.

------

## rk3576_bl31_v1.09.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-06-28 | rk3576_bl31_v1.09.elf | 286c013b2    | important |

### New

1. Support to close VDD_CPU_BIG.
2. Support 1G frequency of cpu timer.
3. Support for reducing length.

------

## rk3576_spl_v1.05.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :----------------------- | ----------- | -------- |
| 2024-06-19 | rk3576_spl_v1.05.bin | 884f049582f   | important     |

### Fixed

| Index | Severity  | Update                  | Issue description                    | Issue source |
| ----- | --------- | ----------------------- | ------------------------------------ | ------------ |
| 1     | important     | Add write maskrom flag to OS_REG0 support | SPL will now write OS_REG0 to enter maskrom mode. | -        |

------

## rk3576_{usbplug,usbplug_fspi1}_v1.02.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :----------------------- | ----------- | -------- |
| 2024-06-19 | rk3576_{usbplug,usbplug_fspi1}_v1.02.bin | 0fe85c2474 | important     |

### Fixed

| Index | Severity  | Update                  | Issue description                    | Issue source |
| ----- | --------- | ----------------------- | ------------------------------------ | ------------ |
| 1     | important     | Add clear OS_REG0 support | SPL will write OS_REG0 to enter maskrom mode, usbplug needs to clear the maskrom flag accordingly. | -        |

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,eyescan}_v1.05.bin

| Date       | File                                                         | Build commit | Severity  |
| ---------- | :----------------------------------------------------------- | ------------ | --------- |
| 2024-06-17 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,eyescan}_v1.05.bin | da1087e33f   | important |

### New

1. Supports dram whose cs0 row is less than cs1 row.
2. Add eyescan DDR bin.

### Fixed

| Index | Severity  | Update                                            | Issue description                             | Issue source |
| ----- | --------- | ------------------------------------------------- | --------------------------------------------- | ------------ |
| 1     | important | Ensure VOP bandwidth in extreme situations        | -                                             | -            |
| 2     | important | Fix probabilistic failure to detect LPDDR4(X) CS1 | Probabilistic failure to detect LPDDR4(X) CS1 | -            |

------

## rk3576_bl31_v1.08.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-06-07 | rk3576_bl31_v1.08.elf | 6102c2d62    | important |

### New

1. Support rbrom command in UFS machines.
2. Enable memory repair according to otp.

------

## rk3576_bl31_v1.07.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-05-29 | rk3576_bl31_v1.07.elf | d6d387faa    | important |

### New

1. Support power off vdd_logic when virtual-poweroff.
2. Support to configure bus_mcu in NS.
3. Improve DDR stability when ultra suspend.
4. Support DFS in VOP+EBC machine.

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,eyescan}_v1.04.bin

| Date       | File                                                         | Build commit | Severity  |
| ---------- | :----------------------------------------------------------- | ------------ | --------- |
| 2024-05-28 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,eyescan}_v1.04.bin | 27ded95582   | important |

### New

1. Supports dram whose cs0 row is less than cs1 row.
2. Add eyescan DDR bin.

### Fixed

| Index | Severity  | Update                                                    | Issue description | Issue source |
| ----- | --------- | --------------------------------------------------------- | ----------------- | ------------ |
| 1     | important | Fix an issue with some LPDDR5 read eye skewed to the left | -                 | -            |
| 2     | important | Improve LPDDR5 534MHz high temperature stability          | -                 | -            |
| 3     | important | Improve ultra suspend stability                           | -                 | -            |
| 4     | important | Improve reboot stability                                  | -                 | -            |
| 5     | moderate  | Improve print result of eye scan                          | -                 | -            |

------

## rk3576_boost_v1.02.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-05-25 | rk3576_boost_v1.02.bin | 85a3a9ac98   | moderate |

### Fixed

| Index | Severity  | Update                  | Issue description                    | Issue source |
| ----- | --------- | ----------------------- | ------------------------------------ | ------------ |
| 1     | moderate | Close uart print | If baud rate is not 1500000,it will print garbled text. | -            |

------

## rk3576_spl_v1.04.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-05-17 | rk3576_spl_v1.04.bin | 3e169ed6d1d    | important |

### Fixed

| Index | Severity  | Update                                         | Issue description                    | Issue source |
| ----- | --------- | ---------------------------------------------- | ------------------------------------ | ------------ |
| 1     | important | When bootrom boot from sd card, fail at SPL stage | SD card power-off mechanism in SPL exists problem | -            |

------

## rk3576_bl31_v1.06.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-05-16 | rk3576_bl31_v1.06.elf | a2ba6bc7c    | important |

### New

1. Print global reset status.
2. Support suspend from any cpu.

------

## rk3576_bl32_v1.02.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-05-13 | rk3576_bl32_v1.02.bin | b90c1680e    | important |

### New

1. Support read write verify toybrick ksn.

------

## rk3576_spl_v1.03.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-04-30 | rk3576_spl_v1.03.bin | e53b21c53e6    | important |

### Fixed

| Index | Severity  | Update                                         | Issue description                    | Issue source |
| ----- | --------- | ---------------------------------------------- | ------------------------------------ | ------------ |
| 1     | important | Fix GPT problem caused by different blocksizes of TF card and UFS device | Invalid GPT error happens | -            |

------

## rk3576_bl31_v1.05.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-04-24 | rk3576_bl31_v1.05.elf | 76e9c9f54    | important |

### New

1. Enable pd_gpu repair.
2. Add otp init.
3. Increase pvptll length for middle frequencies.
4. Adjust pvtpll table by otp opp info.
5. Hptimer support 1G frequency.
6. Don't use cpu unclean src.

### Fixed

| Index | Severity  | Update                                         | Issue description                    | Issue source |
| ----- | --------- | ---------------------------------------------- | ------------------------------------ | ------------ |
| 1     | important | Fix cpu frequecy error when suspend and resume | System crash when suspend and resume | -            |

------

## rk3576_boost_v1.00.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-23 | rk3576_boost_v1.00.bin | d4affbeb09   | important |

### Fixed

| Index | Severity  | Update                  | Issue description                    | Issue source |
| ----- | --------- | ----------------------- | ------------------------------------ | ------------ |
| 1     | important | Fixed SD card boot fail | BootROM load ddr.bin fail in SD card | -            |

------

## rk3576_spl_v1.02.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-19 | rk3576_spl_v1.02.bin | 57b8ceed1c3   | important |

### New

1. Enable cci channels for devices.
2. Add internal phase support for dwmmc.
3. Enable decom by default.
4. Add eMMC and FSPI iomux support.
5. Improve UFS support.
6. Improve usbplug support.

------

## rk3576_bl31_v1.04.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-04-16 | rk3576_bl31_v1.04.elf | 30018b771    | important |

### New

1. Reduced power consumption of the pmu 1v8 during sleep.

### Fixed

| Index | Severity  | Update                                         | Issue description                             | Issue source |
| ----- | --------- | ---------------------------------------------- | --------------------------------------------- | ------------ |
| 1     | important | Fixed GPU performance deteriorates after sleep | GPU performance will deteriorates after sleep | -            |

------

## rk3576_usbplug_v1.01.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------- | ------------ | --------- |
| 2024-04-17 | rk3576_usbplug_v1.01.bin | fa96a41a6    | important |

### New

1. Add support write booster.

### Fixed

| Index | Severity  | Update                                              | Issue description                                          | Issue source |
| ----- | --------- | --------------------------------------------------- | ---------------------------------------------------------- | ------------ |
| 1     | important | Poll for max. 1500ms for fDeviceInit flag to clear. | The timeout is too short, and UFS initialization may fail. | -            |
| 2     | important | Support UFS with PHISON UFS controller.             | Test ready command will fail.                              | -            |

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra}_v1.03.bin

| Date       | File                                                 | Build commit | Severity  |
| ---------- | :--------------------------------------------------- | ------------ | --------- |
| 2024-04-16 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra}_v1.03.bin | 81dd75088a   | important |

### Warn

1. When LPDDR5 is used, the kernel must have this patch: 540126c8642b arm64: dts: rockchip: Increase 2400M to 2750M for dmc opp table (commit ID may be different for different kernel branches).

### Fixed

| Index | Severity  | Update                                          | Issue description                            | Issue source |
| ----- | --------- | ----------------------------------------------- | -------------------------------------------- | ------------ |
| 1     | important | Change default freq of LPDDR5 to 2736MHz        | -                                            | -            |
| 2     | important | Change trigger time of force uart rx to smaller | uart may not automatically trigger jtag mode | -            |

------

## rk3576_bl32_v1.01.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-04-16 | rk3576_bl32_v1.01.bin | 185dc3c92    | important |

### New

1. Optimization parameter check to enhance security.
2. Keylad supports get otp zero count.

------

## rk3576_bl31_v1.03.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-04-10 | rk3576_bl31_v1.03.elf | 9de33eca3    | important |

### New

1. Improve DDR stability when sleep.
2. Supports DDR frequency conversion in EBC scenarios.

### Fixed

| Index | Severity  | Update                                         | Issue description                             | Issue source |
| ----- | --------- | ---------------------------------------------- | --------------------------------------------- | ------------ |
| 1     | important | Fixed CPU performance deteriorates after sleep | CPU performance will deteriorates after sleep | -            |

------

## rk3576_{spl,usbplug}_fspi1_v1.00.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-08 | rk3576_{spl,usbplug}_fspi1_v1.00.bin | 38fed2d628d   | important |

### New

1. Support fspi1 spiflash.

------

## rk3576_spl_v1.01.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-07 | rk3576_spl_v1.01.bin | 4a69562ca69   | important |

### New

1. Support SD card.
2. Support SecureBoot.
3. Enable crypto.
4. Improve UFS support.
5. Improve VOP2 support.
6. Add MCU-related register configuration.

------

## rk3576_bl31_v1.02.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-03-29 | rk3576_bl31_v1.02.elf | 5784c4ac0    | important |

### New

1. Support HDCP.
2. Enable GPU counter.

------

## rk3576_ddr_lp4_2112MHz_lp5_2376MHz_v1.02.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2024-03-22 | rk3576_ddr_lp4_2112MHz_lp5_2376MHz_v1.02.bin | 2e0089635a3  | important |

### Fixed

| Index | Severity  | Update                                   | Issue description                                                                                                                             | Issue source |
| ----- | --------- | ---------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------- | ------------ |
| 1     | important | Fixed VOP will flash with POST_BUF_EMPTY | When DDR is under heavy load, or DDR frequency is low, especially when GPU and RKNN are under heavy load, VOP will flash with POST_BUF_EMPTY. | -            |

------

## rk3576_bl31_v1.01.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-03-21 | rk3576_bl31_v1.01.elf | c87ba612c    | important |

### New

1. Support suspend/resume in uboot.
2. Support virtual poweroff.
3. Support recover system time after system resume.

------

## rk3576_{ddr,spl,usbplug}_v1.00.bin

| Date       | File                               | Build commit                                   | Severity |
| ---------- | :--------------------------------- | ---------------------------------------------- | -------- |
| 2024-03-15 | rk3576_{ddr,spl,usbplug}_v1.00.bin | ddr:563d6071c0#spl:0aca89f21:usbplug:0aca89f21 | moderate |

### New

1. Initial version.

------

## rk3576_{bl31, bl32}_v1.00.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-03-15 | rk3576_{bl31, bl32}_v1.00.bin | bl31:a83ab541f#bl32:68cdaabd4 | moderate |

### New

1. Initial version.

------

