# RK3576 Release Note

## rk3576_spl_v1.08.bin

| 时间       | 文件                     | 编译 commit | 重要程度 |
| ---------- | :----------------------- | ----------- | -------- |
| 2025-06-09 | rk3576_spl_v1.08.bin | 60e6e79d7a0 | 重要     |

### New

1. 调整spl bin的运行地址。
2. 添加sdmmc pinctrl支持。

------

## rk3576_bl31_v1.20.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2025-05-13 | rk3576_bl31_v1.20.elf | 4d7e811c6 | 重要 |

### New

1. BL31运行地址改到0x60000。
2. 提高系统重启稳定性。

------

## rk3576_bl32_v1.06.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2025-05-12 | rk3576_bl32_v1.06.bin | 667b54418   | 重要     |

### New

1. 支持verify config ip 功能。
2. 支持从OEM OTP KEY派生HMAC密钥。

### Fixed

| Index | 重要程度 | 更新说明                   | 问题现象                        | 问题来源 |
| ----- | -------- | -------------------------- | ------------------------------- | -------- |
| 1     | 重要     | 合入官方安全补丁           | 解决潜在的安全风险              | -        |
| 2     | 重要     | 支持异常掉电后文件自动恢复 | 异常掉电导致用户运行user ta报错 | 517988   |

------

## rk3576_bl31_v1.19.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2025-03-21 | rk3576_bl31_v1.19.elf | f3570ca5d | 重要 |

### New

1. 提高rk3576_s1 USB1稳定性。

------

## rk3576_bl31_v1.18.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2025-03-14 | rk3576_bl31_v1.18.elf | b072a1255 | 重要 |

### New

1. 支持动态使能SCU1_AUTO_PD功能。
2. 支持多系统的panic、wdt reset。

------

## rk3576_bl31_v1.17.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2025-03-03 | rk3576_bl31_v1.17.elf | 70d3deb59   | 重要     |

### New

1. 支持配置gpio-group。
2. 减小BL31固件大小。

------

## rk3576_bl31_v1.16.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2025-02-13 | rk3576_bl31_v1.16.elf | fab0f0345   | 重要     |

### New

1. 优化系统唤醒速度。
2. 优化外部32k时钟探测流程。

------

## rk3576_boost_v1.03.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2025-01-24 | rk3576_boost_v1.03.bin | 8a55316839 | 普通     |

### Fixed

| Index | 重要程度 | 更新说明         | 问题现象                       | 问题来源 |
| ----- | -------- | ---------------- | ------------------------------ | -------- |
| 1     | 普通   | 加速UFS启动速度，快350毫秒 | UFS启动速度较慢 | -        |

------

## rk3576_bl31_v1.15.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2025-01-03 | rk3576_bl31_v1.15.elf | bf841fed1   | 重要     |

### New

1. 支持双系统。
2. 支持假关机打印唤醒。
3. 解决超级待机唤醒后otp稳定性问题。

------

## rk3576_bl31_v1.14.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-11-08 | rk3576_bl31_v1.14.elf | c481e5368   | 重要     |

### New

1. 支持rk3576 j/m。
2. 支持系统唤醒后复位arch timer。

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.09.bin

| 时间       | 文件                                                          | 编译 commit | 重要程度 |
| ---------- | :------------------------------------------------------------ | ----------- | -------- |
| 2024-11-07 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.09.bin | 2f85f4b2d4  | 重要     |

### New

1. 新增支持RK3576J和RK3576M。
2. 优化DDR性能。
3. hptimer支持1GHz。

------

## rk3576_usbplug_v1.04.bin

| 时间       | 文件                     | 编译 commit | 重要程度 |
| ---------- | :----------------------- | ----------- | -------- |
| 2024-11-07 | rk3576_usbplug_v1.04.bin | 13ceb2afdcb | 重要     |

### Fixed

| Index | 重要程度 | 更新说明               | 问题现象                                   | 问题来源 |
| ----- | -------- | ---------------------- | ------------------------------------------ | -------- |
| 1     | 重要     | 添加1Ghz系统时钟支持，usbplug调整为默认从前级获取当前系统时钟的频率。 | usbplug中的延时不准确。 | -        |

------

## rk3576_spl_v1.07.bin

| 时间       | 文件                     | 编译 commit | 重要程度 |
| ---------- | :----------------------- | ----------- | -------- |
| 2024-11-07 | rk3576_spl_v1.07.bin | 13ceb2afdcb | 重要     |

### Fixed

| Index | 重要程度 | 更新说明               | 问题现象                                   | 问题来源 |
| ----- | -------- | ---------------------- | ------------------------------------------ | -------- |
| 1     | 重要     | 添加1Ghz系统时钟支持，SPL调整为默认从前级获取当前系统时钟的频率。 | SPL中的延时不准确，末尾耗时打印也不准确。 | -        |

------

## rk3576_bl32_v1.05.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-11-01 | rk3576_bl32_v1.05.bin | 9f2aca7d1   | 重要     |

### Fixed

| Index | 重要程度 | 更新说明                               | 问题现象                                        | 问题来源 |
| ----- | -------- | -------------------------------------- | ----------------------------------------------- | -------- |
| 1     | 重要     | 变更强弱安全前判断rpmb key是否已经注入 | 由弱安全升级到强安全可能出现rpmb key校验失败    | -        |
| 2     | 重要     | 修正RSA OAEP MGF1算法                  | TA在使用RSA算法OAEP MGF1填充方式会报错          | -        |
| 3     | 重要     | 修正secure boot是否使能判断条件        | 在硬件不稳定情况下可能错误认为开启了secure boot | -        |

------


## rk3576_bl31_v1.13.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-10-31 | rk3576_bl31_v1.13.elf | b21ffefc7   | 重要     |

### New

1. 控制PLDO2休眠唤醒时序。

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.08.bin

| 时间       | 文件                                                          | 编译 commit | 重要程度 |
| ---------- | :------------------------------------------------------------ | ----------- | -------- |
| 2024-10-09 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.08.bin | fcb0cfd52f  | 重要     |

### New

1. 新增支持RK3576S。

------

## rk3576_bl31_v1.12.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-10-09 | rk3576_bl31_v1.12.elf | 2535b79ce   | 重要     |

### New

1. 支持快启。
2. 支持RK3576S1。

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.07.bin

| 时间       | 文件                                                         | 编译 commit | 重要程度 |
| ---------- | :----------------------------------------------------------- | ----------- | -------- |
| 2024-09-26 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.07.bin | 584efc13bf  | 重要     |

### New

1. Loader 使能 dvfs/periodic training。

### Fixed

| Index | 重要程度 | 更新说明                       | 问题现象                                                    | 问题来源 |
| ----- | -------- | ------------------------------ | ----------------------------------------------------------- | -------- |
| 1     | 重要     | 修正 rd_dqs_vref_training      | 少数芯片 rd_dqs_vref_training 结果可能不合理，导致 DDR 异常 | -        |
| 2     | 重要     | 修复 LPDDR5 ultra 唤醒异常问题 | -                                                           | -        |
| 3     | 普通     | 更新扫眼图结果 pass 的标准     | -                                                           | -        |

------

## rk3576_usbplug_fspi1_v1.03.bin

| 时间       | 文件                     | 编译 commit | 重要程度 |
| ---------- | :----------------------- | ----------- | -------- |
| 2024-09-18 | rk3576_usbplug_fspi1_v1.03.bin | 4546bd092ab5 | 重要     |

### New

1. 支持 GPT 备份。

------

## rk3576_bl31_v1.11.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-09-21 | rk3576_bl31_v1.11.elf | 5ed489867   | 重要     |

### New

1. 休眠时支持非cpu0中断唤醒。
2. 休眠时默认拉高pmu_sleep pin1。
3. 支持AMP系统。

------

## rk3576_spl_v1.06.bin

| 时间       | 文件                     | 编译 commit | 重要程度 |
| ---------- | :----------------------- | ----------- | -------- |
| 2024-09-13 | rk3576_spl_v1.06.bin | 8532be3569c   | 重要     |

### New

1. 修改擦除保护功能，vendor storage数据也可以被擦除掉。
2. 修改MPHY供电判断，解决部分UFS支持异常问题。
3. 增加控制器CRU复位，解决个别UFS初始化异常问题。

------

## rk3576_usbplug_v1.03.bin

| 时间         | 文件                     | 编译 commit | 重要程度 |
| ----------- | :----------------------- | ----------- | -------- |
| 2024-09-013 | rk3576_usbplug_v1.03.bin | 8532be356   | 重要     |

### New

1. 修改擦除保护功能，vendor storage数据也可以被擦除掉。
2. 修改MPHY供电判断，解决部分UFS支持异常问题。
3. 增加控制器CRU复位，解决个别UFS初始化异常问题。

------

## rk3576_bl32_v1.04.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-09-02 | rk3576_bl32_v1.04.bin | 6c78a7d8c   | 重要     |

### New

1. 支持读写 Non-Protected OEM Zone 区域的 OTP 数据。
2. 支持软件TA加密密钥功能，客户可以不烧写密钥的情况下使用TA加密功能。

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.06.bin

| 时间       | 文件                                                         | 编译 commit | 重要程度 |
| ---------- | :----------------------------------------------------------- | ----------- | -------- |
| 2024-07-27 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,_eyescan}_v1.06.bin | a6303af65c  | 重要     |

### New

1. 支持 x16、x8 die mixed package LPDDR4(X)。
2. eyescan 增加 JEDEC Rx Mask。

### Fixed

| Index | 重要程度 | 更新说明                              | 问题现象                                         | 问题来源 |
| ----- | -------- | ------------------------------------- | ------------------------------------------------ | -------- |
| 1     | 重要     | 优化 LPDDR5 稳定性                    | -                                                | -        |
| 2     | 重要     | 修复 ultra suspend 低概率唤醒失败问题 | ultra suspend 低概率唤醒失败                     | -        |
| 3     | 普通     | 优化 uart 打印速度                    | -                                                | -        |
| 4     | 普通     | 加长 force jtag 时间到 1 秒           | 个别 uart 硬件设计有问题的板子会被切到 jtag 模式 | -        |

------

## rk3576_bl32_v1.03.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-07-22 | rk3576_bl32_v1.03.bin | 1bfd9b503   | 重要     |

### New

1. 支持分块读取RPMB数据。
2. 关闭 Keylad 统计 OTP 零比特个数功能。

------

## rk3576_bl31_v1.10.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-07-20 | rk3576_bl31_v1.10.elf | 6130bb51a   | 重要     |

### New

1. 支持gpio0 debounce中断唤醒。
2. 支持mem_os_reg。
3. 全局复位状态保存到mem_os_reg中。

------

## rk3576_bl31_v1.09.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-06-28 | rk3576_bl31_v1.09.elf | 286c013b2   | 重要     |

### New

1. 支持大核断电。
2. 支持1G频率的cpu timer。

------

## rk3576_spl_v1.05.bin

| 时间       | 文件                     | 编译 commit | 重要程度 |
| ---------- | :----------------------- | ----------- | -------- |
| 2024-06-19 | rk3576_spl_v1.05.bin | 884f049582f   | 重要     |

### Fixed

| Index | 重要程度 | 更新说明               | 问题现象                                   | 问题来源 |
| ----- | -------- | ---------------------- | ------------------------------------------ | -------- |
| 1     | 重要     | 新增向OS_REG0写入maskrom flag | SPL现在会写OS_REG0以进入maskrom模式 | -        |

------

## rk3576_{usbplug,usbplug_fspi1}_v1.02.bin

| 时间       | 文件                     | 编译 commit | 重要程度 |
| ---------- | :----------------------- | ----------- | -------- |
| 2024-06-19 | rk3576_{usbplug,usbplug_fspi1}_v1.02.bin | 0fe85c2474 | 重要     |

### Fixed

| Index | 重要程度 | 更新说明               | 问题现象                                   | 问题来源 |
| ----- | -------- | ---------------------- | ------------------------------------------ | -------- |
| 1     | 重要     | 增加对OS_REG0的清除 | SPL现在会写OS_REG0进入maskrom模式，需要usbplug对应清除maskrom标记 | -        |

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,eyescan}_v1.05.bin

| 时间       | 文件                                                         | 编译 commit | 重要程度 |
| ---------- | :----------------------------------------------------------- | ----------- | -------- |
| 2024-06-17 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,eyescan}_v1.05.bin | da1087e33f  | 重要     |

### Fixed

| Index | 重要程度 | 更新说明                                | 问题现象                      | 问题来源 |
| ----- | -------- | --------------------------------------- | ----------------------------- | -------- |
| 1     | 重要     | 确保极端情况下的 VOP 带宽               | -                             | -        |
| 2     | 重要     | 修正探测 LPDDR4(X) CS1 概率性失败的问题 | 探测 LPDDR4(X) CS1 概率性失败 | -        |

------

## rk3576_bl31_v1.08.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-06-07 | rk3576_bl31_v1.08.elf | 6102c2d62   | 重要     |

### New

1. 在UFS板子上支持rbrom指令。
2. 依照OTP配置使能memory repair。

------

## rk3576_bl31_v1.07.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-05-29 | rk3576_bl31_v1.07.elf | d6d387faa   | 重要     |

### New

1. 支持假关机时vdd_logic断电。
2. 支持bus_mcu非安全世界可配置。
3. 提高 ultra suspend 稳定性。
4. 支持VOP+EBC产品DDR变频功能。

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,eyescan}_v1.04.bin

| 时间       | 文件                                                         | 编译 commit | 重要程度 |
| ---------- | :----------------------------------------------------------- | ----------- | -------- |
| 2024-05-28 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra,eyescan}_v1.04.bin | 27ded95582  | 重要     |

### New

1. 支持 cs0 row 小于 cs1 row 的颗粒。
2. 新增扫眼图 DDR bin。

### Fixed

| Index | 重要程度 | 更新说明                            | 问题现象 | 问题来源 |
| ----- | -------- | ----------------------------------- | -------- | -------- |
| 1     | 重要     | 修正部分 LPDDR5 read 眼图偏左的问题 | -        | -        |
| 2     | 重要     | 提高 LPDDR5 534MHz 高温稳定性       | -        | -        |
| 3     | 重要     | 提高 ultra suspend 稳定性           | -        | -        |
| 4     | 重要     | 提高 reboot 稳定性                  | -        | -        |
| 5     | 普通     | 改进扫眼图的打印结果                | -        | -        |

------

## rk3576_boost_v1.02.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-05-25 | rk3576_boost_v1.02.bin | 85a3a9ac98   | 普通     |

### Fixed

| Index | 重要程度 | 更新说明         | 问题现象                       | 问题来源 |
| ----- | -------- | ---------------- | ------------------------------ | -------- |
| 1     | 普通   | 关闭串口打印 | 波特率不是1500000会有乱码 | -        |

------

## rk3576_spl_v1.04.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-05-17 | rk3576_spl_v1.04.bin  | 3e169ed6d1d |   重要   |

### Fixed

| Index | 重要程度 | 更新说明                      | 问题现象         | 问题来源 |
| ----- | -------- | ----------------------------- | ---------------- | -------- |
| 1     | 重要     | 解决从bootrom阶段支持sd卡启动，会卡死在SPL下问题 | SPL驱动下电sd卡机制有问题 | -        |

------

## rk3576_bl31_v1.06.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-05-16 | rk3576_bl31_v1.06.elf | a2ba6bc7c   | 重要     |

### New

1. 打印复位源。
2. 支持任意CPU进入休眠模式。

------

## rk3576_bl32_v1.02.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-05-13 | rk3576_bl32_v1.02.bin | b90c1680e   | 重要     |

### New

1. 增加读、写、校验 toybrick ksn 接口支持。

------

## rk3576_spl_v1.03.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-30 | rk3576_spl_v1.03.bin | e53b21c53e6   | 重要     |

### Fixed

| Index | 重要程度 | 更新说明                      | 问题现象         | 问题来源 |
| ----- | -------- | ----------------------------- | ---------------- | -------- |
| 1     | 重要     | 解决tf卡和UFS设备，blocksize不同导致的gpt问题 | 出现invalid gpt报错 | -        |

------

## rk3576_bl31_v1.05.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-24 | rk3576_bl31_v1.05.elf | 76e9c9f54   | 重要     |

### New

1. 启用gpu memory 修复功能。
2. 初始化otp。
3. 增加中间频率的pvtpll length。
4. 支持根据otp信息修改pvtpll length。
5. hptimer支持1GHz。
6. 不使用cpu unclean时钟源。

### Fixed

| Index | 重要程度 | 更新说明                      | 问题现象         | 问题来源 |
| ----- | -------- | ----------------------------- | ---------------- | -------- |
| 1     | 重要     | 修复休眠唤醒时cpu频率异常问题 | 高温休眠唤醒卡死 | -        |

------

## rk3576_boost_v1.00.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-23 | rk3576_boost_v1.00.bin | d4affbeb09   | 重要     |

### Fixed

| Index | 重要程度 | 更新说明         | 问题现象                       | 问题来源 |
| ----- | -------- | ---------------- | ------------------------------ | -------- |
| 1     | 重要     | 解决SD卡boot失败 | BootROM加载SD卡上的DDR.bin失败 | -        |

------

## rk3576_spl_v1.02.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-19 | rk3576_spl_v1.02.bin | 57b8ceed1c3   | 重要     |

### New

1. 为设备开启cci通道。
2. dwmmc添加内部相位支持。
3. 默认使用decom加速压缩固件启动。
4. 添加eMMC和FSPI iomux支持。
5. 完善ufs支持。
6. 完善usbplug支持。

------

## rk3576_bl31_v1.04.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-16 | rk3576_bl31_v1.04.elf | 30018b771   | 重要     |

### New

1. 降低休眠时pmu_1v8的功耗。

### Fixed

| Index | 重要程度 | 更新说明                      | 问题现象              | 问题来源 |
| ----- | -------- | ----------------------------- | --------------------- | -------- |
| 1     | 重要     | 修正休眠唤醒后gpu性能下降问题 | 休眠唤醒后gpu跑分下降 | -        |

------

## rk3576_usbplug_v1.01.bin

| 时间       | 文件                     | 编译 commit | 重要程度 |
| ---------- | :----------------------- | ----------- | -------- |
| 2024-04-17 | rk3576_usbplug_v1.01.bin | fa96a41a6   | 重要     |

### New

1. 启用write booster特性。

### Fixed

| Index | 重要程度 | 更新说明               | 问题现象                                   | 问题来源 |
| ----- | -------- | ---------------------- | ------------------------------------------ | -------- |
| 1     | 重要     | 初始化时间修改到1500ms | 默认代码配置超时时间太短，初始化可能会失败 | -        |
| 2     | 重要     | 支持PHISON控制器的UFS  | Test ready 命令会出错                      | -        |

------

## rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra}_v1.03.bin

| 时间       | 文件                                                 | 编译 commit | 重要程度 |
| ---------- | :--------------------------------------------------- | ----------- | -------- |
| 2024-04-16 | rk3576_ddr_lp4_2112MHz_lp5_2736MHz{_ultra}_v1.03.bin | 81dd75088a  | 重要     |

### Warn

1. 使用 LPDDR5 时，要求 kernel 有该补丁：540126c8642b arm64: dts: rockchip: Increase 2400M to 2750M for dmc opp table（不同 kernel 分支的 commit ID 可能不一样）。

### Fixed

| Index | 重要程度 | 更新说明                      | 问题现象                            | 问题来源 |
| ----- | -------- | ----------------------------- | ----------------------------------- | -------- |
| 1     | 重要     | LPDDR5 默认频率改为 2736MHz   | -                                   | -        |
| 2     | 重要     | 改小 force uart rx 的触发时间 | uart 可能无法自动触发进入 jtag 模式 | -        |

------

## rk3576_bl32_v1.01.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-16 | rk3576_bl32_v1.01.bin | 185dc3c92   | 重要     |

### New

1. 增加输入参数检查，增加安全性。
2. Keylad 支持统计 OTP 零比特个数。

------

## rk3576_bl31_v1.03.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-10 | rk3576_bl31_v1.03.elf | 9de33eca3   | 重要     |

### New

1. 提高DDR变频和休眠唤醒稳定性。
2. 支持电子书EBC场景DDR变频。

### Fixed

| Index | 重要程度 | 更新说明                      | 问题现象              | 问题来源 |
| ----- | -------- | ----------------------------- | --------------------- | -------- |
| 1     | 重要     | 修正休眠唤醒后cpu性能下降问题 | 休眠唤醒后cpu跑分下降 | -        |

------

## rk3576_{spl,usbplug}_fspi1_v1.00.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-08 | rk3576_{spl,usbplug}_fspi1_v1.00.bin | 38fed2d628d   | 重要     |

### New

1. 支持fspi1 spiflash支持。

------

## rk3576_spl_v1.01.bin

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-04-07 | rk3576_spl_v1.01.bin | 4a69562ca69   | 重要     |

### New

1. 支持sd卡功能。
2. 支持secureboot功能。
3. 默认使用crypto加速系统启动。
4. 完善ufs支持。
5. 完善vop2支持。
6. 增加mcu相关寄存器配置。

------

## rk3576_bl31_v1.02.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-03-29 | rk3576_bl31_v1.02.elf | 5784c4ac0   | 重要     |

### New

1. 支持HDCP功能。
2. 使能GPU counter。

------

## rk3576_ddr_lp4_2112MHz_lp5_2376MHz_v1.02.bin

| 时间       | 文件                                         | 编译 commit | 重要程度 |
| ---------- | :------------------------------------------- | ----------- | -------- |
| 2024-03-22 | rk3576_ddr_lp4_2112MHz_lp5_2376MHz_v1.02.bin | 2e0089635a3 |  重要    |

### Fixed

| Index | 重要程度 | 更新说明                             | 问题现象                                                            | 问题来源 |
| ----- | -------- | ------------------------------------ | ------------------------------------------------------------------- | -------- |
| 1     | 重要     | 修正DDR负载重的时候VOP会闪屏的问题。 | 当DDR负载重、或DDR频率低，尤其GPU和RKNN重负载时，屏幕会闪得厉害。   | -        |

------

## rk3576_bl31_v1.01.elf

| 时间       | 文件                  | 编译 commit | 重要程度 |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-03-21 | rk3576_bl31_v1.01.elf | c87ba612c   | 重要     |

### New

1. 支持uboot休眠唤醒。
2. 支持假关机。
3. 支持唤醒时间恢复。

------

## rk3576_{ddr,spl,usbplug}_v1.00.bin

| 时间       | 文件                               | 编译 commit                                    | 重要程度 |
| ---------- | :--------------------------------- | ---------------------------------------------- | -------- |
| 2024-03-15 | rk3576_{ddr,spl,usbplug}_v1.00.bin | ddr:563d6071c0#spl:0aca89f21:usbplug:0aca89f21 | 普通     |

### New

1. 初始版本。

------

## rk3576_{bl31, bl32}_v1.00.bin

| 时间       | 文件                          | 编译 commit                   | 重要程度 |
| ---------- | :---------------------------- | ----------------------------- | -------- |
| 2024-03-15 | rk3576_{bl31, bl32}_v1.00.bin | bl31:a83ab541f#bl32:68cdaabd4 | 普通     |

### New

1. 初始版本。

------

