# RK3568 Release Note

## rk3568_bl31_rt_v1.03.elf

| Date       | File                     | Build commit | Severity  |
| ---------- | ------------------------ | ------------ | --------- |
| 2025-03-05 | rk3568_bl31_rt_v1.03.elf | d6900bc23    | important |

### New

1. Add support ddr ecc poison by dcf.

### Fixed

| Index | Severity  | Update                                                   | Issue description                                            | Issue source |
| ----- | --------- | -------------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Fix LP4, LP4X CA instability problem of multi-CS system. | The instability of DDR data of LP4 and LP4X of multi-CS system leads to system anomaly. | -            |

------

## rk3568_bl31_v1.45.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | --------------------- | ------------ | --------- |
| 2025-03-04 | rk3568_bl31_v1.45.elf | 70d3deb59    | important |

### New

1. Add support ddr ecc poison by dcf.

### Fixed

| Index | Severity  | Update                                                   | Issue description                                            | Issue source |
| ----- | --------- | -------------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Fix LP4, LP4X CA instability problem of multi-CS system. | The instability of DDR data of LP4 and LP4X of multi-CS system leads to system anomaly. | -            |

------

## rk3568_bl32_v2.15.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-10-31 | rk3568_bl32_v2.15.bin | 9f2aca7d1    | important |

### New

1. Add support for fw encrypt key.

### Fixed

| Index | Severity  | Update                                            | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | fixed RSA OAEP MGF1 algorithm                     | TA will report an error when using RSA algorithm OAEP MGF1 padding method | -            |
| 2     | important | fixed condition of whether secure boot is enabled | Under unstable hardware conditions, it may be mistakenly believed that secure boot is enabled | -            |

------

## rk3568_ddr_{1560...1056}MHz_v1.23.bin

| Date       | File                                  | Build commit | Severity  |
| ---------- | ------------------------------------- | ------------ | --------- |
| 2024-09-03 | rk3568_ddr_{1560...1056}MHz_v1.23.bin | 03ea844c5d   | important |

### New

1. Added ddr type detection order configurable through ddrbin tool.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Fixed the issue that DDR4 probabilistic capacity probabilistic detection failed. | DDR4 may have capacity, eccdetection errors.                 | -            |
| 2     | important | Added support for ISSI UniIC LP4/4x.                         | Solve the problem of poor stability caused by weak drive strength of ISSI UniIC LP4/4x. | -            |

------

## rk3568_bl32_v2.14.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-09-02 | rk3568_bl32_v2.14.bin | 6c78a7d8     | important |

### New

1.  Support software TA encryption key, customers can use TA encryption function without burning the key.
2.  Support OTP hardware lock, allowing secure and non secure OTP access simultaneously.
3.  Support lock keyreader access function to enhance security.

------

## rk3568_bl32_v2.13.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-07-09 | rk3568_bl32_v2.13.bin | 7ab599eca    | important |

### New

1.  Other security enhancements.
2.  RPMB change read data to multiple times.
3.  Increase MPI_MEMPOOL_SIZE size.

------

## rk3568_ddr_{1560...1056}MHz_v1.22.bin

| Date       | File                                  | Build commit | Severity  |
| ---------- | ------------------------------------- | ------------ | --------- |
| 2024-06-21 | rk3568_ddr_{1560...1056}MHz_v1.22.bin | f8ac117e9c   | important |

### New

1. The CLK/DQS slew rate supports different values at high and low frequencies.
2. Added DRAM Manufacturer ID printing.
3. DDR4 enable LPASR to reduce DDR4 self-refresh power.

### Fixed

| Index | Severity  | Update                                              | Issue description                                            | Issue source |
| ----- | --------- | --------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Probabilistic training failure issue under DDR4 2cs | Probabilistic read/write training failures under DDR4 2cs introduced in ddrbin v1.21. | -            |
| 2     | important | LP4x 600M or less forced to open 240ohm rx odt      | There are compatibility issues with some chips under low-frequency when rx odt disable, which manifests as 324M instability. | -            |
| 3     | important | Undo vref training below 600MHz                     | The vref training introduced in ddrbin v1.21 may cause unreliable vref trining results at low frequencies | -            |

------

## rk3568_ddr_1560MHz_{D3_LP3,D3_LP4_4x}_eyescan_v1.22.bin

| Date       | File                                                    | Build commit | Severity  |
| ---------- | :------------------------------------------------------ | ------------ | --------- |
| 2024-06-21 | rk3568_ddr_1560MHz_{D3_LP3,D3_LP4_4x}_eyescan_v1.22.bin | f8ac117e9c   | important |

### New

1. Updated 2D eye printing format.
2. Add automatic judgment of eye margin.

------

## rk356x_spl_v1.14.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | :------------------- | ------------ | --------- |
| 2024-05-30 | rk356x_spl_v1.14.bin | 606f72bd97a  | important |

### New

1.  Add support for continuing burning RSA key hash after OTP power down.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the issue that SD card initialization fails under SPL stage. | pinctrl node is disabled under SPL stage. | -            |

------

## rk3568_bl32_v2.12.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-04-16 | rk3568_bl32_v2.12.bin | 185dc3c92    | important |

### New

1.  Optimization parameter check to enhance security.
2.  Support printing TEE memory usage information.
3.  Hardware crypto supports addresses exceeding 4G.
4.  Support printing FWVER information.

------

## rk3568_ddr_{1560...920}MHz_v1.21.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2024-01-20 | rk3568_ddr_{1560...920}MHz_v1.21.bin | 2d653b3476   | important |

### Fixed

| Index | Severity  | Update                                                    | Issue description                                            | Issue source |
| ----- | --------- | --------------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Fixed issue that CA training may be missed during reboot. | CA training may not be done during reboot. CA training results always zero. | -            |

------

## rk3568_ddr_{1560...920}MHz_v1.20.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2024-01-12 | rk3568_ddr_{1560...920}MHz_v1.20.bin | 77170a5e90   | important |

### New

1. The tRFC value can be configured through ddrbin_tools.
1. Add read write vref trining to improve compatibility.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | When DDR ECC is enabled, CPU early access is used to ensure the ECC correctness of the pstore segment memory after restart. | When DDR ECC is enabled, the pstore information is lost after restarting. | -            |
| 2     | important | Update DDR3/LPDDR3 rd/wr training pattern to improve read and write signal margin | Optimize DDR3/LPDDR3 read and write signal margin            | -            |
| 3     | important | Fixed 6GB LPDDR3/4 initialization failure problem            | 6GB LPDDR3/4 panic during DDR initialization                 | -            |
| 4     | important | Enable LPDDR4/4X read odt under780M to implove stability.    | Some LPDDR4/4X particles have poor stability at 780M         | -            |

------

## rk3568_pcie_v2.10.bin

| Date       | File                  | Build commit | Severity |
| ---------- | --------------------- | ------------ | -------- |
| 2023-12-18 | rk3568_pcie_v2.10.bin | 35f57cde3    | moderate |

### New

1. Update the version.

------

## rk3568_pcie_v2.00.bin

| Date       | File                  | Build commit | Severity |
| ---------- | --------------------- | ------------ | -------- |
| 2023-12-06 | rk3568_pcie_v2.00.bin | I3e280b78    | moderate |

### New

1. Fix bar capacity.

------

## rk3568_bl31_rt_v1.02.elf

| Date       | File                     | Build commit | Severity |
| ---------- | ------------------------ | ------------ | -------- |
| 2023-11-02 | rk3568_bl31_rt_v1.02.elf | 30c17915b    | moderate |

### New

1. Support config l3 partition according to atags.

------

## rk3568_pcie_v1.00.bin

| Date       | File                  | Build commit | Severity |
| ---------- | --------------------- | ------------ | -------- |
| 2023-10-07 | rk3568_pcie_v1.00.bin | I01c2c7d7    | moderate |
### New

1. Add bare system executable firmware that supports PCIe EP initialization.

------

## rk3568_ddr_{1560...920}MHz_v1.19.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2023-09-11 | rk3568_ddr_{1560...920}MHz_v1.19.bin | fdeec6f4fc   | important |

### New

1. Support RK3567.
2. RK3568 support LVDS1.

------

## rk3568_bl31_v1.44.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | --------------------- | ------------ | --------- |
| 2023-09-19 | rk3568_bl31_v1.44.elf | 8cea6ab0b    | important |

### New

1. Add support for RK3567 SoC.

------

## rk356x_spl_v1.13.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | :------------------- | ------------ | --------- |
| 2023-09-25 | rk356x_spl_v1.13.bin | e4e124926e   | important |

### New

1.  Print and pass the firmware version number.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the issue that the backup image is not loaded when the SPL load or check u-boot.dtb fails | When u-boot.dtb of the first uboot.img is corrupted, SPL doesn't load the backup image. | -            |

------

## rk3568_bl32_v2.11.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-08-28 | rk3568_bl32_v2.11.bin | b5340fd65    | important |

### New

1.  Pseudo random number seed will be set by default.
2. Supports read and write security flag interfaces.
3. Support check ta encryption key is written.
4. Supports the tokbrick ksn interface.

### Fixed

| Index | Severity  | Update                                               | Issue description                                 | Issue source |
| ----- | --------- | ---------------------------------------------------- | ------------------------------------------------- | ------------ |
| 1     | important | Fixed hardware crypto check supported algorithm list | Error will be reported when using hardware crypto | -            |

------

## rk3568_bl31_cpu3_v1.01.elf

| Date       | File                              | Build commit | Severity |
| ---------- | --------------------------------- | ------------ | -------- |
| 2023-08-04 | rk3568_bl31_cpu3_v1.01.elf | b3d2ce25a    | moderate |

### New

1. Support CPU3 startup based on the latest bl31 code.

------

## rk3568_ddr_{1560...920}MHz_v1.18.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2023-07-17 | rk3568_ddr_{1560...920}MHz_v1.18.bin | f366f69a7d   | important |

### Fixed

| Index | Severity | Update                                           | Issue description                     | Issue source |
| ----- | -------- | ------------------------------------------------ | ------------------------------------- | ------------ |
| 1     | important | Fixed the suspend/resume function crash problem caused by DDR active_ranks configuration error | Suspend/resume function crash | -            |

------

## rk3568_bl31_l3_part_ecc_v1.00.elf

| Date       | File                              | Build commit | Severity |
| ---------- | --------------------------------- | ------------ | -------- |
| 2023-06-20 | rk3568_bl31_l3_part_ecc_v1.00.elf | 6f31c2d8c    | moderate |

### New

1. Add initial version: support L3 cache partition and cache ecc.

------

## rk3568_ddr_{1056...324}MHz_v1.17.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2023-06-20 | rk3568_ddr_{1056...324}MHz_v1.17.bin | 992b933606   | important |

### New

1. Added support for 4rank LPDDR3/LPDDR4/LPDDR4x of different rows.
2. Add DDR ECC poison function support.
3. Enable derate function for LPDDR4/LPDDR4x.
4. Add pstore support when ECC enabled.

------

## rk3568_bl32_v2.10.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-06-07 | rk3568_bl32_v2.10.bin | dcfdd61d0    | important |

### New

1. Support recovery from OTP backup data after critical OTP data reading errors.
2. Added the address parameter security check for crypto_service.
2. Kernel support read secure boot flag and public key hash.
3. Support dynamic shared memory, and the secure and normal world can transfer more larger data.
4. BL32 supports pstore, and the kernel can view print info of BL32 through pstore node.

------

## rk3568_bl31_v1.43.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | --------------------- | ------------ | --------- |
| 2023-06-05 | rk3568_bl31_v1.43.elf | bf602aff1    | important |

### Fixed

| Index | Severity  | Update                                           | Issue description                     | Issue source |
| ----- | --------  | ------------------------------------------------ | ------------------------------------- | ------------ |
| 1     | important | Fix deadlock for cpuidle when enter bl31  | The system freezes for a while and then return to normal | -   |

------

## rk3568_bl31_rt_v1.01.elf

| Date       | File                     | Build commit | Severity |
| ---------- | ------------------------ | ------------ | -------- |
| 2023-05-11 | rk3568_bl31_rt_v1.01.elf | b28ca126a    | moderate |

### New

1. Support adjust pvtpll config by OTP.
2. Adjust default pvtpll config for stability.

------

## rk3568_bl31_v1.42.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | --------------------- | ------------ | --------- |
| 2023-05-11 | rk3568_bl31_v1.42.elf | 7f859117f    | important |

### New

1. Support adjust pvtpll config by OTP.
2. Adjust default pvtpll config for stability.

------

## rk3568_bl31_v1.41.elf

| Date       | File                  | Build commit | Severity |
| ---------- | --------------------- | ------------ | -------- |
| 2023-05-06 | rk3568_bl31_v1.41.elf | e24c3f77b    | moderate |

### Fixed

| Index | Severity | Update                                           | Issue description                     | Issue source |
| ----- | -------- | ------------------------------------------------ | ------------------------------------- | ------------ |
| 1     | moderate | Change smc_handler ID of DDR ECC poison function | The DDR ECC poison function exception | -            |

------

## rk3568_bl31_rt_v1.00.elf

| Date       | File                     | Build commit | Severity |
| ---------- | ------------------------ | ------------ | -------- |
| 2023-05-04 | rk3568_bl31_rt_v1.00.elf | c3f2c8c3a    | moderate |

### New

1. Optimize RT Latency.

------

## rk3568_ddr_1560MHz_eyescan_v1.16.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | :----------------------------------- | ------------ | --------- |
| 2023-04-19 | rk3568_ddr_1560MHz_eyescan_v1.16.bin | b9c108a4eb   | important |

### New

1. Add RK3568 2D eye scan support.

------

## rk3568_bl31_v1.40.elf

| Date       | File                  | Build commit | Severity |
| ---------- | --------------------- | ------------ | -------- |
| 2023-04-19 | rk3568_bl31_v1.40.elf | aef7950e4    | moderate |

### New

1. Add DDR ECC poison support.

------

## rk356x_usbplug_v1.17.bin

| Date       | File                     | Build commit | Severity |
| ---------- | :----------------------- | ------------ | -------- |
| 2023-04-14 | rk356x_usbplug_v1.17.bin | 0661d5       | moderate |

### New

1. Support more spiflash.

------

## rk3568_bl31_v1.39.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | --------------------- | ------------ | --------- |
| 2023-04-13 | rk3568_bl31_v1.39.elf | 0d745c7b1    | important |

### New

1. Improve the stability of otp.

------

## rk3568_ddr_{1056...324}MHz_v1.16.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2023-02-26 | rk3568_ddr_{1056...324}MHz_v1.16.bin | 6f71c736ce   | important |

### New

1. RK3568J/RK3568M use 1/2tREFI except LPDDR4/LPDDR4x. LPDDR4/LPDDR4x use derate mode.
2. TREFI, pageclose configurable by ddrbin tool.
3. Improve DDR4 performance.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | To solve the instability problem of some ddr4 when DDR run in 528MHz. | When DDR4 run in 528MHz, the system would unstable, causing a crash and restart | -            |
| 2     | important | To solve 4GB ECC board Init fail bug                         | 4GB DDR4 board may crash in ddrbin                           |              |

------

## rk3568_bl31_v1.38.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | --------------------- | ------------ | --------- |
| 2023-02-16 | rk3568_bl31_v1.38.elf | 94b2d40dc    | important |

### New

1. Improve the stability of sdei.

------

## rk3568_bl31_v1.37.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | --------------------- | ------------ | --------- |
| 2023-02-02 | rk3568_bl31_v1.37.elf | 1cd72fefa    | important |

### New

1. Enable sdei.
2. Support config l3 partition according to atags.

------

## rk3568_ddr_{1560...324}MHz_v1.15.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2022-11-08 | rk3568_ddr_{1560...324}MHz_v1.15.bin | ec2fae0c96   | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | To solve the instability problem of some chips when DDR run in 324MHz. | When DDR run in 324MHz, the system would unstable, causing a crash and restart | -            |

------

## rk3568_bl31_v1.36.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | --------------------- | ------------ | --------- |
| 2022-11-08 | rk3568_bl31_v1.36.elf | 2c8be93f9    | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | To solve the instability problem of some chips when DDR run in 324MHz. | When DDR run in 324MHz, the system would unstable, causing a crash and restart | -            |

------

## rk356x_usbplug_v1.16.bin

| Date       | File                     | Build commit | Severity |
| ---------- | :----------------------- | ------------ | -------- |
| 2022-11-02 | rk356x_usbplug_v1.16.bin | eaaeb1       | moderate |

### New

1. Support more spiflash.

------

## rk3568_bl31_v1.35.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-10-24 | rk3568_bl31_v1.35.elf | cddd6f52e    | important |

### Fixed

| Index | Severity  | Update                                                    | Issue description                                            | Issue source |
| ----- | --------- | --------------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | fix the suspend/resume stability problem, the PCIE suspend fail. | Linux kernel doesn't save/restore GICR, so we need do it if vdd_logic is off in suspend. | -         |

------

## rk356{x_usbplug, 8_miniloader_spinand}_v1.15.bin

| Date       | File                                             | Build commit | Severity |
| ---------- | :----------------------------------------------- | ------------ | -------- |
| 2022-09-26 | rk356{x_usbplug, 8_miniloader_spinand}_v1.15.bin | 65048d1      | moderate |

### New

1. Support more spiflash.

------

## rk3568_bl32_v2.09.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-09-16 | rk3568_bl32_v2.09.bin | d84087907    | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the problem that OPTEE is stuck during startup when printing is closed | User use /rkbin/tools/ddrbin_tool to close printing ,  then rk_atags will notify OPTEE to disable printing, When OPTEE starts, it will be stuck and unable to enter U-Boot | -            |

------

## rk3568_ddr_{1560...324}MHz_v1.14.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | :----------------------------------- | ------------ | --------- |
| 2022-08-27 | rk3568_ddr_{1560...324}MHz_v1.14.bin | b1f29a2a6f   | important |

### Fixed

| Index | Severity  | Update                                                    | Issue description                                            | Issue source |
| ----- | --------- | --------------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | fix some LPDDR4 stability problem                         | CXMT CXDB5CCAM-MK instability for 1560MHz at LPDDR4 mode. Fix this issue by set CLK/CA slew rate from 0xf  to 0x0 . | -         |
| 2     | moderate  | fix Fix set of t_xs_x32, t_xs_abort_x32 and t_xs_fast_x32 | Fix set of t_xs_x32, t_xs_abort_x32 and t_xs_fast_x32.This bug may lead to some low density dram(128M) fail. | -         |
| 3     | important | fix ddr4 528M stability problem                           | some DRAM DLL can't lock at 528M，DLL should be bypass for 528M | -         |
|       | important | fix ddr4 1560M stability problem                          | some 2 rank DDR4 PCB DQS/DQ slew rate should be set to 0x0 when running at1560MHz. | -         |

------
