# RK3562 Release Note

## rk3562_bl31_v1.22.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-03-24 | rk3562_bl31_v1.22.elf | 57ff737a9    | important |

### New

1. Enable virtual shutdown function.

------

## rk3562_bl32_v1.08.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-03-14 | rk3562_bl32_v1.08.bin | ec6f4ffed    | important |

### New

1. Add support for Fw Encrypt Key.
2. Add OEM OTP KEY hmac support for user ta.

### Fixed

| Index | Severity  | Update                          | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Increase TEE OS heap size       | Error occurred when multi-threaded program called to generate key | -            |
| 2     | important | Automatic repair of ta_ver.db   | power off may result in ta_ver.db being created but data not being written | -            |
| 3     | important | Merge official security patches | Address potential security risks                             | -            |

------

## rk3562_spl_v1.07.bin

| Date       | File                 | Build commit | Severity |
| ---------- | :------------------- | ----------- | -------- |
| 2025-01-08 | rk3562_spl_v1.07.bin | 3aa32998d6d  | important |

### New

1. SPL supports dynamically booting either 32-bit or 64-bit U-Boot.

------

## rk3562_ddr_{1560...324}MHz_v1.07.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | :----------------------------------- | ------------ | --------- |
| 2024-11-14 | rk3562_ddr_{1560...324}MHz_v1.07.bin | 6e9ae14bbb   | important |

### New

1. Added ddr type detection order configurable through ddrbin tool.

### Fixed

| Index | Severity  | Update                                                       | Issue description                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | -------------------------------------------- | ------------ |
| 1     | important | Fixed the issue that DDR4 probabilistic capacity detection failed. | DDR4 may have capacity, eccdetection errors. | -            |

------

## rk3562_bl32_v1.07.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-10-31 | rk3562_bl32_v1.07.bin | 9f2aca7d1    | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | check whether the rpmb key has been burned before changing security level | upgrading from weak security level to strong security level may result in rpmb key verification failure | -            |
| 2     | important | fixed RSA OAEP MGF1 algorithm                                | TA will report an error when using RSA algorithm OAEP MGF1 padding method | -            |
| 3     | important | fixed condition of whether secure boot is enabled            | Under unstable hardware conditions, it may be mistakenly believed that secure boot is enabled | -            |

------

## rk3562_bl31_v1.21.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-10-15 | rk3562_bl31_v1.21.elf | b115137cb    | important |

### New

1. Disable version judgment.

------

## rk3562_bl32_v1.06.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-09-02 | rk3562_bl32_v1.06.bin | 6c78a7d8c    | important |

### New

1.  Support toybrick ksn interface.
2.  Support software TA encryption key, customers can use TA encryption function without burning the key.
3.  Support OTP hardware lock, allowing secure and non secure OTP access simultaneously.
4.  Support lock keyreader access function to enhance security.

------

## rk3562_ddr_1056MHz_ultra_v1.06.bin

| Date       | File                               | Build commit | Severity  |
| ---------- | :--------------------------------- | ------------ | --------- |
| 2024-08-13 | rk3562_ddr_1056MHz_ultra_v1.06.bin | 33ea841185   | important |

### New

1. Add DDR4 support.

------

## rk3562_bl32_v1.05.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-07-09 | rk3562_bl32_v1.05.bin | 7ab599eca    | important |

### New

1.  Other security enhancements.
2.  RPMB change read data to multiple times.
3.  Increase MPI_MEMPOOL_SIZE size.

------

## rk3562_ddr_1332MHz_{D3_LP3,D3_LP4_4x}_eyescan_v1.06.bin

| Date       | File                                                    | Build commit | Severity  |
| ---------- | :------------------------------------------------------ | ------------ | --------- |
| 2024-06-21 | rk3562_ddr_1332MHz_{D3_LP3,D3_LP4_4x}_eyescan_v1.06.bin | a2efbe6ac4   | important |

### New

1. Updated 2D eye printing format.
2. Add automatic judgment of eye margin.

------

## rk3562_ddr_{1560...324}MHz_v1.06.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | :----------------------------------- | ------------ | --------- |
| 2024-06-21 | rk3562_ddr_{1560...324}MHz_v1.06.bin | a2efbe6ac4   | important |

### New

1. The CLK/DQS slew rate supports different values at high and low frequencies.
2. Added DRAM Manufacturer ID printing.
3. DDR4 enable LPASR to reduce DDR4 self-refresh power.

### Fixed

| Index | Severity  | Update                                              | Issue description                                            | Issue source |
| ----- | --------- | --------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Probabilistic training failure issue under DDR4 2cs | Probabilistic read/write training failures under DDR4 2cs introduced in ddrbin v1.05. | -            |
| 2     | important | Undo vref training below 600MHz                     | The vref training introduced in ddrbin v1.05 may cause unreliable vref trining results at low frequencies | -            |

------

## rk3562_bl31_v1.20.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-05-15 | rk3562_bl31_v1.20.elf | a2ba6bc7c    | important |

### New

1. Support ARMOFF suspend mode.
2. OTPC_NS can access OTP.

------

## rk3562_bl32_v1.04.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-05-13 | rk3562_bl32_v1.04.bin | 4032c1011    | important |

### New

1.  Add a secure timer to dynamically check the CPU which running in TEE OS, Interrupt is generated, It causing the CPU to return to the kernel.

------

## rk3562_bl32_v1.03.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-04-16 | rk3562_bl32_v1.03.bin | 185dc3c92    | important |

### New

1.  Optimization parameter check to enhance security.
2.  Support printing TEE memory usage information.
3.  Hardware crypto supports addresses exceeding 4G.
4.  Support printing FWVER information.

------

## rk3562_ddr_{1560...324}MHz_v1.05.bin

| Date       | File                            | Build commit                              | Severity  |
| ---------- | :-------------------------------- | ---------------------------------------------- | -------- |
| 2024-01-22 | rk3562_ddr_{1560...324}MHz_v1.05.bin | 93e4a1020c | important |

### New

1. Add read/write vref trining to improve stability and compatibility.

### Fixed

| Index | Severity  | Update                                                    | Issue description                          | Issue source |
| ----- | --------- | --------------------------------------------------------- | ------------------------------------------ | ------------ |
| 1     | important | Enable LPDDR4/4X read odt under780M to implove stability. | Some LPDDR4/4X have poor stability at 780M | -            |

------

## rk3562_spl_v1.06.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | :------------------- | ------------ | --------- |
| 2023-10-23 | rk3562_spl_v1.06.bin | 9db02423188  | important |

### Fixed

| Index | Severity  | Update                                  | Issue description                                            | Issue source |
| ----- | --------- | --------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Fix PCIE causes VOP splash screen issue | PCIe read DDR + VOP + other master have higher priority than VOP, will cause VOP POST_BUF_EMPTY, decrease PCIe shaping can fix it. | -            |

------

## rk3562_spl_v1.05.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | :------------------- | ------------ | --------- |
| 2023-09-25 | rk3562_spl_v1.05.bin | e4e124926e   | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the problem of destroying the last valid tag during SPL modifying the last tag | When SPL overwrites the last valid tag, will destroy it instead of adding a new tag. | -            |

------

## rk3562_spl_v1.04.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | :------------------- | ------------ | --------- |
| 2023-09-19 | rk3562_spl_v1.04.bin | ed86ec4f7    | important |

### New

1. Support for A/B systems.
2. Print and pass the firmware version number.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the issue that the backup image is not loaded when the SPL load or check u-boot.dtb fails | When u-boot.dtb of the first uboot.img is corrupted, SPL doesn't load the backup image. | -            |

------

## rk3562_bl32_v1.02.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-08-29 | rk3562_bl32_v1.02.bin | b5340fd65    | important |

### New

1.  support oem otp key hardware read lock.
2.  Pseudo random number seed will be set by default.
3.  Supports read and write security flag interfaces.
4.  Support check ta encryption key is written.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                 | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------- | ------------ |
| 1     | important | Fixed hardware crypto probability crash issue after enabling dynamic memory | Error will be reported when using hardware crypto | -            |

------

## rk3562_bl31_v1.19.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-08-24 | rk3562_bl31_v1.19.elf | 763689fe5    | important |

### New

1. Support amp boot.

------

## rk3562_bl31_v1.18.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-08-11 | rk3562_bl31_v1.18.elf | 39c4e2a0e    | important |

### New

1. Disable the gpio debounce.
2. Saver/restore the PMIC in the suspend/resume.
3. Saver/restore the pwm in the suspend/resume.

------

## rk3562_ddr_1056MHz_ultra_v1.05.bin

| Date       | File                               | Build commit | Severity  |
| ---------- | :--------------------------------- | ------------ | --------- |
| 2023-05-29 | rk3562_ddr_1056MHz_ultra_v1.05.bin | 229cf1e07c   | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the problem of failure to wake up caused by DDR data error | During suspend, the data error caused the failure to wake up, and it needs to be powered off and restarted. | -            |

------

## rk3562_bl31_v1.17.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-05-26 | rk3562_bl31_v1.17.elf | a394bf0a3    | important |

### New

1. Add the hash calculation for ultra suspend mode.
2. Save/restore the pmic register in the ultra suspend mode.
3. Add interface to config the MCU.
4. Update dcf code to v1.02.

------

## rk3562_bl31_v1.16.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-05-16 | rk3562_bl31_v1.16.elf | 9152290e3    | important |

### New

1. Add soc version init.

------

## rk3562_bl31_v1.15.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-04-27 | rk3562_bl31_v1.15.elf | 904af256f    | important |

### New

1. Adjust pvtpll config for cpu/gpu/npu by the test results of correlation chips.

------

## rk3562_ddr_1332MHz_eyescan_v1.04.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | :----------------------------------- | ------------ | --------- |
| 2023-04-19 | rk3562_ddr_1332MHz_eyescan_v1.04.bin | b9c108a4eb   | important |

### New

1. Add RK3562 2D eye scan support.

------

## rk3562_ddr_1056MHz_ultra_v1.04.bin

| Date       | File                               | Build commit | Severity  |
| ---------- | :--------------------------------- | ------------ | --------- |
| 2023-04-14 | rk3562_ddr_1056MHz_ultra_v1.04.bin | 6227d5cf9e   | important |

### New

1. Add RK3562 ULTRA support.

------

## rk3562_bl31_v1.14.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-04-13 | rk3562_bl31_v1.14.elf | 2041b9655    | important |

### New

1. Support suspend mode config.

------

## rk3562_usbplug_v1.04.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :----------------------- | ---------- | -------- |
| 2023-04-13 | rk3562_usbplug_v1.04.bin | 0cccf6fec  | important |

### Fixed

| Index | Severity  | Update                 | Issue description                  | Issue source |
| ----- | --------- | ---------------------- | ------------------------ | ------------ |
| 1     | important | Fix sometime reboot fail.        | Reboot fail from loader enter.     | -            |

------

## rk3562_bl32_v1.01.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-04-12 | rk3562_bl32_v1.01.bin | c73fd5531    | important |

### New

1. Added crypto/trng/keylad module support.

### Fixed

| Index | Severity  | Update                                                       | Issue description                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | -------------------------------------------- | ------------ |
| 1     | important | Repair the CtsDevicePolicyManagerTestCases test failure problem | CtsDevicePolicyManagerTestCases test failure | 406081       |

------

## rk3562_bl31_v1.13.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-04-10 | rk3562_bl31_v1.13.elf | 69ae6e698    | important |

### New

1. Add opteed sys ctrl support.
2. Don't change unsecure crypto clocks.

------

## rk3562_bl31_v1.12.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-03-15 | rk3562_bl31_v1.12.elf | 3376a679b    | important |

### New

1. Implement autocs suspend and resume.
2. Update dcf code to v1.01.

------

## rk3562_bl31_v1.11.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-03-10 | rk3562_bl31_v1.11.elf | 75d01ff66    | important |

### New

1. Improve suspend/resume stability.

------

## rk3562_bl31_v1.10.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-03-10 | rk3562_bl31_v1.10.elf | 8db141d32    | important |

### New

1. Add autocs support for core.
2. Improve rkrng output.

------

## rk3562_usbplug_v1.03.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :----------------------- | ----------- | -------- |
| 2023-03-09 | rk3562_usbplug_v1.03.bin | a2a8c6bbac | important |

### New

1. First release version.

------

## rk3562_bl31_v1.09.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-03-08 | rk3562_bl31_v1.09.elf | 6a1e56879    | important |

### New

1. Add support to change pvtpll length according to otp and opp flag .

------

## rk3562_spl_v1.03.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ----------- | -------- |
| 2023-03-06 | rk3562_spl_v1.03.bin | 7ff748e19 | important     |

### New

1. First release version.

------

## rk3562_bl31_v1.08.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-02-27 | rk3562_bl31_v1.08.elf | 1f6088dc0    | important |

### New

1. Change clock to normal pll when supend and reset.

------

## rk3562_bl31_v1.07.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-02-22 | rk3562_bl31_v1.07.elf | 4d4f21db2    | important |

### New

1. Support vdd_logic off in the system suspend.

------

## rk3562_ddr_{1560...324}MHz_v1.04.bin

| Date       | File                            | Build commit                              | Severity  |
| ---------- | :-------------------------------- | ---------------------------------------------- | -------- |
| 2023-02-14 | rk3562_ddr_{1560...324}MHz_v1.04.bin | bae1baa081 | important |

### Fixed

| Index | Severity  | Update                                  | Issue description                                            | Issue source |
| ----- | --------- | --------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | moderate  | fix bug of uart print can't be disabled | uart print can't be disabled by ddrbin_tool                  | -            |
| 2     | important | update OS_REG rules                     | OS_REG0 may reset by reboot with NPOR, It lead to reboot maskrom failure. Use OS_REG8 replace OS_REG0 to fix this bug. | -            |

------

## rk3562_bl31_v1.06.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-02-09 | rk3562_bl31_v1.06.elf | de0f55c9c    | important |

### New

1. Add crypto rng and klad clocks support.
2. Adjust pvtpll table for npu 800MHz and 900MHz.
3. Add dmc code.

------

## rk3562_{ddr,spl,usbplug}_v1.x.bin

| Date       | File                            | Build commit                              | Severity  |
| ---------- | :-------------------------------- | ---------------------------------------------- | -------- |
| 2023-02-03 | rk3562_{ddr,spl,usbplug}_v1.x.bin | ddr:4d38eafc48#spl:ec5f0a7c43#usbplug:3ed34f88 | important |

### New

1. Initial version.

------

## rk3562_{bl31,bl32,mcu}_v1.x.bin

| Date       | File                            | Build commit                              | Severity  |
| ---------- | :------------------------------ | -------------------------------- | -------- |
| 2023-02-03 | rk3562_{bl31,bl32,mcu}_v1.x.bin | bl31:none#bl32:512740e0#mcu:none | important |

### New

1. Initial version.

------

