# RK3528 Release Note

## rk3528_bl31_v1.20.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-04-01 | rk3528_bl31_v1.20.elf | fe961b77f | important |

### New

1. Support system suspend for rk3518.

------

## rk3528_bl31_v1.19.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-03-11 | rk3528_bl31_v1.19.elf | b5fa023c7 | important |

### New

1. Support rk3518.

------

## rk3528_usbplug_v1.04.bin

| Date       | File                    | Build commit | Severity  |
| ---------- | :---------------------- | ------------ | --------- |
| 2025-03-10 | rk3528_usbplug_v1.04.bin | 94a761cda    | important |

### New

1. Support RK3518.

------

## rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.11.bin

| Date       | File                                           | Build commit | Severity |
| ---------- | ---------------------------------------------- | ------------ | -------- |
| 2025-02-26 | rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.11.bin | 56f70fd2ad   | moderate |

### New

1. Add trfc min cap mode.

------

## rk3528_spl_v1.06.bin

| Date       | File                 | Build commit | Severity |
| ---------- | :------------------- | ----------- | -------- |
| 2025-01-08 | rk3528_spl_v1.06.bin | 3aa32998d6d  | important |

### New

1. SPL supports dynamically booting either 32-bit or 64-bit U-Boot.

------

## rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB}_eyescan_v1.10.bin

| Date       | File                                                   | Build commit | Severity |
| ---------- | ------------------------------------------------------ | ------------ | -------- |
| 2024-12-31 | rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB}_eyescan_v1.10.bin | ce4c2119c2   | moderate |

### New

1. Add RK3528 2D eye scan support.

------

## rk3528_bl31_v1.18.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-11-18 | rk3528_bl31_v1.18.elf | 059b3c586    | important |

### New

1. Support GX3501.
2. Dump wakeup source after virtual-poweroff.

------

## rk3528_bl32_v1.06.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-10-31 | rk3528_bl32_v1.06.bin | 9f2aca7d1    | important |

### New

1.  Add support for esck key.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | check whether the rpmb key has been burned before changing security level | upgrading from weak security level to strong security level may result in rpmb key verification failure | -            |
| 2     | important | fixed RSA OAEP MGF1 algorithm                                | TA will report an error when using RSA algorithm OAEP MGF1 padding method | -            |
| 3     | important | fixed condition of whether secure boot is enabled            | Under unstable hardware conditions, it may be mistakenly believed that secure boot is enabled | -            |

------

## rk3528_bl32_v1.05.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-09-02 | rk3528_bl32_v1.05.bin | 6c78a7d8     | important |

### New

1.  Support software TA encryption key, customers can use TA encryption function without burning the key.
2.  Support OTP hardware lock, allowing secure and non secure OTP access simultaneously.
3.  RPMB change read data to multiple times.
4.  Increase MPI_MEMPOOL_SIZE size.

------

## rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.10.bin

| Date       | File                                           | Build commit | Severity |
| ---------- | ---------------------------------------------- | ------------ | -------- |
| 2024-07-12 | rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.10.bin | 44ec2e0a51   | moderate |

### New

1. Add Manufacturer ID print.
2. Disable vref training below 600MHz.
3. Enable LPASR for DDR4.

------

## rk3528_bl32_v1.04.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-04-16 | rk3528_bl32_v1.04.bin | 185dc3c92    | important |

### New

1.  Optimization parameter check to enhance security.
2.  Support printing TEE memory usage information.
3.  Hardware crypto supports addresses exceeding 4G.
4.  Support printing FWVER information.

------

## rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.09.bin

| Date       | File                                           | Build commit | Severity  |
| ---------- | ---------------------------------------------- | ------------ | --------- |
| 2024-01-30 | rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.09.bin | 665f3e4817   | important |

### New

1. Support lp3 dram odt auto detect.
2. Support vref training.

### Fixed

| Index | Severity  | Update                           | Issue description                                      | Issue source |
| ----- | --------- | -------------------------------- | ------------------------------------------------------ | ------------ |
| 1     | important | Fix CL err for byte mode lp4 in training. | It will error in training when used byte mode lp4.    | -            |
| 2     | important | Fix lp4/lp4x 4L pcb config wrong.  | The signal of lp4/lp4x use 4L pcb is not in the best. | -            |

------

## rk3528_bl31_v1.17.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-12-21 | rk3528_bl31_v1.17.elf | eda1f5ce4    | important |

### Fixed

| Index | Severity  | Update                               | Issue description                                 | Issue source |
| ----- | --------- | ------------------------------------ | ------------------------------------------------- | ------------ |
| 1     | important | Fix cpu stall when video play back   | cpu will randomly stall when video playback       | -            |

------

## rk3528_spl_v1.05.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | -------------------- | ------------ | --------- |
| 2023-09-25 | rk3528_spl_v1.05.bin | e4e124926e   | important |

### New

1. Print and pass the firmware version number.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the issue that the backup image is not loaded when the SPL load or check u-boot.dtb fails | When u-boot.dtb of the first uboot.img is corrupted, SPL doesn't load the backup image. | -            |

------

## rk3528_bl32_v1.03.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-08-29 | rk3528_bl32_v1.03.bin | b5340fd65    | important |

### New

1.  support oem otp key hardware read lock.
2.  Pseudo random number seed will be set by default.
3.  Supports read and write security flag interfaces.
4.  Support check ta encryption key is written.
5.  Support oem hdcp key.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                 | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------- | ------------ |
| 1     | important | Fixed hardware crypto probability crash issue after enabling dynamic memory | Error will be reported when using hardware crypto | -            |

------

## rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.07.bin

| Date       | File                                           | Build commit | Severity  |
| ---------- | ---------------------------------------------- | ------------ | --------- |
| 2023-08-04 | rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.07.bin | 4fe5906c9d   | important |

### New

1. Support lp4/lp4x derate.
2. Support modified CA de-skew by ddrbin_tool.

### Fixed

| Index | Severity  | Update                           | Issue description                                      | Issue source |
| ----- | --------- | -------------------------------- | ------------------------------------------------------ | ------------ |
| 1     | important | Fix per-bank-refresh enable bug. | Abnormal in OUT print when enable per-bank-refresh.    | -            |
| 2     | important | Fix pageclose bug.               | The system error in dmc driver after enable pageclose. | -            |

------

## rk3528_bl31_v1.16.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-07-21 | rk3528_bl31_v1.16.elf | 7bfd76051    | important |

### New

1. Fix deadlock for soc monitor.

------

## rk3528_bl31_v1.15.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-07-17 | rk3528_bl31_v1.15.elf | d8ae91904    | important |

### New

1. Add support for rk3528A.

------

## rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.06.bin

| Date       | File                                           | Build commit | Severity  |
| ---------- | ---------------------------------------------- | ------------ | --------- |
| 2023-06-05 | rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.06.bin | 1ab0bfbe2d   | important |

### New

1. Support modified CA de-skew by ddrbin_tool.

------

## rk3528_bl31_v1.14.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-05-19 | rk3528_bl31_v1.14.elf | 1b2124ab7    | important |

### New

1. Move  BL31 base to 0x80000.
2. Support ddr frequency scale.

------

## rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.05.bin

| Date       | File                                           | Build commit | Severity  |
| ---------- | ---------------------------------------------- | ------------ | --------- |
| 2023-04-14 | rk3528_ddr_1056MHz_{2L_PCB,4BIT_PCB_}v1.05.bin | 2eef4a672d   | important |

### New

1. Add new ddrbin  for 4BIT PCB configurations.
2. Add the configuration of LP3 CA skew.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Fix the phase problem of DDR3 RAS in 2T mode.                | Abnormal RAS phase in DDR3 2T mode.                          | -            |
| 2     | important | Fixed the abnormal ODT output problem in LP3 training under multi-rank. | The ODT output is abnormal when LP3 does cs1 write training under multi-rank. | -            |

------

## rk3528_bl32_v1.02.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-04-12 | rk3528_bl32_v1.02.bin | c73fd5531    | important |

### New

1. Added crypto/trng/keylad module support.

------

## rk3528_bl31_v1.13.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-04-12 | rk3528_bl31_v1.13.elf | 642369d9b    | important |

### New

1. Modify pvtpll table for cpu and gpu.

------

## rk3528_spl_v1.04.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | :----------------- - | ------------ | --------- |
| 2023-04-11 | rk3528_spl_v1.04.bin | 0fbedd06     | important |

### Fixed

| Index | Severity  | Update                             | Issue description   | Issue source |
| ----- | --------- | ---------------------------------- | ------------------- | ------------ |
| 1     | important | Fix matrix 339M freq set/get error | EMMC transfer error | -            |

------

## rk3528_usbplug_v1.03.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :----------------------- | ---------- | -------- |
| 2023-04-08 | rk3528_usbplug_v1.03.bin | dbdfea79b  | important |

### Fixed

| Index | Severity  | Update                 | Issue description                  | Issue source |
| ----- | --------- | ---------------------- | ------------------------ | ------------ |
| 1     | important | Fix sometime emmc upgrade fail.        | Emmc upgrade fail sometime.     | -            |

------

## rk3528_bl32_v1.01.bin

| Date       | File                  | Build commit | Severity |
| ---------- | :-------------------- | ------------ | -------- |
| 2023-04-03 | rk3528_bl32_v1.01.bin | c5251becc    | moderate |

### New

1. Add some internal TA interface.

------

## rk3528_bl31_v1.12.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-03-16 | rk3528_bl31_v1.12.elf | 70c5c8d9c    | important |

### New

1. Improve trng performance.

------

## rk3528_ddr_1056MHz_{2L_PCB_}v1.04.bin

| Date       | File                                  | Build commit | Severity  |
| ---------- | ------------------------------------- | ------------ | --------- |
| 2023-03-15 | rk3528_ddr_1056MHz_{2L_PCB_}v1.04.bin | dce46ffe73   | important |

### New

1. Add new OTP configurations support.

------

## rk3528_bl31_v1.11.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-03-09 | rk3528_bl31_v1.11.elf | 389e6e47     | important |

### New

1. Modify the ddr configuration flow during system suspend.

------

## rk3528_ddr_1056MHz_{2L_PCB_}v1.03.bin

| Date       | File                                  | Build commit | Severity  |
| ---------- | ------------------------------------- | ------------ | --------- |
| 2023-03-09 | rk3528_ddr_1056MHz_{2L_PCB_}v1.03.bin | f0be8490c4   | important |

### New

1. Add support for chips with different OTP configurations.

### Fixed

| Index | Severity  | Update                                                | Issue description                                            | Issue source |
| ----- | --------- | ----------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Fixed LP3 x16 capacity error problem.                 | The ddr capacity anomalies occur when the phy at lp3 x16 mode. | -            |
| 2     | important | Fixed DDR unstabled when in low frequency(<=400Mhz) . | The kernel will panic when DDR run in low frequency(<=400Mhz). | -            |

------

## rk3528_ddr_1056MHz_{2L_PCB_}v1.02.bin

| Date       | File                                  | Build commit | Severity  |
| ---------- | ------------------------------------- | ------------ | --------- |
| 2023-02-15 | rk3528_ddr_1056MHz_{2L_PCB_}v1.02.bin | 60403d388d   | important |

### New

1. Support config derate refresh, per-bank refresh.
2. Support AXI split.
3. Enable LP4, LP4X read/write DBI function.

### Fixed

| Index | Severity  | Update                                             | Issue description                              | Issue source |
| ----- | --------- | -------------------------------------------------- | ---------------------------------------------- | ------------ |
| 1     | important | Fixed 2L PCB unstabled when DDR in high frequency. | The DDR run in 1056MHz will case system panic. | -            |

------

## rk3528_bl31_v1.10.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-02-15 | rk3528_bl31_v1.10.elf | d74b03e10    | important |

### New

1. Add trng scmi clk support.

------

## rk3528_bl31_v1.09.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-02-03 | rk3528_bl31_v1.09.elf | 16574c7f3    | important |

### New

1. Support all gpio wakeup.
2. Improve the stability of fiq-debugger.

------

## rk3528_bl31_v1.08.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-01-10 | rk3528_bl31_v1.08.elf | 082486b74    | important |

### New

1. Support crypto/crypto_s/klad clock.

------

## rk3528_bl31_v1.07.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-12-26 | rk3528_bl31_v1.07.elf | da191fda0    | important |

### New

1. Support poweroff VDD_LOGIC when system suspend.
2. Hptimer use soft adjust mode.
3. Enable PLAT_RK_OPTEED_SYS_CTRL.

------

## rk3528_spl_v1.03.bin

| Date       | File                 | Build commit | Severity |
| ---------- | :------------------- | ----------- | -------- |
| 2022-12-14 | rk3528_spl_v1.03.bin | f09ed5ff4f  | important|

### Fixed

| Index | Severity  | Update                 | Issue description                  | Issue source |
| ----- | --------- | ---------------------- | ---------------------------------- | ------------ |
| 1     | important | Support HS400ES        | fix HS400 compatibility issues     | -            |
| 2     | important | config EMMC DS to 1.5X | fix some EMMC compatibility issues | -            |

------

## rk3528_bl31_v1.06.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-12-08 | rk3528_bl31_v1.06.elf | 61102ec13    | important |

### New

1. Support USB wakeup.

------

## rk3528_spl_v1.02.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | :------------------- | ------------ | --------- |
| 2022-12-02 | rk3528_spl_v1.02.bin | eee09e1f72   | important |

### Fixed

| Index | Severity  | Update                    | Issue description                                            | Issue source |
| ----- | --------- | ------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Fix matrix clk rate error | clk_200m：396000 KHz、clk_300m：594000 KHz、clk_339m：264000 KHz. It may influence storage module. | -            |

------

## rk3528_bl31_v1.05.elf

| Date       | File                  | Build commit | Severity |
| ---------- | :-------------------- | ------------ | -------- |
| 2022-12-01 | rk3528_bl31_v1.05.elf | b10341386    | moderate |

### New

1. Add TSP clock support.

------

## rk3528_bl31_v1.04.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-11-30 | rk3528_bl31_v1.04.elf | 63ba7e8e1    | important |

### New

1. Support HDMI wakeup.

------

## rk3528_{ddr,spl,usbplug}_v1.x.bin

| Date       | File                              | Build commit                                | Severity  |
| ---------- | :-------------------------------- | ------------------------------------------- | --------- |
| 2022-11-28 | rk3528_{ddr,spl,usbplug}_v1.x.bin | ddr:0799b9b10a#spl:c52427059#usbplug:4eade6 | important |

### New

1. Initial version.

------

## rk3528_{bl31,bl32,mcu}_v1.x.bin

| Date       | File                            | Build commit                              | Severity  |
| ---------- | :------------------------------ | ----------------------------------------- | --------- |
| 2022-11-28 | rk3528_{bl31,bl32,mcu}_v1.x.bin | bl31:a1a47bee6#bl32:3c36a5cb#mcu:76d14059 | important |

### New

1. Initial version.

------

