# RK3308 Release Note

## rk3308_bl31_{aarch32}_v2.27.bin

| Date       | File                            | Build commit | Severity  |
| ---------- | :------------------------------ | ------------ | --------- |
| 2025-05-09 | rk3308_bl31_{aarch32}_v2.27.bin | 1b53efcddbf  | important |

### New

1. Support the module that under pclk_bus to wakeup in system suspend.

------

## rk3308_bl32_v2.09.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-10-31 | rk3308_bl32_v2.09.bin | 9f2aca7d1    | important |

### Fixed

| Index | Severity  | Update                                            | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | fixed RSA OAEP MGF1 algorithm                     | TA will report an error when using RSA algorithm OAEP MGF1 padding method | -            |
| 2     | important | fixed condition of whether secure boot is enabled | Under unstable hardware conditions, it may be mistakenly believed that secure boot is enabled | -            |

------

## rk3308_ddr_{589 ... 393}MHz_{uart2_m1, uart4_m0}_v2.10.bin

| Date       | File                                                       | Build commit | Severity |
| ---------- | ---------------------------------------------------------- | ------------ | -------- |
| 2024-10-23 | rk3308_ddr_{589 ... 393}MHz_{uart2_m1, uart4_m0}_v2.10.bin | da47953620   | moderate |

### Fixed

| Index | Severity | Update                                   | Issue description                                            | Issue source |
| ----- | -------- | ---------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | moderate | Fix the bug in ddr2 bank detect process. | The DDR2 may have the risk of incomplete capacity detection. | -            |

------

## rk3308_ddr_{589 ... 393}MHz_{uart2_m1, uart4_m0}_v2.09.bin

| Date       | File                                                       | Build commit | Severity  |
| ---------- | ---------------------------------------------------------- | ------------ | --------- |
| 2024-09-06 | rk3308_ddr_{589 ... 393}MHz_{uart2_m1, uart4_m0}_v2.09.bin | 286df080e2   | important |

### Fixed

| Index | Severity  | Update                       | Issue description                                            | Issue source |
| ----- | --------- | ---------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Disable auto self refresh    | When auto self refresh is enabled, a small number of RK3308B series chips may freeze with a low probability at certain frequencies. | 491409       |
| 2     | moderate  | Optimize uart printing speed | -                                                            | -            |

------

## rk3308_miniloader_v1.43.bin

| Date       | File                                   | Build commit  | Severity |
| ---------- | :------------------------------------- | ------- | -------- |
| 2024-09-09 | rk3308_miniloader_v1.43.bin | 6c04ae99 | moderate |

### New

1. Restore iomux after SD detect is invalid to avoid UART 2 M1 exception.

------

## rk3308_{miniloader, usbplug}_wo_ftl_v1.43.bin

| Date       | File                                   | Build commit  | Severity |
| ---------- | :------------------------------------- | ------- | -------- |
| 2024-09-09 | rk3308_{miniloader, usbplug}_wo_ftl_v1.43.bin | 6c04ae99 | moderate |

### New

1. Support SPI Nor idblock 2 copies.

------

## rk3308_bl32_v2.08.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-09-02 | rk3308_bl32_v2.08.bin | 6c78a7d8c    | important |

### New

1. Support software TA encryption key, customers can use TA encryption function without burning the key.
2. RPMB change read data to multiple times.
3. Increase MPI_MEMPOOL_SIZE size.

------

## rk3308_miniloader_spinor_v1.43.bin

| Date       | File                                   | Build commit  | Severity |
| ---------- | :------------------------------------- | ------- | -------- |
| 2024-08-19 | rk3308_miniloader_spinor_v1.43.bin | e24e370a | moderate |

### New

1. Add spinor only version.

------

## rk3308_usbplug_v1.43.bin

| Date       | File                                   | Build commit  | Severity |
| ---------- | :------------------------------------- | ------- | -------- |
| 2024-08-16 | rk3308_usbplug_v1.43.bin | e24e370a | moderate |

### New

1. Support SPI Nor idblock 2 copies.

------

## rk3308_{miniloader, usbplug}_v1.42.bin

| Date       | File                                   | Build commit  | Severity |
| ---------- | :------------------------------------- | ------- | -------- |
| 2024-08-02 | rk3308_{miniloader, usbplug}_v1.42.bin | 0494fdae | moderate |

### New

1. Support new SPI flash.

------

## rk3308_bl32_v2.07.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-04-16 | rk3308_bl32_v2.07.bin | 185dc3c92    | important |

### New

1. Optimization parameter check to enhance security.
2. Support printing TEE memory usage information.
3. Hardware crypto supports addresses exceeding 4G.
4. Support printing FWVER information.

------

## rk3308_ddr*{589 ... 393}MHz*{uart2_m1, uart4_m0}_v2.08.bin

| Date       | File                                                       | Build commit | Severity |
| ---------- | ---------------------------------------------------------- | ------------ | -------- |
| 2024-04-09 | rk3308_ddr*{589 ... 393}MHz*{uart2_m1, uart4_m0}_v2.08.bin | 10777823fd   | moderate |

### New

1. Add dram and sram check.

------

## rk3308_{miniloader, usbplug}_wo_ftl_v1.41.bin

| Date       | File                                   | Build commit  | Severity |
| ---------- | :------------------------------------- | ------- | -------- |
| 2024-01-05 | rk3308_{miniloader, usbplug}_wo_ftl_v1.41.bin | f34544a | moderate |

### New

1. Change undefined read data address global variables.

------

## rk3308_bl32_v2.06.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-08-28 | rk3308_bl32_v2.06.bin | b5340fd65    | important |

### New

1. Support pstore for optee log.
2. Enable dynamic SHM.
3. Support check ta encryption key is written.

------

## rk3308_bl31_cpu3_v1.00.elf

| Date       | File                       | Build commit | Severity |
| ---------- | :------------------------- | ------------ | -------- |
| 2023-03-16 | rk3308_bl31_cpu3_v1.00.elf | 5fb7b7229    | moderate |

### New

1. Support boot from CPU3.

------

## rk3308_ddr_{589 ... 393}MHz_{uart2_m1, uart4_m0}_v2.07.bin

| Date       | File                                                       | Build commit | Severity |
| ---------- | :--------------------------------------------------------- | ------------ | -------- |
| 2022-11-29 | rk3308_ddr_{589 ... 393}MHz_{uart2_m1, uart4_m0}_v2.07.bin | 6ede97a868   | moderate |

### Fixed

| Index | Severity | Update                                                   | Issue description                                            | Issue source |
| ----- | -------- | -------------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | moderate | Improve the stability of some DDR in RK3308B/H at 393MHz | When RK3308B/H is less than 451MHz, the value of read DQS DLL delay is inaccurately configured. As a result, some DDR may be unstable at 393MHz. | -            |

------

## rk3308_bl31_{aarch32}_v2.26.elf

| Date       | File                            | Build commit | Severity  |
| ---------- | :------------------------------ | ------------ | --------- |
| 2022-09-28 | rk3308_bl31_{aarch32}_v2.26.elf | 0252d5c8f    | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the wdt reset while system suspend.  Handle solution: bl31 disables pclk_wdt before sleep and resume it after wakeup. | The kernel can't disable secure pclk_wdt,  it results in wdt reset. | 375529       |

------

## rk3308_bl32_v2.05.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-09-16 | rk3308_bl32_v2.05.bin | d84087907    | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the problem that OPTEE is stuck during startup when printing is closed | User use /rkbin/tools/ddrbin_tool to close printing ,  then rk_atags will notify OPTEE to disable printing, When OPTEE starts, it will be stuck and unable to enter U-Boot | -            |

------

## rk3308_{miniloader, usbplug}_v1.39.bin

| Date       | File                                   | Build commit  | Severity |
| ---------- | :------------------------------------- | ------- | -------- |
| 2022-09-08 | rk3308_{miniloader, usbplug}_v1.39.bin | 97d7a6 | moderate |

### New

1. Check ftl super block 2nd page spare data.
