/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoDataSource;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoPoolManager;
import virtuoso.jdbc4.VirtuosoPoolStatistic;
import virtuoso.jdbc4.VirtuosoPooledConnection;

public class VirtuosoConnectionPoolDataSource
extends VirtuosoDataSource
implements ConnectionPoolDataSource,
ConnectionEventListener {
    protected static final String n_initialPoolSize = "initialPoolSize";
    protected static final String n_minPoolSize = "minPoolSize";
    protected static final String n_maxPoolSize = "maxPoolSize";
    protected static final String n_maxIdleTime = "maxIdleTime";
    protected static final String n_propertyCycle = "propertyCycle";
    protected static final String n_maxStatements = "maxStatements";
    public int initialPoolSize = 0;
    public volatile int minPoolSize = 0;
    public volatile int maxPoolSize = 0;
    public volatile int maxIdleTime = 0;
    public volatile int propertyCycle = 0;
    public volatile int maxStatements = 0;
    private ConnCache connPool;
    private volatile boolean isInitialized = false;
    private volatile boolean isClosed = false;
    private VirtuosoPoolStatistic stat;
    private Object initLock;
    private TreeSet<Object> propQueue;
    private long propEnforceTime = 0L;

    public VirtuosoConnectionPoolDataSource() {
        this.dataSourceName = "VirtuosoConnectionPoolDataSourceName";
        this.initLock = new Object();
        this.stat = new VirtuosoPoolStatistic();
        this.connPool = new ConnCache(this);
        this.propQueue = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                long a_time = ((NewProperty)a).enforceTime;
                long b_time = ((NewProperty)b).enforceTime;
                if (a_time == b_time) {
                    return 0;
                }
                if (a_time > b_time) {
                    return 1;
                }
                return -1;
            }
        });
    }

    protected void checkPool() {
        if (this.isClosed) {
            return;
        }
        this.connPool.checkPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPropQueue() {
        if (this.isClosed || this.propEnforceTime == 0L) {
            return;
        }
        long curTime = System.currentTimeMillis();
        TreeSet<Object> treeSet = this.propQueue;
        synchronized (treeSet) {
            while (this.propEnforceTime != 0L && this.propEnforceTime < curTime) {
                NewProperty prop;
                try {
                    prop = (NewProperty)this.propQueue.first();
                }
                catch (NoSuchElementException e) {
                    this.propEnforceTime = 0L;
                    break;
                }
                this.propQueue.remove(prop);
                try {
                    prop.fld.setInt(this, prop.arg);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    prop = (NewProperty)this.propQueue.first();
                    this.propEnforceTime = prop.enforceTime;
                }
                catch (NoSuchElementException e) {
                    this.propEnforceTime = 0L;
                    break;
                }
            }
        }
    }

    public synchronized VirtuosoPoolStatistic get_statistics() {
        VirtuosoPoolStatistic v = (VirtuosoPoolStatistic)this.stat.clone();
        v.setCacheParam(this.dataSourceName, this.connPool.cacheSize.get(), this.connPool.unUsed.size(), this.connPool.in_Use.size());
        return v;
    }

    public synchronized VirtuosoPoolStatistic[] getAll_statistics() {
        return VirtuosoPoolManager.getInstance().getAll_statistics();
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.connPool.clear();
        this.initLock = null;
        this.propQueue.clear();
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        try {
            Object source = event.getSource();
            if (source instanceof VirtuosoPooledConnection) {
                this.connPool.reusePooledConnection((VirtuosoPooledConnection)event.getSource());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        try {
            Object source = event.getSource();
            if (source instanceof VirtuosoPooledConnection) {
                this.connPool.closePooledConnection((VirtuosoPooledConnection)event.getSource());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected void addProperties(Reference ref) {
        super.addProperties(ref);
        ref.add(new StringRefAddr(n_minPoolSize, String.valueOf(this.minPoolSize)));
        ref.add(new StringRefAddr(n_maxPoolSize, String.valueOf(this.maxPoolSize)));
        ref.add(new StringRefAddr(n_initialPoolSize, String.valueOf(this.initialPoolSize)));
        ref.add(new StringRefAddr(n_maxIdleTime, String.valueOf(this.maxIdleTime)));
        ref.add(new StringRefAddr(n_propertyCycle, String.valueOf(this.propertyCycle)));
        ref.add(new StringRefAddr(n_maxStatements, String.valueOf(this.maxStatements)));
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "virtuoso.jdbc4.VirtuosoDataSourceFactory", null);
        this.addProperties(ref);
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill() throws SQLException {
        this.check_close();
        Properties info = this.createConnProperties();
        String connKey = this.create_url_key(this.create_url(), info);
        Object object = this.initLock;
        synchronized (object) {
            if (!this.isInitialized) {
                this.isInitialized = true;
                if (this.initialPoolSize == 0) {
                    this.initialPoolSize = this.minPoolSize;
                }
                if (this.initialPoolSize != 0) {
                    OpenHelper initThread = new OpenHelper(this.initialPoolSize, info);
                    initThread.start();
                    try {
                        initThread.join();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                VirtuosoPoolManager.getInstance().addPool(this);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getPooledConnection().getConnection();
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        return this.getPooledConnection(user, password).getConnection();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection(String _user, String _password) throws SQLException {
        this.check_close();
        String conn_url = this.create_url();
        Properties info = this.createConnProperties();
        if (_user != null) {
            info.setProperty("user", _user);
        }
        if (_password != null) {
            info.setProperty("password", _password);
        }
        String connKey = this.create_url_key(conn_url, info);
        Object object = this.initLock;
        synchronized (object) {
            if (!this.isInitialized) {
                this.isInitialized = true;
                if (this.initialPoolSize == 0) {
                    this.initialPoolSize = this.minPoolSize;
                }
                if (this.initialPoolSize != 0) {
                    OpenHelper initThread = new OpenHelper(this.initialPoolSize, info);
                    initThread.start();
                    try {
                        initThread.join();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                VirtuosoPoolManager.getInstance().addPool(this);
            }
        }
        return this.connPool.getPooledConnection(info, connKey, conn_url);
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int parm) throws SQLException {
        try {
            Field fld = this.getClass().getField(n_minPoolSize);
            this.setField(fld, parm);
        }
        catch (Exception e) {
            throw new VirtuosoException("Error: " + e.toString(), 0);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int parm) throws SQLException {
        try {
            Field fld = this.getClass().getField(n_maxPoolSize);
            this.setField(fld, parm);
        }
        catch (Exception e) {
            throw new VirtuosoException("Error: " + e.toString(), 0);
        }
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setInitialPoolSize(int parm) throws SQLException {
        try {
            Field fld = this.getClass().getField(n_initialPoolSize);
            this.setField(fld, parm);
        }
        catch (Exception e) {
            throw new VirtuosoException("Error: " + e.toString(), 0);
        }
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int parm) throws SQLException {
        try {
            Field fld = this.getClass().getField(n_maxIdleTime);
            this.setField(fld, parm);
        }
        catch (Exception e) {
            throw new VirtuosoException("Error: " + e.toString(), 0);
        }
    }

    public int getPropertyCycle() {
        return this.propertyCycle;
    }

    public void setPropertyCycle(int parm) {
        this.propertyCycle = parm;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int parm) throws SQLException {
        try {
            Field fld = this.getClass().getField(n_maxStatements);
            this.setField(fld, parm);
        }
        catch (Exception e) {
            throw new VirtuosoException("Error: " + e.toString(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setField(Field fld, int parm) throws Exception {
        if (this.propertyCycle == 0) {
            fld.setInt(this, parm);
        } else {
            TreeSet<Object> treeSet = this.propQueue;
            synchronized (treeSet) {
                this.propQueue.add(new NewProperty(fld, parm));
                this.propEnforceTime = ((NewProperty)this.propQueue.first()).enforceTime;
            }
        }
    }

    private void check_close() throws SQLException {
        if (this.isClosed) {
            throw new VirtuosoException("ConnectionPoolDataSource is closed", 0);
        }
    }

    private class ConnCache {
        AtomicInteger cacheSize;
        LinkedList<VirtuosoPooledConnection> unUsed;
        ConcurrentHashMap<VirtuosoPooledConnection, VirtuosoPooledConnection> in_Use;
        Object lck_new = new Object();
        private VirtuosoConnectionPoolDataSource cpds;

        private ConnCache(VirtuosoConnectionPoolDataSource _cpds) {
            this.unUsed = new LinkedList();
            this.in_Use = new ConcurrentHashMap(32);
            this.cacheSize = new AtomicInteger(0);
            this.cpds = _cpds;
        }

        public void finalize() throws Throwable {
            this.clear();
        }

        private void tryAddConnection(String conn_url, String connKey, Properties info) {
            block5: {
                VirtuosoConnection conn = null;
                if (this.checkForNewConn()) {
                    try {
                        conn = new VirtuosoConnection(conn_url, "localhost", 1111, info);
                        VirtuosoPooledConnection pconn = new VirtuosoPooledConnection(conn, connKey, this.cpds);
                        VirtuosoConnectionPoolDataSource.this.connPool.addPooledConnection(pconn, true);
                    }
                    catch (SQLException e) {
                        this.cacheSize.decrementAndGet();
                        if (conn == null) break block5;
                        try {
                            conn.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addPooledConnection(VirtuosoPooledConnection pconn, boolean reuse) throws SQLException {
            if (VirtuosoConnectionPoolDataSource.this.isClosed) {
                throw new VirtuosoException("Cache was closed", 0);
            }
            Object object = this.unUsed;
            synchronized (object) {
                this.unUsed.addLast(pconn);
            }
            if (!reuse) {
                this.cacheSize.incrementAndGet();
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() throws SQLException {
            for (VirtuosoPooledConnection pconn : this.in_Use.keySet()) {
                pconn.removeConnectionEventListener(this.cpds);
                try {
                    pconn.close();
                }
                catch (Exception e) {}
            }
            this.in_Use.clear();
            LinkedList<VirtuosoPooledConnection> linkedList = this.unUsed;
            synchronized (linkedList) {
                for (VirtuosoPooledConnection pconn : this.unUsed) {
                    try {
                        pconn.close();
                    }
                    catch (Exception e) {}
                }
                this.unUsed.clear();
            }
            this.cacheSize.set(0);
        }

        private void reusePooledConnection(VirtuosoPooledConnection pconn) throws SQLException {
            if (VirtuosoConnectionPoolDataSource.this.isClosed) {
                throw new VirtuosoException("Cache was closed", 0);
            }
            if (pconn == null) {
                return;
            }
            pconn.removeConnectionEventListener(this.cpds);
            VirtuosoPooledConnection pooledConn = null;
            pooledConn = this.in_Use.remove(pconn);
            if (pooledConn == null) {
                throw new VirtuosoException("Unexpected state of cache", 0);
            }
            if (VirtuosoConnectionPoolDataSource.this.maxPoolSize != 0 && this.cacheSize.get() > VirtuosoConnectionPoolDataSource.this.maxPoolSize) {
                CloseHelper helpThread = new CloseHelper(pconn);
                helpThread.start();
            } else {
                pooledConn = pconn.reuse();
                this.addPooledConnection(pooledConn, true);
            }
        }

        private void closePooledConnection(VirtuosoPooledConnection pconn) throws SQLException {
            if (VirtuosoConnectionPoolDataSource.this.isClosed) {
                throw new VirtuosoException("Cache was closed", 0);
            }
            pconn.removeConnectionEventListener(this.cpds);
            VirtuosoPooledConnection pooledConn = this.in_Use.remove(pconn);
            if (pooledConn == null) {
                throw new VirtuosoException("Unexpected state of cache", 0);
            }
            try {
                pconn.close();
            }
            finally {
                this.cacheSize.decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private VirtuosoPooledConnection lookup(String _Key) throws SQLException {
            if (VirtuosoConnectionPoolDataSource.this.isClosed) {
                throw new VirtuosoException("Cache was closed", 0);
            }
            ArrayList<VirtuosoPooledConnection> closeTmp = new ArrayList<VirtuosoPooledConnection>();
            int _hashKey = _Key.hashCode();
            try {
                LinkedList<VirtuosoPooledConnection> linkedList = this.unUsed;
                synchronized (linkedList) {
                    ListIterator iterator = this.unUsed.listIterator();
                    while (iterator.hasNext()) {
                        VirtuosoPooledConnection pooledConn = (VirtuosoPooledConnection)iterator.next();
                        if (pooledConn.hashConnURL != _hashKey || !pooledConn.connURL.equals(_Key)) continue;
                        iterator.remove();
                        if (!pooledConn.isConnectionLost(1)) {
                            VirtuosoPooledConnection virtuosoPooledConnection = pooledConn;
                            return virtuosoPooledConnection;
                        }
                        closeTmp.add(pooledConn);
                    }
                }
                linkedList = null;
                return linkedList;
            }
            finally {
                if (closeTmp.size() > 0) {
                    CloseHelper helpThread = new CloseHelper(closeTmp);
                    helpThread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkForNewConn() {
            Object object = this.lck_new;
            synchronized (object) {
                if (VirtuosoConnectionPoolDataSource.this.maxPoolSize == 0 || this.cacheSize.get() < VirtuosoConnectionPoolDataSource.this.maxPoolSize) {
                    this.cacheSize.incrementAndGet();
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PooledConnection getPooledConnection(Properties info, String connKey, String conn_url) throws SQLException {
            if (VirtuosoConnectionPoolDataSource.this.isClosed) {
                throw new VirtuosoException("Cache was closed", 0);
            }
            VirtuosoPooledConnection pconn = null;
            VirtuosoConnection conn = null;
            pconn = this.lookup(connKey);
            if (pconn != null) {
                pconn.init(this.cpds);
                this.in_Use.put(pconn, pconn);
                ++((VirtuosoConnectionPoolDataSource)VirtuosoConnectionPoolDataSource.this).stat._hits;
                return pconn;
            }
            if (this.checkForNewConn()) {
                try {
                    conn = new VirtuosoConnection(conn_url, "localhost", 1111, info);
                    pconn = new VirtuosoPooledConnection(conn, connKey, this.cpds);
                }
                catch (SQLException e) {
                    this.cacheSize.decrementAndGet();
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
                this.in_Use.put(pconn, pconn);
                return pconn;
            }
            long start = System.currentTimeMillis();
            long _timeout = (long)VirtuosoConnectionPoolDataSource.this.loginTimeout * 1000L;
            Thread thr = Thread.currentThread();
            ++((VirtuosoConnectionPoolDataSource)VirtuosoConnectionPoolDataSource.this).stat._misses;
            while (pconn == null) {
                pconn = this.lookup(connKey);
                if (pconn != null) {
                    VirtuosoConnectionPoolDataSource.this.stat.setWaitingTime(System.currentTimeMillis() - start);
                    pconn.init(this.cpds);
                    this.in_Use.put(pconn, pconn);
                    return pconn;
                }
                ConnCache connCache = this;
                synchronized (connCache) {
                    try {
                        if (VirtuosoConnectionPoolDataSource.this.loginTimeout > 0) {
                            this.wait(_timeout);
                            if ((_timeout -= System.currentTimeMillis() - start) < 0L) {
                                throw new VirtuosoException("Connection failed loginTimeout has expired", -6);
                            }
                        } else {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkPool() {
            int count;
            ListIterator l_iter;
            ArrayList<VirtuosoPooledConnection> closeTmp = new ArrayList<VirtuosoPooledConnection>();
            if (VirtuosoConnectionPoolDataSource.this.maxIdleTime != 0) {
                long minTime = System.currentTimeMillis() - (long)VirtuosoConnectionPoolDataSource.this.maxIdleTime * 1000L;
                LinkedList<VirtuosoPooledConnection> linkedList = this.unUsed;
                synchronized (linkedList) {
                    l_iter = this.unUsed.listIterator();
                    while (l_iter.hasNext()) {
                        VirtuosoPooledConnection pooledConn = (VirtuosoPooledConnection)l_iter.next();
                        if (pooledConn.tmClosed >= minTime) continue;
                        closeTmp.add(pooledConn);
                        l_iter.remove();
                    }
                }
            }
            if (VirtuosoConnectionPoolDataSource.this.maxPoolSize != 0 && this.cacheSize.get() > VirtuosoConnectionPoolDataSource.this.maxPoolSize) {
                LinkedList<VirtuosoPooledConnection> minTime = this.unUsed;
                synchronized (minTime) {
                    l_iter = this.unUsed.listIterator();
                    for (count = this.cacheSize.get() - VirtuosoConnectionPoolDataSource.this.maxPoolSize; l_iter.hasNext() && count > 0; --count) {
                        closeTmp.add((VirtuosoPooledConnection)l_iter.next());
                        l_iter.remove();
                    }
                }
            }
            if (closeTmp != null && closeTmp.size() > 0) {
                CloseHelper helpThread = new CloseHelper(closeTmp);
                helpThread.start();
            }
            if (VirtuosoConnectionPoolDataSource.this.minPoolSize != 0 && this.cacheSize.get() < VirtuosoConnectionPoolDataSource.this.minPoolSize) {
                Properties info = VirtuosoConnectionPoolDataSource.this.createConnProperties();
                count = VirtuosoConnectionPoolDataSource.this.minPoolSize - this.cacheSize.get();
                OpenHelper helpThread = new OpenHelper(count, info);
                helpThread.start();
            }
        }
    }

    private class CloseHelper
    extends Thread {
        private List connList;
        private PooledConnection pconn;

        private CloseHelper() {
            this.setName("Virtuoso CloseHelper");
        }

        protected CloseHelper(List _connList) {
            this();
            this.connList = _connList;
        }

        protected CloseHelper(PooledConnection _pconn) {
            this();
            this.pconn = _pconn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.connList != null) {
                ListIterator i = this.connList.listIterator();
                while (i.hasNext()) {
                    try {
                        ((VirtuosoPooledConnection)i.next()).close();
                    }
                    catch (Exception exception) {}
                    continue;
                    finally {
                        ((VirtuosoConnectionPoolDataSource)VirtuosoConnectionPoolDataSource.this).connPool.cacheSize.decrementAndGet();
                    }
                }
                this.connList.clear();
            } else {
                try {
                    this.pconn.close();
                }
                catch (Exception exception) {
                }
                finally {
                    ((VirtuosoConnectionPoolDataSource)VirtuosoConnectionPoolDataSource.this).connPool.cacheSize.decrementAndGet();
                }
            }
        }
    }

    private class OpenHelper
    extends Thread {
        private String conn_url;
        private Properties info;
        private String connKey;
        private int count;

        protected OpenHelper(int _count, Properties _info) {
            this.count = _count;
            this.info = _info;
            this.conn_url = VirtuosoConnectionPoolDataSource.this.create_url();
            this.connKey = VirtuosoConnectionPoolDataSource.this.create_url_key(this.conn_url, this.info);
            this.setName("Virtuoso OpenHelper");
        }

        @Override
        public void run() {
            int cacheSize = ((VirtuosoConnectionPoolDataSource)VirtuosoConnectionPoolDataSource.this).connPool.cacheSize.get();
            if (cacheSize >= this.count || VirtuosoConnectionPoolDataSource.this.maxPoolSize != 0 && cacheSize >= VirtuosoConnectionPoolDataSource.this.maxPoolSize) {
                return;
            }
            for (int i = 0; i < this.count; ++i) {
                try {
                    VirtuosoConnectionPoolDataSource.this.connPool.tryAddConnection(this.conn_url, this.connKey, this.info);
                    cacheSize = ((VirtuosoConnectionPoolDataSource)VirtuosoConnectionPoolDataSource.this).connPool.cacheSize.get();
                    if ((VirtuosoConnectionPoolDataSource.this.minPoolSize == 0 || cacheSize < VirtuosoConnectionPoolDataSource.this.minPoolSize) && (VirtuosoConnectionPoolDataSource.this.maxPoolSize == 0 || cacheSize < VirtuosoConnectionPoolDataSource.this.maxPoolSize)) continue;
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class NewProperty {
        protected long enforceTime;
        protected Field fld;
        protected int arg;

        protected NewProperty(Field _fld, int _arg) {
            this.fld = _fld;
            this.arg = _arg;
            this.enforceTime = System.currentTimeMillis() + (long)VirtuosoConnectionPoolDataSource.this.propertyCycle * 1000L;
        }
    }
}

