/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;
import virtuoso.jena.driver.VirtGraph;

public class VirtResSetIter
extends NiceIterator<Triple> {
    protected Statement v_stmt;
    protected ResultSet v_resultSet;
    protected Triple v_row;
    protected TripleMatch v_in;
    protected boolean v_finished = false;
    protected boolean v_prefetched = false;
    protected VirtGraph v_graph = null;

    public VirtResSetIter() {
        this.v_finished = true;
    }

    public VirtResSetIter(VirtGraph graph, Statement stmt, ResultSet resultSet, TripleMatch in) {
        this.v_stmt = stmt;
        this.v_resultSet = resultSet;
        this.v_in = in;
        this.v_graph = graph;
    }

    public boolean hasNext() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        return !this.v_finished;
    }

    public Triple removeNext() {
        Triple ret = this.next();
        this.remove();
        return ret;
    }

    public Triple next() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        this.v_prefetched = false;
        if (this.v_finished) {
            throw new NoSuchElementException();
        }
        return this.getRow();
    }

    public void remove() {
        if (this.v_row != null && this.v_graph != null) {
            this.v_graph.delete(this.v_row);
            this.v_row = null;
        }
    }

    protected void moveForward() {
        try {
            if (!this.v_finished && this.v_resultSet.next()) {
                this.extractRow();
                this.v_prefetched = true;
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    protected void extractRow() throws Exception {
        Node NodeS = this.v_in.getMatchSubject() != null ? this.v_in.getMatchSubject() : VirtGraph.Object2Node(this.v_resultSet.getObject("s"));
        Node NodeP = this.v_in.getMatchPredicate() != null ? this.v_in.getMatchPredicate() : VirtGraph.Object2Node(this.v_resultSet.getObject("p"));
        Node NodeO = this.v_in.getMatchObject() != null ? this.v_in.getMatchObject() : VirtGraph.Object2Node(this.v_resultSet.getObject("o"));
        this.v_row = new Triple(NodeS, NodeP, NodeO);
    }

    protected Triple getRow() {
        return this.v_row;
    }

    public void close() {
        if (!this.v_finished) {
            if (this.v_resultSet != null) {
                try {
                    this.v_resultSet.close();
                    this.v_resultSet = null;
                }
                catch (SQLException e) {
                    throw new JenaException((Throwable)e);
                }
            }
            if (this.v_stmt != null) {
                try {
                    this.v_stmt.close();
                    this.v_stmt = null;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        this.v_finished = true;
    }

    protected void finalize() throws SQLException {
        if (!this.v_finished && this.v_resultSet != null) {
            this.close();
        }
    }
}

