/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.rdf4j.driver;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import virtuoso.jdbc4.VirtuosoConnectionPoolDataSource;
import virtuoso.rdf4j.driver.VirtuosoRepositoryConnection;
import virtuoso.rdf4j.driver.VirtuosoValueFactory;

public class VirtuosoRepository
implements Repository {
    public static final int CONCUR_DEFAULT = 0;
    public static final int CONCUR_PESSIMISTIC = 1;
    public static final int CONCUR_OPTIMISTIC = 2;
    VirtuosoValueFactory valueFactory = VirtuosoValueFactory.getInstance();
    File dataDir;
    private VirtuosoConnectionPoolDataSource pds = new VirtuosoConnectionPoolDataSource();
    private String url_hostlist;
    private String user;
    private String password;
    private int resultsHandlerType = 0;
    private boolean roundrobin;
    private String charset = "UTF-8";
    static final String utf8 = "charset=utf-8";
    private boolean initialized = false;
    private DataSource _ds;
    private ConnectionPoolDataSource _pds;
    private XADataSource _xads;
    boolean useLazyAdd = true;
    boolean insertBNodeAsVirtuosoIRI = false;
    boolean insertStringLiteralAsSimple = false;
    String defGraph;
    int prefetchSize = 100;
    int batchSize = 5000;
    int queryTimeout = 0;
    String ruleSet;
    String macroLib;
    int concurencyMode = 0;
    boolean useDefGraphForQueries = false;

    public VirtuosoRepository(ConnectionPoolDataSource ds, String defGraph, boolean useLazyAdd) {
        this.defGraph = defGraph;
        this.useLazyAdd = useLazyAdd;
        this._pds = ds;
    }

    public VirtuosoRepository(DataSource ds, String defGraph, boolean useLazyAdd) {
        this.defGraph = defGraph;
        this.useLazyAdd = useLazyAdd;
        this._ds = ds;
    }

    public VirtuosoRepository(XADataSource ds, String defGraph) {
        this.defGraph = defGraph;
        this.useLazyAdd = false;
        this._xads = ds;
    }

    public VirtuosoRepository(String url_hostlist, String user, String password, String defGraph, boolean useLazyAdd) {
        this.url_hostlist = url_hostlist.trim();
        this.user = user;
        this.password = password;
        this.defGraph = defGraph;
        this.useLazyAdd = useLazyAdd;
    }

    public VirtuosoRepository(String url_hostlist, String user, String password, boolean useLazyAdd) {
        this(url_hostlist, user, password, "sesame:nil", useLazyAdd);
    }

    public VirtuosoRepository(String url_hostlist, String user, String password, String defGraph) {
        this(url_hostlist, user, password, defGraph, true);
    }

    public VirtuosoRepository(String url_hostlist, String user, String password) {
        this(url_hostlist, user, password, true);
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        if (this._xads != null) {
            try {
                XAConnection xconn = this._xads.getXAConnection();
                Connection connection = xconn.getConnection();
                this.useLazyAdd = false;
                return new VirtuosoRepositoryConnection(this, connection);
            }
            catch (Exception e) {
                System.out.println("Connection has FAILED.");
                throw new RepositoryException((Throwable)e);
            }
        }
        if (this._pds != null) {
            try {
                PooledConnection pconn = this._pds.getPooledConnection();
                Connection connection = pconn.getConnection();
                return new VirtuosoRepositoryConnection(this, connection);
            }
            catch (Exception e) {
                System.out.println("Connection has FAILED.");
                throw new RepositoryException((Throwable)e);
            }
        }
        if (this._ds != null) {
            try {
                Connection connection = this._ds.getConnection();
                return new VirtuosoRepositoryConnection(this, connection);
            }
            catch (Exception e) {
                System.out.println("Connection has FAILED.");
                throw new RepositoryException((Throwable)e);
            }
        }
        if (this.url_hostlist.startsWith("jdbc:virtuoso://")) {
            try {
                Class.forName("virtuoso.jdbc4.Driver");
                Object url = this.url_hostlist;
                if (((String)url).toLowerCase().indexOf(utf8) == -1) {
                    url = ((String)url).charAt(((String)url).length() - 1) != '/' ? (String)url + "/charset=UTF-8" : (String)url + "charset=UTF-8";
                }
                if (this.roundrobin && ((String)url).toLowerCase().indexOf("roundrobin=") == -1) {
                    url = ((String)url).charAt(((String)url).length() - 1) != '/' ? (String)url + "/roundrobin=1" : (String)url + "roundrobin=1";
                }
                if (((String)url).toLowerCase().indexOf("log_enable=") == -1) {
                    url = ((String)url).charAt(((String)url).length() - 1) != '/' ? (String)url + "/log_enable=1" : (String)url + "log_enable=1";
                }
                Connection connection = DriverManager.getConnection((String)url, this.user, this.password);
                return new VirtuosoRepositoryConnection(this, connection);
            }
            catch (Exception e) {
                System.out.println("Connection to " + this.url_hostlist + " has FAILED.");
                throw new RepositoryException((Throwable)e);
            }
        }
        try {
            this.pds.setServerName(this.url_hostlist);
            this.pds.setUser(this.user);
            this.pds.setPassword(this.password);
            this.pds.setCharset(this.charset);
            this.pds.setRoundrobin(this.roundrobin);
            PooledConnection pconn = this.pds.getPooledConnection();
            Connection connection = pconn.getConnection();
            return new VirtuosoRepositoryConnection(this, connection);
        }
        catch (Exception e) {
            System.out.println("Connection to " + this.url_hostlist + " has FAILED.");
            throw new RepositoryException((Throwable)e);
        }
    }

    public final void init() throws RepositoryException {
        this.initialized = true;
    }

    public void setFetchSize(int sz) {
        this.prefetchSize = sz;
    }

    public int getFetchSize() {
        return this.prefetchSize;
    }

    public void setBatchSize(int sz) {
        this.batchSize = sz;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setQueryTimeout(int seconds) {
        this.queryTimeout = seconds;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setUseLazyAdd(boolean v) {
        this.useLazyAdd = v;
    }

    public boolean getUseLazyAdd() {
        return this.useLazyAdd;
    }

    public void setRoundrobin(boolean v) {
        this.roundrobin = v;
    }

    public boolean getRoundrobin() {
        return this.roundrobin;
    }

    public void setInsertBNodeAsVirtuosoIRI(boolean v) {
        this.insertBNodeAsVirtuosoIRI = v;
    }

    public boolean getInsertBNodeAsVirtuosoIRI() {
        return this.insertBNodeAsVirtuosoIRI;
    }

    public boolean getInsertStringLiteralAsSimple() {
        return this.insertStringLiteralAsSimple;
    }

    public void setInsertStringLiteralAsSimple(boolean v) {
        this.insertStringLiteralAsSimple = v;
    }

    public void setRuleSet(String name) {
        if (name != null && name.equals("null")) {
            name = null;
        }
        this.ruleSet = name;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public void setMacroLib(String name) {
        if (name != null && name.equals("null")) {
            name = null;
        }
        this.macroLib = name;
    }

    public String getMacroLib() {
        return this.macroLib;
    }

    public void setConcurrencyMode(int mode) throws RepositoryException {
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new IllegalArgumentException("Unsupported concurrency mode: " + mode);
        }
        this.concurencyMode = mode;
    }

    public int getConcurrencyMode() {
        return this.concurencyMode;
    }

    public void setUseDefGraphForQueries(boolean v) {
        this.useDefGraphForQueries = v;
    }

    public boolean getUseDefGraphForQueries() {
        return this.useDefGraphForQueries;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public VirtuosoValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isWritable() throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("VirtuosoRepository not initialized.");
        }
        return true;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public void shutDown() throws RepositoryException {
        this.initialized = false;
    }

    public void createRuleSet(String ruleSetName, String uriGraphRuleSet) throws RepositoryException {
        Connection con = ((VirtuosoRepositoryConnection)this.getConnection()).getQuadStoreConnection();
        try {
            Statement st = con.createStatement();
            st.execute("rdfs_rule_set('" + ruleSetName + "', '" + uriGraphRuleSet + "')");
            st.close();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

