|         SYSCALL         | SUPPORTED |                   ARCHITECTURE                   |
|-------------------------|-----------|--------------------------------------------------|
| _llseek                 | 🟢        | ppc64le                                          |
| _newselect              | 🟡        | ppc64le                                          |
| accept                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,x86_64       |
| accept4                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| access                  | 🟢        | ppc64le,s390x,x86_64                             |
| acct                    | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| add_key                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| adjtimex                | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| alarm                   | 🟡        | ppc64le,s390x,x86_64                             |
| arch_prctl              | 🟡        | x86_64                                           |
| bind                    | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| bpf                     | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| brk                     | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| cachestat               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| capget                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| capset                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| chdir                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| chmod                   | 🟢        | ppc64le,s390x,x86_64                             |
| chown                   | 🟢        | ppc64le,s390x,x86_64                             |
| chroot                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| clock_adjtime           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| clock_getres            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| clock_gettime           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| clock_nanosleep         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| clock_settime           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| clone                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| clone3                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| close                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| close_range             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| connect                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| copy_file_range         | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| creat                   | 🟢        | ppc64le,s390x,x86_64                             |
| delete_module           | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| dup                     | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| dup2                    | 🟢        | ppc64le,s390x,x86_64                             |
| dup3                    | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| epoll_create            | 🟢        | ppc64le,s390x,x86_64                             |
| epoll_create1           | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| epoll_ctl               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| epoll_ctl_old           | 🟡        | x86_64                                           |
| epoll_pwait             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| epoll_pwait2            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| epoll_wait              | 🟢        | ppc64le,s390x,x86_64                             |
| epoll_wait_old          | 🟡        | x86_64                                           |
| eventfd                 | 🟢        | ppc64le,s390x,x86_64                             |
| eventfd2                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| execve                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| execveat                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| exit                    | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| exit_group              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| faccessat               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| faccessat2              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fadvise64               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fallocate               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fanotify_init           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fanotify_mark           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fchdir                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fchmod                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fchmodat                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fchmodat2               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fchown                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fchownat                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fcntl                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fdatasync               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fgetxattr               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| file_getattr            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| file_setattr            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| finit_module            | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| flistxattr              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| flock                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fork                    | 🟢        | ppc64le,s390x,x86_64                             |
| fremovexattr            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fsconfig                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fsetxattr               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fsmount                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fsopen                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fspick                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fstat                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fstatfs                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| fstatfs64               | 🟡        | ppc64le,s390x                                    |
| fsync                   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| ftruncate               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| futex                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| futex_requeue           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| futex_wait              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| futex_waitv             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| futex_wake              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| futimesat               | 🟡        | ppc64le,s390x,x86_64                             |
| get_mempolicy           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| get_robust_list         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| get_thread_area         | 🟡        | x86_64                                           |
| getcpu                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getcwd                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getdents                | 🟢        | ppc64le,s390x,x86_64                             |
| getdents64              | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getegid                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| geteuid                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getgid                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getgroups               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getitimer               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getpeername             | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getpgid                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getpgrp                 | 🟡        | ppc64le,s390x,x86_64                             |
| getpid                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getppid                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getpriority             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getrandom               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getresgid               | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getresuid               | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getrlimit               | 🟢        | aarch64,ppc64le,riscv64,s390x,x86_64             |
| getrusage               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getsid                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getsockname             | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getsockopt              | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| gettid                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| gettimeofday            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getuid                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getxattr                | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| getxattrat              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| init_module             | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| inotify_add_watch       | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| inotify_init            | 🟢        | ppc64le,s390x,x86_64                             |
| inotify_init1           | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| inotify_rm_watch        | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| io_cancel               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| io_destroy              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| io_getevents            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| io_pgetevents           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| io_setup                | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| io_submit               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| io_uring_enter          | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| io_uring_register       | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| io_uring_setup          | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| ioctl                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| ioperm                  | 🟡        | ppc64le,x86_64                                   |
| iopl                    | 🟡        | ppc64le,x86_64                                   |
| ioprio_get              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| ioprio_set              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| ipc                     | 🟡        | ppc64le,s390x                                    |
| kcmp                    | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| kexec_file_load         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| kexec_load              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| keyctl                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| kill                    | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| landlock_add_rule       | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| landlock_create_ruleset | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| landlock_restrict_self  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| lchown                  | 🟢        | ppc64le,s390x,x86_64                             |
| lgetxattr               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| link                    | 🟢        | ppc64le,s390x,x86_64                             |
| linkat                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| listen                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| listmount               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| listxattr               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| listxattrat             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| llistxattr              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| lookup_dcookie          | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| lremovexattr            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| lseek                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| lsetxattr               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| lsm_get_self_attr       | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| lsm_list_modules        | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| lsm_set_self_attr       | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| lstat                   | 🟢        | ppc64le,s390x,x86_64                             |
| madvise                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| map_shadow_stack        | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mbind                   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| membarrier              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| memfd_create            | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| memfd_secret            | 🟡        | aarch64,riscv64,s390x,x86_64                     |
| migrate_pages           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mincore                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mkdir                   | 🟢        | ppc64le,s390x,x86_64                             |
| mkdirat                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mknod                   | 🟢        | ppc64le,s390x,x86_64                             |
| mknodat                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mlock                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mlock2                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mlockall                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mmap                    | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| modify_ldt              | 🟡        | ppc64le,x86_64                                   |
| mount                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mount_setattr           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| move_mount              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| move_pages              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mprotect                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mq_getsetattr           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mq_notify               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mq_open                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mq_timedreceive         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mq_timedsend            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mq_unlink               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mremap                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| mseal                   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| msgctl                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| msgget                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| msgrcv                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| msgsnd                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| msync                   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| multiplexer             | 🟡        | ppc64le                                          |
| munlock                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| munlockall              | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| munmap                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| name_to_handle_at       | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| nanosleep               | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| newfstatat              | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| nice                    | 🟡        | ppc64le,s390x                                    |
| oldfstat                | 🟡        | ppc64le                                          |
| oldlstat                | 🟡        | ppc64le                                          |
| oldolduname             | 🟡        | ppc64le                                          |
| oldstat                 | 🟡        | ppc64le                                          |
| olduname                | 🟡        | ppc64le                                          |
| open                    | 🟢        | ppc64le,s390x,x86_64                             |
| open_by_handle_at       | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| open_tree               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| open_tree_attr          | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| openat                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| openat2                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pause                   | 🟡        | ppc64le,s390x,x86_64                             |
| pciconfig_iobase        | 🟡        | ppc64le                                          |
| pciconfig_read          | 🟡        | ppc64le                                          |
| pciconfig_write         | 🟡        | ppc64le                                          |
| perf_event_open         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| personality             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pidfd_getfd             | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pidfd_open              | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pidfd_send_signal       | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pipe                    | 🟢        | ppc64le,s390x,x86_64                             |
| pipe2                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pivot_root              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pkey_alloc              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pkey_free               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pkey_mprotect           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| poll                    | 🟢        | ppc64le,s390x,x86_64                             |
| ppoll                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| prctl                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pread64                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| preadv                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| preadv2                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| prlimit64               | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| process_madvise         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| process_mrelease        | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| process_vm_readv        | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| process_vm_writev       | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pselect6                | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| ptrace                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pwrite64                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pwritev                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| pwritev2                | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| quotactl                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| quotactl_fd             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| read                    | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| readahead               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| readdir                 | 🟡        | ppc64le,s390x                                    |
| readlink                | 🟡        | ppc64le,s390x,x86_64                             |
| readlinkat              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| readv                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| reboot                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| recv                    | 🟢        | ppc64le                                          |
| recvfrom                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| recvmmsg                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| recvmsg                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| remap_file_pages        | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| removexattr             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| removexattrat           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| rename                  | 🟢        | ppc64le,s390x,x86_64                             |
| renameat                | 🟢        | aarch64,ppc64le,s390x,x86_64                     |
| renameat2               | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| request_key             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| restart_syscall         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| riscv_flush_icache      | 🟡        | riscv64                                          |
| riscv_hwprobe           | 🟡        | riscv64                                          |
| rmdir                   | 🟢        | ppc64le,s390x,x86_64                             |
| rseq                    | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| rt_sigaction            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| rt_sigpending           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| rt_sigprocmask          | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| rt_sigqueueinfo         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| rt_sigreturn            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| rt_sigsuspend           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| rt_sigtimedwait         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| rt_tgsigqueueinfo       | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| rtas                    | 🟡        | ppc64le                                          |
| s390_guarded_storage    | 🟡        | s390x                                            |
| s390_pci_mmio_read      | 🟡        | s390x                                            |
| s390_pci_mmio_write     | 🟡        | s390x                                            |
| s390_runtime_instr      | 🟡        | s390x                                            |
| s390_sthyi              | 🟡        | s390x                                            |
| sched_get_priority_max  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sched_get_priority_min  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sched_getaffinity       | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sched_getattr           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sched_getparam          | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sched_getscheduler      | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sched_rr_get_interval   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sched_setaffinity       | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sched_setattr           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sched_setparam          | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sched_setscheduler      | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sched_yield             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| seccomp                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| select                  | 🟢        | ppc64le,s390x,x86_64                             |
| semctl                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| semget                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| semop                   | 🟢        | aarch64,loongarch64,riscv64,x86_64               |
| semtimedop              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| send                    | 🟢        | ppc64le                                          |
| sendfile                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sendmmsg                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sendmsg                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sendto                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| set_mempolicy           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| set_mempolicy_home_node | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| set_robust_list         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| set_thread_area         | 🟡        | x86_64                                           |
| set_tid_address         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setdomainname           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setfsgid                | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setfsuid                | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setgid                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setgroups               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sethostname             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setitimer               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setns                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setpgid                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setpriority             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setregid                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setresgid               | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setresuid               | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setreuid                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setrlimit               | 🟢        | aarch64,ppc64le,riscv64,s390x,x86_64             |
| setsid                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setsockopt              | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| settimeofday            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setuid                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setxattr                | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| setxattrat              | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sgetmask                | 🟡        | ppc64le                                          |
| shmat                   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| shmctl                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| shmdt                   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| shmget                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| shutdown                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sigaction               | 🟡        | ppc64le,s390x                                    |
| sigaltstack             | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| signal                  | 🟡        | ppc64le,s390x                                    |
| signalfd                | 🟢        | ppc64le,s390x,x86_64                             |
| signalfd4               | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sigpending              | 🟡        | ppc64le,s390x                                    |
| sigprocmask             | 🟡        | ppc64le,s390x                                    |
| sigreturn               | 🟡        | ppc64le,s390x                                    |
| sigsuspend              | 🟡        | ppc64le,s390x                                    |
| socket                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| socketcall              | 🟡        | ppc64le,s390x                                    |
| socketpair              | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| splice                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| spu_create              | 🟡        | ppc64le                                          |
| spu_run                 | 🟡        | ppc64le                                          |
| ssetmask                | 🟡        | ppc64le                                          |
| stat                    | 🟢        | ppc64le,s390x,x86_64                             |
| statfs                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| statfs64                | 🟡        | ppc64le,s390x                                    |
| statmount               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| statx                   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| stime                   | 🟡        | ppc64le                                          |
| subpage_prot            | 🟡        | ppc64le                                          |
| swapcontext             | 🟡        | ppc64le                                          |
| swapoff                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| swapon                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| switch_endian           | 🟡        | ppc64le                                          |
| symlink                 | 🟢        | ppc64le,s390x,x86_64                             |
| symlinkat               | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sync                    | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sync_file_range         | 🟡        | aarch64,loongarch64,riscv64,s390x,x86_64         |
| sync_file_range2        | 🟡        | ppc64le                                          |
| syncfs                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| sys_debug_setcontext    | 🟡        | ppc64le                                          |
| sysfs                   | 🟡        | ppc64le,s390x,x86_64                             |
| sysinfo                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| syslog                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| tee                     | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| tgkill                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| time                    | 🟡        | ppc64le,x86_64                                   |
| timer_create            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| timer_delete            | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| timer_getoverrun        | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| timer_gettime           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| timer_settime           | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| timerfd                 | 🟡        | s390x                                            |
| timerfd_create          | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| timerfd_gettime         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| timerfd_settime         | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| times                   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| tkill                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| truncate                | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| ugetrlimit              | 🟢        | ppc64le                                          |
| umask                   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| umount                  | 🟢        | ppc64le,s390x                                    |
| umount2                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| uname                   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| unlink                  | 🟢        | ppc64le,s390x,x86_64                             |
| unlinkat                | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| unshare                 | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| uretprobe               | 🟡        | x86_64                                           |
| userfaultfd             | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| ustat                   | 🟡        | ppc64le,s390x,x86_64                             |
| utime                   | 🟡        | ppc64le,s390x,x86_64                             |
| utimensat               | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| utimes                  | 🟡        | ppc64le,s390x,x86_64                             |
| vfork                   | 🟢        | ppc64le,s390x,x86_64                             |
| vhangup                 | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| vm86                    | 🟡        | ppc64le                                          |
| vmsplice                | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| wait4                   | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| waitid                  | 🟡        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| waitpid                 | 🟡        | ppc64le                                          |
| write                   | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
| writev                  | 🟢        | aarch64,loongarch64,ppc64le,riscv64,s390x,x86_64 |
