/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     AT_SYM = 277,
     AUTHORS_SYM = 278,
     AUTOEXTEND_SIZE_SYM = 279,
     AUTO_INC = 280,
     AVG_ROW_LENGTH = 281,
     AVG_SYM = 282,
     BACKUP_SYM = 283,
     BEFORE_SYM = 284,
     BEGIN_SYM = 285,
     BETWEEN_SYM = 286,
     BIGINT = 287,
     BINARY = 288,
     BINLOG_SYM = 289,
     BIN_NUM = 290,
     BIT_AND = 291,
     BIT_OR = 292,
     BIT_SYM = 293,
     BIT_XOR = 294,
     BLOB_SYM = 295,
     BLOCK_SYM = 296,
     BOOLEAN_SYM = 297,
     BOOL_SYM = 298,
     BOTH = 299,
     BTREE_SYM = 300,
     BY = 301,
     BYTE_SYM = 302,
     CACHE_SYM = 303,
     CALL_SYM = 304,
     CASCADE = 305,
     CASCADED = 306,
     CASE_SYM = 307,
     CAST_SYM = 308,
     CHAIN_SYM = 309,
     CHANGE = 310,
     CHANGED = 311,
     CHARSET = 312,
     CHAR_SYM = 313,
     CHECKSUM_SYM = 314,
     CHECK_SYM = 315,
     CIPHER_SYM = 316,
     CLIENT_SYM = 317,
     CLOSE_SYM = 318,
     COALESCE = 319,
     CODE_SYM = 320,
     COLLATE_SYM = 321,
     COLLATION_SYM = 322,
     COLUMNS = 323,
     COLUMN_SYM = 324,
     COMMENT_SYM = 325,
     COMMITTED_SYM = 326,
     COMMIT_SYM = 327,
     COMPACT_SYM = 328,
     COMPLETION_SYM = 329,
     COMPRESSED_SYM = 330,
     CONCURRENT = 331,
     CONDITION_SYM = 332,
     CONNECTION_SYM = 333,
     CONSISTENT_SYM = 334,
     CONSTRAINT = 335,
     CONTAINS_SYM = 336,
     CONTEXT_SYM = 337,
     CONTINUE_SYM = 338,
     CONTRIBUTORS_SYM = 339,
     CONVERT_SYM = 340,
     COUNT_SYM = 341,
     CPU_SYM = 342,
     CREATE = 343,
     CROSS = 344,
     CUBE_SYM = 345,
     CURDATE = 346,
     CURRENT_USER = 347,
     CURSOR_SYM = 348,
     CURTIME = 349,
     DATABASE = 350,
     DATABASES = 351,
     DATAFILE_SYM = 352,
     DATA_SYM = 353,
     DATETIME = 354,
     DATE_ADD_INTERVAL = 355,
     DATE_SUB_INTERVAL = 356,
     DATE_SYM = 357,
     DAY_HOUR_SYM = 358,
     DAY_MICROSECOND_SYM = 359,
     DAY_MINUTE_SYM = 360,
     DAY_SECOND_SYM = 361,
     DAY_SYM = 362,
     DEALLOCATE_SYM = 363,
     DECIMAL_NUM = 364,
     DECIMAL_SYM = 365,
     DECLARE_SYM = 366,
     DEFAULT = 367,
     DEFINER_SYM = 368,
     DELAYED_SYM = 369,
     DELAY_KEY_WRITE_SYM = 370,
     DELETE_SYM = 371,
     DESC = 372,
     DESCRIBE = 373,
     DES_KEY_FILE = 374,
     DETERMINISTIC_SYM = 375,
     DIRECTORY_SYM = 376,
     DISABLE_SYM = 377,
     DISCARD = 378,
     DISK_SYM = 379,
     DISTINCT = 380,
     DIV_SYM = 381,
     DOUBLE_SYM = 382,
     DO_SYM = 383,
     DROP = 384,
     DUAL_SYM = 385,
     DUMPFILE = 386,
     DUPLICATE_SYM = 387,
     DYNAMIC_SYM = 388,
     EACH_SYM = 389,
     ELSE = 390,
     ELSEIF_SYM = 391,
     ENABLE_SYM = 392,
     ENCLOSED = 393,
     END = 394,
     ENDS_SYM = 395,
     END_OF_INPUT = 396,
     ENGINES_SYM = 397,
     ENGINE_SYM = 398,
     ENUM = 399,
     EQ = 400,
     EQUAL_SYM = 401,
     ERRORS = 402,
     ESCAPED = 403,
     ESCAPE_SYM = 404,
     EVENTS_SYM = 405,
     EVENT_SYM = 406,
     EVERY_SYM = 407,
     EXECUTE_SYM = 408,
     EXISTS = 409,
     EXIT_SYM = 410,
     EXPANSION_SYM = 411,
     EXTENDED_SYM = 412,
     EXTENT_SIZE_SYM = 413,
     EXTRACT_SYM = 414,
     FALSE_SYM = 415,
     FAST_SYM = 416,
     FAULTS_SYM = 417,
     FETCH_SYM = 418,
     FILE_SYM = 419,
     FIRST_SYM = 420,
     FIXED_SYM = 421,
     FLOAT_NUM = 422,
     FLOAT_SYM = 423,
     FLUSH_SYM = 424,
     FORCE_SYM = 425,
     FOREIGN = 426,
     FOR_SYM = 427,
     FOUND_SYM = 428,
     FRAC_SECOND_SYM = 429,
     FROM = 430,
     FULL = 431,
     FULLTEXT_SYM = 432,
     FUNCTION_SYM = 433,
     GE = 434,
     GEOMETRYCOLLECTION = 435,
     GEOMETRY_SYM = 436,
     GET_FORMAT = 437,
     GLOBAL_SYM = 438,
     GRANT = 439,
     GRANTS = 440,
     GROUP_SYM = 441,
     GROUP_CONCAT_SYM = 442,
     GT_SYM = 443,
     HANDLER_SYM = 444,
     HASH_SYM = 445,
     HAVING = 446,
     HELP_SYM = 447,
     HEX_NUM = 448,
     HIGH_PRIORITY = 449,
     HOST_SYM = 450,
     HOSTS_SYM = 451,
     HOUR_MICROSECOND_SYM = 452,
     HOUR_MINUTE_SYM = 453,
     HOUR_SECOND_SYM = 454,
     HOUR_SYM = 455,
     IDENT = 456,
     IDENTIFIED_SYM = 457,
     IDENT_QUOTED = 458,
     IF = 459,
     IGNORE_SYM = 460,
     IMPORT = 461,
     INDEXES = 462,
     INDEX_SYM = 463,
     INFILE = 464,
     INITIAL_SIZE_SYM = 465,
     INNER_SYM = 466,
     INNOBASE_SYM = 467,
     INOUT_SYM = 468,
     INSENSITIVE_SYM = 469,
     INSERT = 470,
     INSERT_METHOD = 471,
     INSTALL_SYM = 472,
     INTERVAL_SYM = 473,
     INTO = 474,
     INT_SYM = 475,
     INVOKER_SYM = 476,
     IN_SYM = 477,
     IO_SYM = 478,
     IPC_SYM = 479,
     IS = 480,
     ISOLATION = 481,
     ISSUER_SYM = 482,
     ITERATE_SYM = 483,
     JOIN_SYM = 484,
     KEYS = 485,
     KEY_BLOCK_SIZE = 486,
     KEY_SYM = 487,
     KILL_SYM = 488,
     LANGUAGE_SYM = 489,
     LAST_SYM = 490,
     LE = 491,
     LEADING = 492,
     LEAVES = 493,
     LEAVE_SYM = 494,
     LEFT = 495,
     LESS_SYM = 496,
     LEVEL_SYM = 497,
     LEX_HOSTNAME = 498,
     LIKE = 499,
     LIMIT = 500,
     LINEAR_SYM = 501,
     LINES = 502,
     LINESTRING = 503,
     LIST_SYM = 504,
     LOAD = 505,
     LOCAL_SYM = 506,
     LOCATOR_SYM = 507,
     LOCKS_SYM = 508,
     LOCK_SYM = 509,
     LOGFILE_SYM = 510,
     LOGS_SYM = 511,
     LONGBLOB = 512,
     LONGTEXT = 513,
     LONG_NUM = 514,
     LONG_SYM = 515,
     LOOP_SYM = 516,
     LOW_PRIORITY = 517,
     LT = 518,
     MASTER_CONNECT_RETRY_SYM = 519,
     MASTER_HOST_SYM = 520,
     MASTER_LOG_FILE_SYM = 521,
     MASTER_LOG_POS_SYM = 522,
     MASTER_PASSWORD_SYM = 523,
     MASTER_PORT_SYM = 524,
     MASTER_SERVER_ID_SYM = 525,
     MASTER_SSL_CAPATH_SYM = 526,
     MASTER_SSL_CA_SYM = 527,
     MASTER_SSL_CERT_SYM = 528,
     MASTER_SSL_CIPHER_SYM = 529,
     MASTER_SSL_KEY_SYM = 530,
     MASTER_SSL_SYM = 531,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 532,
     MASTER_SYM = 533,
     MASTER_USER_SYM = 534,
     MATCH = 535,
     MAX_CONNECTIONS_PER_HOUR = 536,
     MAX_QUERIES_PER_HOUR = 537,
     MAX_ROWS = 538,
     MAX_SIZE_SYM = 539,
     MAX_SYM = 540,
     MAX_UPDATES_PER_HOUR = 541,
     MAX_USER_CONNECTIONS_SYM = 542,
     MAX_VALUE_SYM = 543,
     MEDIUMBLOB = 544,
     MEDIUMINT = 545,
     MEDIUMTEXT = 546,
     MEDIUM_SYM = 547,
     MEMORY_SYM = 548,
     MERGE_SYM = 549,
     MICROSECOND_SYM = 550,
     MIGRATE_SYM = 551,
     MINUTE_MICROSECOND_SYM = 552,
     MINUTE_SECOND_SYM = 553,
     MINUTE_SYM = 554,
     MIN_ROWS = 555,
     MIN_SYM = 556,
     MODE_SYM = 557,
     MODIFIES_SYM = 558,
     MODIFY_SYM = 559,
     MOD_SYM = 560,
     MONTH_SYM = 561,
     MULTILINESTRING = 562,
     MULTIPOINT = 563,
     MULTIPOLYGON = 564,
     MUTEX_SYM = 565,
     NAMES_SYM = 566,
     NAME_SYM = 567,
     NATIONAL_SYM = 568,
     NATURAL = 569,
     NCHAR_STRING = 570,
     NCHAR_SYM = 571,
     NDBCLUSTER_SYM = 572,
     NE = 573,
     NEG = 574,
     NEW_SYM = 575,
     NEXT_SYM = 576,
     NODEGROUP_SYM = 577,
     NONE_SYM = 578,
     NOT2_SYM = 579,
     NOT_SYM = 580,
     NOW_SYM = 581,
     NO_SYM = 582,
     NO_WAIT_SYM = 583,
     NO_WRITE_TO_BINLOG = 584,
     NULL_SYM = 585,
     NUM = 586,
     NUMERIC_SYM = 587,
     NVARCHAR_SYM = 588,
     OFFSET_SYM = 589,
     OLD_PASSWORD = 590,
     ON = 591,
     ONE_SHOT_SYM = 592,
     ONE_SYM = 593,
     OPEN_SYM = 594,
     OPTIMIZE = 595,
     OPTIONS_SYM = 596,
     OPTION = 597,
     OPTIONALLY = 598,
     OR2_SYM = 599,
     ORDER_SYM = 600,
     OR_OR_SYM = 601,
     OR_SYM = 602,
     OUTER = 603,
     OUTFILE = 604,
     OUT_SYM = 605,
     OWNER_SYM = 606,
     PACK_KEYS_SYM = 607,
     PAGE_SYM = 608,
     PAGE_CHECKSUM_SYM = 609,
     PARAM_MARKER = 610,
     PARSER_SYM = 611,
     PARTIAL = 612,
     PARTITIONING_SYM = 613,
     PARTITIONS_SYM = 614,
     PARTITION_SYM = 615,
     PASSWORD = 616,
     PHASE_SYM = 617,
     PLUGINS_SYM = 618,
     PLUGIN_SYM = 619,
     POINT_SYM = 620,
     POLYGON = 621,
     PORT_SYM = 622,
     POSITION_SYM = 623,
     PRECISION = 624,
     PREPARE_SYM = 625,
     PRESERVE_SYM = 626,
     PREV_SYM = 627,
     PRIMARY_SYM = 628,
     PRIVILEGES = 629,
     PROCEDURE = 630,
     PROCESS = 631,
     PROCESSLIST_SYM = 632,
     PROFILE_SYM = 633,
     PROFILES_SYM = 634,
     PURGE = 635,
     QUARTER_SYM = 636,
     QUERY_SYM = 637,
     QUICK = 638,
     RANGE_SYM = 639,
     READS_SYM = 640,
     READ_ONLY_SYM = 641,
     READ_SYM = 642,
     READ_WRITE_SYM = 643,
     REAL = 644,
     REBUILD_SYM = 645,
     RECOVER_SYM = 646,
     REDOFILE_SYM = 647,
     REDO_BUFFER_SIZE_SYM = 648,
     REDUNDANT_SYM = 649,
     REFERENCES = 650,
     REGEXP = 651,
     RELAY_LOG_FILE_SYM = 652,
     RELAY_LOG_POS_SYM = 653,
     RELAY_THREAD = 654,
     RELEASE_SYM = 655,
     RELOAD = 656,
     REMOVE_SYM = 657,
     RENAME = 658,
     REORGANIZE_SYM = 659,
     REPAIR = 660,
     REPEATABLE_SYM = 661,
     REPEAT_SYM = 662,
     REPLACE = 663,
     REPLICATION = 664,
     REQUIRE_SYM = 665,
     RESET_SYM = 666,
     RESOURCES = 667,
     RESTORE_SYM = 668,
     RESTRICT = 669,
     RESUME_SYM = 670,
     RETURNS_SYM = 671,
     RETURN_SYM = 672,
     REVOKE = 673,
     RIGHT = 674,
     ROLLBACK_SYM = 675,
     ROLLUP_SYM = 676,
     ROUTINE_SYM = 677,
     ROWS_SYM = 678,
     ROW_FORMAT_SYM = 679,
     ROW_SYM = 680,
     RTREE_SYM = 681,
     SAVEPOINT_SYM = 682,
     SCHEDULE_SYM = 683,
     SECOND_MICROSECOND_SYM = 684,
     SECOND_SYM = 685,
     SECURITY_SYM = 686,
     SELECT_SYM = 687,
     SENSITIVE_SYM = 688,
     SEPARATOR_SYM = 689,
     SERIALIZABLE_SYM = 690,
     SERIAL_SYM = 691,
     SESSION_SYM = 692,
     SERVER_SYM = 693,
     SERVER_OPTIONS = 694,
     SET = 695,
     SET_VAR = 696,
     SHARE_SYM = 697,
     SHIFT_LEFT = 698,
     SHIFT_RIGHT = 699,
     SHOW = 700,
     SHUTDOWN = 701,
     SIGNED_SYM = 702,
     SIMPLE_SYM = 703,
     SLAVE = 704,
     SMALLINT = 705,
     SNAPSHOT_SYM = 706,
     SOCKET_SYM = 707,
     SONAME_SYM = 708,
     SOUNDS_SYM = 709,
     SOURCE_SYM = 710,
     SPATIAL_SYM = 711,
     SPECIFIC_SYM = 712,
     SQLEXCEPTION_SYM = 713,
     SQLSTATE_SYM = 714,
     SQLWARNING_SYM = 715,
     SQL_BIG_RESULT = 716,
     SQL_BUFFER_RESULT = 717,
     SQL_CACHE_SYM = 718,
     SQL_CALC_FOUND_ROWS = 719,
     SQL_NO_CACHE_SYM = 720,
     SQL_SMALL_RESULT = 721,
     SQL_SYM = 722,
     SQL_THREAD = 723,
     SSL_SYM = 724,
     STARTING = 725,
     STARTS_SYM = 726,
     START_SYM = 727,
     STATUS_SYM = 728,
     STDDEV_SAMP_SYM = 729,
     STD_SYM = 730,
     STOP_SYM = 731,
     STORAGE_SYM = 732,
     STRAIGHT_JOIN = 733,
     STRING_SYM = 734,
     SUBDATE_SYM = 735,
     SUBJECT_SYM = 736,
     SUBPARTITIONS_SYM = 737,
     SUBPARTITION_SYM = 738,
     SUBSTRING = 739,
     SUM_SYM = 740,
     SUPER_SYM = 741,
     SUSPEND_SYM = 742,
     SWAPS_SYM = 743,
     SWITCHES_SYM = 744,
     SYSDATE = 745,
     TABLES = 746,
     TABLESPACE = 747,
     TABLE_REF_PRIORITY = 748,
     TABLE_SYM = 749,
     TABLE_CHECKSUM_SYM = 750,
     TEMPORARY = 751,
     TEMPTABLE_SYM = 752,
     TERMINATED = 753,
     TEXT_STRING = 754,
     TEXT_SYM = 755,
     THAN_SYM = 756,
     THEN_SYM = 757,
     TIMESTAMP = 758,
     TIMESTAMP_ADD = 759,
     TIMESTAMP_DIFF = 760,
     TIME_SYM = 761,
     TINYBLOB = 762,
     TINYINT = 763,
     TINYTEXT = 764,
     TO_SYM = 765,
     TRAILING = 766,
     TRANSACTION_SYM = 767,
     TRANSACTIONAL_SYM = 768,
     TRIGGERS_SYM = 769,
     TRIGGER_SYM = 770,
     TRIM = 771,
     TRUE_SYM = 772,
     TRUNCATE_SYM = 773,
     TYPES_SYM = 774,
     TYPE_SYM = 775,
     UDF_RETURNS_SYM = 776,
     ULONGLONG_NUM = 777,
     UNCOMMITTED_SYM = 778,
     UNDEFINED_SYM = 779,
     UNDERSCORE_CHARSET = 780,
     UNDOFILE_SYM = 781,
     UNDO_BUFFER_SIZE_SYM = 782,
     UNDO_SYM = 783,
     UNICODE_SYM = 784,
     UNINSTALL_SYM = 785,
     UNION_SYM = 786,
     UNIQUE_SYM = 787,
     UNKNOWN_SYM = 788,
     UNLOCK_SYM = 789,
     UNSIGNED = 790,
     UNTIL_SYM = 791,
     UPDATE_SYM = 792,
     UPGRADE_SYM = 793,
     USAGE = 794,
     USER = 795,
     USE_FRM = 796,
     USE_SYM = 797,
     USING = 798,
     UTC_DATE_SYM = 799,
     UTC_TIMESTAMP_SYM = 800,
     UTC_TIME_SYM = 801,
     VALUES = 802,
     VALUE_SYM = 803,
     VARBINARY = 804,
     VARCHAR = 805,
     VARIABLES = 806,
     VARIANCE_SYM = 807,
     VARYING = 808,
     VAR_SAMP_SYM = 809,
     VIEW_SYM = 810,
     WAIT_SYM = 811,
     WARNINGS = 812,
     WEEK_SYM = 813,
     WHEN_SYM = 814,
     WHERE = 815,
     WHILE_SYM = 816,
     WITH = 817,
     WORK_SYM = 818,
     WRAPPER_SYM = 819,
     WRITE_SYM = 820,
     X509_SYM = 821,
     XA_SYM = 822,
     XOR = 823,
     YEAR_MONTH_SYM = 824,
     YEAR_SYM = 825,
     ZEROFILL = 826
   };
#endif
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define AT_SYM 277
#define AUTHORS_SYM 278
#define AUTOEXTEND_SIZE_SYM 279
#define AUTO_INC 280
#define AVG_ROW_LENGTH 281
#define AVG_SYM 282
#define BACKUP_SYM 283
#define BEFORE_SYM 284
#define BEGIN_SYM 285
#define BETWEEN_SYM 286
#define BIGINT 287
#define BINARY 288
#define BINLOG_SYM 289
#define BIN_NUM 290
#define BIT_AND 291
#define BIT_OR 292
#define BIT_SYM 293
#define BIT_XOR 294
#define BLOB_SYM 295
#define BLOCK_SYM 296
#define BOOLEAN_SYM 297
#define BOOL_SYM 298
#define BOTH 299
#define BTREE_SYM 300
#define BY 301
#define BYTE_SYM 302
#define CACHE_SYM 303
#define CALL_SYM 304
#define CASCADE 305
#define CASCADED 306
#define CASE_SYM 307
#define CAST_SYM 308
#define CHAIN_SYM 309
#define CHANGE 310
#define CHANGED 311
#define CHARSET 312
#define CHAR_SYM 313
#define CHECKSUM_SYM 314
#define CHECK_SYM 315
#define CIPHER_SYM 316
#define CLIENT_SYM 317
#define CLOSE_SYM 318
#define COALESCE 319
#define CODE_SYM 320
#define COLLATE_SYM 321
#define COLLATION_SYM 322
#define COLUMNS 323
#define COLUMN_SYM 324
#define COMMENT_SYM 325
#define COMMITTED_SYM 326
#define COMMIT_SYM 327
#define COMPACT_SYM 328
#define COMPLETION_SYM 329
#define COMPRESSED_SYM 330
#define CONCURRENT 331
#define CONDITION_SYM 332
#define CONNECTION_SYM 333
#define CONSISTENT_SYM 334
#define CONSTRAINT 335
#define CONTAINS_SYM 336
#define CONTEXT_SYM 337
#define CONTINUE_SYM 338
#define CONTRIBUTORS_SYM 339
#define CONVERT_SYM 340
#define COUNT_SYM 341
#define CPU_SYM 342
#define CREATE 343
#define CROSS 344
#define CUBE_SYM 345
#define CURDATE 346
#define CURRENT_USER 347
#define CURSOR_SYM 348
#define CURTIME 349
#define DATABASE 350
#define DATABASES 351
#define DATAFILE_SYM 352
#define DATA_SYM 353
#define DATETIME 354
#define DATE_ADD_INTERVAL 355
#define DATE_SUB_INTERVAL 356
#define DATE_SYM 357
#define DAY_HOUR_SYM 358
#define DAY_MICROSECOND_SYM 359
#define DAY_MINUTE_SYM 360
#define DAY_SECOND_SYM 361
#define DAY_SYM 362
#define DEALLOCATE_SYM 363
#define DECIMAL_NUM 364
#define DECIMAL_SYM 365
#define DECLARE_SYM 366
#define DEFAULT 367
#define DEFINER_SYM 368
#define DELAYED_SYM 369
#define DELAY_KEY_WRITE_SYM 370
#define DELETE_SYM 371
#define DESC 372
#define DESCRIBE 373
#define DES_KEY_FILE 374
#define DETERMINISTIC_SYM 375
#define DIRECTORY_SYM 376
#define DISABLE_SYM 377
#define DISCARD 378
#define DISK_SYM 379
#define DISTINCT 380
#define DIV_SYM 381
#define DOUBLE_SYM 382
#define DO_SYM 383
#define DROP 384
#define DUAL_SYM 385
#define DUMPFILE 386
#define DUPLICATE_SYM 387
#define DYNAMIC_SYM 388
#define EACH_SYM 389
#define ELSE 390
#define ELSEIF_SYM 391
#define ENABLE_SYM 392
#define ENCLOSED 393
#define END 394
#define ENDS_SYM 395
#define END_OF_INPUT 396
#define ENGINES_SYM 397
#define ENGINE_SYM 398
#define ENUM 399
#define EQ 400
#define EQUAL_SYM 401
#define ERRORS 402
#define ESCAPED 403
#define ESCAPE_SYM 404
#define EVENTS_SYM 405
#define EVENT_SYM 406
#define EVERY_SYM 407
#define EXECUTE_SYM 408
#define EXISTS 409
#define EXIT_SYM 410
#define EXPANSION_SYM 411
#define EXTENDED_SYM 412
#define EXTENT_SIZE_SYM 413
#define EXTRACT_SYM 414
#define FALSE_SYM 415
#define FAST_SYM 416
#define FAULTS_SYM 417
#define FETCH_SYM 418
#define FILE_SYM 419
#define FIRST_SYM 420
#define FIXED_SYM 421
#define FLOAT_NUM 422
#define FLOAT_SYM 423
#define FLUSH_SYM 424
#define FORCE_SYM 425
#define FOREIGN 426
#define FOR_SYM 427
#define FOUND_SYM 428
#define FRAC_SECOND_SYM 429
#define FROM 430
#define FULL 431
#define FULLTEXT_SYM 432
#define FUNCTION_SYM 433
#define GE 434
#define GEOMETRYCOLLECTION 435
#define GEOMETRY_SYM 436
#define GET_FORMAT 437
#define GLOBAL_SYM 438
#define GRANT 439
#define GRANTS 440
#define GROUP_SYM 441
#define GROUP_CONCAT_SYM 442
#define GT_SYM 443
#define HANDLER_SYM 444
#define HASH_SYM 445
#define HAVING 446
#define HELP_SYM 447
#define HEX_NUM 448
#define HIGH_PRIORITY 449
#define HOST_SYM 450
#define HOSTS_SYM 451
#define HOUR_MICROSECOND_SYM 452
#define HOUR_MINUTE_SYM 453
#define HOUR_SECOND_SYM 454
#define HOUR_SYM 455
#define IDENT 456
#define IDENTIFIED_SYM 457
#define IDENT_QUOTED 458
#define IF 459
#define IGNORE_SYM 460
#define IMPORT 461
#define INDEXES 462
#define INDEX_SYM 463
#define INFILE 464
#define INITIAL_SIZE_SYM 465
#define INNER_SYM 466
#define INNOBASE_SYM 467
#define INOUT_SYM 468
#define INSENSITIVE_SYM 469
#define INSERT 470
#define INSERT_METHOD 471
#define INSTALL_SYM 472
#define INTERVAL_SYM 473
#define INTO 474
#define INT_SYM 475
#define INVOKER_SYM 476
#define IN_SYM 477
#define IO_SYM 478
#define IPC_SYM 479
#define IS 480
#define ISOLATION 481
#define ISSUER_SYM 482
#define ITERATE_SYM 483
#define JOIN_SYM 484
#define KEYS 485
#define KEY_BLOCK_SIZE 486
#define KEY_SYM 487
#define KILL_SYM 488
#define LANGUAGE_SYM 489
#define LAST_SYM 490
#define LE 491
#define LEADING 492
#define LEAVES 493
#define LEAVE_SYM 494
#define LEFT 495
#define LESS_SYM 496
#define LEVEL_SYM 497
#define LEX_HOSTNAME 498
#define LIKE 499
#define LIMIT 500
#define LINEAR_SYM 501
#define LINES 502
#define LINESTRING 503
#define LIST_SYM 504
#define LOAD 505
#define LOCAL_SYM 506
#define LOCATOR_SYM 507
#define LOCKS_SYM 508
#define LOCK_SYM 509
#define LOGFILE_SYM 510
#define LOGS_SYM 511
#define LONGBLOB 512
#define LONGTEXT 513
#define LONG_NUM 514
#define LONG_SYM 515
#define LOOP_SYM 516
#define LOW_PRIORITY 517
#define LT 518
#define MASTER_CONNECT_RETRY_SYM 519
#define MASTER_HOST_SYM 520
#define MASTER_LOG_FILE_SYM 521
#define MASTER_LOG_POS_SYM 522
#define MASTER_PASSWORD_SYM 523
#define MASTER_PORT_SYM 524
#define MASTER_SERVER_ID_SYM 525
#define MASTER_SSL_CAPATH_SYM 526
#define MASTER_SSL_CA_SYM 527
#define MASTER_SSL_CERT_SYM 528
#define MASTER_SSL_CIPHER_SYM 529
#define MASTER_SSL_KEY_SYM 530
#define MASTER_SSL_SYM 531
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 532
#define MASTER_SYM 533
#define MASTER_USER_SYM 534
#define MATCH 535
#define MAX_CONNECTIONS_PER_HOUR 536
#define MAX_QUERIES_PER_HOUR 537
#define MAX_ROWS 538
#define MAX_SIZE_SYM 539
#define MAX_SYM 540
#define MAX_UPDATES_PER_HOUR 541
#define MAX_USER_CONNECTIONS_SYM 542
#define MAX_VALUE_SYM 543
#define MEDIUMBLOB 544
#define MEDIUMINT 545
#define MEDIUMTEXT 546
#define MEDIUM_SYM 547
#define MEMORY_SYM 548
#define MERGE_SYM 549
#define MICROSECOND_SYM 550
#define MIGRATE_SYM 551
#define MINUTE_MICROSECOND_SYM 552
#define MINUTE_SECOND_SYM 553
#define MINUTE_SYM 554
#define MIN_ROWS 555
#define MIN_SYM 556
#define MODE_SYM 557
#define MODIFIES_SYM 558
#define MODIFY_SYM 559
#define MOD_SYM 560
#define MONTH_SYM 561
#define MULTILINESTRING 562
#define MULTIPOINT 563
#define MULTIPOLYGON 564
#define MUTEX_SYM 565
#define NAMES_SYM 566
#define NAME_SYM 567
#define NATIONAL_SYM 568
#define NATURAL 569
#define NCHAR_STRING 570
#define NCHAR_SYM 571
#define NDBCLUSTER_SYM 572
#define NE 573
#define NEG 574
#define NEW_SYM 575
#define NEXT_SYM 576
#define NODEGROUP_SYM 577
#define NONE_SYM 578
#define NOT2_SYM 579
#define NOT_SYM 580
#define NOW_SYM 581
#define NO_SYM 582
#define NO_WAIT_SYM 583
#define NO_WRITE_TO_BINLOG 584
#define NULL_SYM 585
#define NUM 586
#define NUMERIC_SYM 587
#define NVARCHAR_SYM 588
#define OFFSET_SYM 589
#define OLD_PASSWORD 590
#define ON 591
#define ONE_SHOT_SYM 592
#define ONE_SYM 593
#define OPEN_SYM 594
#define OPTIMIZE 595
#define OPTIONS_SYM 596
#define OPTION 597
#define OPTIONALLY 598
#define OR2_SYM 599
#define ORDER_SYM 600
#define OR_OR_SYM 601
#define OR_SYM 602
#define OUTER 603
#define OUTFILE 604
#define OUT_SYM 605
#define OWNER_SYM 606
#define PACK_KEYS_SYM 607
#define PAGE_SYM 608
#define PAGE_CHECKSUM_SYM 609
#define PARAM_MARKER 610
#define PARSER_SYM 611
#define PARTIAL 612
#define PARTITIONING_SYM 613
#define PARTITIONS_SYM 614
#define PARTITION_SYM 615
#define PASSWORD 616
#define PHASE_SYM 617
#define PLUGINS_SYM 618
#define PLUGIN_SYM 619
#define POINT_SYM 620
#define POLYGON 621
#define PORT_SYM 622
#define POSITION_SYM 623
#define PRECISION 624
#define PREPARE_SYM 625
#define PRESERVE_SYM 626
#define PREV_SYM 627
#define PRIMARY_SYM 628
#define PRIVILEGES 629
#define PROCEDURE 630
#define PROCESS 631
#define PROCESSLIST_SYM 632
#define PROFILE_SYM 633
#define PROFILES_SYM 634
#define PURGE 635
#define QUARTER_SYM 636
#define QUERY_SYM 637
#define QUICK 638
#define RANGE_SYM 639
#define READS_SYM 640
#define READ_ONLY_SYM 641
#define READ_SYM 642
#define READ_WRITE_SYM 643
#define REAL 644
#define REBUILD_SYM 645
#define RECOVER_SYM 646
#define REDOFILE_SYM 647
#define REDO_BUFFER_SIZE_SYM 648
#define REDUNDANT_SYM 649
#define REFERENCES 650
#define REGEXP 651
#define RELAY_LOG_FILE_SYM 652
#define RELAY_LOG_POS_SYM 653
#define RELAY_THREAD 654
#define RELEASE_SYM 655
#define RELOAD 656
#define REMOVE_SYM 657
#define RENAME 658
#define REORGANIZE_SYM 659
#define REPAIR 660
#define REPEATABLE_SYM 661
#define REPEAT_SYM 662
#define REPLACE 663
#define REPLICATION 664
#define REQUIRE_SYM 665
#define RESET_SYM 666
#define RESOURCES 667
#define RESTORE_SYM 668
#define RESTRICT 669
#define RESUME_SYM 670
#define RETURNS_SYM 671
#define RETURN_SYM 672
#define REVOKE 673
#define RIGHT 674
#define ROLLBACK_SYM 675
#define ROLLUP_SYM 676
#define ROUTINE_SYM 677
#define ROWS_SYM 678
#define ROW_FORMAT_SYM 679
#define ROW_SYM 680
#define RTREE_SYM 681
#define SAVEPOINT_SYM 682
#define SCHEDULE_SYM 683
#define SECOND_MICROSECOND_SYM 684
#define SECOND_SYM 685
#define SECURITY_SYM 686
#define SELECT_SYM 687
#define SENSITIVE_SYM 688
#define SEPARATOR_SYM 689
#define SERIALIZABLE_SYM 690
#define SERIAL_SYM 691
#define SESSION_SYM 692
#define SERVER_SYM 693
#define SERVER_OPTIONS 694
#define SET 695
#define SET_VAR 696
#define SHARE_SYM 697
#define SHIFT_LEFT 698
#define SHIFT_RIGHT 699
#define SHOW 700
#define SHUTDOWN 701
#define SIGNED_SYM 702
#define SIMPLE_SYM 703
#define SLAVE 704
#define SMALLINT 705
#define SNAPSHOT_SYM 706
#define SOCKET_SYM 707
#define SONAME_SYM 708
#define SOUNDS_SYM 709
#define SOURCE_SYM 710
#define SPATIAL_SYM 711
#define SPECIFIC_SYM 712
#define SQLEXCEPTION_SYM 713
#define SQLSTATE_SYM 714
#define SQLWARNING_SYM 715
#define SQL_BIG_RESULT 716
#define SQL_BUFFER_RESULT 717
#define SQL_CACHE_SYM 718
#define SQL_CALC_FOUND_ROWS 719
#define SQL_NO_CACHE_SYM 720
#define SQL_SMALL_RESULT 721
#define SQL_SYM 722
#define SQL_THREAD 723
#define SSL_SYM 724
#define STARTING 725
#define STARTS_SYM 726
#define START_SYM 727
#define STATUS_SYM 728
#define STDDEV_SAMP_SYM 729
#define STD_SYM 730
#define STOP_SYM 731
#define STORAGE_SYM 732
#define STRAIGHT_JOIN 733
#define STRING_SYM 734
#define SUBDATE_SYM 735
#define SUBJECT_SYM 736
#define SUBPARTITIONS_SYM 737
#define SUBPARTITION_SYM 738
#define SUBSTRING 739
#define SUM_SYM 740
#define SUPER_SYM 741
#define SUSPEND_SYM 742
#define SWAPS_SYM 743
#define SWITCHES_SYM 744
#define SYSDATE 745
#define TABLES 746
#define TABLESPACE 747
#define TABLE_REF_PRIORITY 748
#define TABLE_SYM 749
#define TABLE_CHECKSUM_SYM 750
#define TEMPORARY 751
#define TEMPTABLE_SYM 752
#define TERMINATED 753
#define TEXT_STRING 754
#define TEXT_SYM 755
#define THAN_SYM 756
#define THEN_SYM 757
#define TIMESTAMP 758
#define TIMESTAMP_ADD 759
#define TIMESTAMP_DIFF 760
#define TIME_SYM 761
#define TINYBLOB 762
#define TINYINT 763
#define TINYTEXT 764
#define TO_SYM 765
#define TRAILING 766
#define TRANSACTION_SYM 767
#define TRANSACTIONAL_SYM 768
#define TRIGGERS_SYM 769
#define TRIGGER_SYM 770
#define TRIM 771
#define TRUE_SYM 772
#define TRUNCATE_SYM 773
#define TYPES_SYM 774
#define TYPE_SYM 775
#define UDF_RETURNS_SYM 776
#define ULONGLONG_NUM 777
#define UNCOMMITTED_SYM 778
#define UNDEFINED_SYM 779
#define UNDERSCORE_CHARSET 780
#define UNDOFILE_SYM 781
#define UNDO_BUFFER_SIZE_SYM 782
#define UNDO_SYM 783
#define UNICODE_SYM 784
#define UNINSTALL_SYM 785
#define UNION_SYM 786
#define UNIQUE_SYM 787
#define UNKNOWN_SYM 788
#define UNLOCK_SYM 789
#define UNSIGNED 790
#define UNTIL_SYM 791
#define UPDATE_SYM 792
#define UPGRADE_SYM 793
#define USAGE 794
#define USER 795
#define USE_FRM 796
#define USE_SYM 797
#define USING 798
#define UTC_DATE_SYM 799
#define UTC_TIMESTAMP_SYM 800
#define UTC_TIME_SYM 801
#define VALUES 802
#define VALUE_SYM 803
#define VARBINARY 804
#define VARCHAR 805
#define VARIABLES 806
#define VARIANCE_SYM 807
#define VARYING 808
#define VAR_SAMP_SYM 809
#define VIEW_SYM 810
#define WAIT_SYM 811
#define WARNINGS 812
#define WEEK_SYM 813
#define WHEN_SYM 814
#define WHERE 815
#define WHILE_SYM 816
#define WITH 817
#define WORK_SYM 818
#define WRAPPER_SYM 819
#define WRITE_SYM 820
#define X509_SYM 821
#define XA_SYM 822
#define XOR 823
#define YEAR_MONTH_SYM 824
#define YEAR_SYM 825
#define ZEROFILL 826




/* Copy the first part of user declarations.  */
#line 23 "sql_yacc.yy"

/* thd is passed as an argument to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "event_data_objects.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str= {0,0};

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror((char*) (A));                   \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->get_tok_start();
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 461 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  enum ha_choice choice;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 1710 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 506 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 213 of yacc.c.  */
#line 1725 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  550
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   46906

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  591
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  824
/* YYNRULES -- Number of rules. */
#define YYNRULES  2362
/* YYNRULES -- Number of states. */
#define YYNSTATES  4048

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   826

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short int yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   584,     2,     2,     2,   578,   573,     2,
     581,   582,   576,   575,   583,   574,   588,   577,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   590,   589,
       2,     2,     2,     2,   587,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   579,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   585,   572,   586,   580,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   108,   110,   112,   114,   118,   120,
     122,   127,   129,   132,   133,   138,   139,   142,   146,   148,
     151,   152,   156,   157,   163,   165,   169,   173,   177,   181,
     185,   189,   193,   197,   201,   205,   209,   213,   217,   219,
     223,   227,   231,   235,   236,   244,   245,   258,   259,   266,
     267,   271,   276,   281,   285,   288,   299,   301,   305,   308,
     311,   314,   317,   320,   323,   326,   327,   340,   341,   348,
     351,   352,   354,   358,   360,   361,   364,   365,   368,   369,
     371,   375,   380,   381,   384,   385,   388,   390,   392,   394,
     396,   398,   400,   402,   404,   406,   408,   410,   412,   414,
     415,   419,   421,   422,   425,   426,   429,   432,   435,   438,
     441,   445,   449,   451,   453,   455,   458,   462,   466,   467,
     472,   473,   477,   478,   480,   484,   486,   487,   489,   493,
     495,   496,   500,   501,   503,   507,   509,   514,   515,   517,
     519,   521,   522,   526,   529,   533,   534,   538,   539,   545,
     551,   552,   560,   566,   567,   570,   572,   574,   576,   580,
     582,   584,   588,   589,   591,   593,   595,   597,   600,   602,
     604,   608,   609,   612,   614,   616,   618,   620,   622,   624,
     626,   628,   630,   632,   634,   636,   638,   639,   645,   646,
     649,   650,   654,   655,   658,   661,   664,   667,   668,   675,
     678,   679,   682,   684,   686,   690,   691,   692,   693,   701,
     702,   705,   708,   710,   712,   713,   714,   723,   724,   731,
     733,   736,   738,   741,   742,   743,   750,   751,   752,   759,
     760,   763,   764,   770,   771,   773,   774,   780,   781,   784,
     785,   791,   796,   797,   798,   807,   808,   816,   818,   820,
     822,   824,   826,   829,   834,   840,   841,   846,   851,   856,
     860,   864,   867,   870,   871,   874,   876,   879,   883,   885,
     887,   889,   891,   893,   896,   900,   902,   904,   906,   908,
     910,   912,   914,   916,   918,   920,   923,   927,   929,   931,
     933,   935,   937,   939,   941,   944,   948,   950,   952,   954,
     956,   958,   960,   962,   964,   966,   969,   973,   975,   977,
     979,   982,   985,   988,   990,   992,   994,   996,   999,  1003,
    1007,  1011,  1015,  1019,  1023,  1027,  1031,  1036,  1037,  1039,
    1041,  1043,  1045,  1047,  1050,  1054,  1057,  1062,  1068,  1069,
    1075,  1076,  1077,  1083,  1084,  1092,  1093,  1095,  1096,  1100,
    1101,  1105,  1111,  1117,  1118,  1123,  1124,  1128,  1129,  1133,
    1134,  1136,  1137,  1139,  1141,  1145,  1147,  1153,  1159,  1160,
    1163,  1164,  1165,  1173,  1174,  1184,  1186,  1190,  1192,  1194,
    1195,  1198,  1199,  1203,  1205,  1209,  1210,  1217,  1219,  1220,
    1225,  1231,  1233,  1235,  1237,  1241,  1245,  1247,  1251,  1253,
    1255,  1256,  1260,  1262,  1266,  1267,  1272,  1274,  1275,  1277,
    1280,  1282,  1286,  1291,  1295,  1299,  1303,  1308,  1313,  1317,
    1318,  1319,  1326,  1327,  1329,  1330,  1332,  1334,  1337,  1339,
    1341,  1342,  1344,  1346,  1349,  1351,  1352,  1356,  1357,  1359,
    1361,  1364,  1366,  1369,  1373,  1377,  1381,  1385,  1389,  1393,
    1397,  1401,  1405,  1409,  1413,  1417,  1421,  1425,  1429,  1433,
    1439,  1441,  1443,  1447,  1452,  1457,  1460,  1463,  1466,  1470,
    1474,  1478,  1483,  1488,  1490,  1492,  1494,  1496,  1498,  1500,
    1502,  1504,  1506,  1508,  1510,  1512,  1514,  1517,  1519,  1521,
    1523,  1525,  1527,  1531,  1533,  1535,  1538,  1541,  1549,  1558,
    1567,  1570,  1573,  1574,  1576,  1579,  1580,  1582,  1585,  1586,
    1591,  1595,  1599,  1603,  1605,  1610,  1612,  1614,  1620,  1623,
    1629,  1632,  1637,  1639,  1645,  1651,  1656,  1660,  1662,  1664,
    1667,  1669,  1671,  1674,  1676,  1678,  1680,  1683,  1687,  1690,
    1694,  1697,  1700,  1704,  1708,  1712,  1713,  1720,  1721,  1728,
    1731,  1733,  1735,  1737,  1739,  1741,  1743,  1745,  1747,  1749,
    1751,  1753,  1756,  1759,  1761,  1764,  1766,  1769,  1773,  1776,
    1778,  1780,  1782,  1784,  1786,  1788,  1790,  1793,  1794,  1798,
    1800,  1806,  1807,  1809,  1812,  1814,  1816,  1818,  1820,  1821,
    1825,  1826,  1828,  1829,  1831,  1834,  1836,  1838,  1841,  1844,
    1849,  1851,  1855,  1858,  1860,  1863,  1866,  1869,  1872,  1874,
    1877,  1879,  1881,  1883,  1885,  1887,  1888,  1891,  1893,  1895,
    1897,  1899,  1901,  1902,  1905,  1907,  1909,  1910,  1912,  1913,
    1916,  1918,  1921,  1925,  1928,  1929,  1931,  1932,  1934,  1936,
    1939,  1940,  1942,  1943,  1948,  1950,  1955,  1959,  1961,  1962,
    1964,  1967,  1969,  1973,  1977,  1980,  1983,  1986,  1988,  1990,
    1993,  1996,  1999,  2001,  2004,  2007,  2010,  2013,  2015,  2017,
    2018,  2020,  2022,  2024,  2026,  2027,  2029,  2031,  2033,  2034,
    2036,  2039,  2040,  2042,  2044,  2047,  2050,  2053,  2055,  2059,
    2063,  2065,  2067,  2069,  2074,  2077,  2079,  2084,  2085,  2087,
    2088,  2091,  2093,  2097,  2098,  2105,  2106,  2112,  2120,  2121,
    2127,  2128,  2134,  2135,  2141,  2142,  2147,  2148,  2159,  2163,
    2168,  2172,  2176,  2184,  2185,  2189,  2191,  2196,  2197,  2201,
    2202,  2205,  2206,  2208,  2209,  2212,  2215,  2218,  2221,  2223,
    2225,  2227,  2231,  2236,  2237,  2244,  2249,  2250,  2256,  2257,
    2264,  2269,  2271,  2274,  2276,  2278,  2279,  2285,  2286,  2290,
    2293,  2294,  2300,  2301,  2302,  2309,  2311,  2315,  2317,  2319,
    2323,  2326,  2330,  2333,  2338,  2339,  2346,  2347,  2348,  2357,
    2362,  2367,  2371,  2375,  2378,  2381,  2388,  2394,  2398,  2404,
    2406,  2408,  2410,  2411,  2413,  2414,  2416,  2417,  2419,  2421,
    2422,  2425,  2427,  2428,  2430,  2432,  2434,  2435,  2441,  2445,
    2446,  2452,  2456,  2460,  2461,  2465,  2466,  2469,  2471,  2475,
    2476,  2478,  2480,  2481,  2484,  2486,  2490,  2491,  2498,  2499,
    2506,  2507,  2513,  2514,  2516,  2518,  2519,  2526,  2527,  2529,
    2531,  2534,  2536,  2538,  2540,  2541,  2547,  2550,  2551,  2557,
    2558,  2560,  2562,  2565,  2567,  2569,  2571,  2573,  2575,  2578,
    2579,  2585,  2586,  2588,  2590,  2591,  2596,  2601,  2605,  2611,
    2613,  2617,  2621,  2627,  2629,  2633,  2636,  2638,  2640,  2641,
    2648,  2650,  2654,  2658,  2659,  2662,  2663,  2668,  2669,  2672,
    2674,  2677,  2682,  2685,  2689,  2690,  2694,  2695,  2696,  2703,
    2706,  2708,  2710,  2713,  2716,  2725,  2730,  2731,  2733,  2736,
    2738,  2740,  2742,  2744,  2746,  2748,  2750,  2752,  2754,  2756,
    2758,  2759,  2762,  2767,  2771,  2773,  2775,  2780,  2781,  2782,
    2784,  2786,  2787,  2790,  2793,  2795,  2797,  2798,  2801,  2805,
    2809,  2813,  2816,  2820,  2825,  2829,  2834,  2838,  2843,  2845,
    2849,  2854,  2858,  2862,  2869,  2871,  2877,  2884,  2890,  2898,
    2905,  2914,  2920,  2927,  2932,  2937,  2943,  2947,  2952,  2954,
    2958,  2962,  2966,  2970,  2974,  2978,  2984,  2990,  2994,  2998,
    3002,  3006,  3010,  3014,  3016,  3018,  3020,  3022,  3024,  3026,
    3028,  3030,  3032,  3034,  3036,  3038,  3040,  3042,  3044,  3046,
    3048,  3050,  3052,  3054,  3056,  3058,  3062,  3064,  3066,  3068,
    3070,  3074,  3077,  3080,  3083,  3086,  3090,  3094,  3100,  3107,
    3112,  3117,  3125,  3128,  3135,  3141,  3148,  3155,  3160,  3165,
    3171,  3176,  3183,  3186,  3191,  3196,  3201,  3212,  3219,  3228,
    3235,  3240,  3245,  3252,  3257,  3262,  3267,  3274,  3279,  3287,
    3295,  3303,  3310,  3317,  3324,  3331,  3335,  3340,  3347,  3356,
    3359,  3362,  3367,  3376,  3385,  3392,  3399,  3402,  3407,  3414,
    3421,  3430,  3439,  3446,  3455,  3462,  3465,  3470,  3479,  3488,
    3491,  3494,  3497,  3502,  3507,  3512,  3517,  3521,  3530,  3535,
    3542,  3547,  3552,  3557,  3564,  3573,  3580,  3585,  3592,  3594,
    3601,  3606,  3611,  3616,  3621,  3626,  3633,  3638,  3639,  3645,
    3652,  3655,  3659,  3660,  3665,  3666,  3670,  3671,  3673,  3675,
    3679,  3684,  3689,  3695,  3700,  3705,  3710,  3716,  3721,  3722,
    3723,  3731,  3736,  3742,  3747,  3753,  3758,  3763,  3768,  3773,
    3778,  3784,  3785,  3794,  3795,  3799,  3803,  3805,  3810,  3811,
    3813,  3814,  3817,  3818,  3820,  3821,  3825,  3828,  3832,  3835,
    3837,  3840,  3842,  3845,  3847,  3849,  3851,  3854,  3855,  3857,
    3859,  3863,  3865,  3869,  3871,  3875,  3876,  3878,  3879,  3882,
    3887,  3893,  3895,  3897,  3899,  3901,  3906,  3908,  3912,  3916,
    3920,  3921,  3928,  3929,  3936,  3937,  3946,  3951,  3952,  3961,
    3962,  3973,  3980,  3981,  3990,  3991,  4002,  4009,  4011,  4014,
    4017,  4018,  4023,  4027,  4034,  4035,  4039,  4040,  4041,  4047,
    4048,  4050,  4051,  4053,  4054,  4057,  4061,  4065,  4067,  4069,
    4070,  4078,  4079,  4087,  4089,  4092,  4093,  4094,  4097,  4098,
    4101,  4102,  4104,  4106,  4108,  4110,  4114,  4116,  4120,  4122,
    4124,  4126,  4128,  4130,  4132,  4134,  4136,  4138,  4140,  4142,
    4144,  4146,  4148,  4150,  4152,  4154,  4156,  4158,  4160,  4162,
    4164,  4166,  4168,  4170,  4172,  4174,  4175,  4177,  4179,  4180,
    4183,  4184,  4186,  4187,  4188,  4192,  4193,  4194,  4198,  4201,
    4202,  4203,  4208,  4213,  4216,  4217,  4220,  4223,  4227,  4231,
    4233,  4236,  4237,  4239,  4240,  4245,  4250,  4253,  4254,  4256,
    4258,  4259,  4261,  4262,  4264,  4267,  4269,  4273,  4277,  4279,
    4281,  4283,  4285,  4286,  4289,  4291,  4293,  4295,  4297,  4299,
    4301,  4303,  4305,  4307,  4309,  4311,  4313,  4315,  4317,  4319,
    4321,  4323,  4325,  4327,  4329,  4331,  4333,  4335,  4337,  4339,
    4340,  4341,  4348,  4349,  4351,  4355,  4357,  4361,  4362,  4365,
    4369,  4371,  4374,  4376,  4377,  4381,  4382,  4388,  4391,  4393,
    4394,  4398,  4405,  4406,  4413,  4418,  4425,  4430,  4435,  4440,
    4446,  4451,  4456,  4462,  4469,  4474,  4476,  4480,  4482,  4484,
    4488,  4490,  4491,  4494,  4495,  4497,  4498,  4499,  4508,  4509,
    4510,  4517,  4518,  4520,  4522,  4524,  4526,  4528,  4531,  4533,
    4535,  4537,  4541,  4546,  4547,  4551,  4555,  4557,  4560,  4563,
    4564,  4568,  4569,  4575,  4579,  4581,  4585,  4587,  4591,  4593,
    4595,  4596,  4598,  4599,  4604,  4605,  4607,  4611,  4613,  4615,
    4617,  4618,  4619,  4626,  4627,  4628,  4640,  4644,  4646,  4650,
    4654,  4656,  4660,  4661,  4663,  4664,  4669,  4670,  4677,  4678,
    4684,  4685,  4692,  4694,  4698,  4702,  4708,  4709,  4712,  4713,
    4716,  4718,  4720,  4722,  4726,  4727,  4729,  4730,  4732,  4734,
    4738,  4740,  4742,  4745,  4748,  4751,  4753,  4755,  4757,  4759,
    4760,  4764,  4765,  4769,  4772,  4777,  4782,  4786,  4791,  4796,
    4799,  4801,  4805,  4809,  4816,  4833,  4836,  4839,  4840,  4847,
    4853,  4856,  4859,  4862,  4864,  4866,  4868,  4874,  4880,  4883,
    4886,  4888,  4893,  4897,  4900,  4903,  4906,  4910,  4913,  4916,
    4918,  4922,  4927,  4931,  4935,  4938,  4941,  4945,  4949,  4953,
    4957,  4961,  4965,  4969,  4973,  4975,  4977,  4979,  4981,  4983,
    4984,  4986,  4987,  4990,  4991,  4993,  4995,  4997,  4998,  5001,
    5002,  5005,  5006,  5009,  5012,  5013,  5018,  5019,  5024,  5026,
    5028,  5029,  5031,  5033,  5034,  5036,  5038,  5039,  5044,  5048,
    5050,  5051,  5055,  5060,  5063,  5065,  5067,  5069,  5071,  5073,
    5075,  5077,  5079,  5080,  5082,  5083,  5087,  5091,  5093,  5095,
    5097,  5100,  5101,  5105,  5109,  5112,  5115,  5119,  5120,  5122,
    5124,  5127,  5128,  5133,  5139,  5140,  5141,  5142,  5143,  5162,
    5165,  5166,  5168,  5169,  5171,  5173,  5174,  5176,  5178,  5179,
    5182,  5185,  5187,  5191,  5196,  5200,  5204,  5205,  5208,  5211,
    5213,  5217,  5221,  5222,  5226,  5227,  5231,  5234,  5238,  5240,
    5242,  5245,  5246,  5249,  5251,  5253,  5256,  5259,  5261,  5263,
    5265,  5267,  5269,  5272,  5275,  5277,  5279,  5281,  5283,  5285,
    5287,  5289,  5292,  5295,  5298,  5301,  5304,  5306,  5308,  5310,
    5312,  5314,  5316,  5318,  5322,  5328,  5330,  5332,  5334,  5336,
    5338,  5342,  5347,  5353,  5355,  5361,  5365,  5368,  5370,  5374,
    5377,  5379,  5381,  5383,  5385,  5387,  5389,  5391,  5393,  5395,
    5397,  5399,  5401,  5403,  5405,  5409,  5412,  5414,  5416,  5418,
    5420,  5422,  5424,  5426,  5428,  5430,  5432,  5434,  5436,  5438,
    5440,  5442,  5444,  5446,  5448,  5450,  5452,  5454,  5456,  5458,
    5460,  5462,  5464,  5466,  5468,  5470,  5472,  5474,  5476,  5478,
    5480,  5482,  5484,  5486,  5488,  5490,  5492,  5494,  5496,  5498,
    5500,  5502,  5504,  5506,  5508,  5510,  5512,  5514,  5516,  5518,
    5520,  5522,  5524,  5526,  5528,  5530,  5532,  5534,  5536,  5538,
    5540,  5542,  5544,  5546,  5548,  5550,  5552,  5554,  5556,  5558,
    5560,  5562,  5564,  5566,  5568,  5570,  5572,  5574,  5576,  5578,
    5580,  5582,  5584,  5586,  5588,  5590,  5592,  5594,  5596,  5598,
    5600,  5602,  5604,  5606,  5608,  5610,  5612,  5614,  5616,  5618,
    5620,  5622,  5624,  5626,  5628,  5630,  5632,  5634,  5636,  5638,
    5640,  5642,  5644,  5646,  5648,  5650,  5652,  5654,  5656,  5658,
    5660,  5662,  5664,  5666,  5668,  5670,  5672,  5674,  5676,  5678,
    5680,  5682,  5684,  5686,  5688,  5690,  5692,  5694,  5696,  5698,
    5700,  5702,  5704,  5706,  5708,  5710,  5712,  5714,  5716,  5718,
    5720,  5722,  5724,  5726,  5728,  5730,  5732,  5734,  5736,  5738,
    5740,  5742,  5744,  5746,  5748,  5750,  5752,  5754,  5756,  5758,
    5760,  5762,  5764,  5766,  5768,  5770,  5772,  5774,  5776,  5778,
    5780,  5782,  5784,  5786,  5788,  5790,  5792,  5794,  5796,  5798,
    5800,  5802,  5804,  5806,  5808,  5810,  5812,  5814,  5816,  5818,
    5820,  5822,  5824,  5826,  5828,  5830,  5832,  5834,  5836,  5838,
    5840,  5842,  5844,  5846,  5848,  5850,  5852,  5854,  5856,  5858,
    5860,  5862,  5864,  5866,  5868,  5870,  5872,  5874,  5876,  5878,
    5880,  5882,  5884,  5886,  5888,  5890,  5892,  5894,  5896,  5898,
    5900,  5902,  5904,  5906,  5908,  5910,  5912,  5914,  5916,  5918,
    5920,  5922,  5924,  5926,  5928,  5930,  5932,  5934,  5936,  5938,
    5940,  5942,  5944,  5946,  5948,  5950,  5952,  5954,  5956,  5958,
    5960,  5962,  5964,  5966,  5968,  5970,  5972,  5974,  5976,  5978,
    5980,  5982,  5984,  5986,  5988,  5990,  5992,  5994,  5996,  5998,
    6000,  6002,  6004,  6006,  6008,  6010,  6012,  6014,  6016,  6018,
    6020,  6022,  6024,  6026,  6028,  6030,  6032,  6034,  6036,  6037,
    6042,  6043,  6045,  6047,  6051,  6052,  6055,  6057,  6059,  6061,
    6063,  6064,  6066,  6067,  6069,  6071,  6073,  6074,  6077,  6080,
    6083,  6085,  6088,  6093,  6099,  6104,  6111,  6114,  6118,  6122,
    6126,  6132,  6134,  6138,  6142,  6145,  6148,  6151,  6153,  6155,
    6160,  6165,  6167,  6169,  6171,  6173,  6175,  6176,  6181,  6183,
    6185,  6187,  6191,  6195,  6197,  6199,  6202,  6205,  6206,  6210,
    6215,  6219,  6220,  6228,  6230,  6233,  6235,  6237,  6239,  6241,
    6243,  6245,  6246,  6252,  6254,  6256,  6258,  6260,  6262,  6266,
    6273,  6280,  6287,  6295,  6299,  6308,  6317,  6326,  6327,  6329,
    6331,  6334,  6335,  6337,  6339,  6343,  6344,  6348,  6349,  6353,
    6354,  6358,  6359,  6363,  6365,  6367,  6369,  6371,  6373,  6375,
    6377,  6379,  6381,  6383,  6385,  6388,  6391,  6393,  6397,  6400,
    6403,  6406,  6409,  6412,  6415,  6418,  6421,  6423,  6425,  6426,
    6428,  6432,  6434,  6437,  6440,  6443,  6445,  6449,  6453,  6455,
    6457,  6461,  6463,  6467,  6472,  6478,  6480,  6481,  6485,  6489,
    6491,  6493,  6494,  6497,  6500,  6503,  6506,  6507,  6510,  6513,
    6515,  6518,  6521,  6524,  6527,  6530,  6531,  6535,  6536,  6538,
    6539,  6543,  6546,  6547,  6549,  6552,  6553,  6555,  6560,  6565,
    6571,  6574,  6578,  6579,  6581,  6582,  6587,  6588,  6590,  6592,
    6593,  6596,  6599,  6601,  6602,  6604,  6606,  6607,  6613,  6620,
    6621,  6622,  6625,  6628,  6632,  6634,  6636,  6638,  6640,  6642,
    6644,  6646,  6648,  6650,  6652,  6654,  6656,  6658,  6659,  6663,
    6665,  6668,  6670,  6673,  6677,  6681,  6685,  6686,  6690,  6694,
    6695,  6703,  6704,  6708,  6710,  6714,  6715,  6719,  6722,  6727,
    6728,  6732,  6737,  6742,  6743,  6744,  6745,  6762,  6771,  6779,
    6780,  6781,  6782,  6783,  6784,  6800,  6801,  6802,  6803,  6804,
    6817,  6822,  6827,  6831,  6836,  6840,  6843,  6845,  6849,  6855,
    6857,  6859,  6860,  6862,  6864,  6865,  6868,  6869,  6870,  6874,
    6875,  6878,  6884
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     592,     0,    -1,   141,    -1,   593,   141,    -1,   594,    -1,
    1349,    -1,   906,    -1,   967,    -1,   957,    -1,   969,    -1,
     639,    -1,   606,    -1,   970,    -1,   959,    -1,  1355,    -1,
     611,    -1,   595,    -1,  1191,    -1,  1221,    -1,  1145,    -1,
    1147,    -1,   599,    -1,  1227,    -1,  1324,    -1,  1315,    -1,
     604,    -1,  1155,    -1,  1413,    -1,  1241,    -1,  1244,    -1,
    1307,    -1,   975,    -1,   983,    -1,   771,    -1,   987,    -1,
     597,    -1,  1237,    -1,  1358,    -1,   978,    -1,   962,    -1,
    1158,    -1,  1233,    -1,   955,    -1,  1322,    -1,  1356,    -1,
    1357,    -1,   995,    -1,  1290,    -1,  1208,    -1,   944,    -1,
     947,    -1,  1202,    -1,  1414,    -1,  1313,    -1,  1183,    -1,
    1243,    -1,  1405,    -1,   596,   370,  1284,    -1,   108,    -1,
     129,    -1,   370,  1284,   175,   598,    -1,  1281,    -1,   587,
    1286,    -1,    -1,   153,  1284,   600,   601,    -1,    -1,   543,
     602,    -1,   602,   583,   603,    -1,   603,    -1,   587,  1286,
      -1,    -1,   192,   605,  1286,    -1,    -1,    55,   278,   510,
     607,   608,    -1,   609,    -1,   608,   583,   609,    -1,   265,
     145,  1281,    -1,   279,   145,  1281,    -1,   268,   145,  1281,
      -1,   269,   145,  1125,    -1,   264,   145,  1125,    -1,   276,
     145,  1125,    -1,   272,   145,  1281,    -1,   271,   145,  1281,
      -1,   273,   145,  1281,    -1,   274,   145,  1281,    -1,   275,
     145,  1281,    -1,   277,   145,  1125,    -1,   610,    -1,   266,
     145,  1281,    -1,   267,   145,  1127,    -1,   397,   145,  1281,
      -1,   398,   145,  1125,    -1,    -1,    88,   819,   494,   822,
    1278,   612,   762,    -1,    -1,    88,   893,   208,  1284,   895,
     336,  1278,   613,   581,   901,   582,   896,    -1,    -1,    88,
      95,   822,  1284,   614,   816,    -1,    -1,    88,   615,  1371,
      -1,    88,   540,   632,  1340,    -1,    88,   255,   186,   725,
      -1,    88,   492,   722,    -1,    88,   616,    -1,   438,  1286,
     171,    98,   564,  1286,   341,   581,   617,   582,    -1,   618,
      -1,   617,   583,   618,    -1,   540,  1281,    -1,   195,  1281,
      -1,    95,  1281,    -1,   351,  1281,    -1,   361,  1281,    -1,
     452,  1281,    -1,   367,  1125,    -1,    -1,   151,   822,   633,
     620,   336,   428,   621,   626,   623,   628,   128,   629,    -1,
      -1,   152,  1016,  1096,   622,   624,   625,    -1,    22,  1016,
      -1,    -1,   137,    -1,   122,   336,   449,    -1,   122,    -1,
      -1,   471,  1016,    -1,    -1,   140,  1016,    -1,    -1,   627,
      -1,   336,    74,   371,    -1,   336,    74,   325,   371,    -1,
      -1,    70,  1281,    -1,    -1,   630,   631,    -1,   671,    -1,
     673,    -1,   669,    -1,   690,    -1,   708,    -1,   710,    -1,
     705,    -1,   675,    -1,   677,    -1,   678,    -1,   679,    -1,
     680,    -1,   682,    -1,    -1,  1284,   588,  1284,    -1,  1284,
      -1,    -1,   634,   636,    -1,    -1,   635,   637,    -1,    70,
    1281,    -1,   234,   467,    -1,   327,   467,    -1,    81,   467,
      -1,   385,   467,    98,    -1,   303,   467,    98,    -1,   638,
      -1,   636,    -1,   120,    -1,  1022,   120,    -1,   467,   431,
     113,    -1,   467,   431,   221,    -1,    -1,    49,   633,   640,
     641,    -1,    -1,   581,   642,   582,    -1,    -1,   643,    -1,
     643,   583,  1016,    -1,  1016,    -1,    -1,   645,    -1,   645,
     583,   647,    -1,   647,    -1,    -1,  1284,   646,   845,    -1,
      -1,   649,    -1,   649,   583,   650,    -1,   650,    -1,   651,
     646,  1284,   845,    -1,    -1,   222,    -1,   350,    -1,   213,
      -1,    -1,   652,   668,   589,    -1,   668,   589,    -1,   653,
     668,   589,    -1,    -1,   654,   655,   589,    -1,    -1,   111,
     666,   656,   845,   667,    -1,   111,  1284,    77,   172,   663,
      -1,    -1,   111,   660,   189,   172,   657,   661,   668,    -1,
     111,  1284,    93,   172,   658,    -1,    -1,   659,   995,    -1,
     155,    -1,    83,    -1,   662,    -1,   661,   583,   662,    -1,
     665,    -1,  1125,    -1,   459,   664,  1282,    -1,    -1,   548,
      -1,   663,    -1,  1284,    -1,   460,    -1,  1022,   173,    -1,
     458,    -1,  1284,    -1,   666,   583,  1284,    -1,    -1,   112,
    1016,    -1,   671,    -1,   673,    -1,   669,    -1,   690,    -1,
     708,    -1,   710,    -1,   705,    -1,   675,    -1,   677,    -1,
     678,    -1,   679,    -1,   680,    -1,   682,    -1,    -1,   204,
     670,   685,   139,   204,    -1,    -1,   672,   594,    -1,    -1,
     417,   674,  1016,    -1,    -1,   676,   714,    -1,   239,  1285,
      -1,   228,  1285,    -1,   339,  1284,    -1,    -1,   163,   683,
    1284,   219,   681,   684,    -1,    63,  1284,    -1,    -1,   321,
     175,    -1,   175,    -1,  1284,    -1,   684,   583,  1284,    -1,
      -1,    -1,    -1,   686,  1016,   502,   687,   653,   688,   689,
      -1,    -1,   136,   685,    -1,   135,   653,    -1,   691,    -1,
     694,    -1,    -1,    -1,    52,   692,  1016,   693,   696,   704,
     139,    52,    -1,    -1,    52,   695,   697,   704,   139,    52,
      -1,   698,    -1,   696,   698,    -1,   701,    -1,   697,   701,
      -1,    -1,    -1,   559,   699,  1016,   700,   502,   653,    -1,
      -1,    -1,   559,   702,  1016,   703,   502,   653,    -1,    -1,
     135,   653,    -1,    -1,  1285,   590,   706,   714,   707,    -1,
      -1,  1285,    -1,    -1,  1285,   590,   709,   712,   707,    -1,
      -1,   711,   712,    -1,    -1,    30,   713,   654,   652,   139,
      -1,   261,   653,   139,   261,    -1,    -1,    -1,   561,   715,
    1016,   128,   716,   653,   139,   561,    -1,    -1,   407,   653,
     536,   717,  1016,   139,   407,    -1,    29,    -1,     8,    -1,
     215,    -1,   537,    -1,   116,    -1,   747,   749,    -1,   747,
      55,   744,   728,    -1,   747,     6,   744,   723,   732,    -1,
      -1,   542,   255,   186,  1284,    -1,   747,     6,   744,   735,
      -1,   747,   129,   744,   735,    -1,   748,   727,   738,    -1,
     748,   727,   741,    -1,     6,   745,    -1,     6,   746,    -1,
      -1,   729,   730,    -1,   731,    -1,   730,   731,    -1,   730,
     583,   731,    -1,   750,    -1,   751,    -1,   752,    -1,   733,
      -1,   734,    -1,   733,   734,    -1,   733,   583,   734,    -1,
     750,    -1,   751,    -1,   752,    -1,   753,    -1,   756,    -1,
     758,    -1,   760,    -1,   757,    -1,   736,    -1,   737,    -1,
     736,   737,    -1,   736,   583,   737,    -1,   750,    -1,   751,
      -1,   752,    -1,   758,    -1,   760,    -1,   739,    -1,   740,
      -1,   739,   740,    -1,   739,   583,   740,    -1,   750,    -1,
     754,    -1,   755,    -1,   756,    -1,   758,    -1,   760,    -1,
     757,    -1,   742,    -1,   743,    -1,   742,   743,    -1,   742,
     583,   743,    -1,   750,    -1,   758,    -1,   760,    -1,    97,
    1281,    -1,   526,  1281,    -1,   392,  1281,    -1,  1284,    -1,
    1284,    -1,   386,    -1,   388,    -1,   325,     4,    -1,   210,
    1175,   761,    -1,    24,  1175,   761,    -1,   284,  1175,   761,
      -1,   158,  1175,   761,    -1,   527,  1175,   761,    -1,   393,
    1175,   761,    -1,   322,  1175,  1126,    -1,    70,  1175,  1281,
      -1,  1214,   143,  1175,   829,    -1,    -1,   760,    -1,   556,
      -1,   328,    -1,  1126,    -1,   201,    -1,   581,   763,    -1,
     823,   768,   765,    -1,   244,  1278,    -1,   581,   244,  1278,
     582,    -1,   835,   582,   823,   768,   765,    -1,    -1,   768,
     812,   582,   764,  1362,    -1,    -1,    -1,  1253,   815,   812,
     766,  1359,    -1,    -1,  1253,   815,   581,   812,   582,   767,
    1362,    -1,    -1,   769,    -1,    -1,   360,   770,   773,    -1,
      -1,   360,   772,   773,    -1,    46,   774,   784,   785,   792,
      -1,   778,   232,   581,   779,   582,    -1,    -1,   778,   190,
     775,   782,    -1,    -1,   384,   776,   782,    -1,    -1,   249,
     777,   782,    -1,    -1,   246,    -1,    -1,   780,    -1,   781,
      -1,   780,   583,   781,    -1,  1284,    -1,   581,  1011,   790,
    1012,   582,    -1,   581,  1011,   790,  1012,   582,    -1,    -1,
     359,  1126,    -1,    -1,    -1,   483,    46,   778,   190,   783,
     786,   791,    -1,    -1,   483,    46,   778,   232,   581,   788,
     582,   787,   791,    -1,   789,    -1,   788,   583,   789,    -1,
    1284,    -1,  1019,    -1,    -1,   482,  1126,    -1,    -1,   581,
     793,   582,    -1,   794,    -1,   793,   583,   794,    -1,    -1,
     360,   795,   796,   797,   809,   804,    -1,  1284,    -1,    -1,
     547,   241,   501,   798,    -1,   547,   222,   581,   801,   582,
      -1,   799,    -1,   800,    -1,   288,    -1,   581,   288,   582,
      -1,   581,   803,   582,    -1,   802,    -1,   801,   583,   802,
      -1,   803,    -1,  1019,    -1,    -1,   581,   805,   582,    -1,
     806,    -1,   805,   583,   806,    -1,    -1,   483,   807,   808,
     809,    -1,  1286,    -1,    -1,   810,    -1,   810,   811,    -1,
     811,    -1,   492,  1175,  1286,    -1,  1214,   143,  1175,   829,
      -1,   322,  1175,  1126,    -1,   283,  1175,  1128,    -1,   300,
    1175,  1128,    -1,    98,   121,  1175,  1281,    -1,   208,   121,
    1175,  1281,    -1,    70,  1175,  1281,    -1,    -1,    -1,   432,
     813,  1005,  1009,   814,   833,    -1,    -1,    18,    -1,    -1,
     817,    -1,   818,    -1,   817,   818,    -1,   828,    -1,   827,
      -1,    -1,   820,    -1,   821,    -1,   821,   820,    -1,   496,
      -1,    -1,   204,  1022,   154,    -1,    -1,   825,    -1,   826,
      -1,   826,   824,    -1,   826,    -1,   826,   825,    -1,   826,
     583,   825,    -1,   143,  1175,   829,    -1,   520,  1175,   829,
      -1,   283,  1175,  1127,    -1,   300,  1175,  1127,    -1,    26,
    1175,  1125,    -1,   361,  1175,  1281,    -1,    70,  1175,  1281,
      -1,    25,  1175,  1127,    -1,   352,  1175,  1125,    -1,   352,
    1175,   112,    -1,    59,  1175,  1125,    -1,   495,  1175,  1125,
      -1,   354,  1175,  1131,    -1,   115,  1175,  1125,    -1,   424,
    1175,   831,    -1,   531,  1175,   581,  1232,   582,    -1,   827,
      -1,   828,    -1,   216,  1175,   832,    -1,    98,   121,  1175,
    1281,    -1,   208,   121,  1175,  1281,    -1,   492,  1284,    -1,
     477,   124,    -1,   477,   293,    -1,    78,  1175,  1281,    -1,
     231,  1175,  1125,    -1,   513,  1175,  1131,    -1,   875,   866,
    1175,   868,    -1,   875,    66,  1175,   874,    -1,  1286,    -1,
    1286,    -1,   112,    -1,   166,    -1,   133,    -1,    75,    -1,
     394,    -1,    73,    -1,   353,    -1,   327,    -1,   165,    -1,
     235,    -1,  1120,    -1,  1004,  1008,    -1,   479,    -1,   389,
      -1,   110,    -1,   220,    -1,   836,    -1,   835,   583,   836,
      -1,   837,    -1,   838,    -1,   843,   839,    -1,   843,   880,
      -1,   888,   903,   895,   581,   901,   582,   896,    -1,   841,
     889,   903,   895,   581,   901,   582,   896,    -1,   841,   171,
     232,   903,   581,   901,   582,   880,    -1,   842,   839,    -1,
     841,   840,    -1,    -1,   840,    -1,    60,  1016,    -1,    -1,
     842,    -1,    80,   903,    -1,    -1,  1277,   844,   845,   862,
      -1,   853,   860,   857,    -1,   854,   861,   857,    -1,   168,
     855,   857,    -1,    38,    -1,    38,   581,   331,   582,    -1,
      43,    -1,    42,    -1,   849,   581,   331,   582,   876,    -1,
     849,   876,    -1,   850,   581,   331,   582,   877,    -1,   850,
     877,    -1,    33,   581,   331,   582,    -1,    33,    -1,   851,
     581,   331,   582,   876,    -1,   852,   581,   331,   582,   877,
      -1,   549,   581,   331,   582,    -1,   570,   860,   857,    -1,
     102,    -1,   506,    -1,   503,   860,    -1,    99,    -1,   507,
      -1,    40,   860,    -1,   848,    -1,   289,    -1,   257,    -1,
     260,   549,    -1,   260,   851,   876,    -1,   509,   876,    -1,
     500,   860,   876,    -1,   291,   876,    -1,   258,   876,    -1,
     110,   855,   857,    -1,   332,   855,   857,    -1,   166,   855,
     857,    -1,    -1,   144,   846,   581,   905,   582,   876,    -1,
      -1,   440,   847,   581,   905,   582,   876,    -1,   260,   876,
      -1,   436,    -1,   181,    -1,   180,    -1,   365,    -1,   308,
      -1,   248,    -1,   307,    -1,   366,    -1,   309,    -1,    58,
      -1,   316,    -1,   313,    58,    -1,   849,   553,    -1,   550,
      -1,   313,   550,    -1,   333,    -1,   316,   550,    -1,   313,
      58,   553,    -1,   316,   553,    -1,   220,    -1,   508,    -1,
     450,    -1,   290,    -1,    32,    -1,   389,    -1,   127,    -1,
     127,   369,    -1,    -1,   581,   331,   582,    -1,   856,    -1,
     581,   331,   583,   331,   582,    -1,    -1,   858,    -1,   858,
     859,    -1,   859,    -1,   447,    -1,   535,    -1,   571,    -1,
      -1,   581,   331,   582,    -1,    -1,   856,    -1,    -1,   863,
      -1,   863,   864,    -1,   864,    -1,   330,    -1,  1022,   330,
      -1,   112,   865,    -1,   336,   537,   326,  1015,    -1,    25,
      -1,   436,   112,   548,    -1,   879,   232,    -1,   532,    -1,
     532,   232,    -1,    70,  1281,    -1,    66,   872,    -1,   326,
    1015,    -1,  1268,    -1,    58,   440,    -1,    57,    -1,  1286,
      -1,    33,    -1,   867,    -1,   112,    -1,    -1,   866,   868,
      -1,  1286,    -1,    33,    -1,   870,    -1,   112,    -1,  1286,
      -1,    -1,    66,   874,    -1,   872,    -1,   112,    -1,    -1,
     112,    -1,    -1,    20,   877,    -1,    47,    -1,   529,   877,
      -1,   866,   867,   877,    -1,    33,   878,    -1,    -1,    33,
      -1,    -1,    20,    -1,   529,    -1,   866,   867,    -1,    -1,
     373,    -1,    -1,   395,  1278,   881,   882,    -1,   884,    -1,
     581,   883,   582,   884,    -1,   883,   583,  1284,    -1,  1284,
      -1,    -1,   885,    -1,   885,   886,    -1,   886,    -1,   336,
     116,   887,    -1,   336,   537,   887,    -1,   280,   176,    -1,
     280,   357,    -1,   280,   448,    -1,   414,    -1,    50,    -1,
     440,   330,    -1,   327,     5,    -1,   440,   112,    -1,   890,
      -1,   177,   891,    -1,   456,   891,    -1,   373,   232,    -1,
     532,   891,    -1,   232,    -1,   208,    -1,    -1,   890,    -1,
     230,    -1,   208,    -1,   207,    -1,    -1,   532,    -1,   177,
      -1,   456,    -1,    -1,   894,    -1,   894,   898,    -1,    -1,
     897,    -1,   899,    -1,   897,   899,    -1,   543,   900,    -1,
     520,   900,    -1,   898,    -1,   231,  1175,  1125,    -1,   562,
     356,  1280,    -1,    45,    -1,   426,    -1,   190,    -1,   901,
     583,   902,  1118,    -1,   902,  1118,    -1,  1284,    -1,  1284,
     581,   331,   582,    -1,    -1,  1277,    -1,    -1,   588,  1284,
      -1,  1266,    -1,   905,   583,  1266,    -1,    -1,    13,   940,
     494,  1278,   907,   918,    -1,    -1,    13,    95,   917,   908,
     817,    -1,    13,    95,  1284,   538,    98,   121,   312,    -1,
      -1,    13,   375,   633,   909,   634,    -1,    -1,    13,   178,
     633,   910,   634,    -1,    -1,    13,  1379,  1374,   911,  1381,
      -1,    -1,    13,  1374,   912,  1381,    -1,    -1,    13,  1374,
     151,   633,   913,   914,   915,   623,   628,   916,    -1,    13,
     492,   724,    -1,    13,   255,   186,   726,    -1,    13,   492,
     721,    -1,    13,   492,   720,    -1,    13,   438,  1286,   341,
     581,   617,   582,    -1,    -1,   336,   428,   621,    -1,   627,
      -1,   336,   428,   621,   627,    -1,    -1,   403,   510,   633,
      -1,    -1,   128,   629,    -1,    -1,  1284,    -1,    -1,   123,
     492,    -1,   206,   492,    -1,   933,   768,    -1,   933,   922,
      -1,   922,    -1,   769,    -1,   924,    -1,   129,   360,   931,
      -1,   390,   360,   977,   923,    -1,    -1,   340,   360,   977,
     923,   919,   977,    -1,    14,   360,   977,   923,    -1,    -1,
      60,   360,   923,   920,   972,    -1,    -1,   405,   360,   977,
     923,   921,   964,    -1,    64,   360,   977,  1126,    -1,   927,
      -1,   402,   358,    -1,    12,    -1,   931,    -1,    -1,     6,
     360,   977,   925,   926,    -1,    -1,   581,   793,   582,    -1,
     359,  1126,    -1,    -1,   404,   360,   977,   928,   929,    -1,
      -1,    -1,   931,   930,   219,   581,   793,   582,    -1,   932,
      -1,   931,   583,   932,    -1,  1284,    -1,   935,    -1,   933,
     583,   935,    -1,     6,   939,    -1,   934,   837,   942,    -1,
       6,   838,    -1,   934,   581,   835,   582,    -1,    -1,    55,
     939,  1277,   936,   843,   942,    -1,    -1,    -1,   304,   939,
    1277,   937,   845,   862,   938,   942,    -1,   129,   939,  1277,
     941,    -1,   129,   171,   232,   903,    -1,   129,   373,   232,
      -1,   129,   890,  1277,    -1,   122,   230,    -1,   137,   230,
      -1,    13,   939,  1277,   440,   112,  1268,    -1,    13,   939,
    1277,   129,   112,    -1,   403,   943,  1278,    -1,    85,   510,
     866,   868,   873,    -1,   824,    -1,   170,    -1,  1111,    -1,
      -1,    69,    -1,    -1,   205,    -1,    -1,   414,    -1,    50,
      -1,    -1,     8,  1284,    -1,   165,    -1,    -1,   510,    -1,
     145,    -1,    18,    -1,    -1,   472,   449,   949,   945,   953,
      -1,   476,   449,   949,    -1,    -1,   449,   472,   949,   946,
     953,    -1,   449,   476,   949,    -1,   472,   512,   948,    -1,
      -1,   562,    79,   451,    -1,    -1,   950,   951,    -1,   952,
      -1,   951,   583,   952,    -1,    -1,   468,    -1,   399,    -1,
      -1,   536,   954,    -1,   610,    -1,   954,   583,   610,    -1,
      -1,   413,  1309,   956,  1149,   175,  1281,    -1,    -1,    28,
    1309,   958,  1149,   510,  1281,    -1,    -1,    59,  1309,   960,
    1149,   961,    -1,    -1,   383,    -1,   157,    -1,    -1,   405,
     977,  1309,   963,  1149,   964,    -1,    -1,   965,    -1,   966,
      -1,   966,   965,    -1,   383,    -1,   157,    -1,   541,    -1,
      -1,    14,   977,  1309,   968,  1149,    -1,    34,  1281,    -1,
      -1,    60,  1309,   971,  1149,   972,    -1,    -1,   973,    -1,
     974,    -1,   974,   973,    -1,   383,    -1,   161,    -1,   292,
      -1,   157,    -1,    56,    -1,   172,   538,    -1,    -1,   340,
     977,  1309,   976,  1149,    -1,    -1,   329,    -1,   251,    -1,
      -1,   403,  1309,   979,   981,    -1,   403,   540,   632,   980,
      -1,  1287,   510,  1287,    -1,   980,   583,  1287,   510,  1287,
      -1,   982,    -1,   981,   583,   982,    -1,  1278,   510,  1278,
      -1,    48,   208,   984,   222,   986,    -1,   985,    -1,   984,
     583,   985,    -1,  1278,   991,    -1,  1284,    -1,   112,    -1,
      -1,   250,   208,   219,    48,   988,   989,    -1,   990,    -1,
     989,   583,   990,    -1,  1278,   991,   994,    -1,    -1,   992,
     993,    -1,    -1,   890,   581,  1092,   582,    -1,    -1,   205,
     238,    -1,   996,    -1,   432,   998,    -1,   581,   997,   582,
    1362,    -1,   432,  1000,    -1,   581,   997,   582,    -1,    -1,
    1000,   999,  1359,    -1,    -1,    -1,  1001,  1005,  1009,  1002,
    1003,  1008,    -1,  1114,  1120,    -1,  1141,    -1,  1004,    -1,
    1141,  1004,    -1,  1004,  1141,    -1,   175,  1060,  1103,  1108,
    1105,  1114,  1120,  1132,    -1,   175,   130,  1103,  1120,    -1,
      -1,  1006,    -1,  1006,  1007,    -1,  1007,    -1,   478,    -1,
     194,    -1,   125,    -1,   466,    -1,   461,    -1,   462,    -1,
     464,    -1,   465,    -1,   463,    -1,    12,    -1,    -1,   172,
     537,    -1,   254,   222,   442,   302,    -1,  1009,   583,  1010,
      -1,  1010,    -1,   576,    -1,  1011,  1013,  1012,  1014,    -1,
      -1,    -1,  1272,    -1,  1016,    -1,    -1,    18,  1284,    -1,
      18,  1281,    -1,  1284,    -1,  1281,    -1,    -1,   581,   582,
      -1,  1016,  1020,  1016,    -1,  1016,   568,  1016,    -1,  1016,
    1021,  1016,    -1,   325,  1016,    -1,  1017,   225,   517,    -1,
    1017,   225,  1022,   517,    -1,  1017,   225,   160,    -1,  1017,
     225,  1022,   160,    -1,  1017,   225,   533,    -1,  1017,   225,
    1022,   533,    -1,  1017,    -1,  1017,   225,   330,    -1,  1017,
     225,  1022,   330,    -1,  1017,   146,  1018,    -1,  1017,  1024,
    1018,    -1,  1017,  1024,  1025,   581,  1368,   582,    -1,  1018,
      -1,  1019,   222,   581,  1368,   582,    -1,  1019,  1022,   222,
     581,  1368,   582,    -1,  1019,   222,   581,  1016,   582,    -1,
    1019,   222,   581,  1016,   583,  1053,   582,    -1,  1019,  1022,
     222,   581,  1016,   582,    -1,  1019,  1022,   222,   581,  1016,
     583,  1053,   582,    -1,  1019,    31,  1019,    16,  1018,    -1,
    1019,  1022,    31,  1019,    16,  1018,    -1,  1019,   454,   244,
    1019,    -1,  1019,   244,  1026,  1107,    -1,  1019,  1022,   244,
    1026,  1107,    -1,  1019,   396,  1019,    -1,  1019,  1022,   396,
    1019,    -1,  1019,    -1,  1019,   572,  1019,    -1,  1019,   573,
    1019,    -1,  1019,   443,  1019,    -1,  1019,   444,  1019,    -1,
    1019,   575,  1019,    -1,  1019,   574,  1019,    -1,  1019,   575,
     218,  1016,  1096,    -1,  1019,   574,   218,  1016,  1096,    -1,
    1019,   576,  1019,    -1,  1019,   577,  1019,    -1,  1019,   578,
    1019,    -1,  1019,   126,  1019,    -1,  1019,   305,  1019,    -1,
    1019,   579,  1019,    -1,  1026,    -1,   347,    -1,   344,    -1,
      16,    -1,    15,    -1,   325,    -1,   324,    -1,   584,    -1,
     324,    -1,   145,    -1,   179,    -1,   188,    -1,   236,    -1,
     263,    -1,   318,    -1,    12,    -1,    17,    -1,  1274,    -1,
    1027,    -1,  1028,    -1,  1031,    -1,  1029,    -1,  1026,    66,
    1286,    -1,  1269,    -1,  1267,    -1,  1043,    -1,  1039,    -1,
    1026,   346,  1026,    -1,   575,  1026,    -1,   574,  1026,    -1,
     580,  1026,    -1,  1023,  1026,    -1,   581,  1368,   582,    -1,
     581,  1016,   582,    -1,   581,  1016,   583,  1053,   582,    -1,
     425,   581,  1016,   583,  1053,   582,    -1,   154,   581,  1368,
     582,    -1,   585,  1284,  1016,   586,    -1,   280,  1054,     9,
     581,  1019,  1033,   582,    -1,    33,  1026,    -1,    53,   581,
    1016,    18,  1051,   582,    -1,    52,  1056,  1058,  1057,   139,
      -1,    85,   581,  1016,   583,  1051,   582,    -1,    85,   581,
    1016,   543,   867,   582,    -1,   112,   581,  1274,   582,    -1,
     547,   581,  1275,   582,    -1,   218,  1016,  1096,   575,  1016,
      -1,    58,   581,  1053,   582,    -1,    58,   581,  1053,   543,
     867,   582,    -1,    92,  1015,    -1,   102,   581,  1016,   582,
      -1,   107,   581,  1016,   582,    -1,   200,   581,  1016,   582,
      -1,   215,   581,  1016,   583,  1016,   583,  1016,   583,  1016,
     582,    -1,   218,   581,  1016,   583,  1016,   582,    -1,   218,
     581,  1016,   583,  1016,   583,  1053,   582,    -1,   240,   581,
    1016,   583,  1016,   582,    -1,   299,   581,  1016,   582,    -1,
     306,   581,  1016,   582,    -1,   419,   581,  1016,   583,  1016,
     582,    -1,   430,   581,  1016,   582,    -1,   506,   581,  1016,
     582,    -1,   503,   581,  1016,   582,    -1,   503,   581,  1016,
     583,  1016,   582,    -1,   516,   581,  1016,   582,    -1,   516,
     581,   237,  1016,   175,  1016,   582,    -1,   516,   581,   511,
    1016,   175,  1016,   582,    -1,   516,   581,    44,  1016,   175,
    1016,   582,    -1,   516,   581,   237,   175,  1016,   582,    -1,
     516,   581,   511,   175,  1016,   582,    -1,   516,   581,    44,
     175,  1016,   582,    -1,   516,   581,  1016,   175,  1016,   582,
      -1,   540,   581,   582,    -1,   570,   581,  1016,   582,    -1,
       7,   581,  1016,   583,  1016,   582,    -1,     7,   581,  1016,
     583,   218,  1016,  1096,   582,    -1,    91,  1015,    -1,    94,
    1015,    -1,    94,   581,  1016,   582,    -1,   100,   581,  1016,
     583,   218,  1016,  1096,   582,    -1,   101,   581,  1016,   583,
     218,  1016,  1096,   582,    -1,   159,   581,  1096,   175,  1016,
     582,    -1,   182,   581,  1099,   583,  1016,   582,    -1,   326,
    1015,    -1,   326,   581,  1016,   582,    -1,   368,   581,  1019,
     222,  1016,   582,    -1,   480,   581,  1016,   583,  1016,   582,
      -1,   480,   581,  1016,   583,   218,  1016,  1096,   582,    -1,
     484,   581,  1016,   583,  1016,   583,  1016,   582,    -1,   484,
     581,  1016,   583,  1016,   582,    -1,   484,   581,  1016,   175,
    1016,   172,  1016,   582,    -1,   484,   581,  1016,   175,  1016,
     582,    -1,   490,  1015,    -1,   490,   581,  1016,   582,    -1,
     504,   581,  1097,   583,  1016,   583,  1016,   582,    -1,   505,
     581,  1097,   583,  1016,   583,  1016,   582,    -1,   544,  1015,
      -1,   546,  1015,    -1,   545,  1015,    -1,    20,   581,  1016,
     582,    -1,    57,   581,  1016,   582,    -1,    64,   581,  1053,
     582,    -1,    67,   581,  1016,   582,    -1,    95,   581,   582,
      -1,   204,   581,  1016,   583,  1016,   583,  1016,   582,    -1,
     295,   581,  1016,   582,    -1,   305,   581,  1016,   583,  1016,
     582,    -1,   335,   581,  1016,   582,    -1,   361,   581,  1016,
     582,    -1,   381,   581,  1016,   582,    -1,   407,   581,  1016,
     583,  1016,   582,    -1,   408,   581,  1016,   583,  1016,   583,
    1016,   582,    -1,   518,   581,  1016,   583,  1016,   582,    -1,
     558,   581,  1016,   582,    -1,   558,   581,  1016,   583,  1016,
     582,    -1,  1030,    -1,    81,   581,  1016,   583,  1016,   582,
      -1,   180,   581,  1053,   582,    -1,   248,   581,  1053,   582,
      -1,   307,   581,  1053,   582,    -1,   308,   581,  1053,   582,
      -1,   309,   581,  1053,   582,    -1,   365,   581,  1016,   583,
    1016,   582,    -1,   366,   581,  1053,   582,    -1,    -1,  1280,
     581,  1032,  1036,   582,    -1,  1284,   588,  1284,   581,  1052,
     582,    -1,  1034,  1035,    -1,   222,    42,   302,    -1,    -1,
     222,   314,   234,   302,    -1,    -1,   562,   382,   156,    -1,
      -1,  1037,    -1,  1038,    -1,  1037,   583,  1038,    -1,  1011,
    1016,  1012,  1014,    -1,    27,   581,  1049,   582,    -1,    27,
     581,   125,  1049,   582,    -1,    36,   581,  1049,   582,    -1,
      37,   581,  1049,   582,    -1,    39,   581,  1049,   582,    -1,
      86,   581,  1102,   576,   582,    -1,    86,   581,  1049,   582,
      -1,    -1,    -1,    86,   581,   125,  1040,  1053,  1041,   582,
      -1,   301,   581,  1049,   582,    -1,   301,   581,   125,  1049,
     582,    -1,   285,   581,  1049,   582,    -1,   285,   581,   125,
    1049,   582,    -1,   475,   581,  1049,   582,    -1,   552,   581,
    1049,   582,    -1,   474,   581,  1049,   582,    -1,   554,   581,
    1049,   582,    -1,   485,   581,  1049,   582,    -1,   485,   581,
     125,  1049,   582,    -1,    -1,   187,   581,  1046,  1042,  1053,
    1048,  1047,   582,    -1,    -1,   587,  1044,  1045,    -1,  1286,
     441,  1016,    -1,  1286,    -1,   587,  1299,  1286,   904,    -1,
      -1,   125,    -1,    -1,   434,  1266,    -1,    -1,  1115,    -1,
      -1,  1102,  1050,  1016,    -1,    33,   860,    -1,    58,   860,
     876,    -1,   316,   860,    -1,   447,    -1,   447,   220,    -1,
     535,    -1,   535,   220,    -1,   102,    -1,   506,    -1,    99,
      -1,   110,   855,    -1,    -1,  1053,    -1,  1016,    -1,  1053,
     583,  1016,    -1,  1055,    -1,   581,  1055,   582,    -1,  1274,
      -1,  1055,   583,  1274,    -1,    -1,  1016,    -1,    -1,   135,
    1016,    -1,   559,  1016,   502,  1016,    -1,  1058,   559,  1016,
     502,  1016,    -1,  1072,    -1,  1063,    -1,  1062,    -1,  1059,
      -1,   585,  1284,  1059,   586,    -1,  1061,    -1,  1062,   583,
    1061,    -1,  1059,  1071,  1059,    -1,  1059,   478,  1072,    -1,
      -1,  1059,  1071,  1059,   336,  1064,  1016,    -1,    -1,  1059,
     478,  1072,   336,  1065,  1016,    -1,    -1,  1059,  1071,  1059,
     543,  1066,   581,  1095,   582,    -1,  1059,   314,   229,  1072,
      -1,    -1,  1059,   240,  1081,   229,  1059,   336,  1067,  1016,
      -1,    -1,  1059,   240,  1081,   229,  1072,  1068,   543,   581,
    1095,   582,    -1,  1059,   314,   240,  1081,   229,  1072,    -1,
      -1,  1059,   419,  1081,   229,  1059,   336,  1069,  1016,    -1,
      -1,  1059,   419,  1081,   229,  1072,  1070,   543,   581,  1095,
     582,    -1,  1059,   314,   419,  1081,   229,  1072,    -1,   229,
      -1,   211,   229,    -1,    89,   229,    -1,    -1,  1073,  1278,
    1101,  1090,    -1,  1080,  1079,  1076,    -1,   581,  1079,  1074,
    1362,   582,  1101,    -1,    -1,  1079,  1075,  1062,    -1,    -1,
      -1,  1077,  1005,  1009,  1078,   833,    -1,    -1,   432,    -1,
      -1,   348,    -1,    -1,   172,   229,    -1,   172,   345,    46,
      -1,   172,   186,    46,    -1,   170,    -1,   205,    -1,    -1,
    1083,   890,  1082,  1085,   581,  1094,   582,    -1,    -1,   542,
     890,  1082,  1086,   581,  1092,   582,    -1,  1084,    -1,  1087,
    1084,    -1,    -1,    -1,  1089,  1087,    -1,    -1,  1091,  1088,
      -1,    -1,  1094,    -1,  1284,    -1,   373,    -1,  1093,    -1,
    1094,   583,  1093,    -1,  1284,    -1,  1095,   583,  1284,    -1,
    1098,    -1,   103,    -1,   104,    -1,   105,    -1,   106,    -1,
     197,    -1,   198,    -1,   199,    -1,   297,    -1,   298,    -1,
     429,    -1,   569,    -1,  1098,    -1,   174,    -1,   107,    -1,
     558,    -1,   200,    -1,   299,    -1,   306,    -1,   381,    -1,
     430,    -1,   295,    -1,   570,    -1,   102,    -1,   506,    -1,
      99,    -1,   503,    -1,    -1,    18,    -1,   145,    -1,    -1,
    1100,  1284,    -1,    -1,    12,    -1,    -1,    -1,   560,  1104,
    1016,    -1,    -1,    -1,   191,  1106,  1016,    -1,   149,  1026,
      -1,    -1,    -1,   186,    46,  1109,  1110,    -1,  1109,   583,
    1273,  1118,    -1,  1273,  1118,    -1,    -1,   562,    90,    -1,
     562,   421,    -1,   345,    46,  1112,    -1,  1112,   583,  1113,
      -1,  1113,    -1,  1275,  1118,    -1,    -1,  1115,    -1,    -1,
     345,    46,  1116,  1117,    -1,  1117,   583,  1273,  1118,    -1,
    1273,  1118,    -1,    -1,    19,    -1,   117,    -1,    -1,  1121,
      -1,    -1,  1121,    -1,   245,  1122,    -1,  1123,    -1,  1123,
     583,  1123,    -1,  1123,   334,  1123,    -1,  1267,    -1,   522,
      -1,   259,    -1,   331,    -1,    -1,   245,  1123,    -1,   331,
      -1,   193,    -1,   259,    -1,   522,    -1,   109,    -1,   167,
      -1,   331,    -1,   193,    -1,   259,    -1,   522,    -1,  1129,
      -1,   331,    -1,   522,    -1,   259,    -1,   109,    -1,   167,
      -1,   331,    -1,   522,    -1,   259,    -1,  1129,    -1,  1130,
      -1,   109,    -1,   167,    -1,  1125,    -1,   112,    -1,    -1,
      -1,   375,  1284,  1133,   581,  1134,   582,    -1,    -1,  1135,
      -1,  1135,   583,  1136,    -1,  1136,    -1,  1011,  1016,  1012,
      -1,    -1,  1138,  1139,    -1,  1139,   583,  1140,    -1,  1140,
      -1,   587,  1286,    -1,  1286,    -1,    -1,   219,  1142,  1143,
      -1,    -1,   349,  1283,  1144,  1254,  1257,    -1,   131,  1283,
      -1,  1137,    -1,    -1,   128,  1146,  1053,    -1,   129,  1154,
    1309,  1153,  1149,   941,    -1,    -1,   129,   208,  1284,   336,
    1278,  1148,    -1,   129,    95,  1153,  1284,    -1,   129,   178,
    1153,  1284,   588,  1284,    -1,   129,   178,  1153,  1284,    -1,
     129,   375,  1153,   633,    -1,   129,   540,   632,  1339,    -1,
     129,   555,  1153,  1149,   941,    -1,   129,   151,  1153,   633,
      -1,   129,   515,  1153,   633,    -1,   129,   492,   747,   758,
     759,    -1,   129,   255,   186,   748,   758,   759,    -1,   129,
     438,  1153,  1286,    -1,  1150,    -1,  1149,   583,  1150,    -1,
    1278,    -1,  1152,    -1,  1151,   583,  1152,    -1,  1278,    -1,
      -1,   204,   154,    -1,    -1,   496,    -1,    -1,    -1,   215,
    1156,  1161,   940,  1163,  1157,  1165,  1181,    -1,    -1,    -1,
     408,  1159,  1162,  1163,  1160,  1165,    -1,    -1,   262,    -1,
     114,    -1,   194,    -1,  1190,    -1,   114,    -1,   219,  1164,
      -1,  1164,    -1,  1150,    -1,  1168,    -1,   581,   582,  1168,
      -1,   581,  1167,   582,  1168,    -1,    -1,   440,  1166,  1172,
      -1,  1167,   583,  1271,    -1,  1271,    -1,   547,  1171,    -1,
     548,  1171,    -1,    -1,   812,  1169,  1359,    -1,    -1,   581,
     812,   582,  1170,  1362,    -1,  1171,   583,  1176,    -1,  1176,
      -1,  1172,   583,  1173,    -1,  1173,    -1,  1275,  1174,  1180,
      -1,   145,    -1,   441,    -1,    -1,  1174,    -1,    -1,   581,
    1177,  1178,   582,    -1,    -1,  1179,    -1,  1179,   583,  1180,
      -1,  1180,    -1,  1016,    -1,   112,    -1,    -1,    -1,   336,
     132,  1182,   232,   537,  1188,    -1,    -1,    -1,   537,  1184,
    1190,   940,  1060,   440,  1186,  1185,  1103,  1114,  1124,    -1,
    1186,   583,  1187,    -1,  1187,    -1,  1275,  1174,  1180,    -1,
    1188,   583,  1189,    -1,  1189,    -1,  1275,  1174,  1180,    -1,
      -1,   262,    -1,    -1,   116,  1192,  1200,  1193,    -1,    -1,
     175,  1278,  1194,  1103,  1114,  1124,    -1,    -1,  1197,  1195,
     175,  1060,  1103,    -1,    -1,   175,  1151,  1196,   543,  1060,
    1103,    -1,  1198,    -1,  1197,   583,  1198,    -1,  1284,  1199,
    1101,    -1,  1284,   588,  1284,  1199,  1101,    -1,    -1,   588,
     576,    -1,    -1,  1201,  1200,    -1,   383,    -1,   262,    -1,
     205,    -1,   518,  1203,  1150,    -1,    -1,   494,    -1,    -1,
    1205,    -1,  1206,    -1,  1205,   583,  1206,    -1,    87,    -1,
     293,    -1,    41,   223,    -1,    82,   489,    -1,   353,   162,
      -1,   224,    -1,   488,    -1,   455,    -1,    12,    -1,    -1,
     172,   382,   331,    -1,    -1,   445,  1209,  1210,    -1,    96,
    1220,    -1,  1216,   491,  1215,  1220,    -1,  1216,   514,  1215,
    1220,    -1,   150,  1215,  1220,    -1,   494,   473,  1215,  1220,
      -1,   339,   491,  1215,  1220,    -1,  1216,   364,    -1,   363,
      -1,   143,   830,  1212,    -1,   143,    12,  1212,    -1,  1216,
      68,  1217,  1278,  1215,  1220,    -1,   320,   278,   172,   449,
     562,   266,   145,  1281,    16,   267,   145,  1127,    16,   270,
     145,  1125,    -1,  1213,   256,    -1,   449,   196,    -1,    -1,
      34,   150,  1218,  1219,  1211,  1119,    -1,   892,  1217,  1278,
    1215,  1103,    -1,    69,   519,    -1,   494,   519,    -1,  1214,
     142,    -1,    23,    -1,    84,    -1,   374,    -1,    86,   581,
     576,   582,   557,    -1,    86,   581,   576,   582,   147,    -1,
     557,  1119,    -1,   147,  1119,    -1,   379,    -1,   378,  1204,
    1207,  1119,    -1,  1298,   473,  1220,    -1,   212,   473,    -1,
     310,   473,    -1,  1216,   377,    -1,  1298,   551,  1220,    -1,
     866,  1220,    -1,    67,  1220,    -1,   185,    -1,   185,   172,
    1287,    -1,    88,    95,   822,  1284,    -1,    88,   494,  1278,
      -1,    88,   555,  1278,    -1,   278,   473,    -1,   449,   473,
      -1,    88,   375,   633,    -1,    88,   178,   633,    -1,    88,
     515,   633,    -1,   375,   473,  1220,    -1,   178,   473,  1220,
      -1,   375,    65,   633,    -1,   178,    65,   633,    -1,    88,
     151,   633,    -1,   473,    -1,   310,    -1,   256,    -1,   278,
      -1,    33,    -1,    -1,   477,    -1,    -1,  1217,  1284,    -1,
      -1,   176,    -1,   175,    -1,   222,    -1,    -1,   222,  1281,
      -1,    -1,   175,  1127,    -1,    -1,   244,  1281,    -1,   560,
    1016,    -1,    -1,  1224,  1278,  1222,  1226,    -1,    -1,  1224,
    1225,  1223,   995,    -1,   117,    -1,   118,    -1,    -1,   157,
      -1,   359,    -1,    -1,  1266,    -1,  1284,    -1,    -1,   169,
     977,  1228,  1229,    -1,  1229,   583,  1230,    -1,  1230,    -1,
      -1,  1309,  1231,  1232,    -1,   491,   562,   387,   254,    -1,
     382,    48,    -1,   196,    -1,   374,    -1,   256,    -1,   473,
      -1,   449,    -1,   278,    -1,   119,    -1,   412,    -1,    -1,
    1149,    -1,    -1,   411,  1234,  1235,    -1,  1235,   583,  1236,
      -1,  1236,    -1,   449,    -1,   278,    -1,   382,    48,    -1,
      -1,   380,  1238,  1239,    -1,  1213,   256,  1240,    -1,   510,
    1281,    -1,    29,  1016,    -1,   233,  1242,  1016,    -1,    -1,
      78,    -1,   382,    -1,   542,  1284,    -1,    -1,   250,    98,
    1245,  1246,    -1,   250,   494,  1278,   175,   278,    -1,    -1,
      -1,    -1,    -1,  1252,  1251,   209,  1283,  1247,  1253,   219,
    1248,   494,  1278,  1249,   869,  1250,  1254,  1257,  1260,  1261,
    1264,    -1,   175,   278,    -1,    -1,   251,    -1,    -1,    76,
      -1,   262,    -1,    -1,   408,    -1,   205,    -1,    -1,    68,
    1255,    -1,  1255,  1256,    -1,  1256,    -1,   498,    46,  1266,
      -1,   343,   138,    46,  1266,    -1,   138,    46,  1266,    -1,
     148,    46,  1266,    -1,    -1,   247,  1258,    -1,  1258,  1259,
      -1,  1259,    -1,   498,    46,  1266,    -1,   470,    46,  1266,
      -1,    -1,   205,   331,   247,    -1,    -1,   581,  1262,   582,
      -1,   581,   582,    -1,  1262,   583,  1263,    -1,  1263,    -1,
    1275,    -1,   587,  1286,    -1,    -1,   440,  1188,    -1,   499,
      -1,   315,    -1,   525,   499,    -1,  1265,  1282,    -1,  1282,
      -1,   193,    -1,    35,    -1,   355,    -1,  1269,    -1,   575,
    1270,    -1,   574,  1270,    -1,  1265,    -1,  1270,    -1,   330,
      -1,   160,    -1,   517,    -1,   193,    -1,    35,    -1,   525,
     193,    -1,   525,    35,    -1,   102,  1265,    -1,   506,  1265,
      -1,   503,  1265,    -1,   331,    -1,   259,    -1,   522,    -1,
     109,    -1,   167,    -1,  1275,    -1,  1272,    -1,  1284,   588,
     576,    -1,  1284,   588,  1284,   588,   576,    -1,  1016,    -1,
    1284,    -1,  1276,    -1,  1284,    -1,  1276,    -1,  1284,   588,
    1284,    -1,   588,  1284,   588,  1284,    -1,  1284,   588,  1284,
     588,  1284,    -1,  1284,    -1,  1284,   588,  1284,   588,  1284,
      -1,  1284,   588,  1284,    -1,   588,  1284,    -1,  1284,    -1,
    1284,   588,  1284,    -1,   588,  1284,    -1,  1284,    -1,   201,
      -1,   203,    -1,   499,    -1,   499,    -1,   499,    -1,  1280,
      -1,  1288,    -1,  1280,    -1,  1289,    -1,  1284,    -1,  1281,
      -1,   243,    -1,  1286,    -1,  1286,   587,  1286,    -1,    92,
    1015,    -1,  1289,    -1,    20,    -1,    28,    -1,    30,    -1,
      47,    -1,    48,    -1,    57,    -1,    59,    -1,    63,    -1,
      70,    -1,    72,    -1,    81,    -1,   108,    -1,   128,    -1,
     139,    -1,   153,    -1,   169,    -1,   189,    -1,   192,    -1,
     195,    -1,   217,    -1,   234,    -1,   327,    -1,   339,    -1,
     341,    -1,   351,    -1,   356,    -1,   360,    -1,   367,    -1,
     370,    -1,   402,    -1,   405,    -1,   411,    -1,   413,    -1,
     420,    -1,   427,    -1,   431,    -1,   438,    -1,   447,    -1,
     452,    -1,   449,    -1,   453,    -1,   472,    -1,   476,    -1,
     518,    -1,   529,    -1,   530,    -1,   564,    -1,   567,    -1,
     538,    -1,     5,    -1,     7,    -1,     8,    -1,     9,    -1,
      10,    -1,    11,    -1,    17,    -1,    22,    -1,    23,    -1,
      25,    -1,    24,    -1,    26,    -1,    27,    -1,    34,    -1,
      38,    -1,    41,    -1,    43,    -1,    42,    -1,    45,    -1,
      51,    -1,    54,    -1,    56,    -1,    61,    -1,    62,    -1,
      64,    -1,    65,    -1,    67,    -1,    68,    -1,    71,    -1,
      73,    -1,    74,    -1,    75,    -1,    76,    -1,    78,    -1,
      79,    -1,    82,    -1,    84,    -1,    87,    -1,    90,    -1,
      98,    -1,    97,    -1,    99,    -1,   102,    -1,   107,    -1,
     113,    -1,   115,    -1,   119,    -1,   121,    -1,   122,    -1,
     123,    -1,   124,    -1,   131,    -1,   132,    -1,   133,    -1,
     140,    -1,   144,    -1,   143,    -1,   142,    -1,   147,    -1,
     149,    -1,   151,    -1,   150,    -1,   152,    -1,   156,    -1,
     157,    -1,   158,    -1,   162,    -1,   161,    -1,   173,    -1,
     137,    -1,   176,    -1,   164,    -1,   165,    -1,   166,    -1,
     174,    -1,   181,    -1,   180,    -1,   182,    -1,   185,    -1,
     183,    -1,   190,    -1,   196,    -1,   200,    -1,   202,    -1,
     221,    -1,   206,    -1,   207,    -1,   210,    -1,   223,    -1,
     224,    -1,   226,    -1,   227,    -1,   212,    -1,   216,    -1,
     231,    -1,   235,    -1,   238,    -1,   241,    -1,   242,    -1,
     248,    -1,   249,    -1,   251,    -1,   253,    -1,   255,    -1,
     256,    -1,   283,    -1,   278,    -1,   265,    -1,   269,    -1,
     266,    -1,   267,    -1,   279,    -1,   268,    -1,   270,    -1,
     264,    -1,   276,    -1,   272,    -1,   271,    -1,   273,    -1,
     274,    -1,   275,    -1,   281,    -1,   282,    -1,   284,    -1,
     286,    -1,   287,    -1,   288,    -1,   292,    -1,   293,    -1,
     294,    -1,   295,    -1,   296,    -1,   299,    -1,   300,    -1,
     304,    -1,   302,    -1,   306,    -1,   307,    -1,   308,    -1,
     309,    -1,   310,    -1,   312,    -1,   311,    -1,   313,    -1,
     316,    -1,   317,    -1,   321,    -1,   320,    -1,   328,    -1,
     322,    -1,   323,    -1,   333,    -1,   334,    -1,   335,    -1,
     337,    -1,   338,    -1,   352,    -1,   353,    -1,   354,    -1,
     357,    -1,   358,    -1,   359,    -1,   361,    -1,   362,    -1,
     364,    -1,   363,    -1,   365,    -1,   366,    -1,   371,    -1,
     372,    -1,   374,    -1,   376,    -1,   377,    -1,   378,    -1,
     379,    -1,   381,    -1,   382,    -1,   383,    -1,   386,    -1,
     390,    -1,   391,    -1,   393,    -1,   392,    -1,   394,    -1,
     397,    -1,   398,    -1,   399,    -1,   401,    -1,   404,    -1,
     406,    -1,   409,    -1,   412,    -1,   415,    -1,   416,    -1,
     421,    -1,   422,    -1,   423,    -1,   424,    -1,   425,    -1,
     426,    -1,   428,    -1,   430,    -1,   436,    -1,   435,    -1,
     437,    -1,   448,    -1,   442,    -1,   446,    -1,   451,    -1,
     454,    -1,   455,    -1,   463,    -1,   462,    -1,   465,    -1,
     468,    -1,   471,    -1,   473,    -1,   477,    -1,   479,    -1,
     480,    -1,   481,    -1,   483,    -1,   482,    -1,   486,    -1,
     487,    -1,   488,    -1,   489,    -1,   491,    -1,   495,    -1,
     492,    -1,   496,    -1,   497,    -1,   500,    -1,   501,    -1,
     512,    -1,   513,    -1,   514,    -1,   503,    -1,   504,    -1,
     505,    -1,   506,    -1,   519,    -1,   520,    -1,   521,    -1,
     178,    -1,   523,    -1,   524,    -1,   527,    -1,   526,    -1,
     533,    -1,   536,    -1,   540,    -1,   541,    -1,   551,    -1,
     555,    -1,   548,    -1,   557,    -1,   556,    -1,   558,    -1,
     563,    -1,   566,    -1,   570,    -1,    -1,   440,  1292,  1291,
    1293,    -1,    -1,   342,    -1,  1294,    -1,  1293,   583,  1294,
      -1,    -1,  1295,  1300,    -1,  1297,    -1,   183,    -1,   251,
      -1,   437,    -1,    -1,   337,    -1,    -1,   183,    -1,   251,
      -1,   437,    -1,    -1,   183,   588,    -1,   251,   588,    -1,
     437,   588,    -1,  1301,    -1,  1297,  1302,    -1,  1296,  1303,
    1174,  1306,    -1,  1296,   512,   226,   242,  1304,    -1,   587,
    1286,  1174,  1016,    -1,   587,   587,  1299,  1303,  1174,  1306,
      -1,   866,   871,    -1,   311,  1174,  1016,    -1,   311,   868,
     873,    -1,   361,  1174,  1305,    -1,   361,   172,  1287,  1174,
    1305,    -1,  1284,    -1,  1284,   588,  1284,    -1,   112,   588,
    1284,    -1,   387,   523,    -1,   387,    71,    -1,   406,   387,
      -1,   435,    -1,   499,    -1,   361,   581,   499,   582,    -1,
     335,   581,   499,   582,    -1,  1016,    -1,   112,    -1,   336,
      -1,    12,    -1,    33,    -1,    -1,   254,  1309,  1308,  1310,
      -1,   494,    -1,   491,    -1,  1311,    -1,  1310,   583,  1311,
      -1,  1278,  1101,  1312,    -1,   387,    -1,   565,    -1,   262,
     565,    -1,   387,   251,    -1,    -1,   534,  1314,  1309,    -1,
     189,  1278,   339,  1101,    -1,   189,  1279,    63,    -1,    -1,
     189,  1279,   387,  1316,  1317,  1103,  1120,    -1,  1318,    -1,
    1284,  1319,    -1,   165,    -1,   321,    -1,   165,    -1,   321,
      -1,   372,    -1,   235,    -1,    -1,  1321,  1320,   581,  1179,
     582,    -1,   145,    -1,   179,    -1,   236,    -1,   188,    -1,
     263,    -1,   418,   632,  1323,    -1,  1327,   336,  1326,  1338,
     175,  1340,    -1,  1327,   336,   178,  1338,   175,  1340,    -1,
    1327,   336,   375,  1338,   175,  1340,    -1,    12,  1328,   583,
     184,   342,   175,  1340,    -1,   184,   632,  1325,    -1,  1327,
     336,  1326,  1338,   510,  1340,  1345,  1346,    -1,  1327,   336,
     178,  1338,   510,  1340,  1345,  1346,    -1,  1327,   336,   375,
    1338,   510,  1340,  1345,  1346,    -1,    -1,   494,    -1,  1329,
      -1,    12,  1328,    -1,    -1,   374,    -1,  1330,    -1,  1329,
     583,  1330,    -1,    -1,   432,  1331,  1342,    -1,    -1,   215,
    1332,  1342,    -1,    -1,   537,  1333,  1342,    -1,    -1,   395,
    1334,  1342,    -1,   116,    -1,   539,    -1,   208,    -1,    13,
      -1,    88,    -1,   129,    -1,   153,    -1,   401,    -1,   446,
      -1,   376,    -1,   164,    -1,   184,   342,    -1,   445,    96,
      -1,   486,    -1,    88,   496,   491,    -1,   254,   491,    -1,
     409,   449,    -1,   409,    62,    -1,    88,   555,    -1,   445,
     555,    -1,    88,   422,    -1,    13,   422,    -1,    88,   540,
      -1,   151,    -1,   515,    -1,    -1,    16,    -1,  1337,  1335,
    1336,    -1,  1337,    -1,   481,   499,    -1,   227,   499,    -1,
      61,   499,    -1,   576,    -1,  1284,   588,   576,    -1,   576,
     588,   576,    -1,  1278,    -1,  1287,    -1,  1339,   583,  1287,
      -1,  1341,    -1,  1340,   583,  1341,    -1,  1287,   202,    46,
     499,    -1,  1287,   202,    46,   361,   499,    -1,  1287,    -1,
      -1,   581,  1343,   582,    -1,  1343,   583,  1344,    -1,  1344,
      -1,  1284,    -1,    -1,   410,  1336,    -1,   410,   469,    -1,
     410,   566,    -1,   410,   323,    -1,    -1,   562,  1347,    -1,
    1347,  1348,    -1,  1348,    -1,   184,   342,    -1,   282,  1125,
      -1,   286,  1125,    -1,   281,  1125,    -1,   287,  1125,    -1,
      -1,    30,  1350,  1351,    -1,    -1,   563,    -1,    -1,    16,
     327,    54,    -1,    16,    54,    -1,    -1,   400,    -1,   327,
     400,    -1,    -1,   427,    -1,    72,  1351,  1352,  1353,    -1,
     420,  1351,  1352,  1353,    -1,   420,  1351,   510,  1354,  1284,
      -1,   427,  1284,    -1,   400,   427,  1284,    -1,    -1,  1360,
      -1,    -1,   531,  1366,  1361,   996,    -1,    -1,  1360,    -1,
    1363,    -1,    -1,  1364,  1365,    -1,  1115,  1119,    -1,  1121,
      -1,    -1,   125,    -1,    12,    -1,    -1,   432,  1369,   998,
    1367,  1370,    -1,   581,  1369,   997,  1367,  1370,   582,    -1,
      -1,    -1,  1376,  1372,    -1,  1375,  1373,    -1,  1377,  1374,
    1381,    -1,  1381,    -1,  1389,    -1,  1400,    -1,  1394,    -1,
     619,    -1,  1381,    -1,  1389,    -1,  1400,    -1,  1394,    -1,
    1393,    -1,   619,    -1,  1375,    -1,  1376,    -1,    -1,   113,
     145,  1287,    -1,  1378,    -1,  1378,  1379,    -1,  1379,    -1,
     347,   408,    -1,    11,   145,   524,    -1,    11,   145,   294,
      -1,    11,   145,   497,    -1,    -1,   467,   431,   113,    -1,
     467,   431,   221,    -1,    -1,  1380,   555,  1278,  1382,  1383,
      18,  1385,    -1,    -1,   581,  1384,   582,    -1,  1284,    -1,
    1384,   583,  1284,    -1,    -1,  1386,  1387,  1388,    -1,   432,
     998,    -1,   581,   997,   582,  1362,    -1,    -1,   562,    60,
     342,    -1,   562,    51,    60,   342,    -1,   562,   251,    60,
     342,    -1,    -1,    -1,    -1,   515,  1011,   633,   718,   719,
     336,  1011,  1390,  1278,   172,  1011,  1391,   134,   425,  1392,
     668,    -1,    10,  1011,   178,  1284,   416,   834,   453,  1281,
      -1,  1011,   178,  1284,   416,   834,   453,  1281,    -1,    -1,
      -1,    -1,    -1,    -1,  1011,   178,   633,   581,  1395,   644,
     582,  1396,   416,  1397,   845,  1398,   635,  1399,   668,    -1,
      -1,    -1,    -1,    -1,   375,  1011,   633,  1401,   581,  1402,
     648,   582,  1403,   635,  1404,   668,    -1,   567,  1407,  1406,
    1408,    -1,   567,   139,  1406,  1410,    -1,   567,   370,  1406,
      -1,   567,    72,  1406,  1409,    -1,   567,   420,  1406,    -1,
     567,   391,    -1,  1266,    -1,  1266,   583,  1266,    -1,  1266,
     583,  1266,   583,  1125,    -1,    30,    -1,   472,    -1,    -1,
     229,    -1,   415,    -1,    -1,   338,   362,    -1,    -1,    -1,
     487,  1411,  1412,    -1,    -1,   172,   296,    -1,   217,   364,
    1284,   453,  1281,    -1,   530,   364,  1284,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,  1348,  1348,  1362,  1366,  1367,  1372,  1373,  1374,  1375,
    1376,  1377,  1378,  1379,  1380,  1381,  1382,  1383,  1384,  1385,
    1386,  1387,  1388,  1389,  1390,  1391,  1392,  1393,  1394,  1395,
    1396,  1397,  1398,  1399,  1400,  1401,  1402,  1403,  1404,  1405,
    1406,  1407,  1408,  1409,  1410,  1411,  1412,  1413,  1414,  1415,
    1416,  1417,  1418,  1419,  1420,  1421,  1422,  1426,  1436,  1437,
    1441,  1451,  1458,  1469,  1468,  1479,  1481,  1485,  1486,  1490,
    1503,  1502,  1522,  1521,  1532,  1533,  1537,  1541,  1545,  1549,
    1553,  1557,  1562,  1566,  1570,  1574,  1578,  1582,  1587,  1591,
    1595,  1611,  1615,  1627,  1626,  1661,  1659,  1688,  1687,  1700,
    1699,  1707,  1711,  1715,  1719,  1726,  1739,  1740,  1744,  1748,
    1752,  1756,  1760,  1764,  1768,  1780,  1775,  1826,  1825,  1832,
    1839,  1840,  1845,  1850,  1859,  1862,  1868,  1870,  1877,  1878,
    1882,  1888,  1897,  1898,  1906,  1906,  1964,  1965,  1966,  1967,
    1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,  1976,  1981,
    1995,  2009,  2027,  2028,  2032,  2033,  2038,  2040,  2042,  2044,
    2046,  2048,  2050,  2056,  2057,  2058,  2062,  2066,  2074,  2073,
    2086,  2088,  2091,  2093,  2097,  2101,  2108,  2110,  2114,  2115,
    2120,  2139,  2165,  2167,  2171,  2172,  2176,  2202,  2203,  2204,
    2205,  2209,  2210,  2214,  2215,  2220,  2223,  2250,  2249,  2305,
    2320,  2319,  2363,  2387,  2387,  2409,  2410,  2415,  2417,  2422,
    2445,  2451,  2466,  2467,  2471,  2475,  2484,  2489,  2494,  2502,
    2517,  2535,  2536,  2540,  2541,  2542,  2543,  2544,  2545,  2546,
    2547,  2548,  2549,  2550,  2551,  2552,  2557,  2556,  2563,  2563,
    2616,  2615,  2641,  2641,  2655,  2708,  2749,  2768,  2767,  2787,
    2804,  2806,  2807,  2811,  2831,  2854,  2856,  2870,  2854,  2888,
    2890,  2891,  2895,  2896,  2901,  2907,  2900,  2926,  2925,  2941,
    2942,  2946,  2947,  2952,  2956,  2951,  2973,  2977,  2972,  2992,
    3000,  3005,  3004,  3040,  3041,  3046,  3045,  3078,  3078,  3093,
    3092,  3119,  3130,  3132,  3129,  3156,  3155,  3173,  3175,  3180,
    3182,  3184,  3201,  3206,  3212,  3219,  3220,  3228,  3234,  3243,
    3249,  3255,  3256,  3260,  3260,  3265,  3266,  3267,  3271,  3272,
    3273,  3277,  3281,  3282,  3283,  3287,  3288,  3289,  3290,  3291,
    3292,  3293,  3294,  3298,  3302,  3303,  3304,  3308,  3309,  3310,
    3311,  3312,  3316,  3320,  3321,  3322,  3326,  3327,  3328,  3329,
    3330,  3331,  3332,  3336,  3340,  3341,  3342,  3346,  3347,  3348,
    3353,  3361,  3369,  3377,  3387,  3397,  3402,  3407,  3415,  3423,
    3431,  3439,  3447,  3455,  3463,  3476,  3489,  3502,  3504,  3508,
    3513,  3526,  3527,  3578,  3579,  3582,  3591,  3603,  3608,  3606,
    3613,  3615,  3614,  3618,  3617,  3647,  3648,  3653,  3652,  3685,
    3684,  3701,  3705,  3712,  3711,  3715,  3714,  3718,  3717,  3723,
    3724,  3729,  3730,  3734,  3735,  3739,  3750,  3762,  3775,  3776,
    3792,  3794,  3793,  3798,  3796,  3807,  3808,  3812,  3823,  3839,
    3840,  3856,  3857,  3880,  3881,  3886,  3885,  3910,  3921,  3941,
    3956,  3974,  3986,  4002,  4003,  4007,  4017,  4018,  4022,  4039,
    4098,  4106,  4133,  4134,  4139,  4138,  4159,  4164,  4165,  4169,
    4170,  4174,  4176,  4182,  4184,  4186,  4188,  4190,  4192,  4202,
    4218,  4201,  4232,  4233,  4237,  4238,  4242,  4243,  4247,  4248,
    4252,  4253,  4257,  4258,  4262,  4266,  4267,  4270,  4272,  4276,
    4277,  4281,  4282,  4283,  4287,  4292,  4299,  4304,  4309,  4314,
    4319,  4324,  4329,  4344,  4350,  4355,  4360,  4365,  4370,  4375,
    4390,  4391,  4392,  4397,  4402,  4407,  4409,  4411,  4413,  4419,
    4424,  4432,  4450,  4467,  4490,  4504,  4505,  4506,  4507,  4508,
    4509,  4510,  4514,  4515,  4516,  4520,  4521,  4525,  4526,  4527,
    4528,  4532,  4533,  4537,  4538,  4542,  4543,  4550,  4563,  4573,
    4593,  4597,  4603,  4605,  4609,  4613,  4614,  4618,  4623,  4622,
    4645,  4646,  4647,  4648,  4653,  4658,  4663,  4668,  4673,  4678,
    4684,  4690,  4696,  4702,  4707,  4713,  4719,  4721,  4723,  4725,
    4738,  4740,  4745,  4750,  4762,  4767,  4772,  4777,  4779,  4781,
    4783,  4785,  4787,  4789,  4791,  4794,  4793,  4798,  4797,  4801,
    4803,  4812,  4813,  4814,  4819,  4820,  4821,  4822,  4823,  4827,
    4831,  4832,  4836,  4837,  4841,  4842,  4843,  4844,  4845,  4849,
    4850,  4851,  4852,  4853,  4857,  4862,  4864,  4870,  4871,  4873,
    4878,  4887,  4888,  4892,  4893,  4897,  4898,  4899,  4903,  4904,
    4908,  4909,  4913,  4914,  4918,  4919,  4923,  4924,  4925,  4926,
    4928,  4929,  4935,  4941,  4947,  4953,  4954,  4970,  4972,  4977,
    4978,  4982,  4990,  4994,  4995,  4999,  5000,  5004,  5013,  5017,
    5018,  5022,  5033,  5034,  5038,  5039,  5043,  5044,  5048,  5049,
    5050,  5051,  5060,  5061,  5065,  5066,  5070,  5071,  5072,  5081,
    5084,  5086,  5091,  5090,  5103,  5104,  5108,  5109,  5113,  5114,
    5118,  5119,  5123,  5124,  5125,  5126,  5127,  5131,  5132,  5133,
    5134,  5135,  5139,  5140,  5141,  5154,  5155,  5159,  5160,  5164,
    5165,  5169,  5170,  5171,  5175,  5176,  5177,  5178,  5191,  5203,
    5204,  5208,  5209,  5213,  5214,  5218,  5219,  5223,  5224,  5226,
    5239,  5240,  5241,  5245,  5246,  5250,  5251,  5263,  5264,  5268,
    5269,  5273,  5274,  5282,  5281,  5308,  5307,  5321,  5333,  5332,
    5351,  5350,  5369,  5368,  5387,  5381,  5405,  5400,  5454,  5459,
    5464,  5469,  5474,  5484,  5485,  5486,  5487,  5491,  5492,  5504,
    5505,  5509,  5510,  5513,  5515,  5516,  5517,  5519,  5521,  5522,
    5531,  5532,  5536,  5545,  5543,  5552,  5561,  5560,  5569,  5567,
    5576,  5583,  5587,  5594,  5598,  5603,  5602,  5618,  5620,  5625,
    5634,  5633,  5649,  5653,  5652,  5664,  5665,  5669,  5684,  5685,
    5689,  5698,  5699,  5703,  5708,  5707,  5715,  5724,  5714,  5736,
    5743,  5747,  5754,  5761,  5767,  5773,  5779,  5786,  5805,  5826,
    5831,  5835,  5843,  5844,  5848,  5849,  5853,  5854,  5855,  5859,
    5860,  5861,  5865,  5866,  5867,  5868,  5877,  5876,  5887,  5895,
    5894,  5904,  5913,  5922,  5923,  5930,  5930,  5936,  5937,  5941,
    5942,  5943,  5947,  5948,  5964,  5965,  5970,  5969,  5981,  5980,
    5992,  5991,  6001,  6002,  6003,  6008,  6007,  6019,  6020,  6024,
    6025,  6029,  6030,  6031,  6036,  6035,  6047,  6056,  6055,  6072,
    6073,  6077,  6078,  6082,  6083,  6084,  6085,  6086,  6087,  6092,
    6091,  6103,  6104,  6105,  6110,  6109,  6115,  6122,  6127,  6135,
    6136,  6140,  6153,  6162,  6163,  6167,  6176,  6177,  6182,  6181,
    6191,  6192,  6196,  6205,  6205,  6216,  6217,  6222,  6223,  6232,
    6241,  6242,  6246,  6276,  6281,  6280,  6300,  6308,  6300,  6315,
    6316,  6317,  6318,  6319,  6323,  6330,  6337,  6339,  6350,  6351,
    6355,  6356,  6362,  6363,  6364,  6365,  6371,  6377,  6383,  6397,
    6400,  6402,  6408,  6418,  6419,  6420,  6433,  6459,  6467,  6475,
    6476,  6480,  6481,  6482,  6483,  6484,  6488,  6489,  6494,  6543,
    6548,  6589,  6591,  6593,  6595,  6597,  6599,  6601,  6603,  6607,
    6609,  6611,  6613,  6615,  6617,  6621,  6625,  6631,  6635,  6641,
    6645,  6653,  6655,  6661,  6666,  6668,  6670,  6671,  6673,  6677,
    6679,  6681,  6683,  6685,  6687,  6689,  6691,  6693,  6695,  6697,
    6699,  6701,  6703,  6705,  6709,  6710,  6714,  6715,  6719,  6720,
    6724,  6725,  6729,  6730,  6731,  6732,  6733,  6734,  6738,  6739,
    6743,  6744,  6745,  6746,  6747,  6748,  6756,  6757,  6758,  6759,
    6760,  6762,  6763,  6765,  6767,  6769,  6773,  6774,  6779,  6784,
    6788,  6789,  6796,  6801,  6809,  6811,  6818,  6820,  6832,  6837,
    6849,  6851,  6853,  6859,  6861,  6863,  6865,  6867,  6876,  6884,
    6886,  6888,  6890,  6892,  6894,  6896,  6898,  6900,  6902,  6904,
    6906,  6908,  6910,  6912,  6914,  6916,  6922,  6939,  6944,  6946,
    6951,  6956,  6961,  6963,  6965,  6967,  6969,  6974,  6979,  6981,
    6986,  6988,  6990,  6992,  6994,  6996,  7004,  7012,  7014,  7016,
    7021,  7026,  7039,  7041,  7043,  7045,  7047,  7052,  7054,  7056,
    7058,  7060,  7070,  7072,  7074,  7076,  7078,  7087,  7089,  7102,
    7108,  7115,  7122,  7129,  7136,  7143,  7145,  7165,  7164,  7232,
    7264,  7266,  7271,  7272,  7276,  7277,  7281,  7282,  7286,  7291,
    7299,  7319,  7321,  7323,  7325,  7327,  7329,  7331,  7334,  7336,
    7333,  7339,  7346,  7348,  7350,  7352,  7354,  7356,  7358,  7360,
    7362,  7365,  7364,  7380,  7379,  7394,  7400,  7406,  7422,  7423,
    7428,  7431,  7436,  7439,  7451,  7450,  7467,  7469,  7471,  7473,
    7475,  7477,  7479,  7481,  7483,  7485,  7487,  7492,  7493,  7497,
    7502,  7510,  7511,  7515,  7520,  7528,  7529,  7533,  7534,  7538,
    7544,  7554,  7555,  7564,  7575,  7576,  7581,  7582,  7602,  7604,
    7608,  7606,  7623,  7621,  7639,  7637,  7644,  7653,  7651,  7669,
    7668,  7678,  7689,  7687,  7706,  7705,  7716,  7727,  7728,  7729,
    7734,  7734,  7747,  7769,  7814,  7813,  7836,  7853,  7836,  7860,
    7864,  7890,  7891,  7896,  7900,  7901,  7902,  7906,  7907,  7912,
    7911,  7917,  7916,  7924,  7925,  7928,  7930,  7930,  7934,  7934,
    7939,  7940,  7944,  7946,  7951,  7952,  7956,  7964,  7974,  7975,
    7976,  7977,  7978,  7979,  7980,  7981,  7982,  7983,  7984,  7985,
    7989,  7990,  8009,  8010,  8011,  8012,  8013,  8014,  8015,  8016,
    8017,  8021,  8022,  8023,  8024,  8027,  8029,  8030,  8034,  8035,
    8039,  8041,  8045,  8047,  8046,  8060,  8063,  8062,  8077,  8083,
    8095,  8097,  8101,  8103,  8108,  8109,  8122,  8140,  8144,  8145,
    8149,  8162,  8164,  8169,  8168,  8203,  8205,  8210,  8211,  8212,
    8217,  8223,  8227,  8228,  8232,  8236,  8243,  8250,  8260,  8264,
    8265,  8266,  8271,  8275,  8284,  8285,  8286,  8287,  8288,  8289,
    8293,  8294,  8295,  8296,  8297,  8301,  8302,  8303,  8304,  8305,
    8309,  8310,  8311,  8312,  8316,  8321,  8322,  8326,  8327,  8330,
    8333,  8332,  8361,  8362,  8366,  8367,  8371,  8383,  8383,  8393,
    8394,  8398,  8410,  8443,  8442,  8455,  8454,  8463,  8475,  8487,
    8486,  8503,  8510,  8510,  8522,  8529,  8545,  8564,  8576,  8580,
    8586,  8592,  8599,  8604,  8609,  8619,  8620,  8624,  8632,  8633,
    8637,  8647,  8648,  8652,  8653,  8661,  8671,  8660,  8681,  8688,
    8680,  8698,  8710,  8711,  8712,  8716,  8717,  8721,  8722,  8726,
    8735,  8736,  8737,  8739,  8738,  8749,  8750,  8754,  8755,  8757,
    8756,  8760,  8759,  8765,  8766,  8770,  8771,  8775,  8785,  8786,
    8790,  8791,  8796,  8795,  8809,  8810,  8814,  8819,  8827,  8828,
    8831,  8833,  8833,  8841,  8850,  8840,  8872,  8873,  8877,  8885,
    8886,  8890,  8900,  8901,  8908,  8907,  8921,  8920,  8929,  8928,
    8936,  8935,  8945,  8946,  8950,  8958,  8970,  8971,  8975,  8976,
    8980,  8981,  8982,  8986,  8996,  8998,  9001,  9003,  9006,  9007,
    9010,  9014,  9018,  9022,  9026,  9030,  9034,  9038,  9042,  9050,
    9053,  9063,  9062,  9076,  9083,  9091,  9099,  9107,  9115,  9123,
    9131,  9138,  9140,  9142,  9151,  9164,  9168,  9173,  9172,  9177,
    9186,  9191,  9199,  9206,  9211,  9216,  9221,  9223,  9225,  9227,
    9229,  9231,  9238,  9246,  9258,  9270,  9272,  9280,  9287,  9294,
    9304,  9311,  9317,  9326,  9334,  9338,  9342,  9349,  9356,  9362,
    9371,  9380,  9390,  9400,  9408,  9410,  9412,  9417,  9418,  9421,
    9423,  9427,  9428,  9432,  9433,  9437,  9438,  9442,  9443,  9447,
    9448,  9451,  9453,  9458,  9469,  9468,  9482,  9481,  9491,  9492,
    9496,  9497,  9498,  9502,  9503,  9504,  9517,  9516,  9528,  9529,
    9534,  9533,  9536,  9538,  9540,  9542,  9544,  9546,  9548,  9550,
    9552,  9554,  9559,  9560,  9565,  9564,  9574,  9575,  9579,  9580,
    9581,  9586,  9585,  9596,  9600,  9604,  9616,  9626,  9627,  9628,
    9634,  9646,  9645,  9660,  9678,  9689,  9696,  9706,  9677,  9710,
    9720,  9721,  9725,  9726,  9738,  9742,  9743,  9744,  9747,  9749,
    9753,  9754,  9758,  9763,  9770,  9775,  9782,  9784,  9788,  9789,
    9793,  9798,  9805,  9807,  9815,  9816,  9817,  9821,  9823,  9828,
    9829,  9834,  9835,  9841,  9859,  9867,  9875,  9894,  9900,  9911,
    9924,  9945,  9946,  9947,  9955,  9956,  9957,  9962,  9963,  9964,
    9965,  9966,  9993, 10019, 10020, 10021, 10025, 10030, 10035, 10037,
   10045, 10060, 10061, 10065, 10071, 10082, 10086, 10123, 10127, 10135,
   10139, 10207, 10222, 10246, 10247, 10263, 10273, 10277, 10278, 10279,
   10283, 10291, 10292, 10318, 10331, 10344, 10357, 10358, 10367, 10368,
   10377, 10378, 10379, 10383, 10397, 10411, 10426, 10427, 10428, 10429,
   10430, 10431, 10432, 10433, 10434, 10435, 10436, 10437, 10438, 10439,
   10440, 10441, 10442, 10443, 10444, 10445, 10446, 10447, 10448, 10449,
   10450, 10451, 10452, 10453, 10454, 10455, 10456, 10457, 10458, 10459,
   10460, 10461, 10462, 10463, 10464, 10465, 10466, 10467, 10468, 10469,
   10470, 10471, 10472, 10473, 10474, 10475, 10485, 10486, 10487, 10488,
   10489, 10490, 10491, 10492, 10493, 10494, 10495, 10496, 10497, 10498,
   10499, 10500, 10501, 10502, 10503, 10504, 10505, 10506, 10507, 10508,
   10509, 10510, 10511, 10512, 10513, 10514, 10515, 10516, 10517, 10518,
   10519, 10520, 10521, 10522, 10523, 10524, 10525, 10526, 10527, 10528,
   10529, 10530, 10531, 10532, 10533, 10534, 10535, 10536, 10537, 10538,
   10539, 10540, 10541, 10542, 10543, 10544, 10545, 10546, 10547, 10548,
   10549, 10550, 10551, 10552, 10553, 10554, 10555, 10556, 10557, 10558,
   10559, 10560, 10561, 10562, 10563, 10564, 10565, 10566, 10567, 10568,
   10569, 10570, 10571, 10572, 10573, 10574, 10575, 10576, 10577, 10578,
   10579, 10580, 10581, 10582, 10583, 10584, 10585, 10586, 10587, 10588,
   10589, 10590, 10591, 10592, 10593, 10594, 10595, 10596, 10597, 10598,
   10599, 10600, 10601, 10602, 10603, 10604, 10605, 10606, 10607, 10608,
   10609, 10610, 10611, 10612, 10613, 10614, 10615, 10616, 10617, 10618,
   10619, 10620, 10621, 10622, 10623, 10624, 10625, 10626, 10627, 10628,
   10629, 10630, 10631, 10632, 10633, 10634, 10635, 10636, 10637, 10638,
   10639, 10640, 10641, 10642, 10643, 10644, 10645, 10646, 10647, 10648,
   10649, 10650, 10651, 10652, 10653, 10654, 10655, 10656, 10657, 10658,
   10659, 10660, 10661, 10662, 10663, 10664, 10665, 10666, 10667, 10668,
   10669, 10670, 10671, 10672, 10673, 10674, 10675, 10676, 10677, 10678,
   10679, 10680, 10681, 10682, 10683, 10684, 10685, 10686, 10687, 10688,
   10689, 10690, 10691, 10692, 10693, 10694, 10695, 10696, 10697, 10698,
   10699, 10700, 10701, 10702, 10703, 10704, 10705, 10706, 10707, 10708,
   10709, 10710, 10711, 10712, 10713, 10714, 10715, 10716, 10717, 10718,
   10719, 10720, 10721, 10722, 10723, 10724, 10725, 10726, 10727, 10728,
   10729, 10730, 10731, 10732, 10733, 10734, 10735, 10736, 10737, 10738,
   10739, 10740, 10741, 10742, 10743, 10744, 10745, 10746, 10753, 10752,
   10767, 10768, 10772, 10773, 10777, 10777, 10857, 10858, 10859, 10860,
   10864, 10865, 10869, 10870, 10871, 10872, 10876, 10877, 10878, 10879,
   10883, 10884, 10888, 10969, 10981, 10985, 10990, 10997, 11012, 11025,
   11049, 11059, 11091, 11134, 11148, 11149, 11150, 11151, 11155, 11156,
   11163, 11172, 11173, 11174, 11175, 11176, 11183, 11182, 11198, 11199,
   11203, 11204, 11208, 11216, 11217, 11218, 11219, 11224, 11223, 11243,
   11255, 11268, 11267, 11290, 11291, 11295, 11296, 11300, 11301, 11302,
   11303, 11305, 11304, 11317, 11318, 11319, 11320, 11321, 11327, 11332,
   11338, 11349, 11360, 11367, 11372, 11379, 11391, 11405, 11407, 11411,
   11412, 11419, 11421, 11425, 11426, 11431, 11430, 11434, 11433, 11437,
   11436, 11440, 11439, 11442, 11443, 11444, 11445, 11446, 11447, 11448,
   11449, 11450, 11451, 11452, 11453, 11454, 11455, 11456, 11457, 11458,
   11459, 11460, 11461, 11462, 11463, 11464, 11465, 11466, 11470, 11471,
   11475, 11476, 11480, 11490, 11500, 11513, 11528, 11541, 11554, 11566,
   11571, 11579, 11584, 11592, 11617, 11619, 11625, 11629, 11633, 11634,
   11638, 11658, 11660, 11664, 11668, 11672, 11679, 11680, 11684, 11685,
   11689, 11690, 11696, 11702, 11708, 11718, 11717, 11727, 11728, 11733,
   11734, 11735, 11740, 11741, 11742, 11746, 11747, 11751, 11761, 11768,
   11778, 11787, 11801, 11802, 11807, 11806, 11841, 11842, 11843, 11847,
   11847, 11871, 11872, 11876, 11877, 11878, 11882, 11887, 11892, 11899,
   11920, 11943, 11945, 11947, 11952, 11953, 11954, 11955, 11956, 11960,
   11961, 11962, 11963, 11964, 11965, 11975, 11976, 11981, 11994, 12007,
   12009, 12011, 12016, 12021, 12023, 12025, 12031, 12032, 12034, 12040,
   12039, 12053, 12054, 12058, 12063, 12071, 12071, 12099, 12100, 12105,
   12106, 12108, 12110, 12128, 12137, 12145, 12121, 12216, 12234, 12259,
   12296, 12304, 12312, 12335, 12255, 12402, 12431, 12443, 12452, 12401,
   12480, 12484, 12488, 12492, 12496, 12500, 12507, 12514, 12521, 12531,
   12532, 12536, 12537, 12538, 12542, 12543, 12548, 12550, 12549, 12555,
   12556, 12560, 12570
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM",
  "AUTHORS_SYM", "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CHAIN_SYM", "CHANGE",
  "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM", "CHECK_SYM",
  "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE", "CODE_SYM",
  "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM", "COMMENT_SYM",
  "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM", "COMPLETION_SYM",
  "COMPRESSED_SYM", "CONCURRENT", "CONDITION_SYM", "CONNECTION_SYM",
  "CONSISTENT_SYM", "CONSTRAINT", "CONTAINS_SYM", "CONTEXT_SYM",
  "CONTINUE_SYM", "CONTRIBUTORS_SYM", "CONVERT_SYM", "COUNT_SYM",
  "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER",
  "CURSOR_SYM", "CURTIME", "DATABASE", "DATABASES", "DATAFILE_SYM",
  "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL",
  "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM",
  "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM", "DECIMAL_NUM",
  "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT", "DEFINER_SYM", "DELAYED_SYM",
  "DELAY_KEY_WRITE_SYM", "DELETE_SYM", "DESC", "DESCRIBE", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISK_SYM", "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP",
  "DUAL_SYM", "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM",
  "ELSE", "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EVENT_SYM",
  "EVERY_SYM", "EXECUTE_SYM", "EXISTS", "EXIT_SYM", "EXPANSION_SYM",
  "EXTENDED_SYM", "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM",
  "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FILE_SYM", "FIRST_SYM",
  "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM",
  "FOREIGN", "FOR_SYM", "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GROUP_SYM", "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HASH_SYM",
  "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY", "HOST_SYM",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INITIAL_SIZE_SYM", "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM",
  "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD", "INSTALL_SYM",
  "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM", "IN_SYM", "IO_SYM",
  "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM", "LANGUAGE_SYM",
  "LAST_SYM", "LE", "LEADING", "LEAVES", "LEAVE_SYM", "LEFT", "LESS_SYM",
  "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT", "LINEAR_SYM", "LINES",
  "LINESTRING", "LIST_SYM", "LOAD", "LOCAL_SYM", "LOCATOR_SYM",
  "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM", "LOGS_SYM", "LONGBLOB",
  "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM", "LOW_PRIORITY", "LT",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM",
  "MASTER_USER_SYM", "MATCH", "MAX_CONNECTIONS_PER_HOUR",
  "MAX_QUERIES_PER_HOUR", "MAX_ROWS", "MAX_SIZE_SYM", "MAX_SYM",
  "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM", "MODE_SYM",
  "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM", "MONTH_SYM", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEG", "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM",
  "NOT2_SYM", "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM",
  "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM", "NUMERIC_SYM", "NVARCHAR_SYM",
  "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SHOT_SYM", "ONE_SYM",
  "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM",
  "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM",
  "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PAGE_CHECKSUM_SYM",
  "PARAM_MARKER", "PARSER_SYM", "PARTIAL", "PARTITIONING_SYM",
  "PARTITIONS_SYM", "PARTITION_SYM", "PASSWORD", "PHASE_SYM",
  "PLUGINS_SYM", "PLUGIN_SYM", "POINT_SYM", "POLYGON", "PORT_SYM",
  "POSITION_SYM", "PRECISION", "PREPARE_SYM", "PRESERVE_SYM", "PREV_SYM",
  "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS", "PROCESSLIST_SYM",
  "PROFILE_SYM", "PROFILES_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM",
  "QUICK", "RANGE_SYM", "READS_SYM", "READ_ONLY_SYM", "READ_SYM",
  "READ_WRITE_SYM", "REAL", "REBUILD_SYM", "RECOVER_SYM", "REDOFILE_SYM",
  "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR",
  "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM",
  "RESET_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM", "SECOND_MICROSECOND_SYM",
  "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM", "SENSITIVE_SYM",
  "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM", "SESSION_SYM",
  "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR", "SHARE_SYM",
  "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM",
  "SIMPLE_SYM", "SLAVE", "SMALLINT", "SNAPSHOT_SYM", "SOCKET_SYM",
  "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "STARTS_SYM", "START_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBPARTITIONS_SYM",
  "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM",
  "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE",
  "TABLE_REF_PRIORITY", "TABLE_SYM", "TABLE_CHECKSUM_SYM", "TEMPORARY",
  "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM",
  "THEN_SYM", "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM",
  "TINYBLOB", "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING",
  "TRANSACTION_SYM", "TRANSACTIONAL_SYM", "TRIGGERS_SYM", "TRIGGER_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES", "VALUE_SYM", "VARBINARY",
  "VARCHAR", "VARIABLES", "VARIANCE_SYM", "VARYING", "VAR_SAMP_SYM",
  "VIEW_SYM", "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRAPPER_SYM", "WRITE_SYM", "X509_SYM",
  "XA_SYM", "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "'|'", "'&'",
  "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "'('", "')'", "','",
  "'!'", "'{'", "'}'", "'@'", "'.'", "';'", "':'", "$accept", "query",
  "verb_clause", "statement", "deallocate", "deallocate_or_drop",
  "prepare", "prepare_src", "execute", "@1", "execute_using",
  "execute_var_list", "execute_var_ident", "help", "@2", "change", "@3",
  "master_defs", "master_def", "master_file_def", "create", "@4", "@5",
  "@6", "@7", "server_def", "server_options_list", "server_option",
  "event_tail", "@8", "ev_schedule_time", "@9", "opt_ev_status",
  "ev_starts", "ev_ends", "opt_ev_on_completion", "ev_on_completion",
  "opt_ev_comment", "ev_sql_stmt", "@10", "ev_sql_stmt_inner",
  "clear_privileges", "sp_name", "sp_a_chistics", "sp_c_chistics",
  "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@11",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@12", "@13", "sp_cursor_stmt",
  "@14", "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "opt_value", "sp_hcond", "sp_decl_idents", "sp_opt_default",
  "sp_proc_stmt", "sp_proc_stmt_if", "@15", "sp_proc_stmt_statement",
  "@16", "sp_proc_stmt_return", "@17", "sp_proc_stmt_unlabeled", "@18",
  "sp_proc_stmt_leave", "sp_proc_stmt_iterate", "sp_proc_stmt_open",
  "sp_proc_stmt_fetch", "@19", "sp_proc_stmt_close", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "@20", "@21", "@22", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "@23", "@24",
  "searched_case_stmt", "@25", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@26", "@27",
  "searched_when_clause", "@28", "@29", "else_clause_opt",
  "sp_labeled_control", "@30", "sp_opt_label", "sp_labeled_block", "@31",
  "sp_unlabeled_block", "@32", "sp_block_content", "@33",
  "sp_unlabeled_control", "@34", "@35", "@36", "trg_action_time",
  "trg_event", "change_tablespace_access", "change_tablespace_info",
  "tablespace_info", "opt_logfile_group_name", "alter_tablespace_info",
  "logfile_group_info", "alter_logfile_group_info", "add_log_file",
  "change_ts_option_list", "@37", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create2",
  "create2a", "@38", "create3", "@39", "@40", "opt_partitioning",
  "partitioning", "@41", "partition_entry", "@42", "partition",
  "part_type_def", "@43", "@44", "@45", "opt_linear", "part_field_list",
  "part_field_item_list", "part_field_item", "part_func", "sub_part_func",
  "opt_no_parts", "opt_sub_part", "@46", "@47", "sub_part_field_list",
  "sub_part_field_item", "part_func_expr", "opt_no_subparts", "part_defs",
  "part_def_list", "part_definition", "@48", "part_name",
  "opt_part_values", "part_func_max", "max_value_sym", "part_range_func",
  "part_list_func", "part_list_item", "part_bit_expr", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "@49", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "@50", "@51", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "known_storage_engines",
  "row_types", "merge_insert_types", "opt_select_from", "udf_type",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "@52", "type", "@53", "@54", "spatial_type",
  "char", "nchar", "varchar", "nvarchar", "int_type", "real_type",
  "float_options", "precision", "field_options", "field_opt_list",
  "field_option", "opt_len", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@55", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext",
  "init_key_options", "key_alg", "key_options", "key_opts",
  "key_using_alg", "key_opt", "btree_or_rtree", "key_list", "key_part",
  "opt_ident", "opt_component", "string_list", "alter", "@56", "@57",
  "@58", "@59", "@60", "@61", "@62", "ev_alter_on_schedule_completion",
  "opt_ev_rename_to", "opt_ev_sql_stmt", "ident_or_empty",
  "alter_commands", "@63", "@64", "@65", "remove_partitioning",
  "all_or_alt_part_name_list", "add_partition_rule", "@66",
  "add_part_extra", "reorg_partition_rule", "@67", "reorg_parts_rule",
  "@68", "alt_part_name_list", "alt_part_name_item", "alter_list",
  "add_column", "alter_list_item", "@69", "@70", "@71", "opt_column",
  "opt_ignore", "opt_restrict", "opt_place", "opt_to", "slave", "@72",
  "@73", "start", "start_transaction_opts", "slave_thread_opts", "@74",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@75", "backup", "@76", "checksum", "@77",
  "opt_checksum_type", "repair", "@78", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@79",
  "binlog_base64_event", "check", "@80", "opt_mi_check_type",
  "mi_check_types", "mi_check_type", "optimize", "@81",
  "opt_no_write_to_binlog", "rename", "@82", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@83", "preload_list",
  "preload_keys", "cache_keys_spec", "@84", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@85", "select_part2", "@86", "@87", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "bool_pri", "predicate", "bit_expr", "or", "and", "not", "not2",
  "comp_op", "all_or_any", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@88", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "@89", "@90", "@91", "variable",
  "@92", "variable_aux", "opt_distinct", "opt_gconcat_separator",
  "opt_gorder_clause", "in_sum_expr", "@93", "cast_type", "opt_expr_list",
  "expr_list", "ident_list_arg", "ident_list", "opt_expr", "opt_else",
  "when_list", "table_ref", "join_table_list", "esc_table_ref",
  "derived_table_list", "join_table", "@94", "@95", "@96", "@97", "@98",
  "@99", "@100", "normal_join", "table_factor", "@101", "select_derived",
  "@102", "select_derived2", "@103", "@104", "get_select_lex",
  "select_derived_init", "opt_outer", "index_hint_clause",
  "index_hint_type", "index_hint_definition", "@105", "@106",
  "index_hints_list", "opt_index_hints_list", "@107", "opt_key_definition",
  "@108", "opt_key_usage_list", "key_usage_element", "key_usage_list",
  "using_list", "interval", "interval_time_stamp", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@109", "having_clause", "@110", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@111", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "real_ulong_num", "ulonglong_num", "real_ulonglong_num", "dec_num_error",
  "dec_num", "choice", "procedure_clause", "@112", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@113",
  "select_var_list", "select_var_ident", "into", "@114",
  "into_destination", "@115", "do", "@116", "drop", "@117", "table_list",
  "table_name", "table_alias_ref_list", "table_alias_ref", "if_exists",
  "opt_temporary", "insert", "@118", "@119", "replace", "@120", "@121",
  "insert_lock_option", "replace_lock_option", "insert2", "insert_table",
  "insert_field_spec", "@122", "fields", "insert_values", "@123", "@124",
  "values_list", "ident_eq_list", "ident_eq_value", "equal", "opt_equal",
  "no_braces", "@125", "opt_values", "values", "expr_or_default",
  "opt_insert_update", "@126", "update", "@127", "@128", "update_list",
  "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@129", "single_multi", "@130", "@131",
  "@132", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "opt_profile_defs", "profile_defs", "profile_def", "opt_profile_args",
  "show", "@133", "show_param", "@134", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@135", "@136",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@137", "flush_options", "flush_option", "@138",
  "opt_table_list", "reset", "@139", "reset_options", "reset_option",
  "purge", "@140", "purge_options", "purge_option", "kill", "kill_option",
  "use", "load", "@141", "load_data", "@142", "@143", "@144", "@145",
  "opt_local", "load_data_lock", "opt_duplicate", "opt_field_term",
  "field_term_list", "field_term", "opt_line_term", "line_term_list",
  "line_term", "opt_ignore_lines", "opt_field_or_var_spec",
  "fields_or_vars", "field_or_var", "opt_load_data_set_spec",
  "text_literal", "text_string", "param_marker", "signed_literal",
  "literal", "NUM_literal", "insert_ident", "table_wild", "order_ident",
  "simple_ident", "simple_ident_nospvar", "simple_ident_q", "field_ident",
  "table_ident", "table_ident_nodb", "IDENT_sys", "TEXT_STRING_sys",
  "TEXT_STRING_literal", "TEXT_STRING_filesystem", "ident", "label_ident",
  "ident_or_text", "user", "keyword", "keyword_sp", "set", "@146",
  "opt_option", "option_value_list", "option_type_value", "@147",
  "option_type", "option_type2", "opt_var_type", "opt_var_ident_type",
  "ext_option_value", "sys_option_value", "option_value",
  "internal_variable_name", "isolation_types", "text_or_password",
  "set_expr_or_default", "lock", "@148", "table_or_tables",
  "table_lock_list", "table_lock", "lock_option", "unlock", "@149",
  "handler", "@150", "handler_read_or_scan", "handler_scan_function",
  "handler_rkey_function", "@151", "handler_rkey_mode", "revoke",
  "revoke_command", "grant", "grant_command", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "@152", "@153", "@154", "@155", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "grant_user", "opt_column_list", "column_list",
  "column_list_id", "require_clause", "grant_options", "grant_option_list",
  "grant_option", "begin", "@156", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "@157", "union_opt",
  "union_order_or_limit", "@158", "order_or_limit", "union_option",
  "take_first_select", "subselect", "subselect_start", "subselect_end",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_suid", "view_tail", "@159",
  "view_list_opt", "view_list", "view_select", "@160", "view_select_aux",
  "view_check_option", "trigger_tail", "@161", "@162", "@163", "udf_tail",
  "sf_tail", "@164", "@165", "@166", "@167", "@168", "sp_tail", "@169",
  "@170", "@171", "@172", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@173",
  "opt_migrate", "install", "uninstall", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   124,    38,    45,    43,    42,    47,    37,    94,
     126,    40,    41,    44,    33,   123,   125,    64,    46,    59,
      58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   591,   592,   592,   593,   593,   594,   594,   594,   594,
     594,   594,   594,   594,   594,   594,   594,   594,   594,   594,
     594,   594,   594,   594,   594,   594,   594,   594,   594,   594,
     594,   594,   594,   594,   594,   594,   594,   594,   594,   594,
     594,   594,   594,   594,   594,   594,   594,   594,   594,   594,
     594,   594,   594,   594,   594,   594,   594,   595,   596,   596,
     597,   598,   598,   600,   599,   601,   601,   602,   602,   603,
     605,   604,   607,   606,   608,   608,   609,   609,   609,   609,
     609,   609,   609,   609,   609,   609,   609,   609,   609,   610,
     610,   610,   610,   612,   611,   613,   611,   614,   611,   615,
     611,   611,   611,   611,   611,   616,   617,   617,   618,   618,
     618,   618,   618,   618,   618,   620,   619,   622,   621,   621,
     623,   623,   623,   623,   624,   624,   625,   625,   626,   626,
     627,   627,   628,   628,   630,   629,   631,   631,   631,   631,
     631,   631,   631,   631,   631,   631,   631,   631,   631,   632,
     633,   633,   634,   634,   635,   635,   636,   636,   636,   636,
     636,   636,   636,   637,   637,   637,   638,   638,   640,   639,
     641,   641,   642,   642,   643,   643,   644,   644,   645,   645,
     646,   647,   648,   648,   649,   649,   650,   651,   651,   651,
     651,   652,   652,   653,   653,   654,   654,   656,   655,   655,
     657,   655,   655,   659,   658,   660,   660,   661,   661,   662,
     663,   663,   664,   664,   665,   665,   665,   665,   665,   666,
     666,   667,   667,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   670,   669,   672,   671,
     674,   673,   676,   675,   677,   678,   679,   681,   680,   682,
     683,   683,   683,   684,   684,   686,   687,   688,   685,   689,
     689,   689,   690,   690,   692,   693,   691,   695,   694,   696,
     696,   697,   697,   699,   700,   698,   702,   703,   701,   704,
     704,   706,   705,   707,   707,   709,   708,   711,   710,   713,
     712,   714,   715,   716,   714,   717,   714,   718,   718,   719,
     719,   719,   720,   721,   722,   723,   723,   724,   724,   725,
     726,   727,   727,   729,   728,   730,   730,   730,   731,   731,
     731,   732,   733,   733,   733,   734,   734,   734,   734,   734,
     734,   734,   734,   735,   736,   736,   736,   737,   737,   737,
     737,   737,   738,   739,   739,   739,   740,   740,   740,   740,
     740,   740,   740,   741,   742,   742,   742,   743,   743,   743,
     744,   745,   746,   747,   748,   749,   749,   749,   750,   751,
     752,   753,   754,   755,   756,   757,   758,   759,   759,   760,
     760,   761,   761,   762,   762,   762,   762,   763,   764,   763,
     765,   766,   765,   767,   765,   768,   768,   770,   769,   772,
     771,   773,   774,   775,   774,   776,   774,   777,   774,   778,
     778,   779,   779,   780,   780,   781,   782,   783,   784,   784,
     785,   786,   785,   787,   785,   788,   788,   789,   790,   791,
     791,   792,   792,   793,   793,   795,   794,   796,   797,   797,
     797,   798,   798,   799,   799,   800,   801,   801,   802,   803,
     804,   804,   805,   805,   807,   806,   808,   809,   809,   810,
     810,   811,   811,   811,   811,   811,   811,   811,   811,   813,
     814,   812,   815,   815,   816,   816,   817,   817,   818,   818,
     819,   819,   820,   820,   821,   822,   822,   823,   823,   824,
     824,   825,   825,   825,   826,   826,   826,   826,   826,   826,
     826,   826,   826,   826,   826,   826,   826,   826,   826,   826,
     826,   826,   826,   826,   826,   826,   826,   826,   826,   826,
     826,   827,   828,   829,   830,   831,   831,   831,   831,   831,
     831,   831,   832,   832,   832,   833,   833,   834,   834,   834,
     834,   835,   835,   836,   836,   837,   837,   838,   838,   838,
     838,   838,   839,   839,   840,   841,   841,   842,   844,   843,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   846,   845,   847,   845,   845,
     845,   848,   848,   848,   848,   848,   848,   848,   848,   849,
     850,   850,   851,   851,   852,   852,   852,   852,   852,   853,
     853,   853,   853,   853,   854,   854,   854,   855,   855,   855,
     856,   857,   857,   858,   858,   859,   859,   859,   860,   860,
     861,   861,   862,   862,   863,   863,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   865,   865,   866,
     866,   867,   867,   868,   868,   869,   869,   870,   870,   871,
     871,   872,   873,   873,   874,   874,   875,   875,   876,   876,
     876,   876,   876,   876,   877,   877,   878,   878,   878,   878,
     879,   879,   881,   880,   882,   882,   883,   883,   884,   884,
     885,   885,   886,   886,   886,   886,   886,   887,   887,   887,
     887,   887,   888,   888,   888,   889,   889,   890,   890,   891,
     891,   892,   892,   892,   893,   893,   893,   893,   894,   895,
     895,   896,   896,   897,   897,   898,   898,   899,   899,   899,
     900,   900,   900,   901,   901,   902,   902,   903,   903,   904,
     904,   905,   905,   907,   906,   908,   906,   906,   909,   906,
     910,   906,   911,   906,   912,   906,   913,   906,   906,   906,
     906,   906,   906,   914,   914,   914,   914,   915,   915,   916,
     916,   917,   917,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   919,   918,   918,   920,   918,   921,   918,
     918,   918,   922,   923,   923,   925,   924,   926,   926,   926,
     928,   927,   929,   930,   929,   931,   931,   932,   933,   933,
     934,   935,   935,   935,   936,   935,   937,   938,   935,   935,
     935,   935,   935,   935,   935,   935,   935,   935,   935,   935,
     935,   935,   939,   939,   940,   940,   941,   941,   941,   942,
     942,   942,   943,   943,   943,   943,   945,   944,   944,   946,
     944,   944,   947,   948,   948,   950,   949,   951,   951,   952,
     952,   952,   953,   953,   954,   954,   956,   955,   958,   957,
     960,   959,   961,   961,   961,   963,   962,   964,   964,   965,
     965,   966,   966,   966,   968,   967,   969,   971,   970,   972,
     972,   973,   973,   974,   974,   974,   974,   974,   974,   976,
     975,   977,   977,   977,   979,   978,   978,   980,   980,   981,
     981,   982,   983,   984,   984,   985,   986,   986,   988,   987,
     989,   989,   990,   992,   991,   993,   993,   994,   994,   995,
     996,   996,   997,   997,   999,   998,  1001,  1002,  1000,  1003,
    1003,  1003,  1003,  1003,  1004,  1004,  1005,  1005,  1006,  1006,
    1007,  1007,  1007,  1007,  1007,  1007,  1007,  1007,  1007,  1007,
    1008,  1008,  1008,  1009,  1009,  1009,  1010,  1011,  1012,  1013,
    1013,  1014,  1014,  1014,  1014,  1014,  1015,  1015,  1016,  1016,
    1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1017,
    1017,  1017,  1017,  1017,  1017,  1018,  1018,  1018,  1018,  1018,
    1018,  1018,  1018,  1018,  1018,  1018,  1018,  1018,  1018,  1019,
    1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,
    1019,  1019,  1019,  1019,  1020,  1020,  1021,  1021,  1022,  1022,
    1023,  1023,  1024,  1024,  1024,  1024,  1024,  1024,  1025,  1025,
    1026,  1026,  1026,  1026,  1026,  1026,  1026,  1026,  1026,  1026,
    1026,  1026,  1026,  1026,  1026,  1026,  1026,  1026,  1026,  1026,
    1026,  1026,  1026,  1026,  1026,  1026,  1026,  1026,  1026,  1026,
    1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,
    1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,
    1027,  1027,  1027,  1027,  1027,  1027,  1027,  1028,  1028,  1028,
    1028,  1028,  1028,  1028,  1028,  1028,  1028,  1028,  1028,  1028,
    1028,  1028,  1028,  1028,  1028,  1028,  1028,  1028,  1028,  1028,
    1028,  1028,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,
    1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1030,
    1030,  1030,  1030,  1030,  1030,  1030,  1030,  1032,  1031,  1031,
    1033,  1033,  1034,  1034,  1035,  1035,  1036,  1036,  1037,  1037,
    1038,  1039,  1039,  1039,  1039,  1039,  1039,  1039,  1040,  1041,
    1039,  1039,  1039,  1039,  1039,  1039,  1039,  1039,  1039,  1039,
    1039,  1042,  1039,  1044,  1043,  1045,  1045,  1045,  1046,  1046,
    1047,  1047,  1048,  1048,  1050,  1049,  1051,  1051,  1051,  1051,
    1051,  1051,  1051,  1051,  1051,  1051,  1051,  1052,  1052,  1053,
    1053,  1054,  1054,  1055,  1055,  1056,  1056,  1057,  1057,  1058,
    1058,  1059,  1059,  1060,  1061,  1061,  1062,  1062,  1063,  1063,
    1064,  1063,  1065,  1063,  1066,  1063,  1063,  1067,  1063,  1068,
    1063,  1063,  1069,  1063,  1070,  1063,  1063,  1071,  1071,  1071,
    1073,  1072,  1072,  1072,  1075,  1074,  1077,  1078,  1076,  1079,
    1080,  1081,  1081,  1082,  1082,  1082,  1082,  1083,  1083,  1085,
    1084,  1086,  1084,  1087,  1087,  1088,  1089,  1088,  1091,  1090,
    1092,  1092,  1093,  1093,  1094,  1094,  1095,  1095,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1097,  1097,  1098,  1098,  1098,  1098,  1098,  1098,  1098,  1098,
    1098,  1099,  1099,  1099,  1099,  1100,  1100,  1100,  1101,  1101,
    1102,  1102,  1103,  1104,  1103,  1105,  1106,  1105,  1107,  1107,
    1108,  1108,  1109,  1109,  1110,  1110,  1110,  1111,  1112,  1112,
    1113,  1114,  1114,  1116,  1115,  1117,  1117,  1118,  1118,  1118,
    1119,  1119,  1120,  1120,  1121,  1122,  1122,  1122,  1123,  1123,
    1123,  1123,  1124,  1124,  1125,  1125,  1125,  1125,  1125,  1125,
    1126,  1126,  1126,  1126,  1126,  1127,  1127,  1127,  1127,  1127,
    1128,  1128,  1128,  1128,  1129,  1130,  1130,  1131,  1131,  1132,
    1133,  1132,  1134,  1134,  1135,  1135,  1136,  1138,  1137,  1139,
    1139,  1140,  1140,  1142,  1141,  1144,  1143,  1143,  1143,  1146,
    1145,  1147,  1148,  1147,  1147,  1147,  1147,  1147,  1147,  1147,
    1147,  1147,  1147,  1147,  1147,  1149,  1149,  1150,  1151,  1151,
    1152,  1153,  1153,  1154,  1154,  1156,  1157,  1155,  1159,  1160,
    1158,  1161,  1161,  1161,  1161,  1162,  1162,  1163,  1163,  1164,
    1165,  1165,  1165,  1166,  1165,  1167,  1167,  1168,  1168,  1169,
    1168,  1170,  1168,  1171,  1171,  1172,  1172,  1173,  1174,  1174,
    1175,  1175,  1177,  1176,  1178,  1178,  1179,  1179,  1180,  1180,
    1181,  1182,  1181,  1184,  1185,  1183,  1186,  1186,  1187,  1188,
    1188,  1189,  1190,  1190,  1192,  1191,  1194,  1193,  1195,  1193,
    1196,  1193,  1197,  1197,  1198,  1198,  1199,  1199,  1200,  1200,
    1201,  1201,  1201,  1202,  1203,  1203,  1204,  1204,  1205,  1205,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1207,
    1207,  1209,  1208,  1210,  1210,  1210,  1210,  1210,  1210,  1210,
    1210,  1210,  1210,  1210,  1210,  1210,  1210,  1211,  1210,  1210,
    1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,
    1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,
    1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,
    1210,  1210,  1210,  1210,  1212,  1212,  1212,  1213,  1213,  1214,
    1214,  1215,  1215,  1216,  1216,  1217,  1217,  1218,  1218,  1219,
    1219,  1220,  1220,  1220,  1222,  1221,  1223,  1221,  1224,  1224,
    1225,  1225,  1225,  1226,  1226,  1226,  1228,  1227,  1229,  1229,
    1231,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,
    1230,  1230,  1232,  1232,  1234,  1233,  1235,  1235,  1236,  1236,
    1236,  1238,  1237,  1239,  1240,  1240,  1241,  1242,  1242,  1242,
    1243,  1245,  1244,  1244,  1247,  1248,  1249,  1250,  1246,  1246,
    1251,  1251,  1252,  1252,  1252,  1253,  1253,  1253,  1254,  1254,
    1255,  1255,  1256,  1256,  1256,  1256,  1257,  1257,  1258,  1258,
    1259,  1259,  1260,  1260,  1261,  1261,  1261,  1262,  1262,  1263,
    1263,  1264,  1264,  1265,  1265,  1265,  1265,  1266,  1266,  1266,
    1267,  1268,  1268,  1268,  1269,  1269,  1269,  1269,  1269,  1269,
    1269,  1269,  1269,  1269,  1269,  1269,  1270,  1270,  1270,  1270,
    1270,  1271,  1271,  1272,  1272,  1273,  1274,  1274,  1275,  1275,
    1276,  1276,  1276,  1277,  1277,  1277,  1277,  1278,  1278,  1278,
    1279,  1280,  1280,  1281,  1282,  1283,  1284,  1284,  1285,  1285,
    1286,  1286,  1286,  1287,  1287,  1287,  1288,  1288,  1288,  1288,
    1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,
    1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,
    1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,
    1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,
    1288,  1288,  1288,  1288,  1288,  1288,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1291,  1290,
    1292,  1292,  1293,  1293,  1295,  1294,  1296,  1296,  1296,  1296,
    1297,  1297,  1298,  1298,  1298,  1298,  1299,  1299,  1299,  1299,
    1300,  1300,  1301,  1301,  1302,  1302,  1302,  1302,  1302,  1302,
    1302,  1303,  1303,  1303,  1304,  1304,  1304,  1304,  1305,  1305,
    1305,  1306,  1306,  1306,  1306,  1306,  1308,  1307,  1309,  1309,
    1310,  1310,  1311,  1312,  1312,  1312,  1312,  1314,  1313,  1315,
    1315,  1316,  1315,  1317,  1317,  1318,  1318,  1319,  1319,  1319,
    1319,  1320,  1319,  1321,  1321,  1321,  1321,  1321,  1322,  1323,
    1323,  1323,  1323,  1324,  1325,  1325,  1325,  1326,  1326,  1327,
    1327,  1328,  1328,  1329,  1329,  1331,  1330,  1332,  1330,  1333,
    1330,  1334,  1330,  1330,  1330,  1330,  1330,  1330,  1330,  1330,
    1330,  1330,  1330,  1330,  1330,  1330,  1330,  1330,  1330,  1330,
    1330,  1330,  1330,  1330,  1330,  1330,  1330,  1330,  1335,  1335,
    1336,  1336,  1337,  1337,  1337,  1338,  1338,  1338,  1338,  1339,
    1339,  1340,  1340,  1341,  1341,  1341,  1342,  1342,  1343,  1343,
    1344,  1345,  1345,  1345,  1345,  1345,  1346,  1346,  1347,  1347,
    1348,  1348,  1348,  1348,  1348,  1350,  1349,  1351,  1351,  1352,
    1352,  1352,  1353,  1353,  1353,  1354,  1354,  1355,  1356,  1356,
    1357,  1358,  1359,  1359,  1361,  1360,  1362,  1362,  1362,  1364,
    1363,  1365,  1365,  1366,  1366,  1366,  1367,  1368,  1368,  1369,
    1370,  1371,  1371,  1371,  1372,  1372,  1372,  1372,  1372,  1373,
    1373,  1373,  1373,  1373,  1373,  1374,  1374,  1375,  1376,  1377,
    1377,  1377,  1378,  1379,  1379,  1379,  1380,  1380,  1380,  1382,
    1381,  1383,  1383,  1384,  1384,  1386,  1385,  1387,  1387,  1388,
    1388,  1388,  1388,  1390,  1391,  1392,  1389,  1393,  1393,  1395,
    1396,  1397,  1398,  1399,  1394,  1401,  1402,  1403,  1404,  1400,
    1405,  1405,  1405,  1405,  1405,  1405,  1406,  1406,  1406,  1407,
    1407,  1408,  1408,  1408,  1409,  1409,  1410,  1411,  1410,  1412,
    1412,  1413,  1414
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     1,
       4,     1,     2,     0,     4,     0,     2,     3,     1,     2,
       0,     3,     0,     5,     1,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     1,     3,
       3,     3,     3,     0,     7,     0,    12,     0,     6,     0,
       3,     4,     4,     3,     2,    10,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     0,    12,     0,     6,     2,
       0,     1,     3,     1,     0,     2,     0,     2,     0,     1,
       3,     4,     0,     2,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     1,     0,     2,     0,     2,     2,     2,     2,     2,
       3,     3,     1,     1,     1,     2,     3,     3,     0,     4,
       0,     3,     0,     1,     3,     1,     0,     1,     3,     1,
       0,     3,     0,     1,     3,     1,     4,     0,     1,     1,
       1,     0,     3,     2,     3,     0,     3,     0,     5,     5,
       0,     7,     5,     0,     2,     1,     1,     1,     3,     1,
       1,     3,     0,     1,     1,     1,     1,     2,     1,     1,
       3,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     5,     0,     2,
       0,     3,     0,     2,     2,     2,     2,     0,     6,     2,
       0,     2,     1,     1,     3,     0,     0,     0,     7,     0,
       2,     2,     1,     1,     0,     0,     8,     0,     6,     1,
       2,     1,     2,     0,     0,     6,     0,     0,     6,     0,
       2,     0,     5,     0,     1,     0,     5,     0,     2,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     4,     5,     0,     4,     4,     4,     3,
       3,     2,     2,     0,     2,     1,     2,     3,     1,     1,
       1,     1,     1,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       2,     2,     2,     1,     1,     1,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     0,     1,     1,
       1,     1,     1,     2,     3,     2,     4,     5,     0,     5,
       0,     0,     5,     0,     7,     0,     1,     0,     3,     0,
       3,     5,     5,     0,     4,     0,     3,     0,     3,     0,
       1,     0,     1,     1,     3,     1,     5,     5,     0,     2,
       0,     0,     7,     0,     9,     1,     3,     1,     1,     0,
       2,     0,     3,     1,     3,     0,     6,     1,     0,     4,
       5,     1,     1,     1,     3,     3,     1,     3,     1,     1,
       0,     3,     1,     3,     0,     4,     1,     0,     1,     2,
       1,     3,     4,     3,     3,     3,     4,     4,     3,     0,
       0,     6,     0,     1,     0,     1,     1,     2,     1,     1,
       0,     1,     1,     2,     1,     0,     3,     0,     1,     1,
       2,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       1,     1,     3,     4,     4,     2,     2,     2,     3,     3,
       3,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     3,     1,     1,     2,     2,     7,     8,     8,
       2,     2,     0,     1,     2,     0,     1,     2,     0,     4,
       3,     3,     3,     1,     4,     1,     1,     5,     2,     5,
       2,     4,     1,     5,     5,     4,     3,     1,     1,     2,
       1,     1,     2,     1,     1,     1,     2,     3,     2,     3,
       2,     2,     3,     3,     3,     0,     6,     0,     6,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     2,     1,     2,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     2,     0,     3,     1,
       5,     0,     1,     2,     1,     1,     1,     1,     0,     3,
       0,     1,     0,     1,     2,     1,     1,     2,     2,     4,
       1,     3,     2,     1,     2,     2,     2,     2,     1,     2,
       1,     1,     1,     1,     1,     0,     2,     1,     1,     1,
       1,     1,     0,     2,     1,     1,     0,     1,     0,     2,
       1,     2,     3,     2,     0,     1,     0,     1,     1,     2,
       0,     1,     0,     4,     1,     4,     3,     1,     0,     1,
       2,     1,     3,     3,     2,     2,     2,     1,     1,     2,
       2,     2,     1,     2,     2,     2,     2,     1,     1,     0,
       1,     1,     1,     1,     0,     1,     1,     1,     0,     1,
       2,     0,     1,     1,     2,     2,     2,     1,     3,     3,
       1,     1,     1,     4,     2,     1,     4,     0,     1,     0,
       2,     1,     3,     0,     6,     0,     5,     7,     0,     5,
       0,     5,     0,     5,     0,     4,     0,    10,     3,     4,
       3,     3,     7,     0,     3,     1,     4,     0,     3,     0,
       2,     0,     1,     0,     2,     2,     2,     2,     1,     1,
       1,     3,     4,     0,     6,     4,     0,     5,     0,     6,
       4,     1,     2,     1,     1,     0,     5,     0,     3,     2,
       0,     5,     0,     0,     6,     1,     3,     1,     1,     3,
       2,     3,     2,     4,     0,     6,     0,     0,     8,     4,
       4,     3,     3,     2,     2,     6,     5,     3,     5,     1,
       1,     1,     0,     1,     0,     1,     0,     1,     1,     0,
       2,     1,     0,     1,     1,     1,     0,     5,     3,     0,
       5,     3,     3,     0,     3,     0,     2,     1,     3,     0,
       1,     1,     0,     2,     1,     3,     0,     6,     0,     6,
       0,     5,     0,     1,     1,     0,     6,     0,     1,     1,
       2,     1,     1,     1,     0,     5,     2,     0,     5,     0,
       1,     1,     2,     1,     1,     1,     1,     1,     2,     0,
       5,     0,     1,     1,     0,     4,     4,     3,     5,     1,
       3,     3,     5,     1,     3,     2,     1,     1,     0,     6,
       1,     3,     3,     0,     2,     0,     4,     0,     2,     1,
       2,     4,     2,     3,     0,     3,     0,     0,     6,     2,
       1,     1,     2,     2,     8,     4,     0,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     4,     3,     1,     1,     4,     0,     0,     1,
       1,     0,     2,     2,     1,     1,     0,     2,     3,     3,
       3,     2,     3,     4,     3,     4,     3,     4,     1,     3,
       4,     3,     3,     6,     1,     5,     6,     5,     7,     6,
       8,     5,     6,     4,     4,     5,     3,     4,     1,     3,
       3,     3,     3,     3,     3,     5,     5,     3,     3,     3,
       3,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     1,     1,
       3,     2,     2,     2,     2,     3,     3,     5,     6,     4,
       4,     7,     2,     6,     5,     6,     6,     4,     4,     5,
       4,     6,     2,     4,     4,     4,    10,     6,     8,     6,
       4,     4,     6,     4,     4,     4,     6,     4,     7,     7,
       7,     6,     6,     6,     6,     3,     4,     6,     8,     2,
       2,     4,     8,     8,     6,     6,     2,     4,     6,     6,
       8,     8,     6,     8,     6,     2,     4,     8,     8,     2,
       2,     2,     4,     4,     4,     4,     3,     8,     4,     6,
       4,     4,     4,     6,     8,     6,     4,     6,     1,     6,
       4,     4,     4,     4,     4,     6,     4,     0,     5,     6,
       2,     3,     0,     4,     0,     3,     0,     1,     1,     3,
       4,     4,     5,     4,     4,     4,     5,     4,     0,     0,
       7,     4,     5,     4,     5,     4,     4,     4,     4,     4,
       5,     0,     8,     0,     3,     3,     1,     4,     0,     1,
       0,     2,     0,     1,     0,     3,     2,     3,     2,     1,
       2,     1,     2,     1,     1,     1,     2,     0,     1,     1,
       3,     1,     3,     1,     3,     0,     1,     0,     2,     4,
       5,     1,     1,     1,     1,     4,     1,     3,     3,     3,
       0,     6,     0,     6,     0,     8,     4,     0,     8,     0,
      10,     6,     0,     8,     0,    10,     6,     1,     2,     2,
       0,     4,     3,     6,     0,     3,     0,     0,     5,     0,
       1,     0,     1,     0,     2,     3,     3,     1,     1,     0,
       7,     0,     7,     1,     2,     0,     0,     2,     0,     2,
       0,     1,     1,     1,     1,     3,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     0,     2,
       0,     1,     0,     0,     3,     0,     0,     3,     2,     0,
       0,     4,     4,     2,     0,     2,     2,     3,     3,     1,
       2,     0,     1,     0,     4,     4,     2,     0,     1,     1,
       0,     1,     0,     1,     2,     1,     3,     3,     1,     1,
       1,     1,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       0,     6,     0,     1,     3,     1,     3,     0,     2,     3,
       1,     2,     1,     0,     3,     0,     5,     2,     1,     0,
       3,     6,     0,     6,     4,     6,     4,     4,     4,     5,
       4,     4,     5,     6,     4,     1,     3,     1,     1,     3,
       1,     0,     2,     0,     1,     0,     0,     8,     0,     0,
       6,     0,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     3,     4,     0,     3,     3,     1,     2,     2,     0,
       3,     0,     5,     3,     1,     3,     1,     3,     1,     1,
       0,     1,     0,     4,     0,     1,     3,     1,     1,     1,
       0,     0,     6,     0,     0,    11,     3,     1,     3,     3,
       1,     3,     0,     1,     0,     4,     0,     6,     0,     5,
       0,     6,     1,     3,     3,     5,     0,     2,     0,     2,
       1,     1,     1,     3,     0,     1,     0,     1,     1,     3,
       1,     1,     2,     2,     2,     1,     1,     1,     1,     0,
       3,     0,     3,     2,     4,     4,     3,     4,     4,     2,
       1,     3,     3,     6,    16,     2,     2,     0,     6,     5,
       2,     2,     2,     1,     1,     1,     5,     5,     2,     2,
       1,     4,     3,     2,     2,     2,     3,     2,     2,     1,
       3,     4,     3,     3,     2,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     1,     1,     1,     1,     1,     0,
       1,     0,     2,     0,     1,     1,     1,     0,     2,     0,
       2,     0,     2,     2,     0,     4,     0,     4,     1,     1,
       0,     1,     1,     0,     1,     1,     0,     4,     3,     1,
       0,     3,     4,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     0,     3,     3,     1,     1,     1,
       2,     0,     3,     3,     2,     2,     3,     0,     1,     1,
       2,     0,     4,     5,     0,     0,     0,     0,    18,     2,
       0,     1,     0,     1,     1,     0,     1,     1,     0,     2,
       2,     1,     3,     4,     3,     3,     0,     2,     2,     1,
       3,     3,     0,     3,     0,     3,     2,     3,     1,     1,
       2,     0,     2,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     3,     5,     1,     1,     1,     1,     1,
       3,     4,     5,     1,     5,     3,     2,     1,     3,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       0,     1,     1,     3,     0,     2,     1,     1,     1,     1,
       0,     1,     0,     1,     1,     1,     0,     2,     2,     2,
       1,     2,     4,     5,     4,     6,     2,     3,     3,     3,
       5,     1,     3,     3,     2,     2,     2,     1,     1,     4,
       4,     1,     1,     1,     1,     1,     0,     4,     1,     1,
       1,     3,     3,     1,     1,     2,     2,     0,     3,     4,
       3,     0,     7,     1,     2,     1,     1,     1,     1,     1,
       1,     0,     5,     1,     1,     1,     1,     1,     3,     6,
       6,     6,     7,     3,     8,     8,     8,     0,     1,     1,
       2,     0,     1,     1,     3,     0,     3,     0,     3,     0,
       3,     0,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     1,     0,     1,
       3,     1,     2,     2,     2,     1,     3,     3,     1,     1,
       3,     1,     3,     4,     5,     1,     0,     3,     3,     1,
       1,     0,     2,     2,     2,     2,     0,     2,     2,     1,
       2,     2,     2,     2,     2,     0,     3,     0,     1,     0,
       3,     2,     0,     1,     2,     0,     1,     4,     4,     5,
       2,     3,     0,     1,     0,     4,     0,     1,     1,     0,
       2,     2,     1,     0,     1,     1,     0,     5,     6,     0,
       0,     2,     2,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     3,     1,
       2,     1,     2,     3,     3,     3,     0,     3,     3,     0,
       7,     0,     3,     1,     3,     0,     3,     2,     4,     0,
       3,     4,     4,     0,     0,     0,    16,     8,     7,     0,
       0,     0,     0,     0,    15,     0,     0,     0,     0,    12,
       4,     4,     3,     4,     3,     2,     1,     3,     5,     1,
       1,     0,     1,     1,     0,     2,     0,     0,     3,     0,
       2,     5,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       0,  2297,   911,     0,  2245,     0,     0,     0,     0,     0,
       0,  2247,    99,    58,  1504,  1618,  1619,  1419,  1443,     2,
       0,   911,   149,     0,    70,  1445,     0,  1657,     0,     0,
     911,   399,     0,  1651,     0,     0,   911,  1448,  1644,     0,
     149,  2247,     0,   946,  2080,  1541,     0,     0,     0,  1524,
       0,  2137,  1493,     0,     0,     0,     0,     0,     4,    16,
       0,    35,    21,    25,    11,    15,    10,    33,     6,    49,
      50,    42,     8,    13,    39,     7,     9,    12,    31,    38,
      32,    34,    46,   939,    19,    20,    26,    40,    54,    17,
      51,    48,    18,  1620,    22,    41,    36,    28,    55,    29,
      47,    30,    53,    24,    43,    23,     5,    14,    44,    45,
      37,    56,    27,    52,     0,   781,     0,     0,   845,     0,
       0,     0,     0,     0,   764,  2295,  2296,  2297,   913,   912,
       0,  2129,  2128,   878,  2247,  1753,   896,     0,  1816,  1817,
    1818,  1819,  1820,  1821,  1822,  1767,  1823,  1824,  1826,  1825,
    1827,  1828,  1768,  1769,  1829,  1830,  1831,  1833,  1832,  1834,
    1770,  1771,  1835,  1836,  1837,  1772,  1773,  1838,  1839,  1774,
    1840,  1841,  1842,  1843,  1775,  1844,  1776,  1845,  1846,  1847,
    1848,  1849,  1850,  1777,  1851,  1852,  1853,  1854,  1856,  1855,
    1857,  1858,  1859,  1778,  1860,  1861,  1862,  1863,  1864,  1865,
    1866,  1779,  1867,  1868,  1869,  1885,  1780,  1870,  1873,  1872,
    1871,  1874,  1875,  1877,  1876,  1878,  1781,  1879,  1880,  1881,
    1883,  1882,  1887,  1888,  1889,  1782,  1884,  1890,  1886,  2060,
    1892,  1891,  1893,  1895,  1894,  1783,  1896,  1784,  1785,  1897,
    1898,  1751,  1899,  1752,  1901,  1902,  1903,  1908,  1909,  1786,
    1900,  1904,  1905,  1906,  1907,  1910,  1787,  1911,  1912,  1913,
    1914,  1915,  1916,  1917,  1918,  1919,  1920,  1930,  1923,  1925,
    1926,  1928,  1924,  1929,  1933,  1932,  1934,  1935,  1936,  1931,
    1922,  1927,  1937,  1938,  1921,  1939,  1940,  1941,  1942,  1943,
    1944,  1945,  1946,  1947,  1948,  1949,  1951,  1950,  1952,  1953,
    1954,  1955,  1956,  1958,  1957,  1959,  1960,  1961,  1963,  1962,
    1965,  1966,  1788,  1964,  1967,  1968,  1969,  1970,  1971,  1789,
    1790,  1791,  1972,  1973,  1974,  1792,  1975,  1976,  1977,  1793,
    1978,  1979,  1981,  1980,  1982,  1983,  1794,  1795,  1984,  1985,
    1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,  1995,
    1996,  1998,  1997,  1999,  2000,  2001,  2002,  2003,  1796,  2004,
    1797,  2005,  2006,  1798,  2007,  1799,  2008,  2009,  1800,  2010,
    2011,  2012,  2013,  2014,  2015,  1801,  2016,  2017,  1802,  2019,
    2018,  2020,  1803,  2022,  2023,  1804,  2021,  1806,  2024,  1805,
    1807,  2025,  2026,  2028,  2027,  2029,  2030,  2031,  1808,  2032,
    1809,  2033,  2034,  2035,  2036,  2038,  2037,  2039,  2040,  2041,
    2042,  2043,  2045,  2044,  2046,  2047,  2048,  2049,  2053,  2054,
    2055,  2056,  2050,  2051,  2052,  1810,  2057,  2058,  2059,  2061,
    2062,  2064,  2063,  1811,  1812,  2065,  2066,  1815,  2067,  2068,
    2071,  2069,  2070,  2073,  2072,  2074,  2075,  1813,  2076,  1814,
    2077,   168,  1756,   151,  1757,  1766,     0,   880,   897,  2248,
    2249,   485,   726,     0,     0,   727,     0,   484,   725,   149,
    2297,   104,     0,   481,   482,     0,  1518,     0,  1441,  1441,
    1441,     0,     0,  1441,  1441,     0,  1444,  1441,   149,  1441,
       0,    63,  1626,     0,     0,     0,     0,  1750,     0,  1451,
       0,  1658,  1659,     0,  1661,     0,     0,  2126,     0,     0,
       0,     0,     0,   149,   914,     0,  1502,     0,   876,     0,
    2249,  2260,   940,   944,   956,  2081,  2078,  1603,   865,   865,
     865,   863,   865,  1525,     0,     0,     0,  1502,  1660,  2349,
       0,     0,     0,  2345,     0,  2350,     0,   946,     0,     0,
       1,     3,     0,  1880,  1977,  1616,  1614,  1747,     0,   755,
     782,     0,   760,     0,   758,  1762,  1761,  1760,     0,   771,
     770,   768,     0,   363,     0,     0,  2306,   762,   894,     0,
    2246,     0,   923,   933,   170,     0,    72,     0,     0,     0,
    2252,     0,     0,     0,     0,   103,     0,     0,     0,   100,
     977,   977,  2297,  2299,  2301,   485,   483,     0,  1522,  1521,
    1520,     0,  1518,  1817,  1767,  1828,     0,  1720,     0,     0,
       0,  1225,     0,  1772,     0,  1840,  1842,  1777,     0,     0,
     986,   986,   986,     0,     0,     0,  1858,  1859,  1729,     0,
       0,     0,  1717,  1730,  1892,  1893,     0,  1719,  1898,     0,
       0,     0,     0,  1915,  1727,     0,     0,  1946,  1948,     0,
       0,  1952,  1953,  1954,  1955,  1704,  1041,     0,   986,  1716,
    1726,  1969,  1710,  1978,  1982,  1983,     0,  1991,     0,     0,
       0,  2014,  2017,     0,     0,  2035,     0,     0,   986,  1703,
    2053,  2054,  2055,  2056,     0,  1718,  1810,  1728,     0,  2067,
     986,   986,   986,     0,     0,     0,  2074,  2077,     0,     0,
       0,     0,  1040,     0,  1193,     0,  1219,   998,  1004,  1018,
       0,  1033,  1051,  1052,  1054,  1148,  1053,  1059,  1058,  1420,
    1714,  1057,  1056,  1715,  1050,  1737,  1756,  1736,     0,     0,
       0,     0,     0,     0,     0,     0,  1599,     0,     0,     0,
    1441,    65,     0,  2171,  2186,  2187,  2183,  2188,  2206,  2189,
    2193,     0,  2185,  2177,     0,  2192,  2181,  2190,     0,  2175,
       0,  2191,  2196,  2207,  2179,  2184,  2163,     0,  2169,  2173,
    1749,  1325,  2140,  2141,     0,    71,  1453,  1454,  1452,   844,
       0,  1656,  1672,     0,     0,     0,   909,   409,   400,     0,
    1598,  1597,     0,  1652,  2261,     0,     0,   885,  1456,  1503,
       0,  1455,  1649,     0,  1648,  1645,  1647,     0,  2171,  2158,
       0,  2255,  2252,  2262,   969,   962,   961,   964,   965,   968,
     966,   967,   963,   960,   977,   957,   959,  2084,  1563,     0,
     660,     0,  1611,     0,  1564,     0,     0,  1611,     0,  1360,
    1601,  1604,     0,  2093,  1579,   723,   722,     0,   721,  2094,
    1597,     0,     0,     0,  1550,  1565,     0,  1526,  1570,  2095,
       0,  1600,     0,  1360,  1611,     0,  1542,     0,     0,     0,
       0,   859,   869,   861,   856,     0,   862,   858,  1523,  1437,
    2362,  2138,   844,  1709,  1708,  1754,  2346,  1707,  2354,  2356,
    2342,  2344,  2351,   942,     0,  2266,    57,     0,  1623,  2304,
    2305,  2303,   676,     0,   986,  1763,  2298,   152,   769,     0,
     364,   152,     0,     0,     0,     0,     0,   365,   366,   302,
     753,   766,     0,     0,   765,  2306,     0,     0,  1435,     0,
       0,   925,   935,   172,   169,   150,     0,   882,   899,  2251,
       0,     0,  2253,  2257,  1039,  1038,     0,    97,   102,     0,
       0,     0,  2225,   101,  2221,  2302,   977,   485,   977,   977,
    2294,     0,  2282,  2289,  2290,  2293,  2292,  2291,  2288,     0,
    2281,  2284,  2285,  2287,  2286,  2306,  2300,     0,   728,     0,
    1505,  1508,  1512,  1516,  1519,     0,     0,  1330,  1072,  1330,
    1330,  1330,  1226,     0,     0,     0,     0,     0,     0,     0,
       0,  1330,     0,  1109,  1082,     0,  1110,     0,     0,     0,
       0,     0,  1723,     0,     0,     0,     0,     0,     0,  1198,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1221,
    1223,  1736,  1330,     0,     0,  1330,     0,     0,     0,     0,
       0,   991,     0,  1116,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1330,  1330,     0,     0,  1330,
       0,  1125,     0,  1725,     0,     0,     0,  1724,     0,     0,
    1722,  1721,  1705,     0,  1129,  1131,  1130,     0,  1330,  1330,
       0,     0,  1062,  1061,  1063,  2279,     0,     0,     0,     0,
       0,     0,  1037,  1036,  1035,  1034,     0,     0,     0,  1042,
       0,  1043,  1044,     0,  1045,  1046,  1047,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1064,     0,     0,     0,
    1706,  1157,     0,  1442,  1424,  1430,  1426,     0,  1599,  1427,
    1434,   377,     0,  1431,  2219,  1428,   846,     0,     0,    64,
    1640,  1634,  1636,  1639,  1635,     0,  1641,  1638,  1637,  2129,
    1627,  1629,  1630,  2172,  2170,  2204,  2203,     0,  2205,  2201,
    2194,  2226,  2198,  2226,  2200,  2199,  2226,  2195,  2202,  2226,
    2167,     0,  1326,  1327,     0,  2139,     0,  1748,     0,     0,
    1673,     0,  1674,  1662,  1670,   928,     0,  1325,  2127,  2130,
       0,   410,   407,   405,   418,     0,     0,    60,    61,     0,
     916,     0,   915,   919,     0,     0,     0,  1459,  1449,  1458,
    1650,     0,     0,  2170,  2167,  2256,     0,  2258,  2273,   945,
    2263,   975,   947,   974,     0,   958,  2079,  2082,  2090,  1607,
     659,     0,     0,  1578,  1560,     0,   485,     0,     0,     0,
       0,     0,     0,  1543,     0,     0,   524,     0,  1569,  1361,
    1605,  1606,  1611,     0,     0,  1611,     0,  1573,  1584,  1574,
       0,  1601,     0,  1611,  1538,     0,     0,  1530,  1535,  1531,
       0,  1537,  1536,  1539,  1527,  1528,  1556,  1585,  1601,  1561,
    1568,  1577,     0,  1555,  1562,     0,  1549,  1575,  1601,  1601,
    1611,  1611,   872,   871,   870,   866,   867,   872,     0,  1260,
       0,     0,  2343,  2357,  2341,  2352,  2353,  2340,   943,  2267,
     941,  2268,     0,  1617,  1615,  1624,  1625,   677,   676,   476,
     479,   478,     0,     0,  1765,     0,   761,     0,  1599,   759,
       0,     0,  1599,   313,  1599,   367,   676,   773,     0,     0,
     763,   895,     0,     0,   927,   922,   926,   924,   718,   717,
       0,   934,     0,   173,   175,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,    74,    88,   884,   883,   881,   907,   906,   904,
       0,   905,   903,   898,   900,   901,  2250,  2254,   486,   676,
    1599,     0,   305,     0,     0,     0,     0,     0,     0,     0,
       0,  2283,    93,   729,     0,  1510,  1438,  1506,     0,     0,
       0,  1325,     0,     0,  1331,  1330,     0,  1204,     0,     0,
       0,     0,  1227,     0,     0,     0,     0,     0,     0,     0,
    1178,     0,  1204,   987,     0,  1136,     0,     0,     0,     0,
       0,  2279,     0,  1299,  1300,  1301,  1302,  1312,  1303,  1304,
    1305,  1314,  1319,  1306,  1307,  1315,  1316,  1317,  1308,  1318,
    1313,  1309,  1320,     0,  1298,     0,  1323,  1321,  1324,  1322,
       0,  1199,  1191,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1330,     0,     0,     0,  1330,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1330,     0,     0,     0,  1311,     0,  1310,     0,     0,
       0,     0,     0,     0,     0,  1105,     0,  1739,  1738,     0,
       0,     0,     0,   946,     0,  1066,     0,  1065,     0,  2096,
    1194,  1196,     0,   989,   988,   990,  1001,   994,   999,   992,
     996,     0,  1048,  1822,  1002,     0,     0,  1030,     0,  1339,
    1031,  1016,  1021,  1022,     0,  1019,  1020,     0,  1024,     0,
    1023,  1027,  1028,  1029,  1032,     0,     0,     0,     0,  1055,
    1060,  1220,   977,  1740,     0,  1422,   377,   380,   379,  1432,
     378,  1480,     0,   848,   847,  1429,   846,     0,    66,    68,
    1633,     0,     0,  1642,  2197,     0,  2178,  2182,  2176,  2180,
       0,     0,  2168,     0,  2174,  1329,  1888,  1962,     0,  1332,
    2143,  1446,  2361,  1669,  1671,     0,     0,  1663,     0,     0,
     910,     0,     0,     0,   420,   403,     0,    62,     0,     0,
    1653,     0,     0,     0,     0,   887,  1457,     0,  1646,     0,
       0,     0,     0,     0,  2259,  2275,  2274,  2264,   977,  1351,
     978,   980,   979,  1736,  2084,  2087,  2088,  2091,  2089,     0,
    2086,  2085,  2100,     0,  1609,  1612,  1613,     0,     0,  1593,
    1587,  1586,  1582,  1588,  1583,  1596,  1595,  1594,  1552,  1551,
    1370,  1371,  1369,  1364,  1365,  1368,  1546,  1602,  1592,  1590,
    1580,     0,  1611,  1591,  1589,  1532,  1533,  1534,     0,  1360,
       0,  1611,  1601,     0,  1611,  1611,  1572,  1576,     0,   860,
     869,   857,   864,  1270,  1269,     0,  1234,     0,  1236,  1233,
    1232,  1231,     0,  1269,  2347,  2355,  2359,     0,  1360,  2272,
    2270,   477,  1480,  1480,     0,  1764,     0,     0,     0,     0,
       0,     0,     0,   153,   162,     0,     0,   311,   312,  1480,
     310,   353,   354,   357,   358,   359,     0,     0,     0,     0,
       0,     0,     0,     0,   106,   360,  1480,  1480,   307,   333,
     334,   337,   338,   339,   340,   341,   303,     0,   308,   842,
     842,     0,  1480,  1480,   842,  1480,     0,     0,  1480,  1480,
       0,     0,  1480,     0,     0,   842,     0,  1480,   840,     0,
       0,  1480,  1480,  1480,  1480,   842,     0,     0,  1480,  1480,
     397,  1480,     0,     0,   852,     0,     0,  1480,     0,     0,
    1480,  1480,  1480,  1480,   789,   839,   489,   510,   511,   754,
     788,   790,   801,   395,     0,   818,   841,     0,   775,   777,
    2307,  2308,  2309,   879,  1436,  1290,   171,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   908,   902,    98,   676,  1480,
    1480,  1480,  1480,   309,   342,   343,   346,   347,   348,   349,
     352,   350,   351,     0,     0,  1599,     0,  2222,     0,   115,
    2335,     0,     0,   151,   487,     0,     0,   730,     0,     0,
       0,  1332,  1513,  1260,  1517,  1516,  1514,     0,  1132,     0,
    1171,     0,  1173,  1174,  1175,     0,     0,     0,     0,     0,
    1133,     0,  1080,  1134,  1135,     0,     0,     0,     0,  1177,
       0,  1111,     0,     0,  1083,  1084,  1077,  1069,     0,  1150,
       0,     0,  1085,     0,     0,     0,     0,     0,  1151,  1222,
       0,  1224,  1740,     0,  1183,  1138,  1090,     0,  1181,     0,
    1091,  1152,  1153,  1154,  1117,  1140,  1141,     0,  1156,     0,
    1142,     0,     0,     0,     0,  1093,  1187,  1185,     0,     0,
       0,     0,  1189,  1126,  1095,     0,     0,     0,  1094,     0,
       0,     0,     0,     0,     0,     0,  1097,     0,  1078,  1186,
    1188,  1146,     0,  1106,  2276,  2276,     0,  1070,     0,     0,
       0,     0,     0,  1741,   995,  1000,   993,   997,     0,     0,
       0,     0,     0,  1014,  1013,     0,     0,     0,     0,  1339,
    1017,     0,     0,  1167,  1168,  1217,     0,  1425,  1423,  1433,
    1478,  1479,  1481,     0,  2220,  1421,    69,     0,     0,  1628,
    1643,  1631,  2230,     0,  2229,  2215,  2218,  1747,     0,     0,
       0,  2153,  2147,  2154,  2156,  2150,  2155,  2157,  2148,  2149,
    2144,  2151,  1333,  1362,     0,     0,   929,   930,   933,     0,
    2133,  2134,  2132,  2131,   977,   408,   406,  1395,  1396,  1381,
    1382,  1380,  1383,   419,  1384,  1394,     0,   431,     0,   411,
    1655,  1654,     0,   917,   920,   921,   892,   891,   893,   886,
     888,   889,   469,  1463,     0,     0,     0,  1469,  1450,  1460,
     877,     0,     0,     0,     0,     0,   973,  1260,  1413,   970,
     951,  1362,  1352,   950,   981,     0,  2083,     0,  2050,  2111,
       0,     0,     0,     0,     0,  2101,  1608,     0,  1557,     0,
    1581,     0,     0,     0,  1548,     0,  1571,  1529,  1547,  1332,
    1601,  1544,  1545,   874,   873,   868,  1269,  1260,     0,     0,
    1257,  1271,     0,  1271,  1260,  1260,     0,  1260,  1325,  1266,
       0,     0,  2358,  1353,  2271,     0,     0,   757,   156,   159,
     157,     0,   158,     0,     0,   362,   361,     0,  1599,   355,
     110,   109,   111,   112,  1378,  1379,  1375,  1376,  1374,  1377,
     114,   113,   108,   772,     0,     0,     0,  1599,   335,   314,
     315,   318,   319,   320,   843,   747,   719,   911,   719,   822,
       0,   552,   747,   712,   820,     0,   911,     0,     0,     0,
       0,     0,   911,     0,     0,     0,  1480,     0,   833,   784,
       0,     0,     0,     0,     0,   834,     0,   785,  1480,     0,
       0,     0,     0,     0,   911,     0,     0,     0,     0,     0,
     911,   802,   855,   854,   853,     0,   911,   911,     0,   516,
     517,   515,     0,     0,     0,     0,   490,   676,   786,   396,
     787,   555,     0,   849,   552,   558,  1743,     0,     0,     0,
     120,  2311,  1293,     0,  1294,  1291,  1292,   174,    80,    76,
      89,  1388,  1389,  1387,  1385,  1386,    90,    78,    79,    83,
      82,    84,    85,    86,    81,    87,    77,    91,    92,    75,
       0,     0,     0,     0,  1599,   344,     0,     0,  1480,   304,
     321,   322,   325,   326,   327,   328,   329,   332,   330,   331,
       0,  2223,     0,     0,     0,   298,   297,     0,  2329,     0,
       0,   555,    94,   395,   488,   491,   740,   742,   741,   736,
     735,    95,  1439,  1440,  1260,  1351,  1332,     0,  1325,     0,
       0,  1172,  1205,     0,  1228,     0,  1074,   638,   638,  1215,
    1213,   627,   638,  1209,  1214,  1211,     0,   662,     0,   661,
       0,     0,     0,  1179,  1176,     0,     0,     0,     0,  1202,
       0,     0,     0,  1079,     0,  1162,  1184,  1182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1190,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2280,  2280,  1067,  2097,  2098,  2099,   749,  1195,
       0,  1011,  1007,     0,  1005,  1338,  1026,  1025,     0,     0,
       0,  1015,   978,  1158,   977,     0,  1218,  1742,   376,   523,
      67,  1632,  2227,     0,     0,     0,     0,     0,     0,     0,
       0,  2142,  1363,  1490,  1755,  1664,     0,   937,  2135,  2136,
       0,   409,     0,   401,   404,     0,   412,   413,   415,     0,
     890,   956,     0,  1482,  1467,  1474,  1468,     0,     0,     0,
    1466,  1732,  1731,  1738,  2262,     0,     0,     0,     0,  2265,
    1332,  1332,  1407,     0,     0,   948,   953,   949,   952,     0,
     976,   985,   984,  1733,  1740,     0,     0,     0,     0,   664,
     663,   672,     0,     0,     0,  2096,     0,   668,   670,   669,
    2106,   667,  1610,  1360,  1567,  1566,  1367,  1366,     0,  1540,
    1559,  1611,     0,  2269,  1264,     0,  1259,  1258,  1272,     0,
    1260,  1271,  1271,     0,  1239,  1238,  1494,  1497,     0,  1237,
    1288,  1262,   956,  2348,  2360,     0,   675,   674,   522,   671,
     521,   161,   160,   166,   167,   382,   368,   381,   356,   107,
     369,   370,   336,     0,   316,   557,   748,   720,   713,   805,
     714,     0,     0,     0,   719,   551,   747,   550,   553,   728,
       0,     0,   501,   498,   824,   504,   803,   796,   804,   815,
     817,     0,   500,   518,     0,     0,   507,   747,   791,   831,
     832,   846,   494,     0,   533,   534,   532,   512,   519,   496,
     497,   826,     0,  1347,  1349,  1357,   503,   502,  1398,  1397,
     506,   398,   499,     0,   837,   810,     0,   530,   528,   525,
     527,   526,   531,   529,   508,   505,   520,   495,  1642,   842,
     842,   819,     0,   541,   543,   544,  1746,     0,   851,   821,
       0,   545,   546,     0,     0,     0,   130,     0,     0,   774,
       0,   123,   121,   132,     0,     0,   936,     0,   375,   374,
     373,   372,   345,     0,     0,     0,  1599,   323,  2224,     0,
       0,  2336,   301,   299,   300,     0,   176,   539,   540,   538,
     537,     0,   385,     0,  1793,   383,     0,     0,  1675,   676,
     492,     0,  1332,  1372,  1509,  1515,     0,  1107,  1229,     0,
       0,  1206,   678,     0,  1216,   629,  1208,  1210,  1212,  1073,
    1081,  1149,  1076,  1075,     0,     0,     0,  1114,  1115,  1200,
    1203,     0,     0,  1087,     0,  1089,     0,     0,  1164,  1139,
    1155,  1118,  1143,     0,  1092,  1068,     0,  1119,     0,  1124,
    1122,     0,  1096,     0,     0,  1103,     0,  1101,     0,  1102,
       0,  1104,  1145,  1147,  2277,     0,     0,  1197,  1003,     0,
    1012,  1009,     0,  1006,   981,  1169,  1159,  2228,  2217,  2216,
    2231,  2231,  2231,     0,  1334,     0,  1447,  1675,   931,     0,
     932,   978,   428,     0,   435,     0,   433,   402,     0,   918,
     977,  1464,  1476,     0,  1484,     0,     0,  1461,  1471,     0,
       0,     0,  1470,     0,  2160,  2161,  2159,  1362,  1340,     0,
       0,  1418,     0,  1414,   971,     0,   983,   982,     0,  2113,
       0,  2112,  2124,  2125,  2122,  2123,  2121,  2102,     0,  2108,
    2107,     0,     0,     0,  2118,  2109,     0,     0,  1558,     0,
    1553,   875,     0,  1260,  1235,  1260,  1246,     0,     0,  1260,
    1242,  1240,  1244,     0,  1332,     0,  1261,  1285,   977,  1735,
    1354,  1357,   317,   807,   554,   747,   715,   716,   728,     0,
       0,     0,   795,     0,   899,     0,   800,   672,   513,   830,
     829,   514,     0,   793,     0,  1358,  1359,  1350,   792,   812,
     798,     0,   823,   555,   850,   692,   623,   572,   563,   638,
     566,   565,   609,   580,   577,   627,   625,   595,   627,   627,
     602,   601,   619,   605,   585,   678,   678,   584,   622,   678,
     606,   604,   608,     0,   610,   627,   615,   603,   607,   624,
     600,   597,   621,   638,   638,   578,   581,   620,   678,     0,
     613,   638,   642,   583,   678,   684,     0,     0,   638,   640,
    1745,   131,   119,     0,     0,   776,   778,     0,     0,   779,
    2313,     0,  2315,  1295,     0,   306,   371,   324,     0,     0,
     187,   977,     0,   177,   179,   180,     0,     0,     0,   487,
    1677,  1676,   384,   472,   493,     0,  1511,     0,  1507,     0,
    1230,     0,   684,   686,   680,   684,     0,  1207,     0,  1180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1071,
       0,  1160,     0,     0,     0,     0,     0,     0,  1100,  1098,
    1099,  2278,   750,  1008,     0,  1170,     0,  2236,  2236,  2236,
    1489,  1488,     0,  1487,  1491,     0,   938,     0,     0,     0,
       0,   432,     0,   414,   470,     0,     0,     0,  1485,  1473,
    2266,  1462,  1465,  1740,  2162,   955,     0,  1335,  1417,  1415,
       0,  1408,  1410,  1412,     0,  1734,     0,     0,  2117,  2103,
     673,     0,     0,     0,     0,  2104,     0,  1325,  1265,     0,
    1231,  1260,  1260,     0,  1231,     0,     0,     0,  1496,  1351,
    1498,  1289,     0,  1267,     0,  1356,     0,     0,   806,     0,
       0,     0,   836,     0,   849,   797,   816,   838,   642,   911,
    1348,   811,   813,   887,   509,   542,   698,     0,     0,   582,
     631,   626,     0,   631,   631,   591,   609,   586,     0,   678,
     599,   590,   611,   614,   616,   618,   631,     0,   678,   579,
     588,     0,   631,   650,     0,     0,     0,   646,     0,   691,
       0,   653,   559,   643,   645,     0,     0,   612,     0,   568,
     685,     0,   570,     0,     0,   631,     0,   641,   631,     0,
     117,   122,   133,   134,   767,  2312,     0,  2310,     0,     0,
       0,   128,   190,   188,   189,     0,   183,   185,   180,  2323,
    2330,     0,     0,  2328,   386,   388,   395,   473,     0,     0,
    1357,   745,  1373,  1108,   639,   679,   687,   688,     0,   683,
     681,   684,   628,     0,  1112,  1113,  1201,  1192,  1137,     0,
    1088,  1161,     0,     0,  1144,  1120,  1123,  1121,  1127,  1128,
    1010,     0,     0,  2235,  2233,     0,  2234,  2232,  2208,     0,
    2165,  2166,  2164,  2152,     0,     0,  1665,   416,   977,   421,
       0,   438,   437,   434,  1362,  1475,  1477,  1483,  1472,     0,
    1336,  1351,  1678,  1411,     0,   972,  2115,  2114,  2116,  2110,
       0,     0,     0,     0,  1263,  1247,     0,  1251,  1256,  1252,
       0,  1243,  1241,     0,  1372,  1277,  1278,     0,     0,  1283,
    1287,  1362,  1357,   809,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   835,  1711,   825,   827,   794,     0,   799,
       0,     0,     0,   693,   694,   699,   701,     0,     0,   635,
     636,   637,   592,   632,   634,     0,   594,   562,   587,   617,
     593,     0,   589,     0,   576,   656,   655,   986,   648,   658,
       0,     0,   654,   644,   652,   647,     0,     0,     0,     0,
     560,     0,   561,  1744,   124,   780,   238,  2314,   946,     0,
    2319,   105,  2327,   120,   129,  2337,   187,     0,     0,     0,
     178,   181,  2266,  1675,     0,   391,   731,     0,   744,     0,
     689,   682,     0,     0,  1163,  1165,  2214,  2213,  2212,  2209,
       0,     0,     0,     0,     0,     0,  2237,  2239,  1486,     0,
       0,     0,   429,     0,   425,   427,     0,   457,   471,   970,
     535,  1344,  1357,     0,  1362,     0,  1686,  1409,  2120,  2119,
    2105,     0,     0,     0,     0,     0,     0,  1296,  1495,  1273,
    1273,  1284,  1268,  1355,   808,     0,     0,   731,  1713,  1712,
     849,     0,   704,   705,   706,     0,     0,     0,   697,   700,
     571,   564,   633,     0,   751,     0,   575,   657,   986,   651,
     678,   684,   678,   684,     0,   126,   264,     0,   250,   236,
       0,     0,     0,   240,   135,   138,   136,     0,   137,   143,
       0,   144,   145,   146,   147,   148,   139,   262,   263,   142,
     140,   141,     0,  1758,     0,  1759,  2317,     0,     0,  2316,
     132,   154,   184,     0,     0,  2331,   389,   387,     0,  2262,
    1480,     0,    96,   732,   737,   733,  1357,     0,   630,  1086,
    2210,  2240,  2243,  2241,  2242,  2244,  2238,     0,     0,   978,
       0,   422,   423,     0,     0,     0,  1480,     0,     0,  1480,
    1480,  1480,  1480,   450,   458,   460,     0,   536,     0,     0,
    1341,  1343,  1337,  1399,     0,     0,     0,     0,  1679,  1681,
       0,  1416,     0,  1248,     0,  1253,     0,  1245,     0,     0,
    1281,  1279,     0,   731,   547,   828,     0,   708,     0,   707,
       0,   702,   703,   698,     0,   678,     0,   678,   649,   567,
     569,   573,   574,   125,     0,   118,     0,     0,   249,   252,
       0,     0,   255,   245,   244,   246,     0,   239,   238,   238,
     292,   243,   289,   288,   281,  2266,     0,     0,     0,     0,
    2338,   186,   977,     0,   393,   392,     0,     0,   734,   743,
     746,  1492,  1500,     0,  1666,     0,   430,   429,   426,     0,
       0,     0,  1480,  1480,     0,     0,     0,     0,     0,   436,
     459,  1480,  1345,  1346,  1357,     0,   954,     0,     0,     0,
       0,  1680,     0,     0,  1687,  1689,     0,     0,     0,  1297,
       0,  1274,     0,     0,     0,   549,   548,     0,   710,   711,
     709,   695,   696,   596,   752,   598,   127,   265,   276,   279,
     271,   251,     0,     0,     0,   241,   238,     0,   225,   223,
     224,   230,   231,   232,   233,   234,   235,   226,   229,   227,
     228,   238,     0,   195,     0,     0,  2318,     0,  2320,     0,
     134,   164,   163,   155,     0,   238,  2324,  2332,  2266,   738,
     739,     0,     0,   665,   417,   424,     0,   446,   448,   449,
     443,     0,   439,   441,   442,   468,     0,     0,  1392,  1390,
    1391,   464,  1393,   465,   463,   461,   454,     0,   452,     0,
    1342,  1400,  1684,  1685,     0,  1682,     0,     0,  1688,     0,
    1250,  1255,  1276,  1275,  1290,     0,   814,     0,     0,   238,
     272,     0,   247,     0,     0,     0,     0,   193,   295,     0,
     191,   283,   283,  2321,  2322,   116,   165,  2339,     0,   154,
     394,  1499,  1501,     0,  1667,   440,     0,  1942,     0,   466,
     467,     0,   451,     0,   462,     0,  1683,  1691,  1690,     0,
       0,     0,   273,   279,   269,   277,   238,     0,     0,   237,
     256,   291,   194,     0,   293,     0,   238,     0,   282,   284,
     286,     0,  2333,   666,  1678,   447,   444,   445,   457,   456,
     453,   977,     0,  1282,  1280,     0,   270,     0,     0,   268,
     248,   253,   238,     0,   238,   206,   205,     0,   197,   219,
     290,     0,   196,  2325,   238,  1686,   455,     0,     0,  1403,
    1405,     0,   274,     0,   238,     0,   238,     0,   238,     0,
       0,     0,     0,     0,   192,   238,  2334,  1692,   978,  1401,
     977,  1554,     0,   266,   238,   254,   259,   296,     0,   200,
     220,   221,     0,   203,  2326,     0,  1694,  1406,  1404,   238,
     238,   255,   258,   294,     0,     0,   198,   212,   199,   210,
     202,     0,     0,     0,  1701,   238,   238,   260,   218,   216,
     238,   207,   214,   209,     0,   215,   222,   213,     0,   204,
    1693,  1696,     0,     0,  1698,  1699,     0,  1668,     0,   201,
     217,   211,  1700,  1695,     0,  1702,   208,  1697
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    56,    57,    58,    59,    60,    61,  1217,    62,   751,
    1159,  1618,  1619,    63,   498,    64,   946,  1391,  1392,  1393,
      65,  1924,  2771,  1409,   470,   471,  1793,  1794,   970,  2383,
    2729,  3434,  2733,  3545,  3675,  3443,  1868,  3039,  3435,  3436,
    3554,   493,  1922,  1346,  3700,  1773,  3803,  1774,    66,   584,
     944,  1372,  1373,  3052,  3053,  3272,  3054,  3265,  3266,  3267,
    3268,  3916,  3776,  3870,  3917,  3971,  4004,  4010,  4011,  3947,
    4020,  4021,  4022,  4028,  4023,  3948,  4006,  3777,  3778,  3682,
    3779,  3557,  3780,  3686,  3781,  3560,  3782,  3783,  3784,  3785,
    3908,  3786,  3681,  3940,  3773,  3774,  3942,  3986,  4002,  3787,
    3567,  3676,  3857,  3568,  3677,  3903,  3769,  3904,  3935,  3982,
    3770,  3858,  3938,  3861,  3788,  3794,  3918,  3789,  3795,  3790,
    3572,  3693,  3793,  3691,  3792,  3944,  3913,  2387,  2755,   569,
     570,   595,  1915,   571,   958,   918,  1348,  1806,  1807,  2249,
    2250,  2369,  2370,  2371,  1798,  1799,  1800,  1903,  1904,  1905,
    1780,  1781,  1782,  1352,  1777,  1778,   572,   919,   929,  1801,
    1802,  1803,  2375,  1907,  1908,  1909,  1910,  1804,  1609,  1805,
    2626,  2392,  2765,  3452,  3062,  3589,  3808,  2318,  2319,  2298,
      67,   509,   798,  1214,  2128,  1652,  1651,  1215,  2525,  2526,
    2527,  2115,  3329,  1654,  2127,  3482,  3717,  3483,  3484,  2861,
    3611,  2523,  2865,  2866,  3120,  3331,  3487,  3822,  3823,  3824,
    3816,  3817,  3818,  3729,  3837,  3838,  3891,  3928,  3623,  3624,
    3625,  2147,  2531,  3334,  3278,  1897,  1338,  1339,   472,   473,
     474,   592,  2393,  1855,  2394,  2395,  1857,  1858,  2498,  1265,
    2704,  2677,  3488,  2761,  2712,  2713,  2714,  2715,  2647,  2648,
    2260,  2261,  2324,  2723,  3022,  3202,  3217,  3023,  3024,  3025,
    3026,  3027,  3028,  3029,  2784,  2785,  3402,  3403,  3404,  2781,
    3248,  3232,  3233,  3234,  3418,  3076,  2570,  2571,  3884,  2579,
    2580,  2617,  2909,  2618,  1342,  3077,  3242,  3289,  3235,  2722,
    3196,  3393,  3527,  3394,  3395,  3396,  3661,  2262,  2646,  2263,
    2638,   875,   475,  1423,  1424,  3592,  3593,  3594,  3595,  2399,
    3279,  3280,  2635,  2837,  3533,    68,  1356,   912,   921,   917,
     935,   576,  1357,  1869,  2330,  3254,   559,  1859,  3189,  2954,
    3193,  1860,  2657,  1861,  2943,  3178,  1862,  2969,  3191,  3388,
    2658,  2659,  1863,  1864,  1865,  2953,  2962,  3520,  2264,   123,
    1615,  2719,  2305,    69,  1317,  1312,    70,   886,   881,   882,
    1315,  1316,  1739,  2194,    71,   817,    72,   579,    73,   587,
    1396,    74,  1225,  2139,  2140,  2141,    75,   936,    76,    77,
     588,  1403,  1404,  1405,    78,  1210,   130,    79,   806,  1220,
    1222,  1223,    80,   581,   582,  1365,    81,  1646,  2106,  2107,
     941,   942,  1371,  2860,    82,    83,   549,   522,   823,   523,
     524,  1679,  2159,  3489,   834,   835,   836,  2555,  1242,  1243,
    1244,  2164,  1680,  2560,  1013,   716,   717,   718,   719,  1107,
    1108,  3236,   720,  1117,  1575,   721,   722,   723,   724,   725,
     726,  1602,  2807,  2808,  3091,  2062,  2063,  2064,   727,  1958,
    2794,  1971,   728,  1100,  1560,  1492,  3083,  2799,  1436,  1941,
    2426,  2495,  2036,  1038,  1039,  1003,  1948,  1442,  1746,  1747,
    1748,  1749,  1750,  3166,  3165,  3167,  3502,  3356,  3504,  3360,
    2205,  1751,  1752,  2593,  2923,  2611,  2612,  3371,  2196,  1753,
    2599,  3650,  3368,  3369,  3754,  3753,  3370,  3171,  3172,  2936,
    2937,  2333,  2334,  2335,  3506,  1483,  1536,  1484,  1490,  1194,
    1195,  1437,  2103,  2510,  3341,  3493,  2053,  3137,  3491,  3630,
    1866,  2683,  2684,  2161,  2162,  2615,  2940,  2967,  1268,  3490,
    2512,  1713,  1714,  3068,  4009,  2627,  2346,  3831,  2124,  2125,
    2690,  3736,  3895,  3958,  3959,  3960,  2891,  2892,  3141,  3142,
    2163,  2552,  2893,  3342,    84,   477,    85,  2068,  2080,   938,
    1425,  1426,   739,   490,    86,   499,  2104,    87,   516,  1667,
     789,   810,  1228,  1229,  2148,  2532,  2539,  2149,  2544,  3130,
    2534,  2871,  2872,  2072,  2073,  2535,  2874,  3127,  3112,  3113,
    2856,  3325,    88,   537,  2934,  2606,  2607,  3711,  3712,   811,
      89,   476,   990,  1931,  1429,  1930,   991,   992,  1431,   611,
     612,    90,   534,  1293,  1294,  1295,  1729,    91,   527,   876,
    2583,  1708,   802,  1152,  1272,   879,  1273,  1694,  2178,  1253,
      92,   908,   907,    93,   555,  1334,    94,   752,  1170,  1171,
    1623,  2081,    95,   517,   815,   816,    96,   511,   803,  1660,
      97,   503,    98,    99,   792,  1203,  2857,  3480,  3813,  3924,
    1645,  1204,  3063,  3496,  3638,  3639,  3641,  3744,  3745,  3996,
    4014,  4033,  4034,  4037,   730,   896,   731,  3383,   732,   733,
    2540,  2541,  2941,   734,  3713,   735,  2325,   889,   496,   452,
     566,   897,  2515,   737,  3574,   915,   962,   454,   455,   100,
     837,   526,  1246,  1247,  1248,  1689,  1690,   880,  2041,  1691,
    1692,  2175,  2170,  3149,  2915,  2907,   101,   795,  1172,  1208,
    1209,  2112,   102,   536,   103,  1196,  1639,  1640,  2100,  2509,
    2101,   104,   819,   105,   776,  1633,   777,  1174,   778,   779,
    1186,  1181,  1189,  1183,  3470,  3317,  3318,  2088,  1155,   963,
     964,  1626,  2083,  2084,  3107,  3320,  3476,  3477,   106,   134,
     460,   590,   953,  1236,   107,   108,   109,   110,  1239,  1329,
    2155,  1330,  1331,  1332,  1760,  1677,  2472,  1098,  1554,  2834,
     599,   980,   972,   124,   125,   126,   602,   603,   127,   933,
     934,  2331,  2735,  3041,  3257,  3258,  3440,  3579,   974,  3448,
    3878,  3975,   975,   976,  2756,  3449,  3703,  3879,  3954,   977,
    2384,  3050,  3581,  3805,   111,   898,   546,  1327,  1322,  1324,
    1756,  2212,   112,   113
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3325
static const int yypact[] =
{
    5229,  2132,  1212,   820, -3325,   -97,   803, 39568,   746,   820,
     820,   509,  2489, -3325, -3325, -3325, -3325, -3325,  2819, -3325,
   39568,  1212, -3325, 22066, -3325, -3325,   743,   102,   198,   820,
    1212, -3325, 39568, -3325,   749,  1219,  1212, -3325, -3325,   820,
   -3325,   509, 39568, -3325,   875, -3325,  1242,   -92,   902,   870,
    1013, -3325, -3325, 39568,  2263,  -144,  1404,  1276, -3325, -3325,
    1065, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, 22633, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325,  1334, 39568,  1450, 39568, -3325,  1321,
   39568, 33928, 39568,  1119,  1494, -3325, -3325,  1488, -3325, -3325,
     820, -3325, -3325, -3325,   509, -3325, -3325, 22066, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325,  1086, -3325, -3325,  1176, -3325, -3325, -3325,
    1686,  1520, -3325,  1554, 33928, -3325, 39568, -3325, -3325, -3325,
     203, -3325,  1250, -3325,  1274,  1566,  1153, 11116,  1584,  1584,
    1584, 39568,  1616,  1584,  1584, 39568, -3325,  1584, -3325,  1584,
     820, -3325, -3325,  3837, 39568,  1468,   197,   469, 33928,  1376,
   39568, -3325, -3325, 11116, -3325,  1602, 22066, -3325,   820,  1814,
    1662,   239, 39568, -3325, -3325,   820,  1267,  1083, -3325,  4216,
     143, -3325, -3325, -3325,  1893, -3325, -3325,  4772, -3325, -3325,
   -3325,  1300, -3325, -3325, 22066, 39568,   820,  1612, -3325, -3325,
     231,   231,   231, -3325,   231, -3325,   231, -3325,  -144,  1296,
   -3325, -3325, 39568,   -68,   502, -3325, -3325,  1314,     1, -3325,
    1379, 31108, -3325, 39568, -3325, -3325, -3325, -3325,  1582, -3325,
   -3325, -3325,  1948, -3325, 22066, 39568,  1458, -3325, -3325, 22066,
   -3325,   210, -3325, -3325,  1348, 39568, -3325, 22066, 22066,   776,
     967,  1440, 39568, 39568,  1762, -3325,  1929, 31108,  1529, -3325,
    1056,   807,  1488,  1934, -3325,  1520, -3325, 39568, -3325, -3325,
   -3325, 35620,  1153,  1358,  1380,  1390, 14620, -3325,  1392,  1401,
    1408, 11116,  1412,  1414,  1429,  1435,  1443,  1480,  1482,  1491,
    1498,  1498,  1503,  1507,  1512,  1542,   816,  1555, -3325,  1569,
    1578,  1591, -3325, -3325,  1601,  1606,  1609, -3325,  1614,  1626,
    1631, 11700,  1647,  1649, -3325, 19226,  1653,  1656,  1671,  1678,
    1680,  1687,  1689,  1691,  1694, -3325, -3325, 11116,  1699, -3325,
   -3325,  1704, -3325,  1706,  1708,  1715,  1721,  1723,  1725,  1732,
    1735,  1748,  1751,  1760,  1769,  1772,  1786,  1797,  1799, -3325,
    1038,  1807,  1810,  1565,  1812, -3325,  1815, -3325,   236,  1827,
    1498,  1498,  1498,  1829,  1831,  1836,  1839,  1850, 14620, 14620,
   14620,  8196, -3325, 39568, -3325, 39568,   953,  2614, -3325,  2207,
   14620,   196, -3325, -3325, -3325, -3325, -3325, -3325, -3325,  1368,
    1454, -3325, -3325, -3325, -3325, -3325,  1876,  1461,  1921, 39568,
   39568, 39568,  1761, 39568, 39568, 33928,  1636, 39568, 31108, 22066,
    1584,  1620,  2811,  1794,  1703,  1097, -3325, -3325, -3325, -3325,
   -3325,  1832, -3325, -3325,  1989, -3325, -3325, -3325,   338, -3325,
      81, -3325, -3325, -3325, -3325, -3325, -3325,  1878,  1879, -3325,
   -3325,    91, -3325, -3325, 39568, -3325, -3325, -3325, -3325,  2279,
    2039,   953,   238,  2446,  2329, 22066, -3325,   815, -3325,   832,
   -3325, -3325,  2250, -3325, -3325, 31108, 22066, -3325, -3325, -3325,
   19793, -3325, -3325,  2460, -3325,  1937, -3325, 22066,  1794, -3325,
    2179,  2102,   967,  2002, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325,  1961,  1893, -3325, -3325, -3325,  2393,
   -3325,  2108,   241,  2036, -3325,  1976,  1668,   241, 31672,  2314,
     211, -3325,   290, -3325,  2395, -3325, -3325,  2101, -3325, -3325,
    2105,  2116,  2313,  2121, -3325, -3325,   334,  2212, -3325, -3325,
     279, -3325,  -112,  2314,   241,   211, -3325,  2355,  2471,   599,
    1045, -3325,   -45, -3325, -3325,  2535, -3325, -3325, -3325, -3325,
   -3325, -3325,  2279, -3325, -3325, -3325,  2032, -3325,  2278,  2130,
   -3325, -3325,   124, -3325,  2038,   841, -3325,   705, 32236, -3325,
   -3325, -3325,  2509,  2527,  1498,  2045, -3325, -3325, -3325,  2628,
   -3325, -3325,  2059,  2546,  2546,  2546,  2641, -3325, -3325, -3325,
   -3325, -3325,  2215,  2092, -3325,  1458, 22066,   873, -3325, 36184,
   22066, -3325,  1460, 11116, -3325, -3325,  3158,    26,   847, -3325,
    2598,  2253, -3325, -3325, -3325, -3325,  2501, -3325, -3325,  2628,
    2558,  2546,  2461,  2081, -3325, -3325, -3325,  1520, -3325, -3325,
   -3325,  2487, -3325, -3325, -3325, -3325, -3325, -3325, -3325,  2490,
   -3325, -3325, -3325, -3325, -3325,  1458, -3325, 22066, -3325, 22066,
   -3325,  2086, -3325,  2082, -3325, 11116, 11116,   329,  2605,  2660,
    2660,  2660,   953,  2114, 11116, 11116, 11116, 11116, 11116, 11116,
   11116,   348,  2094, -3325, -3325,  8780, -3325,  2096, 11116, 11116,
    2181, 11116,  1454, 11116, 23200,   731,  3047, 11116,   710,  2559,
   11116, 11116, 11116,  8196,  2718, 11116, 11116, 23200,  2676,  2104,
   -3325,  2100,   836, 11116, 11116,  1457, 11116, 11116, 11116, 11116,
   11116, -3325,  8780, -3325, 11116, 11116, 11116, 11116, 14620, 11116,
   11116, 11116, 11116, 11116, 11116,  2660,  2660, 11116, 11116,  1510,
    8780, -3325, 11116,  1454,  2323,  2323, 11116,  1454,  7028, 11116,
   -3325, -3325, -3325,  2112, -3325, -3325, -3325, 23200,  2660,  2660,
   11116, 11116,  2605,  2605,  2605, -3325,  8196,   190,  2125, 11116,
   24334,  2107, -3325, -3325, -3325, -3325, 11116, 11116, 11116, -3325,
   14620, -3325, -3325,   917, -3325, -3325, -3325, 12284, 14620, 14620,
    2109, 14620, 14620, 14620, 14620, 14620,  2448, 14620, 14620, 15204,
   15788, 14620, 14620, 14620, 14620,   978,  2605, 33928, 14620, 11116,
   -3325, -3325, 39568, -3325, -3325, -3325,  2123, 22066,  1636, -3325,
   -3325,   -54,  2553, -3325, -3325,  2115,    76, 22066,  2128, -3325,
   -3325, -3325, -3325, -3325, -3325,  2654, -3325, -3325, -3325,  2146,
    2129, -3325, -3325, -3325, -3325, -3325, -3325,  2225, -3325, -3325,
   -3325,  2138, -3325,  2138, -3325, -3325,  2138, -3325, -3325,  2138,
     716,  4182, -3325, -3325, 39568, -3325, 40132, -3325, 19793,   -97,
   -3325,  2444, -3325, -3325,  2474, -3325,  2450,   182,  2143, -3325,
   22066, -3325, -3325, -3325,  2373,  1372, 33928, -3325, -3325,   129,
    2148,  2231,  2165, -3325,  2244, 22066, 22066, -3325, -3325, -3325,
   -3325,  1083,   183,  2172,   774, -3325, 39568, -3325,  1526, -3325,
   -3325, -3325,  2174, -3325, 11116, -3325,  2186, -3325,    82,  2540,
   -3325,   -97, 11116, -3325, -3325,  2195,  1520, 39568, 39568, 39568,
   22066, 39568, 22066, -3325,  1084,  1084, -3325,   965, -3325, -3325,
   -3325, -3325,   241, 39568, 39568,   241, 31108, -3325, -3325, -3325,
    2600,   211, 39568,   241, -3325,  2550,  2287, -3325, -3325, -3325,
    2625, -3325, -3325,  2616,  2206, -3325, -3325, -3325,   211, -3325,
   -3325, -3325, 22066, -3325, -3325,   211, -3325, -3325,   211,   211,
     241,   241,  2256, -3325, -3325,  2216, -3325,  2256,  2344,  1046,
     231,  2436, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325,   750, -3325, -3325, -3325, -3325, -3325,    52, -3325,
   -3325, -3325,  1792,  2679, -3325, 33928,  2110,   -40,   877,  2110,
    1741,   -97,   304, -3325,   304, -3325,  4433,  2465,   727, 22066,
   -3325,  2223,   -97, 22066, -3325, -3325, -3325, -3325, -3325, -3325,
    2227, -3325,  2228,  2226,   953,  2670,  2681,  2682,  2685,  2687,
    2688,  2690,  2695,  2696,  2697,  2698,  2699,  2704,  2706,  2707,
    2708,  2272, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
    2321, -3325, -3325, -3325, -3325,  2407, -3325, -3325, -3325,   108,
    1932,  2300,  2325,  2826, 31108,  2700, 39568, 39568, 39568, 39568,
   39568, -3325, -3325,   932,  2529,  2292, -3325,   558, 39568,  2709,
   26596,   101,   303,   818, -3325,  2660,  2301, -3325,  2307,  2308,
    2312, 11116,   116,   269,   846,  -172,  1078,   854,   316,   263,
   -3325,  2315,  2303, -3325,   891, -3325,   352,   368,   915,   957,
    2320, -3325,  2322, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325,  2713, -3325,  1290, -3325, -3325, -3325, -3325,
    2299, -3325, -3325,   963,   372,   377,   267,  2330,   379,  1304,
    1315,  2326, 23200, 39568,  2660,  2331,   983,   990,  2660,  2337,
     381,   999,  1459,  1521,  1535,  1024,  1026,  1032,   406,  1551,
    3049,  1052,   420,   467,   495,   536,  1054,  2339,  2341,   663,
     283,  2660,  2346,  1094,   276, -3325,  2328, -3325,  2351,  1099,
    9364,  9948, 10532,   194,   689, -3325,  2353, -3325,  2100,  2354,
    2357,   296,  1107, -3325,  -144, -3325, 11116, -3325,   105,    72,
   -3325,  2454, 39568,  2095,   139, -3325, -3325, -3325, -3325, -3325,
   -3325,  1009, -3325,  2359, -3325,  2361,  1745,  2333,  8196,   972,
    2333,  2632,   813,   813, 14620,  2677,  1642, 11700,   618, 11700,
     618,  2333,  2333,  2333, -3325, 14620,  2366, 14620, 14620, -3325,
    2605,   953,  2367,  1168, 39568, -3325,   -54, -3325, -3325, -3325,
   -3325,   118, 31108, -3325, -3325, -3325,    76, 33928,  2368, -3325,
   -3325,  2563,  2811, 22066, -3325, 39568, -3325, -3325, -3325, -3325,
   20360, 20360, -3325, 20360, -3325, -3325,   205,   224,  2843,  2392,
   -3325, -3325, -3325, -3325, -3325,  2745, 22066, -3325,   606, 22066,
    2223,  2375,  2375,  1684,  2477, -3325,  2382, -3325, 11116,   -97,
   -3325, 31108, 31108, 22066, 22066,   699, -3325,  1817, -3325,   -97,
    2783, 20360, 20360, 20360, -3325, -3325, -3325, -3325, -3325,   147,
   -3325,   953, -3325,  2380, -3325, -3325, -3325, -3325, -3325, 36748,
     232, -3325, -3325,   -97,  2794, -3325,   953,  2389, 39568, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325,   625, -3325, -3325, -3325, -3325, -3325,
   -3325,  2524,   241, -3325, -3325, -3325, -3325, -3325,  2594,  2314,
    2212,   241,   211, 22066,   241,   241, -3325, -3325,  1516, -3325,
     -45, -3325, -3325, -3325, -3325, 39568,  1595,  2539, -3325,  2403,
   -3325, -3325, 22066, -3325,  2409, -3325,  2818,  2947,  2314, -3325,
   -3325, -3325,   118,   118,  2683, -3325,   -97,  2532,  2533,  2538,
    2542,  2543,  2570, -3325, -3325,   -97,   -97, -3325, -3325,   118,
   -3325,   849, -3325, -3325, -3325, -3325,   -97,   -97,   -97,   -97,
    2199,   -97,   -97,  1570, -3325, -3325,   118,   118, -3325,  1140,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325,   237, -3325,  2864,
    2925,  2642,   118,   118,  2925,   118,  2658,  2665,   118,   118,
    2504,  2899,   118,  2796,  2541,  1375,  2802,   118, -3325,  2544,
    2913,   118,   118,   118,   118,  2925,  2678,  2991,   118,   118,
   -3325,   118,  2680,  2684,   217,  2689,  2691,   118,   178, 39568,
     118,   118,   118,   118, -3325, -3325,  4647, -3325, -3325, -3325,
   -3325, -3325, -3325,   874, 20930, -3325, -3325,   201, -3325,  2636,
   -3325, -3325, -3325, -3325, -3325, 37312, -3325, 11116,  2199,   -97,
     -97,  1178,   -97,  2199,   -97,   -97,   -97,   -97,   -97,  2199,
    2199,   -97,   -97,  2199,  3158, -3325, -3325, -3325,   111,   118,
     118,   118,   118, -3325,  1870, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, 33928,  2789,  1872,   -27, -3325, 39568, -3325,
   -3325,  1693,  2462,   528,  3120,   371,   371, -3325, 22066, 22066,
    2502,  2392, -3325,  1046, -3325,  2464, -3325, 12868, -3325,  2466,
   -3325, 11116, -3325, -3325, -3325,  1387, 11116, 11116,  2911,  2074,
   -3325, 32800, -3325, -3325, -3325, 11116, 32800,  2074, 11116, -3325,
    2472, -3325,  2835,  2839, -3325, -3325, -3325, -3325, 11116, -3325,
   11116, 11116, -3325, 11116, 11116, 11116, 11116, 11116, -3325, -3325,
   14620, -3325,  2473,  2478, -3325, -3325, -3325,  2482, -3325, 11116,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, 11116, -3325, 11116,
   -3325, 11116, 11116, 11116, 11116, -3325, -3325, -3325, 13452, 11116,
   11116,  2484, -3325, -3325, -3325, 11116, 11116, 11116, -3325, 11116,
     150, 11116,  1478, 11116,  1587, 11116, -3325, 11116, -3325, -3325,
   -3325, -3325, 11116, -3325, -3325, -3325,  1588, -3325,  2475,  2492,
    2493, 33928, 11116, -3325, -3325, -3325, -3325, -3325,   731, 14620,
     305,  2488, 14620, -3325,  2632,  2718,  2718,  2023,  8196,   972,
    2632, 11116,  2495,  2476, -3325, 11116, 39568, -3325, -3325, -3325,
   -3325, -3325, -3325, 33928, -3325, -3325, -3325,  2128,  2828, -3325,
    2223, -3325, -3325,  1603, -3325,  2496, -3325,  2497,  2573,  2576,
    2577, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325,  2314,  1817,  2591,  2508, -3325, -3325,  2528,
    2841, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325,  3048,  2514,  2375, 39568,
     953, -3325,  2590, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325,   331, -3325, -3325,  2521,  2521, 18090, -3325, -3325, -3325,
   -3325,  2762,  2933,  2934,  2936,   705, -3325,   621, -3325,  1273,
    2895,  2314, -3325,  2940, 34492, 27160, -3325,  2537,  2897,  2547,
     118, 29416,   830, 24900, 29980, -3325, -3325,  1178, -3325,    25,
   -3325,   965,   965,  2564, -3325,  2797, -3325, -3325, -3325,  2392,
     211, -3325, -3325, -3325,  2548, -3325, -3325,   861,  2898,  2900,
   -3325,  2782,   938,  2782,   861,   861, 23200,  1046,  1890, -3325,
    2199,  2836, -3325, -3325, -3325, 33364, 30544, -3325, -3325, -3325,
   -3325,  3038, -3325,  3039,  1123, -3325, -3325,  1309,   877, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325,  1741,  1309,  1309,   304, -3325,   107,
   -3325, -3325, -3325, -3325, -3325, 23767,  1460,  1212,  1460, -3325,
     325,   386, 23767, -3325, -3325, 23767,  1212,  1178,  2199, 23767,
    2199, 37876,  1212,   -97,   -97,  2120,   118,  2199, -3325, -3325,
    2906, 39568,  2907, 23767, 23767, -3325, 33928, -3325,   118,   128,
    2199,  1178,  1178, 23767,  1212, 23200,  1149,  2012,  1814,   -97,
    1212, -3325, -3325, -3325, -3325, 22066,  1212,  1212,  1808, -3325,
   -3325, -3325,  2199,  2012, 33928,  2560, -3325,  6005, -3325, -3325,
   -3325, 17523, 39568,   265,   407, -3325,  2555,  1203,   833,  2645,
    1493,  2575, -3325,  2583, -3325,  2574, -3325,   953, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
     -97,  1684,  1309,  1309,  1932, -3325,  2817,  2973,   118, -3325,
    1683, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
    2667, -3325,  2751,  2832,  2588, -3325, -3325,   223, -3325,  1405,
   22066, 16956, -3325,  2810, -3325,  2788, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325,  1046,  2831,  2392,  2604,   101, 11700,
    1111, -3325,   953, 11116,   953,  1701, -3325,  2601,  2601, -3325,
   -3325,  2602,  2601,  2961, -3325,  2964,  2606, -3325,  2609, -3325,
    1117,  2610,  2613,  1368, -3325, 11116, 11116,  1127,  1137,   -75,
     741,   753,   314, -3325,  1159,  3103, -3325, -3325,  1164,  1205,
    1217,  1229,   764,  1233,  1650, 11700,  1265,   399,   322, -3325,
    1333,   801,   810,  1350, 11116,  1451, 11116,  1470, 11116,  1476,
    1483,  1501, -3325, -3325, -3325, -3325, -3325, -3325,  2599,   953,
    2615, -3325, -3325, 11116, -3325,   196, -3325, -3325, 14620,   327,
    2617, -3325,   953, -3325, -3325,  2618,  1368, -3325, -3325, -3325,
   -3325, -3325, -3325, 39568,  2620, 27724, 31108, 31108, 31108,  2621,
   11116, -3325, -3325,  2865, -3325, -3325, 22066,  2998, -3325, -3325,
   14620,  2967,  2854, -3325, -3325,  2634,  2637, -3325, -3325, 31108,
   -3325,  1893, 23200, -3325,  2638, -3325,  2638,  1600,  2640,  1661,
   -3325, -3325, -3325,  2631,  2002,  3050, 31108, 31108, 31108, -3325,
    2392,  2392,   169,  2693,  3004, -3325, -3325, -3325, -3325, 38440,
   -3325, -3325, -3325, -3325,  1271, 39568,  2986, 39568,  7612, -3325,
   -3325,  3165, 11116, 31108,    21,    72,   118, -3325, -3325, -3325,
   -3325, -3325, -3325,  2314, -3325, -3325, -3325, -3325,  2970, -3325,
   -3325,   241,  1516,  -156, -3325,  1589, -3325, -3325, -3325,  3009,
     861,  2782,  2782,  3010,  2904,   929,  2650, -3325,   118, -3325,
   -3325, -3325,  1893, -3325, -3325, 11116, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325,   237, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, 11116,  3011,  3016,  1460, -3325, 23767, -3325, -3325, -3325,
     383, 37876, -3325, -3325, -3325, -3325, -3325, -3325,  2675, -3325,
   -3325,  1684, -3325, -3325, 30544,   -97, -3325, 23767,  2675, -3325,
   -3325,   163, -3325,   -97, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, 37876,  2686, -3325,  1336, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, 37876, -3325, -3325, 37876, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, 22066,  2171,
    1667, -3325,  1664, -3325, -3325, -3325, -3325, 39568, -3325, -3325,
   22066, -3325, -3325,  5682, 39568,  2870, -3325, 11116, 11116,  2923,
   39568,  2926, -3325,  3191, 39568,  3248, -3325, 37312, -3325, -3325,
   -3325, -3325, -3325,  2692, 39568,  1309,  1872, -3325, -3325,  1405,
    2840, -3325, -3325, -3325, -3325,  2931, 39568, -3325, -3325, -3325,
   -3325,  2821, -3325, 22066,  3224, -3325,  2845,  1700,   207,  5305,
   -3325,  2694,  2392,  3027, -3325, -3325,  2718, -3325,   953, 11116,
    2948, -3325,   293,  2951, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325,  2703,  2718,  2718, -3325, -3325,  2844,
   -3325, 11116, 11116, -3325, 11116, -3325,   212,  2710,  2728, -3325,
   -3325, -3325, -3325, 11116, -3325, -3325,  2718, -3325, 11116, -3325,
   -3325, 11116, -3325, 11116, 11116, -3325,  1532, -3325,  1538, -3325,
    1544, -3325, -3325, -3325, -3325,  2711, 39568, -3325, -3325,  1729,
   -3325, -3325, 11116, -3325, 34492, -3325, -3325, -3325, -3325, -3325,
    -130,  -130,  -130, 14036,   953,  3159, -3325,    62, -3325,  3056,
   -3325, -3325,  2632,  1431, -3325,  1744, -3325, -3325, 39568, -3325,
    1961,  2712, -3325,   118, 14036,  2521,  2845, -3325, -3325,  1600,
   23200, 27160, -3325, 31108,  2081,  2081,  2081,  2314,  3110,  2591,
    2591, -3325, 25466, -3325, -3325,  2855, -3325, -3325, 28288, -3325,
    1370, -3325, -3325, 14620,  1569, -3325,   953, -3325, 33364, -3325,
     953,   118,  2717,  2723, -3325, -3325, 39004, 11116, -3325,  3161,
   -3325, -3325,  2725,  1046, -3325,   861, -3325,  3080,  3081,   861,
   -3325, -3325, -3325, 23200,  2392, 14036, -3325,   684,  1961,   953,
    2729,  1336, -3325,   566,   953, 23767, -3325, -3325, -3325,  2732,
    3204,  3205, -3325, 23767,  2407, 39568, -3325,  3165, -3325, -3325,
   -3325, -3325,  5682, -3325, 23200, -3325, -3325, -3325, -3325, 39568,
   -3325,  2736, -3325, 17523, -3325, -3325, -3325,  2740,  2741,  2601,
   -3325, -3325, -3325, -3325, -3325,  2602,  2955, -3325,  2602,  2602,
   -3325, -3325, -3325, -3325, -3325,   293,  2058, -3325, -3325,   293,
   -3325, -3325, -3325,    67,  1263,  2602, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325,  2601,  2601, -3325, -3325, -3325,   293,  2746,
   -3325,  2601,  2306, -3325,   384,    89,  2748,  2749,  2601,  2750,
    2738, -3325,   953,  2718,  3258, -3325, -3325,  2884,   -97,  3207,
   -3325,  1756, -3325, -3325,  1741, -3325, -3325, -3325,  2887,   833,
     678, -3325,  2761,  2764, -3325, -3325,   -97,  2766,  2767,  4647,
   -3325, -3325, -3325,  3332, -3325, 39568, -3325,   965, -3325,  1133,
     953,  2770,  3322,   172, -3325,  3322, 32800, -3325,  1763, -3325,
    2775,  2776,   231,  2778,  1563,   812,  1778,  3059,  3128, -3325,
    2981, -3325,  1572,  1406,  1583,  1628,  1633,  1643, -3325, -3325,
   -3325, -3325, -3325, -3325,  1787, -3325,   648,  2803,  2803,  2803,
    1569,   953,  1791, -3325, -3325,  3147, -3325,  2785,  2791,  2792,
   39568, -3325,  2854, -3325,  2174, 23200, 14036,  2793,  2787, -3325,
     841, -3325, -3325,  2790,  2081, -3325,  3330,  3186, -3325, -3325,
   33928,  2798, -3325, -3325,  3077, -3325,    56,  2993, -3325, -3325,
   -3325,    21,  2883,  2885,   118,   953,   -97,  2274,  2403,  2480,
    2846,   861,   861,  2534,  2848, 11116, 11116,  2805, -3325,  2831,
   -3325, -3325,   697,  2174, 11116, -3325,  1684,  2854, -3325,  2806,
    2807, 39568, -3325,  3564,   265, -3325, -3325, -3325,  2306,  1212,
   -3325, -3325,  2675,   331, -3325, -3325,   825,  3052,  3061, -3325,
     979, -3325,  2812,   979,   979, -3325,  2108, -3325,  2847,   293,
   -3325, -3325,  2851, -3325, -3325, -3325,   979,  2813,   293, -3325,
   -3325,  3066,   979, -3325, 33928,   -97,  2481, -3325,  2861, -3325,
    3287,  3169, -3325,  2306, -3325,  3173,  3076, -3325,  3078, -3325,
   -3325,  3079, -3325,  3082,  3083,   979,  3084, -3325,   979, 39568,
   -3325, -3325, -3325, -3325, -3325, -3325, 39568, -3325,   896,  1803,
     -97,  2923, -3325, -3325, -3325,  2825,  2829, -3325, -3325, -3325,
   -3325, 39568,  5682, -3325, -3325, -3325,  2810, -3325,   931,  1822,
    1336,  2830, -3325, -3325, -3325, -3325, -3325, -3325, 32800, -3325,
   -3325,  3322, -3325,  3085, -3325, -3325, -3325, -3325, -3325, 11116,
   -3325, -3325,  3115,  3262, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325,  2920,  2937, -3325, -3325,  2939, -3325, -3325,   100,  2113,
   -3325, -3325, -3325, -3325, 14036,  3210, -3325, -3325, -3325, -3325,
   39568,  2892, -3325, -3325,  1088, -3325, -3325, -3325, -3325, 11116,
   -3325,  2831,  3375, -3325, 25466, -3325, -3325, -3325, -3325, -3325,
    2862,  2863,  7612,  3430, -3325, -3325,  2908, -3325, -3325, -3325,
    2909,   953,   953, 39568,  3027, -3325, -3325,  1460,  1460, -3325,
     697,  1088,  1336, -3325,  1840, 39568, 39568,  1842,   -18,   -18,
     -18,  1424,  1424, -3325, -3325, -3325, -3325, -3325,  3230, -3325,
     735,   127, 39568, -3325, -3325,    92, -3325,  2871,  2872, -3325,
   -3325, -3325, -3325,   979, -3325,   231, -3325, -3325, -3325, -3325,
   -3325,   231, -3325,  2881, -3325, -3325, -3325,  1498, -3325, -3325,
    3138,  2917, -3325, -3325, -3325, -3325,  2886,  2896,  2912,  2915,
   -3325,  2903, -3325, -3325,  2995, -3325, 45208, -3325, -3325,  -144,
    2918, -3325, -3325,  1493, -3325, -3325,  1362, 39568, 22066,  3053,
   -3325, -3325,   841,   207,  2845, -3325,  1527, 39568, -3325,  3160,
   -3325, -3325,  2921,  1654, -3325, -3325, -3325, -3325, -3325, -3325,
     117,  3148,  2199,  2199,  2199,  2199,  2113, -3325, -3325,  2952,
    3023, 14620,  3036,  1857, -3325, -3325,  1528,  2822, -3325,  1273,
   -3325,  -182,  1336, 11116,  2314,   941,  3274, -3325, -3325, -3325,
   -3325,  3256, 11116,  2944, 11116,  2945,  1862, -3325, -3325,  3355,
    3355, -3325, -3325, -3325, -3325,  1866,  1886,  1527, -3325, -3325,
     265,  2953, -3325, -3325, -3325,   771,   771,  1888, -3325, -3325,
   -3325, -3325, -3325,  1892, -3325,  1895, -3325, -3325,  1498, -3325,
     293,  3322,   293,  3322, 11116,  3389,  2974, 39568,   106, -3325,
   46336, 46336, 39568, -3325, -3325, -3325, -3325,  3854, -3325, -3325,
     695, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325,  3502, -3325,  2946, -3325, -3325,  2956,   226, -3325,
    3191, -3325, -3325,  5682,  3363, -3325, -3325, -3325,  2957,  2002,
     118,  3181, -3325,  1527, -3325, -3325,  1336,  2959, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, 23200, 22066, -3325,
    1684, -3325, -3325, 39568,  2968,  3051,   118,  3429,  3432,   118,
     118,   118,   118,  2976,  2822, -3325,  3411, -3325,   132, 11116,
   -3325, -3325,   953,  3188,  3515,  3518,  3427,  3520,   941, -3325,
     -80, -3325,  3422,   953, 39568,   953, 39568, -3325, 39568,  1284,
   -3325, -3325,  3177,  1527, -3325, -3325,  2854, -3325,  3563, -3325,
     882, -3325, -3325,    92, 39568,   293,   231,   293, -3325, -3325,
   -3325, -3325, -3325,   953, 11116, -3325, 11116,  3019, -3325, -3325,
    3412, 39568, -3325, -3325, -3325, -3325, 11116, -3325, 45208, 45208,
   -3325, -3325, -3325, -3325,  3558,   841,  3532,  3251,  3534,  3467,
    2443, -3325, -3325,  5682, -3325, -3325,  2199,   853, -3325, -3325,
   -3325,  3013, -3325,   118, -3325,  3020, -3325,  3036, -3325, 14620,
     248,   -97,   118,   118,  2297,  2297,  1684, 33928,  3124, -3325,
   -3325,   118, -3325, -3325,  1336, 39568, -3325,   231,   231,  3552,
     231, -3325,  3557,  3562,   -80, -3325,  1178,  1904,  1907, -3325,
    3565, -3325,  3567,  3028,  3054, -3325, -3325,  1928, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325,   953,   953, -3325,   134,
   -3325, -3325,  3400,  3481, 11116,   953, 42388,  3040, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, 45772, 11116, -3325,   695,  3502, -3325,  3288, -3325,  3289,
   -3325, -3325, -3325, -3325,  3512, 45208, -3325, -3325,   841, -3325,
   -3325, 23200, 14036,  2120, -3325, -3325,  1935, -3325, -3325,  2632,
   -3325, 16372, -3325, -3325, -3325, -3325,   -97,   -97, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325,  1944, -3325, 33928,
   -3325, -3325, -3325, -3325,   231, -3325,   231,   231, -3325,  3618,
   -3325, -3325, -3325, -3325, 37312, 37312, -3325,  3086, 11116, 45208,
   -3325,  3497, -3325,  3434,  1727,  3381,  3055, -3325,  3057,  1157,
    3535, 46336, 46336, -3325, -3325, -3325, -3325, -3325,  3509, -3325,
   -3325, -3325, -3325, 30544, -3325, -3325, 14620,  3067,  3068, -3325,
   -3325, 33928, -3325,  3124, -3325,  3071, -3325, -3325, -3325,  3378,
    3072,  1963, -3325,   189, -3325,   953, 42952,  3601, 39568, -3325,
   -3325, -3325, -3325, 11116, -3325, 35056, 43516,  3069, -3325, -3325,
   -3325,  3231,  2443, -3325,  3375, -3325, -3325, -3325,  2822, -3325,
   -3325,  3073,  3514, -3325, -3325, 11116, -3325,  3521,  3162, -3325,
    3087, -3325, 45208,   448, 45208, -3325, -3325,  3472,  3088,   788,
   -3325,  3074, -3325, -3325, 45208,  3274, -3325, 11116,  3090,  3100,
   -3325,  2199,   953,  3610, 45208, 39568, 40696,  3260, 44080,  3496,
   39568,  5682,  3513,  3516, -3325, 45208, -3325,  3464,   953, -3325,
   -3325, -3325,  3182, -3325, 41260, -3325,  2415, -3325,  3125, -3325,
   -3325,  3575,  1373, -3325, -3325,  3358,  3109, -3325, -3325, 45208,
   45208, -3325, -3325, -3325, 28852, 11116, -3325,  3143, -3325, -3325,
   -3325,   705,  3445, 18657,  3253, 41824, 44644, -3325, -3325, -3325,
   26032, -3325, -3325, -3325,  3522, -3325,   953, -3325,  1454, -3325,
   -3325, -3325, 33928,  1971, -3325, -3325, 23200, -3325, 28852, -3325,
   -3325, -3325, -3325, -3325, 21497,  3013, -3325, -3325
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
   -3325, -3325, -3325,   137, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325,  1621, -3325, -3325, -3325, -3325, -3325,  1805, -1654,
   -3325, -3325, -3325, -3325, -3325, -3325,   653,  1456,  3101, -3325,
     654, -3325,   262, -3325, -3325, -3325, -2573,   126,   -93, -3325,
   -3325,   549,    31,  2795,  -171, -2754, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325,   441,   439, -3325, -3325,   266,
   -3325, -3325,  -953, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325,  -327,  -279, -3325, -3325, -3325, -3325,  -187,   278, -3325,
     281, -3325,   282, -3325,   285, -3325,   287,   289,   291,   294,
   -3325,   297, -3325, -3325,  -286, -3325, -3325, -3325, -3325,   298,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325,  -177, -3325, -3325,
     -34, -3325, -3325,  -167,   301, -3325,  -134,   306, -3325,   307,
   -3325,   -56, -3325,   -53, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325,  2781, -3325, -3325, -3325,
   -1879, -3325, -3325, -2035,  2390, -3325, -1582, -3325, -3325, -1742,
   -3325, -3325, -1584,   879, -3325, -3325,  1301,   472, -3325, -1258,
   -1725, -1714, -3325, -3325, -3325, -1830, -1824,  -723,  2139, -1100,
   -2059, -3325, -3325, -3325,   295, -3325, -3325, -2292,  2391, -3325,
   -3325, -3325,  1448, -3325, -3325, -3325, -3325,  1228, -3325, -3325,
     883, -1491, -3325, -3325, -3325, -3325, -3325, -3325,   140,   271,
      33, -3325, -3059,   632, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325,  -131,   -63, -3325, -3325,  -137, -3325, -3325,  -169, -3325,
     136, -2094, -3325, -3325, -3325, -3325,  2352, -1215, -3325,  3290,
   -3325,  -507,   704,  1909, -2207, -1286,  -849,  -843, -2253, -3325,
   -3325, -3325,   397,  1020,  1381,   797,  1911, -1743,  1447,  1513,
   -3325, -3325,   823, -3325, -2898, -3325, -3325, -3325,   781, -3325,
     784, -3325, -3325, -3325,  -968,   754,  -498, -3325,   382, -2311,
   -3325,   594, -3325,   551, -3325,  -524, -1906, -2185, -3325, -3325,
   -3325,   562,   834,   881, -3325, -2820, -2667, -3325, -3325,   135,
   -3325, -3325, -3325,   130, -3325,   395,   268, -3325, -3325,  -933,
   -1949, -3325, -3325, -3325, -2415, -2362, -3325,  2369,   202,  1874,
   -2097,   339, -2145, -3325,   387, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325,  1938,  -555, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -2178,   848, -3325, -3325,  1485, -3325, -3325, -3325, -1733,   254,
   -1575, -2750, -3325, -3325, -3325, -3325, -3325, -3325,  1477, -3325,
   -3325,  2065,  2491, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325,   613,  1666, -3325, -3325, -3325, -3325, -3325,
   -3325,   855,  2405, -3325, -3325, -3325,   -16, -3325, -3325, -3325,
   -3325,  2149, -3325, -3325,  2873, -3325, -3325, -3325, -3325,  1295,
    1707, -3325, -3325, -3325,  -901,  1659,  -541, -1526, -3325,  3269,
   -3325, -3325, -3325, -1509, -2172, -3325,  2982,   330, -1750,  2140,
    -590, -2458, -3325,   976,  -613,  3111, -3325, -1063,  -990, -3325,
   -3325,  -583, -3325, -3325, -3325,  -563, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325,  1327, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,  1593, -3325,
    1867, -3325,  -415, -3325,  2799, -3325, -3325, -3325, -2093, -1691,
    1618,   903, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -2139, -3325, -3325, -3325, -3325, -3325, -3325, -1541, -3325,
   -1648,   317, -3325,   460, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325,   -23,  1098,   -21, -1892, -1004,  2763,  1487, -3325, -3325,
   -1181,  2833, -1874, -3325, -3325, -3325,  1780, -3325, -3325, -3325,
   -3325, -3325,   876, -2345, -1295, -3325, -3325, -2841,  -844, -2067,
    -817, -3325, -2110,   473, -1694, -1632, -2118,   120, -1153, -3325,
    1530, -3325, -3325, -3325, -3325,  -139, -3325, -3325, -3325,   498,
    1692, -3325, -3325, -3325, -3325, -3325, -3325, -3325,  -372,  -437,
   -3325,  1917,   819, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325,  2653,  2627,  1750, -3325, -3325, -2306, -3325, -3325,
    1710, -3325,   732, -2128, -1594,   981, -3325, -3325,   984, -2862,
   -3325, -3325, -3325, -3325, -3325, -3325,   926,  -176,    50,  3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325,  2435,  1930,  3252,
   -3325, -3325, -3325, -3325, -3325,  2136, -3325, -3325, -3325, -3325,
   -3325,  2607,  3342,  -526, -1203, -3325,  -667, -3325, -3325,  -807,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,  2248,
   -3325,  1163, -3325, -3325, -3325,  2643, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325,  1016,   -49, -3325,   240,   -78, -3325,   141, -3325,
   -3325, -3325,  -164, -3325,  -614,  -869, -1239,   655, -1593,  -806,
    1003,  2646, -3003,  -581, -1070, -1072, -2102,    57, -3325,  2452,
      78,  -728,  -308,    -7, -3324,  -117,  -537, -3325, -2016, -3325,
   -3325, -3325, -3325,  2202, -3325, -3325, -3325, -3325,  1312, -3325,
   -3325, -3325,   973, -3325,   740,   540, -3325, -3325,  2372, -3325,
    2247, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325, -3325,  2663,  3379,  3089, -3325,  2715,
   -3325, -3325, -3325, -3325, -3325,   429, -3325,   783, -3325,   -65,
    2486,   808, -3325,  1407,  -266,  -503, -3325,   435, -3325, -3325,
    1004,  3392,  3094, -3325, -3325, -3325, -3325, -3325, -2495,  -811,
   -3325, -2535, -3325, -3325, -3325, -3325,  1882,  -977,  2823,  1446,
   -3325, -3325, -3325,    -3,  3450,  3451, -3325, -3325,   555, -3325,
     400, -3325, -3325, -3325, -3325, -3325, -3325, -3325,  3321, -3325,
   -3325, -3325, -3325,  3323, -3325, -3325, -3325, -3325, -3325,  3326,
   -3325, -3325, -3325, -3325, -3325,  1759, -3325, -3325, -3325, -3325,
   -3325, -3325, -3325, -3325
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2307
static const short int yytable[] =
{
     453,   878,  1140,   874,   568,   492,  1333,   904,   956,  1370,
     971,   979,  1240,   491,   508,  1547,   497,  1546,  1014,  1016,
     515,  2123,  1022,  1151,   916,   510,  1648,  2034,  1715,  1300,
    1497,  2620,  1269,  2672,  2844,   521,  2511,  1758,   451,  1335,
    1263,  2075,  2568,  2572,  2574,  2428,   538,  1566,  1462,  2882,
    2431,  1610,  2538,   998,  1574,  1053,  1269,  2405,  2922,  2582,
    2773,  2707,   729,  1340,  3188,  2604,  2259,  1301,  1520,  1341,
    1856,  2586,  2587,  3170,  1040,  1071,  1073,  2265,  1722,  1077,
     495,  2269,  2252,   136,  2193,  2376,   557,  1084,  1085,  1086,
    1783,  2377,  2284,  2253,  2557,  1731,  2240,   888,   987,  2766,
    3175,  2768,  2293,  2668,  2595,  1734,  1735,  2782,   560,  1192,
     453,  2786,  2605,   453,   567,   573,  3469,  2649,  3374,  1192,
    1102,  1103,  3240,  1761,   577,  3212,  1613,  3346,  1576,  1577,
     557,  1796,  1580,  1581,  1582,  1583,  1135,  1585,  1586,  1588,
    1590,  1591,  1592,  1593,  1594,  1092,  1093,  1094,   562,  2652,
     556,   564,  1906,  2636,  1102,  1103,  3035,  1136,  1658,   589,
    2636,  2116,  2365,  2650,  1337,  1102,  1103,  2654,  2215,  2216,
    2160,  3372,  2584,  2679,  2680,  3205,  3210,  1187,  3311,  3211,
     501,  2670,  2671,  1394,  2338,  2227,  2630,  2631,  2770,  2348,
    2373,  2681,  3286,  -756,   583,  2354,  2355,  2229,  3220,  2358,
    1192,  2374,  2245,  2246,  3239,  1102,  1103,   937,  1302,  1102,
    1103,  1154,  2209,  1613,   114,   947,   948,  2248,  2267,  2268,
    1337,  2270,  3732,  1337,  2273,  2274,  3683,  3684,  2277,   840,
     841,  2877, -1328,  2286,  2949,  2302,  1193,  2289,  2290,  2291,
    2292, -2211,  2406,  3525,  2296,  2297,  1193,  2299,  1785,  -474,
    1936,  1946,  -475,  2308,  3087,  2038,  2312,  2313,  2314,  2315,
     782,  1796,  1137,  2070,  3336,  1685,   893,  3060,  1221,  3859,
    1757,  1080,   800,  2717,  1607,  2327, -1328,  3696,  1102,  1103,
    3106,  3679,  1102,  1103,  1102,  1103,  3697,  1949,   547,   840,
     841,  1102,  1103,  2674,  1140,   909,   504,   665,  1102,  1103,
    2889,  1344,  2309,  2740,  2741,  2360,  2361,  2362,  2363,  2640,
    1912,  1102,  1103,  3072,  1200,  2590,   116,  1779,  1102,  1103,
    1102,  1103,  2157,  2039,  3859,  2464,  3073,  1193,  1796,  1102,
    1103,  1102,  1103,  1686,  2380,  2747,  3492,  1102,  1103,  2752,
    3074,  1434,  1102,  1103,  3312,  1140, -2145,   594,  -390,  1140,
     840,   841,  1775,  1325,  1313,  1274,  2912,   530,  1669,  2870,
    1434,  1298,  2303,  2675, -1621, -2146,  2158,  1102,  1103,  2025,
    2634,  1951,  3390,  1227,  3451,  1238,  1415,  1156,  1417,  1418,
    3628,   785,  2913,  1102,  1103,  2641,  1270,  1102,  1103,  3408,
    3742,  1797,  1102,  1103,  1102,  1103,  1102,  1103,  3412,  1282,
    1184,  3629,   135,  3117,  3072,  3285,   505,  1299,  3290,  1395,
    1952,  1139,  3060,  1201,  1102,  1103,  2396,  3073,  3743,  1687,
     531,  1102,  1103,  1314,   894,  1606, -2266,  3680,  3391,  1081,
    2718,  3074,   939,  1271,  3385,  1102,  1103,   548,  2753,  3458,
    2938,   840,   841,  1460, -1328,  1232,  2641,  1779,  2917,  1104,
   -2145,  1754,  1105,  1414,  1435,  2676,  1040,   567,  2009,   573,
    1416,  2926,  3478,  1102,  1103,  1716,  2551,  2641,  1719, -2146,
    3061,  2310,  2381,  1450,   742,  1296,  1724,  3698,   573,  2957,
    2935,   689,  1102,  1103,   502,  1251,  1776,   780,  2136,  1340,
    1614,   567,  1757,   790,  1104,  1341,  2642,  1105,   910,   557,
    1202,  2948,  1608,  1736,  1737,   804,  1610,  1020,  1139,  2040,
    1102,  1103,  2950, -1621,  1779,  1759,  2613,   801,  2890,  1688,
    2914,  1797,  2959,  1783,  2252,   911,  3088,   557,   890,  2189,
    1571,  3513,  2774,  3180,  1104,  2253,  3820,  1105,  1104,  1326,
    2376,  1105,  1138,  2171,  2636,   906,  2377,  3919,  3919,  2251,
     598,  1102,  1103,  3733,   567,  2603,   920,  -556,  1579,  2071,
    1340,  2397,  3064,   794,  1361,  2636,  1341,   557,   453, -1328,
    1856,  2818,   557,  3131,  2653,  1600,  2655,  1614,   945,  3347,
     557,   557,  2585,  2666,   783,   957,   920,  3967,  1797,   519,
     567,  1445,  1446,  2172,  2054,  3338,  2678,  3757,  3315,   985,
     988,  2051,  2687,  2689,   993,  2057,   931,  1104,  2060,  1363,
    1105,  1104,  1485,  1104,  1105,  3061,  1105,  3213,  2705,  2689,
    1104,  1499,  2742,  1105,  3461,  1784,  3734,  1104,  1150,  2328,
    1105,   930,  1607,  1512,  1513,  1514,  1188,  2524,  1733,  1659,
    1104,  -756,  1519,  1105,  2628,  2373,  1906,  1104,  1041,  1104,
    1105,  3631,  1105,   821,  2558,  2594,  2374,  2372,  1104,  1363,
    1104,  1105, -2211,  1105,  3526,  2632,  1104,  1305,  3199,  1105,
    3241,  1104,  3058,  1106,  1105,  1947,  2887,  2888,  1102,  1103,
   -1328,  1785,  2665,  1761, -1328,  3701,  3046,  1911,  3444, -2211,
    2633,  2037,   506,  3768,  2673,  2947,  1104,  -474,  2643,  1105,
    -475,  3287,  3218,  3219,  1102,  1103,  1099,  1106,  1101,  3311,
    3222,  3047,  1104,  2772,  2137,  1105,  1104,  3245,  1106,  1105,
    3669,  1104,  3671,  1104,  1105,  1104,  1105,  2304,  1105,  2739,
     895,  1266,  1144,   453,  1146,  1082,   920,   453,   567,  1720,
     453,   567,   557,  1104,  1119,  3126,  1105, -1328,  3902,  1698,
    1104,  2550,  1297,  1105,  2942,  3709,  1102,  1103,  1106,  -556,
    2754,  1227,  1106,  1275,  1104, -2145,  1363,  1105,  1102,  1103,
    3655,  1145,  1555,  1556,  2745,  1149,  2026,  1197,  1153,  1102,
    1103,   871,  2538,  3151, -2146,  1616,  3160,  1185,   557,  1227,
    3164,  3192,  1104,   940, -2145,  1105,  -390,  2398,   567,   557,
    3179,  1252,  2720,   557,  1912,  3807,  1956,  1283, -1747,  1486,
     557,  1104,  1487, -2146,  1105,  2379,  1102,  1103,  1763,  2173,
    3135,  3657,  3075,  2951,  3364,  1102,  1103,  1102,  1103,  3821,
     949,  1106,  3159,  1102,  1103,  1106,  3163,  1106,  1650,  1104,
    1870,   567,  1105,  2636,  1106,  3763,  1957,  3765,  1434,  1555,
    1975,  1106,  1207,  1665, -1286,  2727,  2136,  2644,  2014,  2015,
    1608,  1102,  1103,  1224,  1106,  3972,  2010,  3365,  2109,  1102,
    1103,  1106,  2138,  1106,  3670,  3312,  3672,  1218,  2031,  2032,
    1104,  3973,  1106,  1105,  1106,  2186,  1937,  2482,  2483, -1286,
    1106,  3262,  2283,  3840,  1630,  1106,  2803,  2804,  3066,  1955,
    3263,  1336,  3366,  1397,  2820,  2821,  1102,  1103,  2252,  2841,
    2842,  3522,  1269,  3075,  2214,  2184,  2376,  3586,  -556,  2253,
    1106,  1981,  2377,  1122,  2188,  3176,  1874,  2191,  2192,   557,
    1102,  1103,  1366,   557, -1622,  1962,  1106,  3237,  2921,  1119,
    1106,  1269,  1715,  1715,  2389,  1106,  3802,  1106,  1871,  1106,
    3882,  1963,  1671,  2927,  2928,  1973,  3688,  3282,   967,  2181,
    1974,  1504,  1977,  1306,  1989,  3238,  2259,  1106,  1102,  1103,
    1783,  3313,  1102,  1103,  1106,  2070,  1307,  2284,  1102,  1103,
     557,  2819,   557,  1561,  3453,  2728,  2481,  2591,  1106,  1997,
    2445,  2251, -1599,  2110,  3759,  1267,  3494,   583,  1102,  1103,
     973,   981,  2573,  2001,  1398,  1102,  1103,  1104,  1399,  1595,
    1105,   137,  2061,  2035,  1102,  1103,  1106,  1041,   597,  1400,
    1599,  2373,  3357,  3358,   456,   604,  3352,  2610,  3264,  2956,
    1041,  1856,  2374,  1104,  2059,  1106,  1105,   748,  1137,  1102,
    1103,  1102,  1103,  1198,  1422,   520,  1427,  1102,  1103,  1340,
    2002,  2486,  2487,  1743,   241,  1341,   243,   784,  1784,  1779,
    3169,  1211,   805,  1106,  1212,   959,   966,  1102,  1103,  1102,
    1103,  2480,   459,  3991,  1547,  2074,  2542,  1567,  2003,  3634,
    1548,  2490,  2137, -1622,  3377,  1104, -2269,  1779,  1105,  3635,
    1308,  1631,  3523,   567,  3705,  1757,  2960,  1104,  3658,  1657,
    1105, -1440,  3689,   950,  1106,  3390,  1906,   500,  1104,  1102,
    1103,  1105,  2372,  1309,  1102,  1103,   585,  3314,  1122,  2004,
    3124,  2052,  1102,  1103,  2132,  2133,  1102,  1103,  1785,  3315,
     567,   665,  1102,  1103,  1547,  1603,  2608,    43,   580,  1401,
     557, -1440,  1102,  1103,  2800,  1104,  1319,  3177,  1105,  1672,
     557,  3715,  1102,  1103,  1104,  3654,  1104,  1105,   986,  1105,
    3796,  3391,  1104,  1095,  1796,  1105,  2174,  2600,  3802,  2044,
    3291,  2111,  1102,  1103,  1102,  1103,   512,  1607,  2601,  1102,
    1103,  1911,   968,  3524,  3455,  3659, -2269,  1635,  3173,  1638,
    1104,   557,  2378,  1105,  1131,  1132,  1133,  1134,  1104,  1213,
    1596,  1105,  1744,   557,  1605,  1607,  1745,   967,  2182,   567,
    1632,  3660,  3760,  1488,  3316,  1148,  1489,   525,   557,   557,
    1102,  1103,  1597,  1547,  1710,  2685, -1286,  2775,  1765,  1674,
    1402,  1106,  1102,  1103,  1840,  1104,  2623,  1683,  1105,  3367,
    2138,   954,   955,  2202,  1102,  1103,  2008,  1568,  1102,  1103,
     453,   453,   453,   557,   453,   557,  3690,  1106,  2234,  1104,
    -182,  2686,  1105,  2157,  1912,  2931,  1717,   453,  1632,   567,
    2379,  2071,  2027,  3880,   932,   453,  1843,  1642,  3515,  3516,
    1102,  1103,  1363, -1599,  3636,  3914,    55,  2341,  1699,  1700,
    1701,  3756,  1703,  1743,   951,   557,  1711,  1104,   740,   741,
    1105,  1104,   744,   745,  1105,  1718,   747,  1104,   749,  1106,
    1105,   131,  1461,  1723,   132,   689,  2235,  1702,  1138,  1704,
     672,  1106,   969,  2637,  2801,  2637,   871,  1104,  3438,  1695,
    1105,   135,  1106,  1267,  1104,  1360,  2802,  1105,   567,  2045,
    1705,  1020,  2236,  1104,  2624,  2342,  1105,  2813,  1102,  1103,
    1779,   532,   557,   665,   871,  2965,   557,  2602,   608,  1732,
    3588,   812, -2306,  2142,   533,  1102,  1103,   952,  1104,  1106,
    1104,  1105,  1238,  1105,  1598,  2251,  1104,   535,  1106,  1105,
    1106,   808,  3460,  1362,  2823,  1421,  1106,  1129,  1130,  1131,
    1132,  1133,  1134,  2824,  1706,  3299,  1104,  1021,  1104,  1105,
    1938,  1105,  1102,  1103,   550,  1608,  3392,   567,  2237,   453,
     453,   453,  1923,   453,  1106,   609,  1872,   551,  2117,  1216,
    3575,   993,  1106,  1935,  1797,  2840,  3399,  3633,  1950,  1795,
    1363,   968,  2228,  1608,  1569,   552,  1954,  2343,  1104,  3637,
    1873,  1105,  1744,  1104,  2254,  2553,  1105,  1919,  1920,  1921,
    1570,  1104,  1925,  2966,  1105,  1104,  1363,  2317,  1105,  1106,
    1547,  1104,  2873,   128,  1105,   813,  1102,  1103,  1607,  1434,
    3750,  1104,  2932,  1961,  1105,  1926,  2118,  3439,  1743,   558,
    2238,  1104,  2234,  1106,  1105,  1102,  1103,  1712,  2372,  2485,
     786,  1102,  1103,  1102,  1103,  1041,  1982,  1964,  1102,  1103,
    2076,  1104,  2119,  1104,  1105,  1784,  1105,   563,  1104,  2344,
    2625,  1105,  3454,  3751,  3400,  2757,  1102,  1103,  1310,  1176,
    3997,  1106,  1434,   932,  2520,  1106,  2046,  2554,  2725,   809,
    2862,  1106,   814,   638,  3575,  3575,   610,   689,  1675,  1965,
    2235,   129,  2047,  2433,  3373,  1972,  2280,  1102,  1103,  1104,
    3401,  1106,  1105,  1102,  1103,  2043,  2439,  1707,  1106,  1102,
    1103,  1104,  1655,  1020,  1105,  1985,  2236,  1106,  2120,  1157,
     787,   969,  1986,  1104,  2726,  3262,  1105,  1104,  1102,  1103,
    1105,  1990,  1508,  1368,  3263,  3812,  3894,  1102,  1103,  2454,
    3384,   643,  1106,  1177,  1106,   561,  1311,  2067,  1102,  1103,
    1106,   116,  1102,  1103,  1656,   567,  1994,  1369,  1995,  1104,
     567, -2306,  1105,   574,  1996,  2731,   557,   871,  2082,  1072,
    1106,  3118,  1106,  2087,  2087,  2758,  2087,  1744,  3849,  3752,
    2732,  1745,  2237,  3384,  2000,  1531,  2005,  1178,   788,   557,
    2121,  1911,   557,  1102,  1103,   575,  2379,  2378,  1102,  1103,
    2496,  1676,  1179,  2466,   567,   567,   557,   557,  1102,  1103,
    1953,  1139,  1106,  3119,  2087,  2087,  2087,  1106,  1368,  1102,
    1103,  2239,  3575,  3575,   585,  1106,  2013,  1104,  2198,  1106,
    1105,  2018,  2169,   654,  2198,  1106,   586,  2086,  2086,  2033,
    2086,  2180,  1369,  2777,  1104,  1106,  1608,  1105,  3923,  2791,
    2345,  2385,   589,  2108,  2238,  1106,  1207,  1796,  1976,  2797,
     131,  2637,  3264,   132,   528,  3283,  1102,  1103,   529,  2798,
    1224,  2135,  2386,  2247,   591,  1106,   557,  1106,  2086,  2086,
    2086,  1104,  1106,  1240,  1105,  2281,  2254,  2131,  2197,  2918,
     593,  2805,  1102,  1103,   605,   557,  2809,  2150,  2282,  2065,
    3614,  2664,  3747,  1899,  3748,   670,  2066,  3146,  3590,   513,
    3575,  2049,  2468,  1256,   954,   955,  1269,   596,  1119,  3615,
     467,  2176,  3069,  1106,   607,  3575,  3147,  2283,  3602,  3603,
    3604,  3605,  1377,  1378,  2920,  1106,   746,  2810,   738,  3575,
    2190,  3080,  3081,  2117,  2759,  1104,  2366,  1106,  1105,  2811,
    2199,  1106,   743,  1353,  1354,  3148,  2199,   781,  1547,  2208,
    2542,  2812,  3093,  3214,  1104,  2814,  3215,  1105,  2200,  1257,
    1104,   793,  1104,  1105,  2200,  1105, -1599,  1104,  1715,  2201,
    1105,  2122,  4007,  1106,  2429,  2201,  1786,   799,  2280,  2429,
    1412,  2368,  2311,  3575,  2218,  1104,  1258,  2817,  1105,   840,
     841,  2118,  2065,  2225,  2226,  3575,  3575,  2326,  1762,  2898,
     797,  1547,   885,  2608,  2230,  2231,  2232,  2233,  2336,  2241,
    2242,  1119,  1969,  1139,   809,  1368,  1104,  2119,   905,  1105,
     665,  2697,  1104,  2698,  2760,  1105,  1978,  1139,  1104,  2413,
    3575,  1105,  1547,  1779,  2685,  2239,  1796,  1979,  1502,  1369,
    3575,  1106,   784,  2202,  2061,   824,   567,  1104,  1192,  2202,
    1105,  2382,  3576,  1389,  1390,  2822,  1104,   913,  1106,  1105,
    2699,   557,   557,   922,  2478,   932,  3575,  1104,  3575,   943,
    1105,  1104,  2825,   960,  1105,   961,  1787,   965,  3575,   995,
    1899,  2700,  1899,  2120,   567,   114,   697,  1122,  3575,   567,
    3575,  1139,  3575,   895,   923,  1106,  2499,  2339,  2340,  3575,
    2347,   996,  2349,  2350,  2351,  2352,  2353,  1797,  3575,  2356,
    2357,   997,  1104,   999,  2701,  1105,  3354,  1104,  3716, -1328,
    1105,  1976,  1000,  3575,  3575,  2401,  2403,  1104,  3305,  1001,
    1105,  1627,  2869,  1004,  1628,  1005,  3706,  1629,  1104,  3575,
    3575,  1105,  1899,   924,  3575,  1900,   883,   884,  2203,   887,
    1006,  1607,  3809, -1599,  2203,  2121,  1007,  3200,   825,  1106,
    3203,  3204,  3721,  2378,  1008,  3724,  3725,  3726,  3727,  3250,
    2368, -1328,  2142,  2827,   567,  1193,  2911,  3216,  1106,  2488,
    2282,  1991,  1139,  1259,  1106,  1104,  1106,  1925,  1105,  1142,
    1122,  1106,  2829,  1547,  2429,  2873,  2576,  2581,  2831,  2497,
   -1328,  1009, -1328,  1010,   689,  2832,   567,  2204,  2839,  1106,
    1926,  1104,  1011,  2204,  1105,  1143, -1328,   925,  3072,  1012,
    1779, -1328,  1779,  2833,  1015,  1124,  1125,   826,  1017,  3591,
    1020,  3073,  1788,  1018,  3834, -1328,  2952,  1147,  2619,  2429,
    1106, -1328,  1789,  1992,  1139,  3074,  1106,  2417,  1790, -1328,
    1102,  1103,  1106,   871,  3098,   840,  3206,  1993,  1139, -1328,
    3099,  2234,  2528,  1019,  2688,  1175,  3100,  2963,  3826,  3827,
   -1328,  1106,  2418,  1998,  1139, -1328,  1023,  3839,  2968,  2543,
    1106,  2970,  1779,   114, -1328,  3298,  1076,  2144,  2145,  1119,
    1024,  1106,  2243,  2244,  3304,  1106,  1797,  2562,  2564,  1025,
     871,  2702,  1260,  1158,   567,  3306,   567,   567,  1173,  2499,
    2474,  1139,  1026,  2419,  1180,  2924,  2420,   840,   841,  2235,
    1766,  2876,  1027,  1261,  2421,  2502,  2503,  1028,  1124,  1125,
    1029,  1767,  1900,  1791,  1900,  1030,  1106,  2499,  1607,  1548,
    1607,  1106,  2703,  2779, -1328,  2236,  2122,  1031,   567,   567,
    3307,  1106,  1032,  3296,  1190,  3308,  1129,  1130,  1131,  1132,
    1133,  1134,  1106,  1262,  1284,  3309, -1328,   115,  1035,  3910,
    1036,  -555,  2815,  1139,  1042, -1328,  3599,  1043,  1118,  1608,
    2254,  2639,  2561,  2879,  2880,   116,  2972,  2973,  2326,  2142,
    2651,  2255,  1044,  1285,  1900,  2326,  2661,  2143,  2326,  1045,
    1607,  1046,  2326,  1901,  2660, -1328,  2746,  3981,  1047,  1106,
    1048,  2237,  1049,   926,  2660,  1050,  2326,  2326,  2682,   567,
    1052,  1792,  3059,  2973,  2693,  1054,  2326,  1055,  1548,  1056,
    2695,  2696,  1192,   539,  1286,  1106,  1057,  3471,   557,  1287,
     899,   900,  1058,   901,  1059,   902,  1060,   567,  2234, -1328,
     117,  3103,  1139,  1061,  2326,  2716,  1062,  1127,  1128,  1129,
    1130,  1131,  1132,  1133,  1134,  1901,  3121,  3122,  1122,  1063,
   -1328,  3223,  1064,  1119,   927,   540,   928,   118,  3255,  3256,
     998,  1065,  -555,  2238,  1768,  3292,  3293,   871,  2256,   871,
    1066,  2662,  2663,  1067,   827,   828,   829,   830,   831,   832,
    3300,  1139,  2694, -1328,  2144,  2145,  2235,  1068, -1328,  3310,
    1139,   833,  3224,  3323,  3324,   133,  3225,  2692,  1069,  1368,
    1070,   457,   458,   557,  2326,  3441,  2244,   119,  1074,  3086,
    2422,  1075,  2236,  1078,  3472,  3473,  1079,  1902,  2146,  3474,
    3475,   507,   541,  1369,  3456,  3457,  2117,   514,  1083,   871,
    1087,   518,  1088,  1769,  2089, -1328,  2090,  1089,  3226,  1193,
    1090, -1328,  3514,  3122,  3517,  3457,  1608,  3104,  1608,  1120,
    1467,  1091, -1328, -1328,  3509,  3510,  1288,  1770,  2738,  3612,
    3613,  2850,  2851,  2852,  3647,  3648, -1328,  2762,  3652,  3457,
   -1328,  1121, -1328,  2364,  2152,  2153,  2154,  1141,  2237,  1902,
   -1328,  3269,  1191,  1397,  2118, -1328,  1124,  1125,  3653,  3457,
    3663,  3664, -1328, -1328,  3665,  3666, -1328,  3667,  3666, -1328,
    1182,  2884,  2885,  2886,   118, -1328,  3850,  3648,  1608,  3851,
    3648,  2862,  1199, -1328,  1205,  1771,  2082,  1535,  1197,   567,
     567,   567,   578, -1328,  1206,  1289,  1219,   120,  1230,   557,
    3856,  3122,  1122,  1766, -1328,  1234,   617,  3885,  3886, -1328,
    1231,  2423,   567,  1471,  1767,  1548,  3892,  3893, -1328,  1235,
    2238,   954,   955,  1238,  2239,  1547,  3534,  1241,  -690,   567,
     567,   567,  3534,  1249,  -555,  3934,  2737,  2429,  1250,  3288,
    4000,  4001,  2897,  4043,  4044,  1254,  3828,  1255,  2899,  1267,
    2901,  1537,  1537,  3801,  1398,  1290,   567,  1276,  1399,  2198,
     121,  3832,  3832,  2108,  1277,  3518,  3519,  1772,  1278,  1400,
    2424,  3138,  3139,  3378,   461,  3108,  3109,  3075, -1328,  1279,
     638,  1280,  1438,  1439,  1440,  1127,  1128,  1129,  1130,  1131,
    1132,  1133,  1134,  1123,  1451,  3321,  3322,  3207,  3020,  2425,
   -1328,  1303,  1281,  1304,  1318,  1320,  1321,  1323,  1472, -1328,
    1328,  1337,  1475,  2198,   122,  1343,  -844,  2258,  3829,  1476,
     954,   955,  1345,   542,  1347,  1505,  3227,  2896,  1509,  2326,
    1350,   642,  3228,  1351,  2660,  1355,  1358,  1359,   643, -1328,
    1124,  1125,  1406,  1407,   543,  1408,  1411,   567,  1527,  1528,
    2326,  1126,  1532,  1413,  1414,  1419,   462,  1291,  1420,  1428,
    1430,  1137,  1434,  1441,   647,  2660,  1453,  1768,  1455,  3229,
    1082,  1549,  1550,   544,  1491,  1501,  2660,  1502,  1503,  2660,
    1578,  2199,  1584, -1328,  1545,  1562,  1611,  -724,  1612,  1401,
    1292,   557,  1620,  -555,  1477,  3406,  3407,  1557,  1621,  2200,
    2974,  1604,  1622,   557, -1328,  1617,  1624,  3030,  3410,  1625,
    2201,  2239,  1643,   453,  3414,  1644,  1649,  3040,  1647,  3819,
    2336,  1661,  1653,  1102,  1103,   545,  3791,  3045,  3481,  1547,
     654,  1662,  3230,  2958,   463,  2199,  1769,  3430,  1663,  3055,
    3432,  2961, -1328,  1479,  1664,  1670,   557,  1678,  1119,  1109,
    1110,  3036,  1693,  2200,  1022,  1073,  1077,   954,   955,  1684,
    1770,  1697,  1721,  1725,  2201,  3143,  1726,  2975,  1240,  1127,
    1128,  1129,  1130,  1131,  1132,  1133,  1134,  1727,  1728,  1730,
    1402,  2619,  1738,  1111,  2202,  1742,   665,  3764,  1755,  1740,
    1764,  1867,  1112,  1119,  3537, -1328,  1363,  3417,  1875,  1877,
    1876,   669,   670,  1812,  1813,  1878,  3355, -1328,  3134,  3830,
    3057,  1463,  1464,  1465,  1466,  1467,  1879,  1880,  1771,  3102,
    1881,  3819,  1882,  1883, -1328,  1884, -1328,  2562,  3231,  1113,
    1885,  1886,  1887,  1888,  1889,  -676,  -676,  1815,  2202,  1890,
    1114,  1891,  1892,  1893,  -676,  1894, -1328, -1328,  1818,  1895,
   -1328,  2528,   750, -1328,  1913,  1928,  1819,  1914,  3842,  3843,
    3359,  3845,  1916,  2543,  3133,  1929,   567,  1115,  1918,  1960,
     796,  1480,  1970,  1940,  1933,   567,  1821,   807,  1968,  1942,
    1943,  2497,  3616,  1482,  1944,  2042,  3819,  1959,  3577,  2203,
    1337,   567,  1966,  1822,  1967,  1976,  3906,  1980,   891,  2169,
    1772,  2016,  1134,  1984,   478,  1468,  1469,  1470,  1471,  1988,
    3617,  2006,  2561,  2007,  -555,  3668,  1548,   464,  2012,   736,
    1160,  1827,  1116,  2254,  2017,  2028,  2029,  1122,  2326,  2030,
   -1049,  1547,  2048,  4035,  2255,   465,  2326,  2058,  2660, -1166,
    2078,  2077,  2102,  2203,  2105,   736,  2114,  1548,  2204,  2429,
    2126,  3626,  2660,  2129,  1547, -1599,  2326,  2151,  2165,  2177,
     479,  2179,  1547,  2183,  4035,  3896,  2185,  3897,  3898,  2206,
     689,   466,  1122,  -480,  3379,   467,  2207,  3380,  2091,  3966,
    2211,  3968,  2210,  2213,  2254,  2217,  1830,   480,   695,  2219,
    2220,  2224,  2266,   697,  1831,  2221,   698,  1161,  2092,  2222,
    2223,  3984,  2204,  1472,  2275,  1473,  1474,  1475,  2271,  1832,
    2276,   468,  2093,  3343,  1476,  2272,  2278,   481,  1939,   469,
    3618,  2094,  2285,  2279,  2288,  -555,  2287,  2295,  2294,  2329,
    2300,  2256,  2301,  2388,  2367,  2404,  4015,  4016,  2411,  2306,
    2416,  2307,  2407,  2435,  2434,  3381,  3382,  2436,  3281,  2494,
    2446,  2066,  1104,  2475,  2447,  1105,  2459,  1162,   736,   567,
    2484,  1833,  1368,   736,   482,  1124,  1125,  2493,  2095,  2096,
    2476,  2477,  2501,  2506,  2504,  2505,  2507,  2508,  1834,  1163,
    2514,  2516,  2519,  2518,  2521,  2522,  1369,  1983,  3626,  1477,
    2529,  1987,  2533,   736,  2545,  3619,  2097,  2619,  2546,  2547,
    4029,  2548,  3806,  3332,  2158,  2157,  3252,  3804,  1548,   736,
    1124,  1125,  3620,  2566,  2011,  2565,  2588,  2596,  2589,  2597,
    2598,  2592,  2614,   567,  3273,  2567,  2621,  2622,  2667,  2669,
    1838,  2708,  1839,  2724,  3621,  1812,  1813,  1478,  1479,  1841,
    1463,  1464,  1465,  1466,  1467,  2730,  2734,  2737,  2743,  2744,
     736,   736,   736,   736,  2098,  2736,  2748,  2749,  2750,  2751,
    1840,  2429,   736,  3387,  3281,  1119,  1757,  -676,  -676,  1815,
    1934,  2787,  2780,  2783,  2788,  1164,  -676,  2836,  2789,   -59,
    1818,  2790,  2792,  1165,   483,  2793,  2848,  2838,  1819,  2843,
    2846,  2855,  2853,  2859,  1127,  1128,  1129,  1130,  1131,  1132,
    1133,  1134,  1847,  1211,  2864,  2099,  2867,   567,  1821,  2881,
    2868,  2875,  2878,  1166,  2257,  2883,  2895,  3143,  2900,  1119,
    2894,  2908,  1337,  2933,  3353,  1822,  2919,  -555,  2925,  2929,
    2930,  3031,  3433,  2945,  1468,  1469,  1470,  1471,  2946,  3437,
    1128,  1129,  1130,  1131,  1132,  1133,  1134,   484,  2955,  3034,
    1167,  3038,  3037,  1827,  3055,  1848,  3042,  3051,  3049,  2964,
    -397,  1999,  3067,  3044,  3056,  3065,  1480,  2142,  3082,  3071,
    1849,   567,  3078,  1850,  1168,  3079,  1106,  1481,  1482,  3883,
    3090,  3114,  3089,  3101,  3116,  3125,  3136,  3144,  3152,   871,
    4041,  1851,  1169,  3416,  3153,   132,  3156,  3157,  1852,  3161,
    3162,   485,  3174,  3181,  3622,   486,  3182,  3183,  3194,  1853,
    2258,  3197,  3198,  3485,  3201,  2806,  3249,  3221,  1830,  3243,
    3244,  3246,  2327,  3251,   487,  3253,  1831,   567,  3442,  3804,
    3260,  3957,  1472,  3270,  1473,  1474,  1475,  3271,  3274,  3275,
    3277,  1832,  3284,  1476,  1122,  3240,  3507,  3294,  3295,   488,
    3297,  3301,  3302,  3303,  2390,  3319,  3326,  3327,  3281,  3281,
    3324,  2769,  3328,  3330,   489,  3337,  3339,  3340,  2898,  3345,
    3348,  3344,  3350,  3397,  3351,  3528,  3363,  3375,  3376, -1249,
    3957, -1254,  3398,  3405,  3411,   736,  -555,  3413,  3420,  3421,
    3237,  3422,  3626,  1833,  3409,  3424,  3425,  3445,  1122,  3426,
    3427,  3459,  3446,  3428,  3429,  3431,  3462,  3464,  3465,  3466,
    1834,  4024,  1375,  1376,  1377,  1378,  1379,  1380,  1477,  1381,
    1382,  1383,  1384,  1385,  1386,  1387,  3467,  1388,  3468,  3486,
    3583,   557,  3479,  3495,  3498,  3499,  3501,   736,   736,  3521,
    3281,  3503,  3505,  3530,  3531,  4024,   736,   736,   736,   736,
     736,   736,   736,  3536,  3538,  3539,  3544,   736,  3540,  3585,
     736,   736,  1838,   736,  1839,   736,  1478,  1479,  3541,   736,
    3578,  1841,   736,   736,   736,   736,  3293,   736,   736,  3607,
    3601,  3597,  1124,  1125,  3542,   736,   736,  3543,   736,   736,
     736,   736,   736,  3598,   736,  3584,   736,   736,   736,   736,
     736,   736,   736,   736,   736,   736,   736,  3608,  3610,   736,
     736,  3640,   736,  3642,   736,  3644,  3646,  3649,   736,  3674,
     736,   736,  3692,  -267,  3656,  3702,  3694,  3707,  3695,  3704,
    3678,  3710,   736,   736,  1847,  3685,  1124,  1125,   736,  3719,
    3722,   736,  3720,  3723,  3731,  1389,  1390,  3728,   736,   736,
     736,  3737,   736,  3735,  3738,  3739,  3740,  3746,  3758,   736,
     736,   736,  2720,   736,   736,   736,   736,   736,  3768,   736,
     736,   736,   736,   736,   736,   736,   736,  3771,  -285,  3866,
     736,   736,  3797,  3798,  3799,  3800,  3811,  1848,  3844,   617,
    1548,   557,  3814,  3846,  3866,  1480,  3485,  3836,  3847,  3854,
    3835,  3852,  1849,  3853,   791,  1850,  1481,  1482,  3877,  3862,
    3863,  1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,  3867,
    3873,  3874,  3876,  1851,  3899,  3855,  3907,  3507,  3909,  3507,
    1852,  3749,  3911,  3921,  3912,  3902,  3915, -2066,  3932,  3926,
    3927,  1853,  3931,  3939,  3933, -1402,  3953,  3762,  3952,  3961,
    3963,  3969,  3983,  3974,  3964,  3714,  3378,  3987,  3989,  3995,
    3965,  3970,  3979,   638,  3772,  1127,  1128,  1129,  1130,  1131,
    1132,  1133,  1134,  3980,  3999,  3992,  4003,  4005,  3993,  4012,
    4013,  4027,  4030,  4036,  3687,  4040,   736,  3259,  2500,  2359,
    2629,  2391,   978,  3261,   736,  3580,  3699,  3875,  3922,  3447,
    3450,  4046,  3582,  4008,  3555,  4017,  1349,  3556,  3558,  3866,
     567,  3559,  2499,  3561,   642,  3562,  3936,  3563,  3841,  3951,
    3564,   643,  1002,  3565,  3566,  3860,  3937,  3569,  3920,  3872,
    1410,  3871,  3570,  3571,  1808,  2069,  2691,  1854,  3587,  2863,
    3815,  3123,  3609,  3718,  3333,  3925,  3930,   647,  3888,  3956,
    3730,  1898,  1034,  3276,   606,  2316,  2429,  3976,  3512,  3048,
    3195,  2721,  2767,  2645,  3929,  2323,  3184,  3208,  1051,  3866,
    3209,  3866,  3386,  3247,  3423,  3532,  3415,  3755,  3994,  3150,
    3529,  3187,  1927,  3761,  3662,  3708,  3596,  3866,  3535,  3825,
    2400,  2320,  2711,  3186,  1548,  2195,  3389,  2530,  1741,  3185,
    1896,  2858,  2134,  1367,  2549,  2517,   903,  1245,  2156,  3627,
    3105,  2845,  1097,   654,  2432,  2609,  3158,  3651,  3866,  3866,
    3511,  3900,   567,  4039,  3901,  3043,  1500,  3508,  1538,  2491,
    3190,  3998,  3497,  2706,  1452,  3833,  2402,  2336,  2336,   753,
     754,  1641,  2556,  1666,  2513,  2536,  3129,  3335,  3128,  3168,
    4045,  3881,   892,  1932,   994,  2408,  2187,     1,     2,   877,
    2079,  2971,  1709,  3115,  1668,  3955,   567,  3977,  3741,   665,
    4047,  3419,     3,  3132,   567,  3848,  2166,  2916,     5,  3154,
    1682,  3349,  3500,   736,   669,   670,  2113,  1673,   820,  3600,
    1917,  3941,     6,     7,  3889,  3890,  1634,  1233,  3949,     8,
    2847,  3606,   822,     9,    10,  4042,  1237,  2473,  1553,  2835,
     600,   601,   982,     0,   983,   755,    11,   984,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    12,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   756,     0,     0,     0,     0,  3985,     0,
       0,     0,    13,  3990,     0,     0,   757,     0,     0,     0,
      14,    15,    16,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    17,    18,     0,     0,     0,     0,   758,     0,
     759,     0,   736,   736,   736,     0,     0,  4025,     0,     0,
       0,   760,     0,     0,     0,     0,  1548,    20,   736,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   761,     0,    21,     0,   567,     0,     0,     0,  1548,
     736,  4025,     0,     0,     0,     0,   736,  1548,    22,   736,
       0,   736,     0,    23,     0,   762,    24,   736,     0,   736,
     736,     0,   763,     0,  1374,     0,     0,     0,     0,     0,
       0,     0,     0,   689,     0,     0,     0,  3379,     0,    25,
    3380,    26,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   695,     0,     0,     0,     0,   697,    27,     0,   698,
       0,   764,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,  1432,  1433,    29,     0,
     736,     0,     0,     0,     0,  1443,  1444,     0,     0,  1447,
    1448,  1449,     0,     0,     0,     0,  1454,     0,     0,  1456,
    1457,     0,  1458,     0,  1459,     0,     0,     0,  3381,  3382,
       0,  1493,  1494,  1495,  1496,     0,  1498,     0,     0,     0,
       0,     0,     0,     0,  1506,  1507,     0,  1510,  1511,     0,
       0,     0,     0,  1515,     0,  1516,  1517,  1518,     0,     0,
    1521,  1522,  1523,  1524,  1525,  1526,     0,     0,  1529,  1530,
       0,  1533,     0,  1534,     0,     0,     0,  1539,     0,  1543,
    1544,     0,     0,     0,    30,   754,     0,     0,     0,     0,
       0,  1551,  1552,     0,     0,     0,     0,  1097,     0,     0,
    1558,     0,     0,   765,    31,     0,     0,  1563,  1564,  1565,
       0,     0,     0,     0,    32,     0,     0,     0,   818,   754,
       0,     0,   766,     0,    33,     0,     0,     0,   767,     0,
       0,     0,     0,     0,     0,     0,   768,     0,     0,     0,
    1601,     0,     0,     0,    34,     0,     0,    35,     0,    36,
       0,     0,    37,     0,     0,    38,     0,    39,     0,   769,
     755,     0,    40,     0,    41,     0,     0,     0,     0,     0,
       0,    42,   770,   771,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,   756,    45,
       0,     0,     0,    46,   755,     0,     0,     0,     0,     0,
       0,   757,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   772,     0,     0,    47,     0,     0,   736,
      48,     0,   756,   758,     0,   759,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   757,   760,     0,     0,     0,
       0,     0,   773,     0,     0,  1681,     0,     0,     0,     0,
       0,     0,     0,  1696,     0,     0,   761,   758,     0,   759,
       0,     0,    49,     0,   774,     0,   775,     0,     0,     0,
     760,     0,     0,     0,    50,     0,     0,     0,    51,   736,
     762,    52,     0,   736,     0,     0,    53,   763,   736,   736,
     761,     0,     0,     0,     0,     0,     0,   736,     0,     0,
     736,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     736,    54,   736,   736,   762,   736,   736,   736,   736,   736,
       0,   763,   736,     0,     0,    55,   764,     0,     0,  1809,
       0,   736,     0,     0,     0,     0,  1810,  1811,     0,   736,
       0,   736,     0,   736,   736,   736,   736,     0,  1812,  1813,
     736,   736,   736,     0,     0,     0,     0,   736,   736,   736,
     764,   736,     0,   736,     0,   736,     0,   736,     0,   736,
       0,     0,     0,     0,   736,     0,     0,     0,  1814,     0,
       0,     0,  1815,  1816,   736,     0,     0,  1817,     0,     0,
       0,   736,     0,  1818,   736,     0,     0,     0,     0,     0,
     736,  1819,     0,   736,     0,     0,     0,   736,  1820,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1337,     0,     0,  1822,     0,
       0,     0,  1945,     0,     0,  1823,  1824,     0,   765,     0,
       0,     0,  1825,     0,     0,     0,     0,     0,     0,     0,
    1826,     0,     0,     0,  -783,     0,  1827,   766,     0,     0,
       0,     0,     0,   767,     0,     0,     0,     0,     0,     0,
       0,   768,   765,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1828,     0,     0,     0,     0,     0,     0,
       0,   766,     0,     0,   769,     0,     0,   767,     0,     0,
       0,     0,     0,     0,     0,   768,     0,   770,   771,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1829,
       0,  1830,     0,     0,     0,     0,     0,     0,   769,  1831,
       0,  2020,  2022,  2024,     0,     0,     0,     0,     0,     0,
       0,   770,   771,     0,  1832,     0,     0,     0,   772,     0,
       0,     0,  1812,  1813,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2050,
       0,     0,     0,     0,     0,     0,     0,   773,  2055,     0,
    2056,     0,   772,     0,  -676,  -676,  1815,     0,     0,     0,
       0,     0,     0,  -676,     0,     0,  1833,  1818,     0,   774,
       0,   775,     0,     0,     0,  1819,     0,     0,     0,     0,
       0,   773,     0,  1834,     0,     0,     0,  1835,     0,     0,
       0,     0,     0,     0,     0,  1821,     0,     0,     0,     0,
       0,     0,     0,   774,     0,   775,     0,     0,     0,  1337,
       0,     0,  1822,     0,     0,     0,     0,     0,     0,  2130,
       0,     0,     0,  1836,     0,     0,     0,     0,  1837,     0,
       0,     0,     0,     0,     0,  1838,     0,  1839,     0,     0,
    1827,     0,     0,  1840,  1841,   838,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   800,   839,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1842,     0,     0,     0,     0,     0,   840,
     841,     0,     0,     0,     0,  1843,  1844,  1845,  1846,   842,
       0,   843,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1830,   844,  1847,   845,     0,
     846,   736,     0,  1831,     0,   736,     0,     0,   847,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1832,     0,
       0,     0,     0,     0,     0,     0,     0,   736,   736,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   736,     0,     0,
    1848,     0,     0,     0, -1599,   848,   736,     0,   736,   849,
     736,     0,   850,     0,     0,  1849,     0,     0,  1850,     0,
    1833,     0,     0,     0,     0,   736,     0,     0,     0,     0,
     736,     0,     0,     0,     0,     0,  1851,  1834,   851,     0,
     852,     0,     0,  1852,     0,   853,     0,   854,     0,     0,
       0,     0,   736,     0,  1853,     0,     0,     0,     0,     0,
       0,     0,   736,     0,     0,     0,     0,     0,     0,   855,
     856,     0,     0,     0,   857,     0,     0,     0,  2337,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1838,
       0,  1839,   858,     0,     0,     0,     0,     0,  1841,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     736,     0,  -783,   859,   736,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2410,     0,
     860,     0,  2412,     0,     0,     0,     0,  2414,  2415,     0,
       0,     0,     0,     0,     0,     0,  2430,   736,     0,     0,
       0,  1847,     0,     0,     0,     0,     0,     0,     0,  2437,
       0,  2438,   861,     0,  2440,  2441,  2442,  2443,  2444,     0,
       0,     0,   862,   736,     0,     0,     0,     0,     0,     0,
    2448,     0,     0,     0,     0,     0,     0,     0,  2449,     0,
    2450,   863,  2451,  2452,  2453,     0,     0,     0,     0,  2456,
    2457,  2458,     0,     0,  1848,     0,  2460,  2461,  2462,     0,
    2463,     0,  2465,     0,  2467,   864,  2469,     0,  2470,  1849,
       0,     0,  1850,  2471,     0,     0,   865,   866,     0,     0,
     867,   868,     0,  2479,     0,     0,     0,     0,     0,     0,
    1851,     0,     0,     0,     0,     0,     0,  1852,     0,  2489,
       0,     0,  2492,     0,     0,     0,     0,     0,  1853,   736,
     736,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   869,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   870,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   736,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     1,     2,     0, -2092,     0,     0,     0,   871,
       0,     0,     0,   736,   736,     0,   736,     3,     0,     4,
       0,     0,     0,     5,     0,   736,   872,     0,     0,     0,
     736,     0,     0,   736,     0,   736,   736,     6,     7,     0,
       0,     0,     0,     0,     8,     0,     0,     0,     9,    10,
       0,     0,     0,     0,   736,     0,     0,     0,     0,     0,
       0,    11,     0,     0,     0,   736,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    12,     0,     0,
       0,     0,     0, -2092,     0,     0,   736,     0,     0,   873,
    1812,  1813,     0,     0,     0,     0,     0,    13,     0,     0,
       0,     0,     0,     0,     0,    14,    15,    16,     0,     0,
       0,     0,     0,     0,     0,   736,     0,    17,    18,     0,
       0,     0,     0,     0,  1815,     0,     0,     0,     0,   736,
      19,     0,     0,     0,     0,  1818,     0,     0,     0,     0,
       0,     0,    20,  1819,     0,     0,     0,   736,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    21,     0,
       0,     0,     0,  1821,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    22,     0,     0,     0,  1337,    23,     0,
    1822,    24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,     0,    26,     0,  1827,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    27,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    28,
       0,     0,     0,    29,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1830,     0,     0,     0,     0,     0,     0,
    2776,  1831,     0,     0,  2778,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1832,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2795,  2796,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2816,     0,     0,    30,
       0,     0,     0,     0,     0,  2826,     0,  2828,   736,  2830,
       0,     0,     0,     0,     0,     0,     0,     0,  1833,    31,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    32,
       0,     0,     0,     0,     0,  1834,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,   736,   736,     0,
       0,  2854,     0,     0,     0,     0,   736,     0,     0,    34,
       0,     0,    35,     0,    36,     0,     0,    37,     0,     0,
      38,     0,    39,     0,     0,     0,     0,    40,     0,    41,
       0,     0,     0,     0,     0,     0,    42,  1838,     0,  1839,
       0,    43,     0,     0,     0,     0,  1841,     0,     0,    44,
       0,     0,     0,     0,    45,     0,     0,     0,    46,  2906,
       0,     0,     0,  2910,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,     0,     0,     0,     0,
       0,     0,     0,     0,  2976,  2977,     0,     0,     0,     0,
    2978,     0,  2979,     0,  2980,  2981,  2939,     0,     0,  1847,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2982,     0,     0,     0,     0,     0,     0,    49,     0,     0,
       0,   736,  2944,     0,     0,     0,     0,     0,     0,    50,
       0,     0,     0,    51,     0,     0,    52,     0,     0,     0,
       0,    53,     0,     0,     0,     0,   736,     0,     0,     0,
       0,  2983,  1848,     0,  2984,     0,     0,     0,     0,     0,
       0,   736,  2985,     0,     0,     0,    54,  1849,     0,     0,
    1850,     0,     0,     0,   736,     0,     0,     0,     0,  2986,
      55,     0,     0,     0,     0,     0,     0,     0,  1851,     0,
       0,     0,     0,     0,     0,  1852,  2987,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1853,     0,  3032,  3033,
       0,     0,     0,     0,     0,     0,     0,     0,  2988,     0,
    2989,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2990,  2991,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3573,     0,
    3070,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2992,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3084,  3085,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3092,     0,     0,     0,     0,  3094,
    2993,     0,  3095,   736,  3096,  3097,     0,     0,     0,  2994,
    2995,     0,  2996,     0,     0,   736,     0,     0,     0,     0,
       0,     0,     0,     0,   736,     0,   736,     0,     0,     0,
       0,     0,     0,     0,  3111,     0,     0,     0,     0,     0,
       0,  2997,  2998,  2999,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3111,     0,     0,     0,  3000,
    3001,  3002,     0,     0,     0,  3003,   736,     0,  3004,     0,
       0,     0,  3573,  3573,     0,     0,     0,     0,     0,     0,
       0,  2709,     0,     0,  3005,  3006,     0,     0,  1810,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3155,     0,
    1812,  1813,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3111,  3007,  3008,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1814,     0,     0,     0,  1815,     0,     0,     0,     0,     0,
       0,  3009,     0,     0,     0,  1818,     0,     0,     0,     0,
       0,   736,     0,  1819,     0,     0,     0,     0,     0,     0,
    1820,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1821,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1337,  3010,     0,
    1822,     0,  3011,     0,     0,     0,   736,  1823,   736,     0,
       0,     0,  3012,     0,  2710,     0,     0,     0,   736,     0,
    3573,  3573,  1826,     0,     0,     0,     0,     0,  1827,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3810,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   736,     0,     0,     0,  1828,     0,     0,     0,     0,
       0,     0,  3013,     0,     0,  3014,     0,     0,  3015,  3016,
    3017,  3018,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1830,     0,     0,     0,     0,     0,     0,
       0,  1831,     0,     0,     0,     0,   736,     0,  3573,     0,
       0,  3019,  3020,     0,     0,     0,  1832,  3111,     0,     0,
       0,     0,     0,  3573,   736,     0,     0,     0,     0,     0,
       0,     0,  3021,     0,     0,     0,     0,  3573,     0,     0,
       0,     0,     0,     0,   736,     0,     0,     0,     0,     0,
       0,     0,     0,   736,     0,     0,  3361,  3362,     0,     0,
       0,     0,     0,     0,     0,  2939,     0,     0,  1833,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1834,     0,     0,     0,  1835,
     736,  3573,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3573,  3573,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   736,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1837,     0,     0,     0,     0,     0,     0,  1838,  3573,  1839,
       0,     0,     0,     0,     0,   736,  1841,     0,  3573,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   736,     0,     0,
       0,     0,     0,     0,  3573,     0,  3573,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3573,     0,  1844,   736,
    3463,     0,     0,     0,     0,     0,  3573,     0,  3573,     0,
    3573,     0,     0,     0,     0,     0,     0,  3573,     0,  1847,
       0,     0,     0,     0,     0,  3111,  3573,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2939,  3573,  3573,     0,     0,     0,     0,   736,     0,     0,
       0,     0,     0,  2906,     0,     0,     0,  3573,  3573,     0,
       0,     0,  3573,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1848,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1849,     0,     0,
    1850,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1851,     0,
       0,     0,     0,     0,     0,  1852,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1853,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3632,     0,     0,     0,     0,     0,
       0,     0,     0,  3643,     0,  3645,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3673,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2939,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3766,     0,  3767,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3775,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3864,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3869,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3111,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3905,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3943,     0,     0,     0,     0,     0,
       0,     0,     0,   138,     0,   613,   140,   141,   142,   143,
       0,     0,     0,     0,     0,   144,  3962,     0,   614,     0,
     146,   147,   148,   149,   150,   615,   152,     0,   153,     0,
       0,   616,   154,   617,   618,   619,   155,   620,  3978,   156,
     157,   158,  1540,   159,     0,   160,   161,     0,     0,   162,
     621,   622,   163,     0,   164,   623,   624,   166,     0,   167,
     168,   169,   625,   171,     0,   626,   173,     0,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   627,
     184,     0,   185,   628,   629,   186,  4026,     0,   187,   630,
     631,     0,   632,   633,     0,   188,   189,   190,   634,   635,
     636,     0,     0,     0,     0,   637,   193,   638,     0,     0,
     639,   194,     0,   195,     0,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,     0,   201,     0,     0,   202,
     203,   204,     0,     0,     0,   205,     0,   206,   207,     0,
     208,   209,   210,     0,     0,   211,     0,   212,   213,   214,
     215,   216,   640,     0,   217,   218,   219,   641,   642,   220,
     221,     0,   222,   223,   224,   643,     0,   225,     0,     0,
       0,   226,   227,     0,   228,     0,   229,     0,   644,   231,
     645,   233,     0,   234,     0,   646,     0,   235,   236,     0,
     237,   647,     0,   238,   239,     0,     0,     0,   648,   241,
     242,   243,   649,     0,   244,   245,     0,     0,   246,     0,
     247,     0,     0,   650,   248,   249,   651,     0,     0,   250,
       0,   251,   252,     0,   253,   254,     0,     0,     0,   255,
       0,     0,   256,   257,     0,  1541,   258,     0,   652,   259,
     260,     0,     0,     0,     0,     0,   653,   262,     0,   263,
       0,   264,     0,   265,   266,     0,     0,   654,     0,     0,
       0,     0,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,     0,   280,   281,   655,   282,
     283,   284,   285,   656,   286,   287,   288,     0,     0,     0,
     289,   290,   291,   657,   293,     0,     0,   658,   295,   659,
     296,     0,   297,   660,   661,   662,   663,   664,   302,   303,
     304,   305,     0,   665,   306,   307,     0,     0,   308,   309,
     310,   311,   666,   667,   668,   312,   313,     0,   669,   670,
       0,   314,   315,   671,     0,   317,   318,   319,     0,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
     322,   323,   324,   672,   325,   326,   327,   328,   329,   673,
     331,   332,   333,   674,   675,   336,   676,     0,   337,   338,
     339,     0,   340,     0,   341,   342,   343,   344,     0,   677,
     346,   347,     0,     0,   348,     0,     0,     0,   349,   350,
     351,   352,   353,     0,     0,   354,   355,   356,     0,   357,
     358,     0,   359,   360,   361,   678,   679,   362,     0,   363,
     364,   365,     0,   366,   367,     0,     0,   680,   368,   369,
     370,   371,   372,   681,   374,   375,   376,     0,   682,   378,
       0,     0,     0,   379,   380,   381,   382,     0,     0,     0,
     383,     0,     0,     0,   384,   385,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,     0,     0,     0,     0,
     393,   394,     0,   395,     0,     0,   396,     0,     0,   397,
     398,   399,   683,   684,   400,   401,     0,   402,   685,   404,
     405,   406,   686,   687,   407,   408,   409,   410,   688,   411,
     412,     0,     0,   413,   414,   415,     0,   689,   416,   417,
       0,   690,   691,   692,   693,     0,     0,     0,     0,  1542,
     422,   423,   424,     0,   694,   695,   696,   426,   427,   428,
     697,   429,   430,   698,   431,   432,     0,   433,   434,     0,
       0,   435,     0,     0,   436,     0,   437,     0,   699,   439,
       0,     0,   700,   701,   702,   703,   440,     0,     0,   441,
     704,     0,   705,   442,   443,   444,   706,     0,     0,     0,
       0,   446,   447,     0,   448,   449,     0,     0,   707,     0,
       0,     0,   708,   709,     0,     0,     0,     0,   710,   711,
       0,     0,   712,   713,     0,   714,   715,   138,     0,   613,
     140,   141,   142,   143,  2902,     0,     0,     0,     0,   144,
       0,     0,   614,     0,   146,   147,   148,   149,   150,   615,
     152,     0,   153,     0,     0,  2903,   154,   617,   618,   619,
     155,   620,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,   621,   622,   163,     0,   164,   623,
     624,   166,     0,   167,   168,   169,   625,   171,     0,   626,
     173,     0,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,     0,   627,   184,     0,   185,   628,   629,   186,
       0,     0,   187,   630,   631,     0,   632,   633,     0,   188,
     189,   190,   634,   635,   636,     0,     0,     0,     0,   637,
     193,   638,     0,     0,  2904,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
     201,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,   206,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,   216,   640,     0,   217,   218,
     219,   641,   642,   220,   221,     0,   222,   223,   224,   643,
       0,   225,     0,     0,     0,   226,   227,     0,   228,     0,
     229,     0,   644,   231,   645,   233,     0,   234,     0,   646,
       0,   235,   236,     0,   237,   647,     0,   238,   239,     0,
       0,     0,   648,   241,   242,   243,   649,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,   650,   248,   249,
     651,     0,     0,   250,     0,   251,   252,     0,   253,   254,
       0,     0,     0,   255,     0,     0,   256,   257,     0,     0,
     258,     0,   652,   259,   260,     0,     0,     0,     0,     0,
     653,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,   654,     0,     0,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,   655,   282,   283,   284,   285,   656,   286,   287,
     288,     0,     0,     0,   289,   290,   291,   657,   293,     0,
       0,   658,   295,   659,   296,     0,   297,   660,   661,   662,
     663,   664,   302,   303,   304,   305,     0,   665,   306,   307,
       0,     0,   308,   309,   310,   311,   666,   667,   668,   312,
     313,     0,   669,   670,     0,   314,   315,   671,  2905,   317,
     318,   319,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,   322,   323,   324,   672,   325,   326,
     327,   328,   329,   673,   331,   332,   333,   674,   675,   336,
     676,     0,   337,   338,   339,     0,   340,     0,   341,   342,
     343,   344,     0,   677,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,   358,     0,   359,   360,   361,   678,
     679,   362,     0,   363,   364,   365,     0,   366,   367,     0,
       0,   680,   368,   369,   370,   371,   372,   681,   374,   375,
     376,     0,   682,   378,     0,     0,     0,   379,   380,   381,
     382,     0,     0,     0,   383,     0,     0,     0,   384,   385,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
       0,     0,     0,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,   398,   399,   683,   684,   400,   401,
       0,   402,   685,   404,   405,   406,   686,   687,   407,   408,
     409,   410,   688,   411,   412,     0,     0,   413,   414,   415,
       0,   689,   416,   417,     0,   690,   691,   692,   693,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   694,   695,
     696,   426,   427,   428,   697,   429,   430,   698,   431,   432,
       0,   433,   434,     0,     0,   435,     0,     0,   436,     0,
     437,     0,   699,   439,     0,     0,   700,   701,   702,   703,
     440,     0,     0,   441,   704,     0,   705,   442,   443,   444,
     706,     0,     0,     0,     0,   446,   447,     0,   448,   449,
       0,     0,   707,     0,     0,     0,   708,   709,     0,     0,
       0,     0,   710,   711,     0,     0,   712,   713,     0,   714,
     715,   138,     0,   613,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,     0,   614,     0,   146,   147,
     148,   149,   150,   615,   152,     0,   153,     0,     0,   616,
     154,   617,   618,   619,   155,   620,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,   621,   622,
     163,     0,   164,   623,   624,   166,     0,   167,   168,   169,
     625,   171,     0,   626,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   627,   184,     0,
     185,   628,   629,   186,     0,     0,   187,   630,   631,     0,
     632,   633,     0,   188,   189,   190,   634,   635,   636,     0,
       0,     0,     0,   637,   193,   638,     0,     0,   639,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,   216,
     640,     0,   217,   218,   219,   641,   642,   220,   221,     0,
     222,   223,   224,   643,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   644,   231,   645,   233,
       0,   234,     0,   646,     0,   235,   236,     0,   237,   647,
       0,   238,   239,     0,     0,     0,   648,   241,   242,   243,
     649,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,   650,   248,   249,   651,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
     256,   257,     0,     0,   258,     0,   652,   259,   260,     0,
       0,     0,     0,     0,   653,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,   654,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,   655,   282,   283,   284,
     285,   656,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   657,   293,     0,     0,   658,   295,   659,   296,     0,
     297,   660,   661,   662,   663,   664,   302,   303,   304,   305,
       0,   665,   306,   307,     0,     0,   308,   309,   310,   311,
     666,   667,   668,   312,   313,     0,   669,   670,     0,   314,
     315,   671,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,   672,   325,   326,   327,   328,   329,   673,   331,   332,
     333,   674,   675,   336,   676,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   677,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,   678,   679,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,   680,   368,   369,   370,   371,
     372,   681,   374,   375,   376,     0,   682,   378,  1095,     0,
       0,   379,   380,   381,   382,     0,     0,     0,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
     683,   684,   400,   401,     0,   402,   685,   404,   405,   406,
     686,   687,   407,   408,   409,   410,   688,   411,   412,     0,
       0,   413,   414,   415,     0,   689,   416,   417,     0,   690,
     691,   692,   693,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   694,   695,   696,   426,   427,   428,   697,   429,
     430,   698,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   699,   439,     0,     0,
     700,   701,   702,   703,   440,     0,     0,   441,   704,     0,
     705,   442,   443,   444,   706,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,     0,   707,     0,     0,     0,
     708,   709,     0,     0,     0,     0,   710,  1096,     0,     0,
     712,   713,     0,   714,   715,   138,     0,   613,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
     614,     0,   146,   147,   148,   149,   150,   615,   152,     0,
     153,     0,     0,   616,   154,   617,   618,   619,   155,   620,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,   621,   622,   163,     0,   164,   623,   624,   166,
       0,   167,   168,   169,   625,   171,     0,   626,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   627,   184,     0,   185,   628,   629,   186,     0,     0,
     187,   630,   631,     0,   632,   633,     0,   188,   189,   190,
     634,   635,   636,     0,     0,     0,     0,   637,   193,   638,
       0,     0,   639,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,   640,     0,   217,   218,   219,   641,
     642,   220,   221,     0,   222,   223,   224,   643,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     644,   231,   645,   233,     0,   234,     0,   646,     0,   235,
     236,     0,   237,   647,     0,   238,   239,     0,     0,     0,
     648,   241,   242,   243,   649,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,   650,   248,   249,   651,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
     652,   259,   260,     0,     0,     0,     0,     0,   653,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,   654,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
     655,   282,   283,   284,   285,   656,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   657,   293,     0,     0,   658,
     295,   659,   296,     0,   297,   660,   661,   662,   663,   664,
     302,   303,   304,   305,     0,   665,   306,   307,     0,     0,
     308,   309,   310,   311,   666,   667,   668,   312,   313,     0,
     669,   670,     0,   314,   315,   671,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,   672,   325,   326,   327,   328,
     329,   673,   331,   332,   333,   674,   675,   336,   676,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   677,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,   678,   679,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,   680,
     368,   369,   370,   371,   372,   681,   374,   375,   376,     0,
     682,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,   683,   684,   400,   401,     0,   402,
     685,   404,   405,   406,   686,   687,   407,   408,   409,   410,
     688,   411,   412,     0,     0,   413,   414,   415,     0,   689,
     416,   417,     0,   690,   691,   692,   693,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   694,   695,   696,   426,
     427,   428,   697,   429,   430,   698,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     699,   439,     0,     0,   700,   701,   702,   703,   440,     0,
       0,   441,   704,     0,   705,   442,   443,   444,   706,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,     0,
     707,     0,     0,     0,   708,   709,     0,     0,     0,     0,
     710,   711,  1453,     0,   712,   713,     0,   714,   715,   138,
       0,   613,   140,   141,   142,   143,     0,     0,     0,     0,
       0,   144,     0,     0,   614,     0,   146,   147,   148,   149,
     150,   615,   152,     0,   153,     0,     0,   616,   154,   617,
     618,   619,   155,   620,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,   621,   622,   163,     0,
     164,   623,   624,   166,     0,   167,   168,   169,   625,   171,
       0,   626,   173,     0,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   627,   184,     0,   185,   628,
     629,   186,     0,     0,   187,   630,   631,     0,   632,   633,
       0,   188,   189,   190,   634,   635,   636,     0,     0,     0,
       0,   637,   193,   638,     0,     0,   639,   194,     0,   195,
       0,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,     0,   201,     0,     0,   202,   203,   204,     0,     0,
       0,   205,     0,   206,   207,     0,   208,   209,   210,     0,
       0,   211,     0,   212,   213,   214,   215,   216,   640,     0,
     217,   218,   219,   641,   642,   220,   221,     0,   222,   223,
     224,   643,     0,   225,     0,     0,     0,   226,   227,  2019,
     228,     0,   229,     0,   644,   231,   645,   233,     0,   234,
       0,   646,     0,   235,   236,     0,   237,   647,     0,   238,
     239,     0,     0,     0,   648,   241,   242,   243,   649,     0,
     244,   245,     0,     0,   246,     0,   247,     0,     0,   650,
     248,   249,   651,     0,     0,   250,     0,   251,   252,     0,
     253,   254,     0,     0,     0,   255,     0,     0,   256,   257,
       0,     0,   258,     0,   652,   259,   260,     0,     0,     0,
       0,     0,   653,   262,     0,   263,     0,   264,     0,   265,
     266,     0,     0,   654,     0,     0,     0,     0,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,     0,   280,   281,   655,   282,   283,   284,   285,   656,
     286,   287,   288,     0,     0,     0,   289,   290,   291,   657,
     293,     0,     0,   658,   295,   659,   296,     0,   297,   660,
     661,   662,   663,   664,   302,   303,   304,   305,     0,   665,
     306,   307,     0,     0,   308,   309,   310,   311,   666,   667,
     668,   312,   313,     0,   669,   670,     0,   314,   315,   671,
       0,   317,   318,   319,     0,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,   322,   323,   324,   672,
     325,   326,   327,   328,   329,   673,   331,   332,   333,   674,
     675,   336,   676,     0,   337,   338,   339,     0,   340,     0,
     341,   342,   343,   344,     0,   677,   346,   347,     0,     0,
     348,     0,     0,     0,   349,   350,   351,   352,   353,     0,
       0,   354,   355,   356,     0,   357,   358,     0,   359,   360,
     361,   678,   679,   362,     0,   363,   364,   365,     0,   366,
     367,     0,     0,   680,   368,   369,   370,   371,   372,   681,
     374,   375,   376,     0,   682,   378,     0,     0,     0,   379,
     380,   381,   382,     0,     0,     0,   383,     0,     0,     0,
     384,   385,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,     0,     0,     0,     0,   393,   394,     0,   395,
       0,     0,   396,     0,     0,   397,   398,   399,   683,   684,
     400,   401,     0,   402,   685,   404,   405,   406,   686,   687,
     407,   408,   409,   410,   688,   411,   412,     0,     0,   413,
     414,   415,     0,   689,   416,   417,     0,   690,   691,   692,
     693,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     694,   695,   696,   426,   427,   428,   697,   429,   430,   698,
     431,   432,     0,   433,   434,     0,     0,   435,     0,     0,
     436,     0,   437,     0,   699,   439,     0,     0,   700,   701,
     702,   703,   440,     0,     0,   441,   704,     0,   705,   442,
     443,   444,   706,     0,     0,     0,     0,   446,   447,     0,
     448,   449,     0,     0,   707,     0,     0,     0,   708,   709,
       0,     0,     0,     0,   710,   711,     0,     0,   712,   713,
       0,   714,   715,   138,     0,   613,   140,   141,   142,   143,
       0,     0,     0,     0,     0,   144,     0,     0,   614,     0,
     146,   147,   148,   149,   150,   615,   152,     0,   153,     0,
       0,   616,   154,   617,   618,   619,   155,   620,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
     621,   622,   163,     0,   164,   623,   624,   166,     0,   167,
     168,   169,   625,   171,     0,   626,   173,     0,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   627,
     184,     0,   185,   628,   629,   186,     0,     0,   187,   630,
     631,     0,   632,   633,     0,   188,   189,   190,   634,   635,
     636,     0,     0,     0,     0,   637,   193,   638,     0,     0,
     639,   194,     0,   195,     0,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,     0,   201,     0,     0,   202,
     203,   204,     0,     0,     0,   205,     0,   206,   207,     0,
     208,   209,   210,     0,     0,   211,     0,   212,   213,   214,
     215,   216,   640,     0,   217,   218,   219,   641,   642,   220,
     221,     0,   222,   223,   224,   643,     0,   225,     0,     0,
       0,   226,   227,  2021,   228,     0,   229,     0,   644,   231,
     645,   233,     0,   234,     0,   646,     0,   235,   236,     0,
     237,   647,     0,   238,   239,     0,     0,     0,   648,   241,
     242,   243,   649,     0,   244,   245,     0,     0,   246,     0,
     247,     0,     0,   650,   248,   249,   651,     0,     0,   250,
       0,   251,   252,     0,   253,   254,     0,     0,     0,   255,
       0,     0,   256,   257,     0,     0,   258,     0,   652,   259,
     260,     0,     0,     0,     0,     0,   653,   262,     0,   263,
       0,   264,     0,   265,   266,     0,     0,   654,     0,     0,
       0,     0,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,     0,   280,   281,   655,   282,
     283,   284,   285,   656,   286,   287,   288,     0,     0,     0,
     289,   290,   291,   657,   293,     0,     0,   658,   295,   659,
     296,     0,   297,   660,   661,   662,   663,   664,   302,   303,
     304,   305,     0,   665,   306,   307,     0,     0,   308,   309,
     310,   311,   666,   667,   668,   312,   313,     0,   669,   670,
       0,   314,   315,   671,     0,   317,   318,   319,     0,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
     322,   323,   324,   672,   325,   326,   327,   328,   329,   673,
     331,   332,   333,   674,   675,   336,   676,     0,   337,   338,
     339,     0,   340,     0,   341,   342,   343,   344,     0,   677,
     346,   347,     0,     0,   348,     0,     0,     0,   349,   350,
     351,   352,   353,     0,     0,   354,   355,   356,     0,   357,
     358,     0,   359,   360,   361,   678,   679,   362,     0,   363,
     364,   365,     0,   366,   367,     0,     0,   680,   368,   369,
     370,   371,   372,   681,   374,   375,   376,     0,   682,   378,
       0,     0,     0,   379,   380,   381,   382,     0,     0,     0,
     383,     0,     0,     0,   384,   385,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,     0,     0,     0,     0,
     393,   394,     0,   395,     0,     0,   396,     0,     0,   397,
     398,   399,   683,   684,   400,   401,     0,   402,   685,   404,
     405,   406,   686,   687,   407,   408,   409,   410,   688,   411,
     412,     0,     0,   413,   414,   415,     0,   689,   416,   417,
       0,   690,   691,   692,   693,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   694,   695,   696,   426,   427,   428,
     697,   429,   430,   698,   431,   432,     0,   433,   434,     0,
       0,   435,     0,     0,   436,     0,   437,     0,   699,   439,
       0,     0,   700,   701,   702,   703,   440,     0,     0,   441,
     704,     0,   705,   442,   443,   444,   706,     0,     0,     0,
       0,   446,   447,     0,   448,   449,     0,     0,   707,     0,
       0,     0,   708,   709,     0,     0,     0,     0,   710,   711,
       0,     0,   712,   713,     0,   714,   715,   138,     0,   613,
     140,   141,   142,   143,     0,     0,     0,     0,     0,   144,
       0,     0,   614,     0,   146,   147,   148,   149,   150,   615,
     152,     0,   153,     0,     0,   616,   154,   617,   618,   619,
     155,   620,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,   621,   622,   163,     0,   164,   623,
     624,   166,     0,   167,   168,   169,   625,   171,     0,   626,
     173,     0,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,     0,   627,   184,     0,   185,   628,   629,   186,
       0,     0,   187,   630,   631,     0,   632,   633,     0,   188,
     189,   190,   634,   635,   636,     0,     0,     0,     0,   637,
     193,   638,     0,     0,   639,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
     201,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,   206,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,   216,   640,     0,   217,   218,
     219,   641,   642,   220,   221,     0,   222,   223,   224,   643,
       0,   225,     0,     0,     0,   226,   227,  2023,   228,     0,
     229,     0,   644,   231,   645,   233,     0,   234,     0,   646,
       0,   235,   236,     0,   237,   647,     0,   238,   239,     0,
       0,     0,   648,   241,   242,   243,   649,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,   650,   248,   249,
     651,     0,     0,   250,     0,   251,   252,     0,   253,   254,
       0,     0,     0,   255,     0,     0,   256,   257,     0,     0,
     258,     0,   652,   259,   260,     0,     0,     0,     0,     0,
     653,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,   654,     0,     0,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,   655,   282,   283,   284,   285,   656,   286,   287,
     288,     0,     0,     0,   289,   290,   291,   657,   293,     0,
       0,   658,   295,   659,   296,     0,   297,   660,   661,   662,
     663,   664,   302,   303,   304,   305,     0,   665,   306,   307,
       0,     0,   308,   309,   310,   311,   666,   667,   668,   312,
     313,     0,   669,   670,     0,   314,   315,   671,     0,   317,
     318,   319,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,   322,   323,   324,   672,   325,   326,
     327,   328,   329,   673,   331,   332,   333,   674,   675,   336,
     676,     0,   337,   338,   339,     0,   340,     0,   341,   342,
     343,   344,     0,   677,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,   358,     0,   359,   360,   361,   678,
     679,   362,     0,   363,   364,   365,     0,   366,   367,     0,
       0,   680,   368,   369,   370,   371,   372,   681,   374,   375,
     376,     0,   682,   378,     0,     0,     0,   379,   380,   381,
     382,     0,     0,     0,   383,     0,     0,     0,   384,   385,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
       0,     0,     0,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,   398,   399,   683,   684,   400,   401,
       0,   402,   685,   404,   405,   406,   686,   687,   407,   408,
     409,   410,   688,   411,   412,     0,     0,   413,   414,   415,
       0,   689,   416,   417,     0,   690,   691,   692,   693,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   694,   695,
     696,   426,   427,   428,   697,   429,   430,   698,   431,   432,
       0,   433,   434,     0,     0,   435,     0,     0,   436,     0,
     437,     0,   699,   439,     0,     0,   700,   701,   702,   703,
     440,     0,     0,   441,   704,     0,   705,   442,   443,   444,
     706,     0,     0,     0,     0,   446,   447,     0,   448,   449,
       0,     0,   707,     0,     0,     0,   708,   709,     0,     0,
       0,     0,   710,   711,     0,     0,   712,   713,     0,   714,
     715,   138,     0,   613,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,     0,   614,     0,   146,   147,
     148,   149,   150,   615,   152,     0,   153,     0,     0,   616,
     154,   617,   618,   619,   155,   620,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,   621,   622,
     163,     0,   164,   623,   624,   166,     0,   167,   168,   169,
     625,   171,     0,   626,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   627,   184,     0,
     185,   628,   629,   186,     0,     0,   187,   630,   631,     0,
     632,   633,     0,   188,   189,   190,   634,   635,   636,     0,
       0,     0,     0,   637,   193,   638,     0,     0,   639,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,   216,
     640,     0,   217,   218,   219,   641,   642,   220,   221,     0,
     222,   223,   224,   643,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   644,   231,   645,   233,
       0,   234,     0,   646,     0,   235,   236,     0,   237,   647,
       0,   238,   239,     0,     0,     0,   648,   241,   242,   243,
     649,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,   650,   248,   249,   651,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
     256,   257,     0,     0,   258,     0,   652,   259,   260,     0,
       0,     0,     0,     0,   653,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,   654,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,   655,   282,   283,   284,
     285,   656,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   657,   293,     0,     0,   658,   295,   659,   296,     0,
     297,   660,   661,   662,   663,   664,   302,   303,   304,   305,
       0,   665,   306,   307,     0,     0,   308,   309,   310,   311,
     666,   667,   668,   312,   313,     0,   669,   670,     0,   314,
     315,   671,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,   672,   325,   326,   327,   328,   329,   673,   331,   332,
     333,   674,   675,   336,   676,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   677,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,   678,   679,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,   680,   368,   369,   370,   371,
     372,   681,   374,   375,   376,     0,   682,   378,     0,     0,
       0,   379,   380,   381,   382,     0,     0,     0,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
     683,   684,   400,   401,     0,   402,   685,   404,   405,   406,
     686,   687,   407,   408,   409,   410,   688,   411,   412,     0,
       0,   413,   414,   415,     0,   689,   416,   417,     0,   690,
     691,   692,   693,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   694,   695,   696,   426,   427,   428,   697,   429,
     430,   698,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   699,   439,     0,     0,
     700,   701,   702,   703,   440,     0,     0,   441,   704,     0,
     705,   442,   443,   444,   706,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,     0,   707,     0,     0,     0,
     708,   709,     0,     0,     0,     0,   710,   711,     0,     0,
     712,   713,     0,   714,   715,   138,     0,   613,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
     614,     0,   146,   147,   148,   149,   150,   615,   152,     0,
     153,     0,     0,   616,   154,   617,   618,   619,   155,   620,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,   621,   622,   163,     0,   164,   623,   624,   166,
       0,   167,   168,   169,   625,   171,     0,   626,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   627,   184,     0,   185,   628,   629,   186,     0,     0,
     187,   630,   631,     0,   632,   633,     0,   188,   189,   190,
     634,   635,   636,     0,     0,     0,     0,   637,   193,   638,
       0,     0,   639,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,   640,     0,   217,   218,   219,   641,
     642,   220,   221,     0,   222,   223,   224,   643,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     644,   231,   645,   233,     0,   234,     0,   646,     0,   235,
     236,     0,   237,   647,     0,   238,   239,     0,     0,     0,
     648,   241,   242,   243,   649,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,   650,   248,   249,   651,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
     652,   259,   260,     0,     0,     0,     0,     0,   653,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,   654,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
     655,   282,   283,   284,   285,   656,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   657,   293,     0,     0,   658,
     295,   659,   296,     0,   297,   660,   661,   662,   663,   664,
     302,   303,   304,   305,     0,   665,   306,   307,     0,     0,
     308,   309,   310,   311,   666,   667,   668,   312,   313,     0,
     669,   670,     0,   314,   315,   671,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,   672,   325,   326,   327,   328,
     329,   673,   331,   332,   333,   674,   675,   336,   676,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   677,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,   678,   679,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,   680,
     368,   369,   370,   371,   372,   681,   374,   375,   376,     0,
     682,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,   683,   684,   400,   401,     0,   402,
     685,   404,   405,   406,   686,   687,   407,   408,   409,   410,
     688,   411,   412,     0,     0,   413,   414,   415,     0,   689,
     416,   417,     0,   690,   691,   692,   693,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   694,   695,   696,   426,
     427,   428,   697,   429,   430,   698,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     699,   439,     0,     0,   700,   701,   702,   703,   440,     0,
       0,   441,   704,     0,   705,   442,   443,   444,   706,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,     0,
     707,     0,     0,     0,   708,   709,     0,     0,     0,     0,
     710,  1033,     0,     0,   712,   713,     0,   714,   715,   138,
       0,   613,   140,   141,   142,   143,  1572,     0,     0,     0,
       0,  1573,     0,     0,   614,     0,   146,   147,   148,   149,
     150,   615,   152,     0,   153,     0,     0,   616,   154,   617,
     618,   619,   155,   620,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,   621,   622,   163,     0,
     164,   623,   624,   166,     0,   167,   168,   169,   625,   171,
       0,   626,   173,     0,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   627,   184,     0,   185,   628,
     629,   186,     0,     0,   187,   630,   631,     0,   632,   633,
       0,   188,   189,   190,   634,   635,   636,     0,     0,     0,
       0,   637,   193,   638,     0,     0,   639,   194,     0,   195,
       0,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,     0,   201,     0,     0,   202,   203,   204,     0,     0,
       0,   205,     0,   206,   207,     0,   208,   209,   210,     0,
       0,   211,     0,   212,   213,   214,   215,   216,   640,     0,
     217,   218,   219,   641,   642,   220,   221,     0,   222,   223,
     224,   643,     0,   225,     0,     0,     0,   226,   227,     0,
     228,     0,   229,     0,   644,   231,   645,   233,     0,   234,
       0,   646,     0,   235,   236,     0,   237,   647,     0,   238,
     239,     0,     0,     0,   648,   241,   242,   243,   649,     0,
     244,   245,     0,     0,   246,     0,   247,     0,     0,   650,
     248,   249,   651,     0,     0,   250,     0,   251,   252,     0,
     253,   254,     0,     0,     0,   255,     0,     0,   256,   257,
       0,     0,   258,     0,   652,   259,   260,     0,     0,     0,
       0,     0,   653,   262,     0,   263,     0,   264,     0,   265,
     266,     0,     0,   654,     0,     0,     0,     0,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,     0,   280,   281,   655,   282,   283,   284,   285,   656,
     286,   287,   288,     0,     0,     0,   289,   290,   291,   657,
     293,     0,     0,   658,   295,   659,   296,     0,   297,   660,
     661,   662,   663,   664,   302,   303,   304,   305,     0,   665,
     306,   307,     0,     0,   308,   309,   310,   311,   666,     0,
     668,   312,   313,     0,   669,   670,     0,   314,   315,   671,
       0,   317,   318,   319,     0,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,   322,   323,   324,   672,
     325,   326,   327,   328,   329,   673,   331,   332,   333,   674,
     675,   336,   676,     0,   337,   338,   339,     0,   340,     0,
     341,   342,   343,   344,     0,   677,   346,   347,     0,     0,
     348,     0,     0,     0,   349,   350,   351,   352,   353,     0,
       0,   354,   355,   356,     0,   357,   358,     0,   359,   360,
     361,   678,   679,   362,     0,   363,   364,   365,     0,   366,
     367,     0,     0,   680,   368,   369,   370,   371,   372,   681,
     374,   375,   376,     0,   682,   378,     0,     0,     0,   379,
     380,   381,   382,     0,     0,     0,   383,     0,     0,     0,
     384,   385,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,     0,     0,     0,     0,   393,   394,     0,   395,
       0,     0,   396,     0,     0,   397,   398,   399,   683,   684,
     400,   401,     0,   402,   685,   404,   405,   406,   686,   687,
     407,   408,   409,   410,   688,   411,   412,     0,     0,   413,
     414,   415,     0,   689,   416,   417,     0,   690,   691,   692,
     693,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     694,   695,   696,   426,   427,   428,   697,   429,   430,   698,
     431,   432,     0,   433,   434,     0,     0,   435,     0,     0,
     436,     0,   437,     0,   699,   439,     0,     0,   700,   701,
     702,   703,   440,     0,     0,   441,   704,     0,   705,   442,
     443,   444,   706,     0,     0,     0,     0,   446,   447,     0,
     448,   449,     0,     0,   707,     0,     0,     0,   708,   709,
       0,     0,     0,     0,   710,   711,     0,     0,   712,   713,
       0,   714,   715,   138,     0,   613,   140,   141,   142,   143,
       0,     0,     0,     0,     0,   144,     0,     0,   614,     0,
     146,   147,   148,   149,   150,   615,   152,     0,   153,     0,
       0,   616,   154,   617,   618,   619,   155,   620,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
     621,   622,   163,     0,   164,   623,   624,   166,     0,   167,
     168,   169,   625,   171,     0,   626,   173,     0,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   627,
     184,     0,   185,   628,   629,   186,     0,     0,   187,   630,
     631,     0,   632,   633,     0,   188,   189,   190,   634,   635,
     636,     0,     0,     0,     0,   637,   193,   638,     0,     0,
     639,   194,     0,   195,     0,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,     0,   201,     0,     0,   202,
     203,   204,     0,     0,     0,   205,     0,   206,   207,     0,
     208,   209,   210,     0,     0,   211,     0,   212,   213,   214,
     215,   216,   640,     0,   217,   218,   219,   641,   642,   220,
     221,     0,   222,   223,   224,   643,     0,   225,     0,     0,
       0,   226,   227,     0,   228,     0,   229,     0,   644,   231,
     645,   233,     0,   234,     0,   646,     0,   235,   236,     0,
     237,   647,     0,   238,   239,     0,     0,     0,   648,   241,
     242,   243,   649,     0,   244,   245,     0,     0,   246,     0,
     247,     0,     0,   650,   248,   249,  2409,     0,     0,   250,
       0,   251,   252,     0,   253,   254,     0,     0,     0,   255,
       0,     0,   256,   257,     0,     0,   258,     0,   652,   259,
     260,     0,     0,     0,     0,     0,   653,   262,     0,   263,
       0,   264,     0,   265,   266,     0,     0,   654,     0,     0,
       0,     0,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,     0,   280,   281,   655,   282,
     283,   284,   285,   656,   286,   287,   288,     0,     0,     0,
     289,   290,   291,   657,   293,     0,     0,   658,   295,   659,
     296,     0,   297,   660,   661,   662,   663,   664,   302,   303,
     304,   305,     0,   665,   306,   307,     0,     0,   308,   309,
     310,   311,   666,   667,   668,   312,   313,     0,   669,   670,
       0,   314,   315,   671,     0,   317,   318,   319,     0,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
     322,   323,   324,   672,   325,   326,   327,   328,   329,   673,
     331,   332,   333,   674,   675,   336,   676,     0,   337,   338,
     339,     0,   340,     0,   341,   342,   343,   344,     0,   677,
     346,   347,     0,     0,   348,     0,     0,     0,   349,   350,
     351,   352,   353,     0,     0,   354,   355,   356,     0,   357,
     358,     0,   359,   360,   361,   678,   679,   362,     0,   363,
     364,   365,     0,   366,   367,     0,     0,   680,   368,   369,
     370,   371,   372,   681,   374,   375,   376,     0,   682,   378,
       0,     0,     0,   379,   380,   381,   382,     0,     0,     0,
     383,     0,     0,     0,   384,   385,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,     0,     0,     0,     0,
     393,   394,     0,   395,     0,     0,   396,     0,     0,   397,
     398,   399,   683,   684,   400,   401,     0,   402,   685,   404,
     405,   406,   686,   687,   407,   408,   409,   410,   688,   411,
     412,     0,     0,   413,   414,   415,     0,   689,   416,   417,
       0,   690,   691,   692,   693,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   694,   695,   696,   426,   427,   428,
     697,   429,   430,   698,   431,   432,     0,   433,   434,     0,
       0,   435,     0,     0,   436,     0,   437,     0,   699,   439,
       0,     0,   700,   701,   702,   703,   440,     0,     0,   441,
     704,     0,   705,   442,   443,   444,   706,     0,     0,     0,
       0,   446,   447,     0,   448,   449,     0,     0,   707,     0,
       0,     0,   708,   709,     0,     0,     0,     0,   710,   711,
       0,     0,   712,   713,     0,   714,   715,   138,     0,   613,
     140,   141,   142,   143,     0,     0,     0,     0,     0,   144,
       0,     0,   614,     0,   146,   147,   148,   149,   150,   615,
     152,     0,   153,     0,     0,   616,   154,   617,   618,   619,
     155,   620,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,   621,   622,   163,     0,   164,   623,
     624,   166,     0,   167,   168,   169,   625,   171,     0,   626,
     173,     0,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,     0,   627,   184,     0,   185,   628,   629,   186,
       0,     0,   187,   630,   631,     0,   632,   633,     0,   188,
     189,   190,   634,   635,   636,     0,     0,     0,     0,   637,
     193,   638,     0,     0,   639,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
     201,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,   206,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,   216,   640,     0,   217,   218,
     219,   641,   642,   220,   221,     0,   222,   223,   224,   643,
       0,   225,     0,     0,     0,   226,   227,     0,   228,     0,
     229,     0,   644,   231,   645,   233,     0,   234,     0,   646,
       0,   235,   236,     0,   237,   647,     0,   238,   239,     0,
       0,     0,   648,   241,   242,   243,   649,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,   650,   248,   249,
    2455,     0,     0,   250,     0,   251,   252,     0,   253,   254,
       0,     0,     0,   255,     0,     0,   256,   257,     0,     0,
     258,     0,   652,   259,   260,     0,     0,     0,     0,     0,
     653,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,   654,     0,     0,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,   655,   282,   283,   284,   285,   656,   286,   287,
     288,     0,     0,     0,   289,   290,   291,   657,   293,     0,
       0,   658,   295,   659,   296,     0,   297,   660,   661,   662,
     663,   664,   302,   303,   304,   305,     0,   665,   306,   307,
       0,     0,   308,   309,   310,   311,   666,   667,   668,   312,
     313,     0,   669,   670,     0,   314,   315,   671,     0,   317,
     318,   319,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,   322,   323,   324,   672,   325,   326,
     327,   328,   329,   673,   331,   332,   333,   674,   675,   336,
     676,     0,   337,   338,   339,     0,   340,     0,   341,   342,
     343,   344,     0,   677,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,   358,     0,   359,   360,   361,   678,
     679,   362,     0,   363,   364,   365,     0,   366,   367,     0,
       0,   680,   368,   369,   370,   371,   372,   681,   374,   375,
     376,     0,   682,   378,     0,     0,     0,   379,   380,   381,
     382,     0,     0,     0,   383,     0,     0,     0,   384,   385,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
       0,     0,     0,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,   398,   399,   683,   684,   400,   401,
       0,   402,   685,   404,   405,   406,   686,   687,   407,   408,
     409,   410,   688,   411,   412,     0,     0,   413,   414,   415,
       0,   689,   416,   417,     0,   690,   691,   692,   693,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   694,   695,
     696,   426,   427,   428,   697,   429,   430,   698,   431,   432,
       0,   433,   434,     0,     0,   435,     0,     0,   436,     0,
     437,     0,   699,   439,     0,     0,   700,   701,   702,   703,
     440,     0,     0,   441,   704,     0,   705,   442,   443,   444,
     706,     0,     0,     0,     0,   446,   447,     0,   448,   449,
       0,     0,   707,     0,     0,     0,   708,   709,     0,     0,
       0,     0,   710,   711,     0,     0,   712,   713,     0,   714,
     715,   138,     0,   613,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,     0,   614,     0,   146,   147,
     148,   149,   150,   615,   152,     0,   153,     0,     0,   616,
     154,   617,   618,   619,   155,   620,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,   621,   622,
     163,     0,   164,   623,   624,   166,     0,   167,   168,   169,
     625,   171,     0,   626,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   627,   184,     0,
     185,   628,   629,   186,     0,     0,   187,   630,   631,     0,
     632,   633,     0,   188,   189,   190,   634,   635,   636,     0,
       0,     0,     0,   637,   193,   638,     0,     0,  3110,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,   216,
     640,     0,   217,   218,   219,   641,   642,   220,   221,     0,
     222,   223,   224,   643,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   644,   231,   645,   233,
       0,   234,     0,   646,     0,   235,   236,     0,   237,   647,
       0,   238,   239,     0,     0,     0,   648,   241,   242,   243,
     649,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,   650,   248,   249,   651,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
     256,   257,     0,     0,   258,     0,   652,   259,   260,     0,
       0,     0,     0,     0,   653,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,   654,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,   655,   282,   283,   284,
     285,   656,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   657,   293,     0,     0,   658,   295,   659,   296,     0,
     297,   660,   661,   662,   663,   664,   302,   303,   304,   305,
       0,   665,   306,   307,     0,     0,   308,   309,   310,   311,
     666,   667,   668,   312,   313,     0,   669,   670,     0,   314,
     315,   671,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,   672,   325,   326,   327,   328,   329,   673,   331,   332,
     333,   674,   675,   336,   676,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   677,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,   678,   679,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,   680,   368,   369,   370,   371,
     372,   681,   374,   375,   376,     0,   682,   378,     0,     0,
       0,   379,   380,   381,   382,     0,     0,     0,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
     683,   684,   400,   401,     0,   402,   685,   404,   405,   406,
     686,   687,   407,   408,   409,   410,   688,   411,   412,     0,
       0,   413,   414,   415,     0,   689,   416,   417,     0,   690,
     691,   692,   693,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   694,   695,   696,   426,   427,   428,   697,   429,
     430,   698,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   699,   439,     0,     0,
     700,   701,   702,   703,   440,     0,     0,   441,   704,     0,
     705,   442,   443,   444,   706,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,     0,   707,     0,     0,     0,
     708,   709,     0,     0,     0,     0,   710,   711,     0,     0,
     712,   713,     0,   714,   715,   138,     0,   613,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
     614,     0,   146,   147,   148,   149,   150,   615,   152,     0,
     153,     0,     0,   616,   154,   617,   618,   619,   155,   620,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,   621,   622,   163,     0,   164,   623,   624,   166,
       0,   167,   168,   169,   625,   171,     0,   626,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   627,   184,     0,   185,   628,   629,   186,     0,     0,
     187,   630,   631,     0,   632,   633,     0,   188,   189,   190,
     634,   635,   636,     0,     0,     0,     0,   637,   193,   638,
       0,     0,   639,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,   640,     0,   217,   218,   219,   641,
     642,   220,   221,     0,   222,   223,   224,   643,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     644,   231,   645,   233,     0,   234,     0,   646,     0,   235,
     236,     0,   237,   647,     0,   238,   239,     0,     0,     0,
     648,   241,   242,   243,   649,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,   650,   248,   249,   651,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
     652,   259,   260,     0,     0,     0,     0,     0,   653,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,   654,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
     655,   282,   283,   284,   285,   656,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   657,   293,     0,     0,   658,
     295,   659,   296,     0,   297,   660,   661,   662,   663,   664,
     302,   303,   304,   305,     0,   665,   306,   307,     0,     0,
     308,   309,   310,   311,   666,     0,   668,   312,   313,     0,
     669,   670,     0,   314,   315,   671,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,   672,   325,   326,   327,   328,
     329,   673,   331,   332,   333,   674,   675,   336,   676,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   677,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,   678,   679,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,   680,
     368,   369,   370,   371,   372,   681,   374,   375,   376,     0,
     682,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,   683,   684,   400,   401,     0,   402,
     685,   404,   405,   406,   686,   687,   407,   408,   409,   410,
     688,   411,   412,     0,     0,   413,   414,   415,     0,   689,
     416,   417,     0,   690,   691,   692,   693,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   694,   695,   696,   426,
     427,   428,   697,   429,   430,   698,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     699,   439,     0,     0,   700,   701,   702,   703,   440,     0,
       0,   441,   704,     0,   705,   442,   443,   444,   706,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,     0,
     707,     0,     0,     0,   708,   709,     0,     0,     0,     0,
     710,   711,     0,     0,   712,   713,     0,   714,   715,   138,
       0,   613,   140,   141,   142,   143,     0,     0,     0,     0,
       0,   144,     0,     0,   614,     0,   146,   147,   148,   149,
     150,   615,   152,     0,   153,     0,     0,   616,   154,   617,
     618,   619,   155,   620,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,   621,   622,   163,     0,
     164,   623,   624,   166,     0,   167,   168,   169,   625,   171,
       0,   626,   173,     0,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   627,   184,     0,   185,   628,
     629,   186,     0,     0,   187,   630,   631,     0,   632,   633,
       0,   188,   189,   190,   634,   635,   636,     0,     0,     0,
       0,   637,   193,   638,     0,     0,   639,   194,     0,   195,
       0,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,     0,   201,     0,     0,   202,   203,   204,     0,     0,
       0,   205,     0,   206,   207,     0,   208,   209,   210,     0,
       0,   211,     0,   212,   213,   214,   215,   216,   640,     0,
     217,   218,   219,   641,   642,   220,   221,     0,   222,   223,
     224,   643,     0,   225,     0,     0,     0,   226,   227,     0,
     228,     0,   229,     0,   644,   231,   645,   233,     0,   234,
       0,   646,     0,   235,   236,     0,   237,   647,     0,   238,
     239,     0,     0,     0,   648,   241,   242,   243,   649,     0,
     244,   245,     0,     0,   246,     0,   247,     0,     0,   650,
     248,   249,  1587,     0,     0,   250,     0,   251,   252,     0,
     253,   254,     0,     0,     0,   255,     0,     0,   256,   257,
       0,     0,   258,     0,   652,   259,   260,     0,     0,     0,
       0,     0,   653,   262,     0,   263,     0,   264,     0,   265,
     266,     0,     0,   654,     0,     0,     0,     0,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,     0,   280,   281,   655,   282,   283,   284,   285,   656,
     286,   287,   288,     0,     0,     0,   289,   290,   291,   657,
     293,     0,     0,   658,   295,   659,   296,     0,   297,   660,
     661,   662,   663,   664,   302,   303,   304,   305,     0,   665,
     306,   307,     0,     0,   308,   309,   310,   311,   666,     0,
     668,   312,   313,     0,   669,   670,     0,   314,   315,   671,
       0,   317,   318,   319,     0,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,   322,   323,   324,   672,
     325,   326,   327,   328,   329,   673,   331,   332,   333,   674,
     675,   336,   676,     0,   337,   338,   339,     0,   340,     0,
     341,   342,   343,   344,     0,   677,   346,   347,     0,     0,
     348,     0,     0,     0,   349,   350,   351,   352,   353,     0,
       0,   354,   355,   356,     0,   357,   358,     0,   359,   360,
     361,   678,   679,   362,     0,   363,   364,   365,     0,   366,
     367,     0,     0,   680,   368,   369,   370,   371,   372,   681,
     374,   375,   376,     0,   682,   378,     0,     0,     0,   379,
     380,   381,   382,     0,     0,     0,   383,     0,     0,     0,
     384,   385,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,     0,     0,     0,     0,   393,   394,     0,   395,
       0,     0,   396,     0,     0,   397,   398,   399,   683,   684,
     400,   401,     0,   402,   685,   404,   405,   406,   686,   687,
     407,   408,   409,   410,   688,   411,   412,     0,     0,   413,
     414,   415,     0,   689,   416,   417,     0,   690,   691,   692,
     693,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     694,   695,   696,   426,   427,   428,   697,   429,   430,   698,
     431,   432,     0,   433,   434,     0,     0,   435,     0,     0,
     436,     0,   437,     0,   699,   439,     0,     0,   700,   701,
     702,   703,   440,     0,     0,   441,   704,     0,   705,   442,
     443,   444,   706,     0,     0,     0,     0,   446,   447,     0,
     448,   449,     0,     0,   707,     0,     0,     0,   708,   709,
       0,     0,     0,     0,   710,   711,     0,     0,   712,   713,
       0,   714,   715,   138,     0,   613,   140,   141,   142,   143,
       0,     0,     0,     0,     0,   144,     0,     0,   614,     0,
     146,   147,   148,   149,   150,   615,   152,     0,   153,     0,
       0,   616,   154,   617,   618,   619,   155,   620,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
     621,   622,   163,     0,   164,   623,   624,   166,     0,   167,
     168,   169,   625,   171,     0,   626,   173,     0,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   627,
     184,     0,   185,   628,   629,   186,     0,     0,   187,   630,
     631,     0,   632,   633,     0,   188,   189,   190,   634,   635,
     636,     0,     0,     0,     0,   637,   193,   638,     0,     0,
     639,   194,     0,   195,     0,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,     0,   201,     0,     0,   202,
     203,   204,     0,     0,     0,   205,     0,   206,   207,     0,
     208,   209,   210,     0,     0,   211,     0,   212,   213,   214,
     215,   216,   640,     0,   217,   218,   219,   641,   642,   220,
     221,     0,   222,   223,   224,   643,     0,   225,     0,     0,
       0,   226,   227,     0,   228,     0,   229,     0,   644,   231,
     645,   233,     0,   234,     0,   646,     0,   235,   236,     0,
     237,   647,     0,   238,   239,     0,     0,     0,   648,   241,
     242,   243,   649,     0,   244,   245,     0,     0,   246,     0,
     247,     0,     0,   650,   248,   249,  1589,     0,     0,   250,
       0,   251,   252,     0,   253,   254,     0,     0,     0,   255,
       0,     0,   256,   257,     0,     0,   258,     0,   652,   259,
     260,     0,     0,     0,     0,     0,   653,   262,     0,   263,
       0,   264,     0,   265,   266,     0,     0,   654,     0,     0,
       0,     0,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,     0,   280,   281,   655,   282,
     283,   284,   285,   656,   286,   287,   288,     0,     0,     0,
     289,   290,   291,   657,   293,     0,     0,   658,   295,   659,
     296,     0,   297,   660,   661,   662,   663,   664,   302,   303,
     304,   305,     0,   665,   306,   307,     0,     0,   308,   309,
     310,   311,   666,     0,   668,   312,   313,     0,   669,   670,
       0,   314,   315,   671,     0,   317,   318,   319,     0,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
     322,   323,   324,   672,   325,   326,   327,   328,   329,   673,
     331,   332,   333,   674,   675,   336,   676,     0,   337,   338,
     339,     0,   340,     0,   341,   342,   343,   344,     0,   677,
     346,   347,     0,     0,   348,     0,     0,     0,   349,   350,
     351,   352,   353,     0,     0,   354,   355,   356,     0,   357,
     358,     0,   359,   360,   361,   678,   679,   362,     0,   363,
     364,   365,     0,   366,   367,     0,     0,   680,   368,   369,
     370,   371,   372,   681,   374,   375,   376,     0,   682,   378,
       0,     0,     0,   379,   380,   381,   382,     0,     0,     0,
     383,     0,     0,     0,   384,   385,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,     0,     0,     0,     0,
     393,   394,     0,   395,     0,     0,   396,     0,     0,   397,
     398,   399,   683,   684,   400,   401,     0,   402,   685,   404,
     405,   406,   686,   687,   407,   408,   409,   410,   688,   411,
     412,     0,     0,   413,   414,   415,     0,   689,   416,   417,
       0,   690,   691,   692,   693,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   694,   695,   696,   426,   427,   428,
     697,   429,   430,   698,   431,   432,     0,   433,   434,     0,
       0,   435,     0,     0,   436,     0,   437,     0,   699,   439,
       0,     0,   700,   701,   702,   703,   440,     0,     0,   441,
     704,     0,   705,   442,   443,   444,   706,     0,     0,     0,
       0,   446,   447,     0,   448,   449,     0,     0,   707,     0,
       0,     0,   708,   709,     0,     0,     0,     0,   710,   711,
       0,     0,   712,   713,     0,   714,   715,   138,     0,   613,
     140,   141,   142,   143,     0,     0,     0,     0,     0,   144,
       0,     0,   614,     0,   146,   147,   148,   149,   150,   615,
     152,     0,   153,     0,     0,   616,   154,   617,   618,   619,
     155,   620,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,   621,   622,   163,     0,   164,   623,
     624,   166,     0,   167,   168,   169,   625,   171,     0,   626,
     173,     0,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,     0,   627,   184,     0,   185,   628,   629,   186,
       0,     0,   187,   630,   631,     0,   632,   633,     0,   188,
     189,   190,   634,   635,   636,     0,     0,     0,     0,   637,
     193,   638,     0,     0,   639,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
     201,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,   206,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,   216,   640,     0,   217,   218,
     219,   641,   642,   220,   221,     0,   222,   223,   224,   643,
       0,   225,     0,     0,     0,   226,   227,     0,   228,     0,
     229,     0,   644,   231,   645,   233,     0,   234,     0,   646,
       0,   235,   236,     0,   237,   647,     0,   238,   239,     0,
       0,     0,   648,   241,   242,   243,   649,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,   650,   248,   249,
     651,     0,     0,   250,     0,   251,   252,     0,   253,   254,
       0,     0,     0,   255,     0,     0,   256,   257,     0,     0,
     258,     0,   652,   259,   260,     0,     0,     0,     0,     0,
     653,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,   654,     0,     0,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,   655,   282,   283,   284,   285,   656,   286,   287,
    3887,     0,     0,     0,   289,   290,   291,   657,   293,     0,
       0,   658,   295,   659,   296,     0,   297,   660,   661,   662,
     663,   664,   302,   303,   304,   305,     0,   665,   306,   307,
       0,     0,   308,   309,   310,   311,   666,     0,   668,   312,
     313,     0,   669,   670,     0,   314,   315,   671,     0,   317,
     318,   319,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,   322,   323,   324,   672,   325,   326,
     327,   328,   329,   673,   331,   332,   333,   674,   675,   336,
     676,     0,   337,   338,   339,     0,   340,     0,   341,   342,
     343,   344,     0,   677,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,   358,     0,   359,   360,   361,   678,
     679,   362,     0,   363,   364,   365,     0,   366,   367,     0,
       0,   680,   368,   369,   370,   371,   372,   681,   374,   375,
     376,     0,   682,   378,     0,     0,     0,   379,   380,   381,
     382,     0,     0,     0,   383,     0,     0,     0,   384,   385,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
       0,     0,     0,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,   398,   399,   683,   684,   400,   401,
       0,   402,   685,   404,   405,   406,   686,   687,   407,   408,
     409,   410,   688,   411,   412,     0,     0,   413,   414,   415,
       0,   689,   416,   417,     0,   690,   691,   692,   693,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   694,   695,
     696,   426,   427,   428,   697,   429,   430,   698,   431,   432,
       0,   433,   434,     0,     0,   435,     0,     0,   436,     0,
     437,     0,   699,   439,     0,     0,   700,   701,   702,   703,
     440,     0,     0,   441,   704,     0,   705,   442,   443,   444,
     706,     0,     0,     0,     0,   446,   447,     0,   448,   449,
       0,     0,   707,     0,     0,     0,   708,   709,     0,     0,
       0,     0,   710,   711,     0,     0,   712,   713,     0,   714,
     715,   138,     0,   139,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,     0,   145,     0,   146,   147,
     148,   149,   150,   151,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,     0,     0,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,     0,   172,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,  2255,   183,   184,     0,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,   193,     0,     0,     0,     0,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,   216,
       0,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,     0,     0,   225,     0,     0,     0,   226,
     227,     0,   228,  2256,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,   235,   236,     0,   237,     0,
       0,   238,   239,     0,     0,     0,   240,   241,   242,   243,
       0,     0,   244,   245,  1368,     0,   246,     0,   247,     0,
       0,     0,   248,   249,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,  1369,     0,
     256,   257,     0,     0,   258,     0,     0,   259,   260,     0,
    2763,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,   312,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,   327,   328,  2764,   330,   331,   332,
     333,   334,   335,   336,     0,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,     0,     0,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,     0,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,   377,   378,  -395,     0,
       0,   379,   380,   381,   382,     0,     0,     0,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,  2258,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
       0,     0,   400,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,     0,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,   425,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,     0,   450,     0,   138,     0,
     139,   140,   141,   142,   143,     0,     0,     0,     0,     0,
     144,     0,     0,   145,  2322,   146,   147,   148,   149,   150,
     151,   152,     0,   153,     0,     0,     0,   154,     0,     0,
       0,   155,     0,     0,   156,   157,   158,     0,   159,     0,
     160,   161,     0,     0,   162,     0,     0,   163,     0,   164,
     165,     0,   166,     0,   167,   168,   169,   170,   171,     0,
     172,   173,     0,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,  2255,   183,   184,     0,   185,     0,     0,
     186,     0,     0,   187,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,     0,
     192,   193,     0,     0,     0,     0,   194,     0,   195,     0,
       0,     0,   196,     0,   197,   198,   199,   200,     0,     0,
       0,   201,     0,     0,   202,   203,   204,     0,     0,     0,
     205,     0,   206,   207,     0,   208,   209,   210,     0,     0,
     211,     0,   212,   213,   214,   215,   216,     0,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
       0,     0,   225,     0,     0,     0,   226,   227,     0,   228,
    2256,   229,     0,   230,   231,   232,   233,     0,   234,     0,
       0,     0,   235,   236,     0,   237,     0,     0,   238,   239,
       0,     0,     0,   240,   241,   242,   243,     0,     0,   244,
     245,  1368,     0,   246,     0,   247,     0,     0,     0,   248,
     249,     0,     0,     0,   250,     0,   251,   252,     0,   253,
     254,     0,     0,     0,   255,  1369,     0,   256,   257,     0,
       0,   258,     0,     0,   259,   260,     0,     0,     0,     0,
       0,   261,   262,     0,   263,     0,   264,     0,   265,   266,
       0,     0,     0,     0,     0,     0,     0,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
       0,   280,   281,     0,   282,   283,   284,   285,     0,   286,
     287,   288,     0,     0,     0,   289,   290,   291,   292,   293,
       0,     0,   294,   295,     0,   296,     0,   297,     0,   298,
     299,   300,   301,   302,   303,   304,   305,     0,     0,   306,
     307,     0,     0,   308,   309,   310,   311,     0,     0,     0,
     312,   313,     0,     0,     0,     0,   314,   315,   316,     0,
     317,   318,   319,     0,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,   322,   323,   324,     0,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,     0,     0,   337,   338,   339,     0,   340,     0,   341,
     342,   343,   344,     0,   345,   346,   347,     0,     0,   348,
       0,     0,     0,   349,   350,   351,   352,   353,     0,     0,
     354,   355,   356,     0,   357,   358,     0,   359,   360,   361,
       0,     0,   362,     0,   363,   364,   365,     0,   366,   367,
       0,     0,     0,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,   377,   378,     0,     0,     0,   379,   380,
     381,   382,     0,     0,     0,   383,     0,     0,     0,   384,
     385,   386,   387,     0,   388,   389,   390,   391,   392,  2258,
       0,     0,     0,     0,     0,   393,   394,     0,   395,     0,
       0,   396,     0,     0,   397,   398,   399,     0,     0,   400,
     401,     0,   402,   403,   404,   405,   406,     0,     0,   407,
     408,   409,   410,     0,   411,   412,     0,     0,   413,   414,
     415,     0,     0,   416,   417,     0,   418,   419,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,     0,
       0,   425,   426,   427,   428,     0,   429,   430,     0,   431,
     432,     0,   433,   434,     0,     0,   435,     0,     0,   436,
       0,   437,     0,   438,   439,     0,     0,     0,     0,     0,
       0,   440,     0,     0,   441,     0,     0,     0,   442,   443,
     444,   445,     0,     0,     0,     0,   446,   447,     0,   448,
     449,     0,     0,   450,     0,   138,     0,   139,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
     145,  2322,   146,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,     0,   172,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,   193,     0,
       0,     0,     0,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,     0,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,     0,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,   235,
     236,     0,   237,     0,     0,   238,   239,     0,     0,     0,
     240,   241,   242,   243,     0,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,   249,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
       0,   259,   260,     0,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,   312,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,     0,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,     0,     0,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,     0,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
     377,   378,  2142,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,     0,     0,   400,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,     0,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,   425,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,     0,
     450,     0,   138,     0,   139,   140,   141,   142,   143,     0,
       0,     0,  2537,     0,   144,     0,     0,   145,   715,   146,
     147,   148,   149,   150,   151,   152,     0,   153,     0,     0,
       0,   154,     0,     0,     0,   155,     0,     0,   156,   157,
     158,     0,   159,     0,   160,   161,     0,     0,   162,     0,
       0,   163,     0,   164,   165,     0,   166,     0,   167,   168,
     169,   170,   171,     0,   172,   173,     0,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
       0,   185,     0,     0,   186,     0,     0,   187,     0,     0,
       0,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,     0,   192,   193,     0,     0,     0,     0,
     194,     0,   195,     0,     0,     0,   196,     0,   197,   198,
     199,   200,     0,     0,     0,   201,     0,     0,   202,   203,
     204,     0,     0,     0,   205,     0,   206,   207,     0,   208,
     209,   210,     0,     0,   211,     0,   212,   213,   214,   215,
     216,     0,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,     0,     0,   225,     0,     0,     0,
     226,   227,     0,   228,     0,   229,     0,   230,   231,   232,
     233,     0,   234,     0,     0,     0,   235,   236,     0,   237,
       0,     0,   238,   239,     0,     0,     0,   240,   241,   242,
     243,     0,     0,   244,   245,     0,     0,   246,     0,   247,
       0,     0,     0,   248,   249,     0,     0,     0,   250,     0,
     251,   252,     0,   253,   254,     0,     0,     0,   255,     0,
       0,   256,   257,     0,     0,   258,     0,     0,   259,   260,
       0,     0,     0,     0,     0,   261,   262,     0,   263,     0,
     264,     0,   265,   266,     0,     0,     0,     0,     0,     0,
       0,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,     0,   280,   281,     0,   282,   283,
     284,   285,     0,   286,   287,   288,     0,     0,     0,   289,
     290,   291,   292,   293,     0,     0,   294,   295,     0,   296,
       0,   297,     0,   298,   299,   300,   301,   302,   303,   304,
     305,     0,     0,   306,   307,     0,     0,   308,   309,   310,
     311,     0,     0,     0,   312,   313,     0,     0,     0,     0,
     314,   315,   316,     0,   317,   318,   319,     0,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,   322,
     323,   324,     0,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,     0,     0,   337,   338,   339,
       0,   340,     0,   341,   342,   343,   344,     0,   345,   346,
     347,     0,     0,   348,     0,     0,     0,   349,   350,   351,
     352,   353,     0,     0,   354,   355,   356,     0,   357,   358,
       0,   359,   360,   361,     0,     0,   362,     0,   363,   364,
     365,     0,   366,   367,     0,     0,     0,   368,   369,   370,
     371,   372,   373,   374,   375,   376,     0,   377,   378,     0,
       0,     0,   379,   380,   381,   382,     0,     0,     0,   383,
       0,     0,     0,   384,   385,   386,   387,     0,   388,   389,
     390,   391,   392,     0,     0,     0,     0,     0,     0,   393,
     394,     0,   395,     0,     0,   396,     0,     0,   397,   398,
     399,     0,     0,   400,   401,     0,   402,   403,   404,   405,
     406,     0,     0,   407,   408,   409,   410,     0,   411,   412,
       0,     0,   413,   414,   415,     0,     0,   416,   417,     0,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,     0,     0,   425,   426,   427,   428,     0,
     429,   430,     0,   431,   432,     0,   433,   434,     0,     0,
     435,     0,     0,   436,     0,   437,     0,   438,   439,     0,
       0,     0,     0,     0,     0,   440,     0,     0,   441,     0,
       0,     0,   442,   443,   444,   445,     0,     0,     0,     0,
     446,   447,     0,   448,   449,     0,     0,   450,     0,     0,
       0,   138,     0,   139,   140,   141,   142,   143,     0,  4031,
       0,     0,     0,   144,  4032,   715,   145,     0,   146,   147,
     148,   149,   150,   151,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,     0,     0,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,     0,   172,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,     0,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,   193,     0,     0,     0,     0,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,   216,
       0,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,     0,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,   235,   236,     0,   237,     0,
       0,   238,   239,     0,     0,     0,   240,   241,   242,   243,
       0,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,     0,   248,   249,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
     256,   257,     0,     0,   258,     0,     0,   259,   260,     0,
       0,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,   312,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,     0,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,     0,     0,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,     0,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,   377,   378,     0,     0,
       0,   379,   380,   381,   382,     0,     0,     0,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
       0,     0,   400,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,     0,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,   425,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,     0,   450,     0,   138,     0,
     139,   140,   141,   142,   143,     0,     0,  1037,     0,     0,
     144,     0,     0,   145,   715,   146,   147,   148,   149,   150,
     151,   152,     0,   153,     0,     0,     0,   154,     0,     0,
       0,   155,     0,     0,   156,   157,   158,     0,   159,     0,
     160,   161,     0,     0,   162,     0,     0,   163,     0,   164,
     165,     0,   166,     0,   167,   168,   169,   170,   171,     0,
     172,   173,     0,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,     0,   185,     0,     0,
     186,     0,     0,   187,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,     0,
     192,   193,     0,     0,     0,     0,   194,     0,   195,     0,
       0,     0,   196,     0,   197,   198,   199,   200,     0,     0,
       0,   201,     0,     0,   202,   203,   204,     0,     0,     0,
     205,     0,   206,   207,     0,   208,   209,   210,     0,     0,
     211,     0,   212,   213,   214,   215,   216,     0,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
       0,     0,   225,     0,     0,     0,   226,   227,     0,   228,
       0,   229,     0,   230,   231,   232,   233,     0,   234,     0,
       0,     0,   235,   236,     0,   237,     0,     0,   238,   239,
       0,     0,     0,   240,   241,   242,   243,     0,     0,   244,
     245,     0,     0,   246,     0,   247,     0,     0,     0,   248,
     249,     0,  1226,     0,   250,     0,   251,   252,     0,   253,
     254,     0,     0,     0,   255,     0,     0,   256,   257,     0,
       0,   258,     0,     0,   259,   260,     0,     0,     0,     0,
       0,   261,   262,     0,   263,     0,   264,     0,   265,   266,
       0,     0,     0,     0,     0,     0,     0,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
       0,   280,   281,     0,   282,   283,   284,   285,     0,   286,
     287,   288,     0,     0,     0,   289,   290,   291,   292,   293,
       0,     0,   294,   295,     0,   296,     0,   297,     0,   298,
     299,   300,   301,   302,   303,   304,   305,     0,     0,   306,
     307,     0,     0,   308,   309,   310,   311,     0,     0,     0,
     312,   313,     0,     0,     0,     0,   314,   315,   316,     0,
     317,   318,   319,     0,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,   322,   323,   324,     0,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,     0,     0,   337,   338,   339,     0,   340,     0,   341,
     342,   343,   344,     0,   345,   346,   347,     0,     0,   348,
       0,     0,     0,   349,   350,   351,   352,   353,     0,     0,
     354,   355,   356,     0,   357,   358,     0,   359,   360,   361,
       0,     0,   362,     0,   363,   364,   365,     0,   366,   367,
       0,     0,     0,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,   377,   378,     0,     0,     0,   379,   380,
     381,   382,     0,     0,     0,   383,     0,     0,     0,   384,
     385,   386,   387,     0,   388,   389,   390,   391,   392,     0,
       0,     0,     0,     0,     0,   393,   394,     0,   395,     0,
       0,   396,     0,     0,   397,   398,   399,     0,     0,   400,
     401,     0,   402,   403,   404,   405,   406,     0,     0,   407,
     408,   409,   410,     0,   411,   412,     0,     0,   413,   414,
     415,     0,     0,   416,   417,     0,   418,   419,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,     0,
       0,   425,   426,   427,   428,     0,   429,   430,     0,   431,
     432,     0,   433,   434,     0,     0,   435,     0,     0,   436,
       0,   437,     0,   438,   439,     0,     0,     0,     0,     0,
       0,   440,     0,     0,   441,     0,     0,     0,   442,   443,
     444,   445,     0,     0,     0,     0,   446,   447,     0,   448,
     449,     0,     0,   450,     0,   138,     0,   139,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
     145,   494,   146,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,     0,   172,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,   193,     0,
       0,     0,     0,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,     0,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,     0,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,   235,
     236,     0,   237,     0,     0,   238,   239,     0,     0,     0,
     240,   241,   242,   243,     0,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,   249,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
       0,   259,   260,     0,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,   312,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,     0,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,     0,     0,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,     0,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
     377,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,     0,     0,   400,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,     0,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,   425,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,     0,
     450,     0,     0,     0,     0,   138,  2085,   139,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,   494,     0,
     145,     0,   146,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,     0,   172,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,   193,     0,
       0,     0,     0,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,     0,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,     0,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,   235,
     236,     0,   237,     0,     0,   238,   239,     0,     0,     0,
     240,   241,   242,   243,     0,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,   249,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
       0,   259,   260,     0,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,   312,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,     0,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,     0,     0,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,     0,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
     377,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,     0,     0,   400,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,     0,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,   425,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,     0,
     450,     0,   138,     0,   139,   140,   141,   142,   143,     0,
       0,  2321,     0,     0,   144,     0,     0,   145,  2322,   146,
     147,   148,   149,   150,   151,   152,     0,   153,     0,     0,
       0,   154,     0,     0,     0,   155,     0,     0,   156,   157,
     158,     0,   159,     0,   160,   161,     0,     0,   162,     0,
       0,   163,     0,   164,   165,     0,   166,     0,   167,   168,
     169,   170,   171,     0,   172,   173,     0,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
       0,   185,     0,     0,   186,     0,     0,   187,     0,     0,
       0,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,     0,   192,   193,     0,     0,     0,     0,
     194,     0,   195,     0,     0,     0,   196,     0,   197,   198,
     199,   200,     0,     0,     0,   201,     0,     0,   202,   203,
     204,     0,     0,     0,   205,     0,   206,   207,     0,   208,
     209,   210,     0,     0,   211,     0,   212,   213,   214,   215,
     216,     0,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,     0,     0,   225,     0,     0,     0,
     226,   227,     0,   228,     0,   229,     0,   230,   231,   232,
     233,     0,   234,     0,     0,     0,   235,   236,     0,   237,
       0,     0,   238,   239,     0,     0,     0,   240,   241,   242,
     243,     0,     0,   244,   245,     0,     0,   246,     0,   247,
       0,     0,     0,   248,   249,     0,     0,     0,   250,     0,
     251,   252,     0,   253,   254,     0,     0,     0,   255,     0,
       0,   256,   257,     0,     0,   258,     0,     0,   259,   260,
       0,     0,     0,     0,     0,   261,   262,     0,   263,     0,
     264,     0,   265,   266,     0,     0,     0,     0,     0,     0,
       0,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,     0,   280,   281,     0,   282,   283,
     284,   285,     0,   286,   287,   288,     0,     0,     0,   289,
     290,   291,   292,   293,     0,     0,   294,   295,     0,   296,
       0,   297,     0,   298,   299,   300,   301,   302,   303,   304,
     305,     0,     0,   306,   307,     0,     0,   308,   309,   310,
     311,     0,     0,     0,   312,   313,     0,     0,     0,     0,
     314,   315,   316,     0,   317,   318,   319,     0,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,   322,
     323,   324,     0,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,     0,     0,   337,   338,   339,
       0,   340,     0,   341,   342,   343,   344,     0,   345,   346,
     347,     0,     0,   348,     0,     0,     0,   349,   350,   351,
     352,   353,     0,     0,   354,   355,   356,     0,   357,   358,
       0,   359,   360,   361,     0,     0,   362,     0,   363,   364,
     365,     0,   366,   367,     0,     0,     0,   368,   369,   370,
     371,   372,   373,   374,   375,   376,     0,   377,   378,     0,
       0,     0,   379,   380,   381,   382,     0,     0,     0,   383,
       0,     0,     0,   384,   385,   386,   387,     0,   388,   389,
     390,   391,   392,     0,     0,     0,     0,     0,     0,   393,
     394,     0,   395,     0,     0,   396,     0,     0,   397,   398,
     399,     0,     0,   400,   401,     0,   402,   403,   404,   405,
     406,     0,     0,   407,   408,   409,   410,     0,   411,   412,
       0,     0,   413,   414,   415,     0,     0,   416,   417,     0,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,     0,     0,   425,   426,   427,   428,     0,
     429,   430,     0,   431,   432,     0,   433,   434,     0,     0,
     435,     0,     0,   436,     0,   437,     0,   438,   439,     0,
       0,     0,     0,     0,     0,   440,     0,     0,   441,     0,
       0,     0,   442,   443,   444,   445,     0,     0,     0,     0,
     446,   447,     0,   448,   449,     0,     0,   450,     0,     0,
       0,   138,     0,   139,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,  4032,   715,   145,     0,   146,   147,
     148,   149,   150,   151,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,     0,     0,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,     0,   172,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,     0,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,   193,     0,     0,     0,     0,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,   216,
       0,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,     0,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,   235,   236,     0,   237,     0,
       0,   238,   239,     0,     0,     0,   240,   241,   242,   243,
       0,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,     0,   248,   249,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
     256,   257,     0,     0,   258,     0,     0,   259,   260,     0,
       0,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,   312,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,     0,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,     0,     0,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,     0,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,   377,   378,     0,     0,
       0,   379,   380,   381,   382,     0,     0,     0,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
       0,     0,   400,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,     0,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,   425,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,     0,   450,     0,   138,     0,
     139,   140,   141,   142,   143,     0,     0,     0,     0,     0,
     144,     0,     0,   145,   494,   146,   147,   148,   149,   150,
     151,   152,     0,   153,     0,     0,     0,   154,     0,     0,
       0,   155,     0,     0,   156,   157,   158,     0,   159,     0,
     160,   161,     0,     0,   162,     0,     0,   163,     0,   164,
     165,     0,   166,     0,   167,   168,   169,   170,   171,     0,
     172,   173,     0,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,     0,   185,     0,     0,
     186,     0,     0,   187,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,     0,
     192,   193,     0,     0,     0,     0,   194,     0,   195,     0,
       0,     0,   196,     0,   197,   198,   199,   200,     0,     0,
       0,   201,     0,     0,   202,   203,   204,     0,     0,     0,
     205,     0,   206,   207,     0,   208,   209,   210,     0,     0,
     211,     0,   212,   213,   214,   215,   216,     0,     0,   217,
     553,   219,     0,     0,   220,   221,     0,   222,   223,   224,
       0,     0,   225,     0,     0,     0,   226,   227,     0,   228,
       0,   229,     0,   230,   231,   232,   233,     0,   234,     0,
       0,     0,   235,   236,     0,   237,     0,     0,   238,   239,
       0,     0,     0,   240,   241,   242,   243,     0,     0,   244,
     245,     0,     0,   246,     0,   247,     0,     0,     0,   248,
     249,     0,     0,     0,   250,     0,   251,   252,     0,   253,
     254,     0,     0,     0,   255,     0,     0,   256,   257,     0,
       0,   258,     0,     0,   259,   260,     0,     0,     0,     0,
       0,   261,   262,     0,   263,     0,   264,     0,   265,   266,
       0,     0,     0,     0,     0,     0,     0,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
       0,   280,   281,     0,   282,   283,   284,   285,     0,   286,
     287,   288,     0,     0,     0,   289,   290,   291,   292,   293,
       0,     0,   294,   295,     0,   296,     0,   297,     0,   298,
     299,   300,   301,   302,   303,   304,   305,     0,     0,   306,
     307,     0,     0,   308,   309,   310,   311,     0,     0,     0,
     312,   313,     0,     0,     0,     0,   314,   315,   316,     0,
     317,   318,   319,     0,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,   322,   323,   324,     0,   325,
     326,   327,   554,   329,   330,   331,   332,   333,   334,   335,
     336,     0,     0,   337,   338,   339,     0,   340,     0,   341,
     342,   343,   344,     0,   345,   346,   347,     0,     0,   348,
       0,     0,     0,   349,   350,   351,   352,   353,     0,     0,
     354,   355,   356,     0,   357,   358,     0,   359,   360,   361,
       0,     0,   362,     0,   363,   364,   365,     0,   366,   367,
       0,     0,     0,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,   377,   378,     0,     0,     0,   379,   380,
     381,   382,     0,     0,     0,   383,     0,     0,     0,   384,
     385,   386,   387,     0,   388,   389,   390,   391,   392,     0,
       0,     0,     0,     0,     0,   393,   394,     0,   395,     0,
       0,   396,     0,     0,   397,   398,   399,     0,     0,   400,
     401,     0,   402,   403,   404,   405,   406,     0,     0,   407,
     408,   409,   410,     0,   411,   412,     0,     0,   413,   414,
     415,     0,     0,   416,   417,     0,   418,   419,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,     0,
       0,   425,   426,   427,   428,     0,   429,   430,     0,   431,
     432,     0,   433,   434,     0,     0,   435,     0,     0,   436,
       0,   437,     0,   438,   439,     0,     0,     0,     0,     0,
       0,   440,     0,     0,   441,     0,     0,     0,   442,   443,
     444,   445,     0,     0,     0,     0,   446,   447,     0,   448,
     449,     0,     0,   450,     0,   138,     0,   139,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
     145,   494,   146,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,     0,   172,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,   193,     0,
       0,     0,     0,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,     0,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,     0,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,   235,
     236,     0,   237,     0,     0,   238,   239,     0,     0,     0,
     240,   241,   242,   243,     0,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,   249,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
       0,   259,   260,     0,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,   312,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,     0,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,     0,     0,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,     0,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
     377,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,     0,     0,   400,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,     0,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,   425,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,     0,
     450,     0,   138,     0,   139,   140,   141,   142,   143,     0,
       0,     0,     0,     0,   144,     0,     0,   145,   715,   146,
     147,   148,   149,   150,   151,   152,     0,   153,     0,     0,
       0,   154,     0,     0,     0,   155,     0,     0,   156,   157,
     158,     0,   159,     0,   160,   161,     0,     0,   162,     0,
       0,   163,     0,   164,   165,     0,   166,     0,   167,   168,
     169,   170,   171,     0,   172,   173,     0,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
       0,   185,     0,     0,   186,     0,     0,   187,     0,     0,
       0,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,     0,   192,   193,     0,     0,     0,     0,
     194,     0,   195,     0,     0,     0,   196,     0,   197,   198,
     199,   200,     0,     0,     0,   201,     0,     0,   202,   203,
     204,     0,     0,     0,   205,     0,   206,   207,     0,   208,
     209,   210,     0,     0,   211,     0,   212,   213,   214,   215,
     216,     0,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,     0,     0,   225,     0,     0,     0,
     226,   227,     0,   228,     0,   229,     0,   230,   231,   232,
     233,     0,   234,     0,     0,     0,   235,   236,     0,   237,
       0,     0,   238,   239,     0,     0,     0,   240,   241,   242,
     243,     0,     0,   244,   245,     0,     0,   246,     0,   247,
       0,     0,     0,   248,   249,     0,     0,     0,   250,     0,
     251,   252,     0,   253,   254,     0,     0,     0,   255,     0,
       0,   256,   257,     0,     0,   258,     0,     0,   259,   260,
       0,     0,     0,     0,     0,   261,   262,     0,   263,     0,
     264,     0,   265,   266,     0,     0,     0,     0,     0,     0,
       0,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,     0,   280,   281,     0,   282,   283,
     284,   285,     0,   286,   287,   288,     0,     0,     0,   289,
     290,   291,   292,   293,     0,     0,   294,   295,     0,   296,
       0,   297,     0,   298,   299,   300,   301,   302,   303,   304,
     305,     0,     0,   306,   307,     0,     0,   308,   309,   310,
     311,     0,     0,     0,   312,   313,     0,     0,     0,     0,
     314,   315,   316,     0,   317,   318,   319,     0,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,   322,
     323,   324,     0,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,     0,     0,   337,   338,   339,
       0,   340,     0,   341,   342,   343,   344,     0,   345,   346,
     347,     0,     0,   348,     0,     0,     0,   349,   350,   351,
     352,   353,     0,     0,   354,   355,   356,     0,   357,   358,
       0,   359,   360,   361,     0,     0,   362,     0,   363,   364,
     365,     0,   366,   367,     0,     0,     0,   368,   369,   370,
     371,   372,   373,   374,   375,   376,     0,   377,   378,     0,
       0,     0,   379,   380,   381,   382,     0,     0,     0,   383,
       0,     0,     0,   384,   385,   386,   387,     0,   388,   389,
     390,   391,   392,     0,     0,     0,     0,     0,     0,   393,
     394,     0,   395,     0,     0,   396,     0,     0,   397,   398,
     399,     0,     0,   400,   401,     0,   402,   403,   404,   405,
     406,     0,     0,   407,   408,   409,   410,     0,   411,   412,
       0,     0,   413,   414,   415,     0,     0,   416,   417,     0,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,     0,     0,   425,   426,   427,   428,     0,
     429,   430,     0,   431,   432,     0,   433,   434,     0,     0,
     435,     0,     0,   436,     0,   437,     0,   438,   439,     0,
       0,     0,     0,     0,     0,   440,     0,     0,   441,     0,
       0,     0,   442,   443,   444,   445,     0,     0,     0,     0,
     446,   447,     0,   448,   449,     0,     0,   450,     0,   138,
       0,   139,   140,   141,   142,   143,     0,     0,     0,     0,
       0,   144,     0,     0,   145,  2322,   146,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
       0,   172,   173,     0,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,     0,   185,     0,
       0,   186,     0,     0,   187,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
       0,   192,   193,     0,     0,     0,     0,   194,     0,   195,
       0,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,     0,   201,     0,     0,   202,   203,   204,     0,     0,
       0,   205,     0,   206,   207,     0,   208,   209,   210,     0,
       0,   211,     0,   212,   213,   214,   215,   216,     0,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,     0,     0,   225,     0,     0,     0,   226,   227,     0,
     228,     0,   229,     0,   230,   231,   232,   233,     0,   234,
       0,     0,     0,   235,   236,     0,   237,     0,     0,   238,
     239,     0,     0,     0,   240,   241,   242,   243,     0,     0,
     244,   245,     0,     0,   246,     0,   247,     0,     0,     0,
     248,   249,     0,     0,     0,   250,     0,   251,   252,     0,
     253,   254,     0,     0,     0,   255,     0,     0,   256,   257,
       0,     0,   258,     0,     0,   259,   260,   565,     0,     0,
       0,     0,   261,   262,     0,   263,     0,   264,     0,   265,
     266,     0,     0,     0,     0,     0,     0,     0,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,     0,   280,   281,     0,   282,   283,   284,   285,     0,
     286,   287,   288,     0,     0,     0,   289,   290,   291,   292,
     293,     0,     0,   294,   295,     0,   296,     0,   297,     0,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
     306,   307,     0,     0,   308,   309,   310,   311,     0,     0,
       0,   312,   313,     0,     0,     0,     0,   314,   315,   316,
       0,   317,   318,   319,     0,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,     0,     0,   337,   338,   339,     0,   340,     0,
     341,   342,   343,   344,     0,   345,   346,   347,     0,     0,
     348,     0,     0,     0,   349,   350,   351,   352,   353,     0,
       0,   354,   355,   356,     0,   357,   358,     0,   359,   360,
     361,     0,     0,   362,     0,   363,   364,   365,     0,   366,
     367,     0,     0,     0,   368,   369,   370,   371,   372,   373,
     374,   375,   376,     0,   377,   378,     0,     0,     0,   379,
     380,   381,   382,     0,     0,     0,   383,     0,     0,     0,
     384,   385,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,     0,     0,     0,     0,   393,   394,     0,   395,
       0,     0,   396,     0,     0,   397,   398,   399,     0,     0,
     400,   401,     0,   402,   403,   404,   405,   406,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,     0,   413,
     414,   415,     0,   135,   416,   417,     0,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
       0,     0,   425,   426,   427,   428,     0,   429,   430,     0,
     431,   432,     0,   433,   434,     0,     0,   435,     0,     0,
     436,     0,   437,     0,   438,   439,     0,     0,     0,     0,
       0,     0,   440,     0,     0,   441,     0,     0,     0,   442,
     443,   444,   445,     0,     0,     0,     0,   446,   447,     0,
     448,   449,     0,     0,   450,   138,     0,   139,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
     145,  1559,   146,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,     0,   172,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,   193,     0,
       0,     0,     0,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,     0,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,     0,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,   235,
     236,     0,   237,     0,     0,   238,   239,     0,     0,     0,
     240,   241,   242,   243,     0,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,   249,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
       0,   259,   260,   565,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,   312,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,     0,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,     0,     0,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,     0,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
     377,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,     0,     0,   400,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,   135,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,   425,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,     0,
     450,   138,     0,   139,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,     0,   145,  2575,   146,   147,
     148,   149,   150,   151,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,     0,     0,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,     0,   172,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,     0,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,   193,     0,     0,     0,     0,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,   216,
       0,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,     0,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,   235,   236,     0,   237,     0,
       0,   238,   239,     0,     0,     0,   240,   241,   242,   243,
       0,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,     0,   248,   249,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
     256,   257,     0,     0,   258,     0,     0,   259,   260,   565,
       0,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,   312,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,     0,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,     0,     0,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,     0,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,   377,   378,     0,     0,
       0,   379,   380,   381,   382,     0,     0,     0,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
       0,     0,   400,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,   135,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,   425,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,     0,   450,   138,     0,   139,
     140,   141,   142,   143,     0,     0,     0,     0,     0,   144,
       0,     0,     0,  3140,   146,   147,   148,   149,   150,   151,
       0,     0,  -287,     0,     0,     0,   154,     0,     0,     0,
     155,     0,     0,   156,   157,   158,     0,   159,     0,     0,
       0,     0,     0,   162,  3546,     0,   163,     0,   164,     0,
       0,     0,     0,   167,   168,  3547,   170,   171,     0,   172,
     173,     0,     0,   175,     0,   177,   178,   179,   180,     0,
     181,   182,     0,     0,   184,     0,   185,     0,     0,   186,
       0,     0,   187,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,     0,   192,
       0,     0,     0,     0,     0,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
       0,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,     0,     0,     0,   217,   218,
     219,     0,     0,   220,   221,  3548,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   226,   227,     0,   228,     0,
     229,     0,   230,   231,   232,   233,     0,   234,     0,     0,
       0,     0,   236,     0,     0,     0,     0,     0,   239,     0,
       0,     0,   240,   241,   242,   243,  3549,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,     0,   248,     0,
       0,     0,     0,   250,     0,   251,   252,     0,   253,   254,
    3550,     0,     0,   255,     0,     0,     0,   257,     0,     0,
     258,  3551,     0,   259,   260,     0,     0,     0,     0,     0,
     261,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,     0,     0,  -242,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,     0,   282,   283,   284,   285,     0,   286,   287,
     288,     0,     0,     0,   289,   290,   291,   292,   293,     0,
       0,   294,   295,     0,   296,     0,   297,     0,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,   306,   307,
       0,     0,   308,   309,   310,   311,     0,     0,     0,     0,
     313,     0,     0,     0,     0,   314,   315,   316,     0,   317,
     318,  3552,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   322,   323,   324,     0,     0,   326,
     327,   328,     0,   330,   331,   332,   333,   334,   335,     0,
       0,     0,     0,   338,   339,     0,   340,     0,   341,   342,
     343,   344,     0,   345,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,     0,     0,   359,     0,   361,  -242,
       0,   362,     0,     0,   364,     0,     0,   366,   367,  3553,
       0,     0,     0,   369,   370,   371,   372,   373,   374,     0,
     376,     0,   377,     0,     0,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   383,     0,     0,     0,   384,     0,
     386,     0,     0,   388,     0,     0,   391,   392,     0,     0,
       0,     0,     0,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,     0,   399,     0,     0,     0,   401,
       0,   402,   403,   404,   405,   406,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,     0,   413,   414,   415,
       0,     0,   416,   417,     0,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,     0,     0,
       0,   426,   427,   428,     0,   429,   430,     0,   431,   432,
       0,     0,     0,     0,     0,   435,     0,     0,   436,     0,
       0,     0,   438,   439,     0,     0,     0,     0,     0,     0,
     440,     0,     0,   441,     0,     0,     0,   442,   443,   444,
     445,     0,     0,  -242,     0,   446,     0,     0,   448,     0,
       0,   138,   450,   139,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,  4038,   145,     0,   146,   147,
     148,   149,   150,   151,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,     0,     0,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,     0,   172,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,     0,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,   193,     0,     0,     0,     0,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,   216,
       0,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,     0,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,   235,   236,     0,   237,     0,
       0,   238,   239,     0,     0,     0,   240,   241,   242,   243,
       0,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,     0,   248,   249,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
     256,   257,     0,     0,   258,     0,     0,   259,   260,     0,
       0,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,   312,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,     0,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,     0,     0,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,     0,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,   377,   378,     0,     0,
       0,   379,   380,   381,   382,     0,     0,     0,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
       0,     0,   400,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,     0,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,   425,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,   138,   450,   139,   140,   141,
     142,   143,  1934,     0,     0,     0,     0,   144,     0,     0,
     145,     0,   146,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,     0,   172,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,   193,     0,
       0,     0,     0,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,     0,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,     0,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,   235,
     236,     0,   237,     0,     0,   238,   239,     0,     0,     0,
     240,   241,   242,   243,     0,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,   249,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
       0,   259,   260,     0,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,   312,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,     0,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,     0,     0,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,     0,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
     377,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,     0,     0,   400,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,     0,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,   425,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,   138,
     450,   139,   140,   141,   142,   143,  2563,     0,     0,     0,
       0,   144,     0,     0,   145,     0,   146,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
       0,   172,   173,     0,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,     0,   185,     0,
       0,   186,     0,     0,   187,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
       0,   192,   193,     0,     0,     0,     0,   194,     0,   195,
       0,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,     0,   201,     0,     0,   202,   203,   204,     0,     0,
       0,   205,     0,   206,   207,     0,   208,   209,   210,     0,
       0,   211,     0,   212,   213,   214,   215,   216,     0,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,     0,     0,   225,     0,     0,     0,   226,   227,     0,
     228,     0,   229,     0,   230,   231,   232,   233,     0,   234,
       0,     0,     0,   235,   236,     0,   237,     0,     0,   238,
     239,     0,     0,     0,   240,   241,   242,   243,     0,     0,
     244,   245,     0,     0,   246,     0,   247,     0,     0,     0,
     248,   249,     0,     0,     0,   250,     0,   251,   252,     0,
     253,   254,     0,     0,     0,   255,     0,     0,   256,   257,
       0,     0,   258,     0,     0,   259,   260,     0,     0,     0,
       0,     0,   261,   262,     0,   263,     0,   264,     0,   265,
     266,     0,     0,     0,     0,     0,     0,     0,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,     0,   280,   281,     0,   282,   283,   284,   285,     0,
     286,   287,   288,     0,     0,     0,   289,   290,   291,   292,
     293,     0,     0,   294,   295,     0,   296,     0,   297,     0,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
     306,   307,     0,     0,   308,   309,   310,   311,     0,     0,
       0,   312,   313,     0,     0,     0,     0,   314,   315,   316,
       0,   317,   318,   319,     0,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,     0,     0,   337,   338,   339,     0,   340,     0,
     341,   342,   343,   344,     0,   345,   346,   347,     0,     0,
     348,     0,     0,     0,   349,   350,   351,   352,   353,     0,
       0,   354,   355,   356,     0,   357,   358,     0,   359,   360,
     361,     0,     0,   362,     0,   363,   364,   365,     0,   366,
     367,     0,     0,     0,   368,   369,   370,   371,   372,   373,
     374,   375,   376,     0,   377,   378,     0,     0,     0,   379,
     380,   381,   382,     0,     0,     0,   383,     0,     0,     0,
     384,   385,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,     0,     0,     0,     0,   393,   394,     0,   395,
       0,     0,   396,     0,     0,   397,   398,   399,     0,     0,
     400,   401,     0,   402,   403,   404,   405,   406,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,     0,   413,
     414,   415,     0,     0,   416,   417,     0,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
       0,     0,   425,   426,   427,   428,     0,   429,   430,     0,
     431,   432,     0,   433,   434,     0,     0,   435,     0,     0,
     436,     0,   437,     0,   438,   439,     0,     0,     0,     0,
       0,     0,   440,     0,     0,   441,     0,     0,     0,   442,
     443,   444,   445,     0,     0,     0,     0,   446,   447,     0,
     448,   449,     0,   138,   450,   139,   140,   141,   142,   143,
    2849,     0,     0,     0,     0,   144,     0,     0,   145,     0,
     146,   147,   148,   149,   150,   151,   152,     0,   153,     0,
       0,     0,   154,     0,     0,     0,   155,     0,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
       0,     0,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,     0,   172,   173,     0,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,     0,   185,     0,     0,   186,     0,     0,   187,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,     0,   192,   193,     0,     0,     0,
       0,   194,     0,   195,     0,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,     0,   201,     0,     0,   202,
     203,   204,     0,     0,     0,   205,     0,   206,   207,     0,
     208,   209,   210,     0,     0,   211,     0,   212,   213,   214,
     215,   216,     0,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,     0,     0,   225,     0,     0,
       0,   226,   227,     0,   228,     0,   229,     0,   230,   231,
     232,   233,     0,   234,     0,     0,     0,   235,   236,     0,
     237,     0,     0,   238,   239,     0,     0,     0,   240,   241,
     242,   243,     0,     0,   244,   245,     0,     0,   246,     0,
     247,     0,     0,     0,   248,   249,     0,     0,     0,   250,
       0,   251,   252,     0,   253,   254,     0,     0,     0,   255,
       0,     0,   256,   257,     0,     0,   258,     0,     0,   259,
     260,     0,     0,     0,     0,     0,   261,   262,     0,   263,
       0,   264,     0,   265,   266,     0,     0,     0,     0,     0,
       0,     0,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,     0,   280,   281,     0,   282,
     283,   284,   285,     0,   286,   287,   288,     0,     0,     0,
     289,   290,   291,   292,   293,     0,     0,   294,   295,     0,
     296,     0,   297,     0,   298,   299,   300,   301,   302,   303,
     304,   305,     0,     0,   306,   307,     0,     0,   308,   309,
     310,   311,     0,     0,     0,   312,   313,     0,     0,     0,
       0,   314,   315,   316,     0,   317,   318,   319,     0,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,     0,     0,   337,   338,
     339,     0,   340,     0,   341,   342,   343,   344,     0,   345,
     346,   347,     0,     0,   348,     0,     0,     0,   349,   350,
     351,   352,   353,     0,     0,   354,   355,   356,     0,   357,
     358,     0,   359,   360,   361,     0,     0,   362,     0,   363,
     364,   365,     0,   366,   367,     0,     0,     0,   368,   369,
     370,   371,   372,   373,   374,   375,   376,     0,   377,   378,
       0,     0,     0,   379,   380,   381,   382,     0,     0,     0,
     383,     0,     0,     0,   384,   385,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,     0,     0,     0,     0,
     393,   394,     0,   395,     0,     0,   396,     0,     0,   397,
     398,   399,     0,     0,   400,   401,     0,   402,   403,   404,
     405,   406,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,     0,   413,   414,   415,     0,     0,   416,   417,
       0,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,     0,     0,   425,   426,   427,   428,
       0,   429,   430,     0,   431,   432,     0,   433,   434,     0,
       0,   435,     0,     0,   436,     0,   437,     0,   438,   439,
       0,     0,     0,     0,     0,     0,   440,     0,     0,   441,
       0,     0,     0,   442,   443,   444,   445,     0,     0,     0,
       0,   446,   447,     0,   448,   449,     0,   138,   450,   139,
     140,   141,   142,   143,  3145,     0,     0,     0,     0,   144,
       0,     0,   145,     0,   146,   147,   148,   149,   150,   151,
     152,     0,   153,     0,     0,     0,   154,     0,     0,     0,
     155,     0,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,     0,     0,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,     0,   172,
     173,     0,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,     0,   183,   184,     0,   185,     0,     0,   186,
       0,     0,   187,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,     0,   192,
     193,  2234,     0,     0,     0,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
     201,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,   206,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,   216,     0,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,  2235,
       0,   225,     0,     0,     0,   226,   227,     0,   228,     0,
     229,     0,   230,   231,   232,   233,     0,   234,     0,     0,
       0,   235,   236,     0,   237,  2236,     0,   238,   239,     0,
       0,     0,   240,   241,   242,   243,     0,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,     0,   248,   249,
       0,     0,     0,   250,     0,   251,   252,     0,   253,   254,
       0,     0,     0,   255,     0,     0,   256,   257,     0,     0,
     258,     0,     0,   259,   260,     0,     0,     0,     0,     0,
     261,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,  2237,     0,     0,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,     0,   282,   283,   284,   285,     0,   286,   287,
     288,     0,     0,     0,   289,   290,   291,   292,   293,     0,
       0,   294,   295,     0,   296,     0,   297,     0,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,   306,   307,
       0,     0,   308,   309,   310,   311,   954,   955,     0,   312,
     313,     0,     0,  2238,     0,   314,   315,   316,     0,   317,
     318,   319,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,   322,   323,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
       0,     0,   337,   338,   339,     0,   340,     0,   341,   342,
     343,   344,     0,   345,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,   358,     0,   359,   360,   361,     0,
       0,   362,     0,   363,   364,   365,     0,   366,   367,     0,
       0,     0,   368,   369,   370,   371,   372,   373,   374,   375,
     376,     0,   377,   378,     0,     0,     0,   379,   380,   381,
     382,     0,     0,     0,   383,     0,     0,     0,   384,   385,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
    4018,  4007,  4019,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,   398,   399,     0,     0,   400,   401,
       0,   402,   403,   404,   405,   406,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,     0,   413,   414,   415,
       0,     0,   416,   417,     0,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,     0,     0,
     425,   426,   427,   428,  2239,   429,   430,     0,   431,   432,
       0,   433,   434,     0,     0,   435,     0,     0,   436,     0,
     437,     0,   438,   439,     0,     0,     0,     0,     0,     0,
     440,     0,     0,   441,     0,     0,     0,   442,   443,   444,
     445,     0,     0,     0,     0,   446,   447,     0,   448,   449,
       0,   138,   450,   139,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,     0,   145,     0,   146,   147,
     148,   149,   150,   151,   152,     0,   153,     0,     0,  2427,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,     0,     0,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,     0,   172,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,     0,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,   193,     0,     0,     0,  2569,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,  2070,     0,   211,     0,   212,   213,   214,   215,   216,
       0,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,     0,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,   235,   236,     0,   237,     0,
       0,   238,   239,     0,     0,     0,   240,   241,   242,   243,
       0,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,     0,   248,   249,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
     256,   257,     0,     0,   258,     0,     0,   259,   260,   565,
       0,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,   312,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,     0,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,     0,     0,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,     0,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,   377,   378,     0,     0,
       0,   379,   380,   381,   382,     0,     0,  2071,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
       0,     0,   400,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,   135,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,   425,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,   138,   450,   139,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
     145,     0,   146,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,  2577,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,     0,   172,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,   193,     0,
       0,     0,  2578,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,     0,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,     0,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,   235,
     236,     0,   237,     0,     0,   238,   239,     0,     0,     0,
     240,   241,   242,   243,     0,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,   249,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
       0,   259,   260,   565,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,   312,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,     0,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,     0,     0,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,     0,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
     377,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,     0,     0,   400,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,   135,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,   425,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,   138,
     450,   139,   140,   141,   142,   143,     0,     0,     0,     0,
       0,   144,     0,     0,   145,     0,   146,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,  2427,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
       0,   172,   173,     0,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,     0,   185,     0,
       0,   186,     0,     0,   187,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
       0,   192,   193,     0,     0,     0,  2569,   194,     0,   195,
       0,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,     0,   201,     0,     0,   202,   203,   204,     0,     0,
       0,   205,     0,   206,   207,     0,   208,   209,   210,     0,
       0,   211,     0,   212,   213,   214,   215,   216,     0,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,     0,     0,   225,     0,     0,     0,   226,   227,     0,
     228,     0,   229,     0,   230,   231,   232,   233,     0,   234,
       0,     0,     0,   235,   236,     0,   237,     0,     0,   238,
     239,     0,     0,     0,   240,   241,   242,   243,     0,     0,
     244,   245,     0,     0,   246,     0,   247,     0,     0,     0,
     248,   249,     0,     0,     0,   250,     0,   251,   252,     0,
     253,   254,     0,     0,     0,   255,     0,     0,   256,   257,
       0,     0,   258,     0,     0,   259,   260,   565,     0,     0,
       0,     0,   261,   262,     0,   263,     0,   264,     0,   265,
     266,     0,     0,     0,     0,     0,     0,     0,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,     0,   280,   281,     0,   282,   283,   284,   285,     0,
     286,   287,   288,     0,     0,     0,   289,   290,   291,   292,
     293,     0,     0,   294,   295,     0,   296,     0,   297,     0,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
     306,   307,     0,     0,   308,   309,   310,   311,     0,     0,
       0,   312,   313,     0,     0,     0,     0,   314,   315,   316,
       0,   317,   318,   319,     0,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,     0,     0,   337,   338,   339,     0,   340,     0,
     341,   342,   343,   344,     0,   345,   346,   347,     0,     0,
     348,     0,     0,     0,   349,   350,   351,   352,   353,     0,
       0,   354,   355,   356,     0,   357,   358,     0,   359,   360,
     361,     0,     0,   362,     0,   363,   364,   365,     0,   366,
     367,     0,     0,     0,   368,   369,   370,   371,   372,   373,
     374,   375,   376,     0,   377,   378,     0,     0,     0,   379,
     380,   381,   382,     0,     0,     0,   383,     0,     0,     0,
     384,   385,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,     0,     0,     0,     0,   393,   394,     0,   395,
       0,     0,   396,     0,     0,   397,   398,   399,     0,     0,
     400,   401,     0,   402,   403,   404,   405,   406,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,     0,   413,
     414,   415,     0,   135,   416,   417,     0,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
       0,     0,   425,   426,   427,   428,     0,   429,   430,     0,
     431,   432,     0,   433,   434,     0,     0,   435,     0,     0,
     436,     0,   437,     0,   438,   439,     0,     0,     0,     0,
       0,     0,   440,     0,     0,   441,     0,     0,     0,   442,
     443,   444,   445,     0,     0,     0,     0,   446,   447,     0,
     448,   449,     0,   138,   450,   139,   140,   141,   142,   143,
       0,     0,     0,     0,     0,   144,     0,     0,   145,     0,
     146,   147,   148,   149,   150,   151,   152,     0,   153,     0,
       0,     0,   154,     0,     0,     0,   155,     0,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
       0,     0,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,     0,   172,   173,     0,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,     0,   185,     0,     0,   186,     0,     0,   187,     0,
     914,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,     0,   192,   193,     0,     0,     0,
       0,   194,     0,   195,     0,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,     0,   201,     0,     0,   202,
     203,   204,     0,     0,     0,   205,     0,   206,   207,     0,
     208,   209,   210,     0,     0,   211,     0,   212,   213,   214,
     215,   216,     0,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,     0,     0,   225,     0,     0,
       0,   226,   227,     0,   228,     0,   229,     0,   230,   231,
     232,   233,     0,   234,     0,     0,     0,   235,   236,     0,
     237,     0,     0,   238,   239,     0,     0,     0,   240,   241,
     242,   243,     0,     0,   244,   245,     0,     0,   246,     0,
     247,     0,     0,     0,   248,   249,     0,     0,     0,   250,
       0,   251,   252,     0,   253,   254,     0,     0,     0,   255,
       0,     0,   256,   257,     0,     0,   258,     0,     0,   259,
     260,   565,     0,     0,     0,     0,   261,   262,     0,   263,
       0,   264,     0,   265,   266,     0,     0,     0,     0,     0,
       0,     0,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,     0,   280,   281,     0,   282,
     283,   284,   285,     0,   286,   287,   288,     0,     0,     0,
     289,   290,   291,   292,   293,     0,     0,   294,   295,     0,
     296,     0,   297,     0,   298,   299,   300,   301,   302,   303,
     304,   305,     0,     0,   306,   307,     0,     0,   308,   309,
     310,   311,     0,     0,     0,   312,   313,     0,     0,     0,
       0,   314,   315,   316,     0,   317,   318,   319,     0,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,     0,     0,   337,   338,
     339,     0,   340,     0,   341,   342,   343,   344,     0,   345,
     346,   347,     0,     0,   348,     0,     0,     0,   349,   350,
     351,   352,   353,     0,     0,   354,   355,   356,     0,   357,
     358,     0,   359,   360,   361,     0,     0,   362,     0,   363,
     364,   365,     0,   366,   367,     0,     0,     0,   368,   369,
     370,   371,   372,   373,   374,   375,   376,     0,   377,   378,
       0,     0,     0,   379,   380,   381,   382,     0,     0,     0,
     383,     0,     0,     0,   384,   385,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,     0,     0,     0,     0,
     393,   394,     0,   395,     0,     0,   396,     0,     0,   397,
     398,   399,     0,     0,   400,   401,     0,   402,   403,   404,
     405,   406,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,     0,   413,   414,   415,     0,   135,   416,   417,
       0,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,     0,     0,   425,   426,   427,   428,
       0,   429,   430,     0,   431,   432,     0,   433,   434,     0,
       0,   435,     0,     0,   436,     0,   437,     0,   438,   439,
       0,     0,     0,     0,     0,     0,   440,     0,     0,   441,
       0,     0,     0,   442,   443,   444,   445,     0,     0,     0,
       0,   446,   447,     0,   448,   449,     0,   138,   450,   139,
     140,   141,   142,   143,  1264,     0,     0,     0,     0,   144,
       0,     0,   145,     0,   146,   147,   148,   149,   150,   151,
     152,     0,   153,     0,     0,     0,   154,     0,     0,     0,
     155,     0,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,     0,     0,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,     0,   172,
     173,     0,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,     0,   183,   184,     0,   185,     0,     0,   186,
       0,     0,   187,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,     0,   192,
     193,     0,     0,     0,     0,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
     201,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,   206,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,   216,     0,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,     0,
       0,   225,     0,     0,     0,   226,   227,     0,   228,     0,
     229,     0,   230,   231,   232,   233,     0,   234,     0,     0,
       0,   235,   236,     0,   237,     0,     0,   238,   239,     0,
       0,     0,   240,   241,   242,   243,     0,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,     0,   248,   249,
       0,     0,     0,   250,     0,   251,   252,     0,   253,   254,
       0,     0,     0,   255,     0,     0,   256,   257,     0,     0,
     258,     0,     0,   259,   260,   565,     0,     0,     0,     0,
     261,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,     0,     0,     0,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,     0,   282,   283,   284,   285,     0,   286,   287,
     288,     0,     0,     0,   289,   290,   291,   292,   293,     0,
       0,   294,   295,     0,   296,     0,   297,     0,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,   306,   307,
       0,     0,   308,   309,   310,   311,     0,     0,     0,   312,
     313,     0,     0,     0,     0,   314,   315,   316,     0,   317,
     318,   319,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,   322,   323,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
       0,     0,   337,   338,   339,     0,   340,     0,   341,   342,
     343,   344,     0,   345,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,   358,     0,   359,   360,   361,     0,
       0,   362,     0,   363,   364,   365,     0,   366,   367,     0,
       0,     0,   368,   369,   370,   371,   372,   373,   374,   375,
     376,     0,   377,   378,     0,     0,     0,   379,   380,   381,
     382,     0,     0,     0,   383,     0,     0,     0,   384,   385,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
       0,     0,     0,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,   398,   399,     0,     0,   400,   401,
       0,   402,   403,   404,   405,   406,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,     0,   413,   414,   415,
       0,   135,   416,   417,     0,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,     0,     0,
     425,   426,   427,   428,     0,   429,   430,     0,   431,   432,
       0,   433,   434,     0,     0,   435,     0,     0,   436,     0,
     437,     0,   438,   439,     0,     0,     0,     0,     0,     0,
     440,     0,     0,   441,     0,     0,     0,   442,   443,   444,
     445,     0,     0,     0,     0,   446,   447,     0,   448,   449,
       0,   138,   450,   139,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,     0,   145,     0,   146,   147,
     148,   149,   150,   151,   152,     0,   153,     0,     0,     0,
     154,   893,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,     0,     0,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,     0,   172,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,     0,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,   193,     0,     0,     0,     0,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,   216,
       0,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,     0,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,   235,   236,     0,   237,   894,
       0,   238,   239,     0,     0,     0,   240,   241,   242,   243,
       0,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,     0,   248,   249,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
     256,   257,     0,     0,   258,     0,     0,   259,   260,     0,
       0,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,   312,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,     0,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,     0,     0,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,     0,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,   377,   378,     0,     0,
       0,   379,   380,   381,   382,     0,     0,     0,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
       0,     0,   400,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,   895,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,   425,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,   138,   450,   139,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
     145,     0,   146,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,  2427,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,     0,   172,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,   193,     0,
       0,     0,     0,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,     0,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,     0,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,   235,
     236,     0,   237,     0,     0,   238,   239,     0,     0,     0,
     240,   241,   242,   243,     0,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,   249,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
       0,   259,   260,   565,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,   312,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,     0,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,     0,     0,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,     0,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
     377,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,     0,     0,   400,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,   135,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,   425,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,   138,
     450,   139,   140,   141,   142,   143,     0,     0,     0,     0,
       0,   144,     0,     0,   145,     0,   146,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
       0,   172,   173,     0,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,     0,   185,     0,
       0,   186,     0,     0,   187,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
       0,   192,   193,     0,     0,     0,  2616,   194,     0,   195,
       0,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,     0,   201,     0,     0,   202,   203,   204,     0,     0,
       0,   205,     0,   206,   207,     0,   208,   209,   210,     0,
       0,   211,     0,   212,   213,   214,   215,   216,     0,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,     0,     0,   225,     0,     0,     0,   226,   227,     0,
     228,     0,   229,     0,   230,   231,   232,   233,     0,   234,
       0,     0,     0,   235,   236,     0,   237,     0,     0,   238,
     239,     0,     0,     0,   240,   241,   242,   243,     0,     0,
     244,   245,     0,     0,   246,     0,   247,     0,     0,     0,
     248,   249,     0,     0,     0,   250,     0,   251,   252,     0,
     253,   254,     0,     0,     0,   255,     0,     0,   256,   257,
       0,     0,   258,     0,     0,   259,   260,   565,     0,     0,
       0,     0,   261,   262,     0,   263,     0,   264,     0,   265,
     266,     0,     0,     0,     0,     0,     0,     0,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,     0,   280,   281,     0,   282,   283,   284,   285,     0,
     286,   287,   288,     0,     0,     0,   289,   290,   291,   292,
     293,     0,     0,   294,   295,     0,   296,     0,   297,     0,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
     306,   307,     0,     0,   308,   309,   310,   311,     0,     0,
       0,   312,   313,     0,     0,     0,     0,   314,   315,   316,
       0,   317,   318,   319,     0,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,     0,     0,   337,   338,   339,     0,   340,     0,
     341,   342,   343,   344,     0,   345,   346,   347,     0,     0,
     348,     0,     0,     0,   349,   350,   351,   352,   353,     0,
       0,   354,   355,   356,     0,   357,   358,     0,   359,   360,
     361,     0,     0,   362,     0,   363,   364,   365,     0,   366,
     367,     0,     0,     0,   368,   369,   370,   371,   372,   373,
     374,   375,   376,     0,   377,   378,     0,     0,     0,   379,
     380,   381,   382,     0,     0,     0,   383,     0,     0,     0,
     384,   385,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,     0,     0,     0,     0,   393,   394,     0,   395,
       0,     0,   396,     0,     0,   397,   398,   399,     0,     0,
     400,   401,     0,   402,   403,   404,   405,   406,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,     0,   413,
     414,   415,     0,   135,   416,   417,     0,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
       0,     0,   425,   426,   427,   428,     0,   429,   430,     0,
     431,   432,     0,   433,   434,     0,     0,   435,     0,     0,
     436,     0,   437,     0,   438,   439,     0,     0,     0,     0,
       0,     0,   440,     0,     0,   441,     0,     0,     0,   442,
     443,   444,   445,     0,     0,     0,     0,   446,   447,     0,
     448,   449,     0,   138,   450,   139,   140,   141,   142,   143,
       0,     0,     0,     0,     0,   144,     0,     0,   145,     0,
     146,   147,   148,   149,   150,   151,   152,     0,   153,     0,
       0,     0,   154,     0,     0,     0,   155,     0,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
       0,     0,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,     0,   172,   173,     0,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,     0,   185,     0,     0,   186,     0,     0,   187,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,     0,   192,   193,     0,     0,     0,
       0,   194,     0,   195,     0,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,     0,   201,     0,     0,   202,
     203,   204,     0,     0,     0,   205,     0,   206,   207,     0,
     208,   209,   210,     0,     0,   211,     0,   212,   213,   214,
     215,   216,     0,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,     0,     0,   225,     0,     0,
       0,   226,   227,     0,   228,     0,   229,     0,   230,   231,
     232,   233,     0,   234,     0,     0,     0,   235,   236,     0,
     237,     0,     0,   238,   239,     0,     0,     0,   240,   241,
     242,   243,     0,     0,   244,   245,     0,     0,   246,     0,
     247,     0,     0,     0,   248,   249,     0,     0,     0,   250,
       0,   251,   252,     0,   253,   254,     0,     0,     0,   255,
       0,     0,   256,   257,     0,     0,   258,     0,     0,   259,
     260,   565,     0,     0,     0,     0,   261,   262,     0,   263,
       0,   264,     0,   265,   266,     0,     0,     0,     0,     0,
       0,     0,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,     0,   280,   281,     0,   282,
     283,   284,   285,     0,   286,   287,   288,     0,     0,     0,
     289,   290,   291,   292,   293,     0,     0,   294,   295,     0,
     296,     0,   297,     0,   298,   299,   300,   301,   302,   303,
     304,   305,     0,     0,   306,   307,     0,     0,   308,   309,
     310,   311,     0,     0,     0,   312,   313,     0,     0,     0,
       0,   314,   315,   316,     0,   317,   318,   319,     0,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,     0,     0,   337,   338,
     339,     0,   340,     0,   341,   342,   343,   344,     0,   345,
     346,   347,     0,     0,   348,     0,     0,     0,   349,   350,
     351,   352,   353,     0,     0,   354,   355,   356,     0,   357,
     358,     0,   359,   360,   361,     0,     0,   362,     0,   363,
     364,   365,     0,   366,   367,     0,     0,     0,   368,   369,
     370,   371,   372,   373,   374,   375,   376,     0,   377,   378,
       0,     0,     0,   379,   380,   381,   382,     0,     0,     0,
     383,     0,     0,     0,   384,   385,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,     0,     0,     0,     0,
     393,   394,     0,   395,     0,     0,   396,     0,     0,   397,
     398,   399,     0,     0,   400,   401,     0,   402,   403,   404,
     405,   406,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,     0,   413,   414,   415,     0,   135,   416,   417,
       0,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,     0,     0,   425,   426,   427,   428,
       0,   429,   430,     0,   431,   432,     0,   433,   434,     0,
       0,   435,     0,     0,   436,     0,   437,     0,   438,   439,
       0,     0,     0,     0,     0,     0,   440,     0,     0,   441,
       0,     0,     0,   442,   443,   444,   445,     0,     0,     0,
       0,   446,   447,     0,   448,   449,     0,   138,   450,   139,
     140,   141,   142,   143,     0,     0,     0,     0,     0,   144,
    2559,     0,   145,     0,   146,   147,   148,   149,   150,   151,
     152,     0,   153,     0,     0,     0,   154,     0,     0,     0,
     155,     0,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,     0,     0,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,     0,   172,
     173,     0,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,     0,   183,   184,     0,   185,     0,     0,   186,
       0,     0,   187,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,     0,   192,
     193,     0,     0,     0,     0,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
     201,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,   206,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,   216,     0,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,     0,
       0,   225,     0,     0,     0,   226,   227,     0,   228,     0,
     229,     0,   230,   231,   232,   233,     0,   234,     0,     0,
       0,   235,   236,     0,   237,     0,     0,   238,   239,     0,
       0,     0,   240,   241,   242,   243,     0,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,     0,   248,   249,
       0,     0,     0,   250,     0,   251,   252,     0,   253,   254,
       0,     0,     0,   255,     0,     0,   256,   257,     0,     0,
     258,     0,     0,   259,   260,     0,     0,     0,     0,     0,
     261,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,     0,     0,     0,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,     0,   282,   283,   284,   285,     0,   286,   287,
     288,     0,     0,     0,   289,   290,   291,   292,   293,     0,
       0,   294,   295,     0,   296,     0,   297,     0,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,   306,   307,
       0,     0,   308,   309,   310,   311,     0,     0,     0,   312,
     313,     0,     0,     0,     0,   314,   315,   316,     0,   317,
     318,   319,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,   322,   323,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
       0,     0,   337,   338,   339,     0,   340,     0,   341,   342,
     343,   344,     0,   345,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,   358,     0,   359,   360,   361,     0,
       0,   362,     0,   363,   364,   365,     0,   366,   367,     0,
       0,     0,   368,   369,   370,   371,   372,   373,   374,   375,
     376,     0,   377,   378,     0,     0,     0,   379,   380,   381,
     382,     0,     0,     0,   383,     0,     0,     0,   384,   385,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
       0,     0,     0,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,   398,   399,     0,     0,   400,   401,
       0,   402,   403,   404,   405,   406,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,     0,   413,   414,   415,
       0,   135,   416,   417,     0,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,     0,     0,
     425,   426,   427,   428,     0,   429,   430,     0,   431,   432,
       0,   433,   434,     0,     0,   435,     0,     0,   436,     0,
     437,     0,   438,   439,     0,     0,     0,     0,     0,     0,
     440,     0,     0,   441,     0,     0,     0,   442,   443,   444,
     445,     0,     0,     0,     0,   446,   447,     0,   448,   449,
       0,   138,   450,   139,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,     0,   145,     0,   146,   147,
     148,   149,   150,   151,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,     0,     0,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,     0,   172,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,  3945,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,   193,     0,     0,     0,     0,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,   216,
       0,  3946,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,     0,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,   235,   236,     0,   237,     0,
       0,   238,   239,     0,     0,     0,   240,   241,   242,   243,
       0,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,     0,   248,   249,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
     256,   257,     0,     0,   258,     0,     0,   259,   260,     0,
       0,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,   312,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,     0,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,     0,     0,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,     0,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,   377,   378,     0,     0,
       0,   379,   380,   381,   382,     0,     0,     0,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
       0,     0,   400,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,     0,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,   425,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,   138,   450,   139,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
     145,     0,   146,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,     0,   172,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,   193,     0,
       0,     0,     0,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,     0,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,     0,     0,   225,
       0,     0,     0,   226,   227,   989,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,   235,
     236,     0,   237,     0,     0,   238,   239,     0,     0,     0,
     240,   241,   242,   243,     0,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,   249,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
       0,   259,   260,     0,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,   312,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,     0,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,     0,     0,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,     0,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
     377,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,     0,     0,   400,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,     0,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,   425,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,   138,
     450,   139,   140,   141,   142,   143,     0,     0,     0,     0,
       0,   144,     0,     0,   145,     0,   146,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
       0,   172,   173,     0,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,     0,   185,     0,
       0,   186,     0,     0,   187,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
       0,   192,   193,     0,     0,     0,  1364,   194,     0,   195,
       0,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,     0,   201,     0,     0,   202,   203,   204,     0,     0,
       0,   205,     0,   206,   207,     0,   208,   209,   210,     0,
       0,   211,     0,   212,   213,   214,   215,   216,     0,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,     0,     0,   225,     0,     0,     0,   226,   227,     0,
     228,     0,   229,     0,   230,   231,   232,   233,     0,   234,
       0,     0,     0,   235,   236,     0,   237,     0,     0,   238,
     239,     0,     0,     0,   240,   241,   242,   243,     0,     0,
     244,   245,     0,     0,   246,     0,   247,     0,     0,     0,
     248,   249,     0,     0,     0,   250,     0,   251,   252,     0,
     253,   254,     0,     0,     0,   255,     0,     0,   256,   257,
       0,     0,   258,     0,     0,   259,   260,     0,     0,     0,
       0,     0,   261,   262,     0,   263,     0,   264,     0,   265,
     266,     0,     0,     0,     0,     0,     0,     0,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,     0,   280,   281,     0,   282,   283,   284,   285,     0,
     286,   287,   288,     0,     0,     0,   289,   290,   291,   292,
     293,     0,     0,   294,   295,     0,   296,     0,   297,     0,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
     306,   307,     0,     0,   308,   309,   310,   311,     0,     0,
       0,   312,   313,     0,     0,     0,     0,   314,   315,   316,
       0,   317,   318,   319,     0,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,     0,     0,   337,   338,   339,     0,   340,     0,
     341,   342,   343,   344,     0,   345,   346,   347,     0,     0,
     348,     0,     0,     0,   349,   350,   351,   352,   353,     0,
       0,   354,   355,   356,     0,   357,   358,     0,   359,   360,
     361,     0,     0,   362,     0,   363,   364,   365,     0,   366,
     367,     0,     0,     0,   368,   369,   370,   371,   372,   373,
     374,   375,   376,     0,   377,   378,     0,     0,     0,   379,
     380,   381,   382,     0,     0,     0,   383,     0,     0,     0,
     384,   385,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,     0,     0,     0,     0,   393,   394,     0,   395,
       0,     0,   396,     0,     0,   397,   398,   399,     0,     0,
     400,   401,     0,   402,   403,   404,   405,   406,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,     0,   413,
     414,   415,     0,     0,   416,   417,     0,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
       0,     0,   425,   426,   427,   428,     0,   429,   430,     0,
     431,   432,     0,   433,   434,     0,     0,   435,     0,     0,
     436,     0,   437,     0,   438,   439,     0,     0,     0,     0,
       0,     0,   440,     0,     0,   441,     0,     0,     0,   442,
     443,   444,   445,     0,     0,     0,     0,   446,   447,     0,
     448,   449,     0,   138,   450,   139,   140,   141,   142,   143,
       0,     0,     0,     0,     0,   144,     0,     0,   145,     0,
     146,   147,   148,   149,   150,   151,   152,     0,   153,     0,
       0,     0,   154,     0,     0,     0,   155,     0,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
       0,     0,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,     0,   172,   173,     0,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,     0,   185,     0,     0,   186,     0,     0,   187,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,     0,   192,   193,     0,     0,     0,
    2167,   194,     0,   195,     0,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,     0,   201,     0,     0,   202,
     203,   204,     0,     0,     0,   205,     0,   206,   207,     0,
     208,   209,   210,     0,     0,   211,     0,   212,   213,   214,
     215,   216,     0,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,     0,     0,   225,     0,     0,
       0,   226,   227,     0,   228,     0,   229,     0,   230,   231,
     232,   233,     0,   234,     0,     0,     0,   235,   236,     0,
     237,     0,     0,   238,   239,     0,     0,     0,   240,   241,
     242,   243,     0,     0,   244,   245,     0,     0,   246,     0,
     247,     0,     0,     0,   248,   249,     0,     0,     0,   250,
       0,   251,   252,     0,   253,   254,     0,     0,     0,   255,
       0,     0,   256,   257,     0,     0,   258,     0,     0,   259,
     260,     0,     0,     0,     0,     0,   261,   262,     0,   263,
       0,   264,     0,   265,   266,     0,     0,     0,     0,     0,
       0,     0,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,     0,   280,   281,     0,   282,
     283,   284,   285,     0,   286,   287,   288,     0,     0,     0,
     289,   290,   291,   292,   293,     0,     0,   294,   295,     0,
     296,     0,   297,     0,   298,   299,   300,   301,   302,   303,
     304,   305,     0,     0,   306,   307,     0,     0,   308,   309,
     310,   311,     0,     0,     0,   312,   313,     0,     0,     0,
       0,   314,   315,   316,     0,   317,   318,   319,     0,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,     0,     0,   337,   338,
     339,     0,   340,     0,   341,   342,   343,   344,     0,   345,
     346,   347,     0,     0,   348,     0,     0,     0,   349,   350,
     351,   352,   353,     0,     0,   354,   355,   356,     0,   357,
     358,     0,   359,   360,   361,     0,     0,   362,     0,   363,
     364,   365,     0,   366,   367,     0,     0,     0,   368,   369,
     370,   371,   372,   373,   374,   375,   376,     0,   377,   378,
       0,     0,     0,   379,   380,   381,   382,     0,     0,     0,
     383,     0,     0,     0,   384,   385,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,     0,     0,     0,     0,
     393,   394,     0,   395,     0,     0,   396,     0,     0,   397,
     398,   399,     0,     0,   400,   401,     0,   402,   403,   404,
     405,   406,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,     0,   413,   414,   415,     0,     0,   416,   417,
       0,   418,   419,   420,   421,     0,     0,     0,     0,     0,
    2168,   423,   424,     0,     0,     0,   425,   426,   427,   428,
       0,   429,   430,     0,   431,   432,     0,   433,   434,     0,
       0,   435,     0,     0,   436,     0,   437,     0,   438,   439,
       0,     0,     0,     0,     0,     0,   440,     0,     0,   441,
       0,     0,     0,   442,   443,   444,   445,     0,     0,     0,
       0,   446,   447,     0,   448,   449,     0,   138,   450,   139,
     140,   141,   142,   143,     0,     0,     0,     0,     0,   144,
       0,     0,   145,     0,   146,   147,   148,   149,   150,   151,
     152,     0,   153,     0,     0,     0,   154,     0,     0,     0,
     155,     0,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,     0,     0,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,     0,   172,
     173,     0,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,     0,   183,   184,     0,   185,     0,     0,   186,
       0,     0,   187,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,     0,   192,
     193,     0,     0,     0,     0,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
     201,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,   206,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,   216,     0,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,     0,
       0,   225,     0,     0,     0,   226,   227,     0,   228,     0,
     229,     0,   230,   231,   232,   233,     0,   234,     0,     0,
       0,   235,   236,     0,   237,     0,     0,   238,   239,     0,
       0,     0,   240,   241,   242,   243,     0,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,     0,   248,   249,
       0,     0,     0,   250,     0,   251,   252,     0,   253,   254,
       0,     0,     0,   255,     0,     0,   256,   257,     0,     0,
     258,     0,     0,   259,   260,     0,     0,     0,     0,     0,
     261,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,     0,     0,     0,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,     0,   282,   283,   284,   285,     0,   286,   287,
     288,     0,     0,     0,   289,   290,   291,   292,   293,     0,
       0,   294,   295,     0,   296,     0,   297,     0,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,   306,   307,
       0,     0,   308,   309,   310,   311,     0,     0,     0,   312,
     313,     0,     0,     0,     0,   314,   315,   316,     0,   317,
     318,   319,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,   322,   323,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
       0,     0,   337,   338,   339,  2332,   340,     0,   341,   342,
     343,   344,     0,   345,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,   358,     0,   359,   360,   361,     0,
       0,   362,     0,   363,   364,   365,     0,   366,   367,     0,
       0,     0,   368,   369,   370,   371,   372,   373,   374,   375,
     376,     0,   377,   378,     0,     0,     0,   379,   380,   381,
     382,     0,     0,     0,   383,     0,     0,     0,   384,   385,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
       0,     0,     0,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,   398,   399,     0,     0,   400,   401,
       0,   402,   403,   404,   405,   406,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,     0,   413,   414,   415,
       0,     0,   416,   417,     0,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,     0,     0,
     425,   426,   427,   428,     0,   429,   430,     0,   431,   432,
       0,   433,   434,     0,     0,   435,     0,     0,   436,     0,
     437,     0,   438,   439,     0,     0,     0,     0,     0,     0,
     440,     0,     0,   441,     0,     0,     0,   442,   443,   444,
     445,     0,     0,     0,     0,   446,   447,     0,   448,   449,
       0,   138,   450,   139,   140,   141,   142,   143,  2656,     0,
       0,     0,     0,   144,     0,     0,   145,     0,   146,   147,
     148,   149,   150,   151,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,     0,     0,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,     0,   172,   173,     0,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,     0,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,   193,     0,     0,     0,     0,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,   201,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,   206,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,   216,
       0,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,     0,     0,   225,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,   235,   236,     0,   237,     0,
       0,   238,   239,     0,     0,     0,   240,   241,   242,   243,
       0,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,     0,   248,   249,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
     256,   257,     0,     0,   258,     0,     0,   259,   260,     0,
       0,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,   312,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,   319,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,     0,     0,   337,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,   358,     0,
     359,   360,   361,     0,     0,   362,     0,   363,   364,   365,
       0,   366,   367,     0,     0,     0,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,   377,   378,     0,     0,
       0,   379,   380,   381,   382,     0,     0,     0,   383,     0,
       0,     0,   384,   385,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,   398,   399,
       0,     0,   400,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,     0,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,   425,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,   435,
       0,     0,   436,     0,   437,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,     0,     0,   446,
     447,     0,   448,   449,     0,   138,   450,   139,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
     145,     0,   146,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,     0,   172,   173,     0,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,   193,     0,
       0,     0,     0,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,   201,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,   206,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,   216,     0,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,     0,     0,   225,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,   235,
     236,     0,   237,     0,     0,   238,   239,     0,     0,     0,
     240,   241,   242,   243,     0,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,   249,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,     0,     0,
       0,   255,     0,     0,   256,   257,     0,     0,   258,     0,
       0,   259,   260,     0,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,     0,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,   312,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,   319,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,     0,     0,
     337,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,   358,     0,   359,   360,   361,     0,     0,   362,
       0,   363,   364,   365,     0,   366,   367,     0,     0,     0,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
     377,   378,     0,     0,     0,   379,   380,   381,   382,     0,
       0,     0,   383,     0,     0,     0,   384,   385,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,   398,   399,     0,     0,   400,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,   135,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,   425,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,   433,
     434,     0,     0,   435,     0,     0,   436,     0,   437,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,     0,
       0,     0,     0,   446,   447,     0,   448,   449,     0,   138,
     450,   139,   140,   141,   142,   143,     0,     0,     0,     0,
       0,   144,     0,     0,   145,     0,   146,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
       0,   172,   173,     0,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,     0,   185,     0,
       0,   186,     0,     0,   187,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
       0,   192,   193,     0,     0,     0,  2167,   194,     0,   195,
       0,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,     0,   201,     0,     0,   202,   203,   204,     0,     0,
       0,   205,     0,   206,   207,     0,   208,   209,   210,     0,
       0,   211,     0,   212,   213,   214,   215,   216,     0,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,     0,     0,   225,     0,     0,     0,   226,   227,     0,
     228,     0,   229,     0,   230,   231,   232,   233,     0,   234,
       0,     0,     0,   235,   236,     0,   237,     0,     0,   238,
     239,     0,     0,     0,   240,   241,   242,   243,     0,     0,
     244,   245,     0,     0,   246,     0,   247,     0,     0,     0,
     248,   249,     0,     0,     0,   250,     0,   251,   252,     0,
     253,   254,     0,     0,     0,   255,     0,     0,   256,   257,
       0,     0,   258,     0,     0,   259,   260,     0,     0,     0,
       0,     0,   261,   262,     0,   263,     0,   264,     0,   265,
     266,     0,     0,     0,     0,     0,     0,     0,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,     0,   280,   281,     0,   282,   283,   284,   285,     0,
     286,   287,   288,     0,     0,     0,   289,   290,   291,   292,
     293,     0,     0,   294,   295,     0,   296,     0,   297,     0,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
     306,   307,     0,     0,   308,   309,   310,   311,     0,     0,
       0,   312,   313,     0,     0,     0,     0,   314,   315,   316,
       0,   317,   318,   319,     0,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,     0,     0,   337,   338,   339,     0,   340,     0,
     341,   342,   343,   344,     0,   345,   346,   347,     0,     0,
     348,     0,     0,     0,   349,   350,   351,   352,   353,     0,
       0,   354,   355,   356,     0,   357,   358,     0,   359,   360,
     361,     0,     0,   362,     0,   363,   364,   365,     0,   366,
     367,     0,     0,     0,   368,   369,   370,   371,   372,   373,
     374,   375,   376,     0,   377,   378,     0,     0,     0,   379,
     380,   381,   382,     0,     0,     0,   383,     0,     0,     0,
     384,   385,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,     0,     0,     0,     0,   393,   394,     0,   395,
       0,     0,   396,     0,     0,   397,   398,   399,     0,     0,
     400,   401,     0,   402,   403,   404,   405,   406,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,     0,   413,
     414,   415,     0,     0,   416,   417,     0,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
       0,     0,   425,   426,   427,   428,     0,   429,   430,     0,
     431,   432,     0,   433,   434,     0,     0,   435,     0,     0,
     436,     0,   437,     0,   438,   439,     0,     0,     0,     0,
       0,     0,   440,     0,     0,   441,     0,     0,     0,   442,
     443,   444,   445,     0,     0,     0,     0,   446,   447,     0,
     448,   449,     0,   138,   450,   139,   140,   141,   142,   143,
       0,     0,     0,     0,     0,   144,     0,     0,   145,     0,
     146,   147,   148,   149,   150,   151,   152,     0,   153,     0,
       0,     0,   154,     0,     0,     0,   155,     0,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
       0,     0,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,     0,   172,   173,     0,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,     0,   185,     0,     0,   186,     0,     0,   187,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,     0,   192,   193,     0,     0,     0,
       0,   194,     0,   195,     0,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,     0,   201,     0,     0,   202,
     203,   204,     0,     0,     0,   205,     0,   206,   207,     0,
     208,   209,   210,     0,     0,   211,     0,   212,   213,   214,
     215,   216,     0,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,     0,     0,   225,     0,     0,
       0,   226,   227,     0,   228,     0,   229,     0,   230,   231,
     232,   233,     0,   234,     0,     0,     0,   235,   236,     0,
     237,     0,     0,   238,   239,     0,     0,     0,   240,   241,
     242,   243,     0,     0,   244,   245,     0,     0,   246,     0,
     247,     0,     0,     0,   248,   249,     0,     0,     0,   250,
       0,   251,   252,     0,   253,   254,     0,     0,     0,   255,
       0,     0,   256,   257,     0,     0,   258,     0,     0,   259,
     260,     0,     0,     0,     0,     0,   261,   262,     0,   263,
       0,   264,     0,   265,   266,     0,     0,     0,     0,     0,
       0,     0,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,     0,   280,   281,     0,   282,
     283,   284,   285,     0,   286,   287,   288,     0,     0,     0,
     289,   290,   291,   292,   293,     0,     0,   294,   295,     0,
     296,     0,   297,     0,   298,   299,   300,   301,   302,   303,
     304,   305,     0,     0,   306,   307,     0,     0,   308,   309,
     310,   311,     0,     0,     0,   312,   313,     0,     0,     0,
       0,   314,   315,   316,     0,   317,   318,   319,     0,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,     0,     0,   337,   338,
     339,     0,   340,     0,   341,   342,   343,   344,     0,   345,
     346,   347,     0,     0,   348,     0,     0,     0,   349,   350,
     351,   352,   353,     0,     0,   354,   355,   356,     0,   357,
     358,     0,   359,   360,   361,     0,     0,   362,     0,   363,
     364,   365,     0,   366,   367,     0,     0,     0,   368,   369,
     370,   371,   372,   373,   374,   375,   376,     0,   377,   378,
       0,     0,     0,   379,   380,   381,   382,     0,     0,     0,
     383,     0,     0,     0,   384,   385,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,     0,     0,     0,     0,
     393,   394,     0,   395,     0,     0,   396,     0,     0,   397,
     398,   399,     0,     0,   400,   401,     0,   402,   403,   404,
     405,   406,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,     0,   413,   414,   415,     0,     0,   416,   417,
       0,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,     0,     0,   425,   426,   427,   428,
       0,   429,   430,     0,   431,   432,     0,   433,   434,     0,
       0,   435,     0,     0,   436,     0,   437,     0,   438,   439,
       0,     0,     0,     0,     0,     0,   440,     0,     0,   441,
       0,     0,     0,   442,   443,   444,   445,     0,     0,     0,
       0,   446,   447,     0,   448,   449,     0,   138,   450,   139,
     140,   141,   142,   143,     0,     0,     0,     0,     0,   144,
       0,     0,   145,     0,   146,   147,   148,   149,   150,   151,
     152,     0,   153,     0,     0,     0,   154,     0,     0,     0,
     155,     0,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,     0,     0,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,     0,   172,
     173,     0,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,     0,   183,   184,     0,   185,     0,     0,   186,
       0,     0,   187,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,     0,   192,
     193,     0,     0,     0,     0,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
     201,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,   206,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,   216,     0,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,  1636,   224,     0,
       0,   225,     0,     0,     0,   226,   227,     0,   228,     0,
     229,     0,   230,   231,   232,   233,     0,   234,     0,     0,
       0,   235,   236,     0,   237,     0,     0,   238,   239,     0,
       0,     0,   240,   241,   242,   243,     0,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,     0,   248,   249,
       0,     0,     0,   250,     0,   251,   252,     0,   253,   254,
       0,     0,     0,   255,     0,     0,   256,   257,     0,     0,
     258,     0,     0,   259,   260,     0,     0,     0,     0,     0,
     261,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,     0,     0,     0,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,     0,   282,   283,   284,   285,     0,   286,   287,
     288,     0,     0,     0,   289,   290,   291,   292,   293,     0,
       0,   294,   295,     0,   296,     0,   297,     0,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,   306,   307,
       0,     0,   308,  1637,   310,   311,     0,     0,     0,   312,
     313,     0,     0,     0,     0,   314,   315,   316,     0,   317,
     318,   319,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,   322,   323,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
       0,     0,   337,   338,   339,     0,   340,     0,   341,   342,
     343,   344,     0,   345,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,   358,     0,   359,   360,   361,     0,
       0,   362,     0,   363,   364,   365,     0,   366,   367,     0,
       0,     0,   368,   369,   370,   371,   372,   373,   374,   375,
     376,     0,   377,   378,     0,     0,     0,   379,   380,   381,
     382,     0,     0,     0,   383,     0,     0,     0,   384,   385,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
       0,     0,     0,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,   398,   399,     0,     0,   400,   401,
       0,   402,   403,   404,   405,   406,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,     0,   413,   414,   415,
       0,     0,   416,   417,     0,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,     0,     0,
     425,   426,   427,   428,     0,   429,   430,     0,   431,   432,
       0,   433,   434,     0,     0,   435,     0,     0,   436,     0,
     437,     0,   438,   439,     0,     0,     0,     0,     0,     0,
     440,     0,     0,   441,     0,     0,     0,   442,   443,   444,
     445,     0,     0,     0,     0,   446,   447,     0,   448,   449,
       0,   138,   450,   139,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,     0,     0,     0,   146,   147,
     148,   149,   150,   151,     0,     0,  -287,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,     0,     0,     0,     0,   162,  3546,     0,
     163,     0,   164,     0,     0,     0,     0,   167,   168,  3547,
     170,   171,     0,   172,   173,     0,     0,   175,     0,   177,
     178,   179,   180,     0,   181,   182,     0,     0,   184,     0,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,     0,     0,     0,     0,     0,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,     0,     0,     0,   202,   203,   204,
       0,  -257,  -257,   205,     0,  -257,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,     0,
       0,     0,   217,   218,   219,     0,     0,   220,   221,  3548,
     222,   223,   224,     0,     0,     0,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,     0,   236,     0,     0,     0,
       0,     0,   239,     0,     0,     0,   240,   241,   242,   243,
    3549,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,     0,   248,     0,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,  3550,     0,     0,   255,     0,     0,
       0,   257,     0,     0,   258,  3551,     0,   259,   260,     0,
       0,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,  -242,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,     0,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,  3552,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   322,   323,
     324,     0,     0,   326,   327,   328,     0,   330,   331,   332,
     333,   334,   335,     0,     0,     0,     0,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,     0,     0,
     359,     0,   361,  -242,     0,   362,     0,     0,   364,     0,
       0,   366,   367,  3553,     0,     0,     0,   369,   370,   371,
     372,   373,   374,     0,   376,     0,   377,     0,     0,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   383,     0,
       0,     0,   384,     0,   386,     0,     0,   388,     0,     0,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,     0,   399,
       0,     0,     0,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,     0,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,     0,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,     0,     0,     0,     0,   435,
       0,     0,   436,     0,     0,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,  -242,     0,   446,
       0,     0,   448,     0,     0,   138,   450,   139,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
       0,     0,   146,   147,   148,   149,   150,   151,     0,     0,
    -287,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,     0,     0,     0,
       0,   162,  3546,     0,   163,     0,   164,     0,     0,     0,
       0,   167,   168,  3547,   170,   171,     0,   172,   173,     0,
       0,   175,     0,   177,   178,   179,   180,     0,   181,   182,
       0,     0,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,     0,     0,
       0,     0,     0,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,     0,     0,
       0,   202,   203,   204,     0,  -278,     0,   205,     0,  -278,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,     0,     0,     0,   217,   218,   219,     0,
       0,   220,   221,  3548,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,     0,
     236,     0,     0,     0,     0,     0,   239,     0,     0,     0,
     240,   241,   242,   243,  3549,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,     0,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,  3550,     0,
       0,   255,     0,     0,     0,   257,     0,     0,   258,  3551,
       0,   259,   260,     0,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,  -242,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,     0,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,  3552,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   322,   323,   324,     0,     0,   326,   327,   328,
       0,   330,   331,   332,   333,   334,   335,     0,     0,     0,
       0,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,     0,     0,   359,     0,   361,  -242,     0,   362,
       0,     0,   364,     0,     0,   366,   367,  3553,     0,     0,
       0,   369,   370,   371,   372,   373,   374,     0,   376,     0,
     377,     0,     0,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   383,     0,     0,     0,   384,     0,   386,     0,
       0,   388,     0,     0,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,     0,   399,     0,     0,     0,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,     0,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,     0,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,     0,
       0,     0,     0,   435,     0,     0,   436,     0,     0,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,  -278,
       0,  -242,     0,   446,     0,     0,   448,     0,     0,   138,
     450,   139,   140,   141,   142,   143,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,   146,   147,   148,   149,
     150,   151,     0,     0,  -287,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,     0,     0,     0,     0,   162,  3546,     0,   163,     0,
     164,     0,     0,     0,     0,   167,   168,  3547,   170,   171,
       0,   172,   173,     0,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,     0,   184,     0,   185,     0,
       0,   186,     0,     0,   187,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
       0,   192,     0,     0,     0,     0,     0,   194,     0,   195,
       0,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,     0,     0,     0,     0,   202,   203,   204,     0,  -275,
       0,   205,     0,  -275,   207,     0,   208,   209,   210,     0,
       0,   211,     0,   212,   213,   214,   215,     0,     0,     0,
     217,   218,   219,     0,     0,   220,   221,  3548,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   226,   227,     0,
     228,     0,   229,     0,   230,   231,   232,   233,     0,   234,
       0,     0,     0,     0,   236,     0,     0,     0,     0,     0,
     239,     0,     0,     0,   240,   241,   242,   243,  3549,     0,
     244,   245,     0,     0,   246,     0,   247,     0,     0,     0,
     248,     0,     0,     0,     0,   250,     0,   251,   252,     0,
     253,   254,  3550,     0,     0,   255,     0,     0,     0,   257,
       0,     0,   258,  3551,     0,   259,   260,     0,     0,     0,
       0,     0,   261,   262,     0,   263,     0,   264,     0,   265,
     266,     0,     0,     0,     0,  -242,     0,     0,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,     0,   280,   281,     0,   282,   283,   284,   285,     0,
     286,   287,   288,     0,     0,     0,   289,   290,   291,   292,
     293,     0,     0,   294,   295,     0,   296,     0,   297,     0,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
     306,   307,     0,     0,   308,   309,   310,   311,     0,     0,
       0,     0,   313,     0,     0,     0,     0,   314,   315,   316,
       0,   317,   318,  3552,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   322,   323,   324,     0,
       0,   326,   327,   328,     0,   330,   331,   332,   333,   334,
     335,     0,     0,     0,     0,   338,   339,     0,   340,     0,
     341,   342,   343,   344,     0,   345,   346,   347,     0,     0,
     348,     0,     0,     0,   349,   350,   351,   352,   353,     0,
       0,   354,   355,   356,     0,   357,     0,     0,   359,     0,
     361,  -242,     0,   362,     0,     0,   364,     0,     0,   366,
     367,  3553,     0,     0,     0,   369,   370,   371,   372,   373,
     374,     0,   376,     0,   377,     0,     0,     0,     0,   379,
     380,   381,     0,     0,     0,     0,   383,     0,     0,     0,
     384,     0,   386,     0,     0,   388,     0,     0,   391,   392,
       0,     0,     0,     0,     0,     0,   393,   394,     0,   395,
       0,     0,   396,     0,     0,   397,     0,   399,     0,     0,
       0,   401,     0,   402,   403,   404,   405,   406,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,     0,   413,
     414,   415,     0,     0,   416,   417,     0,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
       0,     0,     0,   426,   427,   428,     0,   429,   430,     0,
     431,   432,     0,     0,     0,     0,     0,   435,     0,     0,
     436,     0,     0,     0,   438,   439,     0,     0,     0,     0,
       0,     0,   440,     0,     0,   441,     0,     0,     0,   442,
     443,   444,   445,  -275,     0,  -242,     0,   446,     0,     0,
     448,     0,     0,   138,   450,   139,   140,   141,   142,   143,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
     146,   147,   148,   149,   150,   151,     0,     0,  -287,     0,
       0,     0,   154,     0,     0,     0,   155,     0,     0,   156,
     157,   158,     0,   159,     0,     0,     0,     0,     0,   162,
    3546,     0,   163,     0,   164,     0,     0,     0,     0,   167,
     168,  3547,   170,   171,     0,   172,   173,     0,     0,   175,
       0,   177,   178,   179,   180,     0,   181,   182,     0,     0,
     184,     0,   185,     0,     0,   186,     0,     0,   187,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,     0,   192,     0,     0,     0,     0,
       0,   194,     0,   195,     0,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,     0,     0,     0,     0,   202,
     203,   204,     0,     0,     0,   205,     0,  3865,   207,     0,
     208,   209,   210,     0,     0,   211,     0,   212,   213,   214,
     215,     0,     0,     0,   217,   218,   219,     0,     0,   220,
     221,  3548,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   226,   227,     0,   228,     0,   229,     0,   230,   231,
     232,   233,     0,   234,     0,     0,     0,     0,   236,     0,
       0,     0,     0,     0,   239,     0,     0,     0,   240,   241,
     242,   243,  3549,     0,   244,   245,     0,     0,   246,     0,
     247,     0,     0,     0,   248,     0,     0,     0,     0,   250,
       0,   251,   252,     0,   253,   254,  3550,     0,     0,   255,
       0,     0,     0,   257,     0,     0,   258,  3551,     0,   259,
     260,     0,     0,     0,     0,     0,   261,   262,     0,   263,
       0,   264,     0,   265,   266,     0,     0,     0,     0,  -242,
       0,     0,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,     0,   280,   281,     0,   282,
     283,   284,   285,     0,   286,   287,   288,     0,     0,     0,
     289,   290,   291,   292,   293,     0,     0,   294,   295,     0,
     296,     0,   297,     0,   298,   299,   300,   301,   302,   303,
     304,   305,     0,     0,   306,   307,     0,     0,   308,   309,
     310,   311,     0,     0,     0,     0,   313,     0,     0,     0,
       0,   314,   315,   316,     0,   317,   318,  3552,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     322,   323,   324,     0,     0,   326,   327,   328,     0,   330,
     331,   332,   333,   334,   335,     0,     0,     0,     0,   338,
     339,     0,   340,     0,   341,   342,   343,   344,     0,   345,
     346,   347,     0,     0,   348,     0,     0,     0,   349,   350,
     351,   352,   353,     0,     0,   354,   355,   356,     0,   357,
       0,     0,   359,     0,   361,  -242,     0,   362,     0,     0,
     364,     0,     0,   366,   367,  3553,     0,     0,     0,   369,
     370,   371,   372,   373,   374,     0,   376,     0,   377,     0,
       0,     0,     0,   379,   380,   381,     0,     0,     0,     0,
     383,     0,     0,     0,   384,     0,   386,     0,     0,   388,
       0,     0,   391,   392,     0,     0,     0,     0,     0,     0,
     393,   394,     0,   395,     0,     0,   396,     0,     0,   397,
       0,   399,     0,     0,     0,   401,     0,   402,   403,   404,
     405,   406,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,     0,   413,   414,   415,     0,     0,   416,   417,
       0,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,     0,     0,     0,   426,   427,   428,
       0,   429,   430,     0,   431,   432,     0,     0,     0,     0,
       0,   435,     0,     0,   436,     0,     0,     0,   438,   439,
       0,     0,     0,     0,     0,     0,   440,     0,     0,   441,
       0,     0,     0,   442,   443,   444,   445,     0,     0,  -242,
       0,   446,     0,     0,   448,     0,     0,   138,   450,   139,
     140,   141,   142,   143,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,   146,   147,   148,   149,   150,   151,
       0,     0,  -287,     0,     0,     0,   154,     0,     0,     0,
     155,     0,     0,   156,   157,   158,     0,   159,     0,     0,
       0,     0,     0,   162,  3546,     0,   163,     0,   164,     0,
       0,     0,     0,   167,   168,  3547,   170,   171,     0,   172,
     173,     0,     0,   175,     0,   177,   178,   179,   180,     0,
     181,   182,     0,     0,   184,     0,   185,     0,     0,   186,
       0,     0,   187,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,     0,   192,
       0,     0,     0,     0,     0,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
       0,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,  -280,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,     0,     0,     0,   217,   218,
     219,     0,     0,   220,   221,  3548,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   226,   227,     0,   228,     0,
     229,     0,   230,   231,   232,   233,     0,   234,     0,     0,
       0,     0,   236,     0,     0,     0,     0,     0,   239,     0,
       0,     0,   240,   241,   242,   243,  3549,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,     0,   248,     0,
       0,     0,     0,   250,     0,   251,   252,     0,   253,   254,
    3550,     0,     0,   255,     0,     0,     0,   257,     0,     0,
     258,  3551,     0,   259,   260,     0,     0,     0,     0,     0,
     261,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,     0,     0,  -242,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,     0,   282,   283,   284,   285,     0,   286,   287,
     288,     0,     0,     0,   289,   290,   291,   292,   293,     0,
       0,   294,   295,     0,   296,     0,   297,     0,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,   306,   307,
       0,     0,   308,   309,   310,   311,     0,     0,     0,     0,
     313,     0,     0,     0,     0,   314,   315,   316,     0,   317,
     318,  3552,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   322,   323,   324,     0,     0,   326,
     327,   328,     0,   330,   331,   332,   333,   334,   335,     0,
       0,     0,     0,   338,   339,     0,   340,     0,   341,   342,
     343,   344,     0,   345,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,     0,     0,   359,     0,   361,  -242,
       0,   362,     0,     0,   364,     0,     0,   366,   367,  3553,
       0,     0,     0,   369,   370,   371,   372,   373,   374,     0,
     376,     0,   377,     0,     0,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   383,     0,     0,     0,   384,     0,
     386,     0,     0,   388,     0,     0,   391,   392,     0,     0,
       0,     0,     0,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,     0,   399,     0,     0,     0,   401,
       0,   402,   403,   404,   405,   406,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,     0,   413,   414,   415,
       0,     0,   416,   417,     0,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,     0,     0,
       0,   426,   427,   428,     0,   429,   430,     0,   431,   432,
       0,     0,     0,     0,     0,   435,     0,     0,   436,     0,
       0,     0,   438,   439,     0,     0,     0,     0,     0,     0,
     440,     0,     0,   441,     0,     0,     0,   442,   443,   444,
     445,     0,     0,  -242,     0,   446,     0,     0,   448,     0,
       0,   138,   450,   139,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,     0,     0,     0,   146,   147,
     148,   149,   150,   151,     0,     0,  -287,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,     0,     0,     0,     0,   162,  3546,     0,
     163,     0,   164,     0,     0,     0,     0,   167,   168,  3547,
     170,   171,     0,   172,   173,     0,     0,   175,     0,   177,
     178,   179,   180,     0,   181,   182,     0,     0,   184,     0,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,     0,     0,     0,     0,     0,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,     0,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,  3950,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,     0,
       0,     0,   217,   218,   219,     0,     0,   220,   221,  3548,
     222,   223,   224,     0,     0,     0,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,     0,   236,     0,     0,     0,
       0,     0,   239,     0,     0,     0,   240,   241,   242,   243,
    3549,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,     0,   248,     0,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,  3550,     0,     0,   255,     0,     0,
       0,   257,     0,     0,   258,  3551,     0,   259,   260,     0,
       0,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,  -242,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,     0,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,  3552,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   322,   323,
     324,     0,     0,   326,   327,   328,     0,   330,   331,   332,
     333,   334,   335,     0,     0,     0,     0,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,     0,     0,
     359,     0,   361,  -242,     0,   362,     0,     0,   364,     0,
       0,   366,   367,  3553,     0,     0,     0,   369,   370,   371,
     372,   373,   374,     0,   376,     0,   377,     0,     0,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   383,     0,
       0,     0,   384,     0,   386,     0,     0,   388,     0,     0,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,     0,   399,
       0,     0,     0,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,     0,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,     0,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,     0,     0,     0,     0,   435,
       0,     0,   436,     0,     0,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,  -242,     0,   446,
       0,     0,   448,     0,     0,   138,   450,   139,   140,   141,
     142,   143,     0,     0,     0,     0,     0,   144,     0,     0,
       0,     0,   146,   147,   148,   149,   150,   151,     0,     0,
    -287,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,     0,     0,     0,
       0,   162,  3546,     0,   163,     0,   164,     0,     0,     0,
       0,   167,   168,  3547,   170,   171,     0,   172,   173,     0,
       0,   175,     0,   177,   178,   179,   180,     0,   181,   182,
       0,     0,   184,     0,   185,     0,     0,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,     0,   192,     0,     0,
       0,     0,     0,   194,     0,   195,     0,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,     0,     0,     0,
       0,   202,   203,   204,     0,     0,     0,   205,     0,  3988,
     207,     0,   208,   209,   210,     0,     0,   211,     0,   212,
     213,   214,   215,     0,     0,     0,   217,   218,   219,     0,
       0,   220,   221,  3548,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   226,   227,     0,   228,     0,   229,     0,
     230,   231,   232,   233,     0,   234,     0,     0,     0,     0,
     236,     0,     0,     0,     0,     0,   239,     0,     0,     0,
     240,   241,   242,   243,  3549,     0,   244,   245,     0,     0,
     246,     0,   247,     0,     0,     0,   248,     0,     0,     0,
       0,   250,     0,   251,   252,     0,   253,   254,  3550,     0,
       0,   255,     0,     0,     0,   257,     0,     0,   258,  3551,
       0,   259,   260,     0,     0,     0,     0,     0,   261,   262,
       0,   263,     0,   264,     0,   265,   266,     0,     0,     0,
       0,  -242,     0,     0,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,     0,   280,   281,
       0,   282,   283,   284,   285,     0,   286,   287,   288,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,   296,     0,   297,     0,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,   306,   307,     0,     0,
     308,   309,   310,   311,     0,     0,     0,     0,   313,     0,
       0,     0,     0,   314,   315,   316,     0,   317,   318,  3552,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   322,   323,   324,     0,     0,   326,   327,   328,
       0,   330,   331,   332,   333,   334,   335,     0,     0,     0,
       0,   338,   339,     0,   340,     0,   341,   342,   343,   344,
       0,   345,   346,   347,     0,     0,   348,     0,     0,     0,
     349,   350,   351,   352,   353,     0,     0,   354,   355,   356,
       0,   357,     0,     0,   359,     0,   361,  -242,     0,   362,
       0,     0,   364,     0,     0,   366,   367,  3553,     0,     0,
       0,   369,   370,   371,   372,   373,   374,     0,   376,     0,
     377,     0,     0,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   383,     0,     0,     0,   384,     0,   386,     0,
       0,   388,     0,     0,   391,   392,     0,     0,     0,     0,
       0,     0,   393,   394,     0,   395,     0,     0,   396,     0,
       0,   397,     0,   399,     0,     0,     0,   401,     0,   402,
     403,   404,   405,   406,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,     0,   413,   414,   415,     0,     0,
     416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,     0,     0,     0,   426,
     427,   428,     0,   429,   430,     0,   431,   432,     0,     0,
       0,     0,     0,   435,     0,     0,   436,     0,     0,     0,
     438,   439,     0,     0,     0,     0,     0,     0,   440,     0,
       0,   441,     0,     0,     0,   442,   443,   444,   445,     0,
       0,  -242,     0,   446,     0,     0,   448,     0,     0,   138,
     450,   139,   140,   141,   142,   143,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,   146,   147,   148,   149,
     150,   151,     0,     0,  -287,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,     0,     0,     0,     0,   162,  3546,     0,   163,     0,
     164,     0,     0,     0,     0,   167,   168,  3547,   170,   171,
       0,   172,   173,     0,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,     0,   184,     0,   185,     0,
       0,   186,     0,     0,   187,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
       0,   192,     0,     0,     0,     0,     0,   194,     0,   195,
       0,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,     0,     0,     0,     0,   202,   203,   204,     0,     0,
       0,   205,     0,  -261,   207,     0,   208,   209,   210,     0,
       0,   211,     0,   212,   213,   214,   215,     0,     0,     0,
     217,   218,   219,     0,     0,   220,   221,  3548,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   226,   227,     0,
     228,     0,   229,     0,   230,   231,   232,   233,     0,   234,
       0,     0,     0,     0,   236,     0,     0,     0,     0,     0,
     239,     0,     0,     0,   240,   241,   242,   243,  3549,     0,
     244,   245,     0,     0,   246,     0,   247,     0,     0,     0,
     248,     0,     0,     0,     0,   250,     0,   251,   252,     0,
     253,   254,  3550,     0,     0,   255,     0,     0,     0,   257,
       0,     0,   258,  3551,     0,   259,   260,     0,     0,     0,
       0,     0,   261,   262,     0,   263,     0,   264,     0,   265,
     266,     0,     0,     0,     0,  -242,     0,     0,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,     0,   280,   281,     0,   282,   283,   284,   285,     0,
     286,   287,   288,     0,     0,     0,   289,   290,   291,   292,
     293,     0,     0,   294,   295,     0,   296,     0,   297,     0,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
     306,   307,     0,     0,   308,   309,   310,   311,     0,     0,
       0,     0,   313,     0,     0,     0,     0,   314,   315,   316,
       0,   317,   318,  3552,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   322,   323,   324,     0,
       0,   326,   327,   328,     0,   330,   331,   332,   333,   334,
     335,     0,     0,     0,     0,   338,   339,     0,   340,     0,
     341,   342,   343,   344,     0,   345,   346,   347,     0,     0,
     348,     0,     0,     0,   349,   350,   351,   352,   353,     0,
       0,   354,   355,   356,     0,   357,     0,     0,   359,     0,
     361,  -242,     0,   362,     0,     0,   364,     0,     0,   366,
     367,  3553,     0,     0,     0,   369,   370,   371,   372,   373,
     374,     0,   376,     0,   377,     0,     0,     0,     0,   379,
     380,   381,     0,     0,     0,     0,   383,     0,     0,     0,
     384,     0,   386,     0,     0,   388,     0,     0,   391,   392,
       0,     0,     0,     0,     0,     0,   393,   394,     0,   395,
       0,     0,   396,     0,     0,   397,     0,   399,     0,     0,
       0,   401,     0,   402,   403,   404,   405,   406,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,     0,   413,
     414,   415,     0,     0,   416,   417,     0,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
       0,     0,     0,   426,   427,   428,     0,   429,   430,     0,
     431,   432,     0,     0,     0,     0,     0,   435,     0,     0,
     436,     0,     0,     0,   438,   439,     0,     0,     0,     0,
       0,     0,   440,     0,     0,   441,     0,     0,     0,   442,
     443,   444,   445,     0,     0,  -242,     0,   446,     0,     0,
     448,     0,     0,   138,   450,   139,   140,   141,   142,   143,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
     146,   147,   148,   149,   150,   151,     0,     0,  -287,     0,
       0,     0,   154,     0,     0,     0,   155,     0,     0,   156,
     157,   158,     0,   159,     0,     0,     0,     0,     0,   162,
    3546,     0,   163,     0,   164,     0,     0,     0,     0,   167,
     168,  3547,   170,   171,     0,   172,   173,     0,     0,   175,
       0,   177,   178,   179,   180,     0,   181,   182,     0,     0,
     184,     0,   185,     0,     0,   186,     0,     0,   187,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,     0,   192,     0,     0,     0,     0,
       0,   194,     0,   195,     0,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,     0,     0,     0,     0,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   207,     0,
     208,   209,   210,     0,     0,   211,     0,   212,   213,   214,
     215,     0,     0,     0,   217,   218,   219,     0,     0,   220,
     221,  3548,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   226,   227,     0,   228,     0,   229,     0,   230,   231,
     232,   233,     0,   234,     0,     0,     0,     0,   236,     0,
       0,     0,     0,     0,   239,     0,     0,     0,   240,   241,
     242,   243,  3549,     0,   244,   245,     0,     0,   246,     0,
     247,     0,     0,     0,   248,     0,     0,     0,     0,   250,
       0,   251,   252,     0,   253,   254,  3550,     0,     0,   255,
       0,     0,     0,   257,     0,     0,   258,  3551,     0,   259,
     260,     0,     0,     0,     0,     0,   261,   262,     0,   263,
       0,   264,     0,   265,   266,     0,     0,     0,     0,  -242,
       0,     0,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,     0,   280,   281,     0,   282,
     283,   284,   285,     0,   286,   287,   288,     0,     0,     0,
     289,   290,   291,   292,   293,     0,     0,   294,   295,     0,
     296,     0,   297,     0,   298,   299,   300,   301,   302,   303,
     304,   305,     0,     0,   306,   307,     0,     0,   308,   309,
     310,   311,     0,     0,     0,     0,   313,     0,     0,     0,
       0,   314,   315,   316,     0,   317,   318,  3552,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     322,   323,   324,     0,     0,   326,   327,   328,     0,   330,
     331,   332,   333,   334,   335,     0,     0,     0,     0,   338,
     339,     0,   340,     0,   341,   342,   343,   344,     0,   345,
     346,   347,     0,     0,   348,     0,     0,     0,   349,   350,
     351,   352,   353,     0,     0,   354,   355,   356,     0,   357,
       0,     0,   359,     0,   361,  -242,     0,   362,     0,     0,
     364,     0,     0,   366,   367,  3553,     0,     0,     0,   369,
     370,   371,   372,   373,   374,     0,   376,     0,   377,     0,
       0,     0,     0,   379,   380,   381,     0,     0,     0,     0,
     383,     0,     0,     0,   384,     0,   386,     0,     0,   388,
       0,     0,   391,   392,     0,     0,     0,     0,     0,     0,
     393,   394,     0,   395,     0,     0,   396,     0,     0,   397,
       0,   399,     0,     0,     0,   401,     0,   402,   403,   404,
     405,   406,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,     0,   413,   414,   415,     0,     0,   416,   417,
       0,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,     0,     0,     0,   426,   427,   428,
       0,   429,   430,     0,   431,   432,     0,     0,     0,     0,
       0,   435,     0,     0,   436,     0,     0,     0,   438,   439,
       0,     0,     0,     0,     0,     0,   440,     0,     0,   441,
       0,     0,     0,   442,   443,   444,   445,     0,     0,  -242,
       0,   446,     0,     0,   448,     0,     0,   138,   450,   139,
     140,   141,   142,   143,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,   146,   147,   148,   149,   150,   151,
       0,     0,  -287,     0,     0,     0,   154,     0,     0,     0,
     155,     0,     0,   156,   157,   158,     0,   159,     0,     0,
       0,     0,     0,   162,  3546,     0,   163,     0,   164,     0,
       0,     0,     0,   167,   168,  3547,   170,   171,     0,   172,
     173,     0,     0,   175,     0,   177,   178,   179,   180,     0,
     181,   182,     0,     0,   184,     0,   185,     0,     0,   186,
       0,     0,   187,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,     0,   192,
       0,     0,     0,     0,     0,   194,     0,   195,     0,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,     0,
       0,     0,     0,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   207,     0,   208,   209,   210,     0,     0,   211,
       0,   212,   213,   214,   215,     0,     0,     0,   217,   218,
     219,     0,     0,   220,   221,  3548,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   226,   227,     0,   228,     0,
     229,     0,   230,   231,   232,   233,     0,   234,     0,     0,
       0,     0,   236,     0,     0,     0,     0,     0,   239,     0,
       0,     0,   240,   241,   242,   243,  3549,     0,   244,   245,
       0,     0,   246,     0,   247,     0,     0,     0,   248,     0,
       0,     0,     0,   250,     0,   251,   252,     0,   253,   254,
    3550,     0,     0,   255,     0,     0,     0,   257,     0,     0,
     258,  3551,     0,   259,   260,     0,     0,     0,     0,     0,
     261,   262,     0,   263,     0,   264,     0,   265,   266,     0,
       0,     0,     0,  -242,     0,     0,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,     0,
     280,   281,     0,   282,   283,   284,   285,     0,   286,   287,
     288,     0,     0,     0,   289,   290,   291,   292,   293,     0,
       0,   294,   295,     0,   296,     0,   297,     0,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,   306,   307,
       0,     0,   308,   309,   310,   311,     0,     0,     0,     0,
     313,     0,     0,     0,     0,   314,   315,   316,     0,   317,
     318,  3552,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   322,   323,   324,     0,     0,   326,
     327,   328,     0,   330,   331,   332,   333,   334,   335,     0,
       0,     0,     0,   338,   339,     0,   340,     0,   341,   342,
     343,   344,     0,   345,   346,   347,     0,     0,   348,     0,
       0,     0,   349,   350,   351,   352,   353,     0,     0,   354,
     355,   356,     0,   357,     0,     0,   359,     0,   361,  -242,
       0,   362,     0,     0,   364,     0,     0,   366,   367,  3553,
       0,     0,     0,   369,   370,   371,   372,   373,   374,     0,
     376,     0,   377,     0,     0,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   383,     0,     0,     0,   384,     0,
     386,     0,     0,   388,     0,     0,   391,   392,     0,     0,
       0,     0,     0,     0,   393,   394,     0,   395,     0,     0,
     396,     0,     0,   397,     0,   399,     0,     0,     0,   401,
       0,   402,   403,   404,   405,   406,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,     0,   413,   414,   415,
       0,     0,   416,   417,     0,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,     0,     0,
       0,   426,   427,   428,     0,   429,   430,     0,   431,   432,
       0,     0,     0,     0,     0,   435,     0,     0,  3868,     0,
       0,     0,   438,   439,     0,     0,     0,     0,     0,     0,
     440,     0,     0,   441,     0,     0,     0,   442,   443,   444,
     445,     0,     0,  -242,     0,   446,     0,     0,   448,     0,
       0,   138,   450,   139,   140,   141,   142,   143,     0,     0,
       0,     0,     0,   144,     0,     0,     0,     0,   146,   147,
     148,   149,   150,   151,     0,     0,     0,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,     0,     0,     0,     0,   162,     0,     0,
     163,     0,   164,     0,     0,     0,     0,   167,   168,     0,
     170,   171,     0,   172,   173,     0,     0,   175,     0,   177,
     178,   179,   180,     0,   181,   182,     0,     0,   184,     0,
     185,     0,     0,   186,     0,     0,   187,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,     0,   192,     0,     0,     0,     0,     0,   194,
       0,   195,     0,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,     0,     0,     0,     0,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   207,     0,   208,   209,
     210,     0,     0,   211,     0,   212,   213,   214,   215,     0,
       0,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,     0,     0,     0,     0,     0,     0,   226,
     227,     0,   228,     0,   229,     0,   230,   231,   232,   233,
       0,   234,     0,     0,     0,     0,   236,     0,     0,     0,
       0,     0,   239,     0,     0,     0,   240,   241,   242,   243,
       0,     0,   244,   245,     0,     0,   246,     0,   247,     0,
       0,     0,   248,     0,     0,     0,     0,   250,     0,   251,
     252,     0,   253,   254,     0,     0,     0,   255,     0,     0,
       0,   257,     0,     0,   258,     0,     0,   259,   260,     0,
       0,     0,     0,     0,   261,   262,     0,   263,     0,   264,
       0,   265,   266,     0,     0,     0,     0,     0,     0,     0,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,     0,   280,   281,     0,   282,   283,   284,
     285,     0,   286,   287,   288,     0,     0,     0,   289,   290,
     291,   292,   293,     0,     0,   294,   295,     0,   296,     0,
     297,     0,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,   306,   307,     0,     0,   308,   309,   310,   311,
       0,     0,     0,     0,   313,     0,     0,     0,     0,   314,
     315,   316,     0,   317,   318,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   322,   323,
     324,     0,     0,   326,   327,   328,     0,   330,   331,   332,
     333,   334,   335,     0,     0,     0,     0,   338,   339,     0,
     340,     0,   341,   342,   343,   344,     0,   345,   346,   347,
       0,     0,   348,     0,     0,     0,   349,   350,   351,   352,
     353,     0,     0,   354,   355,   356,     0,   357,     0,     0,
     359,     0,   361,     0,     0,   362,     0,     0,   364,     0,
       0,   366,   367,     0,     0,     0,     0,   369,   370,   371,
     372,   373,   374,     0,   376,     0,   377,     0,     0,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   383,     0,
       0,     0,   384,     0,   386,     0,     0,   388,     0,     0,
     391,   392,     0,     0,     0,     0,     0,     0,   393,   394,
       0,   395,     0,     0,   396,     0,     0,   397,     0,   399,
       0,     0,     0,   401,     0,   402,   403,   404,   405,   406,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
       0,   413,   414,   415,     0,     0,   416,   417,     0,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,     0,     0,     0,   426,   427,   428,     0,   429,
     430,     0,   431,   432,     0,     0,     0,     0,     0,   435,
       0,     0,   436,     0,     0,     0,   438,   439,     0,     0,
       0,     0,     0,     0,   440,     0,     0,   441,     0,     0,
       0,   442,   443,   444,   445,     0,     0,     0,     0,   446,
       0,     0,   448,     0,     0,     0,   450
};

static const short int yycheck[] =
{
       7,   527,   730,   527,   121,    21,   907,   548,   591,   942,
     600,   601,   823,    20,    30,  1087,    23,  1087,   631,   632,
      36,  1653,   636,   746,   561,    32,  1207,  1553,  1267,   873,
    1034,  2216,   849,  2286,  2492,    42,  2103,  1332,     7,   908,
     847,  1616,  2170,  2171,  2172,  1951,    53,  1110,  1025,  2544,
    1956,  1151,  2146,   616,  1117,   668,   873,  1931,  2593,  2177,
    2405,  2314,   477,   912,  2962,  2204,  1809,   874,  1058,   912,
    1356,  2181,  2182,  2935,   655,   688,   690,  1810,  1281,   693,
      23,  1814,  1807,     5,  1738,  1915,    93,   700,   701,   702,
    1348,  1915,  1825,  1807,  2161,  1298,  1790,   534,   605,  2391,
    2941,  2393,  1835,  2281,  2197,  1308,  1309,  2418,   115,    18,
     117,  2422,  2205,   120,   121,   122,    16,  2262,  3177,    18,
      15,    16,    33,  1338,   127,    58,    50,    71,  1118,  1119,
     137,    24,  1122,  1123,  1124,  1125,   719,  1127,  1128,  1129,
    1130,  1131,  1132,  1133,  1134,   708,   709,   710,   117,  2267,
      93,   120,  1410,  2255,    15,    16,  2729,   720,    29,    16,
    2262,  1652,  1904,  2265,   112,    15,    16,  2269,  1762,  1763,
    1679,  3174,   147,  2291,  2292,  2995,  2996,    96,    61,  2999,
      78,  2283,  2284,   157,  1878,  1779,  2245,  2246,  2395,  1883,
    1915,  2293,    20,   141,   137,  1889,  1890,  1781,  3018,  1893,
      18,  1915,  1796,  1797,  3024,    15,    16,   579,   875,    15,
      16,   748,  1753,    50,    11,   587,   588,  1799,  1812,  1813,
     112,  1815,    90,   112,  1818,  1819,  3550,  3551,  1822,    57,
      58,  2537,   141,  1827,  2649,    18,   145,  1831,  1832,  1833,
    1834,   141,  1933,   116,  1838,  1839,   145,  1841,  1348,   141,
    1431,   135,   141,  1847,    42,   183,  1850,  1851,  1852,  1853,
      63,    24,    66,   145,  3126,   183,    35,   205,   805,   135,
     345,    35,    33,     8,   328,    74,   175,    51,    15,    16,
     410,   175,    15,    16,    15,    16,    60,    18,   432,    57,
      58,    15,    16,   165,  1022,   294,    98,   315,    15,    16,
     131,   914,   124,  2362,  2363,  1899,  1900,  1901,  1902,  2258,
    1410,    15,    16,    20,    76,  2189,   113,   210,    15,    16,
      15,    16,   175,   251,   135,   175,    33,   145,    24,    15,
      16,    15,    16,   251,   361,  2370,  3339,    15,    16,   116,
      47,    12,    15,    16,   227,  1073,   141,   464,   141,  1077,
      57,    58,   392,   229,   399,    65,   335,   449,   175,  2531,
      12,   473,   145,   235,   432,   141,   219,    15,    16,   175,
    2249,   543,   280,   810,  3272,   531,   966,   749,   968,   969,
     562,   498,   361,    15,    16,    60,   175,    15,    16,  3209,
     470,   284,    15,    16,    15,    16,    15,    16,  3218,    65,
      62,   583,   499,  2861,    20,  3072,   208,   519,  3075,   383,
     582,   583,   205,   175,    15,    16,    45,    33,   498,   337,
     512,    15,    16,   468,   193,  1148,   582,   321,   336,   193,
     165,    47,   222,   222,  3184,    15,    16,   581,   215,  3280,
    2612,    57,    58,  1024,   262,   817,    60,   210,  2576,   344,
     245,  1320,   347,   583,   125,   327,  1037,   464,   175,   466,
     967,  2600,  3324,    15,    16,  1272,  2157,    60,  1275,   245,
     408,   293,   499,   125,   481,   196,  1283,   251,   485,  2664,
    2608,   499,    15,    16,   382,   244,   526,   494,   157,  1338,
     414,   498,   345,   500,   344,  1338,   171,   347,   497,   506,
     262,  2646,   556,  1310,  1311,   512,  1606,   525,   583,   437,
      15,    16,   129,   581,   210,  1332,  2210,   278,   349,   437,
     499,   284,  2667,  1781,  2249,   524,   314,   534,   535,  1732,
    1113,  3372,  2406,  2948,   344,  2249,   288,   347,   344,   415,
    2370,   347,   346,   311,  2646,   552,  2370,  3871,  3872,  1807,
     347,    15,    16,   421,   561,  2203,   563,   171,  1121,   441,
    1409,   190,  2769,   506,   936,  2667,  1409,   574,   575,   387,
    1856,   172,   579,  2879,  2268,  1138,  2270,   414,   585,   523,
     587,   588,   557,  2277,   387,   592,   593,   139,   284,    40,
     597,  1006,  1007,   361,  1584,  3130,  2290,  3656,   481,   602,
     607,  1578,  2296,  2297,   611,  1595,   575,   344,  1598,   583,
     347,   344,  1027,   344,   347,   408,   347,   550,  2312,  2313,
     344,  1036,  2364,   347,  3291,  1348,  3629,   344,   745,   428,
     347,   574,   328,  1048,  1049,  1050,   555,  2128,  1305,   510,
     344,   589,  1057,   347,  2228,  2370,  1904,   344,   655,   344,
     347,  3492,   347,   510,  2163,  2196,  2370,  1915,   344,   583,
     344,   347,   562,   347,   537,  2247,   344,    68,  2979,   347,
     581,   344,  2766,   568,   347,   559,  2550,  2551,    15,    16,
     589,  1781,  2276,  1898,   583,  3583,  2745,  1410,  3261,   589,
     583,   586,   494,   559,  2288,  2644,   344,   589,   373,   347,
     589,   529,  3013,  3014,    15,    16,   713,   568,   715,    61,
    3021,  2746,   344,  2404,   383,   347,   344,  3028,   568,   347,
    3540,   344,  3542,   344,   347,   344,   347,   510,   347,  2361,
     499,   848,   739,   740,   741,   499,   743,   744,   745,  1276,
     747,   748,   749,   344,   126,  2873,   347,   565,   559,  1256,
     344,   130,   473,   347,  2633,  3596,    15,    16,   568,   373,
     537,  1198,   568,   473,   344,   560,   583,   347,    15,    16,
    3520,   740,   582,   583,  2368,   744,   582,   784,   747,    15,
      16,   477,  2876,  2911,   560,  1157,  2925,   449,   795,  1226,
    2929,  2969,   344,   583,   589,   347,   589,   426,   805,   806,
    2945,   560,   395,   810,  1904,  3703,   543,   473,   339,    99,
     817,   344,   102,   589,   347,  1915,    15,    16,  1342,   587,
    2887,    50,   529,   440,  3169,    15,    16,    15,    16,   581,
      54,   568,  2925,    15,    16,   568,  2929,   568,  1210,   344,
     113,   848,   347,  2945,   568,  3665,   583,  3667,    12,   582,
     583,   568,   795,  1225,   170,    22,   157,   532,   582,   583,
     556,    15,    16,   806,   568,    77,   583,   170,   262,    15,
      16,   568,   541,   568,  3541,   227,  3543,   799,   582,   583,
     344,    93,   568,   347,   568,  1729,   583,   582,   583,   205,
     568,   213,  1825,  3734,   178,   568,   582,   583,  2772,   583,
     222,   908,   205,    56,   582,   583,    15,    16,  2633,   582,
     583,   176,  1729,   529,  1758,  1722,  2746,  3452,   532,  2633,
     568,  1502,  2746,   305,  1731,   359,  1363,  1734,  1735,   936,
      15,    16,   939,   940,   432,   583,   568,   553,  2592,   126,
     568,  1758,  2181,  2182,   416,   568,  3700,   568,   221,   568,
    3812,   583,   178,  2601,  2602,   583,   261,  3067,   151,   334,
     583,   125,   583,   364,   583,   581,  2709,   568,    15,    16,
    2228,   323,    15,    16,   568,   145,   377,  2710,    15,    16,
     987,   582,   989,  1100,  3276,   152,  2049,  2190,   568,   583,
    1980,  2249,   143,   387,   112,   245,  3341,   940,    15,    16,
     600,   601,   172,   583,   157,    15,    16,   344,   161,    31,
     347,   208,  1602,  1554,    15,    16,   568,  1024,   469,   172,
    1137,  2746,  3161,  3162,   278,   470,  3154,  2208,   350,  2661,
    1037,  2317,  2746,   344,  1597,   568,   347,   488,    66,    15,
      16,    15,    16,   789,   987,    41,   989,    15,    16,  1898,
     583,  2055,  2056,   432,   201,  1898,   203,   588,  1781,   210,
    2934,   246,   513,   568,   249,   593,    10,    15,    16,    15,
      16,  2048,   563,  3971,  2146,  1612,  2146,   160,   583,   138,
    1087,  2058,   383,   581,  3181,   344,   245,   210,   347,   148,
     491,   375,   357,  1100,  3589,   345,  2671,   344,   327,  1216,
     347,   543,   407,   327,   568,   280,  2364,   364,   344,    15,
      16,   347,  2370,   514,    15,    16,   588,   469,   305,   583,
    2870,   149,    15,    16,  1661,  1662,    15,    16,  2228,   481,
    1137,   315,    15,    16,  2206,  1142,  2206,   432,   134,   292,
    1147,   583,    15,    16,  2439,   344,   892,   581,   347,   375,
    1157,  3609,    15,    16,   344,  3517,   344,   347,   603,   347,
    3695,   336,   344,   432,    24,   347,  1690,   229,  3922,   160,
    3076,   565,    15,    16,    15,    16,   427,   328,   240,    15,
      16,  1904,   375,   448,  3278,   414,   345,  1194,  2938,  1196,
     344,  1198,  1915,   347,   576,   577,   578,   579,   344,   384,
     222,   347,   581,  1210,  1147,   328,   585,   151,   583,  1216,
     494,   440,   330,   503,   566,   743,   506,   342,  1225,  1226,
      15,    16,   244,  2295,   259,  2295,   542,  2408,  1345,  1236,
     383,   568,    15,    16,   360,   344,   113,  1244,   347,   542,
     541,   324,   325,   314,    15,    16,   583,   330,    15,    16,
    1257,  1258,  1259,  1260,  1261,  1262,   561,   568,   109,   344,
     582,   112,   347,   175,  2364,   336,  1273,  1274,   494,  1276,
    2370,   441,   583,  3808,   467,  1282,   402,  1199,  3375,  3376,
      15,    16,   583,   143,   343,   128,   581,   109,  1257,  1258,
    1259,  3653,  1261,   432,   327,  1302,   331,   344,   479,   480,
     347,   344,   483,   484,   347,  1274,   487,   344,   489,   568,
     347,   491,   581,  1282,   494,   499,   167,  1260,   346,  1262,
     355,   568,   515,  2256,   583,  2258,   477,   344,   432,  1251,
     347,   499,   568,   245,   344,   935,   583,   347,  1345,   330,
     256,   525,   193,   344,   221,   167,   347,   583,    15,    16,
     210,   449,  1359,   315,   477,    19,  1363,   419,   205,  1302,
    3454,   278,   555,   432,   494,    15,    16,   400,   344,   568,
     344,   347,   531,   347,   396,  2633,   344,   364,   568,   347,
     568,   114,  3288,   510,   583,   985,   568,   574,   575,   576,
     577,   578,   579,   583,   310,   583,   344,   581,   344,   347,
     582,   347,    15,    16,     0,   556,   581,  1414,   259,  1416,
    1417,  1418,  1419,  1420,   568,   262,  1359,   141,   109,   587,
    3436,  1428,   568,  1430,   284,  2488,   447,  3494,   582,  1351,
     583,   375,   583,   556,   517,   370,   582,   259,   344,   498,
    1362,   347,   581,   344,    69,   172,   347,  1416,  1417,  1418,
     533,   344,   520,   117,   347,   344,   583,   583,   347,   568,
    2532,   344,  2532,   251,   347,   382,    15,    16,   328,    12,
     186,   344,   543,   582,   347,   543,   167,   581,   432,   145,
     331,   344,   109,   568,   347,    15,    16,   522,  2746,  2052,
     114,    15,    16,    15,    16,  1502,  1503,   582,    15,    16,
    1617,   344,   193,   344,   347,  2228,   347,   186,   344,   331,
     201,   347,   581,   229,   535,   110,    15,    16,   473,   422,
    3978,   568,    12,   467,  2114,   568,   517,   254,   325,   262,
    2520,   568,   449,   109,  3550,  3551,   383,   499,    12,   582,
     167,   329,   533,  1958,  3176,   582,   171,    15,    16,   344,
     571,   568,   347,    15,    16,  1562,  1971,   473,   568,    15,
      16,   344,   190,   525,   347,   582,   193,   568,   259,   750,
     194,   515,   582,   344,   371,   213,   347,   344,    15,    16,
     347,   582,   125,   208,   222,  3713,  3839,    15,    16,  2004,
    3183,   167,   568,   496,   568,   145,   551,  1604,    15,    16,
     568,   113,    15,    16,   232,  1612,   582,   232,   582,   344,
    1617,   555,   347,   494,   582,   122,  1623,   477,  1625,   581,
     568,   190,   568,  1630,  1631,   220,  1633,   581,  3746,   345,
     137,   585,   259,  3226,   582,   125,   582,   540,   262,  1646,
     331,  2364,  1649,    15,    16,   151,  2746,  2370,    15,    16,
    2065,   125,   555,   175,  1661,  1662,  1663,  1664,    15,    16,
     582,   583,   568,   232,  1671,  1672,  1673,   568,   208,    15,
      16,   522,  3688,  3689,   588,   568,   582,   344,    89,   568,
     347,   582,  1689,   259,    89,   568,   510,  1630,  1631,   582,
    1633,  1698,   232,   582,   344,   568,   556,   347,  3883,   582,
     522,     8,    16,  1646,   331,   568,  1649,    24,   575,   582,
     491,  2644,   350,   494,   472,   582,    15,    16,   476,   582,
    1663,  1664,    29,   583,   204,   568,  1733,   568,  1671,  1672,
    1673,   344,   568,  2544,   347,   360,    69,  1659,  1745,  2583,
     186,   582,    15,    16,   494,  1752,   582,  1669,   373,   581,
     222,  2275,  3644,    70,  3646,   331,   588,   387,   231,   540,
    3776,    16,   175,    95,   324,   325,  2583,   466,   126,   241,
     496,  1693,  2776,   568,   208,  3791,   406,  2710,  3472,  3473,
    3474,  3475,   266,   267,  2591,   568,   485,   582,   204,  3805,
    1733,  2795,  2796,   109,   389,   344,  1913,   568,   347,   582,
     211,   568,   186,   924,   925,   435,   211,   339,  2880,  1752,
    2880,   582,  2816,   550,   344,   582,   553,   347,   229,   151,
     344,   219,   344,   347,   229,   347,   143,   344,  3067,   240,
     347,   522,   459,   568,  1951,   240,    95,   175,   171,  1956,
     961,   158,  1849,  3859,  1766,   344,   178,   582,   347,    57,
      58,   167,   581,  1775,  1776,  3871,  3872,  1864,    66,   588,
      46,  2933,   562,  2933,  1786,  1787,  1788,  1789,  1875,  1791,
    1792,   126,   582,   583,   262,   208,   344,   193,   582,   347,
     315,    73,   344,    75,   479,   347,   582,   583,   344,   502,
    3906,   347,  2964,   210,  2964,   522,    24,   582,   583,   232,
    3916,   568,   588,   314,  2494,    12,  1913,   344,    18,   314,
     347,  1918,  3438,   397,   398,   582,   344,   538,   568,   347,
     112,  1928,  1929,   341,  2041,   467,  3942,   344,  3944,   581,
     347,   344,   582,   171,   347,     6,   195,   408,  3954,   581,
      70,   133,    70,   259,  1951,    11,   522,   305,  3964,  1956,
    3966,   583,  3968,   499,     6,   568,  2073,  1879,  1880,  3975,
    1882,   581,  1884,  1885,  1886,  1887,  1888,   284,  3984,  1891,
    1892,   581,   344,   581,   166,   347,  3157,   344,  3610,    89,
     347,   575,   581,  3999,  4000,  1928,  1929,   344,   582,   581,
     347,  1183,  2529,   581,  1186,   581,  3590,  1189,   344,  4015,
    4016,   347,    70,    55,  4020,   322,   529,   530,   419,   532,
     581,   328,  3706,   143,   419,   331,   581,  2985,   125,   568,
    2988,  2989,  3616,  2746,   581,  3619,  3620,  3621,  3622,  3033,
     158,   141,   432,   582,  2041,   145,  2573,  3005,   568,    16,
     373,   582,   583,   375,   568,   344,   568,   520,   347,   588,
     305,   568,   582,  3125,  2171,  3125,  2173,  2174,   582,  2066,
     170,   581,   172,   581,   499,   582,  2073,   478,  2483,   568,
     543,   344,   581,   478,   347,   154,   186,   129,    20,   581,
     210,   191,   210,   582,   581,   443,   444,   194,   581,   562,
     525,    33,   351,   581,  3726,   205,  2651,   336,  2215,  2216,
     568,   211,   361,   582,   583,    47,   568,    33,   367,   219,
      15,    16,   568,   477,   582,    57,    58,   582,   583,   229,
     582,   109,  2129,   581,   112,   422,   582,  2682,  3722,  3723,
     240,   568,    58,   582,   583,   245,   581,  3731,  2693,  2146,
     568,  2696,   210,    11,   254,   582,   581,   547,   548,   126,
     581,   568,   582,   583,   582,   568,   284,  2164,  2165,   581,
     477,   353,   494,   543,  2171,   582,  2173,  2174,   374,  2286,
     582,   583,   581,    99,   342,   586,   102,    57,    58,   167,
      70,   581,   581,   515,   110,   582,   583,   581,   443,   444,
     581,    81,   322,   452,   322,   581,   568,  2314,   328,  2206,
     328,   568,   394,   502,   314,   193,   522,   581,  2215,  2216,
     582,   568,   581,  3082,   336,   582,   574,   575,   576,   577,
     578,   579,   568,   555,    12,   582,   336,    95,   581,   502,
     581,    60,   582,   583,   581,   345,   582,   581,    31,   556,
      69,  2257,  2164,   582,   583,   113,   582,   583,  2255,   432,
    2266,    80,   581,    41,   322,  2262,  2272,   440,  2265,   581,
     328,   581,  2269,   393,  2271,   375,   583,  3961,   581,   568,
     581,   259,   581,   325,  2281,   581,  2283,  2284,  2294,  2286,
     581,   540,   582,   583,  2300,   581,  2293,   581,  2295,   581,
    2306,  2307,    18,    30,    82,   568,   581,   184,  2305,    87,
     541,   542,   581,   544,   581,   546,   581,  2314,   109,   419,
     178,   582,   583,   581,  2321,  2322,   581,   572,   573,   574,
     575,   576,   577,   578,   579,   393,   582,   583,   305,   581,
     440,    25,   581,   126,   386,    72,   388,   205,   582,   583,
    2903,   581,   171,   331,   234,   582,   583,   477,   177,   477,
     581,  2273,  2274,   581,   461,   462,   463,   464,   465,   466,
     582,   583,  2305,    89,   547,   548,   167,   581,   478,   582,
     583,   478,    66,   582,   583,     3,    70,  2299,   581,   208,
     581,     9,    10,  2390,  2391,   582,   583,   255,   581,  2804,
     316,   581,   193,   581,   281,   282,   581,   527,   581,   286,
     287,    29,   139,   232,   582,   583,   109,    35,   581,   477,
     581,    39,   581,   303,  1631,   141,  1633,   581,   112,   145,
     581,   531,   582,   583,   582,   583,   556,  2842,   556,   222,
     107,   581,   542,   543,  3367,  3368,   224,   327,  2360,   582,
     583,  2506,  2507,  2508,   582,   583,   172,  2390,   582,   583,
     560,   244,   562,   583,  1671,  1672,  1673,   581,   259,   527,
     186,  3051,   583,    56,   167,   191,   443,   444,   582,   583,
     582,   583,   582,   583,   582,   583,   586,   582,   583,   589,
     491,  2546,  2547,  2548,   205,   211,   582,   583,   556,   582,
     583,  3481,   453,   219,    48,   385,  2503,   174,  2505,  2506,
    2507,  2508,   130,   229,   175,   293,   256,   375,    48,  2516,
     582,   583,   305,    70,   240,   336,    35,   582,   583,   245,
     583,   447,  2529,   200,    81,  2532,   582,   583,   254,   427,
     331,   324,   325,   531,   522,  3607,  3405,   576,   232,  2546,
    2547,  2548,  3411,   150,   373,   582,   583,  2664,   440,  3073,
     135,   136,  2559,   582,   583,   519,   259,   581,  2565,   245,
    2567,  1074,  1075,   120,   157,   353,  2573,   172,   161,    89,
     438,  3724,  3725,  2516,   473,  3381,  3382,   467,   473,   172,
     506,  2889,  2890,   102,    95,  2851,  2852,   529,   314,   473,
     109,   278,   999,  1000,  1001,   572,   573,   574,   575,   576,
     577,   578,   579,   396,  1011,  3108,  3109,   549,   550,   535,
     336,   256,   491,   142,    79,   583,   338,   487,   295,   345,
     582,   112,   299,    89,   492,    98,   494,   456,   331,   306,
     324,   325,   587,   370,     6,  1042,   330,  2559,  1045,  2646,
     581,   160,   336,    97,  2651,     4,   431,   555,   167,   375,
     443,   444,    54,   400,   391,   154,    98,  2664,  1065,  1066,
    2667,   454,  1069,   202,   583,   178,   177,   455,   178,   583,
     588,    66,    12,   559,   193,  2682,   582,   234,   582,   373,
     499,  1088,  1089,   420,   125,     9,  2693,   583,   588,  2696,
     581,   211,   244,   419,   582,   588,   143,   208,   583,   292,
     488,  2708,    48,   532,   381,  3203,  3204,   582,   562,   229,
    2717,   588,   583,  2720,   440,   587,   491,  2724,  3216,   581,
     240,   522,   278,  2730,  3222,   251,   583,  2734,   278,  3719,
    2737,   583,   359,    15,    16,   472,  3689,  2744,  3328,  3811,
     259,   510,   436,  2665,   255,   211,   303,  3245,   583,  2756,
    3248,  2673,   478,   430,   510,   583,  2763,   583,   126,   145,
     146,  2730,   222,   229,  3378,  3379,  3380,   324,   325,   583,
     327,   576,   172,   223,   240,  2892,   489,  2720,  3589,   572,
     573,   574,   575,   576,   577,   578,   579,   162,   172,   583,
     383,  2908,   536,   179,   314,   451,   315,  3666,   362,   583,
     121,   336,   188,   126,  3417,   531,   583,   326,   581,   583,
     582,   330,   331,    25,    26,   145,   336,   543,  2883,   522,
    2763,   103,   104,   105,   106,   107,   145,   145,   385,  2836,
     145,  3821,   145,   145,   560,   145,   562,  2844,   532,   225,
     145,   145,   145,   145,   145,    57,    58,    59,   314,   145,
     236,   145,   145,   145,    66,   583,   582,   583,    70,   538,
     586,  2868,   490,   589,   564,   336,    78,   542,  3737,  3738,
     336,  3740,    46,  2880,  2881,   583,  2883,   263,   178,   576,
     508,   558,   583,   582,   175,  2892,    98,   515,   175,   582,
     582,  2898,    70,   570,   582,   441,  3886,   582,  3439,   419,
     112,  2908,   582,   115,   582,   575,  3859,   581,   536,  2916,
     467,   583,   579,   582,    95,   197,   198,   199,   200,   582,
      98,   582,  2844,   582,    60,  3538,  2933,   438,   582,   477,
     119,   143,   318,    69,   583,   582,   582,   305,  2945,   582,
     581,  4013,   581,  4013,    80,   456,  2953,   581,  2955,   582,
     387,   583,   560,   419,   209,   503,   581,  2964,   478,  3076,
     483,  3487,  2969,   581,  4036,   143,  2973,   184,   588,   175,
     151,   582,  4044,   449,  4044,  3844,   382,  3846,  3847,   440,
     499,   492,   305,   494,   503,   496,   583,   506,   145,  3942,
     172,  3944,   583,    46,    69,   312,   208,   178,   517,   467,
     467,   431,   360,   522,   216,   467,   525,   196,   165,   467,
     467,  3964,   478,   295,   510,   297,   298,   299,   360,   231,
     121,   532,   179,  3140,   306,   360,   230,   208,  1435,   540,
     208,   188,   230,   492,   121,   171,   492,    46,   360,   403,
     360,   177,   358,   581,   255,   543,  3999,  4000,   582,   360,
     139,   360,   588,   218,   582,   574,   575,   218,  3065,   583,
     582,   588,   344,   588,   582,   347,   582,   256,   616,  3076,
     582,   283,   208,   621,   255,   443,   444,   582,   235,   236,
     588,   588,   254,   510,   588,   588,   510,   510,   300,   278,
     499,   583,   251,   565,    46,   581,   232,  1504,  3624,   381,
     510,  1508,   581,   651,   342,   283,   263,  3224,   175,   175,
    4011,   175,  3702,  3120,   219,   175,  3038,  3700,  3125,   667,
     443,   444,   300,   226,  1531,   588,   562,   229,   331,   229,
     348,   583,   296,  3140,  3056,   588,    98,    98,   232,   232,
     352,   581,   354,   588,   322,    25,    26,   429,   430,   361,
     103,   104,   105,   106,   107,   510,   581,   583,   341,   186,
     708,   709,   710,   711,   321,   582,   499,   416,   336,   581,
     360,  3288,   720,  3189,  3181,   126,   345,    57,    58,    59,
     576,   220,   581,   581,   220,   374,    66,   588,   582,   370,
      70,   582,   582,   382,   375,   582,   576,   582,    78,   582,
     582,   336,   581,   205,   572,   573,   574,   575,   576,   577,
     578,   579,   424,   246,   360,   372,   582,  3224,    98,   588,
     583,   583,   582,   412,   360,   175,   222,  3344,   242,   126,
     537,    66,   112,   583,  3156,   115,   266,   373,   229,   229,
     336,   371,  3249,   232,   197,   198,   199,   200,   232,  3256,
     573,   574,   575,   576,   577,   578,   579,   438,   583,   336,
     449,    70,   336,   143,  3271,   477,    18,   336,   428,   583,
      46,   222,   245,   581,   453,   581,   558,   432,   434,   331,
     492,  3288,   331,   495,   473,   582,   568,   569,   570,  3813,
     562,   132,   582,   582,   238,   583,   186,   442,   581,   477,
    4028,   513,   491,  3225,   581,   494,   145,   582,   520,   229,
     229,   492,   583,   581,   492,   496,   112,   112,   582,   531,
     456,   581,   581,  3330,   369,   222,   588,   581,   208,   581,
     581,   581,    74,   449,   515,   128,   216,  3344,  3260,  3922,
     453,  3931,   295,   582,   297,   298,   299,   583,   582,   582,
      18,   231,   582,   306,   305,    33,  3363,   582,   582,   540,
     582,   302,   234,   382,   244,   562,   219,   582,  3375,  3376,
     583,   583,   581,   581,   555,   582,    46,   191,   588,   302,
     387,   583,   499,   331,   499,  3392,   581,   581,   581,   543,
    3980,   543,   331,   581,   581,   943,   532,   331,   537,   112,
     553,   232,  3928,   283,   553,   232,   330,   582,   305,   331,
     331,   581,   583,   331,   331,   331,   331,   302,   156,   499,
     300,  4004,   264,   265,   266,   267,   268,   269,   381,   271,
     272,   273,   274,   275,   276,   277,   499,   279,   499,   547,
    3447,  3448,   232,    68,   582,   582,    16,   995,   996,   219,
    3457,   543,   543,   582,   582,  4038,  1004,  1005,  1006,  1007,
    1008,  1009,  1010,   582,   326,   548,   471,  1015,   582,   416,
    1018,  1019,   352,  1021,   354,  1023,   429,   430,   582,  1027,
     562,   361,  1030,  1031,  1032,  1033,   583,  1035,  1036,   537,
     342,   331,   443,   444,   582,  1043,  1044,   582,  1046,  1047,
    1048,  1049,  1050,   582,  1052,  3448,  1054,  1055,  1056,  1057,
    1058,  1059,  1060,  1061,  1062,  1063,  1064,   494,   482,  1067,
    1068,   247,  1070,   267,  1072,   581,   581,   172,  1076,   140,
    1078,  1079,    30,   559,   581,   172,   590,   356,   582,   582,
    3547,   582,  1090,  1091,   424,  3552,   443,   444,  1096,   581,
     121,  1099,   501,   121,   143,   397,   398,   581,  1106,  1107,
    1108,    46,  1110,   375,    46,   138,    46,   145,     5,  1117,
    1118,  1119,   395,  1121,  1122,  1123,  1124,  1125,   559,  1127,
    1128,  1129,  1130,  1131,  1132,  1133,  1134,   175,    30,  3776,
    1138,  1139,    60,   342,    60,   128,   583,   477,    46,    35,
    3607,  3608,   582,    46,  3791,   558,  3613,   483,    46,   581,
    3727,    46,   492,    46,   503,   495,   569,   570,  3805,   219,
     139,   572,   573,   574,   575,   576,   577,   578,   579,   589,
     342,   342,   120,   513,    16,   581,   139,  3644,   204,  3646,
     520,  3648,   261,   134,   589,   559,   111,   590,   270,   582,
     582,   531,   581,    52,   582,   582,   425,  3664,   589,   145,
     139,   189,    52,   589,   502,  3608,   102,   407,   172,   205,
     583,   583,   582,   109,  3681,   572,   573,   574,   575,   576,
     577,   578,   579,   583,   502,   172,   561,   112,   172,   331,
     581,   548,   247,   440,  3557,   173,  1244,  3044,  2077,  1894,
    2244,   581,   601,  3049,  1252,  3443,  3580,  3800,  3879,  3268,
    3271,  4038,  3446,  3992,  3436,  4001,   921,  3436,  3436,  3906,
    3727,  3436,  3839,  3436,   160,  3436,  3903,  3436,  3735,  3916,
    3436,   167,   621,  3436,  3436,  3769,  3903,  3436,  3872,  3795,
     959,  3794,  3436,  3436,  1354,  1606,  2298,  1356,  3453,  2521,
    3717,  2868,  3481,  3613,  3122,  3886,  3893,   193,  3821,  3928,
    3624,  1409,   651,  3059,   474,  1856,  3883,  3954,  3371,  2749,
    2973,  2324,  2391,  2260,  3891,  1864,  2953,  2996,   667,  3966,
    2996,  3968,  3188,  3029,  3233,  3403,  3224,  3652,  3975,  2908,
    3395,  2957,  1423,  3663,  3526,  3593,  3457,  3984,  3411,  3721,
    1926,  1863,  2317,  2955,  3811,  1740,  3193,  2141,  1317,  2954,
    1405,  2516,  1663,   940,  2155,  2108,   547,   835,  1678,  3489,
    2844,  2494,   711,   259,  1957,  2207,  2923,  3510,  4015,  4016,
    3370,  3854,  3839,  4020,  3855,  2737,  1037,  3364,  1075,  2059,
    2964,  3980,  3344,  2313,  1011,  3725,  1929,  3854,  3855,    12,
      13,  1198,  2160,  1226,  2104,  2145,  2875,  3125,  2874,  2933,
    4036,  3811,   537,  1428,   612,  1935,  1730,    13,    14,   527,
    1622,  2708,  1265,  2857,  1231,  3924,  3883,  3955,  3638,   315,
    4044,  3226,    28,  2880,  3891,  3744,  1684,  2575,    34,  2916,
    1244,  3151,  3352,  1441,   330,   331,  1649,  1234,   519,  3470,
    1414,  3908,    48,    49,  3826,  3827,  1191,   818,  3915,    55,
    2503,  3476,   520,    59,    60,  4032,   822,  2035,  1095,  2473,
     470,   470,   601,    -1,   601,    88,    72,   601,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,  3965,    -1,
      -1,    -1,   108,  3970,    -1,    -1,   129,    -1,    -1,    -1,
     116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,    -1,    -1,    -1,    -1,   151,    -1,
     153,    -1,  1540,  1541,  1542,    -1,    -1,  4004,    -1,    -1,
      -1,   164,    -1,    -1,    -1,    -1,  4013,   153,  1556,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   184,    -1,   169,    -1,  4032,    -1,    -1,    -1,  4036,
    1578,  4038,    -1,    -1,    -1,    -1,  1584,  4044,   184,  1587,
      -1,  1589,    -1,   189,    -1,   208,   192,  1595,    -1,  1597,
    1598,    -1,   215,    -1,   943,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   499,    -1,    -1,    -1,   503,    -1,   215,
     506,   217,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   517,    -1,    -1,    -1,    -1,   522,   233,    -1,   525,
      -1,   254,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   995,   996,   254,    -1,
    1658,    -1,    -1,    -1,    -1,  1004,  1005,    -1,    -1,  1008,
    1009,  1010,    -1,    -1,    -1,    -1,  1015,    -1,    -1,  1018,
    1019,    -1,  1021,    -1,  1023,    -1,    -1,    -1,   574,   575,
      -1,  1030,  1031,  1032,  1033,    -1,  1035,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1043,  1044,    -1,  1046,  1047,    -1,
      -1,    -1,    -1,  1052,    -1,  1054,  1055,  1056,    -1,    -1,
    1059,  1060,  1061,  1062,  1063,  1064,    -1,    -1,  1067,  1068,
      -1,  1070,    -1,  1072,    -1,    -1,    -1,  1076,    -1,  1078,
    1079,    -1,    -1,    -1,   340,    13,    -1,    -1,    -1,    -1,
      -1,  1090,  1091,    -1,    -1,    -1,    -1,  1096,    -1,    -1,
    1099,    -1,    -1,   376,   360,    -1,    -1,  1106,  1107,  1108,
      -1,    -1,    -1,    -1,   370,    -1,    -1,    -1,    12,    13,
      -1,    -1,   395,    -1,   380,    -1,    -1,    -1,   401,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   409,    -1,    -1,    -1,
    1139,    -1,    -1,    -1,   400,    -1,    -1,   403,    -1,   405,
      -1,    -1,   408,    -1,    -1,   411,    -1,   413,    -1,   432,
      88,    -1,   418,    -1,   420,    -1,    -1,    -1,    -1,    -1,
      -1,   427,   445,   446,    -1,    -1,   432,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   440,    -1,    -1,    -1,   116,   445,
      -1,    -1,    -1,   449,    88,    -1,    -1,    -1,    -1,    -1,
      -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   486,    -1,    -1,   472,    -1,    -1,  1877,
     476,    -1,   116,   151,    -1,   153,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   129,   164,    -1,    -1,    -1,
      -1,    -1,   515,    -1,    -1,  1244,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1252,    -1,    -1,   184,   151,    -1,   153,
      -1,    -1,   518,    -1,   537,    -1,   539,    -1,    -1,    -1,
     164,    -1,    -1,    -1,   530,    -1,    -1,    -1,   534,  1937,
     208,   537,    -1,  1941,    -1,    -1,   542,   215,  1946,  1947,
     184,    -1,    -1,    -1,    -1,    -1,    -1,  1955,    -1,    -1,
    1958,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1968,   567,  1970,  1971,   208,  1973,  1974,  1975,  1976,  1977,
      -1,   215,  1980,    -1,    -1,   581,   254,    -1,    -1,     6,
      -1,  1989,    -1,    -1,    -1,    -1,    13,    14,    -1,  1997,
      -1,  1999,    -1,  2001,  2002,  2003,  2004,    -1,    25,    26,
    2008,  2009,  2010,    -1,    -1,    -1,    -1,  2015,  2016,  2017,
     254,  2019,    -1,  2021,    -1,  2023,    -1,  2025,    -1,  2027,
      -1,    -1,    -1,    -1,  2032,    -1,    -1,    -1,    55,    -1,
      -1,    -1,    59,    60,  2042,    -1,    -1,    64,    -1,    -1,
      -1,  2049,    -1,    70,  2052,    -1,    -1,    -1,    -1,    -1,
    2058,    78,    -1,  2061,    -1,    -1,    -1,  2065,    85,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,    -1,   115,    -1,
      -1,    -1,  1441,    -1,    -1,   122,   123,    -1,   376,    -1,
      -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,    -1,   143,   395,    -1,    -1,
      -1,    -1,    -1,   401,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   409,   376,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   170,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   395,    -1,    -1,   432,    -1,    -1,   401,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   409,    -1,   445,   446,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   206,
      -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,   432,   216,
      -1,  1540,  1541,  1542,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   231,    -1,    -1,    -1,   486,    -1,
      -1,    -1,    25,    26,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1578,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   515,  1587,    -1,
    1589,    -1,   486,    -1,    57,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    -1,   283,    70,    -1,   537,
      -1,   539,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      -1,   515,    -1,   300,    -1,    -1,    -1,   304,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   537,    -1,   539,    -1,    -1,    -1,   112,
      -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,  1658,
      -1,    -1,    -1,   340,    -1,    -1,    -1,    -1,   345,    -1,
      -1,    -1,    -1,    -1,    -1,   352,    -1,   354,    -1,    -1,
     143,    -1,    -1,   360,   361,    23,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    33,    34,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   390,    -1,    -1,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,   402,   403,   404,   405,    67,
      -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   208,    84,   424,    86,    -1,
      88,  2409,    -1,   216,    -1,  2413,    -1,    -1,    96,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2435,  2436,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2455,    -1,    -1,
     477,    -1,    -1,    -1,   142,   143,  2464,    -1,  2466,   147,
    2468,    -1,   150,    -1,    -1,   492,    -1,    -1,   495,    -1,
     283,    -1,    -1,    -1,    -1,  2483,    -1,    -1,    -1,    -1,
    2488,    -1,    -1,    -1,    -1,    -1,   513,   300,   176,    -1,
     178,    -1,    -1,   520,    -1,   183,    -1,   185,    -1,    -1,
      -1,    -1,  2510,    -1,   531,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2520,    -1,    -1,    -1,    -1,    -1,    -1,   207,
     208,    -1,    -1,    -1,   212,    -1,    -1,    -1,  1877,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   352,
      -1,   354,   230,    -1,    -1,    -1,    -1,    -1,   361,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2568,    -1,   589,   251,  2572,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1937,    -1,
     278,    -1,  1941,    -1,    -1,    -1,    -1,  1946,  1947,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1955,  2615,    -1,    -1,
      -1,   424,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1968,
      -1,  1970,   310,    -1,  1973,  1974,  1975,  1976,  1977,    -1,
      -1,    -1,   320,  2641,    -1,    -1,    -1,    -1,    -1,    -1,
    1989,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1997,    -1,
    1999,   339,  2001,  2002,  2003,    -1,    -1,    -1,    -1,  2008,
    2009,  2010,    -1,    -1,   477,    -1,  2015,  2016,  2017,    -1,
    2019,    -1,  2021,    -1,  2023,   363,  2025,    -1,  2027,   492,
      -1,    -1,   495,  2032,    -1,    -1,   374,   375,    -1,    -1,
     378,   379,    -1,  2042,    -1,    -1,    -1,    -1,    -1,    -1,
     513,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,  2058,
      -1,    -1,  2061,    -1,    -1,    -1,    -1,    -1,   531,  2727,
    2728,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   437,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   449,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    13,    14,    -1,   473,    -1,    -1,    -1,   477,
      -1,    -1,    -1,  2801,  2802,    -1,  2804,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,  2813,   494,    -1,    -1,    -1,
    2818,    -1,    -1,  2821,    -1,  2823,  2824,    48,    49,    -1,
      -1,    -1,    -1,    -1,    55,    -1,    -1,    -1,    59,    60,
      -1,    -1,    -1,    -1,  2842,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    -1,    -1,  2853,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,
      -1,    -1,    -1,   551,    -1,    -1,  2874,    -1,    -1,   557,
      25,    26,    -1,    -1,    -1,    -1,    -1,   108,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2903,    -1,   128,   129,    -1,
      -1,    -1,    -1,    -1,    59,    -1,    -1,    -1,    -1,  2917,
     141,    -1,    -1,    -1,    -1,    70,    -1,    -1,    -1,    -1,
      -1,    -1,   153,    78,    -1,    -1,    -1,  2935,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   184,    -1,    -1,    -1,   112,   189,    -1,
     115,   192,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   215,    -1,   217,    -1,   143,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   250,
      -1,    -1,    -1,   254,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,
    2409,   216,    -1,    -1,  2413,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2435,  2436,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2455,    -1,    -1,   340,
      -1,    -1,    -1,    -1,    -1,  2464,    -1,  2466,  3126,  2468,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   283,   360,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   370,
      -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,   380,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3165,  3166,    -1,
      -1,  2510,    -1,    -1,    -1,    -1,  3174,    -1,    -1,   400,
      -1,    -1,   403,    -1,   405,    -1,    -1,   408,    -1,    -1,
     411,    -1,   413,    -1,    -1,    -1,    -1,   418,    -1,   420,
      -1,    -1,    -1,    -1,    -1,    -1,   427,   352,    -1,   354,
      -1,   432,    -1,    -1,    -1,    -1,   361,    -1,    -1,   440,
      -1,    -1,    -1,    -1,   445,    -1,    -1,    -1,   449,  2568,
      -1,    -1,    -1,  2572,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    32,    33,    -1,    -1,    -1,    -1,
      38,    -1,    40,    -1,    42,    43,  2615,    -1,    -1,   424,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,   518,    -1,    -1,
      -1,  3299,  2641,    -1,    -1,    -1,    -1,    -1,    -1,   530,
      -1,    -1,    -1,   534,    -1,    -1,   537,    -1,    -1,    -1,
      -1,   542,    -1,    -1,    -1,    -1,  3324,    -1,    -1,    -1,
      -1,    99,   477,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,  3339,   110,    -1,    -1,    -1,   567,   492,    -1,    -1,
     495,    -1,    -1,    -1,  3352,    -1,    -1,    -1,    -1,   127,
     581,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   513,    -1,
      -1,    -1,    -1,    -1,    -1,   520,   144,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   531,    -1,  2727,  2728,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
     168,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   180,   181,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3436,    -1,
    2779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2801,  2802,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2813,    -1,    -1,    -1,    -1,  2818,
     248,    -1,  2821,  3481,  2823,  2824,    -1,    -1,    -1,   257,
     258,    -1,   260,    -1,    -1,  3493,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3502,    -1,  3504,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2853,    -1,    -1,    -1,    -1,    -1,
      -1,   289,   290,   291,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2874,    -1,    -1,    -1,   307,
     308,   309,    -1,    -1,    -1,   313,  3544,    -1,   316,    -1,
      -1,    -1,  3550,  3551,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     6,    -1,    -1,   332,   333,    -1,    -1,    13,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2917,    -1,
      25,    26,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2935,   365,   366,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      55,    -1,    -1,    -1,    59,    -1,    -1,    -1,    -1,    -1,
      -1,   389,    -1,    -1,    -1,    70,    -1,    -1,    -1,    -1,
      -1,  3629,    -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,
      85,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   112,   436,    -1,
     115,    -1,   440,    -1,    -1,    -1,  3674,   122,  3676,    -1,
      -1,    -1,   450,    -1,   129,    -1,    -1,    -1,  3686,    -1,
    3688,  3689,   137,    -1,    -1,    -1,    -1,    -1,   143,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3707,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3719,    -1,    -1,    -1,   170,    -1,    -1,    -1,    -1,
      -1,    -1,   500,    -1,    -1,   503,    -1,    -1,   506,   507,
     508,   509,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   216,    -1,    -1,    -1,    -1,  3774,    -1,  3776,    -1,
      -1,   549,   550,    -1,    -1,    -1,   231,  3126,    -1,    -1,
      -1,    -1,    -1,  3791,  3792,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   570,    -1,    -1,    -1,    -1,  3805,    -1,    -1,
      -1,    -1,    -1,    -1,  3812,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3821,    -1,    -1,  3165,  3166,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3174,    -1,    -1,   283,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,   304,
    3858,  3859,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3871,  3872,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3886,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     345,    -1,    -1,    -1,    -1,    -1,    -1,   352,  3906,   354,
      -1,    -1,    -1,    -1,    -1,  3913,   361,    -1,  3916,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3935,    -1,    -1,
      -1,    -1,    -1,    -1,  3942,    -1,  3944,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3954,    -1,   403,  3957,
    3299,    -1,    -1,    -1,    -1,    -1,  3964,    -1,  3966,    -1,
    3968,    -1,    -1,    -1,    -1,    -1,    -1,  3975,    -1,   424,
      -1,    -1,    -1,    -1,    -1,  3324,  3984,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3339,  3999,  4000,    -1,    -1,    -1,    -1,  4005,    -1,    -1,
      -1,    -1,    -1,  3352,    -1,    -1,    -1,  4015,  4016,    -1,
      -1,    -1,  4020,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   477,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   492,    -1,    -1,
     495,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   513,    -1,
      -1,    -1,    -1,    -1,    -1,   520,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   531,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3493,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3502,    -1,  3504,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3544,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3629,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3674,    -1,  3676,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3686,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3774,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3792,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3812,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3858,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3913,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,  3935,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,  3957,    41,
      42,    43,    44,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    -1,    56,    57,    58,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,  4005,    -1,    90,    91,
      92,    -1,    94,    95,    -1,    97,    98,    99,   100,   101,
     102,    -1,    -1,    -1,    -1,   107,   108,   109,    -1,    -1,
     112,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,   154,    -1,   156,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,    -1,   169,    -1,    -1,
      -1,   173,   174,    -1,   176,    -1,   178,    -1,   180,   181,
     182,   183,    -1,   185,    -1,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,    -1,    -1,   200,   201,
     202,   203,   204,    -1,   206,   207,    -1,    -1,   210,    -1,
     212,    -1,    -1,   215,   216,   217,   218,    -1,    -1,   221,
      -1,   223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,
      -1,    -1,   234,   235,    -1,   237,   238,    -1,   240,   241,
     242,    -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,
      -1,   253,    -1,   255,   256,    -1,    -1,   259,    -1,    -1,
      -1,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,    -1,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,    -1,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,    -1,   315,   316,   317,    -1,    -1,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,    -1,   337,   338,   339,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
     372,    -1,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,   383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,   407,   408,   409,    -1,   411,
     412,   413,    -1,   415,   416,    -1,    -1,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,    -1,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,
     442,    -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,
     452,   453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,
     472,   473,   474,   475,   476,   477,    -1,   479,   480,   481,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,    -1,    -1,   495,   496,   497,    -1,   499,   500,   501,
      -1,   503,   504,   505,   506,    -1,    -1,    -1,    -1,   511,
     512,   513,   514,    -1,   516,   517,   518,   519,   520,   521,
     522,   523,   524,   525,   526,   527,    -1,   529,   530,    -1,
      -1,   533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,
      -1,    -1,   544,   545,   546,   547,   548,    -1,    -1,   551,
     552,    -1,   554,   555,   556,   557,   558,    -1,    -1,    -1,
      -1,   563,   564,    -1,   566,   567,    -1,    -1,   570,    -1,
      -1,    -1,   574,   575,    -1,    -1,    -1,    -1,   580,   581,
      -1,    -1,   584,   585,    -1,   587,   588,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    57,
      58,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      -1,    -1,    90,    91,    92,    -1,    94,    95,    -1,    97,
      98,    99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,
     108,   109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,   153,   154,    -1,   156,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
      -1,   169,    -1,    -1,    -1,   173,   174,    -1,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
      -1,    -1,   200,   201,   202,   203,   204,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,   215,   216,   217,
     218,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
      -1,    -1,    -1,   231,    -1,    -1,   234,   235,    -1,    -1,
     238,    -1,   240,   241,   242,    -1,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,   259,    -1,    -1,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,   315,   316,   317,
      -1,    -1,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,   372,    -1,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,   409,    -1,   411,   412,   413,    -1,   415,   416,    -1,
      -1,   419,   420,   421,   422,   423,   424,   425,   426,   427,
     428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,   447,
     448,   449,    -1,   451,   452,   453,   454,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,   472,   473,   474,   475,   476,   477,
      -1,   479,   480,   481,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,    -1,    -1,   495,   496,   497,
      -1,   499,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,   516,   517,
     518,   519,   520,   521,   522,   523,   524,   525,   526,   527,
      -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,    -1,
     538,    -1,   540,   541,    -1,    -1,   544,   545,   546,   547,
     548,    -1,    -1,   551,   552,    -1,   554,   555,   556,   557,
     558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,   567,
      -1,    -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,
      -1,    -1,   580,   581,    -1,    -1,   584,   585,    -1,   587,
     588,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
     204,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,   215,   216,   217,   218,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
     234,   235,    -1,    -1,   238,    -1,   240,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,   259,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,   315,   316,   317,    -1,    -1,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,   407,   408,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,   419,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,   432,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
     474,   475,   476,   477,    -1,   479,   480,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,    -1,
      -1,   495,   496,   497,    -1,   499,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,   516,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
     544,   545,   546,   547,   548,    -1,    -1,   551,   552,    -1,
     554,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,    -1,   570,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,   580,   581,    -1,    -1,
     584,   585,    -1,   587,   588,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    -1,    56,    57,    58,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    -1,    -1,
      90,    91,    92,    -1,    94,    95,    -1,    97,    98,    99,
     100,   101,   102,    -1,    -1,    -1,    -1,   107,   108,   109,
      -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,   154,    -1,   156,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,   204,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,   215,   216,   217,   218,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
     240,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,   259,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,   315,   316,   317,    -1,    -1,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,   407,   408,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,   419,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,   474,   475,   476,   477,    -1,   479,
     480,   481,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,    -1,    -1,   495,   496,   497,    -1,   499,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,   516,   517,   518,   519,
     520,   521,   522,   523,   524,   525,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,   544,   545,   546,   547,   548,    -1,
      -1,   551,   552,    -1,   554,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,    -1,
     570,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,    -1,
     580,   581,   582,    -1,   584,   585,    -1,   587,   588,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    57,    58,    59,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    -1,    -1,    90,    91,    92,    -1,    94,    95,
      -1,    97,    98,    99,   100,   101,   102,    -1,    -1,    -1,
      -1,   107,   108,   109,    -1,    -1,   112,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,   153,   154,    -1,
     156,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,    -1,   169,    -1,    -1,    -1,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,    -1,   185,
      -1,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,    -1,    -1,   200,   201,   202,   203,   204,    -1,
     206,   207,    -1,    -1,   210,    -1,   212,    -1,    -1,   215,
     216,   217,   218,    -1,    -1,   221,    -1,   223,   224,    -1,
     226,   227,    -1,    -1,    -1,   231,    -1,    -1,   234,   235,
      -1,    -1,   238,    -1,   240,   241,   242,    -1,    -1,    -1,
      -1,    -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,
     256,    -1,    -1,   259,    -1,    -1,    -1,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,    -1,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,    -1,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,    -1,   315,
     316,   317,    -1,    -1,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,   372,    -1,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,   383,    -1,    -1,
     386,    -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,   407,   408,   409,    -1,   411,   412,   413,    -1,   415,
     416,    -1,    -1,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,
     446,   447,   448,   449,    -1,   451,   452,   453,   454,   455,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,
      -1,    -1,   468,    -1,    -1,   471,   472,   473,   474,   475,
     476,   477,    -1,   479,   480,   481,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,    -1,    -1,   495,
     496,   497,    -1,   499,   500,   501,    -1,   503,   504,   505,
     506,    -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,
     516,   517,   518,   519,   520,   521,   522,   523,   524,   525,
     526,   527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,
     536,    -1,   538,    -1,   540,   541,    -1,    -1,   544,   545,
     546,   547,   548,    -1,    -1,   551,   552,    -1,   554,   555,
     556,   557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,
     566,   567,    -1,    -1,   570,    -1,    -1,    -1,   574,   575,
      -1,    -1,    -1,    -1,   580,   581,    -1,    -1,   584,   585,
      -1,   587,   588,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    -1,    56,    57,    58,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    -1,    -1,    90,    91,
      92,    -1,    94,    95,    -1,    97,    98,    99,   100,   101,
     102,    -1,    -1,    -1,    -1,   107,   108,   109,    -1,    -1,
     112,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,   154,    -1,   156,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,    -1,   169,    -1,    -1,
      -1,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,    -1,   185,    -1,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,    -1,    -1,   200,   201,
     202,   203,   204,    -1,   206,   207,    -1,    -1,   210,    -1,
     212,    -1,    -1,   215,   216,   217,   218,    -1,    -1,   221,
      -1,   223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,
      -1,    -1,   234,   235,    -1,    -1,   238,    -1,   240,   241,
     242,    -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,
      -1,   253,    -1,   255,   256,    -1,    -1,   259,    -1,    -1,
      -1,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,    -1,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,    -1,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,    -1,   315,   316,   317,    -1,    -1,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,    -1,   337,   338,   339,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
     372,    -1,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,   383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,   407,   408,   409,    -1,   411,
     412,   413,    -1,   415,   416,    -1,    -1,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,    -1,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,
     442,    -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,
     452,   453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,
     472,   473,   474,   475,   476,   477,    -1,   479,   480,   481,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,    -1,    -1,   495,   496,   497,    -1,   499,   500,   501,
      -1,   503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,
     512,   513,   514,    -1,   516,   517,   518,   519,   520,   521,
     522,   523,   524,   525,   526,   527,    -1,   529,   530,    -1,
      -1,   533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,
      -1,    -1,   544,   545,   546,   547,   548,    -1,    -1,   551,
     552,    -1,   554,   555,   556,   557,   558,    -1,    -1,    -1,
      -1,   563,   564,    -1,   566,   567,    -1,    -1,   570,    -1,
      -1,    -1,   574,   575,    -1,    -1,    -1,    -1,   580,   581,
      -1,    -1,   584,   585,    -1,   587,   588,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    57,
      58,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      -1,    -1,    90,    91,    92,    -1,    94,    95,    -1,    97,
      98,    99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,
     108,   109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,   153,   154,    -1,   156,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
      -1,   169,    -1,    -1,    -1,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
      -1,    -1,   200,   201,   202,   203,   204,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,   215,   216,   217,
     218,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
      -1,    -1,    -1,   231,    -1,    -1,   234,   235,    -1,    -1,
     238,    -1,   240,   241,   242,    -1,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,   259,    -1,    -1,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,   315,   316,   317,
      -1,    -1,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,   372,    -1,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,   409,    -1,   411,   412,   413,    -1,   415,   416,    -1,
      -1,   419,   420,   421,   422,   423,   424,   425,   426,   427,
     428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,   447,
     448,   449,    -1,   451,   452,   453,   454,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,   472,   473,   474,   475,   476,   477,
      -1,   479,   480,   481,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,    -1,    -1,   495,   496,   497,
      -1,   499,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,   516,   517,
     518,   519,   520,   521,   522,   523,   524,   525,   526,   527,
      -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,    -1,
     538,    -1,   540,   541,    -1,    -1,   544,   545,   546,   547,
     548,    -1,    -1,   551,   552,    -1,   554,   555,   556,   557,
     558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,   567,
      -1,    -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,
      -1,    -1,   580,   581,    -1,    -1,   584,   585,    -1,   587,
     588,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
     204,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,   215,   216,   217,   218,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
     234,   235,    -1,    -1,   238,    -1,   240,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,   259,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,   315,   316,   317,    -1,    -1,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,   407,   408,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,   419,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
     474,   475,   476,   477,    -1,   479,   480,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,    -1,
      -1,   495,   496,   497,    -1,   499,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,   516,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
     544,   545,   546,   547,   548,    -1,    -1,   551,   552,    -1,
     554,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,    -1,   570,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,   580,   581,    -1,    -1,
     584,   585,    -1,   587,   588,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    -1,    56,    57,    58,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    -1,    -1,
      90,    91,    92,    -1,    94,    95,    -1,    97,    98,    99,
     100,   101,   102,    -1,    -1,    -1,    -1,   107,   108,   109,
      -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,   154,    -1,   156,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,   204,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,   215,   216,   217,   218,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
     240,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,   259,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,   315,   316,   317,    -1,    -1,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,   407,   408,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,   419,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,   474,   475,   476,   477,    -1,   479,
     480,   481,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,    -1,    -1,   495,   496,   497,    -1,   499,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,   516,   517,   518,   519,
     520,   521,   522,   523,   524,   525,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,   544,   545,   546,   547,   548,    -1,
      -1,   551,   552,    -1,   554,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,    -1,
     570,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,    -1,
     580,   581,    -1,    -1,   584,   585,    -1,   587,   588,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    57,    58,    59,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    -1,    -1,    90,    91,    92,    -1,    94,    95,
      -1,    97,    98,    99,   100,   101,   102,    -1,    -1,    -1,
      -1,   107,   108,   109,    -1,    -1,   112,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,   153,   154,    -1,
     156,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,    -1,   169,    -1,    -1,    -1,   173,   174,    -1,
     176,    -1,   178,    -1,   180,   181,   182,   183,    -1,   185,
      -1,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,    -1,    -1,   200,   201,   202,   203,   204,    -1,
     206,   207,    -1,    -1,   210,    -1,   212,    -1,    -1,   215,
     216,   217,   218,    -1,    -1,   221,    -1,   223,   224,    -1,
     226,   227,    -1,    -1,    -1,   231,    -1,    -1,   234,   235,
      -1,    -1,   238,    -1,   240,   241,   242,    -1,    -1,    -1,
      -1,    -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,
     256,    -1,    -1,   259,    -1,    -1,    -1,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,    -1,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,    -1,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,    -1,   315,
     316,   317,    -1,    -1,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,   372,    -1,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,   383,    -1,    -1,
     386,    -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,   407,   408,   409,    -1,   411,   412,   413,    -1,   415,
     416,    -1,    -1,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,
     446,   447,   448,   449,    -1,   451,   452,   453,   454,   455,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,
      -1,    -1,   468,    -1,    -1,   471,   472,   473,   474,   475,
     476,   477,    -1,   479,   480,   481,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,    -1,    -1,   495,
     496,   497,    -1,   499,   500,   501,    -1,   503,   504,   505,
     506,    -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,
     516,   517,   518,   519,   520,   521,   522,   523,   524,   525,
     526,   527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,
     536,    -1,   538,    -1,   540,   541,    -1,    -1,   544,   545,
     546,   547,   548,    -1,    -1,   551,   552,    -1,   554,   555,
     556,   557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,
     566,   567,    -1,    -1,   570,    -1,    -1,    -1,   574,   575,
      -1,    -1,    -1,    -1,   580,   581,    -1,    -1,   584,   585,
      -1,   587,   588,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    -1,    56,    57,    58,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    -1,    -1,    90,    91,
      92,    -1,    94,    95,    -1,    97,    98,    99,   100,   101,
     102,    -1,    -1,    -1,    -1,   107,   108,   109,    -1,    -1,
     112,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,   154,    -1,   156,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,    -1,   169,    -1,    -1,
      -1,   173,   174,    -1,   176,    -1,   178,    -1,   180,   181,
     182,   183,    -1,   185,    -1,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,    -1,    -1,   200,   201,
     202,   203,   204,    -1,   206,   207,    -1,    -1,   210,    -1,
     212,    -1,    -1,   215,   216,   217,   218,    -1,    -1,   221,
      -1,   223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,
      -1,    -1,   234,   235,    -1,    -1,   238,    -1,   240,   241,
     242,    -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,
      -1,   253,    -1,   255,   256,    -1,    -1,   259,    -1,    -1,
      -1,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,    -1,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,    -1,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,    -1,   315,   316,   317,    -1,    -1,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,    -1,   337,   338,   339,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
     372,    -1,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,   383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,   407,   408,   409,    -1,   411,
     412,   413,    -1,   415,   416,    -1,    -1,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,    -1,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,
     442,    -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,
     452,   453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,
     472,   473,   474,   475,   476,   477,    -1,   479,   480,   481,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,    -1,    -1,   495,   496,   497,    -1,   499,   500,   501,
      -1,   503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,
     512,   513,   514,    -1,   516,   517,   518,   519,   520,   521,
     522,   523,   524,   525,   526,   527,    -1,   529,   530,    -1,
      -1,   533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,
      -1,    -1,   544,   545,   546,   547,   548,    -1,    -1,   551,
     552,    -1,   554,   555,   556,   557,   558,    -1,    -1,    -1,
      -1,   563,   564,    -1,   566,   567,    -1,    -1,   570,    -1,
      -1,    -1,   574,   575,    -1,    -1,    -1,    -1,   580,   581,
      -1,    -1,   584,   585,    -1,   587,   588,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    57,
      58,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      -1,    -1,    90,    91,    92,    -1,    94,    95,    -1,    97,
      98,    99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,
     108,   109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,   153,   154,    -1,   156,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
      -1,   169,    -1,    -1,    -1,   173,   174,    -1,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
      -1,    -1,   200,   201,   202,   203,   204,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,   215,   216,   217,
     218,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
      -1,    -1,    -1,   231,    -1,    -1,   234,   235,    -1,    -1,
     238,    -1,   240,   241,   242,    -1,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,   259,    -1,    -1,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,   315,   316,   317,
      -1,    -1,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,   372,    -1,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,   409,    -1,   411,   412,   413,    -1,   415,   416,    -1,
      -1,   419,   420,   421,   422,   423,   424,   425,   426,   427,
     428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,   447,
     448,   449,    -1,   451,   452,   453,   454,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,   472,   473,   474,   475,   476,   477,
      -1,   479,   480,   481,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,    -1,    -1,   495,   496,   497,
      -1,   499,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,   516,   517,
     518,   519,   520,   521,   522,   523,   524,   525,   526,   527,
      -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,    -1,
     538,    -1,   540,   541,    -1,    -1,   544,   545,   546,   547,
     548,    -1,    -1,   551,   552,    -1,   554,   555,   556,   557,
     558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,   567,
      -1,    -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,
      -1,    -1,   580,   581,    -1,    -1,   584,   585,    -1,   587,
     588,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
     204,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,   215,   216,   217,   218,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
     234,   235,    -1,    -1,   238,    -1,   240,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,   259,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,    -1,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,   315,   316,   317,    -1,    -1,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,   407,   408,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,   419,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
     474,   475,   476,   477,    -1,   479,   480,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,    -1,
      -1,   495,   496,   497,    -1,   499,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,   516,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
     544,   545,   546,   547,   548,    -1,    -1,   551,   552,    -1,
     554,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,    -1,   570,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,   580,   581,    -1,    -1,
     584,   585,    -1,   587,   588,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    -1,    56,    57,    58,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    -1,    -1,
      90,    91,    92,    -1,    94,    95,    -1,    97,    98,    99,
     100,   101,   102,    -1,    -1,    -1,    -1,   107,   108,   109,
      -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,   154,    -1,   156,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,   204,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,   215,   216,   217,   218,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
     240,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,   259,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,    -1,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,   315,   316,   317,    -1,    -1,
     320,   321,   322,   323,   324,    -1,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,   407,   408,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,   419,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,   474,   475,   476,   477,    -1,   479,
     480,   481,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,    -1,    -1,   495,   496,   497,    -1,   499,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,   516,   517,   518,   519,
     520,   521,   522,   523,   524,   525,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,   544,   545,   546,   547,   548,    -1,
      -1,   551,   552,    -1,   554,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,    -1,
     570,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,    -1,
     580,   581,    -1,    -1,   584,   585,    -1,   587,   588,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    57,    58,    59,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    -1,    -1,    90,    91,    92,    -1,    94,    95,
      -1,    97,    98,    99,   100,   101,   102,    -1,    -1,    -1,
      -1,   107,   108,   109,    -1,    -1,   112,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,   153,   154,    -1,
     156,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,    -1,   169,    -1,    -1,    -1,   173,   174,    -1,
     176,    -1,   178,    -1,   180,   181,   182,   183,    -1,   185,
      -1,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,    -1,    -1,   200,   201,   202,   203,   204,    -1,
     206,   207,    -1,    -1,   210,    -1,   212,    -1,    -1,   215,
     216,   217,   218,    -1,    -1,   221,    -1,   223,   224,    -1,
     226,   227,    -1,    -1,    -1,   231,    -1,    -1,   234,   235,
      -1,    -1,   238,    -1,   240,   241,   242,    -1,    -1,    -1,
      -1,    -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,
     256,    -1,    -1,   259,    -1,    -1,    -1,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,    -1,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,    -1,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,    -1,   315,
     316,   317,    -1,    -1,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,   372,    -1,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,   383,    -1,    -1,
     386,    -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,   407,   408,   409,    -1,   411,   412,   413,    -1,   415,
     416,    -1,    -1,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,
     446,   447,   448,   449,    -1,   451,   452,   453,   454,   455,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,
      -1,    -1,   468,    -1,    -1,   471,   472,   473,   474,   475,
     476,   477,    -1,   479,   480,   481,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,    -1,    -1,   495,
     496,   497,    -1,   499,   500,   501,    -1,   503,   504,   505,
     506,    -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,
     516,   517,   518,   519,   520,   521,   522,   523,   524,   525,
     526,   527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,
     536,    -1,   538,    -1,   540,   541,    -1,    -1,   544,   545,
     546,   547,   548,    -1,    -1,   551,   552,    -1,   554,   555,
     556,   557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,
     566,   567,    -1,    -1,   570,    -1,    -1,    -1,   574,   575,
      -1,    -1,    -1,    -1,   580,   581,    -1,    -1,   584,   585,
      -1,   587,   588,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    -1,    56,    57,    58,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    -1,    -1,    90,    91,
      92,    -1,    94,    95,    -1,    97,    98,    99,   100,   101,
     102,    -1,    -1,    -1,    -1,   107,   108,   109,    -1,    -1,
     112,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,   154,    -1,   156,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,    -1,   169,    -1,    -1,
      -1,   173,   174,    -1,   176,    -1,   178,    -1,   180,   181,
     182,   183,    -1,   185,    -1,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,    -1,    -1,   200,   201,
     202,   203,   204,    -1,   206,   207,    -1,    -1,   210,    -1,
     212,    -1,    -1,   215,   216,   217,   218,    -1,    -1,   221,
      -1,   223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,
      -1,    -1,   234,   235,    -1,    -1,   238,    -1,   240,   241,
     242,    -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,
      -1,   253,    -1,   255,   256,    -1,    -1,   259,    -1,    -1,
      -1,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,    -1,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,    -1,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,    -1,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,    -1,   315,   316,   317,    -1,    -1,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,    -1,   337,   338,   339,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
     372,    -1,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,   383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,   407,   408,   409,    -1,   411,
     412,   413,    -1,   415,   416,    -1,    -1,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,    -1,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,
     442,    -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,
     452,   453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,
     472,   473,   474,   475,   476,   477,    -1,   479,   480,   481,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,    -1,    -1,   495,   496,   497,    -1,   499,   500,   501,
      -1,   503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,
     512,   513,   514,    -1,   516,   517,   518,   519,   520,   521,
     522,   523,   524,   525,   526,   527,    -1,   529,   530,    -1,
      -1,   533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,
      -1,    -1,   544,   545,   546,   547,   548,    -1,    -1,   551,
     552,    -1,   554,   555,   556,   557,   558,    -1,    -1,    -1,
      -1,   563,   564,    -1,   566,   567,    -1,    -1,   570,    -1,
      -1,    -1,   574,   575,    -1,    -1,    -1,    -1,   580,   581,
      -1,    -1,   584,   585,    -1,   587,   588,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    57,
      58,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      -1,    -1,    90,    91,    92,    -1,    94,    95,    -1,    97,
      98,    99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,
     108,   109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,   153,   154,    -1,   156,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
      -1,   169,    -1,    -1,    -1,   173,   174,    -1,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
      -1,    -1,   200,   201,   202,   203,   204,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,   215,   216,   217,
     218,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
      -1,    -1,    -1,   231,    -1,    -1,   234,   235,    -1,    -1,
     238,    -1,   240,   241,   242,    -1,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,   259,    -1,    -1,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,   315,   316,   317,
      -1,    -1,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,   372,    -1,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,   409,    -1,   411,   412,   413,    -1,   415,   416,    -1,
      -1,   419,   420,   421,   422,   423,   424,   425,   426,   427,
     428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,   447,
     448,   449,    -1,   451,   452,   453,   454,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,   472,   473,   474,   475,   476,   477,
      -1,   479,   480,   481,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,    -1,    -1,   495,   496,   497,
      -1,   499,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,   516,   517,
     518,   519,   520,   521,   522,   523,   524,   525,   526,   527,
      -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,    -1,
     538,    -1,   540,   541,    -1,    -1,   544,   545,   546,   547,
     548,    -1,    -1,   551,   552,    -1,   554,   555,   556,   557,
     558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,   567,
      -1,    -1,   570,    -1,    -1,    -1,   574,   575,    -1,    -1,
      -1,    -1,   580,   581,    -1,    -1,   584,   585,    -1,   587,
     588,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    57,    -1,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    80,    81,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,   177,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
      -1,    -1,   206,   207,   208,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,    -1,
     244,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,    -1,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,    -1,    -1,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,   432,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,   456,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
      -1,    -1,   476,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,    -1,   570,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,   588,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    80,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
      -1,    -1,   169,    -1,    -1,    -1,   173,   174,    -1,   176,
     177,   178,    -1,   180,   181,   182,   183,    -1,   185,    -1,
      -1,    -1,   189,   190,    -1,   192,    -1,    -1,   195,   196,
      -1,    -1,    -1,   200,   201,   202,   203,    -1,    -1,   206,
     207,   208,    -1,   210,    -1,   212,    -1,    -1,    -1,   216,
     217,    -1,    -1,    -1,   221,    -1,   223,   224,    -1,   226,
     227,    -1,    -1,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,   238,    -1,    -1,   241,   242,    -1,    -1,    -1,    -1,
      -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,   256,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
      -1,   278,   279,    -1,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,    -1,    -1,   292,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,   302,    -1,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,   313,    -1,    -1,   316,
     317,    -1,    -1,   320,   321,   322,   323,    -1,    -1,    -1,
     327,   328,    -1,    -1,    -1,    -1,   333,   334,   335,    -1,
     337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,    -1,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,    -1,    -1,   370,   371,   372,    -1,   374,    -1,   376,
     377,   378,   379,    -1,   381,   382,   383,    -1,    -1,   386,
      -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,
     397,   398,   399,    -1,   401,   402,    -1,   404,   405,   406,
      -1,    -1,   409,    -1,   411,   412,   413,    -1,   415,   416,
      -1,    -1,    -1,   420,   421,   422,   423,   424,   425,   426,
     427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,
     437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,
     447,   448,   449,    -1,   451,   452,   453,   454,   455,   456,
      -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,
      -1,   468,    -1,    -1,   471,   472,   473,    -1,    -1,   476,
     477,    -1,   479,   480,   481,   482,   483,    -1,    -1,   486,
     487,   488,   489,    -1,   491,   492,    -1,    -1,   495,   496,
     497,    -1,    -1,   500,   501,    -1,   503,   504,   505,   506,
      -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,    -1,
      -1,   518,   519,   520,   521,    -1,   523,   524,    -1,   526,
     527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,
      -1,   538,    -1,   540,   541,    -1,    -1,    -1,    -1,    -1,
      -1,   548,    -1,    -1,   551,    -1,    -1,    -1,   555,   556,
     557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,
     567,    -1,    -1,   570,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   588,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,    -1,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,    -1,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
      -1,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,   327,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,    -1,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,    -1,    -1,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,    -1,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,   432,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,    -1,    -1,   476,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,    -1,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,   518,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,    -1,
     570,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,   582,    -1,    17,    -1,    -1,    20,   588,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,    62,
      63,    64,    65,    -1,    67,    68,    -1,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    -1,    81,    82,
      -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,
      -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,
      -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,
     113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
     153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,
      -1,   164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,
     173,   174,    -1,   176,    -1,   178,    -1,   180,   181,   182,
     183,    -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,
      -1,    -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,
     203,    -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,
     223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,
      -1,   234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,
      -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,
     253,    -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,    -1,   278,   279,    -1,   281,   282,
     283,   284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,   302,
      -1,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
     313,    -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,
     323,    -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,
     333,   334,   335,    -1,   337,   338,   339,    -1,   341,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,    -1,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,    -1,    -1,   370,   371,   372,
      -1,   374,    -1,   376,   377,   378,   379,    -1,   381,   382,
     383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,
     393,   394,    -1,    -1,   397,   398,   399,    -1,   401,   402,
      -1,   404,   405,   406,    -1,    -1,   409,    -1,   411,   412,
     413,    -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,   425,   426,   427,   428,    -1,   430,   431,    -1,
      -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,
      -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,   452,
     453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,
     463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,
     473,    -1,    -1,   476,   477,    -1,   479,   480,   481,   482,
     483,    -1,    -1,   486,   487,   488,   489,    -1,   491,   492,
      -1,    -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,
     503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,
     513,   514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,
     523,   524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,
     533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,
      -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,
      -1,    -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,
     563,   564,    -1,   566,   567,    -1,    -1,   570,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,   582,
      -1,    -1,    -1,    17,   587,   588,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    57,    -1,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
      -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
     234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,    -1,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,    -1,    -1,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
      -1,    -1,   476,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,    -1,   570,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,   581,    -1,    -1,
      17,    -1,    -1,    20,   588,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
      -1,    -1,   169,    -1,    -1,    -1,   173,   174,    -1,   176,
      -1,   178,    -1,   180,   181,   182,   183,    -1,   185,    -1,
      -1,    -1,   189,   190,    -1,   192,    -1,    -1,   195,   196,
      -1,    -1,    -1,   200,   201,   202,   203,    -1,    -1,   206,
     207,    -1,    -1,   210,    -1,   212,    -1,    -1,    -1,   216,
     217,    -1,   219,    -1,   221,    -1,   223,   224,    -1,   226,
     227,    -1,    -1,    -1,   231,    -1,    -1,   234,   235,    -1,
      -1,   238,    -1,    -1,   241,   242,    -1,    -1,    -1,    -1,
      -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,   256,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
      -1,   278,   279,    -1,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,    -1,    -1,   292,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,   302,    -1,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,   313,    -1,    -1,   316,
     317,    -1,    -1,   320,   321,   322,   323,    -1,    -1,    -1,
     327,   328,    -1,    -1,    -1,    -1,   333,   334,   335,    -1,
     337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,    -1,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,    -1,    -1,   370,   371,   372,    -1,   374,    -1,   376,
     377,   378,   379,    -1,   381,   382,   383,    -1,    -1,   386,
      -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,
     397,   398,   399,    -1,   401,   402,    -1,   404,   405,   406,
      -1,    -1,   409,    -1,   411,   412,   413,    -1,   415,   416,
      -1,    -1,    -1,   420,   421,   422,   423,   424,   425,   426,
     427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,
     437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,
     447,   448,   449,    -1,   451,   452,   453,   454,   455,    -1,
      -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,
      -1,   468,    -1,    -1,   471,   472,   473,    -1,    -1,   476,
     477,    -1,   479,   480,   481,   482,   483,    -1,    -1,   486,
     487,   488,   489,    -1,   491,   492,    -1,    -1,   495,   496,
     497,    -1,    -1,   500,   501,    -1,   503,   504,   505,   506,
      -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,    -1,
      -1,   518,   519,   520,   521,    -1,   523,   524,    -1,   526,
     527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,
      -1,   538,    -1,   540,   541,    -1,    -1,    -1,    -1,    -1,
      -1,   548,    -1,    -1,   551,    -1,    -1,    -1,   555,   556,
     557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,
     567,    -1,    -1,   570,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   588,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,    -1,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,    -1,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
      -1,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,   327,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,    -1,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,    -1,    -1,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,    -1,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,    -1,    -1,   476,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,    -1,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,   518,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,    -1,
     570,    -1,    -1,    -1,    -1,     5,   576,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,   588,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,    -1,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,    -1,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
      -1,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,   327,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,    -1,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,    -1,    -1,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,    -1,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,    -1,    -1,   476,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,    -1,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,   518,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,    -1,
     570,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,   581,    -1,    -1,    17,    -1,    -1,    20,   588,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,    62,
      63,    64,    65,    -1,    67,    68,    -1,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    -1,    81,    82,
      -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,
      -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,
      -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,
     113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
     153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,
      -1,   164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,
     173,   174,    -1,   176,    -1,   178,    -1,   180,   181,   182,
     183,    -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,
      -1,    -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,
     203,    -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,
     223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,
      -1,   234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,
      -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,
     253,    -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,    -1,   278,   279,    -1,   281,   282,
     283,   284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,   302,
      -1,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
     313,    -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,
     323,    -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,
     333,   334,   335,    -1,   337,   338,   339,    -1,   341,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,    -1,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,    -1,    -1,   370,   371,   372,
      -1,   374,    -1,   376,   377,   378,   379,    -1,   381,   382,
     383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,
     393,   394,    -1,    -1,   397,   398,   399,    -1,   401,   402,
      -1,   404,   405,   406,    -1,    -1,   409,    -1,   411,   412,
     413,    -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,   425,   426,   427,   428,    -1,   430,   431,    -1,
      -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,
      -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,   452,
     453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,
     463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,
     473,    -1,    -1,   476,   477,    -1,   479,   480,   481,   482,
     483,    -1,    -1,   486,   487,   488,   489,    -1,   491,   492,
      -1,    -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,
     503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,
     513,   514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,
     523,   524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,
     533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,
      -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,
      -1,    -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,
     563,   564,    -1,   566,   567,    -1,    -1,   570,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,   587,   588,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    57,    -1,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
      -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
     234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,    -1,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,    -1,    -1,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
      -1,    -1,   476,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,    -1,   570,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,   588,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
      -1,    -1,   169,    -1,    -1,    -1,   173,   174,    -1,   176,
      -1,   178,    -1,   180,   181,   182,   183,    -1,   185,    -1,
      -1,    -1,   189,   190,    -1,   192,    -1,    -1,   195,   196,
      -1,    -1,    -1,   200,   201,   202,   203,    -1,    -1,   206,
     207,    -1,    -1,   210,    -1,   212,    -1,    -1,    -1,   216,
     217,    -1,    -1,    -1,   221,    -1,   223,   224,    -1,   226,
     227,    -1,    -1,    -1,   231,    -1,    -1,   234,   235,    -1,
      -1,   238,    -1,    -1,   241,   242,    -1,    -1,    -1,    -1,
      -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,   256,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
      -1,   278,   279,    -1,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,    -1,    -1,   292,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,   302,    -1,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,   313,    -1,    -1,   316,
     317,    -1,    -1,   320,   321,   322,   323,    -1,    -1,    -1,
     327,   328,    -1,    -1,    -1,    -1,   333,   334,   335,    -1,
     337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,    -1,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,    -1,    -1,   370,   371,   372,    -1,   374,    -1,   376,
     377,   378,   379,    -1,   381,   382,   383,    -1,    -1,   386,
      -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,
     397,   398,   399,    -1,   401,   402,    -1,   404,   405,   406,
      -1,    -1,   409,    -1,   411,   412,   413,    -1,   415,   416,
      -1,    -1,    -1,   420,   421,   422,   423,   424,   425,   426,
     427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,
     437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,
     447,   448,   449,    -1,   451,   452,   453,   454,   455,    -1,
      -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,
      -1,   468,    -1,    -1,   471,   472,   473,    -1,    -1,   476,
     477,    -1,   479,   480,   481,   482,   483,    -1,    -1,   486,
     487,   488,   489,    -1,   491,   492,    -1,    -1,   495,   496,
     497,    -1,    -1,   500,   501,    -1,   503,   504,   505,   506,
      -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,    -1,
      -1,   518,   519,   520,   521,    -1,   523,   524,    -1,   526,
     527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,
      -1,   538,    -1,   540,   541,    -1,    -1,    -1,    -1,    -1,
      -1,   548,    -1,    -1,   551,    -1,    -1,    -1,   555,   556,
     557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,
     567,    -1,    -1,   570,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   588,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,    -1,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,    -1,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
      -1,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,   327,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,    -1,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,    -1,    -1,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,    -1,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,    -1,    -1,   476,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,    -1,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,   518,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,    -1,
     570,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   588,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,    62,
      63,    64,    65,    -1,    67,    68,    -1,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    -1,    81,    82,
      -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,
      -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,
      -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,
     113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
     153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,
      -1,   164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,
     173,   174,    -1,   176,    -1,   178,    -1,   180,   181,   182,
     183,    -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,
      -1,    -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,
     203,    -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,
     223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,
      -1,   234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,
      -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,
     253,    -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,    -1,   278,   279,    -1,   281,   282,
     283,   284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,   302,
      -1,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
     313,    -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,
     323,    -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,
     333,   334,   335,    -1,   337,   338,   339,    -1,   341,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,    -1,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,    -1,    -1,   370,   371,   372,
      -1,   374,    -1,   376,   377,   378,   379,    -1,   381,   382,
     383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,
     393,   394,    -1,    -1,   397,   398,   399,    -1,   401,   402,
      -1,   404,   405,   406,    -1,    -1,   409,    -1,   411,   412,
     413,    -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,
     423,   424,   425,   426,   427,   428,    -1,   430,   431,    -1,
      -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,
      -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,   452,
     453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,
     463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,
     473,    -1,    -1,   476,   477,    -1,   479,   480,   481,   482,
     483,    -1,    -1,   486,   487,   488,   489,    -1,   491,   492,
      -1,    -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,
     503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,
     513,   514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,
     523,   524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,
     533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,
      -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,
      -1,    -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,
     563,   564,    -1,   566,   567,    -1,    -1,   570,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,   588,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,
      56,    57,    -1,    59,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,
      -1,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,    -1,    -1,   161,   162,    -1,   164,   165,
     166,    -1,    -1,   169,    -1,    -1,    -1,   173,   174,    -1,
     176,    -1,   178,    -1,   180,   181,   182,   183,    -1,   185,
      -1,    -1,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
     196,    -1,    -1,    -1,   200,   201,   202,   203,    -1,    -1,
     206,   207,    -1,    -1,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,    -1,   223,   224,    -1,
     226,   227,    -1,    -1,    -1,   231,    -1,    -1,   234,   235,
      -1,    -1,   238,    -1,    -1,   241,   242,   243,    -1,    -1,
      -1,    -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,
     256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,    -1,    -1,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,   302,    -1,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,   313,    -1,    -1,
     316,   317,    -1,    -1,   320,   321,   322,   323,    -1,    -1,
      -1,   327,   328,    -1,    -1,    -1,    -1,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,    -1,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,    -1,   370,   371,   372,    -1,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,   383,    -1,    -1,
     386,    -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,    -1,    -1,   409,    -1,   411,   412,   413,    -1,   415,
     416,    -1,    -1,    -1,   420,   421,   422,   423,   424,   425,
     426,   427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,
     446,   447,   448,   449,    -1,   451,   452,   453,   454,   455,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,
      -1,    -1,   468,    -1,    -1,   471,   472,   473,    -1,    -1,
     476,   477,    -1,   479,   480,   481,   482,   483,    -1,    -1,
     486,   487,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,    -1,   499,   500,   501,    -1,   503,   504,   505,
     506,    -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,
      -1,    -1,   518,   519,   520,   521,    -1,   523,   524,    -1,
     526,   527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,
     536,    -1,   538,    -1,   540,   541,    -1,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,   551,    -1,    -1,    -1,   555,
     556,   557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,
     566,   567,    -1,    -1,   570,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   587,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,    -1,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,    -1,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
      -1,   241,   242,   243,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,   327,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,    -1,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,    -1,    -1,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,    -1,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,    -1,    -1,   476,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,   499,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,   518,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,    -1,
     570,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,   587,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    57,    -1,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
      -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
     234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,   243,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,    -1,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,    -1,    -1,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
      -1,    -1,   476,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,   499,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,    -1,   570,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,   587,    22,    23,    24,    25,    26,    27,
      -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    -1,
      -1,    -1,    -1,    51,    52,    -1,    54,    -1,    56,    -1,
      -1,    -1,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    -1,    71,    -1,    73,    74,    75,    76,    -1,
      78,    79,    -1,    -1,    82,    -1,    84,    -1,    -1,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
      -1,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
      -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,    -1,    -1,   156,   157,
     158,    -1,    -1,   161,   162,   163,   164,   165,   166,    -1,
      -1,    -1,    -1,    -1,    -1,   173,   174,    -1,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,    -1,
      -1,    -1,   190,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,   200,   201,   202,   203,   204,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
     228,    -1,    -1,   231,    -1,    -1,    -1,   235,    -1,    -1,
     238,   239,    -1,   241,   242,    -1,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,    -1,    -1,   261,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,   302,    -1,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,    -1,   316,   317,
      -1,    -1,   320,   321,   322,   323,    -1,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,   335,    -1,   337,
     338,   339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   352,   353,   354,    -1,    -1,   357,
     358,   359,    -1,   361,   362,   363,   364,   365,   366,    -1,
      -1,    -1,    -1,   371,   372,    -1,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,    -1,    -1,   404,    -1,   406,   407,
      -1,   409,    -1,    -1,   412,    -1,    -1,   415,   416,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,   426,    -1,
     428,    -1,   430,    -1,    -1,    -1,    -1,   435,   436,   437,
      -1,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,    -1,   473,    -1,    -1,    -1,   477,
      -1,   479,   480,   481,   482,   483,    -1,    -1,   486,   487,
     488,   489,    -1,   491,   492,    -1,    -1,   495,   496,   497,
      -1,    -1,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,    -1,    -1,
      -1,   519,   520,   521,    -1,   523,   524,    -1,   526,   527,
      -1,    -1,    -1,    -1,    -1,   533,    -1,    -1,   536,    -1,
      -1,    -1,   540,   541,    -1,    -1,    -1,    -1,    -1,    -1,
     548,    -1,    -1,   551,    -1,    -1,    -1,   555,   556,   557,
     558,    -1,    -1,   561,    -1,   563,    -1,    -1,   566,    -1,
      -1,     5,   570,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,   583,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    57,    -1,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
      -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
     234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,    -1,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,    -1,    -1,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
      -1,    -1,   476,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,     5,   570,     7,     8,     9,
      10,    11,   576,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,    -1,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,    -1,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
      -1,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,   327,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,    -1,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,    -1,    -1,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,    -1,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,    -1,    -1,   476,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,    -1,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,   518,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,     5,
     570,     7,     8,     9,    10,    11,   576,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,
      56,    57,    -1,    59,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,
      -1,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,    -1,    -1,   161,   162,    -1,   164,   165,
     166,    -1,    -1,   169,    -1,    -1,    -1,   173,   174,    -1,
     176,    -1,   178,    -1,   180,   181,   182,   183,    -1,   185,
      -1,    -1,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
     196,    -1,    -1,    -1,   200,   201,   202,   203,    -1,    -1,
     206,   207,    -1,    -1,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,    -1,   223,   224,    -1,
     226,   227,    -1,    -1,    -1,   231,    -1,    -1,   234,   235,
      -1,    -1,   238,    -1,    -1,   241,   242,    -1,    -1,    -1,
      -1,    -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,
     256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,    -1,    -1,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,   302,    -1,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,   313,    -1,    -1,
     316,   317,    -1,    -1,   320,   321,   322,   323,    -1,    -1,
      -1,   327,   328,    -1,    -1,    -1,    -1,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,    -1,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,    -1,   370,   371,   372,    -1,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,   383,    -1,    -1,
     386,    -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,    -1,    -1,   409,    -1,   411,   412,   413,    -1,   415,
     416,    -1,    -1,    -1,   420,   421,   422,   423,   424,   425,
     426,   427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,
     446,   447,   448,   449,    -1,   451,   452,   453,   454,   455,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,
      -1,    -1,   468,    -1,    -1,   471,   472,   473,    -1,    -1,
     476,   477,    -1,   479,   480,   481,   482,   483,    -1,    -1,
     486,   487,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,    -1,    -1,   500,   501,    -1,   503,   504,   505,
     506,    -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,
      -1,    -1,   518,   519,   520,   521,    -1,   523,   524,    -1,
     526,   527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,
     536,    -1,   538,    -1,   540,   541,    -1,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,   551,    -1,    -1,    -1,   555,
     556,   557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,
     566,   567,    -1,     5,   570,     7,     8,     9,    10,    11,
     576,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,    -1,    -1,   169,    -1,    -1,
      -1,   173,   174,    -1,   176,    -1,   178,    -1,   180,   181,
     182,   183,    -1,   185,    -1,    -1,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,   196,    -1,    -1,    -1,   200,   201,
     202,   203,    -1,    -1,   206,   207,    -1,    -1,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,
      -1,   223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,
      -1,    -1,   234,   235,    -1,    -1,   238,    -1,    -1,   241,
     242,    -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,
      -1,   253,    -1,   255,   256,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,    -1,   278,   279,    -1,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,    -1,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
     302,    -1,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,   313,    -1,    -1,   316,   317,    -1,    -1,   320,   321,
     322,   323,    -1,    -1,    -1,   327,   328,    -1,    -1,    -1,
      -1,   333,   334,   335,    -1,   337,   338,   339,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,    -1,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,    -1,    -1,   370,   371,
     372,    -1,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,   383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,    -1,    -1,   409,    -1,   411,
     412,   413,    -1,   415,   416,    -1,    -1,    -1,   420,   421,
     422,   423,   424,   425,   426,   427,   428,    -1,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,
     442,    -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,
     452,   453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,
     472,   473,    -1,    -1,   476,   477,    -1,   479,   480,   481,
     482,   483,    -1,    -1,   486,   487,   488,   489,    -1,   491,
     492,    -1,    -1,   495,   496,   497,    -1,    -1,   500,   501,
      -1,   503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,
     512,   513,   514,    -1,    -1,    -1,   518,   519,   520,   521,
      -1,   523,   524,    -1,   526,   527,    -1,   529,   530,    -1,
      -1,   533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,
      -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,   551,
      -1,    -1,    -1,   555,   556,   557,   558,    -1,    -1,    -1,
      -1,   563,   564,    -1,   566,   567,    -1,     5,   570,     7,
       8,     9,    10,    11,   576,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,    57,
      -1,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
     108,   109,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,   153,    -1,    -1,   156,   157,
     158,    -1,    -1,   161,   162,    -1,   164,   165,   166,   167,
      -1,   169,    -1,    -1,    -1,   173,   174,    -1,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,    -1,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
      -1,    -1,   200,   201,   202,   203,    -1,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
      -1,    -1,    -1,   231,    -1,    -1,   234,   235,    -1,    -1,
     238,    -1,    -1,   241,   242,    -1,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,   259,    -1,    -1,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,   302,    -1,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,    -1,   316,   317,
      -1,    -1,   320,   321,   322,   323,   324,   325,    -1,   327,
     328,    -1,    -1,   331,    -1,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,    -1,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,    -1,   370,   371,   372,    -1,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,    -1,
      -1,   409,    -1,   411,   412,   413,    -1,   415,   416,    -1,
      -1,    -1,   420,   421,   422,   423,   424,   425,   426,   427,
     428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,   447,
     448,   449,    -1,   451,   452,   453,   454,   455,    -1,    -1,
     458,   459,   460,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,   472,   473,    -1,    -1,   476,   477,
      -1,   479,   480,   481,   482,   483,    -1,    -1,   486,   487,
     488,   489,    -1,   491,   492,    -1,    -1,   495,   496,   497,
      -1,    -1,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,    -1,    -1,
     518,   519,   520,   521,   522,   523,   524,    -1,   526,   527,
      -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,    -1,
     538,    -1,   540,   541,    -1,    -1,    -1,    -1,    -1,    -1,
     548,    -1,    -1,   551,    -1,    -1,    -1,   555,   556,   557,
     558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,   567,
      -1,     5,   570,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    57,    -1,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,   145,    -1,   147,    -1,   149,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
      -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
     234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,   243,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,    -1,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,    -1,    -1,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,   441,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
      -1,    -1,   476,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,   499,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,     5,   570,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,    -1,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,    -1,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
      -1,   241,   242,   243,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,   327,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,    -1,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,    -1,    -1,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,    -1,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,    -1,    -1,   476,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,   499,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,   518,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,     5,
     570,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,
      56,    57,    -1,    59,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,
      -1,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,   112,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,    -1,    -1,   161,   162,    -1,   164,   165,
     166,    -1,    -1,   169,    -1,    -1,    -1,   173,   174,    -1,
     176,    -1,   178,    -1,   180,   181,   182,   183,    -1,   185,
      -1,    -1,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
     196,    -1,    -1,    -1,   200,   201,   202,   203,    -1,    -1,
     206,   207,    -1,    -1,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,    -1,   223,   224,    -1,
     226,   227,    -1,    -1,    -1,   231,    -1,    -1,   234,   235,
      -1,    -1,   238,    -1,    -1,   241,   242,   243,    -1,    -1,
      -1,    -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,
     256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,    -1,    -1,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,   302,    -1,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,   313,    -1,    -1,
     316,   317,    -1,    -1,   320,   321,   322,   323,    -1,    -1,
      -1,   327,   328,    -1,    -1,    -1,    -1,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,    -1,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,    -1,   370,   371,   372,    -1,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,   383,    -1,    -1,
     386,    -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,    -1,    -1,   409,    -1,   411,   412,   413,    -1,   415,
     416,    -1,    -1,    -1,   420,   421,   422,   423,   424,   425,
     426,   427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,
     446,   447,   448,   449,    -1,   451,   452,   453,   454,   455,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,
      -1,    -1,   468,    -1,    -1,   471,   472,   473,    -1,    -1,
     476,   477,    -1,   479,   480,   481,   482,   483,    -1,    -1,
     486,   487,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,    -1,   499,   500,   501,    -1,   503,   504,   505,
     506,    -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,
      -1,    -1,   518,   519,   520,   521,    -1,   523,   524,    -1,
     526,   527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,
     536,    -1,   538,    -1,   540,   541,    -1,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,   551,    -1,    -1,    -1,   555,
     556,   557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,
     566,   567,    -1,     5,   570,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      92,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,    -1,    -1,   169,    -1,    -1,
      -1,   173,   174,    -1,   176,    -1,   178,    -1,   180,   181,
     182,   183,    -1,   185,    -1,    -1,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,   196,    -1,    -1,    -1,   200,   201,
     202,   203,    -1,    -1,   206,   207,    -1,    -1,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,
      -1,   223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,
      -1,    -1,   234,   235,    -1,    -1,   238,    -1,    -1,   241,
     242,   243,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,
      -1,   253,    -1,   255,   256,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,    -1,   278,   279,    -1,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,    -1,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
     302,    -1,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,   313,    -1,    -1,   316,   317,    -1,    -1,   320,   321,
     322,   323,    -1,    -1,    -1,   327,   328,    -1,    -1,    -1,
      -1,   333,   334,   335,    -1,   337,   338,   339,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,    -1,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,    -1,    -1,   370,   371,
     372,    -1,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,   383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,    -1,    -1,   409,    -1,   411,
     412,   413,    -1,   415,   416,    -1,    -1,    -1,   420,   421,
     422,   423,   424,   425,   426,   427,   428,    -1,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,
     442,    -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,
     452,   453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,
     472,   473,    -1,    -1,   476,   477,    -1,   479,   480,   481,
     482,   483,    -1,    -1,   486,   487,   488,   489,    -1,   491,
     492,    -1,    -1,   495,   496,   497,    -1,   499,   500,   501,
      -1,   503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,
     512,   513,   514,    -1,    -1,    -1,   518,   519,   520,   521,
      -1,   523,   524,    -1,   526,   527,    -1,   529,   530,    -1,
      -1,   533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,
      -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,   551,
      -1,    -1,    -1,   555,   556,   557,   558,    -1,    -1,    -1,
      -1,   563,   564,    -1,   566,   567,    -1,     5,   570,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,    57,
      -1,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,   153,    -1,    -1,   156,   157,
     158,    -1,    -1,   161,   162,    -1,   164,   165,   166,    -1,
      -1,   169,    -1,    -1,    -1,   173,   174,    -1,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,    -1,
      -1,   189,   190,    -1,   192,    -1,    -1,   195,   196,    -1,
      -1,    -1,   200,   201,   202,   203,    -1,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
      -1,    -1,    -1,   231,    -1,    -1,   234,   235,    -1,    -1,
     238,    -1,    -1,   241,   242,   243,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,   302,    -1,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,    -1,   316,   317,
      -1,    -1,   320,   321,   322,   323,    -1,    -1,    -1,   327,
     328,    -1,    -1,    -1,    -1,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,    -1,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,    -1,   370,   371,   372,    -1,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,    -1,
      -1,   409,    -1,   411,   412,   413,    -1,   415,   416,    -1,
      -1,    -1,   420,   421,   422,   423,   424,   425,   426,   427,
     428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,   447,
     448,   449,    -1,   451,   452,   453,   454,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,   472,   473,    -1,    -1,   476,   477,
      -1,   479,   480,   481,   482,   483,    -1,    -1,   486,   487,
     488,   489,    -1,   491,   492,    -1,    -1,   495,   496,   497,
      -1,   499,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,    -1,    -1,
     518,   519,   520,   521,    -1,   523,   524,    -1,   526,   527,
      -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,    -1,
     538,    -1,   540,   541,    -1,    -1,    -1,    -1,    -1,    -1,
     548,    -1,    -1,   551,    -1,    -1,    -1,   555,   556,   557,
     558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,   567,
      -1,     5,   570,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    35,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    57,    -1,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
      -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
     234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,    -1,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,    -1,    -1,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
      -1,    -1,   476,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,   499,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,     5,   570,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,    -1,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,    -1,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
      -1,   241,   242,   243,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,   327,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,    -1,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,    -1,    -1,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,    -1,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,    -1,    -1,   476,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,   499,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,   518,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,     5,
     570,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,
      56,    57,    -1,    59,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,
      -1,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,   112,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,    -1,    -1,   161,   162,    -1,   164,   165,
     166,    -1,    -1,   169,    -1,    -1,    -1,   173,   174,    -1,
     176,    -1,   178,    -1,   180,   181,   182,   183,    -1,   185,
      -1,    -1,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
     196,    -1,    -1,    -1,   200,   201,   202,   203,    -1,    -1,
     206,   207,    -1,    -1,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,    -1,   223,   224,    -1,
     226,   227,    -1,    -1,    -1,   231,    -1,    -1,   234,   235,
      -1,    -1,   238,    -1,    -1,   241,   242,   243,    -1,    -1,
      -1,    -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,
     256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,    -1,    -1,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,   302,    -1,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,   313,    -1,    -1,
     316,   317,    -1,    -1,   320,   321,   322,   323,    -1,    -1,
      -1,   327,   328,    -1,    -1,    -1,    -1,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,    -1,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,    -1,   370,   371,   372,    -1,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,   383,    -1,    -1,
     386,    -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,    -1,    -1,   409,    -1,   411,   412,   413,    -1,   415,
     416,    -1,    -1,    -1,   420,   421,   422,   423,   424,   425,
     426,   427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,
     446,   447,   448,   449,    -1,   451,   452,   453,   454,   455,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,
      -1,    -1,   468,    -1,    -1,   471,   472,   473,    -1,    -1,
     476,   477,    -1,   479,   480,   481,   482,   483,    -1,    -1,
     486,   487,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,    -1,   499,   500,   501,    -1,   503,   504,   505,
     506,    -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,
      -1,    -1,   518,   519,   520,   521,    -1,   523,   524,    -1,
     526,   527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,
     536,    -1,   538,    -1,   540,   541,    -1,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,   551,    -1,    -1,    -1,   555,
     556,   557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,
     566,   567,    -1,     5,   570,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,    -1,    -1,   169,    -1,    -1,
      -1,   173,   174,    -1,   176,    -1,   178,    -1,   180,   181,
     182,   183,    -1,   185,    -1,    -1,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,   196,    -1,    -1,    -1,   200,   201,
     202,   203,    -1,    -1,   206,   207,    -1,    -1,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,
      -1,   223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,
      -1,    -1,   234,   235,    -1,    -1,   238,    -1,    -1,   241,
     242,   243,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,
      -1,   253,    -1,   255,   256,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,    -1,   278,   279,    -1,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,    -1,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
     302,    -1,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,   313,    -1,    -1,   316,   317,    -1,    -1,   320,   321,
     322,   323,    -1,    -1,    -1,   327,   328,    -1,    -1,    -1,
      -1,   333,   334,   335,    -1,   337,   338,   339,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,    -1,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,    -1,    -1,   370,   371,
     372,    -1,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,   383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,    -1,    -1,   409,    -1,   411,
     412,   413,    -1,   415,   416,    -1,    -1,    -1,   420,   421,
     422,   423,   424,   425,   426,   427,   428,    -1,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,
     442,    -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,
     452,   453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,
     472,   473,    -1,    -1,   476,   477,    -1,   479,   480,   481,
     482,   483,    -1,    -1,   486,   487,   488,   489,    -1,   491,
     492,    -1,    -1,   495,   496,   497,    -1,   499,   500,   501,
      -1,   503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,
     512,   513,   514,    -1,    -1,    -1,   518,   519,   520,   521,
      -1,   523,   524,    -1,   526,   527,    -1,   529,   530,    -1,
      -1,   533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,
      -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,   551,
      -1,    -1,    -1,   555,   556,   557,   558,    -1,    -1,    -1,
      -1,   563,   564,    -1,   566,   567,    -1,     5,   570,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,    57,
      -1,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,   153,    -1,    -1,   156,   157,
     158,    -1,    -1,   161,   162,    -1,   164,   165,   166,    -1,
      -1,   169,    -1,    -1,    -1,   173,   174,    -1,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,    -1,
      -1,   189,   190,    -1,   192,    -1,    -1,   195,   196,    -1,
      -1,    -1,   200,   201,   202,   203,    -1,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
      -1,    -1,    -1,   231,    -1,    -1,   234,   235,    -1,    -1,
     238,    -1,    -1,   241,   242,    -1,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,   302,    -1,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,    -1,   316,   317,
      -1,    -1,   320,   321,   322,   323,    -1,    -1,    -1,   327,
     328,    -1,    -1,    -1,    -1,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,    -1,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,    -1,   370,   371,   372,    -1,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,    -1,
      -1,   409,    -1,   411,   412,   413,    -1,   415,   416,    -1,
      -1,    -1,   420,   421,   422,   423,   424,   425,   426,   427,
     428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,   447,
     448,   449,    -1,   451,   452,   453,   454,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,   472,   473,    -1,    -1,   476,   477,
      -1,   479,   480,   481,   482,   483,    -1,    -1,   486,   487,
     488,   489,    -1,   491,   492,    -1,    -1,   495,   496,   497,
      -1,   499,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,    -1,    -1,
     518,   519,   520,   521,    -1,   523,   524,    -1,   526,   527,
      -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,    -1,
     538,    -1,   540,   541,    -1,    -1,    -1,    -1,    -1,    -1,
     548,    -1,    -1,   551,    -1,    -1,    -1,   555,   556,   557,
     558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,   567,
      -1,     5,   570,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    57,    -1,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    83,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
      -1,   155,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
      -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
     234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,    -1,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,    -1,    -1,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
      -1,    -1,   476,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,     5,   570,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,    -1,    -1,   169,
      -1,    -1,    -1,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,    -1,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
      -1,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,   327,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,    -1,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,    -1,    -1,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,    -1,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,    -1,    -1,   476,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,    -1,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,   518,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,     5,
     570,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,
      56,    57,    -1,    59,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,
      -1,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,   112,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,    -1,    -1,   161,   162,    -1,   164,   165,
     166,    -1,    -1,   169,    -1,    -1,    -1,   173,   174,    -1,
     176,    -1,   178,    -1,   180,   181,   182,   183,    -1,   185,
      -1,    -1,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
     196,    -1,    -1,    -1,   200,   201,   202,   203,    -1,    -1,
     206,   207,    -1,    -1,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,    -1,   223,   224,    -1,
     226,   227,    -1,    -1,    -1,   231,    -1,    -1,   234,   235,
      -1,    -1,   238,    -1,    -1,   241,   242,    -1,    -1,    -1,
      -1,    -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,
     256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,    -1,    -1,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,   302,    -1,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,   313,    -1,    -1,
     316,   317,    -1,    -1,   320,   321,   322,   323,    -1,    -1,
      -1,   327,   328,    -1,    -1,    -1,    -1,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,    -1,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,    -1,   370,   371,   372,    -1,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,   383,    -1,    -1,
     386,    -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,    -1,    -1,   409,    -1,   411,   412,   413,    -1,   415,
     416,    -1,    -1,    -1,   420,   421,   422,   423,   424,   425,
     426,   427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,
     446,   447,   448,   449,    -1,   451,   452,   453,   454,   455,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,
      -1,    -1,   468,    -1,    -1,   471,   472,   473,    -1,    -1,
     476,   477,    -1,   479,   480,   481,   482,   483,    -1,    -1,
     486,   487,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,    -1,    -1,   500,   501,    -1,   503,   504,   505,
     506,    -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,
      -1,    -1,   518,   519,   520,   521,    -1,   523,   524,    -1,
     526,   527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,
     536,    -1,   538,    -1,   540,   541,    -1,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,   551,    -1,    -1,    -1,   555,
     556,   557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,
     566,   567,    -1,     5,   570,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
     112,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,    -1,    -1,   169,    -1,    -1,
      -1,   173,   174,    -1,   176,    -1,   178,    -1,   180,   181,
     182,   183,    -1,   185,    -1,    -1,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,   196,    -1,    -1,    -1,   200,   201,
     202,   203,    -1,    -1,   206,   207,    -1,    -1,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,
      -1,   223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,
      -1,    -1,   234,   235,    -1,    -1,   238,    -1,    -1,   241,
     242,    -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,
      -1,   253,    -1,   255,   256,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,    -1,   278,   279,    -1,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,    -1,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
     302,    -1,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,   313,    -1,    -1,   316,   317,    -1,    -1,   320,   321,
     322,   323,    -1,    -1,    -1,   327,   328,    -1,    -1,    -1,
      -1,   333,   334,   335,    -1,   337,   338,   339,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,    -1,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,    -1,    -1,   370,   371,
     372,    -1,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,   383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,    -1,    -1,   409,    -1,   411,
     412,   413,    -1,   415,   416,    -1,    -1,    -1,   420,   421,
     422,   423,   424,   425,   426,   427,   428,    -1,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,
     442,    -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,
     452,   453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,
     472,   473,    -1,    -1,   476,   477,    -1,   479,   480,   481,
     482,   483,    -1,    -1,   486,   487,   488,   489,    -1,   491,
     492,    -1,    -1,   495,   496,   497,    -1,    -1,   500,   501,
      -1,   503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,
     512,   513,   514,    -1,    -1,    -1,   518,   519,   520,   521,
      -1,   523,   524,    -1,   526,   527,    -1,   529,   530,    -1,
      -1,   533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,
      -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,   551,
      -1,    -1,    -1,   555,   556,   557,   558,    -1,    -1,    -1,
      -1,   563,   564,    -1,   566,   567,    -1,     5,   570,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,    57,
      -1,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,   153,    -1,    -1,   156,   157,
     158,    -1,    -1,   161,   162,    -1,   164,   165,   166,    -1,
      -1,   169,    -1,    -1,    -1,   173,   174,    -1,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,    -1,
      -1,   189,   190,    -1,   192,    -1,    -1,   195,   196,    -1,
      -1,    -1,   200,   201,   202,   203,    -1,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
      -1,    -1,    -1,   231,    -1,    -1,   234,   235,    -1,    -1,
     238,    -1,    -1,   241,   242,    -1,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,   302,    -1,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,    -1,   316,   317,
      -1,    -1,   320,   321,   322,   323,    -1,    -1,    -1,   327,
     328,    -1,    -1,    -1,    -1,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,    -1,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,    -1,   370,   371,   372,   373,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,    -1,
      -1,   409,    -1,   411,   412,   413,    -1,   415,   416,    -1,
      -1,    -1,   420,   421,   422,   423,   424,   425,   426,   427,
     428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,   447,
     448,   449,    -1,   451,   452,   453,   454,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,   472,   473,    -1,    -1,   476,   477,
      -1,   479,   480,   481,   482,   483,    -1,    -1,   486,   487,
     488,   489,    -1,   491,   492,    -1,    -1,   495,   496,   497,
      -1,    -1,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,    -1,    -1,
     518,   519,   520,   521,    -1,   523,   524,    -1,   526,   527,
      -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,    -1,
     538,    -1,   540,   541,    -1,    -1,    -1,    -1,    -1,    -1,
     548,    -1,    -1,   551,    -1,    -1,    -1,   555,   556,   557,
     558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,   567,
      -1,     5,   570,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    57,    -1,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,    -1,    -1,   169,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,   196,    -1,    -1,    -1,   200,   201,   202,   203,
      -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
     234,   235,    -1,    -1,   238,    -1,    -1,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,   327,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,    -1,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,    -1,   370,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,    -1,    -1,   409,    -1,   411,   412,   413,
      -1,   415,   416,    -1,    -1,    -1,   420,   421,   422,   423,
     424,   425,   426,   427,   428,    -1,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,   447,   448,   449,    -1,   451,   452,   453,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,   472,   473,
      -1,    -1,   476,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,   518,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,   529,   530,    -1,    -1,   533,
      -1,    -1,   536,    -1,   538,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
     564,    -1,   566,   567,    -1,     5,   570,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,    -1,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,   196,    -1,    -1,    -1,
     200,   201,   202,   203,    -1,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,    -1,    -1,
      -1,   231,    -1,    -1,   234,   235,    -1,    -1,   238,    -1,
      -1,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,   327,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,    -1,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,    -1,
     370,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,    -1,    -1,   409,
      -1,   411,   412,   413,    -1,   415,   416,    -1,    -1,    -1,
     420,   421,   422,   423,   424,   425,   426,   427,   428,    -1,
     430,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,   447,   448,   449,
      -1,   451,   452,   453,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,   472,   473,    -1,    -1,   476,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,   499,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,   518,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,   529,
     530,    -1,    -1,   533,    -1,    -1,   536,    -1,   538,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,    -1,
      -1,    -1,    -1,   563,   564,    -1,   566,   567,    -1,     5,
     570,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,
      56,    57,    -1,    59,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,
      -1,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,   112,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,    -1,    -1,   161,   162,    -1,   164,   165,
     166,    -1,    -1,   169,    -1,    -1,    -1,   173,   174,    -1,
     176,    -1,   178,    -1,   180,   181,   182,   183,    -1,   185,
      -1,    -1,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
     196,    -1,    -1,    -1,   200,   201,   202,   203,    -1,    -1,
     206,   207,    -1,    -1,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,    -1,   223,   224,    -1,
     226,   227,    -1,    -1,    -1,   231,    -1,    -1,   234,   235,
      -1,    -1,   238,    -1,    -1,   241,   242,    -1,    -1,    -1,
      -1,    -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,
     256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,    -1,    -1,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,   302,    -1,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,   313,    -1,    -1,
     316,   317,    -1,    -1,   320,   321,   322,   323,    -1,    -1,
      -1,   327,   328,    -1,    -1,    -1,    -1,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,    -1,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,    -1,   370,   371,   372,    -1,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,   383,    -1,    -1,
     386,    -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,    -1,    -1,   409,    -1,   411,   412,   413,    -1,   415,
     416,    -1,    -1,    -1,   420,   421,   422,   423,   424,   425,
     426,   427,   428,    -1,   430,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,    -1,    -1,   442,    -1,    -1,    -1,
     446,   447,   448,   449,    -1,   451,   452,   453,   454,   455,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,
      -1,    -1,   468,    -1,    -1,   471,   472,   473,    -1,    -1,
     476,   477,    -1,   479,   480,   481,   482,   483,    -1,    -1,
     486,   487,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,    -1,    -1,   500,   501,    -1,   503,   504,   505,
     506,    -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,
      -1,    -1,   518,   519,   520,   521,    -1,   523,   524,    -1,
     526,   527,    -1,   529,   530,    -1,    -1,   533,    -1,    -1,
     536,    -1,   538,    -1,   540,   541,    -1,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,   551,    -1,    -1,    -1,   555,
     556,   557,   558,    -1,    -1,    -1,    -1,   563,   564,    -1,
     566,   567,    -1,     5,   570,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,    -1,    -1,   169,    -1,    -1,
      -1,   173,   174,    -1,   176,    -1,   178,    -1,   180,   181,
     182,   183,    -1,   185,    -1,    -1,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,   196,    -1,    -1,    -1,   200,   201,
     202,   203,    -1,    -1,   206,   207,    -1,    -1,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,
      -1,   223,   224,    -1,   226,   227,    -1,    -1,    -1,   231,
      -1,    -1,   234,   235,    -1,    -1,   238,    -1,    -1,   241,
     242,    -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,
      -1,   253,    -1,   255,   256,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,    -1,   278,   279,    -1,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,    -1,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
     302,    -1,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,   313,    -1,    -1,   316,   317,    -1,    -1,   320,   321,
     322,   323,    -1,    -1,    -1,   327,   328,    -1,    -1,    -1,
      -1,   333,   334,   335,    -1,   337,   338,   339,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,    -1,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,    -1,    -1,   370,   371,
     372,    -1,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,   383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,    -1,    -1,   409,    -1,   411,
     412,   413,    -1,   415,   416,    -1,    -1,    -1,   420,   421,
     422,   423,   424,   425,   426,   427,   428,    -1,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,    -1,    -1,
     442,    -1,    -1,    -1,   446,   447,   448,   449,    -1,   451,
     452,   453,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,
     472,   473,    -1,    -1,   476,   477,    -1,   479,   480,   481,
     482,   483,    -1,    -1,   486,   487,   488,   489,    -1,   491,
     492,    -1,    -1,   495,   496,   497,    -1,    -1,   500,   501,
      -1,   503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,
     512,   513,   514,    -1,    -1,    -1,   518,   519,   520,   521,
      -1,   523,   524,    -1,   526,   527,    -1,   529,   530,    -1,
      -1,   533,    -1,    -1,   536,    -1,   538,    -1,   540,   541,
      -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,   551,
      -1,    -1,    -1,   555,   556,   557,   558,    -1,    -1,    -1,
      -1,   563,   564,    -1,   566,   567,    -1,     5,   570,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,    57,
      -1,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,   153,    -1,    -1,   156,   157,
     158,    -1,    -1,   161,   162,    -1,   164,   165,   166,    -1,
      -1,   169,    -1,    -1,    -1,   173,   174,    -1,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,    -1,
      -1,   189,   190,    -1,   192,    -1,    -1,   195,   196,    -1,
      -1,    -1,   200,   201,   202,   203,    -1,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
      -1,    -1,    -1,   231,    -1,    -1,   234,   235,    -1,    -1,
     238,    -1,    -1,   241,   242,    -1,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,   302,    -1,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,    -1,   316,   317,
      -1,    -1,   320,   321,   322,   323,    -1,    -1,    -1,   327,
     328,    -1,    -1,    -1,    -1,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,    -1,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,    -1,   370,   371,   372,    -1,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,    -1,
      -1,   409,    -1,   411,   412,   413,    -1,   415,   416,    -1,
      -1,    -1,   420,   421,   422,   423,   424,   425,   426,   427,
     428,    -1,   430,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,   447,
     448,   449,    -1,   451,   452,   453,   454,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,   472,   473,    -1,    -1,   476,   477,
      -1,   479,   480,   481,   482,   483,    -1,    -1,   486,   487,
     488,   489,    -1,   491,   492,    -1,    -1,   495,   496,   497,
      -1,    -1,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,    -1,    -1,
     518,   519,   520,   521,    -1,   523,   524,    -1,   526,   527,
      -1,   529,   530,    -1,    -1,   533,    -1,    -1,   536,    -1,
     538,    -1,   540,   541,    -1,    -1,    -1,    -1,    -1,    -1,
     548,    -1,    -1,   551,    -1,    -1,    -1,   555,   556,   557,
     558,    -1,    -1,    -1,    -1,   563,   564,    -1,   566,   567,
      -1,     5,   570,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,
      54,    -1,    56,    -1,    -1,    -1,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    -1,    71,    -1,    73,
      74,    75,    76,    -1,    78,    79,    -1,    -1,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,
      -1,   135,   136,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,   163,
     164,   165,   166,    -1,    -1,    -1,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,    -1,   190,    -1,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,   200,   201,   202,   203,
     204,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,   228,    -1,    -1,   231,    -1,    -1,
      -1,   235,    -1,    -1,   238,   239,    -1,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,   261,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   352,   353,
     354,    -1,    -1,   357,   358,   359,    -1,   361,   362,   363,
     364,   365,   366,    -1,    -1,    -1,    -1,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,    -1,    -1,
     404,    -1,   406,   407,    -1,   409,    -1,    -1,   412,    -1,
      -1,   415,   416,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,   426,    -1,   428,    -1,   430,    -1,    -1,    -1,
      -1,   435,   436,   437,    -1,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,    -1,   473,
      -1,    -1,    -1,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,    -1,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,    -1,    -1,    -1,    -1,   533,
      -1,    -1,   536,    -1,    -1,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,   561,    -1,   563,
      -1,    -1,   566,    -1,    -1,     5,   570,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    22,    23,    24,    25,    26,    27,    -1,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    -1,    -1,    -1,
      -1,    51,    52,    -1,    54,    -1,    56,    -1,    -1,    -1,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      -1,    71,    -1,    73,    74,    75,    76,    -1,    78,    79,
      -1,    -1,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,    -1,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,   135,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,   163,   164,   165,   166,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,    -1,
     190,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,
     200,   201,   202,   203,   204,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,   228,    -1,
      -1,   231,    -1,    -1,    -1,   235,    -1,    -1,   238,   239,
      -1,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,   261,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   352,   353,   354,    -1,    -1,   357,   358,   359,
      -1,   361,   362,   363,   364,   365,   366,    -1,    -1,    -1,
      -1,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,    -1,    -1,   404,    -1,   406,   407,    -1,   409,
      -1,    -1,   412,    -1,    -1,   415,   416,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,   426,    -1,   428,    -1,
     430,    -1,    -1,    -1,    -1,   435,   436,   437,    -1,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,    -1,   473,    -1,    -1,    -1,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,    -1,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,    -1,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,    -1,
      -1,    -1,    -1,   533,    -1,    -1,   536,    -1,    -1,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,   559,
      -1,   561,    -1,   563,    -1,    -1,   566,    -1,    -1,     5,
     570,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,
      26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    54,    -1,
      56,    -1,    -1,    -1,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    -1,    71,    -1,    73,    74,    75,
      76,    -1,    78,    79,    -1,    -1,    82,    -1,    84,    -1,
      -1,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   107,    -1,    -1,    -1,    -1,    -1,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,   135,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,    -1,    -1,
     156,   157,   158,    -1,    -1,   161,   162,   163,   164,   165,
     166,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
     176,    -1,   178,    -1,   180,   181,   182,   183,    -1,   185,
      -1,    -1,    -1,    -1,   190,    -1,    -1,    -1,    -1,    -1,
     196,    -1,    -1,    -1,   200,   201,   202,   203,   204,    -1,
     206,   207,    -1,    -1,   210,    -1,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,    -1,   221,    -1,   223,   224,    -1,
     226,   227,   228,    -1,    -1,   231,    -1,    -1,    -1,   235,
      -1,    -1,   238,   239,    -1,   241,   242,    -1,    -1,    -1,
      -1,    -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,
     256,    -1,    -1,    -1,    -1,   261,    -1,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,    -1,    -1,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,   302,    -1,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,   313,    -1,    -1,
     316,   317,    -1,    -1,   320,   321,   322,   323,    -1,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,   335,
      -1,   337,   338,   339,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   352,   353,   354,    -1,
      -1,   357,   358,   359,    -1,   361,   362,   363,   364,   365,
     366,    -1,    -1,    -1,    -1,   371,   372,    -1,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,   383,    -1,    -1,
     386,    -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,    -1,   401,    -1,    -1,   404,    -1,
     406,   407,    -1,   409,    -1,    -1,   412,    -1,    -1,   415,
     416,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
     426,    -1,   428,    -1,   430,    -1,    -1,    -1,    -1,   435,
     436,   437,    -1,    -1,    -1,    -1,   442,    -1,    -1,    -1,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,
      -1,    -1,   468,    -1,    -1,   471,    -1,   473,    -1,    -1,
      -1,   477,    -1,   479,   480,   481,   482,   483,    -1,    -1,
     486,   487,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,    -1,    -1,   500,   501,    -1,   503,   504,   505,
     506,    -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,
      -1,    -1,    -1,   519,   520,   521,    -1,   523,   524,    -1,
     526,   527,    -1,    -1,    -1,    -1,    -1,   533,    -1,    -1,
     536,    -1,    -1,    -1,   540,   541,    -1,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,   551,    -1,    -1,    -1,   555,
     556,   557,   558,   559,    -1,   561,    -1,   563,    -1,    -1,
     566,    -1,    -1,     5,   570,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    -1,    56,    -1,    -1,    -1,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    -1,    71,
      -1,    73,    74,    75,    76,    -1,    78,    79,    -1,    -1,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,   163,   164,   165,   166,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,   176,    -1,   178,    -1,   180,   181,
     182,   183,    -1,   185,    -1,    -1,    -1,    -1,   190,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,   200,   201,
     202,   203,   204,    -1,   206,   207,    -1,    -1,   210,    -1,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,    -1,   221,
      -1,   223,   224,    -1,   226,   227,   228,    -1,    -1,   231,
      -1,    -1,    -1,   235,    -1,    -1,   238,   239,    -1,   241,
     242,    -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,
      -1,   253,    -1,   255,   256,    -1,    -1,    -1,    -1,   261,
      -1,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,    -1,   278,   279,    -1,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,    -1,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
     302,    -1,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,   313,    -1,    -1,   316,   317,    -1,    -1,   320,   321,
     322,   323,    -1,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,   335,    -1,   337,   338,   339,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     352,   353,   354,    -1,    -1,   357,   358,   359,    -1,   361,
     362,   363,   364,   365,   366,    -1,    -1,    -1,    -1,   371,
     372,    -1,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,   383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
      -1,    -1,   404,    -1,   406,   407,    -1,   409,    -1,    -1,
     412,    -1,    -1,   415,   416,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,   426,    -1,   428,    -1,   430,    -1,
      -1,    -1,    -1,   435,   436,   437,    -1,    -1,    -1,    -1,
     442,    -1,    -1,    -1,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,
      -1,   473,    -1,    -1,    -1,   477,    -1,   479,   480,   481,
     482,   483,    -1,    -1,   486,   487,   488,   489,    -1,   491,
     492,    -1,    -1,   495,   496,   497,    -1,    -1,   500,   501,
      -1,   503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,
     512,   513,   514,    -1,    -1,    -1,    -1,   519,   520,   521,
      -1,   523,   524,    -1,   526,   527,    -1,    -1,    -1,    -1,
      -1,   533,    -1,    -1,   536,    -1,    -1,    -1,   540,   541,
      -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,   551,
      -1,    -1,    -1,   555,   556,   557,   558,    -1,    -1,   561,
      -1,   563,    -1,    -1,   566,    -1,    -1,     5,   570,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,    27,
      -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    -1,
      -1,    -1,    -1,    51,    52,    -1,    54,    -1,    56,    -1,
      -1,    -1,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    -1,    71,    -1,    73,    74,    75,    76,    -1,
      78,    79,    -1,    -1,    82,    -1,    84,    -1,    -1,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
      -1,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
      -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,    -1,    -1,   156,   157,
     158,    -1,    -1,   161,   162,   163,   164,   165,   166,    -1,
      -1,    -1,    -1,    -1,    -1,   173,   174,    -1,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,    -1,
      -1,    -1,   190,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,   200,   201,   202,   203,   204,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
     228,    -1,    -1,   231,    -1,    -1,    -1,   235,    -1,    -1,
     238,   239,    -1,   241,   242,    -1,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,    -1,    -1,   261,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,   302,    -1,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,    -1,   316,   317,
      -1,    -1,   320,   321,   322,   323,    -1,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,   335,    -1,   337,
     338,   339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   352,   353,   354,    -1,    -1,   357,
     358,   359,    -1,   361,   362,   363,   364,   365,   366,    -1,
      -1,    -1,    -1,   371,   372,    -1,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,    -1,    -1,   404,    -1,   406,   407,
      -1,   409,    -1,    -1,   412,    -1,    -1,   415,   416,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,   426,    -1,
     428,    -1,   430,    -1,    -1,    -1,    -1,   435,   436,   437,
      -1,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,    -1,   473,    -1,    -1,    -1,   477,
      -1,   479,   480,   481,   482,   483,    -1,    -1,   486,   487,
     488,   489,    -1,   491,   492,    -1,    -1,   495,   496,   497,
      -1,    -1,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,    -1,    -1,
      -1,   519,   520,   521,    -1,   523,   524,    -1,   526,   527,
      -1,    -1,    -1,    -1,    -1,   533,    -1,    -1,   536,    -1,
      -1,    -1,   540,   541,    -1,    -1,    -1,    -1,    -1,    -1,
     548,    -1,    -1,   551,    -1,    -1,    -1,   555,   556,   557,
     558,    -1,    -1,   561,    -1,   563,    -1,    -1,   566,    -1,
      -1,     5,   570,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,
      54,    -1,    56,    -1,    -1,    -1,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    -1,    71,    -1,    73,
      74,    75,    76,    -1,    78,    79,    -1,    -1,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,   163,
     164,   165,   166,    -1,    -1,    -1,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,    -1,   190,    -1,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,   200,   201,   202,   203,
     204,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,   228,    -1,    -1,   231,    -1,    -1,
      -1,   235,    -1,    -1,   238,   239,    -1,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,   261,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,   339,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   352,   353,
     354,    -1,    -1,   357,   358,   359,    -1,   361,   362,   363,
     364,   365,   366,    -1,    -1,    -1,    -1,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,    -1,    -1,
     404,    -1,   406,   407,    -1,   409,    -1,    -1,   412,    -1,
      -1,   415,   416,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,   426,    -1,   428,    -1,   430,    -1,    -1,    -1,
      -1,   435,   436,   437,    -1,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,    -1,   473,
      -1,    -1,    -1,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,    -1,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,    -1,    -1,    -1,    -1,   533,
      -1,    -1,   536,    -1,    -1,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,   561,    -1,   563,
      -1,    -1,   566,    -1,    -1,     5,   570,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    22,    23,    24,    25,    26,    27,    -1,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    -1,    -1,    -1,
      -1,    51,    52,    -1,    54,    -1,    56,    -1,    -1,    -1,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      -1,    71,    -1,    73,    74,    75,    76,    -1,    78,    79,
      -1,    -1,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,    -1,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,   163,   164,   165,   166,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,   176,    -1,   178,    -1,
     180,   181,   182,   183,    -1,   185,    -1,    -1,    -1,    -1,
     190,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,
     200,   201,   202,   203,   204,    -1,   206,   207,    -1,    -1,
     210,    -1,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
      -1,   221,    -1,   223,   224,    -1,   226,   227,   228,    -1,
      -1,   231,    -1,    -1,    -1,   235,    -1,    -1,   238,   239,
      -1,   241,   242,    -1,    -1,    -1,    -1,    -1,   248,   249,
      -1,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,   261,    -1,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,   279,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
      -1,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,    -1,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,   313,    -1,    -1,   316,   317,    -1,    -1,
     320,   321,   322,   323,    -1,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,   335,    -1,   337,   338,   339,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   352,   353,   354,    -1,    -1,   357,   358,   359,
      -1,   361,   362,   363,   364,   365,   366,    -1,    -1,    -1,
      -1,   371,   372,    -1,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,   383,    -1,    -1,   386,    -1,    -1,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
      -1,   401,    -1,    -1,   404,    -1,   406,   407,    -1,   409,
      -1,    -1,   412,    -1,    -1,   415,   416,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,   426,    -1,   428,    -1,
     430,    -1,    -1,    -1,    -1,   435,   436,   437,    -1,    -1,
      -1,    -1,   442,    -1,    -1,    -1,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,   465,    -1,    -1,   468,    -1,
      -1,   471,    -1,   473,    -1,    -1,    -1,   477,    -1,   479,
     480,   481,   482,   483,    -1,    -1,   486,   487,   488,   489,
      -1,   491,   492,    -1,    -1,   495,   496,   497,    -1,    -1,
     500,   501,    -1,   503,   504,   505,   506,    -1,    -1,    -1,
      -1,    -1,   512,   513,   514,    -1,    -1,    -1,    -1,   519,
     520,   521,    -1,   523,   524,    -1,   526,   527,    -1,    -1,
      -1,    -1,    -1,   533,    -1,    -1,   536,    -1,    -1,    -1,
     540,   541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,
      -1,   551,    -1,    -1,    -1,   555,   556,   557,   558,    -1,
      -1,   561,    -1,   563,    -1,    -1,   566,    -1,    -1,     5,
     570,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,
      26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    54,    -1,
      56,    -1,    -1,    -1,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    -1,    71,    -1,    73,    74,    75,
      76,    -1,    78,    79,    -1,    -1,    82,    -1,    84,    -1,
      -1,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   107,    -1,    -1,    -1,    -1,    -1,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,    -1,    -1,
     156,   157,   158,    -1,    -1,   161,   162,   163,   164,   165,
     166,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
     176,    -1,   178,    -1,   180,   181,   182,   183,    -1,   185,
      -1,    -1,    -1,    -1,   190,    -1,    -1,    -1,    -1,    -1,
     196,    -1,    -1,    -1,   200,   201,   202,   203,   204,    -1,
     206,   207,    -1,    -1,   210,    -1,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,    -1,   221,    -1,   223,   224,    -1,
     226,   227,   228,    -1,    -1,   231,    -1,    -1,    -1,   235,
      -1,    -1,   238,   239,    -1,   241,   242,    -1,    -1,    -1,
      -1,    -1,   248,   249,    -1,   251,    -1,   253,    -1,   255,
     256,    -1,    -1,    -1,    -1,   261,    -1,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,    -1,    -1,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,   302,    -1,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,   313,    -1,    -1,
     316,   317,    -1,    -1,   320,   321,   322,   323,    -1,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,   335,
      -1,   337,   338,   339,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   352,   353,   354,    -1,
      -1,   357,   358,   359,    -1,   361,   362,   363,   364,   365,
     366,    -1,    -1,    -1,    -1,   371,   372,    -1,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,   383,    -1,    -1,
     386,    -1,    -1,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,    -1,   401,    -1,    -1,   404,    -1,
     406,   407,    -1,   409,    -1,    -1,   412,    -1,    -1,   415,
     416,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
     426,    -1,   428,    -1,   430,    -1,    -1,    -1,    -1,   435,
     436,   437,    -1,    -1,    -1,    -1,   442,    -1,    -1,    -1,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,    -1,   465,
      -1,    -1,   468,    -1,    -1,   471,    -1,   473,    -1,    -1,
      -1,   477,    -1,   479,   480,   481,   482,   483,    -1,    -1,
     486,   487,   488,   489,    -1,   491,   492,    -1,    -1,   495,
     496,   497,    -1,    -1,   500,   501,    -1,   503,   504,   505,
     506,    -1,    -1,    -1,    -1,    -1,   512,   513,   514,    -1,
      -1,    -1,    -1,   519,   520,   521,    -1,   523,   524,    -1,
     526,   527,    -1,    -1,    -1,    -1,    -1,   533,    -1,    -1,
     536,    -1,    -1,    -1,   540,   541,    -1,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,   551,    -1,    -1,    -1,   555,
     556,   557,   558,    -1,    -1,   561,    -1,   563,    -1,    -1,
     566,    -1,    -1,     5,   570,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    -1,    56,    -1,    -1,    -1,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    -1,    71,
      -1,    73,    74,    75,    76,    -1,    78,    79,    -1,    -1,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,   163,   164,   165,   166,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,   176,    -1,   178,    -1,   180,   181,
     182,   183,    -1,   185,    -1,    -1,    -1,    -1,   190,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,   200,   201,
     202,   203,   204,    -1,   206,   207,    -1,    -1,   210,    -1,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,    -1,   221,
      -1,   223,   224,    -1,   226,   227,   228,    -1,    -1,   231,
      -1,    -1,    -1,   235,    -1,    -1,   238,   239,    -1,   241,
     242,    -1,    -1,    -1,    -1,    -1,   248,   249,    -1,   251,
      -1,   253,    -1,   255,   256,    -1,    -1,    -1,    -1,   261,
      -1,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,    -1,   278,   279,    -1,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,    -1,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
     302,    -1,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,   313,    -1,    -1,   316,   317,    -1,    -1,   320,   321,
     322,   323,    -1,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,   335,    -1,   337,   338,   339,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     352,   353,   354,    -1,    -1,   357,   358,   359,    -1,   361,
     362,   363,   364,   365,   366,    -1,    -1,    -1,    -1,   371,
     372,    -1,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,   383,    -1,    -1,   386,    -1,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
      -1,    -1,   404,    -1,   406,   407,    -1,   409,    -1,    -1,
     412,    -1,    -1,   415,   416,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,   426,    -1,   428,    -1,   430,    -1,
      -1,    -1,    -1,   435,   436,   437,    -1,    -1,    -1,    -1,
     442,    -1,    -1,    -1,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,    -1,   465,    -1,    -1,   468,    -1,    -1,   471,
      -1,   473,    -1,    -1,    -1,   477,    -1,   479,   480,   481,
     482,   483,    -1,    -1,   486,   487,   488,   489,    -1,   491,
     492,    -1,    -1,   495,   496,   497,    -1,    -1,   500,   501,
      -1,   503,   504,   505,   506,    -1,    -1,    -1,    -1,    -1,
     512,   513,   514,    -1,    -1,    -1,    -1,   519,   520,   521,
      -1,   523,   524,    -1,   526,   527,    -1,    -1,    -1,    -1,
      -1,   533,    -1,    -1,   536,    -1,    -1,    -1,   540,   541,
      -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,   551,
      -1,    -1,    -1,   555,   556,   557,   558,    -1,    -1,   561,
      -1,   563,    -1,    -1,   566,    -1,    -1,     5,   570,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,    27,
      -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    -1,
      -1,    -1,    -1,    51,    52,    -1,    54,    -1,    56,    -1,
      -1,    -1,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    -1,    71,    -1,    73,    74,    75,    76,    -1,
      78,    79,    -1,    -1,    82,    -1,    84,    -1,    -1,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
      -1,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
      -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,    -1,    -1,   156,   157,
     158,    -1,    -1,   161,   162,   163,   164,   165,   166,    -1,
      -1,    -1,    -1,    -1,    -1,   173,   174,    -1,   176,    -1,
     178,    -1,   180,   181,   182,   183,    -1,   185,    -1,    -1,
      -1,    -1,   190,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,   200,   201,   202,   203,   204,    -1,   206,   207,
      -1,    -1,   210,    -1,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,    -1,   221,    -1,   223,   224,    -1,   226,   227,
     228,    -1,    -1,   231,    -1,    -1,    -1,   235,    -1,    -1,
     238,   239,    -1,   241,   242,    -1,    -1,    -1,    -1,    -1,
     248,   249,    -1,   251,    -1,   253,    -1,   255,   256,    -1,
      -1,    -1,    -1,   261,    -1,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,   279,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,    -1,    -1,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,   302,    -1,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,   313,    -1,    -1,   316,   317,
      -1,    -1,   320,   321,   322,   323,    -1,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,   335,    -1,   337,
     338,   339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   352,   353,   354,    -1,    -1,   357,
     358,   359,    -1,   361,   362,   363,   364,   365,   366,    -1,
      -1,    -1,    -1,   371,   372,    -1,   374,    -1,   376,   377,
     378,   379,    -1,   381,   382,   383,    -1,    -1,   386,    -1,
      -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,    -1,   401,    -1,    -1,   404,    -1,   406,   407,
      -1,   409,    -1,    -1,   412,    -1,    -1,   415,   416,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,   426,    -1,
     428,    -1,   430,    -1,    -1,    -1,    -1,   435,   436,   437,
      -1,    -1,    -1,    -1,   442,    -1,    -1,    -1,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,    -1,   465,    -1,    -1,
     468,    -1,    -1,   471,    -1,   473,    -1,    -1,    -1,   477,
      -1,   479,   480,   481,   482,   483,    -1,    -1,   486,   487,
     488,   489,    -1,   491,   492,    -1,    -1,   495,   496,   497,
      -1,    -1,   500,   501,    -1,   503,   504,   505,   506,    -1,
      -1,    -1,    -1,    -1,   512,   513,   514,    -1,    -1,    -1,
      -1,   519,   520,   521,    -1,   523,   524,    -1,   526,   527,
      -1,    -1,    -1,    -1,    -1,   533,    -1,    -1,   536,    -1,
      -1,    -1,   540,   541,    -1,    -1,    -1,    -1,    -1,    -1,
     548,    -1,    -1,   551,    -1,    -1,    -1,   555,   556,   557,
     558,    -1,    -1,   561,    -1,   563,    -1,    -1,   566,    -1,
      -1,     5,   570,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    -1,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    -1,    -1,    -1,    -1,    61,    62,    -1,
      64,    65,    -1,    67,    68,    -1,    -1,    71,    -1,    73,
      74,    75,    76,    -1,    78,    79,    -1,    -1,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,    -1,    -1,    -1,    -1,    -1,    -1,   173,
     174,    -1,   176,    -1,   178,    -1,   180,   181,   182,   183,
      -1,   185,    -1,    -1,    -1,    -1,   190,    -1,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,   200,   201,   202,   203,
      -1,    -1,   206,   207,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,    -1,   221,    -1,   223,
     224,    -1,   226,   227,    -1,    -1,    -1,   231,    -1,    -1,
      -1,   235,    -1,    -1,   238,    -1,    -1,   241,   242,    -1,
      -1,    -1,    -1,    -1,   248,   249,    -1,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,    -1,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,   302,    -1,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,   316,   317,    -1,    -1,   320,   321,   322,   323,
      -1,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,   335,    -1,   337,   338,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   352,   353,
     354,    -1,    -1,   357,   358,   359,    -1,   361,   362,   363,
     364,   365,   366,    -1,    -1,    -1,    -1,   371,   372,    -1,
     374,    -1,   376,   377,   378,   379,    -1,   381,   382,   383,
      -1,    -1,   386,    -1,    -1,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,    -1,   401,    -1,    -1,
     404,    -1,   406,    -1,    -1,   409,    -1,    -1,   412,    -1,
      -1,   415,   416,    -1,    -1,    -1,    -1,   421,   422,   423,
     424,   425,   426,    -1,   428,    -1,   430,    -1,    -1,    -1,
      -1,   435,   436,   437,    -1,    -1,    -1,    -1,   442,    -1,
      -1,    -1,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
      -1,   465,    -1,    -1,   468,    -1,    -1,   471,    -1,   473,
      -1,    -1,    -1,   477,    -1,   479,   480,   481,   482,   483,
      -1,    -1,   486,   487,   488,   489,    -1,   491,   492,    -1,
      -1,   495,   496,   497,    -1,    -1,   500,   501,    -1,   503,
     504,   505,   506,    -1,    -1,    -1,    -1,    -1,   512,   513,
     514,    -1,    -1,    -1,    -1,   519,   520,   521,    -1,   523,
     524,    -1,   526,   527,    -1,    -1,    -1,    -1,    -1,   533,
      -1,    -1,   536,    -1,    -1,    -1,   540,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,   551,    -1,    -1,
      -1,   555,   556,   557,   558,    -1,    -1,    -1,    -1,   563,
      -1,    -1,   566,    -1,    -1,    -1,   570
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,    13,    14,    28,    30,    34,    48,    49,    55,    59,
      60,    72,    88,   108,   116,   117,   118,   128,   129,   141,
     153,   169,   184,   189,   192,   215,   217,   233,   250,   254,
     340,   360,   370,   380,   400,   403,   405,   408,   411,   413,
     418,   420,   427,   432,   440,   445,   449,   472,   476,   518,
     530,   534,   537,   542,   567,   581,   592,   593,   594,   595,
     596,   597,   599,   604,   606,   611,   639,   771,   906,   944,
     947,   955,   957,   959,   962,   967,   969,   970,   975,   978,
     983,   987,   995,   996,  1145,  1147,  1155,  1158,  1183,  1191,
    1202,  1208,  1221,  1224,  1227,  1233,  1237,  1241,  1243,  1244,
    1290,  1307,  1313,  1315,  1322,  1324,  1349,  1355,  1356,  1357,
    1358,  1405,  1413,  1414,    11,    95,   113,   178,   205,   255,
     375,   438,   492,   940,  1374,  1375,  1376,  1379,   251,   329,
     977,   491,   494,  1309,  1350,   499,  1281,   208,     5,     7,
       8,     9,    10,    11,    17,    20,    22,    23,    24,    25,
      26,    27,    28,    30,    34,    38,    41,    42,    43,    45,
      47,    48,    51,    54,    56,    57,    59,    61,    62,    63,
      64,    65,    67,    68,    70,    71,    72,    73,    74,    75,
      76,    78,    79,    81,    82,    84,    87,    90,    97,    98,
      99,   102,   107,   108,   113,   115,   119,   121,   122,   123,
     124,   128,   131,   132,   133,   137,   139,   140,   142,   143,
     144,   147,   149,   150,   151,   152,   153,   156,   157,   158,
     161,   162,   164,   165,   166,   169,   173,   174,   176,   178,
     180,   181,   182,   183,   185,   189,   190,   192,   195,   196,
     200,   201,   202,   203,   206,   207,   210,   212,   216,   217,
     221,   223,   224,   226,   227,   231,   234,   235,   238,   241,
     242,   248,   249,   251,   253,   255,   256,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     278,   279,   281,   282,   283,   284,   286,   287,   288,   292,
     293,   294,   295,   296,   299,   300,   302,   304,   306,   307,
     308,   309,   310,   311,   312,   313,   316,   317,   320,   321,
     322,   323,   327,   328,   333,   334,   335,   337,   338,   339,
     341,   351,   352,   353,   354,   356,   357,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   370,   371,   372,
     374,   376,   377,   378,   379,   381,   382,   383,   386,   390,
     391,   392,   393,   394,   397,   398,   399,   401,   402,   404,
     405,   406,   409,   411,   412,   413,   415,   416,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   430,   431,   435,
     436,   437,   438,   442,   446,   447,   448,   449,   451,   452,
     453,   454,   455,   462,   463,   465,   468,   471,   472,   473,
     476,   477,   479,   480,   481,   482,   483,   486,   487,   488,
     489,   491,   492,   495,   496,   497,   500,   501,   503,   504,
     505,   506,   512,   513,   514,   518,   519,   520,   521,   523,
     524,   526,   527,   529,   530,   533,   536,   538,   540,   541,
     548,   551,   555,   556,   557,   558,   563,   564,   566,   567,
     570,   633,  1280,  1284,  1288,  1289,   278,  1309,  1309,   563,
    1351,    95,   177,   255,   438,   456,   492,   496,   532,   540,
     615,   616,   819,   820,   821,   893,  1192,  1146,    95,   151,
     178,   208,   255,   375,   438,   492,   496,   515,   540,   555,
    1154,  1284,   977,   632,   588,  1278,  1279,  1284,   605,  1156,
     364,    78,   382,  1242,    98,   208,   494,  1309,   977,   772,
    1284,  1238,   427,   540,  1309,   977,  1159,  1234,  1309,   632,
    1351,  1284,   998,  1000,  1001,   342,  1292,  1209,   472,   476,
     449,   512,   449,   494,  1203,   364,  1314,  1184,  1284,    30,
      72,   139,   370,   391,   420,   472,  1407,   432,   581,   997,
       0,   141,   370,   157,   359,  1225,  1278,  1284,   145,   917,
    1284,   145,   633,   186,   633,   243,  1281,  1284,  1286,   720,
     721,   724,   747,  1284,   494,   151,   912,  1374,  1309,   958,
    1351,   984,   985,  1278,   640,   588,   510,   960,   971,    16,
    1352,   204,   822,   186,  1286,   722,   747,   632,   347,  1371,
    1375,  1376,  1377,  1378,  1379,   494,   820,   208,   205,   262,
     383,  1200,  1201,     7,    20,    27,    33,    35,    36,    37,
      39,    52,    53,    57,    58,    64,    67,    81,    85,    86,
      91,    92,    94,    95,   100,   101,   102,   107,   109,   112,
     154,   159,   160,   167,   180,   182,   187,   193,   200,   204,
     215,   218,   240,   248,   259,   280,   285,   295,   299,   301,
     305,   306,   307,   308,   309,   315,   324,   325,   326,   330,
     331,   335,   355,   361,   365,   366,   368,   381,   407,   408,
     419,   425,   430,   474,   475,   480,   484,   485,   490,   499,
     503,   504,   505,   506,   516,   517,   518,   522,   525,   540,
     544,   545,   546,   547,   552,   554,   558,   570,   574,   575,
     580,   581,   584,   585,   587,   588,  1016,  1017,  1018,  1019,
    1023,  1026,  1027,  1028,  1029,  1030,  1031,  1039,  1043,  1053,
    1265,  1267,  1269,  1270,  1274,  1276,  1280,  1284,   204,  1153,
    1153,  1153,  1284,   186,  1153,  1153,   747,  1153,   632,  1153,
    1309,   600,  1228,    12,    13,    88,   116,   129,   151,   153,
     164,   184,   208,   215,   254,   376,   395,   401,   409,   432,
     445,   446,   486,   515,   537,   539,  1325,  1327,  1329,  1330,
    1284,   339,    63,   387,   588,  1286,   114,   194,   262,  1161,
    1284,  1016,  1245,   219,  1278,  1308,  1309,    46,   773,   175,
      33,   278,  1213,  1239,  1284,   632,   979,  1309,   114,   262,
    1162,  1190,   278,   382,   449,  1235,  1236,   956,    12,  1323,
    1327,   510,  1352,   999,    12,   125,   194,   461,   462,   463,
     464,   465,   466,   478,  1005,  1006,  1007,  1291,    23,    34,
      57,    58,    67,    69,    84,    86,    88,    96,   143,   147,
     150,   176,   178,   183,   185,   207,   208,   212,   230,   251,
     278,   310,   320,   339,   363,   374,   375,   378,   379,   437,
     449,   477,   494,   557,   866,   892,  1210,  1213,  1214,  1216,
    1298,   949,   950,   949,   949,   562,   948,   949,  1150,  1278,
    1284,  1309,  1190,    35,   193,   499,  1266,  1282,  1406,  1406,
    1406,  1406,  1406,  1000,   997,   582,  1284,  1223,  1222,   294,
     497,   524,   908,   538,    92,  1286,  1287,   910,   726,   748,
    1284,   909,   341,     6,    55,   129,   325,   386,   388,   749,
    1278,   633,   467,  1380,  1381,   911,   968,  1149,  1150,   222,
     583,   991,   992,   581,   641,  1284,   607,  1149,  1149,    54,
     327,   327,   400,  1353,   324,   325,  1022,  1284,   725,   748,
     171,     6,  1287,  1340,  1341,   408,    10,   151,   375,   515,
     619,  1011,  1373,  1381,  1389,  1393,  1394,  1400,   619,  1011,
    1372,  1381,  1389,  1394,  1400,  1374,  1379,   822,  1284,   175,
    1193,  1197,  1198,  1284,  1200,   581,   581,   581,  1026,   581,
     581,   581,  1016,  1056,   581,   581,   581,   581,   581,   581,
     581,   581,   581,  1015,  1015,   581,  1015,   581,   581,   581,
     525,   581,  1265,   581,   581,   581,   581,   581,   581,   581,
     581,   581,   581,   581,  1016,   581,   581,   581,  1054,  1055,
    1274,  1284,   581,   581,   581,   581,   581,   581,   581,   581,
     581,  1016,   581,  1015,   581,   581,   581,   581,   581,   581,
     581,   581,   581,   581,   581,   581,   581,   581,   581,   581,
     581,  1015,   581,  1265,   581,   581,   581,  1265,   581,   581,
      35,   193,   499,   581,  1015,  1015,  1015,   581,   581,   581,
     581,   581,  1026,  1026,  1026,   432,   581,  1016,  1368,  1284,
    1044,  1284,    15,    16,   344,   347,   568,  1020,  1021,   145,
     146,   179,   188,   225,   236,   263,   318,  1024,    31,   126,
     222,   244,   305,   396,   443,   444,   454,   572,   573,   574,
     575,   576,   577,   578,   579,  1022,  1026,    66,   346,   583,
    1282,   581,   588,   154,  1284,   633,  1284,   336,   748,   633,
    1286,   758,  1214,   633,  1287,  1339,  1149,  1153,   543,   601,
     119,   196,   256,   278,   374,   382,   412,   449,   473,   491,
    1229,  1230,  1309,   374,  1328,   422,   422,   496,   540,   555,
     342,  1332,   491,  1334,    62,   449,  1331,    96,   555,  1333,
     336,   583,    18,   145,  1100,  1101,  1316,  1284,   940,   453,
      76,   175,   262,  1246,  1252,    48,   175,  1278,  1310,  1311,
     976,   246,   249,   384,   774,   778,   587,   598,  1281,   256,
     980,  1287,   981,   982,  1278,   963,   219,  1150,  1163,  1164,
      48,   583,  1149,  1328,   336,   427,  1354,  1353,   531,  1359,
    1360,   576,  1009,  1010,  1011,  1007,  1293,  1294,  1295,   150,
     440,   244,   560,  1220,   519,   581,    95,   151,   178,   375,
     494,   515,   555,  1220,    12,   830,  1286,   245,  1119,  1121,
     175,   222,  1215,  1217,    65,   473,   172,   473,   473,   473,
     278,   491,    65,   473,    12,    41,    82,    87,   224,   293,
     353,   455,   488,  1204,  1205,  1206,   196,   473,   473,   519,
    1119,  1220,  1217,   256,   142,    68,   364,   377,   491,   514,
     473,   551,   946,   399,   468,   951,   952,   945,    79,   940,
     583,   338,  1409,   487,  1410,   229,   415,  1408,   582,  1360,
    1362,  1363,  1364,   995,  1226,  1266,  1284,   112,   817,   818,
     827,   828,   875,    98,  1015,   587,   634,     6,   727,   634,
     581,    97,   744,   744,   744,     4,   907,   913,   431,   555,
    1381,  1149,   510,   583,   112,   986,  1284,   985,   208,   232,
     890,   993,   642,   643,  1016,   264,   265,   266,   267,   268,
     269,   271,   272,   273,   274,   275,   276,   277,   279,   397,
     398,   608,   609,   610,   157,   383,   961,    56,   157,   161,
     172,   292,   383,   972,   973,   974,    54,   400,   154,   614,
     727,    98,   744,   202,   583,  1011,   822,  1011,  1011,   178,
     178,  1381,  1278,   894,   895,  1151,  1152,  1278,   583,  1195,
     588,  1199,  1016,  1016,    12,   125,  1049,  1102,  1049,  1049,
    1049,   559,  1058,  1016,  1016,  1053,  1053,  1016,  1016,  1016,
     125,  1049,  1102,   582,  1016,   582,  1016,  1016,  1016,  1016,
    1274,   581,  1368,   103,   104,   105,   106,   107,   197,   198,
     199,   200,   295,   297,   298,   299,   306,   381,   429,   430,
     558,   569,   570,  1096,  1098,  1053,    99,   102,   503,   506,
    1099,   125,  1046,  1016,  1016,  1016,  1016,  1096,  1016,  1053,
    1055,     9,   583,   588,   125,  1049,  1016,  1016,   125,  1049,
    1016,  1016,  1053,  1053,  1053,  1016,  1016,  1016,  1016,  1053,
    1019,  1016,  1016,  1016,  1016,  1016,  1016,  1049,  1049,  1016,
    1016,   125,  1049,  1016,  1016,   174,  1097,  1098,  1097,  1016,
      44,   237,   511,  1016,  1016,   582,  1275,  1276,  1284,  1049,
    1049,  1016,  1016,  1369,  1369,   582,   583,   582,  1016,   587,
    1045,  1286,   588,  1016,  1016,  1016,  1018,   160,   330,   517,
     533,  1022,    12,    17,  1018,  1025,  1019,  1019,   581,  1026,
    1019,  1019,  1019,  1019,   244,  1019,  1019,   218,  1019,   218,
    1019,  1019,  1019,  1019,  1019,    31,   222,   244,   396,  1286,
    1026,  1016,  1032,  1284,   588,  1278,   758,   328,   556,   759,
     760,   143,   583,    50,   414,   941,  1149,   587,   602,   603,
      48,   562,   583,  1231,   491,   581,  1342,  1342,  1342,  1342,
     178,   375,   494,  1326,  1330,  1284,   165,   321,  1284,  1317,
    1318,  1163,  1281,   278,   251,  1251,   988,   278,  1101,   583,
    1149,   777,   776,   359,   784,   190,   232,  1286,    29,   510,
    1240,   583,   510,   583,   510,  1149,  1164,  1160,  1236,   175,
     583,   178,   375,  1326,  1284,    12,   125,  1366,   583,  1002,
    1013,  1016,  1272,  1284,   583,   183,   251,   337,   437,  1296,
    1297,  1300,  1301,   222,  1218,  1281,  1016,   576,   822,   633,
     633,   633,  1278,   633,  1278,   256,   310,   473,  1212,  1212,
     259,   331,   522,  1122,  1123,  1267,  1220,  1284,   633,  1220,
    1287,   172,  1215,   633,  1220,   223,   489,   162,   172,  1207,
     583,  1215,  1278,  1217,  1215,  1215,  1220,  1220,   536,   953,
     583,   953,   451,   432,   581,   585,  1059,  1060,  1061,  1062,
    1063,  1072,  1073,  1080,  1266,   362,  1411,   345,  1115,  1121,
    1365,   818,    66,   866,   121,  1286,    70,    81,   234,   303,
     327,   385,   467,   636,   638,   392,   526,   745,   746,   210,
     741,   742,   743,   750,   758,   760,    95,   195,   351,   361,
     367,   452,   540,   617,   618,  1281,    24,   284,   735,   736,
     737,   750,   751,   752,   758,   760,   728,   729,   735,     6,
      13,    14,    25,    26,    55,    59,    60,    64,    70,    78,
      85,    98,   115,   122,   123,   129,   137,   143,   170,   206,
     208,   216,   231,   283,   300,   304,   340,   345,   352,   354,
     360,   361,   390,   402,   403,   404,   405,   424,   477,   492,
     495,   513,   520,   531,   769,   824,   826,   827,   828,   918,
     922,   924,   927,   933,   934,   935,  1111,   336,   627,   914,
     113,   221,  1278,  1281,  1150,   581,   582,   583,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   583,   538,   973,   816,   817,    70,
     322,   393,   527,   738,   739,   740,   750,   754,   755,   756,
     757,   758,   760,   564,   542,   723,    46,  1341,   178,   633,
     633,   633,   633,  1284,   612,   520,   543,   898,   336,   583,
    1196,  1194,  1198,   175,   576,  1284,  1101,   583,   582,  1049,
     582,  1050,   582,   582,   582,  1016,   135,   559,  1057,    18,
     582,   543,   582,   582,   582,   583,   543,   583,  1040,   582,
     576,   582,   583,   583,   582,   582,   582,   582,   175,   582,
     583,  1042,   582,   583,   583,   583,   575,   583,   582,   582,
     581,  1274,  1284,  1049,   582,   582,   582,  1049,   582,   583,
     582,   582,   582,   582,   582,   582,   582,   583,   582,   222,
     582,   583,   583,   583,   583,   582,   582,   582,   583,   175,
     583,  1049,   582,   582,   582,   583,   583,   583,   582,   175,
    1016,   175,  1016,   175,  1016,   175,   582,   583,   582,   582,
     582,   582,   583,   582,   998,   997,  1053,   586,   183,   251,
     437,  1299,   441,  1284,   160,   330,   517,   533,   581,    16,
    1016,  1368,   149,  1107,  1019,  1016,  1016,  1019,   581,  1026,
    1019,  1011,  1036,  1037,  1038,   581,   588,  1284,  1148,   759,
     145,   441,  1174,  1175,  1287,   941,  1286,   583,   387,  1230,
    1149,  1232,  1284,  1343,  1344,   576,  1278,  1284,  1338,  1338,
    1338,   145,   165,   179,   188,   235,   236,   263,   321,   372,
    1319,  1321,   560,  1103,  1157,   209,   989,   990,  1278,   262,
     387,   565,  1312,  1311,   581,   782,   782,   109,   167,   193,
     259,   331,   522,  1126,  1129,  1130,   483,   785,   775,   581,
    1016,  1281,  1287,  1287,   982,  1278,   157,   383,   541,   964,
     965,   966,   432,   440,   547,   548,   581,   812,  1165,  1168,
    1281,   184,  1338,  1338,  1338,  1361,  1010,   175,   219,  1003,
    1004,  1114,  1115,  1141,  1012,   588,  1294,   112,   512,  1284,
    1303,   311,   361,   587,   866,  1302,  1281,   175,  1219,   582,
    1284,   334,   583,   449,  1220,   382,  1119,  1206,  1220,  1215,
    1278,  1220,  1220,   610,   954,   952,  1079,  1284,    89,   211,
     229,   240,   314,   419,   478,  1071,   440,   583,  1278,  1079,
     583,   172,  1412,    46,  1119,  1175,  1175,   312,  1281,   467,
     467,   467,   467,   467,   431,  1281,  1281,  1175,   583,   743,
    1281,  1281,  1281,  1281,   109,   167,   193,   259,   331,   522,
    1125,  1281,  1281,   582,   583,  1175,  1175,   583,   737,   730,
     731,   750,   751,   752,    69,    80,   177,   360,   456,   838,
     841,   842,   888,   890,   939,   939,   360,  1175,  1175,   939,
    1175,   360,   360,  1175,  1175,   510,   121,  1175,   230,   492,
     171,   360,   373,   890,   939,   230,  1175,   492,   121,  1175,
    1175,  1175,  1175,   939,   360,    46,  1175,  1175,   770,  1175,
     360,   358,    18,   145,   510,   943,   360,   360,  1175,   124,
     293,  1284,  1175,  1175,  1175,  1175,   824,   583,   768,   769,
     922,   581,   588,   837,   843,  1277,  1284,    74,   428,   403,
     915,  1382,   373,  1092,  1093,  1094,  1284,  1016,  1125,  1281,
    1281,   109,   167,   259,   331,   522,  1127,  1281,  1125,  1281,
    1281,  1281,  1281,  1281,  1125,  1125,  1281,  1281,  1125,   609,
    1175,  1175,  1175,  1175,   583,   740,  1286,   255,   158,   732,
     733,   734,   750,   751,   752,   753,   756,   757,   758,   760,
     361,   499,  1284,   620,  1401,     8,    29,   718,   581,   416,
     244,   581,   762,   823,   825,   826,    45,   190,   426,   900,
     900,  1278,  1152,  1278,   543,  1103,  1060,   588,  1199,   218,
    1016,   582,  1016,   502,  1016,  1016,   139,    33,    58,    99,
     102,   110,   316,   447,   506,   535,  1051,    33,   867,  1286,
    1016,   867,  1051,  1053,   582,   218,   218,  1016,  1016,  1053,
    1016,  1016,  1016,  1016,  1016,  1019,   582,   582,  1016,  1016,
    1016,  1016,  1016,  1016,  1053,   218,  1016,  1016,  1016,   582,
    1016,  1016,  1016,  1016,   175,  1016,   175,  1016,   175,  1016,
    1016,  1016,  1367,  1367,   582,   588,   588,   588,  1286,  1016,
    1368,  1018,   582,   583,   582,  1026,  1096,  1096,    16,  1016,
    1368,  1107,  1016,   582,   583,  1052,  1053,  1284,   829,  1286,
     603,   254,   582,   583,   588,   588,   510,   510,   510,  1320,
    1104,  1120,  1121,  1165,   499,  1283,   583,   991,   565,   251,
    1011,    46,   581,   792,   782,   779,   780,   781,  1284,   510,
     965,   813,  1166,   581,  1171,  1176,  1171,   582,   812,  1167,
    1271,  1272,  1275,  1284,  1169,   342,   175,   175,   175,   996,
     130,  1060,  1142,   172,   254,  1008,  1141,  1120,  1004,    18,
    1014,  1281,  1284,   576,  1284,   588,   226,   588,  1174,   112,
     867,   868,  1174,   172,  1174,   587,  1286,    33,   112,   870,
     871,  1286,  1127,  1211,   147,   557,  1123,  1123,   562,   331,
    1103,  1215,   583,  1074,  1079,  1059,   229,   229,   348,  1081,
     229,   240,   419,  1081,  1072,  1059,  1186,  1187,  1275,  1061,
    1101,  1076,  1077,  1125,   296,  1116,   112,   872,   874,  1286,
     868,    98,    98,   113,   221,   201,   761,  1126,   743,   618,
     761,   761,   737,   583,   731,   903,  1277,   890,   891,   977,
     891,    60,   171,   373,   532,   840,   889,   839,   840,   903,
    1277,   977,  1127,  1125,  1277,  1125,    12,   923,   931,   932,
    1284,   977,  1281,  1281,   866,  1175,  1125,   232,   931,   232,
    1277,  1277,   829,  1175,   165,   235,   327,   832,  1125,  1127,
    1127,  1277,   977,  1112,  1113,  1275,   112,  1125,   112,  1125,
    1131,   773,  1281,   977,  1278,   977,   977,    73,    75,   112,
     133,   166,   353,   394,   831,  1125,  1131,   829,   581,     6,
     129,   935,   835,   836,   837,   838,  1284,     8,   165,   942,
     395,   839,   880,   844,   588,   325,   371,    22,   152,   621,
     510,   122,   137,   623,   581,  1383,   582,   583,  1281,  1126,
     761,   761,   740,   341,   186,  1175,   583,   734,   499,   416,
     336,   581,   116,   215,   537,   719,  1395,   110,   220,   389,
     479,   834,  1278,   244,   360,   763,   768,   835,   768,   583,
     825,   613,  1060,  1114,  1103,  1101,  1016,   582,  1016,   502,
     581,   860,   860,   581,   855,   856,   860,   220,   220,   582,
     582,   582,   582,   582,  1041,  1016,  1016,   582,   582,  1048,
    1115,   583,   583,   582,   583,   582,   222,  1033,  1034,   582,
     582,   582,   582,   583,   582,   582,  1016,   582,   172,   582,
     582,   583,   582,   583,   583,   582,  1016,   582,  1016,   582,
    1016,   582,   582,   582,  1370,  1370,   588,   904,   582,  1053,
    1018,   582,   583,   582,  1012,  1038,   582,  1344,   576,   576,
    1340,  1340,  1340,   581,  1016,   336,  1181,  1247,   990,   205,
     994,   790,  1019,   778,   360,   793,   794,   582,   583,  1287,
    1005,  1172,  1173,  1275,  1177,   583,   581,  1168,   582,   582,
     583,   588,  1359,   175,  1340,  1340,  1340,  1103,  1103,   131,
     349,  1137,  1138,  1143,   537,   222,  1281,  1284,   588,  1284,
     242,  1284,    12,    33,   112,   336,  1016,  1306,    66,   873,
    1016,  1287,   335,   361,   499,  1305,  1299,  1174,  1119,   266,
    1220,   610,  1362,  1075,   586,   229,  1072,  1081,  1081,   229,
     336,   336,   543,   583,  1185,  1174,  1090,  1091,  1005,  1016,
    1117,  1273,   731,   925,  1016,   232,   232,   891,   903,   895,
     129,   440,   923,   936,   920,   583,  1126,   868,  1281,   903,
     941,  1281,   937,   923,   583,    19,   117,  1118,   923,   928,
     923,  1232,   582,   583,  1284,  1278,    32,    33,    38,    40,
      42,    43,    58,    99,   102,   110,   127,   144,   166,   168,
     180,   181,   220,   248,   257,   258,   260,   289,   290,   291,
     307,   308,   309,   313,   316,   332,   333,   365,   366,   389,
     436,   440,   450,   500,   503,   506,   507,   508,   509,   549,
     550,   570,   845,   848,   849,   850,   851,   852,   853,   854,
    1284,   371,  1016,  1016,   336,   627,   633,   336,    70,   628,
    1284,  1384,    18,  1093,   581,  1284,   761,   734,   834,   428,
    1402,   336,   644,   645,   647,  1284,   453,  1278,   812,   582,
     205,   408,   765,  1253,   825,   581,  1103,   245,  1124,  1096,
    1016,   331,    20,    33,    47,   529,   866,   876,   331,   582,
    1096,  1096,   434,  1047,  1016,  1016,  1053,    42,   314,   582,
     562,  1035,  1016,  1096,  1016,  1016,  1016,  1016,   582,   582,
     582,   582,  1284,   582,  1053,  1014,   410,  1345,  1345,  1345,
     112,  1016,  1179,  1180,   132,  1253,   238,  1012,   190,   232,
     795,   582,   583,   781,  1009,   583,  1174,  1178,  1179,  1176,
    1170,  1168,  1271,  1284,  1340,  1120,   186,  1108,  1283,  1283,
     587,  1139,  1140,  1286,   442,   576,   387,   406,   435,  1304,
     874,  1174,   581,   581,  1303,  1016,   145,   582,  1062,  1059,
    1072,   229,   229,  1059,  1072,  1065,  1064,  1066,  1187,  1103,
    1180,  1088,  1089,  1009,   583,  1118,   359,   581,   926,   903,
     895,   581,   112,   112,   843,   972,   932,   873,   845,   919,
    1113,   929,   931,   921,   582,   836,   881,   581,   581,   860,
     855,   369,   846,   855,   855,   876,    58,   549,   849,   851,
     876,   876,    58,   550,   550,   553,   855,   847,   860,   860,
     876,   581,   860,    25,    66,    70,   112,   330,   336,   373,
     436,   532,   862,   863,   864,   879,  1022,   553,   581,   876,
      33,   581,   877,   581,   581,   860,   581,   856,   861,   588,
    1096,   449,  1281,   128,   916,   582,   583,  1385,  1386,   617,
     453,   621,   213,   222,   350,   648,   649,   650,   651,  1011,
     582,   583,   646,  1281,   582,   582,   823,    18,   815,   901,
     902,  1284,  1123,   582,   582,   877,    20,   529,   866,   878,
     877,   867,   582,   583,   582,   582,  1266,   582,   582,   583,
     582,   302,   234,   382,   582,   582,   582,   582,   582,   582,
     582,    61,   227,   323,   469,   481,   566,  1336,  1337,   562,
    1346,  1346,  1346,   582,   583,  1182,   219,   582,   581,   783,
     581,   796,  1284,   794,   814,  1173,  1180,   582,  1362,    46,
     191,  1105,  1144,  1286,   583,   302,    71,   523,   387,  1305,
     499,   499,  1174,  1281,  1101,   336,  1068,  1072,  1072,   336,
    1070,  1016,  1016,   581,  1114,   170,   205,   542,  1083,  1084,
    1087,  1078,  1273,  1126,   793,   581,   581,   901,   102,   503,
     506,   574,   575,  1268,  1269,   942,   862,   977,   930,   964,
     280,   336,   581,   882,   884,   885,   886,   331,   331,   447,
     535,   571,   857,   858,   859,   581,   857,   857,   876,   553,
     857,   581,   876,   331,   857,   872,  1281,   326,   865,  1268,
     537,   112,   232,   864,   232,   330,   331,   331,   331,   331,
     857,   331,   857,  1284,   622,   629,   630,  1284,   432,   581,
    1387,   582,  1281,   626,   627,   582,   583,   646,  1390,  1396,
     647,   845,   764,   768,   581,   812,   582,   583,  1118,   581,
     867,   877,   331,  1016,   302,   156,   499,   499,   499,    16,
    1335,   184,   281,   282,   286,   287,  1347,  1348,  1180,   232,
    1248,  1011,   786,   788,   789,  1284,   547,   797,   833,  1004,
    1120,  1109,  1273,  1106,  1114,    68,  1254,  1140,   582,   582,
    1306,    16,  1067,   543,  1069,   543,  1095,  1284,  1124,   890,
     890,  1084,   833,  1118,   582,   901,   901,   582,  1270,  1270,
     938,   219,   176,   357,   448,   116,   537,   883,  1284,   886,
     582,   582,   859,   905,  1266,   905,   582,  1015,   326,   548,
     582,   582,   582,   582,   471,   624,    52,    63,   163,   204,
     228,   239,   339,   417,   631,   669,   671,   672,   673,   675,
     676,   677,   678,   679,   680,   682,   690,   691,   694,   705,
     708,   710,   711,  1280,  1285,  1289,   998,   997,   562,  1388,
     623,  1403,   650,  1284,  1278,   416,  1362,   765,   812,   766,
     231,   562,   896,   897,   898,   899,   902,   331,   582,   582,
    1336,   342,  1125,  1125,  1125,  1125,  1348,   537,   494,   790,
     482,   791,   582,   583,   222,   241,    70,    98,   208,   283,
     300,   322,   492,   809,   810,   811,  1214,  1008,   562,   583,
    1110,  1118,  1016,  1120,   138,   148,   343,   498,  1255,  1256,
     247,  1257,   267,  1016,   581,  1016,   581,   582,   583,   172,
    1082,  1082,   582,   582,   896,   942,   581,    50,   327,   414,
     440,   887,   887,   582,   583,   582,   583,   582,  1015,   876,
     877,   876,   877,  1016,   140,   625,   692,   695,  1284,   175,
     321,   683,   670,  1285,  1285,  1284,   674,   594,   261,   407,
     561,   714,    30,   712,   590,   582,    51,    60,   251,   628,
     635,   845,   172,  1397,   582,  1359,  1175,   356,   899,  1118,
     582,  1188,  1189,  1275,  1278,  1012,  1126,   787,   789,   581,
     501,  1175,   121,   121,  1175,  1175,  1175,  1175,   581,   804,
     811,   143,    90,   421,  1273,   375,  1132,    46,    46,   138,
      46,  1256,   470,   498,  1258,  1259,   145,  1095,  1095,  1284,
     186,   229,   345,  1086,  1085,   880,   896,   793,     5,   112,
     330,   884,  1284,   876,  1266,   876,  1016,  1016,   559,   697,
     701,   175,  1284,   685,   686,  1016,   653,   668,   669,   671,
     673,   675,   677,   678,   679,   680,   682,   690,   705,   708,
     710,   653,   715,   713,   706,   709,  1362,    60,   342,    60,
     128,   120,   636,   637,  1022,  1404,  1011,   845,   767,  1125,
    1280,   583,  1174,  1249,   582,   791,   801,   802,   803,  1019,
     288,   581,   798,   799,   800,  1281,  1175,  1175,   259,   331,
     522,  1128,  1129,  1128,  1126,  1286,   483,   805,   806,  1175,
    1118,  1284,  1266,  1266,    46,  1266,    46,    46,  1259,  1127,
     582,   582,    46,    46,   581,   581,   582,   693,   702,   135,
     701,   704,   219,   139,  1016,   139,   668,   589,   536,  1016,
     654,   714,   712,   342,   342,   629,   120,   668,  1391,  1398,
    1362,  1189,  1180,   866,   869,   582,   583,   288,   803,  1281,
    1281,   807,   582,   583,   829,  1133,  1266,  1266,  1266,    16,
    1092,  1094,   559,   696,   698,  1016,   653,   139,   681,   204,
     502,   261,   589,   717,   128,   111,   652,   655,   707,  1285,
     707,   134,   635,   868,  1250,   802,   582,   582,   808,  1286,
     806,   581,   270,   582,   582,   699,   698,   704,   703,    52,
     684,  1284,   687,  1016,   716,    83,   155,   660,   666,  1284,
     139,   668,   589,   425,  1399,  1254,   809,  1011,  1134,  1135,
    1136,   145,  1016,   139,   502,   583,   653,   139,   653,   189,
     583,   656,    77,    93,   589,  1392,   668,  1257,  1016,   582,
     583,  1125,   700,    52,   653,  1284,   688,   407,   139,   172,
    1284,   845,   172,   172,   668,   205,  1260,  1012,  1136,   502,
     135,   136,   689,   561,   657,   112,   667,   459,   663,  1125,
     658,   659,   331,   581,  1261,   653,   653,   685,   458,   460,
     661,   662,   663,   665,  1022,  1284,  1016,   548,   664,   995,
     247,   582,   587,  1262,  1263,  1275,   440,  1264,   583,   668,
     173,  1282,  1286,   582,   583,  1188,   662,  1263
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1349 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            if (!thd->bootstrap &&
              (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
            {
              my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
              MYSQL_YYABORT;
            }
            else
            {
              thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
            }
          }
