/* Copyright (c) V-Nova International Limited 2023-2024. All rights reserved.
 * This software is licensed under the BSD-3-Clause-Clear License by V-Nova Limited.
 * No patent licenses are granted under this license. For enquiries about patent licenses,
 * please contact legal@v-nova.com.
 * The LCEVCdec software is a stand-alone project and is NOT A CONTRIBUTION to any other project.
 * If the software is incorporated into another project, THE TERMS OF THE BSD-3-CLAUSE-CLEAR LICENSE
 * AND THE ADDITIONAL LICENSING INFORMATION CONTAINED IN THIS FILE MUST BE MAINTAINED, AND THE
 * SOFTWARE DOES NOT AND MUST NOT ADOPT THE LICENSE OF THE INCORPORATING PROJECT. However, the
 * software may be incorporated into a project under a compatible license provided the requirements
 * of the BSD-3-Clause-Clear license are respected, and V-Nova Limited remains
 * licensor of the software ONLY UNDER the BSD-3-Clause-Clear license (not the compatible license).
 * ANY ONWARD DISTRIBUTION, WHETHER STAND-ALONE OR AS PART OF ANY OTHER PROJECT, REMAINS SUBJECT TO
 * THE EXCLUSION OF PATENT LICENSES PROVISION OF THE BSD-3-CLAUSE-CLEAR LICENSE. */

#include <chrono>
#include <cstdlib>
#include <vector>

// - Helper consts and functions ------------------------------------------------------------------

// This is from a real .ts stream. The timestamps generally seem to come in groups of 5, which is
// comfortably below the maxNumReorderFrames of 16 that we're using. The exact pattern also does
// vary: some groups go 5,2,1,3,4 while others go 4,2,1,3,5 (see 2580000000 - 2980000000).
static const std::vector<uint64_t> kTimehandles1 = {
    780000000,   980000000,   860000000,   820000000,   900000000,   940000000,   1180000000,
    1060000000,  1020000000,  1100000000,  1140000000,  1380000000,  1260000000,  1220000000,
    1300000000,  1340000000,  1580000000,  1460000000,  1420000000,  1500000000,  1540000000,
    1780000000,  1660000000,  1620000000,  1700000000,  1740000000,  1980000000,  1860000000,
    1820000000,  1900000000,  1940000000,  2180000000,  2060000000,  2020000000,  2100000000,
    2140000000,  2380000000,  2260000000,  2220000000,  2300000000,  2340000000,  2580000000,
    2460000000,  2420000000,  2500000000,  2540000000,  2740000000,  2660000000,  2620000000,
    2700000000,  2780000000,  2980000000,  2860000000,  2820000000,  2900000000,  2940000000,
    3180000000,  3060000000,  3020000000,  3100000000,  3140000000,  3380000000,  3260000000,
    3220000000,  3300000000,  3340000000,  3580000000,  3460000000,  3420000000,  3500000000,
    3540000000,  3780000000,  3660000000,  3620000000,  3700000000,  3740000000,  3980000000,
    3860000000,  3820000000,  3900000000,  3940000000,  4180000000,  4060000000,  4020000000,
    4100000000,  4140000000,  4380000000,  4260000000,  4220000000,  4300000000,  4340000000,
    4580000000,  4460000000,  4420000000,  4500000000,  4540000000,  4740000000,  4660000000,
    4620000000,  4700000000,  4780000000,  4980000000,  4860000000,  4820000000,  4900000000,
    4940000000,  5180000000,  5060000000,  5020000000,  5100000000,  5140000000,  5380000000,
    5260000000,  5220000000,  5300000000,  5340000000,  5580000000,  5460000000,  5420000000,
    5500000000,  5540000000,  5780000000,  5660000000,  5620000000,  5700000000,  5740000000,
    5980000000,  5860000000,  5820000000,  5900000000,  5940000000,  6180000000,  6060000000,
    6020000000,  6100000000,  6140000000,  6380000000,  6260000000,  6220000000,  6300000000,
    6340000000,  6580000000,  6460000000,  6420000000,  6500000000,  6540000000,  6740000000,
    6660000000,  6620000000,  6700000000,  6780000000,  6980000000,  6860000000,  6820000000,
    6900000000,  6940000000,  7180000000,  7060000000,  7020000000,  7100000000,  7140000000,
    7380000000,  7260000000,  7220000000,  7300000000,  7340000000,  7580000000,  7460000000,
    7420000000,  7500000000,  7540000000,  7780000000,  7660000000,  7620000000,  7700000000,
    7740000000,  7980000000,  7860000000,  7820000000,  7900000000,  7940000000,  8180000000,
    8060000000,  8020000000,  8100000000,  8140000000,  8380000000,  8260000000,  8220000000,
    8300000000,  8340000000,  8580000000,  8460000000,  8420000000,  8500000000,  8540000000,
    8740000000,  8660000000,  8620000000,  8700000000,  8780000000,  8980000000,  8860000000,
    8820000000,  8900000000,  8940000000,  9180000000,  9060000000,  9020000000,  9100000000,
    9140000000,  9380000000,  9260000000,  9220000000,  9300000000,  9340000000,  9580000000,
    9460000000,  9420000000,  9500000000,  9540000000,  9780000000,  9660000000,  9620000000,
    9700000000,  9740000000,  9980000000,  9860000000,  9820000000,  9900000000,  9940000000,
    10180000000, 10060000000, 10020000000, 10100000000, 10140000000, 10380000000, 10260000000,
    10220000000, 10300000000, 10340000000, 10580000000, 10460000000, 10420000000, 10500000000,
    10540000000, 10740000000, 10660000000, 10620000000, 10700000000, 10780000000, 10980000000,
    10860000000, 10820000000, 10900000000, 10940000000, 11180000000, 11060000000, 11020000000,
    11100000000, 11140000000, 11380000000, 11260000000, 11220000000, 11300000000, 11340000000,
    11580000000, 11460000000, 11420000000, 11500000000, 11540000000, 11780000000, 11660000000,
    11620000000, 11700000000, 11740000000, 11980000000, 11860000000, 11820000000, 11900000000,
    11940000000, 12180000000, 12060000000, 12020000000, 12100000000, 12140000000, 12380000000,
    12260000000, 12220000000, 12300000000, 12340000000, 12580000000, 12460000000, 12420000000,
    12500000000, 12540000000, 12740000000, 12660000000, 12620000000, 12700000000, 12780000000,
    12980000000, 12860000000, 12820000000, 12900000000, 12940000000, 13180000000, 13060000000,
    13020000000, 13100000000, 13140000000, 13380000000, 13260000000, 13220000000, 13300000000,
    13340000000, 13580000000, 13460000000, 13420000000, 13500000000, 13540000000, 13780000000,
    13660000000, 13620000000, 13700000000, 13740000000, 13980000000, 13860000000, 13820000000,
    13900000000, 13940000000, 14180000000, 14060000000, 14020000000, 14100000000, 14140000000,
    14380000000, 14260000000, 14220000000, 14300000000, 14340000000, 14580000000, 14460000000,
    14420000000, 14500000000, 14540000000, 14740000000, 14660000000, 14620000000, 14700000000,
    14780000000, 14980000000, 14860000000, 14820000000, 14900000000, 14940000000, 15180000000,
    15060000000, 15020000000, 15100000000, 15140000000, 15380000000, 15260000000, 15220000000,
    15300000000, 15340000000, 15580000000, 15460000000, 15420000000, 15500000000, 15540000000,
    15780000000, 15660000000, 15620000000, 15700000000, 15740000000, 15980000000, 15860000000,
    15820000000, 15900000000, 15940000000, 16180000000, 16060000000, 16020000000, 16100000000,
    16140000000, 16380000000, 16260000000, 16220000000, 16300000000, 16340000000, 16580000000,
    16460000000, 16420000000, 16500000000, 16540000000, 16740000000, 16660000000, 16620000000,
    16700000000, 16780000000, 16980000000, 16860000000, 16820000000, 16900000000, 16940000000,
    17180000000, 17060000000, 17020000000, 17100000000, 17140000000, 17380000000, 17260000000,
    17220000000, 17300000000, 17340000000, 17580000000, 17460000000, 17420000000, 17500000000,
    17540000000, 17780000000, 17660000000, 17620000000, 17700000000, 17740000000, 17980000000,
    17860000000, 17820000000, 17900000000, 17940000000, 18180000000, 18060000000, 18020000000,
    18100000000, 18140000000, 18380000000, 18260000000, 18220000000, 18300000000, 18340000000,
    18580000000, 18460000000, 18420000000, 18500000000, 18540000000, 18740000000, 18660000000,
    18620000000, 18700000000, 18780000000, 18980000000, 18860000000, 18820000000, 18900000000,
    18940000000, 19180000000, 19060000000, 19020000000, 19100000000, 19140000000, 19380000000,
    19260000000, 19220000000, 19300000000, 19340000000, 19580000000, 19460000000, 19420000000,
    19500000000, 19540000000, 19780000000, 19660000000, 19620000000, 19700000000, 19740000000,
    19980000000, 19860000000, 19820000000, 19900000000, 19940000000, 20180000000, 20060000000,
    20020000000, 20100000000, 20140000000, 20380000000, 20260000000, 20220000000, 20300000000,
    20340000000, 20580000000, 20460000000, 20420000000, 20500000000, 20540000000, 20740000000,
    20660000000, 20620000000, 20700000000, 20780000000, 20900000000, 20820000000, 20860000000};

// values from a real world Live stream that had problems with the timehandlePredictor
// use 290317 as the first value to see that it works correctly
static const std::vector<uint64_t> kTimehandles2 = {
    0,       423783,  357050,  323683,  307000,  340366,  390416,  373733,  407100,  557250,
    490516,  457150,  440466,  473833,  523883,  507200,  540566,  690716,  623983,  590616,
    573933,  607300,  657350,  640666,  674033,  824183,  757450,  724083,  707400,  740766,
    790816,  774133,  807500,  957650,  890916,  857550,  840866,  874233,  924283,  907600,
    940966,  1091116, 1024383, 991016,  974333,  1007700, 1057750, 1041066, 1074433, 1224583,
    1157850, 1124483, 1107800, 1141166, 1191216, 1174533, 1207900, 1358050, 1291316, 1257950,
    1241266, 1274633, 1324683, 1308000, 1341366, 1491516, 1424783, 1391416, 1374733, 1408100,
    1458150, 1441466, 1474833, 1624983, 1558250, 1524883, 1508200, 1541566, 1591616, 1574933,
    1608300, 1758450, 1691716, 1658350, 1641666, 1675033, 1725083, 1708400, 1741766, 1891916,
    1825183, 1791816, 1775133, 1808500, 1858550, 1841866, 1875233, 1925283, 1908600, 1941966,
    2075433, 2008700, 1975333, 1958650, 1992016, 2042066, 2025383, 2058750, 2208900, 2142166,
    2108800, 2092116, 2125483, 2175533, 2158850, 2192216, 2342366, 2275633, 2242266, 2225583,
    2258950, 2309000, 2292316, 2325683, 2475833, 2409100, 2375733, 2359050, 2392416, 2442466,
    2425783, 2459150, 2609300, 2542566, 2509200};

static const std::vector<uint64_t> kSortedTimehandles = {
    780000000,   820000000,   860000000,   900000000,   940000000,   980000000,   1020000000,
    1060000000,  1100000000,  1140000000,  1180000000,  1220000000,  1260000000,  1300000000,
    1340000000,  1380000000,  1420000000,  1460000000,  1500000000,  1540000000,  1580000000,
    1620000000,  1660000000,  1700000000,  1740000000,  1780000000,  1820000000,  1860000000,
    1900000000,  1940000000,  1980000000,  2020000000,  2060000000,  2100000000,  2140000000,
    2180000000,  2220000000,  2260000000,  2300000000,  2340000000,  2380000000,  2420000000,
    2460000000,  2500000000,  2540000000,  2580000000,  2620000000,  2660000000,  2700000000,
    2740000000,  2780000000,  2820000000,  2860000000,  2900000000,  2940000000,  2980000000,
    3020000000,  3060000000,  3100000000,  3140000000,  3180000000,  3220000000,  3260000000,
    3300000000,  3340000000,  3380000000,  3420000000,  3460000000,  3500000000,  3540000000,
    3580000000,  3620000000,  3660000000,  3700000000,  3740000000,  3780000000,  3820000000,
    3860000000,  3900000000,  3940000000,  3980000000,  4020000000,  4060000000,  4100000000,
    4140000000,  4180000000,  4220000000,  4260000000,  4300000000,  4340000000,  4380000000,
    4420000000,  4460000000,  4500000000,  4540000000,  4580000000,  4620000000,  4660000000,
    4700000000,  4740000000,  4780000000,  4820000000,  4860000000,  4900000000,  4940000000,
    4980000000,  5020000000,  5060000000,  5100000000,  5140000000,  5180000000,  5220000000,
    5260000000,  5300000000,  5340000000,  5380000000,  5420000000,  5460000000,  5500000000,
    5540000000,  5580000000,  5620000000,  5660000000,  5700000000,  5740000000,  5780000000,
    5820000000,  5860000000,  5900000000,  5940000000,  5980000000,  6020000000,  6060000000,
    6100000000,  6140000000,  6180000000,  6220000000,  6260000000,  6300000000,  6340000000,
    6380000000,  6420000000,  6460000000,  6500000000,  6540000000,  6580000000,  6620000000,
    6660000000,  6700000000,  6740000000,  6780000000,  6820000000,  6860000000,  6900000000,
    6940000000,  6980000000,  7020000000,  7060000000,  7100000000,  7140000000,  7180000000,
    7220000000,  7260000000,  7300000000,  7340000000,  7380000000,  7420000000,  7460000000,
    7500000000,  7540000000,  7580000000,  7620000000,  7660000000,  7700000000,  7740000000,
    7780000000,  7820000000,  7860000000,  7900000000,  7940000000,  7980000000,  8020000000,
    8060000000,  8100000000,  8140000000,  8180000000,  8220000000,  8260000000,  8300000000,
    8340000000,  8380000000,  8420000000,  8460000000,  8500000000,  8540000000,  8580000000,
    8620000000,  8660000000,  8700000000,  8740000000,  8780000000,  8820000000,  8860000000,
    8900000000,  8940000000,  8980000000,  9020000000,  9060000000,  9100000000,  9140000000,
    9180000000,  9220000000,  9260000000,  9300000000,  9340000000,  9380000000,  9420000000,
    9460000000,  9500000000,  9540000000,  9580000000,  9620000000,  9660000000,  9700000000,
    9740000000,  9780000000,  9820000000,  9860000000,  9900000000,  9940000000,  9980000000,
    10020000000, 10060000000, 10100000000, 10140000000, 10180000000, 10220000000, 10260000000,
    10300000000, 10340000000, 10380000000, 10420000000, 10460000000, 10500000000, 10540000000,
    10580000000, 10620000000, 10660000000, 10700000000, 10740000000, 10780000000, 10820000000,
    10860000000, 10900000000, 10940000000, 10980000000, 11020000000, 11060000000, 11100000000,
    11140000000, 11180000000, 11220000000, 11260000000, 11300000000, 11340000000, 11380000000,
    11420000000, 11460000000, 11500000000, 11540000000, 11580000000, 11620000000, 11660000000,
    11700000000, 11740000000, 11780000000, 11820000000, 11860000000, 11900000000, 11940000000,
    11980000000, 12020000000, 12060000000, 12100000000, 12140000000, 12180000000, 12220000000,
    12260000000, 12300000000, 12340000000, 12380000000, 12420000000, 12460000000, 12500000000,
    12540000000, 12580000000, 12620000000, 12660000000, 12700000000, 12740000000, 12780000000,
    12820000000, 12860000000, 12900000000, 12940000000, 12980000000, 13020000000, 13060000000,
    13100000000, 13140000000, 13180000000, 13220000000, 13260000000, 13300000000, 13340000000,
    13380000000, 13420000000, 13460000000, 13500000000, 13540000000, 13580000000, 13620000000,
    13660000000, 13700000000, 13740000000, 13780000000, 13820000000, 13860000000, 13900000000,
    13940000000, 13980000000, 14020000000, 14060000000, 14100000000, 14140000000, 14180000000,
    14220000000, 14260000000, 14300000000, 14340000000, 14380000000, 14420000000, 14460000000,
    14500000000, 14540000000, 14580000000, 14620000000, 14660000000, 14700000000, 14740000000,
    14780000000, 14820000000, 14860000000, 14900000000, 14940000000, 14980000000, 15020000000,
    15060000000, 15100000000, 15140000000, 15180000000, 15220000000, 15260000000, 15300000000,
    15340000000, 15380000000, 15420000000, 15460000000, 15500000000, 15540000000, 15580000000,
    15620000000, 15660000000, 15700000000, 15740000000, 15780000000, 15820000000, 15860000000,
    15900000000, 15940000000, 15980000000, 16020000000, 16060000000, 16100000000, 16140000000,
    16180000000, 16220000000, 16260000000, 16300000000, 16340000000, 16380000000, 16420000000,
    16460000000, 16500000000, 16540000000, 16580000000, 16620000000, 16660000000, 16700000000,
    16740000000, 16780000000, 16820000000, 16860000000, 16900000000, 16940000000, 16980000000,
    17020000000, 17060000000, 17100000000, 17140000000, 17180000000, 17220000000, 17260000000,
    17300000000, 17340000000, 17380000000, 17420000000, 17460000000, 17500000000, 17540000000,
    17580000000, 17620000000, 17660000000, 17700000000, 17740000000, 17780000000, 17820000000,
    17860000000, 17900000000, 17940000000, 17980000000, 18020000000, 18060000000, 18100000000,
    18140000000, 18180000000, 18220000000, 18260000000, 18300000000, 18340000000, 18380000000,
    18420000000, 18460000000, 18500000000, 18540000000, 18580000000, 18620000000, 18660000000,
    18700000000, 18740000000, 18780000000, 18820000000, 18860000000, 18900000000, 18940000000,
    18980000000, 19020000000, 19060000000, 19100000000, 19140000000, 19180000000, 19220000000,
    19260000000, 19300000000, 19340000000, 19380000000, 19420000000, 19460000000, 19500000000,
    19540000000, 19580000000, 19620000000, 19660000000, 19700000000, 19740000000, 19780000000,
    19820000000, 19860000000, 19900000000, 19940000000, 19980000000, 20020000000, 20060000000,
    20100000000, 20140000000, 20180000000, 20220000000, 20260000000, 20300000000, 20340000000,
    20380000000, 20420000000, 20460000000, 20500000000, 20540000000, 20580000000, 20620000000,
    20660000000, 20700000000, 20740000000, 20780000000, 20820000000, 20860000000, 20900000000};

// 40 uint64_ts that increase exponentially, so the timehandlePredictor can't work out the gap,
// and therefore always gives us NULL.
static const std::vector<uint64_t> kTimehandlesIncreaseExponentially = {
    1ULL << 0,  1ULL << 1,  1ULL << 2,  1ULL << 3,  1ULL << 4,  1ULL << 5,  1ULL << 6,  1ULL << 7,
    1ULL << 8,  1ULL << 9,  1ULL << 10, 1ULL << 11, 1ULL << 12, 1ULL << 13, 1ULL << 14, 1ULL << 15,
    1ULL << 16, 1ULL << 17, 1ULL << 18, 1ULL << 19, 1ULL << 20, 1ULL << 21, 1ULL << 22, 1ULL << 23,
    1ULL << 24, 1ULL << 25, 1ULL << 26, 1ULL << 27, 1ULL << 28, 1ULL << 29, 1ULL << 30, 1ULL << 31,
    1ULL << 32, 1ULL << 33, 1ULL << 34, 1ULL << 35, 1ULL << 36, 1ULL << 37, 1ULL << 38, 1ULL << 39};

static const std::vector<uint64_t> kEmptyArray = {};

// kRandLengths were generated with 3 calls to "1 + (std::rand() % kMaxBufSize)" and each randDataN
// was generated with kRandLengths[N] calls to "static_cast<uint8_t>(std::rand())".
static constexpr size_t kRandLengths[3] = {213, 22, 56};
static constexpr size_t kLenRandLengths = sizeof(kRandLengths) / sizeof(*kRandLengths);
static uint8_t kRandData1[kRandLengths[0]] = {
    55,  31,  15,  183, 0,   87,  240, 183, 96,  88,  198, 237, 209, 11,  226, 60,  62,  248,
    187, 11,  255, 105, 135, 141, 11,  204, 8,   70,  105, 90,  169, 203, 232, 246, 201, 201,
    16,  88,  87,  72,  88,  106, 159, 49,  154, 242, 99,  14,  195, 114, 46,  18,  207, 76,
    229, 89,  245, 42,  159, 112, 30,  157, 182, 24,  156, 5,   31,  71,  25,  176, 246, 112,
    205, 70,  93,  4,   245, 100, 135, 57,  128, 135, 16,  10,  11,  44,  144, 127, 15,  53,
    111, 46,  89,  143, 251, 2,   187, 18,  183, 59,  2,   168, 246, 182, 39,  178, 169, 111,
    202, 167, 118, 68,  219, 254, 10,  252, 155, 79,  175, 135, 195, 181, 33,  135, 2,   118,
    157, 16,  173, 230, 60,  172, 179, 136, 127, 163, 207, 119, 43,  121, 1,   4,   87,  183,
    62,  161, 195, 239, 103, 254, 107, 250, 120, 113, 92,  132, 2,   155, 199, 203, 219, 73,
    84,  163, 19,  152, 184, 190, 43,  93,  138, 42,  130, 195, 82,  27,  16,  54,  228, 235,
    86,  128, 236, 95,  149, 50,  201, 44,  63,  70,  159, 185, 171, 2,   167, 39,  12,  32,
    202, 143, 164, 43,  111, 138, 53,  44,  145, 247, 185, 134, 20,  248, 82};
static uint8_t kRandData2[kRandLengths[1]] = {89,  62,  132, 192, 16,  135, 162, 191,
                                              77,  100, 134, 219, 222, 64,  133, 103,
                                              221, 158, 163, 171, 129, 162};
static uint8_t kRandData3[kRandLengths[2]] = {
    135, 57,  211, 161, 89,  252, 31, 67,  33,  218, 32,  172, 227, 216, 157, 19,  77, 250, 84,
    213, 154, 161, 246, 103, 182, 23, 116, 142, 163, 105, 121, 210, 27,  117, 55,  48, 119, 67,
    103, 15,  207, 153, 139, 117, 99, 201, 119, 123, 57,  206, 15,  254, 8,   151, 82, 152};
static uint8_t* const kRandData[3] = {kRandData1, kRandData2, kRandData3};

static const size_t kContainerDefaultCapacity = 100;
static const size_t kMaxBufSize = 256;

// utility function to save some effort getting input times
using TimePoint = std::chrono::high_resolution_clock::time_point;
using DurationType = std::chrono::duration<int64_t, std::milli>;
static uint64_t getTime()
{
    const TimePoint now = std::chrono::high_resolution_clock::now();
    const auto ticks = std::chrono::duration_cast<DurationType>(now.time_since_epoch());
    return ticks.count();
}
const uint64_t kStartTime = getTime();
static uint64_t getTimeSinceStart() { return getTime() - kStartTime; }
