---
layout: news_item
title: "ORC 2.1.0 Released"
date: "2025-01-09 03:00:00 -0800"
author: william
version: 2.1.0
categories: [release]
---

The ORC team is excited to announce the release of ORC v2.1.0.

{% assign releaseName = "2.1.0" %}
{% include release_description.md %}

### New Feature
- [ORC-262]({{site.jira}}/ORC-262) [C++] Support async prefetch in Orc reader
- [ORC-1388]({{site.jira}}/ORC-1388) [C++] Support schema evolution from decimal to timestamp/string group
- [ORC-1389]({{site.jira}}/ORC-1389) [C++] Support schema evolution from string group to numeric/string group
- [ORC-1390]({{site.jira}}/ORC-1390) [C++] Support schema evolution from string group to decimal/timestamp
- [ORC-1622]({{site.jira}}/ORC-1622) [C++] Support conan packaging
- [ORC-1807]({{site.jira}}/ORC-1807) [C++] Native support for vcpkg

### Improvement
- [ORC-1264]({{site.jira}}/ORC-1264) [C++] Add a writer option to align compression block with row group boundary
- [ORC-1365]({{site.jira}}/ORC-1365) [C++] Use BlockBuffer to replace DataBuffer of rawInputBuffer in the CompressionStream
- [ORC-1635]({{site.jira}}/ORC-1635) Try downloading orc-format from `dlcdn.apache.org` before `archive.apache.org`
- [ORC-1645]({{site.jira}}/ORC-1645) Evaulate stripe stats before load stripe footer
- [ORC-1658]({{site.jira}}/ORC-1658) [C++] uniform identifiers naming style.
- [ORC-1661]({{site.jira}}/ORC-1661) [C++] Better handling when TZDB is unavailable
- [ORC-1664]({{site.jira}}/ORC-1664) Enable the removeUnusedImports function in spotless-maven-plugin
- [ORC-1665]({{site.jira}}/ORC-1665) Enable the `importOrder` function in `spotless-maven-plugin`
- [ORC-1667]({{site.jira}}/ORC-1667) Add `check` tool to check the index of the specified column
- [ORC-1669]({{site.jira}}/ORC-1669) [C++] Deprecate HDFS support
- [ORC-1672]({{site.jira}}/ORC-1672) Modify the package name of TestCheckTool
- [ORC-1675]({{site.jira}}/ORC-1675) [C++] Print decimal values as strings
- [ORC-1677]({{site.jira}}/ORC-1677) [C++] remove `m` prefix of variables.
- [ORC-1683]({{site.jira}}/ORC-1683) Fix `instanceof` of BinaryStatisticsImpl merge method
- [ORC-1684]({{site.jira}}/ORC-1684) [C++] Find tzdb without TZDIR when in conda-environments
- [ORC-1685]({{site.jira}}/ORC-1685) Use `Pattern Matching for instanceof` in RecordReaderImpl
- [ORC-1686]({{site.jira}}/ORC-1686) [C++] Avoid using std::filesystem
- [ORC-1687]({{site.jira}}/ORC-1687) [C++] Enforce naming style.
- [ORC-1688]({{site.jira}}/ORC-1688) [C++] Do not access TZDB if there is no timestamp type
- [ORC-1689]({{site.jira}}/ORC-1689) [C++] Generate CMake config file
- [ORC-1690]({{site.jira}}/ORC-1690) [C++] Refactor CMake to use imported thirdtparty libraries
- [ORC-1710]({{site.jira}}/ORC-1710)  Reduce enum array allocation
- [ORC-1711]({{site.jira}}/ORC-1711) [C++] Introduce a memory block size parameter for writer option
- [ORC-1720]({{site.jira}}/ORC-1720) [C++] Unified compressor/decompressor exception types
- [ORC-1724]({{site.jira}}/ORC-1724) JsonFileDump utility should print user metadata
- [ORC-1730]({{site.jira}}/ORC-1730) [C++] Add finishEncode support for the encoder
- [ORC-1732]({{site.jira}}/ORC-1732) [C++] Can't detect Protobuf installed by Homebrew on macOS
- [ORC-1733]({{site.jira}}/ORC-1733) [C++] [CMake] Fix CMAKE_MODULE_PATH not to use PROJECT_SOURCE_DIR
- [ORC-1751]({{site.jira}}/ORC-1751) [C++] Syntax error in ThirdpartyToolchain
- [ORC-1767]({{site.jira}}/ORC-1767) [C++] Improve writing performance of encoded string column and support EncodedStringVectorBatch for StringColumnWriter
- [ORC-1796]({{site.jira}}/ORC-1796) [C++] Reading orc file which lack of Statistics may give wrong result
- [ORC-1810]({{site.jira}}/ORC-1810) Offline build support

### Bug Fix
- [ORC-1654]({{site.jira}}/ORC-1654) [C++] Count up EvaluatedRowGroupCount correctly.
- [ORC-1657]({{site.jira}}/ORC-1657) Fix building apache orc with clang-cl on Windows
- [ORC-1706]({{site.jira}}/ORC-1706) [C++] Fix build break w/ BUILD_CPP_ENABLE_METRICS=ON
- [ORC-1725]({{site.jira}}/ORC-1725) [C++] Statistics for BYTE type are calculated incorrectly on ARM
- [ORC-1738]({{site.jira}}/ORC-1738) Wrong Int128 maximum value
- [ORC-1811]({{site.jira}}/ORC-1811) Use the recommended `closer.lua` URL to download ORC format
- [ORC-1813]({{site.jira}}/ORC-1813) Incompatibility with ORC files written in version 0.12 due to missing hasNull field in C++ Reader

### Task
- [ORC-1573]({{site.jira}}/ORC-1573) Setting version to 2.1.0-SNAPSHOT
- [ORC-1594]({{site.jira}}/ORC-1594) Add IntelliJ conf in the project root directory to support JIRA/PR autolinks
- [ORC-1649]({{site.jira}}/ORC-1649) [C++] [Conan] Add 2.0.0 to conan recipe and update release guide
- [ORC-1655]({{site.jira}}/ORC-1655) Add label definition to conan directory
- [ORC-1656]({{site.jira}}/ORC-1656) Skip build and test on conan updates
- [ORC-1666]({{site.jira}}/ORC-1666) Remove extra newlines at the end of Java files
- [ORC-1758]({{site.jira}}/ORC-1758) Use `OpenContainers` Annotations in docker images
- [ORC-1802]({{site.jira}}/ORC-1802) Enable tag protection

### Test
- [ORC-1589]({{site.jira}}/ORC-1589) Bump `spotbugs-maven-plugin` to 4.8.3.0
- [ORC-1590]({{site.jira}}/ORC-1590) Bump `spotless-maven-plugin` to 2.42.0
- [ORC-1603]({{site.jira}}/ORC-1603) Bump `checkstyle` to 10.13.0
- [ORC-1606]({{site.jira}}/ORC-1606) Upgrade `spotless-maven-plugin` to 2.43.0
- [ORC-1611]({{site.jira}}/ORC-1611) Bump `junit` to 5.10.2
- [ORC-1651]({{site.jira}}/ORC-1651) Bump `checkstyle` to 10.14.0
- [ORC-1652]({{site.jira}}/ORC-1652) Bump `extra-enforcer-rules` to 1.8.0
- [ORC-1653]({{site.jira}}/ORC-1653) Bump `maven-assembly-plugin` to 3.7.0
- [ORC-1659]({{site.jira}}/ORC-1659) Bump `guava` to 33.1.0-jre
- [ORC-1660]({{site.jira}}/ORC-1660) Bump `checkstyle` to 10.14.2
- [ORC-1673]({{site.jira}}/ORC-1673) Remove test packages `o.a.o.tools.[count|merge|sizes]`
- [ORC-1676]({{site.jira}}/ORC-1676) Use Hive 4.0.0 in benchmark
- [ORC-1678]({{site.jira}}/ORC-1678) Bump `checkstyle` to 10.15.0
- [ORC-1680]({{site.jira}}/ORC-1680) Bump `bcpkix-jdk18on` to 1.78
- [ORC-1691]({{site.jira}}/ORC-1691) Bump `spotbugs-maven-plugin` to 4.8.4.0
- [ORC-1694]({{site.jira}}/ORC-1694) Upgrade gson to 2.9.0 for Benchmarks Hive
- [ORC-1695]({{site.jira}}/ORC-1695) Upgrade gson to 2.10.1
- [ORC-1699]({{site.jira}}/ORC-1699) Fix SparkBenchmark in Parquet format according to SPARK-40918
- [ORC-1700]({{site.jira}}/ORC-1700) Write parquet decimal type data in Benchmark using FIXED_LEN_BYTE_ARRAY type
- [ORC-1704]({{site.jira}}/ORC-1704) Migration to Scala 2.13 of Apache Spark 3.5.1 at SparkBenchmark
- [ORC-1707]({{site.jira}}/ORC-1707) Fix sun.util.calendar IllegalAccessException when SparkBenchmark runs on JDK17
- [ORC-1708]({{site.jira}}/ORC-1708) Support data/compress options in Hive benchmark
- [ORC-1709]({{site.jira}}/ORC-1709) Upgrade GitHub Action `setup-java` to v4 and use built-in cache feature
- [ORC-1713]({{site.jira}}/ORC-1713) Bump spotbugs-maven-plugin to 4.8.5.0
- [ORC-1716]({{site.jira}}/ORC-1716) Bump com.puppycrawl.tools:checkstyle to 10.16.0
- [ORC-1719]({{site.jira}}/ORC-1719) Bump `guava` to 33.2.0-jre
- [ORC-1722]({{site.jira}}/ORC-1722) Bump `checkstyle` to 10.17.0
- [ORC-1726]({{site.jira}}/ORC-1726) Bump `guava` to 33.2.1-jre
- [ORC-1727]({{site.jira}}/ORC-1727) Bump `maven-enforcer-plugin` to 3.5.0
- [ORC-1728]({{site.jira}}/ORC-1728) Bump `maven-shade-plugin` to 3.6.0
- [ORC-1729]({{site.jira}}/ORC-1729) Bump `maven-checkstyle-plugin` to 3.4.0
- [ORC-1731]({{site.jira}}/ORC-1731) Upgrade `maven-dependency-plugin` to 3.7.0
- [ORC-1735]({{site.jira}}/ORC-1735) Upgrade `maven-dependency-plugin` to 3.7.1
- [ORC-1736]({{site.jira}}/ORC-1736) Bump `junit` to 5.10.3
- [ORC-1737]({{site.jira}}/ORC-1737) Bump `spotbugs-maven-plugin` to 4.8.6.1
- [ORC-1739]({{site.jira}}/ORC-1739) Bump `spotbugs-maven-plugin` to 4.8.6.2
- [ORC-1745]({{site.jira}}/ORC-1745) Remove `Ubuntu 20.04` Support
- [ORC-1750]({{site.jira}}/ORC-1750) Bump `protobuf-java` to 3.25.4
- [ORC-1756]({{site.jira}}/ORC-1756) Bump `snappy-java` to 1.1.10.6 in `bench` module
- [ORC-1760]({{site.jira}}/ORC-1760) Upgrade `junit` to 5.11.0
- [ORC-1761]({{site.jira}}/ORC-1761) Upgrade `guava` to `33.3.0-jre`
- [ORC-1763]({{site.jira}}/ORC-1763) Upgrade `checkstyle` to 10.18.0
- [ORC-1764]({{site.jira}}/ORC-1764) Upgrade `maven-checkstyle-plugin` to 3.5.0
- [ORC-1765]({{site.jira}}/ORC-1765) Upgrade `maven-dependency-plugin` to 3.8.0
- [ORC-1771]({{site.jira}}/ORC-1771) Upgrade `checkstyle` to 10.18.1
- [ORC-1772]({{site.jira}}/ORC-1772) Bump `spotbugs-maven-plugin` to 4.8.6.3
- [ORC-1774]({{site.jira}}/ORC-1774) Upgrade `snappy-java` to 1.1.10.7 in `bench` module
- [ORC-1776]({{site.jira}}/ORC-1776) Remove `MacOS 12` from GitHub Action CI and docs
- [ORC-1778]({{site.jira}}/ORC-1778) Upgrade Spark to 4.0.0-preview2
- [ORC-1779]({{site.jira}}/ORC-1779) Upgrade `extra-enforcer-rules` to 1.9.0
- [ORC-1780]({{site.jira}}/ORC-1780) Upgrade `spotbugs-maven-plugin` to 4.8.6.4
- [ORC-1783]({{site.jira}}/ORC-1783) Add MacOS 15 to GitHub Action MacOS CI and docs
- [ORC-1786]({{site.jira}}/ORC-1786) Upgrade `guava` to 33.3.1-jre
- [ORC-1788]({{site.jira}}/ORC-1788) Upgrade `checkstyle` to 10.18.2
- [ORC-1789]({{site.jira}}/ORC-1789) Upgrade `junit` to 5.11.2
- [ORC-1790]({{site.jira}}/ORC-1790) Upgrade `parquet` to 1.14.3 in `bench` module
- [ORC-1794]({{site.jira}}/ORC-1794) Upgrade `checkstyle` to 10.19.0
- [ORC-1795]({{site.jira}}/ORC-1795) Upgrade `junit` to 5.11.3
- [ORC-1797]({{site.jira}}/ORC-1797) Upgrade `spotbugs-maven-plugin` to 4.8.6.5
- [ORC-1799]({{site.jira}}/ORC-1799) Upgrade `maven-checkstyle-plugin` to 3.6.0
- [ORC-1801]({{site.jira}}/ORC-1801) Upgrade `checkstyle` to 10.20.0
- [ORC-1804]({{site.jira}}/ORC-1804) Upgrade `parquet` to 1.14.4 in `bench` module
- [ORC-1805]({{site.jira}}/ORC-1805) Upgrade `checkstyle` to 10.20.1
- [ORC-1806]({{site.jira}}/ORC-1806) Upgrade `spotbugs-maven-plugin` to 4.8.6.6
- [ORC-1809]({{site.jira}}/ORC-1809) Upgrade `checkstyle` to 10.20.2
- [ORC-1812]({{site.jira}}/ORC-1812) Upgrade `parquet` to 1.15.0 in `bench` module
- [ORC-1816]({{site.jira}}/ORC-1816) Upgrade `checkstyle` to 10.21.0
- [ORC-1820]({{site.jira}}/ORC-1820) Bump junit.version to 5.11.4
- [ORC-1821]({{site.jira}}/ORC-1821) Upgrade `guava` to 33.4.0-jre
- [ORC-1822]({{site.jira}}/ORC-1822) [C++] [CI] Use cpp-linter-action for clang-tidy and clang-format
- [ORC-1823]({{site.jira}}/ORC-1823) Upgrade `checkstyle` to 10.21.1
- [ORC-1826]({{site.jira}}/ORC-1826) [C++] Add ASAN to CI

### Build and Dependency Changes
- [ORC-1608]({{site.jira}}/ORC-1608) Upgrade Hadoop to 3.4.0
- [ORC-1617]({{site.jira}}/ORC-1617) Upgrade `slf4j` to 2.0.12
- [ORC-1640]({{site.jira}}/ORC-1640) Upgrade cyclonedx-maven-plugin to 2.7.11
- [ORC-1650]({{site.jira}}/ORC-1650) Bump `maven-shade-plugin` to 3.5.2
- [ORC-1670]({{site.jira}}/ORC-1670) Upgrade `zstd-jni` to 1.5.6-1
- [ORC-1679]({{site.jira}}/ORC-1679) Bump `zstd-jni` 1.5.6-2
- [ORC-1682]({{site.jira}}/ORC-1682) Bump maven-assembly-plugin to 3.7.1
- [ORC-1692]({{site.jira}}/ORC-1692) Bump `slf4j` to 2.0.13
- [ORC-1693]({{site.jira}}/ORC-1693) Bump `maven-jar-plugin` to 3.4.0
- [ORC-1698]({{site.jira}}/ORC-1698) Upgrade `commons-cli` to 1.7.0
- [ORC-1701]({{site.jira}}/ORC-1701) Bump `threeten-extra` to 1.8.0
- [ORC-1702]({{site.jira}}/ORC-1702) Bump `bcpkix-jdk18on` to 1.78.1
- [ORC-1703]({{site.jira}}/ORC-1703) Bump `maven-jar-plugin` to 3.4.1
- [ORC-1705]({{site.jira}}/ORC-1705) Upgrade `zstd-jni` to 1.5.6-3
- [ORC-1712]({{site.jira}}/ORC-1712) Bump maven-shade-plugin to 3.5.3
- [ORC-1714]({{site.jira}}/ORC-1714) Bump commons-csv to 1.11.0
- [ORC-1715]({{site.jira}}/ORC-1715) Bump org.objenesis:objenesis to 3.3
- [ORC-1718]({{site.jira}}/ORC-1718) Upgrade `build-helper-maven-plugin` to 3.6.0
- [ORC-1723]({{site.jira}}/ORC-1723) Upgrade `commons-cli` to 1.8.0
- [ORC-1734]({{site.jira}}/ORC-1734) Bump `maven-jar-plugin` to 3.4.2
- [ORC-1748]({{site.jira}}/ORC-1748) Upgrade `commons-lang3` to 3.15.0
- [ORC-1755]({{site.jira}}/ORC-1755) Bump `commons-lang3` to 3.16.0
- [ORC-1757]({{site.jira}}/ORC-1757) Bump `slf4j` to 2.0.14
- [ORC-1759]({{site.jira}}/ORC-1759) Upgrade `commons-cli` to 1.9.0
- [ORC-1762]({{site.jira}}/ORC-1762) Bump `slf4j` to 2.0.16
- [ORC-1766]({{site.jira}}/ORC-1766) Upgrade `brotli4j` to 1.17.0
- [ORC-1768]({{site.jira}}/ORC-1768) Upgrade `commons-lang3` to 3.17.0
- [ORC-1773]({{site.jira}}/ORC-1773) Bump `reproducible-build-maven-plugin` to 0.17
- [ORC-1775]({{site.jira}}/ORC-1775) Upgrade `aircompressor` to 2.0.2
- [ORC-1777]({{site.jira}}/ORC-1777) Upgrade `protobuf-java` to 3.25.5
- [ORC-1781]({{site.jira}}/ORC-1781) Upgrade `zstd-jni` to 1.5.6-6
- [ORC-1782]({{site.jira}}/ORC-1782) Upgrade Hadoop to 3.4.1
- [ORC-1784]({{site.jira}}/ORC-1784) Upgrade `Maven` to 3.9.9
- [ORC-1785]({{site.jira}}/ORC-1785) Upgrade `commons-csv` to 1.12.0
- [ORC-1791]({{site.jira}}/ORC-1791) Remove `commons-lang3` dependency
- [ORC-1798]({{site.jira}}/ORC-1798) Upgrade `maven-dependency-plugin` to 3.8.1
- [ORC-1803]({{site.jira}}/ORC-1803) Upgrade `zstd-jni` to 1.5.6-7
- [ORC-1808]({{site.jira}}/ORC-1808) Upgrade `zstd-jni` to 1.5.6-8
- [ORC-1817]({{site.jira}}/ORC-1817) Upgrade `brotli4j` to 1.18.0
- [ORC-1825]({{site.jira}}/ORC-1825) [C++] Bump Snappy to 1.2.1
- [ORC-1827]({{site.jira}}/ORC-1827) [C++] Bump ZLIB to 1.3.1
- [ORC-1828]({{site.jira}}/ORC-1828) [C++] Bump LZ4 to 1.10.0

### Documentation
- [ORC-642]({{site.jira}}/ORC-642) Update PatchedBase doc with patch ceiling in spec
- [ORC-1634]({{site.jira}}/ORC-1634) Fix some outdated descriptions in Building ORC documentation
- [ORC-1668]({{site.jira}}/ORC-1668) Add merge command to Java tools documentation
- [ORC-1800]({{site.jira}}/ORC-1800) Upgrade `bcpkix-jdk18on` to 1.79
- [ORC-1814]({{site.jira}}/ORC-1814) Use Ubuntu 24.04/Jekyll 4.3/Rouge 4.5 to generate website
- [ORC-1815]({{site.jira}}/ORC-1815) Remove broken `people.apache.org` links
- [ORC-1819]({{site.jira}}/ORC-1819) Publish snapshot website through GitHub Pages
- [ORC-1824]({{site.jira}}/ORC-1824) Update Python documentation with PyArrow 18.1.0 and Task 2024.12.1
- [ORC-1830]({{site.jira}}/ORC-1830) Fix release table hyperlink to use baseurl
