<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

November 23, 2020

Host: Michael Dolan

Rotating Secretary: Doug Walker

Attendees:
  * [ ] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [X] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Deke Kincaid - Digital Domain

Apologies:
  Mark Boorer

# **OCIO TSC Meeting Notes**

* ASWF Survey:
    - Michael: Our part of the ASWF survey includes a question "Are there any
      areas of color management that OCIO is NOT helping you with?".  Is there a
      way to make this multiple choice to fit with the rest of the survey?
    - Carol: I would remove if it needs to be multiple choice.  Don't want to
      seed responses.  Michael, Doug, Kevin: agree.  
    - Kevin: Also don't want to imply we are thinking about adding something
      that we actually are not.
    - Michael: Will try to keep it as an optional write-in.

* Documentation Update:
    - Michael: Hoping to wrap up PR #1197 in a few days.  Adding the part to
      handle Python that we discussed previously.  Basic issue is that RTD does not
      allow us to use cmake and build.  Implies Python needs to be pre-generated and
      "frozen" into the repo.  Also implies Doxygen needs to be run via Sphinx rather
      than cmake.
    - Michael: Not happy with how complicated the solution is but until RTD
      supports cmake, will need some kind of solution like this.  The process of
      generating and updating the documentation will itself need careful
      documentation.
    - Doug: Thanks for working on this Michael!

* Review of Current and Upcoming PRs:
    - Doug: We've pushed several PRs in the past week: #1208, #1214, #1215. 
      These are all either minor clean-ups or bug fixes.  The most important is #1215
      since it fixes a bug reading v1 configs that use "interpolation=unknown" in a
      FileTransform.  We view this as a critical bug fix and would like to merge it
      before placing the beta1 tag.  Does anyone object to us going ahead and merging
      this one now?
    - Michael, Mark, Carol, Kevin: Yes, merge #1215 immediately.  (No one objected.)
    - Doug: We will go ahead and merge it and then place the "beta1" tag
      discussed at the previous TSC meeting.
    - Doug: We have two more PRs that will land this week.  First is related to
      Issue #1155.  In that issue I proposed cleaining up the CDLTransform API.  We
      have done that and moved the parsing and serialization code out of CDLTransform
      and put it in the FileFormat modules, to be more like the other formats.  We did
      not go quite as far as I had proposed in Issue #1155 in that we did not remove
      all the mentioned functions (although the name of one was changed to clarify
      what it does).  Also, we moved the write method from the Processor class to the
      GroupTransform class.
    - Michael: Why move the write method to the GroupTransform?
    - Patrick: It allows for more flexibility, don't need to create a Processor
      in order to write.  No functionality is removed, one may always get a
      GroupTransform from a Processor.
    - Doug: Note that this was not in v1, so moving it will not break any
      existing apps.
    - Michael: Is there a case for also leaving it on Processor so that it's
      more discoverable?
    - Patrick: Metadata may be lost when a Processor is built, also some
      spurious items may be added (Allocation, etc.).  Having it on the GroupTransform
      is a better design, allows one to write exactly what is intended.  It's more
      deterministic.
    - Kevin: If the worry is about making it discoverable, that could be done
      via documentation rather than leaving it in the Processor API.
    - Michael: Yes, and it could also be confusing to have it in both places
      giving somewhat different results.
    - Doug: The other PR landing this week is a move of the AppHelpers modules
      into the core.  This is following up on the TSC's request to move it from a
      separate library into the core.  The goal is to avoid needing two OCIO libraries
      (for Linux distros, etc.).
    - Michael: What about the OIIO and OGL helpers?  Patrick: Those remain as
      separate.  Really don't want to bring those third-party dependencies into the
      core library.  AppHelpers adds no third-party dependencies.

* OpenEXR 3.0
    - Michael: Their v3 is on the way.  Pulling from top of tree may break
      downstreams.  We pull from most recent tag, so not impacted yet but will be
      soon.  Currently we do some special stuff in our cmake since the only thing we
      need is half.h.  This could probably be improved based on their refactoring.
    - Patrick: This dependency is not in our public API, but agree it will
      require some updates.  Could be a good first issue for someone.
    - Doug: Michael, would you create an issue on GitHub so it has more
      visibility?  Michael: Yes, will do.

* Open Tasks Needed for OCIO v2
    - Michael: Wanted to discuss some of the remaining items.  Mei, where do we
      stand with the Python unit tests?
    - Mei: The Transforms is the area that needs the most work.  Would also like
      to centralize more.
    - Michael: If you need help, reach out.  Don't want you to feel like this is
      all on your shoulders.  Mei: Will do.
    - Michael: On the documentation front, where are there holes?  Is it all
      documented in the GitHub Project?
    - Carol: We don't have Issues created for everything.  There are still some
      items in my head, and Doug's too probably.  We have been trying to onboard new
      contributors.  Have received some great assistance from Zach.  We have some
      tasks that would benefit from having a sample v2 config, but not blocked by that
      yet.
    - Doug: Another important task is making OpenFX plug-ins for v2.  We have a
      student who has volunteered to help with this but he is having trouble getting
      the example plug-ins from the OpenFX SDK loaded.  He's tried Natron but the
      plug-ins are not loading.  Not sure if it is a problem with what he's built or
      in Natron.  Once he gets the plug-ins loading in a host, Patrick and I could
      help him with the OCIO part but is there anyone that could help us get him over
      this first hurdle of getting some example plug-ins to load?  The student has
      posted in #dev on Slack asking for help.
    - Michael: Mark, OpenFX was originally a Foundry initiative, right?  Is
      there someone on your team that could help?
    - Mark: I will check.  Also, once the plug-ins are ready to test, we could
      help with that too.

* Items for next TSC meeting agenda:
    - Doug: The Named Transform will soon be a blocker for us.  Need to get to a
      resolution on that.  Also, would like to know if our reply to ILM's memo
      addressed their other concerns.
    - Michael: I have put Named Transform on the agenda for next meeting. 
      Carol: Could set a goal to resolve it.
    - Patrick: The end of the year is rapidly approaching and in the roadmap
      presentations we showed releasing a v2 library at year end.  Need to make rapid
      progress.
    - Michael: We may need to settle for just having the release candidate done
      by then.  Would like to have more feedback before the final release.
    - Doug: Agree.  I'd also like to have a discussion around the categories feature. 
      The code was added a long time ago but we still need to have the discussion
      around what are the recommended strings.  (These are the strings that allow apps
      to filter the list of color spaces based on the specific menus.)
    - Deke: Sounds good, we're excited about that.
    - Carol: Yes, I'll also put some thoughts on GitHub prior to the next live
      discussion.
    - Doug: I'll create an Issue for the category naming.

* Documentation Meeting Schedule
    - The group decided to cancel the documentation working group meeting this
      Friday due to the Thanksgiving holiday in the US.
