#
# Copyright (c) 2025, MediaTek Inc. All rights reserved.
#
# SPDX-License-Identifier: BSD-3-Clause
#

# Separate text code and read only data
SEPARATE_CODE_AND_RODATA := 1

# ARMv8.2 and above need enable HW assist coherence
HW_ASSISTED_COHERENCY := 1

# No need coherency memory because of HW assistency
USE_COHERENT_MEM := 0

# GIC600
GICV3_SUPPORT_GIC600 := 1

#
# MTK options
#
MCUSYS_VERSION := v1
PLAT_EXTRA_RODATA_INCLUDES := 1
CONFIG_MTK_DISABLE_CACHE_AS_RAM := $(COREBOOT)
CONFIG_ARCH_ARM_V8_2 := y
CONFIG_MTK_PMIC_WRAP_V3 := y
MTK_PUBEVENT_ENABLE := y
CONFIG_MTK_PM_SUPPORT := y
CONFIG_MTK_PM_ARCH := 8_2
CONFIG_MTK_CPU_PM_SUPPORT := y
CONFIG_MTK_CPU_PM_ARCH := 3_2
CONFIG_MTK_SMP_EN := y
CPU_PM_SPM_CORE_POWERON := y
CONFIG_MTK_SPM_COMMON_SUPPORT := y
CONFIG_MTK_SPM_SUPPORT := y
CONFIG_MTK_SPM_VERSION := mt8189
CONFIG_MTK_MTCMOS := y
CONFIG_MTK_CPU_SUSPEND_EN := y
CPU_PM_DOMAIN_CORE_ONLY := n
CPU_PM_SUSPEND_NOTIFY := y
CPU_PM_TINYSYS_SUPPORT := y
CPU_PM_CACHE_AUTO_DORMANT_DIS := y

CONFIG_MTK_PMIC := y
CONFIG_MTK_PMIC_LOWPOWER := y
CONFIG_MTK_PMIC_SHUTDOWN_CFG := y
CONFIG_MTK_PMIC_SHUTDOWN_V2 := y
CONFIG_MTK_SPMI := y
PMIC_CHIP := mt6359p
USE_PMIC_WRAP_INIT_V3 := 1

# Configs for A78 and A55
CTX_INCLUDE_AARCH32_REGS := 0
ERRATA_A55_1530923 := 1
ERRATA_A55_1221012 := 1
ERRATA_A78_1688305 := 1
ERRATA_A78_1941498 := 1
ERRATA_A78_1951500 := 1
ERRATA_A78_1821534 := 1
ERRATA_A78_2132060 := 1
ERRATA_A78_2242635 := 1
ERRATA_A78_2376745 := 1
ERRATA_A78_2395406 := 1
