/*
 * Copyright (c) 2025, MediaTek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef PCM_DEF_H
#define PCM_DEF_H

/*-- MD32PCM_STA1 define */
#define R12_PCM_TIMER_B BIT(0)
#define R12_TWAM_PMSR_DVFSRC BIT(1)
#define R12_KP_IRQ_B BIT(2)
#define R12_APWDT_EVENT_B BIT(3)
#define R12_APXGPT_EVENT_B BIT(4)
#define R12_CONN2AP_WAKEUP_B BIT(5)
#define R12_EINT_EVENT_B BIT(6)
#define R12_CONN_WDT_IRQ_B BIT(7)
#define R12_CCIF0_EVENT_B BIT(8)
#define R12_CCIF1_EVENT_B BIT(9)
#define R12_SSPM2SPM_WAKEUP_B BIT(10)
#define R12_SCP2SPM_WAKEUP_B BIT(11)
#define R12_VADSP2SPM_WAKEUP_B BIT(12)
#define R12_PCM_WDT_WAKEUP_B BIT(13)
#define R12_USB0_CDSC_B BIT(14)
#define R12_USB0_POWERDWN_B BIT(15)
#define R12_SBD_INTR_B BIT(16)
#define R12_UART2SPM_IRQ_B BIT(17)
#define R12_SYS_TIMER_EVENT_B BIT(18)
#define R12_EINT_EVENT_SECURE_B BIT(19)
#define R12_AFE_IRQ_MCU_B BIT(20)
#define R12_THERM_CTRL_EVENT_B BIT(21)
#define R12_SYS_CIRQ_IRQ_B BIT(22)
#define R12_MD2AP_PEER_EVENT_B BIT(23)
#define R12_CSYSPWREQ_B BIT(24)
#define R12_MD_WDT_B BIT(25)
#define R12_AP2AP_PEER_WAKEUP_B BIT(26)
#define R12_SEJ_B BIT(27)
#define R12_CPU_WAKEUP BIT(28)
#define R12_APUSYS_WAKE_HOST_B BIT(29)
#define R12_PCIE_MAC_IRQ_WAKE_B BIT(30)
#define R12_MSDC_WAKEUP_EVENT_B BIT(31)

/*-- MD32PCM_STA2 define */
#define EVENT_F26M_WAKE BIT(0)
#define EVENT_F26M_SLEEP BIT(1)
#define EVENT_INFRA_WAKE BIT(2)
#define EVENT_INFRA_SLEEP BIT(3)
#define EVENT_EMI_WAKE BIT(4)
#define EVENT_EMI_SLEEP BIT(5)
#define EVENT_APSRC_WAKE BIT(6)
#define EVENT_APSRC_SLEEP BIT(7)
#define EVENT_VRF18_WAKE BIT(8)
#define EVENT_VRF18_SLEEP BIT(9)
#define EVENT_DVFS_WAKE BIT(10)
#define EVENT_DDREN_WAKE BIT(11)
#define EVENT_DDREN_SLEEP BIT(12)
#define EVENT_VCORE_WAKE BIT(13)
#define EVENT_VCORE_SLEEP BIT(14)
#define EVENT_PMIC_WAKE BIT(15)
#define EVENT_PMIC_SLEEP BIT(16)
#define EVENT_CPUEB_STATE BIT(17)
#define EVENT_SSPM_STATE BIT(18)
#define EVENT_DPM_STATE BIT(19)
#define EVENT_CONN_SRCCLKENB_D2T BIT(20)
#define EVENT_SW_MAILBOX_WAKE BIT(21)
#define EVENT_SPM_LEAVE_SUSPEND_ACK BIT(22)
#define EVENT_SPM_LEAVE_DEEPIDLE_ACK BIT(23)
#define EVENT_CROSS_REQ_APU_l3 BIT(24)
#define EVENT_DFD_SOC_MTCMOS_REQ BIT(25)
#define EVENT_AOVBUS_WAKE BIT(26)
#define EVENT_AOVBUS_SLEEP BIT(27)

enum SPM_WAKE_SRC_LIST {
	WAKE_SRC_STA1_PCM_TIMER = BIT(0),
	WAKE_SRC_STA1_TWAM_PMSR_DVFSRC = BIT(1),
	WAKE_SRC_STA1_KP_IRQ_B = BIT(2),
	WAKE_SRC_STA1_APWDT_EVENT_B = BIT(3),
	WAKE_SRC_STA1_APXGPT1_EVENT_B = BIT(4),
	WAKE_SRC_STA1_CONN2AP_SPM_WAKEUP_B = BIT(5),
	WAKE_SRC_STA1_EINT_EVENT_B = BIT(6),
	WAKE_SRC_STA1_CONN_WDT_IRQ_B = BIT(7),
	WAKE_SRC_STA1_CCIF0_EVENT_B = BIT(8),
	WAKE_SRC_STA1_CCIF1_EVENT_B = BIT(9),
	WAKE_SRC_STA1_SC_SSPM2SPM_WAKEUP_B = BIT(10),
	WAKE_SRC_STA1_SC_SCP2SPM_WAKEUP_B = BIT(11),
	WAKE_SRC_STA1_VADSP2SPM_WAKEUP_B = BIT(12),
	WAKE_SRC_STA1_PCM_WDT_WAKEUP_B = BIT(13),
	WAKE_SRC_STA1_USB_CDSC_B = BIT(14),
	WAKE_SRC_STA1_USB_POWERDWN_B = BIT(15),
	WAKE_SRC_STA1_SBD_INTR_B = BIT(16),
	WAKE_SRC_STA1_UART2SPM_IRQ_B = BIT(17),
	WAKE_SRC_STA1_SYS_TIMER_EVENT_B = BIT(18),
	WAKE_SRC_STA1_EINT_EVENT_SECURE_B = BIT(19),
	WAKE_SRC_STA1_AFE_IRQ_MCU_B = BIT(20),
	WAKE_SRC_STA1_THERM_CTRL_EVENT_B = BIT(21),
	WAKE_SRC_STA1_SYS_CIRQ_IRQ_B = BIT(22),
	WAKE_SRC_STA1_MD2AP_PEER_EVENT_B = BIT(23),
	WAKE_SRC_STA1_CSYSPWREQ_B = BIT(24),
	WAKE_SRC_STA1_MD1_WDT_B = BIT(25),
	WAKE_SRC_STA1_AP2AP_PEER_WAKEUPEVENT_B = BIT(26),
	WAKE_SRC_STA1_SEJ_EVENT_B = BIT(27),
	WAKE_SRC_STA1_SPM_CPU_WAKEUPEVENT_B = BIT(28),
	WAKE_SRC_STA1_APUSYS_WAKE_HOST_B = BIT(29),
	WAKE_SRC_STA1_PCIE_MAC_IRQ_WAKE_B = BIT(30),
	WAKE_SRC_STA1_MSDC_WAKEUP_EVENT_B = BIT(31),
};

extern const char *wakesrc_str[32];

#endif /* PCM_DEF_H */
