# Domoticz Open Source Security Policies and Procedures

This document describes our security procedures and general policies for the Domoticz Open Source projects as found on https://github.com/domoticz.

  * [Reporting a Vulnerability](#reporting-a-vulnerability)
  * [Disclosure Policy](#disclosure-policy)
  * [Releases under maintenance](#Releases-under-maintenance)

## Reporting a Vulnerability 

The team and community of Domoticz take all security vulnerabilities seriously. Thank you for improving the security of our open source software. We appreciate your efforts and responsible disclosure and will make every effort to acknowledge your contributions.

Report security vulnerabilities by emailing the Domoticz team at:

    security@domoticz.com

Normally we will acknowledge your email within 24 hours, and will send a more detailed response within a week indicating the next steps in handling your report. After the initial reply to your report, the team will endeavor to keep you informed of the progress towards a fix and full announcement, and may ask for additional information or guidance.

Please report security vulnerabilities in third-party modules to the person or team maintaining the module.

## Disclosure Policy

When the team receives a security bug report, they will assign it to a primary handler. This person will coordinate the fix and release process, involving the following steps:

  * Confirm the problem and determine if any releases under maintenance are affected.
  * Audit code to find any potential similar problems.
  * Prepare fixes for all releases still under maintenance.

## Releases under maintenance

Currently, only the latest [_Stable_](https://www.domoticz.com/downloads/) release and the latest _Beta_ release will receive security fixes addressing reported and confirmed security issues.
