/* vi: set sw=4 ts=4: */
#include "tinylogin.h"

#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <termios.h>
#include <unistd.h>
#include <utmp.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <ctype.h>
#include <time.h>


/* + Construct an argv that login_main() can parse.
 * + For options that can't be specified on argv,
 *   modify global variables.  (ewwww)
 * + return argc
 */
static int
construct_argv(
			   char **argv,
			   char *username, int preserve, char *shell, char *command)
{
	int argc = 0;

	argv[argc++] = "su";
	if (preserve) {
		argv[argc++] = "-p";
	}
	argv[argc++] = username;

	argv[argc] = NULL;
	return argc;
}


/* 
 * TODO : I need to see if I can support the lone dash option.
 *      : I need to try to support the other options
 *      : -* poor schizophrenic login_main() *-
 `.________________________________________________________________________ */
int su_main(int argc, char **argv)
{
	int flag;
	int opt_preserve = 0;
	int opt_loginshell = 0;
	char *opt_shell = NULL;
	char *opt_command = NULL;
	char *username = "root";

	char *custom_argv[16];
	int custom_argc;
	extern int su_mode;

	su_mode = 1;

	/* su called w/ no args */
	if (argc == 1) {
		custom_argc = construct_argv(custom_argv,
									 username,
									 opt_preserve, opt_shell, opt_command);
		return login_main(custom_argc, custom_argv);
	}

	/* getopt */
	while ((flag = getopt(argc, argv, "c:hmps:")) != EOF) {
		switch (flag) {

		case 'c':
			opt_command = optarg;
			break;

		case 'h':
			usage(su_usage);
			break;

		case 'm':
		case 'p':
			opt_preserve = 1;
			break;

		case 's':
			opt_shell = optarg;
			break;

		default:
			usage(su_usage);
			break;
		}
	}

	/* get user if specified */
	if (optind < argc) {
		if (strcmp(argv[optind], "-") == 0) {
			opt_loginshell = 1;
			if ((optind + 1) < argc) {
				username = argv[++optind];
			}
		} else {
			username = argv[optind];
		}
		optind++;
	}

	/* construct custom_argv */
	custom_argc = construct_argv(custom_argv,
								 username,
								 opt_preserve, opt_shell, opt_command);

	/* reset getopt | how close to kosher is this? | damn globals */
	optind = 0;

	return login_main(custom_argc, custom_argv);
}
