/*
Copyright (c) 2006-2018, John Hurst
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*! \file    MDD.[h|cpp]
    \version $Id$
    \brief   MXF Metadata Dictionary
*/
//
// MDD.cpp
//

#include "KLV.h"

static const ASDCP::MDDEntry s_MDD_Table[] = {
   { { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 0
       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MICAlgorithm_NONE" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 1
       0x0d, 0x01, 0x02, 0x01, 0x10, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MXFInterop_OPAtom" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x02, // 2
       0x0d, 0x01, 0x02, 0x01, 0x10, 0x00, 0x00, 0x00 },
     {0, 0}, false, "OPAtom" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 3
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x00 },
     {0, 0}, false, "OP1a" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x03, // 4
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x7f, 0x01, 0x00 },
     {0, 0}, false, "GCMulti" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 5
       0x01, 0x03, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PictureDataDef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 6
       0x01, 0x03, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "SoundDataDef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 7
       0x01, 0x03, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TimecodeDataDef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 8
       0x01, 0x03, 0x02, 0x01, 0x10, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DescriptiveMetaDataDef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 9
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x06, 0x01, 0x00 },
     {0, 0}, false, "WAVWrappingFrame" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x02, // 10
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x04, 0x60, 0x00 },
     {0, 0}, false, "MPEG2_VESWrappingFrame" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x07, // 11
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x0c, 0x01, 0x00 },
     {0, 0}, false, "MXFGCFUFrameWrappedPictureElement" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x01, // 12
       0x0d, 0x01, 0x03, 0x01, 0x15, 0x01, 0x08, 0x00 },
     {0, 0}, false, "JPEG2000Essence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x01, // 13
       0x0d, 0x01, 0x03, 0x01, 0x15, 0x01, 0x05, 0x00 },
     {0, 0}, false, "MPEG2Essence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x04, 0x01, 0x07, // 14
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x7e, 0x01, 0x00 },
     {0, 0}, false, "MXFInterop_CryptEssence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x04, 0x01, 0x01, // 15
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x7e, 0x01, 0x00 },
     {0, 0}, false, "CryptEssence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x01, // 16
       0x0d, 0x01, 0x03, 0x01, 0x16, 0x01, 0x01, 0x00 },
     {0, 0}, false, "WAVEssence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x09, // 17
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x01, 0x03 },
     {0, 0}, false, "JP2KEssenceCompression_2K" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x09, // 18
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x01, 0x04 },
     {0, 0}, false, "JP2KEssenceCompression_4K" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x07, // 19
       0x02, 0x09, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "CipherAlgorithm_AES" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x07, // 20
       0x02, 0x09, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MICAlgorithm_HMAC_SHA1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 21
       0x03, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "KLVFill" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 22
       0x03, 0x01, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_MajorVersion" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 23
       0x03, 0x01, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_MinorVersion" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 24
       0x03, 0x01, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_KAGSize" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 25
       0x06, 0x10, 0x10, 0x03, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_ThisPartition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 26
       0x06, 0x10, 0x10, 0x02, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_PreviousPartition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 27
       0x06, 0x10, 0x10, 0x05, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_FooterPartition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 28
       0x04, 0x06, 0x09, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_HeaderByteCount" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 29
       0x04, 0x06, 0x09, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_IndexByteCount" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 30
       0x01, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_IndexSID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 31
       0x06, 0x08, 0x01, 0x02, 0x01, 0x03, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_BodyOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 32
       0x01, 0x03, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_BodySID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 33
       0x01, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_OperationalPattern" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 34
       0x01, 0x02, 0x02, 0x10, 0x02, 0x01, 0x00, 0x00 },
     {0, 0}, false, "PartitionMetadata_EssenceContainers" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 35
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x02, 0x01, 0x00 },
     {0, 0}, false, "OpenHeader" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 36
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x02, 0x03, 0x00 },
     {0, 0}, false, "OpenCompleteHeader" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 37
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x02, 0x02, 0x00 },
     {0, 0}, false, "ClosedHeader" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 38
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x02, 0x04, 0x00 },
     {0, 0}, false, "ClosedCompleteHeader" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 39
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x03, 0x01, 0x00 },
     {0, 0}, false, "OpenBodyPartition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 40
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x03, 0x03, 0x00 },
     {0, 0}, false, "OpenCompleteBodyPartition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 41
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x03, 0x02, 0x00 },
     {0, 0}, false, "ClosedBodyPartition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 42
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x03, 0x04, 0x00 },
     {0, 0}, false, "ClosedCompleteBodyPartition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 43
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x04, 0x02, 0x00 },
     {0, 0}, false, "Footer" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 44
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x04, 0x04, 0x00 },
     {0, 0}, false, "CompleteFooter" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 45
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x05, 0x01, 0x00 },
     {0, 0}, false, "Primer" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 46
       0x06, 0x01, 0x01, 0x07, 0x15, 0x00, 0x00, 0x00 },
     {0, 0}, false, "Primer_LocalTagEntryBatch" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 47
       0x01, 0x03, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "LocalTagEntryBatch_Primer_LocalTag" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 48
       0x01, 0x03, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "LocalTagEntryBatch_Primer_UID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 49
       0x01, 0x01, 0x15, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0x3c, 0x0a}, false, "InterchangeObject_InstanceUID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 50
       0x05, 0x20, 0x07, 0x01, 0x08, 0x00, 0x00, 0x00 },
     {0x01, 0x02}, true, "GenerationInterchangeObject_GenerationUID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 51
       0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DefaultObject" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 52
       0x05, 0x30, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00 },
     {0x3f, 0x0b}, false, "IndexTableSegmentBase_IndexEditRate" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 53
       0x07, 0x02, 0x01, 0x03, 0x01, 0x0a, 0x00, 0x00 },
     {0x3f, 0x0c}, false, "IndexTableSegmentBase_IndexStartPosition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 54
       0x07, 0x02, 0x02, 0x01, 0x01, 0x02, 0x00, 0x00 },
     {0x3f, 0x0d}, false, "IndexTableSegmentBase_IndexDuration" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 55
       0x04, 0x06, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0x3f, 0x05}, false, "IndexTableSegmentBase_EditUnitByteCount" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 56
       0x01, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00 },
     {0x3f, 0x06}, false, "IndexTableSegmentBase_IndexSID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 57
       0x01, 0x03, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },
     {0x3f, 0x07}, false, "IndexTableSegmentBase_BodySID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 58
       0x04, 0x04, 0x04, 0x01, 0x01, 0x00, 0x00, 0x00 },
     {0x3f, 0x08}, false, "IndexTableSegmentBase_SliceCount" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 59
       0x04, 0x04, 0x04, 0x01, 0x07, 0x00, 0x00, 0x00 },
     {0x3f, 0x0e}, true, "IndexTableSegmentBase_PosTableCount" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 60
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x10, 0x01, 0x00 },
     {0, 0}, false, "IndexTableSegment" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 61
       0x04, 0x04, 0x04, 0x01, 0x06, 0x00, 0x00, 0x00 },
     {0x3f, 0x09}, true, "IndexTableSegment_DeltaEntryArray" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 62
       0x04, 0x04, 0x04, 0x01, 0x04, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DeltaEntryArray_IndexTableSegment_PosTableIndex" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 63
       0x04, 0x04, 0x04, 0x01, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DeltaEntryArray_IndexTableSegment_Slice" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 64
       0x04, 0x04, 0x04, 0x01, 0x03, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DeltaEntryArray_IndexTableSegment_ElementDelta" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 65
       0x04, 0x04, 0x04, 0x02, 0x05, 0x00, 0x00, 0x00 },
     {0x3f, 0x0a}, false, "IndexTableSegment_IndexEntryArray" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 66
       0x04, 0x04, 0x04, 0x02, 0x03, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IndexEntryArray_IndexTableSegment_TemporalOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 67
       0x04, 0x04, 0x04, 0x02, 0x04, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IndexEntryArray_IndexTableSegment_AnchorOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 68
       0x04, 0x04, 0x04, 0x02, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IndexEntryArray_IndexTableSegment_Flags" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 69
       0x04, 0x04, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IndexEntryArray_IndexTableSegment_StreamOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 70
       0x04, 0x04, 0x04, 0x01, 0x05, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IndexEntryArray_IndexTableSegment_SliceOffsetArray" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 71
       0x04, 0x04, 0x04, 0x01, 0x08, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IndexEntryArray_IndexTableSegment_PosTableArray" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 72
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x11, 0x01, 0x00 },
     {0, 0}, false, "RandomIndexMetadata" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 73
       0x01, 0x03, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionArray_RandomIndexMetadata_BodySID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 74
       0x06, 0x09, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PartitionArray_RandomIndexMetadata_ByteOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 75
       0x04, 0x06, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "RandomIndexMetadata_Length" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 76
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x11, 0x00, 0x00 },
     {0, 0}, false, "RandomIndexMetadataV10" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 77
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2f, 0x00 },
     {0, 0}, false, "Preface" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 78
       0x07, 0x02, 0x01, 0x10, 0x02, 0x04, 0x00, 0x00 },
     {0x3b, 0x02}, false, "Preface_LastModifiedDate" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 79
       0x03, 0x01, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00 },
     {0x3b, 0x05}, false, "Preface_Version" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 80
       0x03, 0x01, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00 },
     {0x3b, 0x07}, true, "Preface_ObjectModelVersion" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 81
       0x06, 0x01, 0x01, 0x04, 0x01, 0x08, 0x00, 0x00 },
     {0x3b, 0x08}, true, "Preface_PrimaryPackage" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 82
       0x06, 0x01, 0x01, 0x04, 0x06, 0x04, 0x00, 0x00 },
     {0x3b, 0x06}, false, "Preface_Identifications" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 83
       0x06, 0x01, 0x01, 0x04, 0x02, 0x01, 0x00, 0x00 },
     {0x3b, 0x03}, false, "Preface_ContentStorage" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 84
       0x01, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00 },
     {0x3b, 0x09}, false, "Preface_OperationalPattern" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 85
       0x01, 0x02, 0x02, 0x10, 0x02, 0x01, 0x00, 0x00 },
     {0x3b, 0x0a}, false, "Preface_EssenceContainers" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 86
       0x01, 0x02, 0x02, 0x10, 0x02, 0x02, 0x00, 0x00 },
     {0x3b, 0x0b}, false, "Preface_DMSchemes" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 87
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00 },
     {0, 0}, false, "Identification" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 88
       0x05, 0x20, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00 },
     {0x3c, 0x09}, false, "Identification_ThisGenerationUID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 89
       0x05, 0x20, 0x07, 0x01, 0x02, 0x01, 0x00, 0x00 },
     {0x3c, 0x01}, false, "Identification_CompanyName" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 90
       0x05, 0x20, 0x07, 0x01, 0x03, 0x01, 0x00, 0x00 },
     {0x3c, 0x02}, false, "Identification_ProductName" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 91
       0x05, 0x20, 0x07, 0x01, 0x04, 0x00, 0x00, 0x00 },
     {0x3c, 0x03}, true, "Identification_ProductVersion" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 92
       0x05, 0x20, 0x07, 0x01, 0x05, 0x01, 0x00, 0x00 },
     {0x3c, 0x04}, false, "Identification_VersionString" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 93
       0x05, 0x20, 0x07, 0x01, 0x07, 0x00, 0x00, 0x00 },
     {0x3c, 0x05}, false, "Identification_ProductUID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 94
       0x07, 0x02, 0x01, 0x10, 0x02, 0x03, 0x00, 0x00 },
     {0x3c, 0x06}, false, "Identification_ModificationDate" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 95
       0x05, 0x20, 0x07, 0x01, 0x0a, 0x00, 0x00, 0x00 },
     {0x3c, 0x07}, true, "Identification_ToolkitVersion" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 96
       0x05, 0x20, 0x07, 0x01, 0x06, 0x01, 0x00, 0x00 },
     {0x3c, 0x08}, true, "Identification_Platform" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 97
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00 },
     {0, 0}, false, "ContentStorage" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 98
       0x06, 0x01, 0x01, 0x04, 0x05, 0x01, 0x00, 0x00 },
     {0x19, 0x01}, false, "ContentStorage_Packages" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 99
       0x06, 0x01, 0x01, 0x04, 0x05, 0x02, 0x00, 0x00 },
     {0x19, 0x02}, true, "ContentStorage_EssenceContainerData" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 100
       0x06, 0x01, 0x01, 0x04, 0x05, 0x00, 0x00, 0x00 },
     {0x19, 0x01}, false, "ContentStorageKludge_V10Packages" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 101
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x00 },
     {0, 0}, false, "EssenceContainerData" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 102
       0x06, 0x01, 0x01, 0x06, 0x01, 0x00, 0x00, 0x00 },
     {0x27, 0x01}, false, "EssenceContainerData_LinkedPackageUID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 103
       0x01, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00 },
     {0x3f, 0x06}, true, "EssenceContainerData_IndexSID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 104
       0x01, 0x03, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },
     {0x3f, 0x07}, false, "EssenceContainerData_BodySID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 105
       0x01, 0x01, 0x15, 0x10, 0x00, 0x00, 0x00, 0x00 },
     {0x44, 0x01}, false, "GenericPackage_PackageUID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 106
       0x01, 0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00 },
     {0x44, 0x02}, true, "GenericPackage_Name" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 107
       0x07, 0x02, 0x01, 0x10, 0x01, 0x03, 0x00, 0x00 },
     {0x44, 0x05}, false, "GenericPackage_PackageCreationDate" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 108
       0x07, 0x02, 0x01, 0x10, 0x02, 0x05, 0x00, 0x00 },
     {0x44, 0x04}, false, "GenericPackage_PackageModifiedDate" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 109
       0x06, 0x01, 0x01, 0x04, 0x06, 0x05, 0x00, 0x00 },
     {0x44, 0x03}, false, "GenericPackage_Tracks" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 110
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00 },
     {0, 0}, false, "NetworkLocator" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 111
       0x01, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },
     {0x40, 0x01}, false, "NetworkLocator_URLString" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 112
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x33, 0x00 },
     {0, 0}, false, "TextLocator" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 113
       0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00 },
     {0x41, 0x01}, false, "TextLocator_LocatorName" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 114
       0x01, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0x48, 0x01}, false, "GenericTrack_TrackID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 115
       0x01, 0x04, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00 },
     {0x48, 0x04}, false, "GenericTrack_TrackNumber" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 116
       0x01, 0x07, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00 },
     {0x48, 0x02}, true, "GenericTrack_TrackName" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 117
       0x06, 0x01, 0x01, 0x04, 0x02, 0x04, 0x00, 0x00 },
     {0x48, 0x03}, false, "GenericTrack_Sequence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 118
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3a, 0x00 },
     {0, 0}, false, "StaticTrack" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 119
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3b, 0x00 },
     {0, 0}, false, "Track" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 120
       0x05, 0x30, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00 },
     {0x4b, 0x01}, false, "Track_EditRate" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 121
       0x07, 0x02, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00 },
     {0x4b, 0x02}, false, "Track_Origin" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 122
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x00 },
     {0, 0}, false, "EventTrack" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 123
       0x05, 0x30, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0x49, 0x01}, false, "EventTrack_EventEditRate" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 124
       0x07, 0x02, 0x01, 0x03, 0x01, 0x0b, 0x00, 0x00 },
     {0x49, 0x02}, true, "EventTrack_EventOrigin" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 125
       0x04, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0x02, 0x01}, false, "StructuralComponent_DataDefinition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 126
       0x07, 0x02, 0x02, 0x01, 0x01, 0x03, 0x00, 0x00 },
     {0x02, 0x02}, false, "StructuralComponent_Duration" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 127
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x00 },
     {0, 0}, false, "Sequence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 128
       0x06, 0x01, 0x01, 0x04, 0x06, 0x09, 0x00, 0x00 },
     {0x10, 0x01}, false, "Sequence_StructuralComponents" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 129
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x00 },
     {0, 0}, false, "TimecodeComponent" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 130
       0x04, 0x04, 0x01, 0x01, 0x02, 0x06, 0x00, 0x00 },
     {0x15, 0x02}, false, "TimecodeComponent_RoundedTimecodeBase" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 131
       0x07, 0x02, 0x01, 0x03, 0x01, 0x05, 0x00, 0x00 },
     {0x15, 0x01}, false, "TimecodeComponent_StartTimecode" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 132
       0x04, 0x04, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00 },
     {0x15, 0x03}, false, "TimecodeComponent_DropFrame" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 133
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x00 },
     {0, 0}, false, "SourceClip" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 134
       0x07, 0x02, 0x01, 0x03, 0x01, 0x04, 0x00, 0x00 },
     {0x12, 0x01}, false, "SourceClip_StartPosition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 135
       0x06, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00 },
     {0x11, 0x01}, false, "SourceClip_SourcePackageID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 136
       0x06, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00 },
     {0x11, 0x02}, false, "SourceClip_SourceTrackID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 137
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x00 },
     {0, 0}, false, "DMSegment" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 138
       0x07, 0x02, 0x01, 0x03, 0x03, 0x03, 0x00, 0x00 },
     {0x06, 0x01}, false, "DMSegment_EventStartPosition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 139
       0x05, 0x30, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00 },
     {0x06, 0x02}, true, "DMSegment_EventComment" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 140
       0x01, 0x07, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00 },
     {0x61, 0x02}, false, "DMSegment_TrackIDs" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 141
       0x06, 0x01, 0x01, 0x04, 0x02, 0x0c, 0x00, 0x00 },
     {0x61, 0x01}, false, "DMSegment_DMFramework" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 142
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x45, 0x00 },
     {0, 0}, false, "DMSourceClip" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 143
       0x01, 0x07, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00 },
     {0x61, 0x03}, true, "DMSourceClip_DMSourceClipTrackIDs" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 144
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x36, 0x00 },
     {0, 0}, false, "MaterialPackage" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 145
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x37, 0x00 },
     {0, 0}, false, "SourcePackage" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 146
       0x06, 0x01, 0x01, 0x04, 0x02, 0x03, 0x00, 0x00 },
     {0x47, 0x01}, false, "SourcePackage_Descriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 147
       0x06, 0x01, 0x01, 0x04, 0x06, 0x03, 0x00, 0x00 },
     {0x2f, 0x01}, true, "GenericDescriptor_Locators" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x09, // 148
       0x06, 0x01, 0x01, 0x04, 0x06, 0x10, 0x00, 0x00 },
     {0, 0}, true, "GenericDescriptor_SubDescriptors" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 149
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x00 },
     {0, 0}, false, "FileDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 150
       0x06, 0x01, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00 },
     {0x30, 0x06}, true, "FileDescriptor_LinkedTrackID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 151
       0x04, 0x06, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0x30, 0x01}, false, "FileDescriptor_SampleRate" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 152
       0x04, 0x06, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0x30, 0x02}, true, "FileDescriptor_ContainerDuration" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 153
       0x06, 0x01, 0x01, 0x04, 0x01, 0x02, 0x00, 0x00 },
     {0x30, 0x04}, false, "FileDescriptor_EssenceContainer" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 154
       0x06, 0x01, 0x01, 0x04, 0x01, 0x03, 0x00, 0x00 },
     {0x30, 0x05}, true, "FileDescriptor_Codec" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 155
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00 },
     {0, 0}, false, "GenericPictureEssenceDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 156
       0x04, 0x05, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00 },
     {0x32, 0x15}, true, "GenericPictureEssenceDescriptor_SignalStandard" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 157
       0x04, 0x01, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00 },
     {0x32, 0x0c}, false, "GenericPictureEssenceDescriptor_FrameLayout" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 158
       0x04, 0x01, 0x05, 0x02, 0x02, 0x00, 0x00, 0x00 },
     {0x32, 0x03}, false, "GenericPictureEssenceDescriptor_StoredWidth" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 159
       0x04, 0x01, 0x05, 0x02, 0x01, 0x00, 0x00, 0x00 },
     {0x32, 0x02}, false, "GenericPictureEssenceDescriptor_StoredHeight" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 160
       0x04, 0x01, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00 },
     {0x32, 0x16}, true, "GenericPictureEssenceDescriptor_StoredF2Offset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 161
       0x04, 0x01, 0x05, 0x01, 0x08, 0x00, 0x00, 0x00 },
     {0x32, 0x05}, true, "GenericPictureEssenceDescriptor_SampledWidth" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 162
       0x04, 0x01, 0x05, 0x01, 0x07, 0x00, 0x00, 0x00 },
     {0x32, 0x04}, true, "GenericPictureEssenceDescriptor_SampledHeight" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 163
       0x04, 0x01, 0x05, 0x01, 0x09, 0x00, 0x00, 0x00 },
     {0x32, 0x06}, true, "GenericPictureEssenceDescriptor_SampledXOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 164
       0x04, 0x01, 0x05, 0x01, 0x0a, 0x00, 0x00, 0x00 },
     {0x32, 0x07}, true, "GenericPictureEssenceDescriptor_SampledYOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 165
       0x04, 0x01, 0x05, 0x01, 0x0b, 0x00, 0x00, 0x00 },
     {0x32, 0x08}, true, "GenericPictureEssenceDescriptor_DisplayHeight" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 166
       0x04, 0x01, 0x05, 0x01, 0x0c, 0x00, 0x00, 0x00 },
     {0x32, 0x09}, true, "GenericPictureEssenceDescriptor_DisplayWidth" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 167
       0x04, 0x01, 0x05, 0x01, 0x0d, 0x00, 0x00, 0x00 },
     {0x32, 0x0a}, true, "GenericPictureEssenceDescriptor_DisplayXOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 168
       0x04, 0x01, 0x05, 0x01, 0x0e, 0x00, 0x00, 0x00 },
     {0x32, 0x0b}, true, "GenericPictureEssenceDescriptor_DisplayYOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 169
       0x04, 0x01, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00 },
     {0x32, 0x17}, true, "GenericPictureEssenceDescriptor_DisplayF2Offset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 170
       0x04, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },
     {0x32, 0x0e}, false, "GenericPictureEssenceDescriptor_AspectRatio" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 171
       0x04, 0x01, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00 },
     {0x32, 0x18}, true, "GenericPictureEssenceDescriptor_ActiveFormatDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 172
       0x04, 0x01, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00 },
     {0x32, 0x0d}, false, "GenericPictureEssenceDescriptor_VideoLineMap" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 173
       0x05, 0x20, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0x32, 0x0f}, true, "GenericPictureEssenceDescriptor_AlphaTransparency" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 174
       0x04, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x00 },
     {0x32, 0x10}, true, "GenericPictureEssenceDescriptor_TransferCharacteristic" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 175
       0x04, 0x18, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0x32, 0x11}, true, "GenericPictureEssenceDescriptor_ImageAlignmentOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 176
       0x04, 0x18, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0x32, 0x13}, true, "GenericPictureEssenceDescriptor_ImageStartOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 177
       0x04, 0x18, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00 },
     {0x32, 0x14}, true, "GenericPictureEssenceDescriptor_ImageEndOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 178
       0x04, 0x01, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00 },
     {0x32, 0x12}, true, "GenericPictureEssenceDescriptor_FieldDominance" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 179
       0x04, 0x01, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0x32, 0x01}, false, "GenericPictureEssenceDescriptor_PictureEssenceCoding" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 180
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00 },
     {0, 0}, false, "CDCIEssenceDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 181
       0x04, 0x01, 0x05, 0x03, 0x0a, 0x00, 0x00, 0x00 },
     {0x33, 0x01}, false, "CDCIEssenceDescriptor_ComponentDepth" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 182
       0x04, 0x01, 0x05, 0x01, 0x05, 0x00, 0x00, 0x00 },
     {0x33, 0x02}, false, "CDCIEssenceDescriptor_HorizontalSubsampling" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 183
       0x04, 0x01, 0x05, 0x01, 0x10, 0x00, 0x00, 0x00 },
     {0x33, 0x08}, true, "CDCIEssenceDescriptor_VerticalSubsampling" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 184
       0x04, 0x01, 0x05, 0x01, 0x06, 0x00, 0x00, 0x00 },
     {0x33, 0x03}, true, "CDCIEssenceDescriptor_ColorSiting" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 185
       0x03, 0x01, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00 },
     {0x33, 0x0b}, true, "CDCIEssenceDescriptor_ReversedByteOrder" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 186
       0x04, 0x18, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00 },
     {0x33, 0x07}, true, "CDCIEssenceDescriptor_PaddingBits" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 187
       0x04, 0x01, 0x05, 0x03, 0x07, 0x00, 0x00, 0x00 },
     {0x33, 0x09}, true, "CDCIEssenceDescriptor_AlphaSampleDepth" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 188
       0x04, 0x01, 0x05, 0x03, 0x03, 0x00, 0x00, 0x00 },
     {0x33, 0x04}, true, "CDCIEssenceDescriptor_BlackRefLevel" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 189
       0x04, 0x01, 0x05, 0x03, 0x04, 0x00, 0x00, 0x00 },
     {0x33, 0x05}, true, "CDCIEssenceDescriptor_WhiteReflevel" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 190
       0x04, 0x01, 0x05, 0x03, 0x05, 0x00, 0x00, 0x00 },
     {0x33, 0x06}, true, "CDCIEssenceDescriptor_ColorRange" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 191
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x29, 0x00 },
     {0, 0}, false, "RGBAEssenceDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 192
       0x04, 0x01, 0x05, 0x03, 0x0b, 0x00, 0x00, 0x00 },
     {0x34, 0x06}, true, "RGBAEssenceDescriptor_ComponentMaxRef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 193
       0x04, 0x01, 0x05, 0x03, 0x0c, 0x00, 0x00, 0x00 },
     {0x34, 0x07}, true, "RGBAEssenceDescriptor_ComponentMinRef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 194
       0x04, 0x01, 0x05, 0x03, 0x0d, 0x00, 0x00, 0x00 },
     {0x34, 0x08}, true, "RGBAEssenceDescriptor_AlphaMaxRef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 195
       0x04, 0x01, 0x05, 0x03, 0x0e, 0x00, 0x00, 0x00 },
     {0x34, 0x09}, true, "RGBAEssenceDescriptor_AlphaMinRef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 196
       0x04, 0x01, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00 },
     {0x34, 0x05}, true, "RGBAEssenceDescriptor_ScanningDirection" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 197
       0x04, 0x01, 0x05, 0x03, 0x06, 0x00, 0x00, 0x00 },
     {0x34, 0x01}, false, "RGBAEssenceDescriptor_PixelLayout" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 198
       0x04, 0x01, 0x05, 0x03, 0x08, 0x00, 0x00, 0x00 },
     {0x34, 0x03}, true, "RGBAEssenceDescriptor_Palette" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 199
       0x04, 0x01, 0x05, 0x03, 0x09, 0x00, 0x00, 0x00 },
     {0x34, 0x04}, true, "RGBAEssenceDescriptor_PaletteLayout" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 200
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00 },
     {0, 0}, false, "GenericSoundEssenceDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 201
       0x04, 0x02, 0x03, 0x01, 0x01, 0x01, 0x00, 0x00 },
     {0x3d, 0x03}, false, "GenericSoundEssenceDescriptor_AudioSamplingRate" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 202
       0x04, 0x02, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00 },
     {0x3d, 0x02}, true, "GenericSoundEssenceDescriptor_Locked" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 203
       0x04, 0x02, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00 },
     {0x3d, 0x04}, true, "GenericSoundEssenceDescriptor_AudioRefLevel" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, // 204
       0x04, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },
     {0x3d, 0x05}, true, "GenericSoundEssenceDescriptor_ElectroSpatialFormulation" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 205
       0x04, 0x02, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00 },
     {0x3d, 0x07}, false, "GenericSoundEssenceDescriptor_ChannelCount" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 206
       0x04, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00 },
     {0x3d, 0x01}, false, "GenericSoundEssenceDescriptor_QuantizationBits" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 207
       0x04, 0x02, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0x3d, 0x0c}, true, "GenericSoundEssenceDescriptor_DialNorm" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 208
       0x04, 0x02, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0x3d, 0x06}, true, "GenericSoundEssenceDescriptor_SoundEssenceCoding" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 209
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x00 },
     {0, 0}, false, "GenericDataEssenceDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x03, // 210
       0x04, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0x3e, 0x01}, false, "GenericDataEssenceDescriptor_DataEssenceCoding" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 211
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x44, 0x00 },
     {0, 0}, false, "MultipleDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 212
       0x06, 0x01, 0x01, 0x04, 0x06, 0x0b, 0x00, 0x00 },
     {0x3f, 0x01}, false, "MultipleDescriptor_SubDescriptorUIDs" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 213
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x51, 0x00 },
     {0, 0}, false, "MPEG2VideoDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 214
       0x04, 0x01, 0x06, 0x02, 0x01, 0x02, 0x00, 0x00 },
     {0, 0}, true, "MPEG2VideoDescriptor_SingleSequence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 215
       0x04, 0x01, 0x06, 0x02, 0x01, 0x03, 0x00, 0x00 },
     {0, 0}, true, "MPEG2VideoDescriptor_ConstantBFrames" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 216
       0x04, 0x01, 0x06, 0x02, 0x01, 0x04, 0x00, 0x00 },
     {0, 0}, true, "MPEG2VideoDescriptor_CodedContentType" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 217
       0x04, 0x01, 0x06, 0x02, 0x01, 0x05, 0x00, 0x00 },
     {0, 0}, true, "MPEG2VideoDescriptor_LowDelay" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 218
       0x04, 0x01, 0x06, 0x02, 0x01, 0x06, 0x00, 0x00 },
     {0, 0}, true, "MPEG2VideoDescriptor_ClosedGOP" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 219
       0x04, 0x01, 0x06, 0x02, 0x01, 0x07, 0x00, 0x00 },
     {0, 0}, true, "MPEG2VideoDescriptor_IdenticalGOP" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 220
       0x04, 0x01, 0x06, 0x02, 0x01, 0x08, 0x00, 0x00 },
     {0, 0}, true, "MPEG2VideoDescriptor_MaxGOP" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 221
       0x04, 0x01, 0x06, 0x02, 0x01, 0x09, 0x00, 0x00 },
     {0, 0}, true, "MPEG2VideoDescriptor_BPictureCount" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 222
       0x04, 0x01, 0x06, 0x02, 0x01, 0x0b, 0x00, 0x00 },
     {0, 0}, true, "MPEG2VideoDescriptor_BitRate" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 223
       0x04, 0x01, 0x06, 0x02, 0x01, 0x0a, 0x00, 0x00 },
     {0, 0}, true, "MPEG2VideoDescriptor_ProfileAndLevel" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 224
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x48, 0x00 },
     {0, 0}, false, "WaveAudioDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 225
       0x04, 0x02, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00 },
     {0x3d, 0x0a}, false, "WaveAudioDescriptor_BlockAlign" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 226
       0x04, 0x02, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00 },
     {0x3d, 0x0b}, true, "WaveAudioDescriptor_SequenceOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 227
       0x04, 0x02, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00 },
     {0x3d, 0x09}, false, "WaveAudioDescriptor_AvgBps" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, // 228
       0x04, 0x02, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00 },
     {0x3d, 0x0e}, true, "WaveAudioDescriptor_PeakEnvelopeData" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 229
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5a, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 230
       0x04, 0x01, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_Rsize" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 231
       0x04, 0x01, 0x06, 0x03, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_Xsize" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 232
       0x04, 0x01, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_Ysize" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 233
       0x04, 0x01, 0x06, 0x03, 0x04, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_XOsize" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 234
       0x04, 0x01, 0x06, 0x03, 0x05, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_YOsize" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 235
       0x04, 0x01, 0x06, 0x03, 0x06, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_XTsize" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 236
       0x04, 0x01, 0x06, 0x03, 0x07, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_YTsize" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 237
       0x04, 0x01, 0x06, 0x03, 0x08, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_XTOsize" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 238
       0x04, 0x01, 0x06, 0x03, 0x09, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_YTOsize" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 239
       0x04, 0x01, 0x06, 0x03, 0x0a, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_Csize" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 240
       0x04, 0x01, 0x06, 0x03, 0x0b, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_PictureComponentSizing" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 241
       0x04, 0x01, 0x06, 0x03, 0x0c, 0x00, 0x00, 0x00 },
     {0, 0}, true, "JPEG2000PictureSubDescriptor_CodingStyleDefault" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a, // 242
       0x04, 0x01, 0x06, 0x03, 0x0d, 0x00, 0x00, 0x00 },
     {0, 0}, true, "JPEG2000PictureSubDescriptor_QuantizationDefault" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 243
       0x0d, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DescriptiveFramework" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 244
       0x0d, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DM_Set" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x07, // 245
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x0b, 0x01, 0x00 },
     {0, 0}, false, "EncryptedContainerLabel" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x07, // 246
       0x0d, 0x01, 0x04, 0x01, 0x02, 0x01, 0x01, 0x00 },
     {0, 0}, false, "CryptographicFrameworkLabel" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 247
       0x0d, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x00 },
     {0, 0}, false, "CryptographicFramework" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x09, // 248
       0x06, 0x01, 0x01, 0x04, 0x02, 0x0d, 0x00, 0x00 },
     {0, 0}, false, "CryptographicFramework_ContextSR" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 249
       0x0d, 0x01, 0x04, 0x01, 0x02, 0x02, 0x00, 0x00 },
     {0, 0}, false, "CryptographicContext" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x09, // 250
       0x01, 0x01, 0x15, 0x11, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "CryptographicContext_ContextID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x09, // 251
       0x06, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "CryptographicContext_SourceEssenceContainer" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x09, // 252
       0x02, 0x09, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "CryptographicContext_CipherAlgorithm" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x09, // 253
       0x02, 0x09, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "CryptographicContext_MICAlgorithm" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x09, // 254
       0x02, 0x09, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "CryptographicContext_CryptographicKeyID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0a, // 255
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x13, 0x01, 0x01 },
     {0, 0}, false, "TimedTextWrappingClip" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x01, // 256
       0x0d, 0x01, 0x03, 0x01, 0x17, 0x01, 0x0b, 0x01 },
     {0, 0}, false, "TimedTextEssence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 257
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x64, 0x00 },
     {0, 0}, false, "TimedTextDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c, // 258
       0x01, 0x01, 0x15, 0x12, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TimedTextDescriptor_ResourceID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c, // 259
       0x04, 0x09, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TimedTextDescriptor_UCSEncoding" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, // 260
       0x01, 0x02, 0x01, 0x05, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TimedTextDescriptor_NamespaceURI" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 261
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x65, 0x00 },
     {0, 0}, false, "TimedTextResourceSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c, // 262
       0x01, 0x01, 0x15, 0x13, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TimedTextResourceSubDescriptor_AncillaryResourceID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, // 263
       0x04, 0x09, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TimedTextResourceSubDescriptor_MIMEMediaType" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 264
       0x01, 0x03, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TimedTextResourceSubDescriptor_EssenceStreamID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01, // 265
       0x0d, 0x01, 0x02, 0x01, 0x01, 0x03, 0x11, 0x00 },
     {0, 0}, false, "GenericStreamPartition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 266
       0x04, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0x02, 0x01}, false, "DMSegment_DataDefinition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 267
       0x07, 0x02, 0x02, 0x01, 0x01, 0x03, 0x00, 0x00 },
     {0x02, 0x02}, true, "DMSegment_Duration" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 268
       0x01, 0x07, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00 },
     {0x61, 0x02}, false, "DMSegment_TrackIDList" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 269
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x63, 0x00 },
     {0, 0}, false, "StereoscopicPictureSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, // 270
       0x04, 0x02, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00 },
     {0x3d, 0x32}, true, "WaveAudioDescriptor_ChannelAssignment" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c, // 271
       0x0d, 0x01, 0x05, 0x09, 0x01, 0x00, 0x00, 0x00 },
     {0x00, 0x00}, false, "GenericStream_DataElement" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 272
       0x06, 0x01, 0x01, 0x04, 0x06, 0x10, 0x00, 0x00 },
     {0, 0}, true, "MXFInterop_GenericDescriptor_SubDescriptors" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 273
       0x01, 0x03, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },
     {0x3f, 0x07}, false, "BodySID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, // 274
       0x01, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00 },
     {0x3f, 0x06}, false, "IndexSID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 275
       0x01, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00 },
     {0x3b, 0x09}, false, "OperationalPattern" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 276
       0x01, 0x02, 0x02, 0x10, 0x02, 0x01, 0x00, 0x00 },
     {0x3b, 0x0a}, false, "EssenceContainers" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0b, // 277
       0x04, 0x02, 0x02, 0x10, 0x03, 0x01, 0x01, 0x00 },
     {0, 0}, false, "DCAudioChannelCfg_1_5p1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0b, // 278
       0x04, 0x02, 0x02, 0x10, 0x03, 0x01, 0x02, 0x00 },
     {0, 0}, false, "DCAudioChannelCfg_2_6p1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0b, // 279
       0x04, 0x02, 0x02, 0x10, 0x03, 0x01, 0x03, 0x00 },
     {0, 0}, false, "DCAudioChannelCfg_3_7p1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0b, // 280
       0x04, 0x02, 0x02, 0x10, 0x03, 0x01, 0x04, 0x00 },
     {0, 0}, false, "DCAudioChannelCfg_4_WTF" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0b, // 281
       0x04, 0x02, 0x02, 0x10, 0x03, 0x01, 0x05, 0x00 },
     {0, 0}, false, "DCAudioChannelCfg_5_7p1_DS" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 282
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6a, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 283
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6b, 0x00 },
     {0, 0}, false, "AudioChannelLabelSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 284
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6c, 0x00 },
     {0, 0}, false, "SoundfieldGroupLabelSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 285
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6d, 0x00 },
     {0, 0}, false, "GroupOfSoundfieldGroupsLabelSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 286
       0x01, 0x03, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCALabelDictionaryID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 287
       0x01, 0x03, 0x07, 0x01, 0x05, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCALinkID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 288
       0x01, 0x03, 0x07, 0x01, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCATagSymbol" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 289
       0x01, 0x03, 0x07, 0x01, 0x03, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCATagName" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 290
       0x01, 0x03, 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCAChannelID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0d, // 291
       0x03, 0x01, 0x01, 0x02, 0x03, 0x15, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_RFC5646SpokenLanguage" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 292
       0x01, 0x03, 0x07, 0x01, 0x06, 0x00, 0x00, 0x00 },
     {0, 0}, false, "AudioChannelLabelSubDescriptor_SoundfieldGroupLinkID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 293
       0x01, 0x03, 0x07, 0x01, 0x04, 0x00, 0x00, 0x00 },
     {0, 0}, false, "SoundfieldGroupLabelSubDescriptor_GroupOfSoundfieldGroupsLinkID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 294
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x13, 0x02, 0x01 },
     {0, 0}, false, "DCDataWrappingFrame" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x0d, // 295
       0x0d, 0x01, 0x03, 0x01, 0x17, 0x01, 0x0d, 0x00 },
     {0, 0}, false, "DCDataEssence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 296
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x73, 0x00 },
     {0, 0}, false, "DCDataDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x05, // 297
       0x0e, 0x09, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DolbyAtmosSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 298
       0x0e, 0x09, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, true, "DolbyAtmosSubDescriptor_AtmosVersion" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 299
       0x0e, 0x09, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, true, "DolbyAtmosSubDescriptor_MaxChannelCount" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 300
       0x0e, 0x09, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, true, "DolbyAtmosSubDescriptor_MaxObjectCount" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 301
       0x0e, 0x09, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, true, "DolbyAtmosSubDescriptor_AtmosID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 302
       0x0e, 0x09, 0x05, 0x0A, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, true, "DolbyAtmosSubDescriptor_FirstFrame" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 303
       0x01, 0x03, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DataDataDef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 304
       0x04, 0x02, 0x02, 0x10, 0x03, 0x02, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannelCfg_MCA" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 305
       0x03, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_L" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 306
       0x03, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_R" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 307
       0x03, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_C" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 308
       0x03, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_LFE" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 309
       0x03, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Ls" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 310
       0x03, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Rs" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 311
       0x03, 0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Lss" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 312
       0x03, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Rss" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 313
       0x03, 0x02, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Lrs" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 314
       0x03, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Rrs" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 315
       0x03, 0x02, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Lc" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 316
       0x03, 0x02, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Rc" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 317
       0x03, 0x02, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Cs" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 318
       0x03, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_HI" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 319
       0x03, 0x02, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_VIN" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 320
       0x03, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioSoundfield_51" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 321
       0x03, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioSoundfield_71" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 322
       0x03, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioSoundfield_SDS" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 323
       0x03, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioSoundfield_61" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 324
       0x03, 0x02, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioSoundfield_M" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x01, // 325
       0x0d, 0x01, 0x03, 0x01, 0x16, 0x01, 0x02, 0x00 },
     {0, 0}, false, "WAVEssenceClip" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 326
       0x04, 0x02, 0x02, 0x10, 0x04, 0x01, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioChannelCfg_MCA" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 327
       0x03, 0x02, 0x01, 0x20, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioChannel_M1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 328
       0x03, 0x02, 0x01, 0x20, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioChannel_M2" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 329
       0x03, 0x02, 0x01, 0x20, 0x03, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioChannel_Lt" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 330
       0x03, 0x02, 0x01, 0x20, 0x04, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioChannel_Rt" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 331
       0x03, 0x02, 0x01, 0x20, 0x05, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioChannel_Lst" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 332
       0x03, 0x02, 0x01, 0x20, 0x06, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioChannel_Rst" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 333
       0x03, 0x02, 0x01, 0x20, 0x07, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioChannel_S" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 334
       0x03, 0x02, 0x01, 0x20, 0x08, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFNumberedSourceChannel" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 335
       0x03, 0x02, 0x02, 0x20, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_ST" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 336
       0x03, 0x02, 0x02, 0x20, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_DM" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 337
       0x03, 0x02, 0x02, 0x20, 0x03, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_DNS" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 338
       0x03, 0x02, 0x02, 0x20, 0x04, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_30" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 339
       0x03, 0x02, 0x02, 0x20, 0x05, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_40" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 340
       0x03, 0x02, 0x02, 0x20, 0x06, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_50" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 341
       0x03, 0x02, 0x02, 0x20, 0x07, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_60" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 342
       0x03, 0x02, 0x02, 0x20, 0x08, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_70" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 343
       0x03, 0x02, 0x02, 0x20, 0x09, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_LtRt" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 344
       0x03, 0x02, 0x02, 0x20, 0x0a, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_51EX" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 345
       0x03, 0x02, 0x02, 0x20, 0x0b, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_HI" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 346
       0x03, 0x02, 0x02, 0x20, 0x0c, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioSoundfield_VIN" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 347
       0x03, 0x02, 0x03, 0x20, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioGroup_MPg" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 348
       0x03, 0x02, 0x03, 0x20, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioGroup_DVS" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 349
       0x03, 0x02, 0x03, 0x20, 0x03, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMFAudioGroup_Dcm" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c, // 350
       0x06, 0x01, 0x01, 0x04, 0x02, 0x0f, 0x00, 0x00 },
     {0, 0}, false, "MaterialPackage_PackageMarker" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, // 351
       0x04, 0x01, 0x02, 0x01, 0x01, 0x03, 0x01, 0x00 },
     {0x32, 0x1a}, false, "GenericPictureEssenceDescriptor_CodingEquations" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x09, // 352
       0x04, 0x01, 0x02, 0x01, 0x01, 0x06, 0x01, 0x00 },
     {0x32, 0x19}, false, "GenericPictureEssenceDescriptor_ColorPrimaries" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 353
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x01, 0x11 },
     {0, 0}, false, "JP2KEssenceCompression_BroadcastProfile_1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 354
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x01, 0x12 },
     {0, 0}, false, "JP2KEssenceCompression_BroadcastProfile_2" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 355
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x01, 0x13 },
     {0, 0}, false, "JP2KEssenceCompression_BroadcastProfile_3" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 356
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x01, 0x14 },
     {0, 0}, false, "JP2KEssenceCompression_BroadcastProfile_4" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 357
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x01, 0x15 },
     {0, 0}, false, "JP2KEssenceCompression_BroadcastProfile_5" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 358
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x01, 0x16 },
     {0, 0}, false, "JP2KEssenceCompression_BroadcastProfile_6" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 359
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x01, 0x17 },
     {0, 0}, false, "JP2KEssenceCompression_BroadcastProfile_7" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 360
       0x04, 0x02, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00 },
     {0, 0}, false, "GenericSoundEssenceDescriptor_ReferenceImageEditRate" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 361
       0x04, 0x02, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00 },
     {0, 0}, false, "GenericSoundEssenceDescriptor_ReferenceAudioAlignmentLevel" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 362
       0x04, 0x01, 0x03, 0x02, 0x0b, 0x00, 0x00, 0x00 },
     {0, 0}, false, "GenericPictureEssenceDescriptor_AlternativeCenterCuts" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 363
       0x04, 0x01, 0x05, 0x01, 0x13, 0x00, 0x00, 0x00 },
     {0, 0}, true, "GenericPictureEssenceDescriptor_ActiveHeight" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 364
       0x04, 0x01, 0x05, 0x01, 0x14, 0x00, 0x00, 0x00 },
     {0, 0}, true, "GenericPictureEssenceDescriptor_ActiveWidth" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 365
       0x04, 0x01, 0x05, 0x01, 0x15, 0x00, 0x00, 0x00 },
     {0, 0}, true, "GenericPictureEssenceDescriptor_ActiveXOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 366
       0x04, 0x01, 0x05, 0x01, 0x16, 0x00, 0x00, 0x00 },
     {0, 0}, true, "GenericPictureEssenceDescriptor_ActiveYOffset" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 367
       0x03, 0x01, 0x01, 0x02, 0x02, 0x16, 0x00, 0x00 },
     {0, 0}, false, "TimedTextDescriptor_RFC5646LanguageTagList" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 368
       0x04, 0x01, 0x01, 0x01, 0x00, 0x04, 0x01, 0x00 },
     {0, 0}, false, "AlternativeCenterCuts_4x3" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 369
       0x04, 0x01, 0x01, 0x01, 0x00, 0x04, 0x02, 0x00 },
     {0, 0}, false, "AlternativeCenterCuts_14x9" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 370
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x06, 0x02, 0x00 },
     {0, 0}, false, "WAVWrappingClip" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 371
       0x0e, 0x16, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01 },
     {0, 0}, false, "DBOXMotionCodePrimaryStream" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 372
       0x0e, 0x16, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02 },
     {0, 0}, false, "DBOXMotionCodeSecondaryStream" },

   //  379-2, Sec. 7: Encoders that conform to this specification shall add a
   // ContainerConstraintsSubDescriptor to the GenericDescriptor::SubDescriptors
   // property of the top-most File Descriptor that describes the essence
   // container.
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 373
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x67, 0x00 },
     {0, 0}, false, "ContainerConstraintsSubDescriptor" },

   // protype for high dynamic range, values recorded in Dolby registry
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x05, // 374
       0x0e, 0x09, 0x06, 0x07, 0x01, 0x01, 0x01, 0x01 },
     {0, 0}, false, "PHDRImageMetadataWrappingFrame" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x05, // 375
       0x0e, 0x09, 0x06, 0x07, 0x01, 0x01, 0x01, 0x00 },
     {0, 0}, false, "PHDRImageMetadataItem" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x05, // 376
       0x0e, 0x09, 0x06, 0x07, 0x01, 0x01, 0x01, 0x03 },
     {0, 0}, false, "PHDRMetadataTrackSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 377
       0x0e, 0x09, 0x06, 0x07, 0x01, 0x01, 0x01, 0x04 },
     {0, 0}, false, "PHDRMetadataTrackSubDescriptor_DataDefinition" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 378
       0x0e, 0x09, 0x06, 0x07, 0x01, 0x01, 0x01, 0x05 },
     {0, 0}, false, "PHDRMetadataTrackSubDescriptor_SourceTrackID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 379
       0x0e, 0x09, 0x06, 0x07, 0x01, 0x01, 0x01, 0x06 },
     {0, 0}, false, "PHDRMetadataTrackSubDescriptor_SimplePayloadSID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 380
       0x04, 0x01, 0x06, 0x03, 0x0e, 0x00, 0x00, 0x00 },
     {0, 0}, true, "JPEG2000PictureSubDescriptor_J2CLayout" },

   // Old DCData UL values, needed for continued support of Atmos
   //
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x05, // 381
       0x0e, 0x09, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PrivateDCDataWrappingFrame" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x05, // 382
       0x0e, 0x09, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PrivateDCDataEssence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x05, // 383
       0x0e, 0x09, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "PrivateDCDataDescriptor" },

   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 384
       0x01, 0x05, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCATitle" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 385
       0x01, 0x05, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCATitleVersion" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 386
       0x01, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCATitleSubVersion" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 387
       0x01, 0x05, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCAEpisode" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 388
       0x01, 0x04, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCAPartitionKind" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 389
       0x01, 0x04, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCAPartitionNumber" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 390
       0x03, 0x02, 0x01, 0x02, 0x20, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCAAudioContentKind" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 391
       0x03, 0x02, 0x01, 0x02, 0x21, 0x00, 0x00, 0x00 },
     {0, 0}, false, "MCALabelSubDescriptor_MCAAudioElementKind" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 392
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x0c, 0x03, 0x00 },
     {0, 0}, false, "MXFGCI1FrameWrappedPictureElement" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 393
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x0c, 0x06, 0x00 },
     {0, 0}, false, "MXFGCP1FrameWrappedPictureElement" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 394
       0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00 },
     {0, 0}, false, "TransferCharacteristic_ITU709" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0e, // 395
       0x04, 0x01, 0x01, 0x01, 0x01, 0x09, 0x00, 0x00 },
     {0, 0}, false, "TransferCharacteristic_ITU2020" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 396
       0x04, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00 },
     {0, 0}, false, "TransferCharacteristic_IEC6196624_xvYCC" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 397
       0x04, 0x01, 0x01, 0x01, 0x01, 0x0a, 0x00, 0x00 },
     {0, 0}, false, "TransferCharacteristic_SMPTEST2084" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x06, // 398
       0x04, 0x01, 0x01, 0x01, 0x01, 0x06, 0x00, 0x00 },
     {0, 0}, false, "TransferCharacteristic_linear" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 399
       0x04, 0x01, 0x01, 0x01, 0x02, 0x01, 0x00, 0x00 },
     {0, 0}, false, "CodingEquations_601" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, // 400
       0x04, 0x01, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00 },
     {0, 0}, false, "CodingEquations_709" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 401
       0x04, 0x01, 0x01, 0x01, 0x02, 0x06, 0x00, 0x00 },
     {0, 0}, false, "CodingEquations_Rec2020" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x06, // 402
       0x04, 0x01, 0x01, 0x01, 0x03, 0x03, 0x00, 0x00 },
     {0, 0}, false, "ColorPrimaries_ITU709" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0D, // 403
       0x04, 0x01, 0x01, 0x01, 0x03, 0x04, 0x00, 0x00 },
     {0, 0}, false, "ColorPrimaries_ITU2020" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 404
       0x04, 0x01, 0x01, 0x01, 0x03, 0x06, 0x00, 0x00 },
     {0, 0}, false, "ColorPrimaries_P3D65" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 405
       0x04, 0x01, 0x01, 0x01, 0x03, 0x07, 0x00, 0x00 },
     {0, 0}, false, "ColorPrimaries_ACES" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 406
       0x04, 0x20, 0x04, 0x01, 0x01, 0x01, 0x00, 0x00 },
     {0, 0}, false, "GenericPictureEssenceDescriptor_MasteringDisplayPrimaries" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 407
       0x04, 0x20, 0x04, 0x01, 0x01, 0x02, 0x00, 0x00 },
     {0, 0}, false, "GenericPictureEssenceDescriptor_MasteringDisplayWhitePointChromaticity" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 408
       0x04, 0x20, 0x04, 0x01, 0x01, 0x03, 0x00, 0x00 },
     {0, 0}, false, "GenericPictureEssenceDescriptor_MasteringDisplayMaximumLuminance" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 409
       0x04, 0x20, 0x04, 0x01, 0x01, 0x04, 0x00, 0x00 },
     {0, 0}, false, "GenericPictureEssenceDescriptor_MasteringDisplayMinimumLuminance" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 410
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x00 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 411
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x00 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 412
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x04, 0x00 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Lossy" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 413
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x05, 0x00 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Reversible" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 414
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x06, 0x00 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Reversible" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 415
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x07, 0x00 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Reversible" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 416
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x03 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_1_1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 417
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x05 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_2_1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 418
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x07 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_3_1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 419
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x09 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_4_1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 420
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x0a },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_4_2" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 421
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x0c },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_5_1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 422
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x0d },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_5_2" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 423
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x0e },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_5_3" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 424
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x10 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_6_1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 425
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x11 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_6_2" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 426
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x12 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_6_3" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 427
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x13 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_6_4" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 428
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x15 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_7_1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 429
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x16 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_7_2" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 430
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x17 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_7_3" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 431
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x18 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_7_4" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 432
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x19 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_7_5" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 433
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x1b },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_8_1" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 434
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x1c },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_8_2" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 435
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x1d },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_8_3" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 436
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x1e },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_8_4" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 437
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x1f },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_8_5" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 438
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x03, 0x20 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Lossy_8_6" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 439
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x05, 0x02 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Reversible_1_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 440
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x05, 0x04 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Reversible_2_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 441
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x05, 0x06 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Reversible_3_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 442
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x05, 0x08 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Reversible_4_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 443
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x05, 0x0b },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Reversible_5_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 444
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x05, 0x0f },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Reversible_6_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 445
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x06, 0x02 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Reversible_1_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 446
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x06, 0x04 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Reversible_2_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 447
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x06, 0x06 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Reversible_3_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 448
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x06, 0x08 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Reversible_4_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 449
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x06, 0x0b },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Reversible_5_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 450
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x06, 0x0f },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Reversible_6_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 451
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x06, 0x14 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Reversible_7_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 452
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x06, 0x1a },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_4K_Reversible_8_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 453
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x07, 0x02 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Reversible_1_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 454
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x07, 0x04 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Reversible_2_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 455
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x07, 0x06 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Reversible_3_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 456
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x07, 0x08 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Reversible_4_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 457
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x07, 0x0b },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Reversible_5_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 458
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x07, 0x0f },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Reversible_6_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 459
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x07, 0x14 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Reversible_7_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 460
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x07, 0x1a },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Reversible_8_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 461
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x07, 0x21 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Reversible_9_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  // 462
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x07, 0x29 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_8K_Reversible_10_0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0a,  // 463
       0x04, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "SMPTE382MDefaultUncompressedSoundCoding" },

   // protype for generic aux data (IMF)
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x05, // 464
       0x0e, 0x09, 0x06, 0x07, 0x01, 0x01, 0x10, 0x00 },
     {0, 0}, false, "PIMFDynamicMetadataWrappingFrame" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x05, // 465
       0x0e, 0x09, 0x06, 0x07, 0x01, 0x01, 0x11, 0x00 },
     {0, 0}, false, "PIMFDynamicMetadataEssence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x05, // 466
       0x0e, 0x09, 0x06, 0x07, 0x01, 0x01, 0x12, 0x00 },
     {0, 0}, false, "PIMFDynamicMetadataDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 467
       0x0e, 0x09, 0x06, 0x07, 0x01, 0x01, 0x13, 0x00 },
     {0, 0}, false, "PIMFDynamicMetadataDescriptor_GlobalPayloadSID" },

   // back to regularly defined UL values
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x06, // 468
       0x04, 0x01, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00 },
     {0, 0}, false, "ColorPrimaries_ITU470_PAL" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x06, // 469
       0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00 },
     {0, 0}, false, "ColorPrimaries_SMPTE170M" },

   // ACES ST 2067-50
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 470
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x79, 0x00 },
     {0, 0}, false, "ACESPictureSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 471
       0x04, 0x01, 0x06, 0x0a, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "ACESPictureSubDescriptor_ACESAuthoringInformation" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 472
       0x04, 0x01, 0x06, 0x0a, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "ACESPictureSubDescriptor_ACESMasteringDisplayPrimaries" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 473
       0x04, 0x01, 0x06, 0x0a, 0x03, 0x00, 0x00, 0x00 },
     {0, 0}, false, "ACESPictureSubDescriptor_ACESMasteringDisplayWhitePointChromaticity" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 474
       0x04, 0x01, 0x06, 0x0a, 0x04, 0x00, 0x00, 0x00 },
     {0, 0}, false, "ACESPictureSubDescriptor_ACESMasteringDisplayMaximumLuminance" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 475
       0x04, 0x01, 0x06, 0x0a, 0x05, 0x00, 0x00, 0x00 },
     {0, 0}, false, "ACESPictureSubDescriptor_ACESMasteringDisplayMinimumLuminance" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 476
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7a, 0x00 },
     {0, 0}, false, "TargetFrameSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 477
       0x04, 0x01, 0x06, 0x09, 0x01, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TargetFrameSubDescriptor_TargetFrameAncillaryResourceID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 478
       0x04, 0x01, 0x06, 0x09, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TargetFrameSubDescriptor_MediaType" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 479
       0x04, 0x01, 0x06, 0x09, 0x03, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TargetFrameSubDescriptor_TargetFrameIndex" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 480
       0x04, 0x01, 0x06, 0x09, 0x04, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TargetFrameSubDescriptor_TargetFrameTransferCharacteristic" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 481
       0x04, 0x01, 0x06, 0x09, 0x05, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TargetFrameSubDescriptor_TargetFrameColorPrimaries" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 482
       0x04, 0x01, 0x06, 0x09, 0x06, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TargetFrameSubDescriptor_TargetFrameComponentMaxRef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 483
       0x04, 0x01, 0x06, 0x09, 0x07, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TargetFrameSubDescriptor_TargetFrameComponentMinRef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 484
       0x04, 0x01, 0x06, 0x09, 0x08, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TargetFrameSubDescriptor_TargetFrameEssenceStreamID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 485
       0x04, 0x01, 0x06, 0x09, 0x09, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TargetFrameSubDescriptor_ACESPictureSubDescriptorInstanceID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 486
       0x04, 0x01, 0x06, 0x09, 0x0a, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TargetFrameSubDescriptor_TargetFrameViewingEnvironment" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 487
       0x04, 0x01, 0x01, 0x01, 0x01, 0x0c, 0x00, 0x00 },
     {0, 0}, false, "TransferCharacteristic_Gamma_2_6" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 488
       0x04, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x00, 0x00 },
     {0, 0}, false, "TransferCharacteristic_sRGB" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 489
       0x04, 0x10, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },
     {0, 0}, false, "TheatricalViewingEnvironment" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 490
       0x04, 0x10, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00 },
     {0, 0}, false, "HDTVReferenceViewingEnvironment" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 491
       0x04, 0x10, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00 },
     {0, 0}, false, "HDRReferenceViewingEnvironment" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x05, // 492
       0x0e, 0x09, 0x05, 0x02, 0x01, 0x00, 0x01, 0x00 },
     {0, 0}, false, "FrameWrappedISXDData" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x05, // 493
       0x0e, 0x09, 0x06, 0x07, 0x01, 0x01, 0x01, 0x03 },
     {0, 0}, false, "FrameWrappedISXDContainer" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x05, // 494
       0x0e, 0x09, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "ISXDDataEssenceDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, // 495
       0x0e, 0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "ISXDDataEssenceDescriptor_NamespaceURI" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x05, // 496
       0x0e, 0x09, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "UTF_8_Text_DataEssenceCoding" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 497-chk
       0x0d, 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 0x00 },
     {0, 0}, false, "TextBasedDMFramework" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0D, // 498-chk
       0x06, 0x01, 0x01, 0x04, 0x05, 0x41, 0x01, 0x00 },
     {0, 0}, true, "TextBasedDMFramework_ObjectRef" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 499
       0x0d, 0x01, 0x04, 0x01, 0x04, 0x03, 0x01, 0x00 },
     {0, 0}, false, "TextBasedObject" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0d, // 500
       0x04, 0x06, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TextBasedObject_PayloadSchemeID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0d, // 501
       0x04, 0x09, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TextBasedObject_TextMIMEMediaType" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0d, // 502
       0x03, 0x01, 0x01, 0x02, 0x02, 0x14, 0x00, 0x00 },
     {0, 0}, false, "TextBasedObject_RFC5646TextLanguageCode" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0d, // 503
       0x03, 0x02, 0x01, 0x06, 0x03, 0x02, 0x00, 0x00 },
     {0, 0}, true, "TextBasedObject_TextDataDescription" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 504
       0x0d, 0x01, 0x04, 0x01, 0x04, 0x02, 0x01, 0x00 },
     {0, 0}, false, "GenericStreamTextBasedSet" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0d, // 505
       0x01, 0x03, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "GenericStreamTextBasedSet_GenericStreamSID" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x06, 0x01, 0x01, // 506
       0x0d, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DescriptiveObject" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c, // 507
       0x05, 0x20, 0x07, 0x01, 0x0c, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DescriptiveFramework_LinkedDescriptiveFrameworkPlugInId" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c, // 508
       0x05, 0x20, 0x07, 0x01, 0x11, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DescriptiveObject_LinkedDescriptiveObjectPlugInId" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c, // 509
       0x01, 0x02, 0x02, 0x10, 0x02, 0x03, 0x00, 0x00 },
     {0, 0}, false, "Preface_ApplicationSchemes" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e, // 510
       0x01, 0x02, 0x02, 0x10, 0x02, 0x04, 0x00, 0x00 },
     {0, 0}, false, "Preface_ConformsToSpecifications" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0c, // 511
       0x0d, 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 0x00 },
     {0, 0}, false, "MXFTextBasedFramework" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0e, // 512
       0x04, 0x01, 0x01, 0x01, 0x03, 0x05, 0x00, 0x00 },
     {0, 0}, false, "ColorPrimaries_SMPTE_DCDM" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0e, // 513
       0x04, 0x01, 0x01, 0x01, 0x03, 0x08, 0x00, 0x00 },
     {0, 0}, false, "ColorPrimaries_CinemaMezzanine" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 514
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x19, 0x01, 0x00,  },
     {0, 0}, false, "MXFGCFrameWrappedACESPictures" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 515
       0x04, 0x01, 0x02, 0x02, 0x03, 0x04, 0x01, 0x00,  },
     {0, 0}, false, "ACESUncompressedMonoscopicWithoutAlpha" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 516
       0x04, 0x01, 0x02, 0x02, 0x03, 0x04, 0x02, 0x00,  },
     {0, 0}, false, "ACESUncompressedMonoscopicWithAlpha" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x01, // 517
       0x0d, 0x01, 0x03, 0x01, 0x15, 0x01, 0x12, 0x00 },
     {0, 0}, false, "ACESFrameWrappedEssence" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 518
       0x03, 0x02, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_FSKSyncSignalChannel" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x03, 0x0f, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_J2KExtendedCapabilities" }, // 519
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x03, 0x10, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_J2KProfile" }, // 520
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x03, 0x11, 0x00, 0x00, 0x00 },
     {0, 0}, false, "JPEG2000PictureSubDescriptor_J2KCorrespondingProfile" }, // 521
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01,
       0x03, 0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "J2KExtendedCapabilities" }, // 522
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0D,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x08, 0x00 },
     {0, 0}, false, "HTJ2KPictureCodingScheme" }, // 523
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0D,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x08, 0x01 },
     {0, 0}, false, "HTJ2KPictureCodingSchemeGeneric" }, // 524
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x0d, 0x0f, 0x03, 0x02, 0x01, 0x01, 0x00, 0x00 },
     {0, 0}, false, "AudioChannelSLVS" }, // 525
   { { 0x06, 0x0e, 0x2b, 0x34, 01, 0x01, 0x01, 0x0e,
       0x06, 0x01, 0x01, 0x02, 04, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TimedTextDescriptor_DisplayType" }, // 526
   { { 0x06, 0x0e, 0x2b, 0x34, 01, 0x01, 0x01, 0x0e,
       0x06, 0x01, 0x01, 0x02, 05, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TimedTextDescriptor_IntrinsicPictureResolution" }, // 527
   { { 0x06, 0x0e, 0x2b, 0x34, 01, 0x01, 0x01, 0x0e,
       06, 0x01, 0x01, 0x02, 06, 0x00, 0x00, 0x00 },
     {0, 0}, false, "TimedTextDescriptor_ZPositionInUse" }, // 528
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 529
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7b, 0x00 },
     {0, 0}, false, "IABEssenceDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, // 530
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7c, 0x00 },
     {0, 0}, false, "IABSoundfieldLabelSubDescriptor" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 531
       0x01, 0x01, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IMF_IABTrackFileLevel0" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 532
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x1d, 0x01, 0x01 },
     {0, 0}, false, "IMF_IABEssenceClipWrappedContainer" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, // 533
       0x03, 0x02, 0x02, 0x21, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "IABSoundfield" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x01, // 534
       0x0d, 0x01, 0x03, 0x01, 0x16, 0x7f, 0x0d, 0x7f },
     {0, 0}, false, "IMF_IABEssenceClipWrappedElement" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x05, // 535
       0x0e, 0x09, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00 },
     {0, 0}, false, "ImmersiveAudioCoding" },
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,  
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x21, 0x00, 0x00 },
     {0}, false, "MXFGCJPEGXSPictures" },              // 536
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x21, 0x01, 0x00 },
     {0}, false, "MXFGCFrameWrappedProgressiveJPEGXSPictures" }, // 537
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x21, 0x02, 0x00 },
     {0}, false, "MXFGCFrameWrappedInterlacedJPEGXSPictures" }, // 538
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x0d, 0x01, 0x03, 0x01, 0x02, 0x21, 0x03, 0x00 },
     {0}, false, "MXFGCClipWrappedJPEGXSPictures" }, // 539
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x08, 0x00, 0x00 },
     {0}, false, "JPEGXSPictureCodingSchemes"}, // 540
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x08, 0x01, 0x00 },
     {0}, false, "JPEGXSUnrestrictedCodestream"},      // 541
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x08, 0x02, 0x00 },
     {0}, false, "JPEGXSMain422_10Profile" },          // 542
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x08, 0x03, 0x00 },
     {0}, false, "JPEGXSMain444_12Profile" },          // 543
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x08, 0x04, 0x00 },
     {0}, false, "JPEGXSMain4444_12Profile" },         // 544
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x08, 0x05, 0x00 },
     {0}, false, "JPEGXSLight422_10Profile" },         // 545
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x08, 0x06, 0x00 },
     {0}, false, "JPEGXSLight444_12Profile" },         // 546
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x08, 0x07, 0x00 },
     {0}, false, "JPEGXSLightSubline422_10Profile" },  // 547
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x08, 0x08, 0x00 },
     {0}, false, "JPEGXSHigh444_12Profile" },          // 548
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x08, 0x09, 0x00 },
     {0}, false, "JPEGXSHigh4444_12Profile" },         // 549
   { { 0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
       0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x81, 0x02 },
     {0}, false, "JPEGXSSubDescriptor" },              // 550
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x0b, 0x00, 0x00 ,0x00, 0x00 },
     {0}, false, "JPEGXSCodingParameters" },           // 551
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x0b, 0x01, 0x00 ,0x00, 0x00 },
     {0}, false, "JPEGXSPpih" },                       // 552
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x0b, 0x02, 0x00 ,0x00, 0x00 },
     {0}, false, "JPEGXSPlev" },                       // 553
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x0b, 0x03, 0x00 ,0x00, 0x00 },
     {0}, false, "JPEGXSWf" },                         // 554
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x0b, 0x04, 0x00 ,0x00, 0x00 },
     {0}, false, "JPEGXSHf" },                         // 555
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x0b, 0x05, 0x00 ,0x00, 0x00 },
     {0}, false, "JPEGXSNc" },                         // 556
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x0b, 0x06, 0x00 ,0x00, 0x00 },
     {0}, false, "JPEGXSComponentTable" },             // 557
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x0b, 0x07, 0x00 ,0x00, 0x00 },
     {0}, true, "JPEGXSCw" },                         // 558
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x0b, 0x08, 0x00 ,0x00, 0x00 },
     {0}, true, "JPEGXSHsl" },                       // 559
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0e,
       0x04, 0x01, 0x06, 0x0b, 0x09, 0x00 ,0x00, 0x00 },
     {0}, true, "JPEGXSMaximumBitRate" },            // 560
   { { 0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x01, 
       0x0d, 0x01, 0x03, 0x01, 0x15, 0x01, 0x1a, 0x00 },
     {0}, false, "JPEGXSEssence" }, // 561. frame wrapped JPEG XS
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, 
       0x04, 0x01, 0x01, 0x01, 0x01, 0x0b, 0x00, 0x00 },
     {0}, false, "TransferCharacteristic_HLG" }, // 562
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, 
       0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00 },
     {0}, false, "TransferCharacteristic_BT.1361" },  // 563
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 
       0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },
     {0}, false, "TransferCharacteristic_BT470" }, // 564
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 
       0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00 },
     {0}, false, "TransferCharacteristic_ST240M" }, // 565
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x08, 
       0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00 },
     {0}, false, "TransferCharacteristic_ST428" }, // 566
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, 
       0x04, 0x01, 0x01, 0x01, 0x02, 0x05, 0x00, 0x00 },
     {0}, false, "CodingEquations_BGR" }, // 567
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x06, 
       0x04, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00 },
     {0}, false, "CodingEquations_ST240M" }, // 568
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d, 
       0x04, 0x01, 0x01, 0x01, 0x02, 0x04, 0x00, 0x00 },
     {0}, false, "CodingEquations_YCGCO" }, // 569

   // more IMF
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x03 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_1_1" }, // 570
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x05 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_2_1" }, // 571
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x07 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_3_1" }, // 572
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x09 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_4_1" }, // 573
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x0a },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_4_2" }, // 574
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x0c },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_5_1" }, // 575
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x0d },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_5_2" }, // 576
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x0e },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_5_3" }, // 577
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x10 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_6_1" }, // 578
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x11 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_6_2" }, // 579
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x12 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_6_3" }, // 580
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0d,
       0x04, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x13 },
     {0, 0}, false, "JP2KEssenceCompression_IMFProfile_2K_Lossy_6_4" }, // 581

   // 5.1.4 audio program from SMPTE ST 377-42
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x05,
       0x0e, 0x09, 0x01, 0x01, 0x05, 0x02, 0x00, 0x00 },
     {0, 0}, false, "DCAudioSoundfield_514" }, // 582
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x05,
       0x0e, 0x09, 0x01, 0x01, 0x04, 0x03, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Ltfs" }, // 583
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x05,
       0x0e, 0x09, 0x01, 0x01, 0x04, 0x04, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Rtfs" }, // 584
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x05,
       0x0e, 0x09, 0x01, 0x01, 0x04, 0x07, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Ltrs" }, // 585
   { { 0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x05,
       0x0e, 0x09, 0x01, 0x01, 0x04, 0x08, 0x00, 0x00 },
     {0, 0}, false, "DCAudioChannel_Ltrs" }, // 586
   { {0}, {0}, false, 0 },
};

//
// end MDD.cpp
//
