# omnia-eeprom

The `omnia-eeprom` utility allows you to display and update EEPROM fields on
the Turris Omnia router.

The EEPROM is normally not meant to be updated by users, but there are some
exceptions where it might be useful.

One such example is to change the DDR3 speed from the default 1600K mode to
1333H mode, in order to solve random crashes that occur on some boards with
newer versions of the U-Boot bootloader (because of bugs in newer versions of
the DDR training algorithm). This can be done with:

  ```
  omnia-eeprom set ddr_speed 1333H
  ```

## Build

The program requires building with GCC. Clang should also work, but is not
tested.

Simply run `make` with the appropriate `CC` and `CFLAGS` settings.
If not in a git repository, you also need to specify the `OMNIA_EEPROM_VERSION`
variable (it is printed in `omnia-eeprom --version`.

## License

This program is licensed under GNU GPL v2.
