#!/bin/bash
#
# what does this script do?
#
#set -x

usage(){
    echo "SetDefaultTrippoints [CONFIG_FILE]"
}

set_trip_points(){
    local FILE="$1"

    grep "THERMAL_TRIP_POINTS AUTOMATICALLY CREATED - DO NOT EDIT THIS LINE" $FILE >/dev/null
    if [ $? -eq 0 ];then
	# Trip points already written
	return
    fi
    
    echo $'\n' >> $FILE
    echo "## Path:		System/Powermanagement/Powersave/Thermal"$'\n'\
"## Type:		integer(0:150)"$'\n'\
"#"$'\n'\
"# THERMAL_TRIP_POINTS AUTOMATICALLY CREATED - DO NOT EDIT THIS LINE"$'\n'\
"# Set trip points for critical, hot, passive and active limits"$'\n'\
"# also see the ENABLE_THERMAL_MANAGEMENT variable in the thermal file"$'\n'\
"# to activate these settings. Per default only thermal zones that define"$'\n'\
"# a passive trip point are managed with these settings."$'\n'\
"# The intitial default values are exported from BIOS."$'\n' >>$FILE


    n=0
    for x in `sed -n -e 's/^Critical: \([0-9]\+\)/\1/p' < <(cat $THERMAL_TRIPPOINTS_FILE)`; do
        echo "THERMAL_CRITICAL_$n=\"$x\"" >> $FILE
        n=$(($n+1))
    done

    n=0
    for x in `sed -n -e 's/^Hot: \([0-9]\+\)/\1/p' < <(cat $THERMAL_TRIPPOINTS_FILE)`; do
        echo "THERMAL_HOT_$n=\"$x\"" >> $FILE
        n=$(($n+1))
    done

    n=0
    for x in `sed -n -e 's/^Passive: \([0-9]\+\)/\1/p' < <(cat $THERMAL_TRIPPOINTS_FILE)`; do
        echo "THERMAL_PASSIVE_$n=\"$x\"" >> $FILE
        n=$(($n+1))
    done
}

if [ $# -gt 1 ];then
    echo usage
    exit 1
fi

CONFIG_FILE=""

if [ -n "$1" ];then
    if [ -w "$1" ];then
	CONFIG_FILE="$1"
    else
	echo "Cannot access config file $1"
	exit 1
    fi
fi

if [ -d /dev/shm ] && [ -w /dev/shm ] && [ -x /dev/shm ];then
    THERMAL_TRIPPOINTS_FILE="/dev/shm/thermal_trippoints_file"
    ${exec_prefix}/bin/powersave -T > $THERMAL_TRIPPOINTS_FILE
    if [ $? != 0 ];then
	exit 1
    fi
elif [ -d /tmp ] && [ -w /tmp ] && [ -x /tmp ];then
    THERMAL_TRIPPOINTS_FILE="/tmp/thermal_trippoints_file"
    ${exec_prefix}/bin/powersave -T > $THERMAL_TRIPPOINTS_FILE
    if [ $? != 0 ];then
	exit 1
    fi
else
    # No temp directory
    return
fi

if [ "$CONFIG_FILE" = "" ];then
    for y in ${prefix}/etc/powersave/scheme_*; do
	if [ ! -w "$y" ];then
	    echo "Cannot access config file $y"
	    exit 1
	fi
	set_trip_points $y
    done
else
    set_trip_points $CONFIG_FILE
fi