#!/bin/sh
# geninitrd mod: uvesafb
USE_V86D=${USE_V86D:-yes}

# whether v86d should be installed
need_uvesafb=no

# setup geninitrd module
# @access	public
setup_mod_uvesafb() {
	v86d=$(find_tool $initrd_dir/v86d /sbin/v86d)

	if [ ! -x "$v86d" ]; then
		USE_V86D=no
	fi
}

# find modules for for fbsplash
# @access	public
find_modules_uvesafb() {
	if ! is_yes "$USE_V86D"; then
		return
	fi

	# if we are adding uvesafb, we need v86d as well
	local m
	for m in $MODULES; do
		if [[ "$m" = *uvesafb* ]]; then
			need_uvesafb=yes
		fi
	done
}

# generate initrd fragment
# @access	public
initrd_gen_uvesafb() {
	if ! is_yes "$need_uvesafb"; then
		return
	fi

	verbose "initrd_gen_uvesafb"
	mknod -m 640 $DESTDIR/dev/mem c 1 1
	mknod -m 600 $DESTDIR/dev/tty1 c 4 1
	inst_d /sbin
	inst_exec $v86d /sbin
}

initrd_gen_stop_uvesafb() {
	if ! is_yes "$need_uvesafb"; then
		return
	fi

	busybox_applet killall
	add_linuxrc	<<-'EOF'
		killall v86d
	EOF
}
