#!/bin/sh
# geninitrd mod: depmod for 2.4 kernel

# Finds module dependencies
#
# @param	$module
# @param	$mode	[silent]
#
# Outputs each dependant module full path.
find_depmod() {
	local module="$1"
	local mode="$2"

	typeset mods module f level depfile first

	depfile=/lib/modules/$kernel/modules.dep

	if [ ! -f $depfile ]; then
		die "No $depfile! Run depmod and rerun $PROGRAM."
	fi

	# prepend / if no path given, append $modext.gz if not given,
	# quote /
	origmodule="$2"
	module=$(echo "$2" | \
		awk '/\// {print;next} {print "/" $0}' | \
		awk '/\./ {print;next} {print $0 "'$modext'.gz"}' |
		awk '{gsub("/","\\/");print}')
	mods=$(awk '
BEGIN { here = 0 }
/'"$module"':(.*)/ { gsub(/:/," "); gsub(/\\/," "); print; here = 1; next }
/:/ { here = 0 }
/(.*)/ { gsub(/\\/," "); if (here) print }
' $depfile | xargs)

	# fallback to $modext
	if [ "$mods" = "" ]; then
		module=$(echo "$module" | awk '{gsub("\'$modext'\.gz$","\'$modext'",$0);print}')
		# ") - vim
	fi

	mods=$(awk '
BEGIN { here = 0 }
/'"$module"':(.*)/ { gsub(/:/," "); gsub(/\\/," "); print; here = 1; next }
/:/ { here = 0 }
/(.*)/ { gsub(/\\/," "); if (here) print }
' $depfile | xargs)

	if [ "$mods" = "" ]; then
		if [ "$1" != silent ]; then
			warn "$origmodule: module not found in $depfile"
		fi
		if ! is_no "$EXIT_IF_MISSING"; then
			exit 1
		else
			warn "If $origmodule isn't compiled in kernel then this initrd may not start your system."
		fi
	fi

	level=$3
	if [ "$level" = "" ]; then
		level=0
	fi
	level=$((level + 1))
	if [ $level -gt 20 ]; then
		die "$origmodule: cycle in $depfile"
	fi

	first=
	for f in $mods; do
		if [ "$first" = "" ]; then
			first=$f
		else
			find_depmod $1 $f $level
		fi
	done

	echo $first
}
