# RK3566 Release Note

## rk3568_ddr_{1560...1056}MHz_v1.23.bin

| Date       | File                                  | Build commit | Severity  |
| ---------- | ------------------------------------- | ------------ | --------- |
| 2024-09-03 | rk3568_ddr_{1560...1056}MHz_v1.23.bin | 03ea844c5d   | important |

### New

1. Added ddr type detection order configurable through ddrbin tool.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Fixed the issue that DDR4 probabilistic capacity probabilistic detection failed. | DDR4 may have capacity, eccdetection errors.                 | -            |
| 2     | important | Added support for ISSI UniIC LP4/4x.                         | Solve the problem of poor stability caused by weak drive strength of ISSI UniIC LP4/4x. | -            |

------

## rk3566_ddr_{1056...920}MHz_v1.22.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2024-06-21 | rk3566_ddr_{1056...920}MHz_v1.22.bin | f8ac117e9c   | important |

### New

1. The CLK/DQS slew rate supports different values at high and low frequencies.
2. Added DRAM Manufacturer ID printing.
3. DDR4 enable LPASR to reduce DDR4 self-refresh power.

### Fixed

| Index | Severity  | Update                                              | Issue description                                            | Issue source |
| ----- | --------- | --------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Probabilistic training failure issue under DDR4 2cs | Probabilistic read/write training failures under DDR4 2cs introduced in ddrbin v1.21. | -            |
| 2     | important | LP4x 600M or less forced to open 240ohm rx odt      | There are compatibility issues with some chips under low-frequency when rx odt disable, which manifests as 324M instability. | -            |
| 3     | important | Undo vref training below 600MHz                     | The vref training introduced in ddrbin v1.21 may cause unreliable vref trining results at low frequencies | -            |

------

## rk3566_ddr_1056MHz_{D3_LP3,D3_LP4_4x}_eyescan_v1.22.bin

| Date       | File                                                    | Build commit | Severity  |
| ---------- | :------------------------------------------------------ | ------------ | --------- |
| 2024-06-21 | rk3566_ddr_1056MHz_{D3_LP3,D3_LP4_4x}_eyescan_v1.22.bin | f8ac117e9c   | important |

### New

1. Updated 2D eye printing format.
2. Add automatic judgment of eye margin.

------

## rk356x_spl_v1.14.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | :------------------- | ------------ | --------- |
| 2024-05-30 | rk356x_spl_v1.14.bin | 606f72bd97a  | important |

### New

1.  Add support for continuing burning RSA key hash after OTP power down.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the issue that SD card initialization fails under SPL stage. | pinctrl node is disabled under SPL stage. | -            |

------

## rk3566_ddr_{1056...920}MHz_v1.21.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2024-01-20 | rk3566_ddr_{1056...920}MHz_v1.21.bin | 2d653b3476   | important |

### Fixed

| Index | Severity  | Update                                                    | Issue description                                            | Issue source |
| ----- | --------- | --------------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Fixed issue that CA training may be missed during reboot. | CA training may not be done during reboot. CA training results always zero. | -            |

------

## rk3568_bl31_ultra_v2.17.elf

| Date       | File                        | Build commit | Severity  |
| ---------- | --------------------------- | ------------ | --------- |
| 2024-02-01 | rk3568_bl31_ultra_v2.17.elf | 4a52a1f56    | important |

### New

1. Reduce the maximum uart busy wait time to 5.6ms to prevent long uart busy from causing slow wake up.

------

## rk3566_ddr_1056MHz_ultra_v1.20.bin

| Date       | File                               | Build commit | Severity  |
| ---------- | ---------------------------------- | ------------ | --------- |
| 2024-01-13 | rk3566_ddr_1056MHz_ultra_v1.20.bin | 328b43930e   | important |

### New

1. The tRFC value can be configured through ddrbin_tools.
1. Add read/write vref trining to improve compatibility.

### Fixed

| Index | Severity  | Update                                                    | Issue description                          | Issue source |
| ----- | --------- | --------------------------------------------------------- | ------------------------------------------ | ------------ |
| 1     | important | Fixed 6GB LPDDR4 initialization failure problem           | 6GB LPDDR4 panic during DDR initialization | -            |
| 2     | important | Enable LPDDR4/4X read odt under780M to implove stability. | Some LPDDR4/4X have poor stability at 780M | -            |
| 3     | important | Fixed issue that CA training may be missed during reboot  | CA training may not be done during reboot  | -            |

------

## rk3566_ddr_{1056...920}MHz_v1.20.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2024-01-12 | rk3566_ddr_{1056...920}MHz_v1.20.bin | 77170a5e90   | important |

### New

1. The tRFC value can be configured through ddrbin_tools.
1. Add read write vref trining to improve compatibility.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                    | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ---------------------------------------------------- | ------------ |
| 1     | important | Update DDR3/LPDDR3 rd/wr training pattern to improve read and write signal margin | Optimize DDR3/LPDDR3 read and write signal margin    | -            |
| 2     | important | Fixed 6GB LPDDR3/4 initialization failure problem            | 6GB LPDDR3/4 panic during DDR initialization         | -            |
| 3     | important | Enable LPDDR4/4X read odt under780M to implove stability.    | Some LPDDR4/4X particles have poor stability at 780M | -            |

------

## rk3568_bl31_ultra_v2.16.elf

| Date       | File                        | Build commit | Severity  |
| ---------- | --------------------------- | ------------ | --------- |
| 2023-11-10 | rk3568_bl31_ultra_v2.16.elf | 4af8f9ace    | important |

### New

1. Update the latest code to improve compatibility.

------

## rk3568_bl31_ultra_v2.15.elf

| Date       | File                        | Build commit | Severity  |
| ---------- | --------------------------- | ------------ | --------- |
| 2023-10-28 | rk3568_bl31_ultra_v2.15.elf | 2f6f2e6f4    | important |

### New

1. Optimize wakeup speed.
2. Fix lite mode sleep, vcc_ddr probability high power consumption.

------

## rk3568_bl31_ultra_v2.14.elf

| Date       | File                        | Build commit | Severity  |
| ---------- | --------------------------- | ------------ | --------- |
| 2023-10-12 | rk3568_bl31_ultra_v2.14.elf | 7e89dd758    | important |

### New

1. Update the latest code.

------

## rk3566_ddr_1056MHz_ultra_v1.19.bin

| Date       | File                               | Build commit | Severity  |
| ---------- | ---------------------------------- | ------------ | --------- |
| 2023-10-07 | rk3566_ddr_1056MHz_ultra_v1.19.bin | b2f397ce2c   | important |

### Warn

1. BL31 should be update to v2.14 or above.

### New

1. Enable derate function for LPDDR4/LPDDR4x.
2. Add byte mode LPDDR4/4x support.

------

## rk356x_spl_v1.13.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | -------------------- | ------------ | --------- |
| 2023-09-25 | rk356x_spl_v1.13.bin | e4e124926e   | important |

### New

1. Print and pass the firmware version number.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the issue that the backup image is not loaded when the SPL load or check u-boot.dtb fails | When u-boot.dtb of the first uboot.img is corrupted, SPL doesn't load the backup image. | -            |

------

## rk3566_ddr_{1056...920}MHz_v1.18.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2023-07-17 | rk3566_ddr_{1056...920}MHz_v1.18.bin | f366f69a7d   | important |

### Fixed

| Index | Severity | Update                                           | Issue description                     | Issue source |
| ----- | -------- | ------------------------------------------------ | ------------------------------------- | ------------ |
| 1     | important | Fixed the suspend/resume function crash problem caused by DDR active_ranks configuration error | Suspend/resume function crash | -            |

------

## rk3566_ddr_{1056...324}MHz_v1.17.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2023-06-20 | rk3566_ddr_{1056...324}MHz_v1.17.bin | 992b933606   | important |

### New

1. Added support for 4rank LPDDR3/LPDDR4/LPDDR4x of different rows.
2. Enable derate function for LPDDR4/LPDDR4x.

------

## rk3566_ddr_1056MHz_eyescan_v1.16.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | :----------------------------------- | ------------ | --------- |
| 2023-04-19 | rk3566_ddr_1056MHz_eyescan_v1.16.bin | b9c108a4eb   | important |

### New

1. Add RK3566 2D eye scan support.

------

## rk3566_ddr_{1056...324}MHz_v1.16.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2022-11-16 | rk3566_ddr_{1056...324}MHz_v1.16.bin | 6f71c736ce   | important |

### New

1. RK3568J/RK3568M use 1/2tREFI except LPDDR4/LPDDR4x. LPDDR4/LPDDR4x use derate mode.
2. TREFI, pageclose configurable by ddrbin tool.
3. Improve DDR4 performance.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | To solve the instability problem of some ddr4 when DDR run in 528MHz. | When DDR4 run in 528MHz, the system would unstable, causing a crash and restart | -            |
| 2     | important | To solve 4GB ECC board Init fail bug                         | 4GB DDR4 board may crash in ddrbin                           |              |

------

## rk3566_ddr_{1056...324}MHz_v1.15.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | ------------------------------------ | ------------ | --------- |
| 2022-11-08 | rk3566_ddr_{1056...324}MHz_v1.15.bin | ec2fae0c96   | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | To solve the instability problem of some chips when DDR run in 324MHz. | When DDR run in 324MHz, the system would unstable, causing a crash and restart | -            |

------

## rk3566_ddr_{1056...324}MHz_v1.14.bin

| Date       | File                                 | Build commit | Severity  |
| ---------- | :----------------------------------- | ------------ | --------- |
| 2022-08-27 | rk3566_ddr_{1056...324}MHz_v1.14.bin | b1f29a2a6f   | important |

### Fixed

| Index | Severity  | Update                                                    | Issue description                                            | Issue source |
| ----- | --------- | --------------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | moderate  | fix Fix set of t_xs_x32, t_xs_abort_x32 and t_xs_fast_x32 | Fix set of t_xs_x32, t_xs_abort_x32 and t_xs_fast_x32.This bug may lead to some low density dram(128M) fail. | -         |
| 2     | important | fix ddr4 528M stability problem                           | some DRAM DLL can't lock at 528M，DLL should be bypass for 528M | -         |

------
