/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import virtuoso.jdbc4.Driver;
import virtuoso.jdbc4.VirtuosoConnectionPoolDataSource;
import virtuoso.jdbc4.VirtuosoDataSource;
import virtuoso.jdbc4.VirtuosoDate;
import virtuoso.jdbc4.VirtuosoTime;
import virtuoso.jdbc4.VirtuosoTimestamp;
import virtuoso.jdbc4.VirtuosoXADataSource;
import virtuoso.jena.driver.VirtDataset;
import virtuoso.jena.driver.VirtPrefixMapping;
import virtuoso.jena.driver.VirtResSetIter;
import virtuoso.jena.driver.VirtTransactionHandler;
import virtuoso.jena.driver.VirtuosoQueryEngine;
import virtuoso.sql.ExtendedString;
import virtuoso.sql.RdfBox;

public class VirtGraph
extends GraphBase {
    public static final int CONCUR_DEFAULT = 0;
    public static final int CONCUR_PESSIMISTIC = 1;
    public static final int CONCUR_OPTIMISTIC = 2;
    static final String xsd_string = "http://www.w3.org/2001/XMLSchema#string";
    protected static final String S_BATCH_INSERT = "DB.DBA.RDF_INSERT_TRIPLE_C (?,?,?,?,?,?)";
    protected static final String S_BATCH_DELETE = "DB.DBA.RDF_DELETE_TRIPLE_C (?,?,?,?,?,?)";
    static final String S_CLEAR_GRAPH = "DB.DBA.RDF_CLEAR_GRAPHS_C (?)";
    protected static final int BATCH_SIZE = 5000;
    protected static final int MAX_CMD_SIZE = 36000;
    static final String utf8 = "charset=utf-8";
    static final String charset = "UTF-8";
    public static final String DEFAULT = "virt:DEFAULT";
    protected boolean isXA = false;
    protected String graphName;
    protected boolean readFromAllGraphs = false;
    protected String url_hostlist;
    protected String user;
    protected String password;
    protected boolean roundrobin = false;
    protected int prefetchSize = 100;
    protected int batchSize = 5000;
    protected Connection connection = null;
    protected VirtDataset parent_dataset = null;
    protected String ruleSet = null;
    protected String macroLib = null;
    protected boolean useSameAs = false;
    protected int queryTimeout = 0;
    protected boolean useReprepare = false;
    protected String sparqlPrefix = null;
    protected boolean insertBNodeAsVirtuosoIRI = false;
    protected boolean resetBNodesDictAfterCall = false;
    protected boolean resetBNodesDictAfterCommit = true;
    protected boolean insertStringLiteralAsSimple = false;
    protected boolean useAdvancedDelete = false;
    protected int concurencyMode = 0;
    private VirtuosoConnectionPoolDataSource pds = new VirtuosoConnectionPoolDataSource();
    private DataSource ds;
    private XAResource xa_resource = null;
    private XAConnection xa_connection = null;
    protected VirtTransactionHandler tranHandler = null;
    protected final Object lck_add = new Object();
    private boolean isBNodesDictCreated = false;
    private boolean batch_add_executed = false;
    PreparedStatement psInsert = null;
    int psInsert_Count = 0;
    protected VirtPrefixMapping m_prefixMapping = null;

    protected VirtGraph(String _graphName, VirtDataset ds) {
        this.graphName = _graphName == null ? DEFAULT : _graphName;
        this.connection = ds.getConnection();
        this.parent_dataset = ds;
        this.url_hostlist = ds.getGraphUrl();
        this.user = ds.getGraphUser();
        this.password = ds.getGraphPassword();
        this.roundrobin = ds.roundrobin;
        this.setMacroLib(ds.getMacroLib());
        this.setRuleSet(ds.getRuleSet());
        this.setFetchSize(ds.getFetchSize());
        this.setQueryTimeout(ds.getQueryTimeout());
        this.setBatchSize(ds.getBatchSize());
        this.setSparqlPrefix(ds.getSparqlPrefix());
        this.setInsertBNodeAsVirtuosoIRI(ds.getInsertBNodeAsVirtuosoIRI());
        this.setResetBNodesDictAfterCall(ds.getResetBNodesDictAfterCall());
        this.setResetBNodesDictAfterCommit(ds.getResetBNodesDictAfterCommit());
        this.setUseAdvancedDelete(ds.getUseAdvancedDelete());
        this.setInsertStringLiteralAsSimple(ds.getInsertStringLiteralAsSimple());
        this.setConcurrencyMode(ds.getConcurrencyMode());
        this.setReadFromAllGraphs(ds.getReadFromAllGraphs());
        this.setSameAs(ds.getSameAs());
        try {
            Driver drv = new Driver();
            if (drv.getMajorVersion() <= 3 && drv.getMinorVersion() < 72) {
                this.useReprepare = true;
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public VirtGraph() {
        this(null, "jdbc:virtuoso://localhost:1111/charset=UTF-8", null, null, false);
    }

    public VirtGraph(String graphName) {
        this(graphName, "jdbc:virtuoso://localhost:1111/charset=UTF-8", null, null, false);
    }

    public VirtGraph(String graphName, String _url_hostlist, String user, String password) {
        this(graphName, _url_hostlist, user, password, false);
    }

    public VirtGraph(String url_hostlist, String user, String password) {
        this(null, url_hostlist, user, password, false);
    }

    public VirtGraph(String _graphName, DataSource _ds) {
        if (_ds instanceof VirtuosoDataSource) {
            VirtuosoDataSource vds = (VirtuosoDataSource)_ds;
            this.url_hostlist = vds.getServerName();
            this.user = vds.getUser();
            this.password = vds.getPassword();
        }
        this.graphName = _graphName == null ? DEFAULT : _graphName;
        try {
            this.connection = _ds.getConnection();
            this.ds = _ds;
            ModelCom m = new ModelCom((Graph)this);
            TypeMapper tm = TypeMapper.getInstance();
            Driver drv = new Driver();
            if (drv.getMajorVersion() <= 3 && drv.getMinorVersion() < 72) {
                this.useReprepare = true;
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public VirtGraph(DataSource _ds) {
        this(null, _ds);
    }

    public VirtGraph(String _graphName, ConnectionPoolDataSource _ds) {
        if (_ds instanceof VirtuosoConnectionPoolDataSource) {
            VirtuosoDataSource vds = (VirtuosoDataSource)_ds;
            this.url_hostlist = vds.getServerName();
            this.user = vds.getUser();
            this.password = vds.getPassword();
        }
        this.graphName = _graphName == null ? DEFAULT : _graphName;
        try {
            this.connection = _ds.getPooledConnection().getConnection();
            ModelCom m = new ModelCom((Graph)this);
            TypeMapper tm = TypeMapper.getInstance();
            Driver drv = new Driver();
            if (drv.getMajorVersion() <= 3 && drv.getMinorVersion() < 72) {
                this.useReprepare = true;
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public VirtGraph(ConnectionPoolDataSource _ds) {
        this(null, _ds);
    }

    public VirtGraph(String _graphName, XADataSource _ds) {
        if (_ds instanceof VirtuosoXADataSource) {
            VirtuosoXADataSource vds = (VirtuosoXADataSource)_ds;
            this.url_hostlist = vds.getServerName();
            this.user = vds.getUser();
            this.password = vds.getPassword();
        }
        this.ds = (DataSource)((Object)_ds);
        this.graphName = _graphName == null ? DEFAULT : _graphName;
        try {
            this.xa_connection = _ds.getXAConnection();
            this.connection = this.xa_connection.getConnection();
            this.isXA = true;
            ModelCom m = new ModelCom((Graph)this);
            TypeMapper tm = TypeMapper.getInstance();
            Driver drv = new Driver();
            if (drv.getMajorVersion() <= 3 && drv.getMinorVersion() < 72) {
                this.useReprepare = true;
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public VirtGraph(XADataSource _ds) {
        this(null, _ds);
    }

    public VirtGraph(String _graphName, String _url_hostlist, String user, String password, boolean _roundrobin) {
        this.url_hostlist = _url_hostlist.trim();
        this.roundrobin = _roundrobin;
        this.user = user;
        this.password = password;
        this.graphName = _graphName == null ? DEFAULT : _graphName;
        try {
            if (this.url_hostlist.startsWith("jdbc:virtuoso://")) {
                Object url = this.url_hostlist;
                if (((String)url).toLowerCase().indexOf(utf8) == -1) {
                    url = ((String)url).charAt(((String)url).length() - 1) != '/' ? (String)url + "/charset=UTF-8" : (String)url + "charset=UTF-8";
                }
                if (this.roundrobin && ((String)url).toLowerCase().indexOf("roundrobin=") == -1) {
                    url = ((String)url).charAt(((String)url).length() - 1) != '/' ? (String)url + "/roundrobin=1" : (String)url + "roundrobin=1";
                }
                if (((String)url).toLowerCase().indexOf("log_enable=") == -1) {
                    url = ((String)url).charAt(((String)url).length() - 1) != '/' ? (String)url + "/log_enable=1" : (String)url + "log_enable=1";
                }
                Class.forName("virtuoso.jdbc4.Driver");
                this.connection = DriverManager.getConnection((String)url, user, password);
            } else {
                this.pds.setServerName(this.url_hostlist);
                this.pds.setUser(user);
                this.pds.setPassword(password);
                this.pds.setCharset(charset);
                this.pds.setRoundrobin(this.roundrobin);
                PooledConnection pconn = this.pds.getPooledConnection();
                this.connection = pconn.getConnection();
                this.ds = this.pds;
            }
            ModelCom m = new ModelCom((Graph)this);
            TypeMapper tm = TypeMapper.getInstance();
            Driver drv = new Driver();
            if (drv.getMajorVersion() <= 3 && drv.getMinorVersion() < 72) {
                this.useReprepare = true;
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public XAResource getXAResource() {
        try {
            if (this.xa_resource == null) {
                this.xa_resource = this.xa_connection != null ? this.xa_connection.getXAResource() : null;
            }
            return this.xa_resource;
        }
        catch (SQLException e) {
            throw new JenaException((Throwable)e);
        }
    }

    public String getGraphName() {
        return this.graphName;
    }

    protected void setGraphName(String name) {
        this.graphName = name;
    }

    public String getGraphUrl() {
        return this.url_hostlist;
    }

    public String getGraphUser() {
        return this.user;
    }

    public String getGraphPassword() {
        return this.password;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getFetchSize() {
        return this.prefetchSize;
    }

    public void setFetchSize(int sz) {
        this.prefetchSize = sz;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int seconds) {
        this.queryTimeout = seconds;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int sz) {
        this.batchSize = sz;
    }

    public String getSparqlPrefix() {
        return this.sparqlPrefix;
    }

    public void setSparqlPrefix(String val) {
        this.sparqlPrefix = val;
    }

    public boolean getInsertBNodeAsVirtuosoIRI() {
        return this.insertBNodeAsVirtuosoIRI;
    }

    public void setInsertBNodeAsVirtuosoIRI(boolean v) {
        this.insertBNodeAsVirtuosoIRI = v;
    }

    public boolean getResetBNodesDictAfterCall() {
        return this.resetBNodesDictAfterCall;
    }

    public void setResetBNodesDictAfterCall(boolean v) {
        this.resetBNodesDictAfterCall = v;
    }

    public boolean getResetBNodesDictAfterCommit() {
        return this.resetBNodesDictAfterCommit;
    }

    public void setResetBNodesDictAfterCommit(boolean v) {
        this.resetBNodesDictAfterCommit = v;
    }

    public boolean getUseAdvancedDelete() {
        return this.useAdvancedDelete;
    }

    public void setUseAdvancedDelete(boolean v) {
        this.useAdvancedDelete = v;
    }

    public boolean getInsertStringLiteralAsSimple() {
        return this.insertStringLiteralAsSimple;
    }

    public void setInsertStringLiteralAsSimple(boolean v) {
        this.insertStringLiteralAsSimple = v;
    }

    public void setConcurrencyMode(int mode) throws JenaException {
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new IllegalArgumentException("Unsupported concurrency mode: " + mode);
        }
        this.concurencyMode = mode;
    }

    public int getConcurrencyMode() {
        return this.concurencyMode;
    }

    public int getCount() {
        return this.size();
    }

    public void remove(List triples) {
        this.delete(triples.iterator(), null);
    }

    public void remove(Triple t) {
        this.delete(t);
    }

    public boolean getReadFromAllGraphs() {
        return this.readFromAllGraphs;
    }

    public void setReadFromAllGraphs(boolean val) {
        this.readFromAllGraphs = val;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(String _ruleSet) {
        this.ruleSet = _ruleSet;
    }

    public String getMacroLib() {
        return this.macroLib;
    }

    public void setMacroLib(String _macroLib) {
        this.macroLib = _macroLib;
    }

    public boolean getSameAs() {
        return this.useSameAs;
    }

    public void setSameAs(boolean _sameAs) {
        this.useSameAs = _sameAs;
    }

    public void createRuleSet(String ruleSetName, String uriGraphRuleSet) {
        this.checkOpen();
        Statement st = null;
        try {
            st = this.createStatement(false);
            st.execute("rdfs_rule_set('" + ruleSetName + "', '" + uriGraphRuleSet + "')");
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void removeRuleSet(String ruleSetName, String uriGraphRuleSet) {
        this.checkOpen();
        Statement st = null;
        try {
            st = this.createStatement(false);
            st.execute("rdfs_rule_set('" + ruleSetName + "', '" + uriGraphRuleSet + "', 1)");
            st.close();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String escapeString(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c >= '\u0000' && c <= '\b' || c == '\u000b' || c == '\f' || c >= '\u000e' && c <= '\u001f' || c >= '\u007f' && c <= '\uffff') {
                sb.append("\\u");
                sb.append(VirtGraph.toHexString(c, 4));
                continue;
            }
            if (c >= '\u10000' && c <= '\u10ffff') {
                sb.append("\\U");
                sb.append(VirtGraph.toHexString(c, 8));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String toHexString(int decimal, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength);
        String hexVal = Integer.toHexString(decimal).toUpperCase();
        int nofZeros = stringLength - hexVal.length();
        for (int i = 0; i < nofZeros; ++i) {
            sb.append('0');
        }
        sb.append(hexVal);
        return sb.toString();
    }

    protected Statement createStatement(boolean isIUD) throws SQLException {
        this.checkOpen();
        Statement st = this.connection.createStatement(1003, this.getJdbcConcurrency(isIUD));
        if (this.queryTimeout > 0) {
            st.setQueryTimeout(this.queryTimeout);
        }
        st.setFetchSize(this.prefetchSize);
        return st;
    }

    protected PreparedStatement prepareStatement(String sql, boolean isIUD) throws SQLException {
        this.checkOpen();
        PreparedStatement st = this.connection.prepareStatement(sql, 1003, this.getJdbcConcurrency(isIUD));
        if (this.queryTimeout > 0) {
            st.setQueryTimeout(this.queryTimeout);
        }
        st.setFetchSize(this.prefetchSize);
        return st;
    }

    protected void appendSparqlPrefixes(StringBuilder sb, boolean isSelect) {
        if (this.ruleSet != null) {
            sb.append(" define input:inference '" + this.ruleSet + "'\n ");
        }
        if (this.macroLib != null) {
            sb.append(" define input:macro-lib <" + this.macroLib + ">\n ");
        }
        if (this.sparqlPrefix != null) {
            sb.append(this.sparqlPrefix);
            sb.append('\n');
        }
        if (this.useSameAs) {
            sb.append(" define input:same-as \"yes\"\n ");
        }
        sb.append('\n');
    }

    protected int getJdbcConcurrency(boolean isIUD) {
        if (isIUD) {
            switch (this.concurencyMode) {
                case 1: {
                    return 1008;
                }
                case 2: {
                    return 1009;
                }
            }
            return 1007;
        }
        return 1007;
    }

    static String BNode2String(Node n) {
        String ns = n.toString();
        if (ns.startsWith("_:nodeID://")) {
            return ns.substring(2);
        }
        return ns;
    }

    static String BNode2String_add(Node n) {
        return "_:" + n.toString().replace(':', '_').replace('-', 'z').replace('/', 'y');
    }

    public String Node2Str(Node n) {
        if (n.isURI()) {
            return "<" + String.valueOf(n) + ">";
        }
        if (n.isBlank()) {
            String ns = n.toString();
            if (ns.startsWith("_:nodeID://")) {
                return "`iri('" + ns.substring(2) + "')`";
            }
            return this.insertBNodeAsVirtuosoIRI ? "<" + VirtGraph.BNode2String(n) + ">" : VirtGraph.BNode2String(n);
        }
        if (n.isLiteral()) {
            boolean llang_exists = false;
            StringBuilder sb = new StringBuilder();
            sb.append("\"");
            sb.append(VirtGraph.escapeString(n.getLiteralLexicalForm()));
            sb.append("\"");
            String llang = n.getLiteralLanguage();
            if (llang != null && llang.length() > 0) {
                sb.append("@");
                sb.append(llang);
                llang_exists = true;
            }
            String ltype = n.getLiteralDatatypeURI();
            if (!(llang_exists || ltype == null || ltype.length() <= 0 || this.insertStringLiteralAsSimple && ltype.equals(xsd_string))) {
                sb.append("^^<");
                sb.append(ltype);
                sb.append(">");
            }
            return sb.toString();
        }
        return "<" + String.valueOf(n) + ">";
    }

    public String Node2Str(Node n, boolean inTriplePattern) {
        if (n.isURI()) {
            return "<" + String.valueOf(n) + ">";
        }
        if (n.isBlank()) {
            String ns = n.toString();
            if (ns.startsWith("_:nodeID://")) {
                return inTriplePattern ? "`iri('" + ns.substring(2) + "')`" : "iri('" + ns.substring(2) + "')";
            }
            return this.insertBNodeAsVirtuosoIRI ? "<" + VirtGraph.BNode2String(n) + ">" : VirtGraph.BNode2String(n);
        }
        if (n.isLiteral()) {
            boolean llang_exists = false;
            StringBuilder sb = new StringBuilder();
            sb.append("\"");
            sb.append(VirtGraph.escapeString(n.getLiteralLexicalForm()));
            sb.append("\"");
            String llang = n.getLiteralLanguage();
            if (llang != null && llang.length() > 0) {
                sb.append("@");
                sb.append(llang);
                llang_exists = true;
            }
            String ltype = n.getLiteralDatatypeURI();
            if (!(llang_exists || ltype == null || ltype.length() <= 0 || this.insertStringLiteralAsSimple && ltype.equals(xsd_string))) {
                sb.append("^^<");
                sb.append(ltype);
                sb.append(">");
            }
            return sb.toString();
        }
        return "<" + String.valueOf(n) + ">";
    }

    public String Node2Str_add(Object o) {
        if (o instanceof Node) {
            Node n = (Node)o;
            if (n.isURI()) {
                return "<" + String.valueOf(n) + ">";
            }
            if (n.isBlank()) {
                if (!this.insertBNodeAsVirtuosoIRI) {
                    return VirtGraph.BNode2String_add(n);
                }
                return "<" + VirtGraph.BNode2String_add(n) + ">";
            }
            if (n.isLiteral()) {
                boolean llang_exists = false;
                StringBuilder sb = new StringBuilder();
                sb.append("\"");
                sb.append(VirtGraph.escapeString(n.getLiteralLexicalForm()));
                sb.append("\"");
                String llang = n.getLiteralLanguage();
                if (llang != null && llang.length() > 0) {
                    sb.append("@");
                    sb.append(llang);
                    llang_exists = true;
                }
                String ltype = n.getLiteralDatatypeURI();
                if (!(llang_exists || ltype == null || ltype.length() <= 0 || this.insertStringLiteralAsSimple && ltype.equals(xsd_string))) {
                    sb.append("^^<");
                    sb.append(ltype);
                    sb.append(">");
                }
                return sb.toString();
            }
            return "<" + String.valueOf(n) + ">";
        }
        return o.toString();
    }

    void bindSubject(PreparedStatement ps, int col, Node n) throws SQLException {
        if (n == null) {
            return;
        }
        if (n.isURI()) {
            ps.setString(col, n.toString());
        } else if (n.isBlank()) {
            ps.setString(col, VirtGraph.BNode2String(n));
        } else {
            throw new SQLException("Only URI or Blank nodes can be used as subject");
        }
    }

    void bindPredicate(PreparedStatement ps, int col, Node n) throws SQLException {
        if (n == null) {
            return;
        }
        if (!n.isURI()) {
            throw new SQLException("Only URI nodes can be used as predicate");
        }
        ps.setString(col, n.toString());
    }

    void bindObject(PreparedStatement ps, int col, Node n) throws SQLException {
        if (n == null) {
            return;
        }
        if (n.isURI()) {
            ps.setInt(col, 1);
            ps.setString(col + 1, n.toString());
            ps.setNull(col + 2, 12);
        } else if (n.isBlank()) {
            ps.setInt(col, 1);
            ps.setString(col + 1, VirtGraph.BNode2String(n));
            ps.setNull(col + 2, 12);
        } else if (n.isLiteral()) {
            String llang = n.getLiteralLanguage();
            String ltype = n.getLiteralDatatypeURI();
            if (llang != null && llang.length() > 0) {
                ps.setInt(col, 5);
                ps.setString(col + 1, n.getLiteralLexicalForm());
                ps.setString(col + 2, n.getLiteralLanguage());
            } else if (ltype != null && ltype.length() > 0) {
                if (!this.insertStringLiteralAsSimple || !ltype.equals(xsd_string)) {
                    ps.setInt(col, 4);
                    ps.setString(col + 1, n.getLiteralLexicalForm());
                    ps.setString(col + 2, n.getLiteralDatatypeURI());
                } else {
                    ps.setInt(col, 3);
                    ps.setString(col + 1, n.getLiteralLexicalForm());
                    ps.setNull(col + 2, 12);
                }
            } else {
                ps.setInt(col, 3);
                ps.setString(col + 1, n.getLiteralLexicalForm());
                ps.setNull(col + 2, 12);
            }
        } else {
            ps.setInt(col, 3);
            ps.setString(col + 1, n.toString());
            ps.setNull(col + 2, 12);
        }
    }

    public void performAdd(Triple t) {
        this.performAdd(null, t.getSubject(), t.getPredicate(), t.getObject());
    }

    protected void performAdd(String _gName, Triple t) {
        this.performAdd(_gName, t.getSubject(), t.getPredicate(), t.getObject());
    }

    protected void performAdd(String _gName, Node nS, Node nP, Node nO) {
        _gName = _gName != null ? _gName : this.graphName;
        Statement st = null;
        Statement ps = null;
        try {
            if (this.batch_add_executed) {
                this.psInsert = this.addToQuadStore_batch(this.psInsert, nS, nP, nO, _gName);
                ++this.psInsert_Count;
                if (this.psInsert_Count >= this.batchSize) {
                    this.psInsert = this.flushDelayAdd_batch(this.psInsert, this.psInsert_Count);
                    this.psInsert_Count = 0;
                }
            } else {
                boolean isAutocommit = this.connection.getAutoCommit();
                if (this.insertBNodeAsVirtuosoIRI || this.resetBNodesDictAfterCall || isAutocommit) {
                    st = this.createStatement(true);
                    StringBuilder data = new StringBuilder(1024);
                    data.append("sparql insert into <");
                    data.append(_gName);
                    data.append("> { ");
                    data.append(this.Node2Str_add(nS));
                    data.append(' ');
                    data.append(this.Node2Str_add(nP));
                    data.append(' ');
                    data.append(this.Node2Str_add(nO));
                    data.append(" .}");
                    st.execute(data.toString());
                } else {
                    this.createBNodesDict();
                    ps = this.prepareStatement(S_BATCH_INSERT, true);
                    this.bindBatchParams((PreparedStatement)ps, nS, nP, nO, _gName);
                    ps.execute();
                }
            }
        }
        catch (Exception e) {
            throw new AddDeniedException((Throwable)e);
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void performDelete(Triple t) {
        this.performDelete(null, t.getSubject(), t.getPredicate(), t.getObject());
    }

    protected void performDelete(String _gName, Node s, Node p, Node o) {
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(S_BATCH_DELETE, true);
            this.bindBatchParams(ps, s, p, o, _gName != null ? _gName : this.graphName);
            ps.execute();
        }
        catch (Exception e) {
            throw new DeleteDeniedException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected int graphBaseSize() {
        StringBuilder sb = new StringBuilder("select count(*) from (sparql define input:storage \"\" ");
        this.appendSparqlPrefixes(sb, true);
        if (this.readFromAllGraphs) {
            sb.append(" select * where {?s ?p ?o })f");
        } else {
            sb.append(" select * where { graph `iri(??)` { ?s ?p ?o }})f");
        }
        ResultSet rs = null;
        int ret = 0;
        this.checkOpen();
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sb.toString(), false);
            if (!this.readFromAllGraphs) {
                ps.setString(1, this.graphName);
            }
            if ((rs = ps.executeQuery()).next()) {
                ret = rs.getInt(1);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    protected boolean graphBaseContains(Triple t) {
        return this.graphBaseContains(null, t);
    }

    protected boolean graphBaseContains(String _gName, Triple t) {
        ResultSet rs = null;
        StringBuilder sb = new StringBuilder("sparql define input:storage \"\" ");
        this.checkOpen();
        this.appendSparqlPrefixes(sb, true);
        if (this.readFromAllGraphs && _gName == null) {
            sb.append(" select * where { ");
        } else {
            sb.append(" select * from <" + (_gName != null ? _gName : this.graphName) + "> where { ");
        }
        Node nS = t.getSubject();
        Node nP = t.getPredicate();
        Node nO = t.getObject();
        if (nP.isBlank()) {
            throw new JenaException("BNode could not be used as Predicate");
        }
        sb.append(' ');
        if (!Node.ANY.equals((Object)nS)) {
            sb.append("`iri(??)`");
        } else {
            sb.append("?s");
        }
        sb.append(' ');
        if (!Node.ANY.equals((Object)nP)) {
            sb.append("`iri(??)`");
        } else {
            sb.append("?p");
        }
        sb.append(' ');
        if (!Node.ANY.equals((Object)nO)) {
            sb.append("`bif:__rdf_long_from_batch_params(??,??,??)`");
        } else {
            sb.append("?o");
        }
        sb.append(" } limit 1");
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sb.toString(), false);
            int col = 1;
            if (!Node.ANY.equals((Object)nS)) {
                this.bindSubject(ps, col++, nS);
            }
            if (!Node.ANY.equals((Object)nP)) {
                this.bindPredicate(ps, col++, nP);
            }
            if (!Node.ANY.equals((Object)nO)) {
                this.bindObject(ps, col, nO);
            }
            rs = ps.executeQuery();
            boolean ret = rs.next();
            rs.close();
            boolean bl = ret;
            return bl;
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public ExtendedIterator<Triple> graphBaseFind(Triple tm) {
        return this.graphBaseFind(null, tm);
    }

    protected ExtendedIterator<Triple> graphBaseFind(String _gName, Triple tm) {
        StringBuilder sb = new StringBuilder("sparql ");
        this.checkOpen();
        this.appendSparqlPrefixes(sb, true);
        if (this.readFromAllGraphs && _gName == null) {
            sb.append(" select * where { ");
        } else {
            sb.append(" select * from <" + (_gName != null ? _gName : this.graphName) + "> where { ");
        }
        Node nS = tm.getMatchSubject();
        Node nP = tm.getMatchPredicate();
        Node nO = tm.getMatchObject();
        if (nP != null && nP.isBlank()) {
            throw new JenaException("BNode could not be used as Predicate");
        }
        sb.append(' ');
        if (nS != null) {
            sb.append("`iri(??)`");
        } else {
            sb.append("?s");
        }
        sb.append(' ');
        if (nP != null) {
            sb.append("`iri(??)`");
        } else {
            sb.append("?p");
        }
        sb.append(' ');
        if (nO != null) {
            sb.append("`bif:__rdf_long_from_batch_params(??,??,??)`");
        } else {
            sb.append("?o");
        }
        sb.append(" }");
        try {
            PreparedStatement ps = this.prepareStatement(sb.toString(), false);
            int col = 1;
            if (nS != null) {
                this.bindSubject(ps, col++, nS);
            }
            if (nP != null) {
                this.bindPredicate(ps, col++, nP);
            }
            if (nO != null) {
                this.bindObject(ps, col, nO);
            }
            return new VirtResSetIter(this, ps, ps.executeQuery(), tm);
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public void close() {
        try {
            super.close();
            if (this.connection != null) {
                if (this.parent_dataset != null) {
                    this.parent_dataset.removeLink(this);
                } else {
                    this.connection.close();
                }
            }
            this.connection = null;
            this.xa_connection = null;
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public void clear() {
        this.clear(NodeFactory.createURI((String)this.graphName));
        this.getEventManager().notifyEvent((Graph)this, (Object)GraphEvents.removeAll);
    }

    public void clear(Node ... graphs) {
        Statement st = null;
        if (graphs != null && graphs.length > 0) {
            try {
                st = this.createStatement(true);
                for (int i = 0; i < graphs.length; ++i) {
                    st.addBatch("sparql clear graph <" + graphs[i].toString() + ">");
                }
                st.executeBatch();
                st.clearBatch();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void read(String url, String type) {
        StringBuilder sb = new StringBuilder("sparql \n");
        this.appendSparqlPrefixes(sb, false);
        sb.append("load \"" + url + "\" into graph <" + this.graphName + ">");
        this.checkOpen();
        Statement st = null;
        try {
            st = this.createStatement(true);
            st.execute(sb.toString());
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createBNodesDict() throws SQLException {
        Object object = this.lck_add;
        synchronized (object) {
            Statement st = null;
            try {
                if (this.isBNodesDictCreated) {
                    return;
                }
                if (this.insertBNodeAsVirtuosoIRI) return;
                st = this.createStatement(false);
                st.executeUpdate("connection_set ('RDF_INSERT_TRIPLE_C_BNODES', dict_new(1000))");
                this.isBNodesDictCreated = true;
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception exception) {}
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dropBNodesDict() throws SQLException {
        Object object = this.lck_add;
        synchronized (object) {
            Statement st = null;
            try {
                if (!this.isBNodesDictCreated) {
                    return;
                }
                st = this.createStatement(false);
                st.executeUpdate("connection_set ('RDF_INSERT_TRIPLE_C_BNODES', NULL)");
                this.isBNodesDictCreated = false;
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception exception) {}
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startBatchAdd() throws SQLException {
        Object object = this.lck_add;
        synchronized (object) {
            if (this.batch_add_executed) {
                throw new JenaException("Batch mode is started already");
            }
            this.batch_add_executed = true;
            this.createBNodesDict();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopBatchAdd() throws SQLException {
        Object object = this.lck_add;
        synchronized (object) {
            if (!this.batch_add_executed) {
                return;
            }
            try {
                if (this.psInsert != null && this.psInsert_Count > 0) {
                    this.psInsert.executeBatch();
                    this.psInsert.clearBatch();
                    this.psInsert_Count = 0;
                }
                if (this.resetBNodesDictAfterCall) {
                    this.dropBNodesDict();
                }
            }
            finally {
                if (this.psInsert != null) {
                    try {
                        this.psInsert.close();
                    }
                    catch (Exception exception) {}
                }
                this.psInsert = null;
                this.batch_add_executed = false;
            }
        }
    }

    private synchronized PreparedStatement addToQuadStore_batch(PreparedStatement ps, Node subject, Node predicate, Node object, String _gName) throws SQLException {
        if (ps == null) {
            ps = this.prepareStatement(S_BATCH_INSERT, true);
        }
        this.bindBatchParams(ps, subject, predicate, object, _gName);
        ps.addBatch();
        return ps;
    }

    private synchronized PreparedStatement flushDelayAdd_batch(PreparedStatement ps, int psCount) throws SQLException {
        if (psCount > 0 && ps != null) {
            ps.executeBatch();
            ps.clearBatch();
            if (this.useReprepare) {
                try {
                    ps.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ps = null;
            }
        }
        return ps;
    }

    void performAdd_batch(String _gName, Node nS, Node nP, Node nO) throws SQLException {
        _gName = _gName != null ? _gName : this.graphName;
        this.psInsert = this.addToQuadStore_batch(this.psInsert, nS, nP, nO, _gName);
        ++this.psInsert_Count;
        if (this.psInsert_Count >= this.batchSize) {
            this.psInsert = this.flushDelayAdd_batch(this.psInsert, this.psInsert_Count);
            this.psInsert_Count = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(String _gName, Iterator<Triple> it, List<Triple> list) {
        Object object = this.lck_add;
        synchronized (object) {
            _gName = _gName != null ? _gName : this.graphName;
            this.checkOpen();
            try {
                this.startBatchAdd();
                while (it.hasNext()) {
                    Triple t = it.next();
                    if (list != null) {
                        list.add(t);
                    }
                    Node nS = t.getSubject();
                    Node nP = t.getPredicate();
                    Node nO = t.getObject();
                    this.performAdd_batch(_gName, nS, nP, nO);
                }
                this.flushDelayAdd_batch(this.psInsert, this.psInsert_Count);
                this.psInsert_Count = 0;
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            finally {
                try {
                    this.stopBatchAdd();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(String _gName, Iterator<org.apache.jena.rdf.model.Statement> it) {
        Object object = this.lck_add;
        synchronized (object) {
            _gName = _gName != null ? _gName : this.graphName;
            this.checkOpen();
            try {
                this.startBatchAdd();
                while (it.hasNext()) {
                    org.apache.jena.rdf.model.Statement t = it.next();
                    Node nS = t.getSubject().asNode();
                    Node nP = t.getPredicate().asNode();
                    Node nO = t.getObject().asNode();
                    this.performAdd_batch(_gName, nS, nP, nO);
                }
                this.flushDelayAdd_batch(this.psInsert, this.psInsert_Count);
                this.psInsert_Count = 0;
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            finally {
                try {
                    this.stopBatchAdd();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamAdd(String _gName, Iterator<Triple> it) {
        Object object = this.lck_add;
        synchronized (object) {
            _gName = _gName != null ? _gName : this.graphName;
            this.checkOpen();
            try {
                while (it.hasNext()) {
                    Triple t = it.next();
                    Node nS = t.getSubject();
                    Node nP = t.getPredicate();
                    Node nO = t.getObject();
                    this.performAdd_batch(_gName, nS, nP, nO);
                }
                this.psInsert = this.flushDelayAdd_batch(this.psInsert, this.psInsert_Count);
                this.psInsert_Count = 0;
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamAdd(Iterator<Quad> it) {
        Object object = this.lck_add;
        synchronized (object) {
            this.checkOpen();
            try {
                while (it.hasNext()) {
                    Quad q = it.next();
                    String _gName = q.getGraph() == null ? this.graphName : q.getGraph().toString();
                    Node nS = q.getSubject();
                    Node nP = q.getPredicate();
                    Node nO = q.getObject();
                    this.performAdd_batch(_gName, nS, nP, nO);
                }
                this.psInsert = this.flushDelayAdd_batch(this.psInsert, this.psInsert_Count);
                this.psInsert_Count = 0;
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
        }
    }

    void delete(Iterator<Triple> it, List<Triple> list) {
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(S_BATCH_DELETE, true);
            int count = 0;
            while (it.hasNext()) {
                Triple t = it.next();
                if (list != null) {
                    list.add(t);
                }
                this.bindBatchParams(ps, t.getSubject(), t.getPredicate(), t.getObject(), this.graphName);
                ps.addBatch();
                if (++count <= this.batchSize) continue;
                ps.executeBatch();
                ps.clearBatch();
                count = 0;
                if (!this.useReprepare) continue;
                try {
                    ps.close();
                    ps = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ps = this.prepareStatement(S_BATCH_DELETE, true);
            }
            if (count > 0) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void delete(String _gName, Iterator<org.apache.jena.rdf.model.Statement> it) {
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(S_BATCH_DELETE, true);
            int count = 0;
            while (it.hasNext()) {
                org.apache.jena.rdf.model.Statement t = it.next();
                this.bindBatchParams(ps, t.getSubject().asNode(), t.getPredicate().asNode(), t.getObject().asNode(), _gName);
                ps.addBatch();
                if (++count <= this.batchSize) continue;
                ps.executeBatch();
                ps.clearBatch();
                count = 0;
                if (!this.useReprepare) continue;
                try {
                    ps.close();
                    ps = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ps = this.prepareStatement(S_BATCH_DELETE, true);
            }
            if (count > 0) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void md_delete_Model(StmtIterator it) {
        if (this.useAdvancedDelete) {
            LinkedList<DelItem> lst = new LinkedList<DelItem>();
            LinkedList<DelItem> cmd = new LinkedList<DelItem>();
            while (it.hasNext()) {
                org.apache.jena.rdf.model.Statement st = it.nextStatement();
                Node s = st.getSubject().asNode();
                Node p = st.getPredicate().asNode();
                Node o = st.getObject().asNode();
                if (!(s.isBlank() || p.isBlank() || o.isBlank())) {
                    cmd.add(new DelItem(s, p, o));
                    continue;
                }
                lst.add(new DelItem(s, p, o));
            }
            it.close();
            this.md_apply_delete_n(cmd);
            cmd.clear();
            while (lst.size() > 0) {
                HashMap<String, String> bnodes = new HashMap<String, String>();
                DelItem i = (DelItem)lst.removeFirst();
                this.md_load_Bnodes(bnodes, i);
                cmd.add(i);
                boolean added = false;
                do {
                    Iterator iter = lst.iterator();
                    added = false;
                    while (iter.hasNext()) {
                        i = (DelItem)iter.next();
                        if (!this.md_check_Item(bnodes, i)) continue;
                        cmd.add(i);
                        iter.remove();
                        added = true;
                    }
                } while (added);
                this.md_apply_delete(cmd, bnodes, false);
                cmd.clear();
            }
        } else {
            this.delete(this.graphName, (Iterator<org.apache.jena.rdf.model.Statement>)it);
        }
    }

    void md_load_Bnodes(HashMap<String, String> bnodes, DelItem i) {
        String s;
        if (i.s.isBlank()) {
            s = i.s.toString();
            bnodes.put(s, s);
        }
        if (i.p.isBlank()) {
            s = i.p.toString();
            bnodes.put(s, s);
        }
        if (i.o.isBlank()) {
            s = i.o.toString();
            bnodes.put(s, s);
        }
    }

    boolean md_check_Item(HashMap<String, String> bnodes, DelItem i) {
        boolean add = false;
        if (i.s.isBlank() && bnodes.containsKey(i.s.toString())) {
            add = true;
        }
        if (i.p.isBlank() && bnodes.containsKey(i.p.toString())) {
            add = true;
        }
        if (i.o.isBlank() && bnodes.containsKey(i.o.toString())) {
            add = true;
        }
        if (add) {
            this.md_load_Bnodes(bnodes, i);
        }
        return add;
    }

    void md_apply_delete_n(LinkedList<DelItem> cmd) {
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(S_BATCH_DELETE, true);
            int count = 0;
            for (DelItem it : cmd) {
                this.bindBatchParams(ps, it.s, it.p, it.o, this.graphName);
                ps.addBatch();
                if (++count <= this.batchSize) continue;
                ps.executeBatch();
                ps.clearBatch();
                count = 0;
                if (!this.useReprepare) continue;
                try {
                    ps.close();
                    ps = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ps = this.prepareStatement(S_BATCH_DELETE, true);
            }
            if (count > 0) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    void md_apply_delete(LinkedList<DelItem> cmd, HashMap<String, String> bnodes, boolean splitCmdData) {
        String del_start = null;
        int id = 0;
        for (String key : bnodes.keySet()) {
            bnodes.put(key, "?a" + id);
            ++id;
        }
        del_start = "sparql DELETE WHERE { GRAPH <";
        Statement stmt = null;
        int count = 0;
        StringBuilder data = new StringBuilder(256);
        data.append(del_start);
        data.append(this.graphName);
        data.append("> { ");
        try {
            stmt = this.createStatement(true);
            for (DelItem it : cmd) {
                StringBuilder row = new StringBuilder(256);
                if (it.s.isBlank()) {
                    row.append(bnodes.get(it.s.toString()));
                } else {
                    row.append(this.Node2Str(it.s));
                }
                row.append(' ');
                if (it.p.isBlank()) {
                    row.append(bnodes.get(it.p.toString()));
                } else {
                    row.append(this.Node2Str(it.p));
                }
                row.append(' ');
                if (it.o.isBlank()) {
                    row.append(bnodes.get(it.o.toString()));
                } else {
                    row.append(this.Node2Str(it.o));
                }
                row.append(" .\n");
                if (splitCmdData && count > 0 && data.length() + row.length() > 36000) {
                    data.append(" }}");
                    stmt.execute(data.toString());
                    data.setLength(0);
                    data.append(del_start);
                    data.append(this.graphName);
                    data.append("> { ");
                    count = 0;
                }
                data.append((CharSequence)row);
                ++count;
            }
            if (count > 0) {
                data.append(" }}");
                stmt.execute(data.toString());
            }
        }
        catch (Exception e) {
            throw new JenaException(data.toString(), (Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void bindBatchParams(PreparedStatement ps, Node subject, Node predicate, Node object, String _graphName) throws SQLException {
        int flags = 0;
        flags |= subject.isBlank() && !subject.toString().startsWith("_:nodeID://") ? 256 : 0;
        flags |= object.isBlank() && !object.toString().startsWith("_:nodeID://") ? 512 : 0;
        ps.setString(1, subject.isBlank() ? VirtGraph.BNode2String(subject) : subject.toString());
        ps.setString(2, predicate.toString());
        if (object.isURI()) {
            ps.setString(3, object.toString());
            ps.setNull(4, 12);
        } else if (object.isBlank()) {
            ps.setString(3, VirtGraph.BNode2String(object));
            ps.setNull(4, 12);
        } else if (object.isLiteral()) {
            ps.setString(3, object.getLiteralLexicalForm());
            String s_lang = object.getLiteralLanguage();
            String s_type = object.getLiteralDatatypeURI();
            if (s_lang != null && s_lang.length() > 0) {
                ps.setString(4, s_lang);
                flags |= 2;
            } else if (s_type != null && s_type.length() > 0) {
                if (this.insertStringLiteralAsSimple && s_type.equals(xsd_string)) {
                    ps.setNull(4, 12);
                    flags |= 1;
                } else {
                    ps.setString(4, s_type);
                    flags = s_type.equals("http://www.w3.org/2001/XMLSchema#integer") ? (flags |= 5) : (s_type.equals("http://www.w3.org/2001/XMLSchema#float") ? (flags |= 6) : (s_type.equals("http://www.w3.org/2001/XMLSchema#double") ? (flags |= 7) : (s_type.equals("http://www.w3.org/2001/XMLSchema#decimal") ? (flags |= 8) : (flags |= 3))));
                }
            } else {
                ps.setNull(4, 12);
                flags |= 1;
            }
        } else {
            ps.setString(3, object.toString());
            ps.setNull(4, 12);
        }
        ps.setInt(5, flags);
        ps.setString(6, _graphName);
    }

    void delete_match(Triple tm) {
        this.delete_match(null, tm);
    }

    void delete_match(String _gName, Triple tm) {
        Statement ps = null;
        this.checkOpen();
        Node nS = tm.getMatchSubject();
        Node nP = tm.getMatchPredicate();
        Node nO = tm.getMatchObject();
        if (nP != null && nP.isBlank()) {
            throw new DeleteDeniedException("BNode could not be used as Predicate");
        }
        try {
            if (nS == null && nP == null && nO == null) {
                String gr = _gName != null ? _gName : this.graphName;
                this.clear(NodeFactory.createURI((String)gr));
            } else if (nS != null && nP != null && nO != null) {
                ps = this.prepareStatement(S_BATCH_DELETE, true);
                this.bindBatchParams((PreparedStatement)ps, nS, nP, nO, _gName != null ? _gName : this.graphName);
                ps.execute();
            } else {
                StringBuilder stm = new StringBuilder();
                stm.append(' ');
                if (nS != null) {
                    stm.append("`iri(??)`");
                } else {
                    stm.append("?s");
                }
                stm.append(' ');
                if (nP != null) {
                    stm.append("`iri(??)`");
                } else {
                    stm.append("?p");
                }
                stm.append(' ');
                if (nO != null) {
                    stm.append("`bif:__rdf_long_from_batch_params(??,??,??)`");
                } else {
                    stm.append("?o");
                }
                StringBuilder sb = new StringBuilder();
                sb.append("sparql ");
                this.appendSparqlPrefixes(sb, false);
                sb.append("delete from <");
                sb.append(_gName != null ? _gName : this.graphName);
                sb.append("> { ");
                sb.append(stm.toString());
                sb.append(" } where { ");
                sb.append(stm.toString());
                sb.append(" }");
                ps = this.prepareStatement(sb.toString(), true);
                int col = 1;
                if (nS != null) {
                    this.bindSubject((PreparedStatement)ps, col++, nS);
                }
                if (nP != null) {
                    this.bindPredicate((PreparedStatement)ps, col++, nP);
                }
                if (nO != null) {
                    this.bindObject((PreparedStatement)ps, col, nO);
                    col += 3;
                }
                if (nS != null) {
                    this.bindSubject((PreparedStatement)ps, col++, nS);
                }
                if (nP != null) {
                    this.bindPredicate((PreparedStatement)ps, col++, nP);
                }
                if (nO != null) {
                    this.bindObject((PreparedStatement)ps, col, nO);
                }
                ps.execute();
            }
        }
        catch (Exception e) {
            throw new DeleteDeniedException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public ExtendedIterator reifierTriples(Triple m) {
        return NiceIterator.emptyIterator();
    }

    public int reifierSize() {
        return 0;
    }

    public VirtTransactionHandler getTransactionHandler() {
        if (this.tranHandler == null) {
            this.tranHandler = new VirtTransactionHandler(this);
        }
        return this.tranHandler;
    }

    public PrefixMapping getPrefixMapping() {
        if (this.m_prefixMapping == null) {
            this.m_prefixMapping = new VirtPrefixMapping(this);
        }
        return this.m_prefixMapping;
    }

    public static Node Object2Node(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ExtendedString) {
            ExtendedString vs = (ExtendedString)o;
            if (vs.getIriType() == 1 && (vs.getStrType() & 1) == 1) {
                if (vs.toString().indexOf("_:") == 0) {
                    return NodeFactory.createBlankNode((String)vs.toString().substring(2));
                }
                return NodeFactory.createURI((String)vs.toString());
            }
            if (vs.getIriType() == 2) {
                return NodeFactory.createBlankNode((String)vs.toString());
            }
            return NodeFactory.createLiteralString((String)vs.toString());
        }
        if (o instanceof RdfBox) {
            RdfBox rb = (RdfBox)o;
            String rb_type = rb.getType();
            RDFDatatype dt = null;
            String rb_val = rb.toString();
            if (rb_type != null) {
                dt = TypeMapper.getInstance().getSafeTypeByName(rb_type);
                if (rb_val.length() == 1 && (rb_val.charAt(0) == '1' || rb_val.charAt(0) == '0') && rb_type.equals("http://www.w3.org/2001/XMLSchema#boolean")) {
                    return NodeFactory.createLiteral((String)(rb_val.charAt(0) == '1' ? "true" : "false"), (String)rb.getLang(), (RDFDatatype)dt);
                }
            }
            return NodeFactory.createLiteral((String)rb_val, (String)rb.getLang(), (RDFDatatype)dt);
        }
        if (o instanceof Long) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#long");
            return NodeFactory.createLiteral((String)o.toString(), null, (RDFDatatype)dt);
        }
        if (o instanceof Integer) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#integer");
            return NodeFactory.createLiteral((String)o.toString(), null, (RDFDatatype)dt);
        }
        if (o instanceof Short) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#integer");
            return NodeFactory.createLiteral((String)o.toString(), null, (RDFDatatype)dt);
        }
        if (o instanceof Float) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#float");
            return NodeFactory.createLiteral((String)o.toString(), null, (RDFDatatype)dt);
        }
        if (o instanceof Double) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#double");
            return NodeFactory.createLiteral((String)o.toString(), null, (RDFDatatype)dt);
        }
        if (o instanceof BigDecimal) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#decimal");
            return NodeFactory.createLiteral((String)o.toString(), null, (RDFDatatype)dt);
        }
        if (o instanceof Blob) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#hexBinary");
            return NodeFactory.createLiteral((String)o.toString(), null, (RDFDatatype)dt);
        }
        if (o instanceof VirtuosoDate) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#date");
            return NodeFactory.createLiteral((String)((VirtuosoDate)o).toXSD_String(), null, (RDFDatatype)dt);
        }
        if (o instanceof VirtuosoTimestamp) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#dateTime");
            return NodeFactory.createLiteral((String)((VirtuosoTimestamp)o).toXSD_String(), null, (RDFDatatype)dt);
        }
        if (o instanceof VirtuosoTime) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#time");
            return NodeFactory.createLiteral((String)((VirtuosoTime)o).toXSD_String(), null, (RDFDatatype)dt);
        }
        if (o instanceof Date) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#date");
            return NodeFactory.createLiteral((String)o.toString(), null, (RDFDatatype)dt);
        }
        if (o instanceof Timestamp) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#dateTime");
            return NodeFactory.createLiteral((String)VirtGraph.Timestamp2String((Timestamp)o), null, (RDFDatatype)dt);
        }
        if (o instanceof Time) {
            RDFDatatype dt = null;
            dt = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#time");
            return NodeFactory.createLiteral((String)o.toString(), null, (RDFDatatype)dt);
        }
        return NodeFactory.createLiteralString((String)o.toString());
    }

    private static String Timestamp2String(Timestamp v) {
        Object nanosString;
        GregorianCalendar cal = new GregorianCalendar();
        int timezone = cal.get(15) / 60000;
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String zeros = "000000000";
        int nanos = v.getNanos();
        sb.append(formatter.format(v));
        if (nanos == 0) {
            nanosString = "";
        } else {
            nanosString = Integer.toString(nanos);
            nanosString = zeros.substring(0, 9 - ((String)nanosString).length()) + (String)nanosString;
            char[] nanosChar = new char[((String)nanosString).length()];
            ((String)nanosString).getChars(0, ((String)nanosString).length(), nanosChar, 0);
            int truncIndex = 8;
            while (nanosChar[truncIndex] == '0') {
                --truncIndex;
            }
            nanosString = new String(nanosChar, 0, truncIndex + 1);
        }
        if (((String)nanosString).length() > 0) {
            sb.append(".");
            sb.append((String)nanosString);
        }
        sb.append(timezone > 0 ? (char)'+' : '-');
        int tz = Math.abs(timezone);
        int tzh = tz / 60;
        int tzm = tz % 60;
        if (tzh < 10) {
            sb.append('0');
        }
        sb.append(tzh);
        sb.append(':');
        if (tzm < 10) {
            sb.append('0');
        }
        sb.append(tzm);
        return sb.toString();
    }

    static {
        VirtuosoQueryEngine.register();
    }

    class DelItem {
        Node s;
        Node p;
        Node o;

        DelItem(Node _s, Node _p, Node _o) {
            this.s = _s;
            this.p = _p;
            this.o = _o;
        }
    }
}

