/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class VirtuosoDate
extends Date {
    int timezone = 0;
    boolean with_timezone = false;

    public VirtuosoDate(long date) {
        super(date);
    }

    public VirtuosoDate(long date, int tz) {
        super(date);
        this.timezone = tz;
        this.with_timezone = true;
    }

    public VirtuosoDate(long date, int tz, boolean with_tz) {
        super(date);
        this.timezone = tz;
        this.with_timezone = with_tz;
    }

    public boolean withTimezone() {
        return this.with_timezone;
    }

    public int getTimezone() {
        return this.timezone;
    }

    @Override
    public VirtuosoDate clone() {
        return new VirtuosoDate(this.getTime(), this.timezone, this.with_timezone);
    }

    public String toXSD_String() {
        SimpleDateFormat formatter;
        StringBuilder sb = new StringBuilder();
        String timeZoneString = null;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this);
        if (cal.get(0) == 0) {
            sb.append('-');
            formatter = new SimpleDateFormat("yyy-MM-dd");
        } else {
            formatter = new SimpleDateFormat("yyyy-MM-dd");
        }
        if (this.with_timezone) {
            StringBuilder s = new StringBuilder();
            s.append(this.timezone > 0 ? (char)'+' : '-');
            int tz = Math.abs(this.timezone);
            int tzh = tz / 60;
            int tzm = tz % 60;
            if (tzh < 10) {
                s.append('0');
            }
            s.append(tzh);
            s.append(':');
            if (tzm < 10) {
                s.append('0');
            }
            s.append(tzm);
            timeZoneString = s.toString();
            formatter.setTimeZone(TimeZone.getTimeZone("GMT" + timeZoneString));
        }
        sb.append(formatter.format(this));
        if (this.with_timezone && this.timezone != 0) {
            sb.append(timeZoneString);
        }
        return sb.toString();
    }
}

