/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import virtuoso.jdbc4.CallableStatementWrapper;
import virtuoso.jdbc4.Closeable;
import virtuoso.jdbc4.PreparedStatementWrapper;
import virtuoso.jdbc4.StatementWrapper;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoPooledConnection;
import virtuoso.jdbc4.VirtuosoXAResource;

public class ConnectionWrapper
implements Connection {
    private VirtuosoXAResource r_XAResource;
    private Boolean r_AutoCommit;
    private Boolean r_ReadOnly;
    private String r_Catalog;
    private Integer r_TxnIsolation;
    private Integer r_Holdability;
    private HashMap<Object, Object> objsToClose;
    private boolean isClosed = false;
    private volatile Connection rconn;
    private VirtuosoPooledConnection pconn;

    public ConnectionWrapper(Connection rConn, VirtuosoPooledConnection pConn) {
        this.rconn = rConn;
        this.pconn = pConn;
        this.objsToClose = new HashMap(100);
    }

    public void finalize() throws Throwable {
        VirtuosoPooledConnection pc = this.pconn;
        if (pc != null) {
            pc.sendCloseEvent();
        }
        this.pconn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.rconn == null || this.isClosed) {
            return;
        }
        ConnectionWrapper connectionWrapper = this;
        synchronized (connectionWrapper) {
            if (this.pconn != null) {
                this.pconn.sendCloseEvent();
            }
            this.isClosed = true;
            this.pconn = null;
        }
    }

    protected synchronized void closeAll() throws SQLException {
        this.close_objs();
        this.pconn = null;
        this.reset_XA();
        if (this.rconn != null && !this.rconn.isClosed()) {
            this.rconn.close();
        }
        this.rconn = null;
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            this.check_conn();
            return new StatementWrapper(this, this.rconn.createStatement());
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            this.check_conn();
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(sql));
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            this.check_conn();
            return new CallableStatementWrapper(this, this.rconn.prepareCall(sql));
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.nativeSQL(sql);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.check_conn();
            if (this.r_AutoCommit == null) {
                this.r_AutoCommit = this.getAutoCommit();
            }
            this.rconn.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getAutoCommit();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.check_conn();
            this.rconn.commit();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.check_conn();
            this.rconn.rollback();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rconn == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getMetaData();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.check_conn();
            if (this.r_ReadOnly == null) {
                this.r_ReadOnly = this.isReadOnly();
            }
            this.rconn.setReadOnly(readOnly);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.isReadOnly();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.check_conn();
            if (this.r_Catalog == null) {
                this.r_Catalog = this.getCatalog();
            }
            this.rconn.setCatalog(catalog);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getCatalog();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.check_conn();
            if (this.r_TxnIsolation == null) {
                this.r_TxnIsolation = this.getTransactionIsolation();
            }
            this.rconn.setTransactionIsolation(level);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getTransactionIsolation();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getWarnings();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.check_conn();
            this.rconn.clearWarnings();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.check_conn();
            return new StatementWrapper(this, this.rconn.createStatement(resultSetType, resultSetConcurrency));
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.check_conn();
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.check_conn();
            return new CallableStatementWrapper(this, this.rconn.prepareCall(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getTypeMap();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.check_conn();
        this.rconn.setTypeMap(map);
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getHoldability();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            this.check_conn();
            if (this.r_Holdability == null) {
                this.r_Holdability = this.getHoldability();
            }
            this.rconn.setHoldability(holdability);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.setSavepoint();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.setSavepoint(name);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.check_conn();
            this.rconn.rollback(savepoint);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.check_conn();
            this.rconn.releaseSavepoint(savepoint);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.check_conn();
            return new StatementWrapper(this, this.rconn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.check_conn();
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.check_conn();
            return new CallableStatementWrapper(this, this.rconn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int flag) throws SQLException {
        try {
            this.check_conn();
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(sql, flag));
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.check_conn();
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(sql, columnIndexes));
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            this.check_conn();
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(sql, columnNames));
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createClob();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createBlob();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createNClob();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createSQLXML();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.isValid(timeout);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.check_conn();
            this.rconn.setClientInfo(name, value);
        }
        catch (SQLClientInfoException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw new SQLClientInfoException(ex.getMessage(), ex.getSQLState(), null);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.check_conn();
            this.rconn.setClientInfo(properties);
        }
        catch (SQLClientInfoException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw new SQLClientInfoException(ex.getMessage(), ex.getSQLState(), null);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getClientInfo(name);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getClientInfo();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createArrayOf(typeName, elements);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createStruct(typeName, attributes);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.unwrap(iface);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.isWrapperFor(iface);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        try {
            this.check_conn();
            this.rconn.setSchema(schema);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getSchema();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            this.check_conn();
            this.rconn.abort(executor);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            this.check_conn();
            this.rconn.setNetworkTimeout(executor, milliseconds);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getNetworkTimeout();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    protected void setXAResource(VirtuosoXAResource val) {
        this.r_XAResource = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addObjToClose(Object obj) {
        HashMap<Object, Object> hashMap = this.objsToClose;
        synchronized (hashMap) {
            this.objsToClose.put(obj, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeObjFromClose(Object obj) {
        HashMap<Object, Object> hashMap = this.objsToClose;
        synchronized (hashMap) {
            this.objsToClose.remove(obj);
        }
    }

    protected synchronized void reset_XA() {
        if (this.rconn == null) {
            return;
        }
        if (this.r_XAResource != null) {
            this.r_XAResource.reset_XA();
        }
        this.r_XAResource = null;
    }

    protected synchronized void reset() {
        if (this.rconn == null) {
            return;
        }
        this.reset_XA();
        try {
            this.rconn.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.close_objs();
        if (this.r_AutoCommit != null) {
            try {
                this.rconn.setAutoCommit(this.r_AutoCommit);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.r_ReadOnly != null) {
            try {
                this.rconn.setReadOnly(this.r_ReadOnly);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.r_Catalog != null) {
            try {
                this.rconn.setCatalog(this.r_Catalog);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.r_TxnIsolation != null) {
            try {
                this.rconn.setTransactionIsolation(this.r_TxnIsolation);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            this.rconn.setTypeMap(null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.rconn = null;
    }

    protected void exceptionOccurred(SQLException ex) {
        if (this.pconn != null && VirtuosoConnection.isCriticalError(ex)) {
            this.pconn.sendErrorEvent(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close_objs() {
        HashMap copy = (HashMap)this.objsToClose.clone();
        HashMap<Object, Object> hashMap = this.objsToClose;
        synchronized (hashMap) {
            Iterator i = copy.keySet().iterator();
            while (i.hasNext()) {
                try {
                    ((Closeable)i.next()).close();
                }
                catch (Exception exception) {}
            }
            this.objsToClose.clear();
        }
        copy.clear();
    }

    private void check_conn() throws SQLException {
        if (this.isClosed || this.rconn == null) {
            throw new VirtuosoException("The connection is already closed.", -1);
        }
    }
}

