/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.ListIterator;
import openlink.util.Vector;
import openlink.util.VectorOfLong;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoFuture;
import virtuoso.jdbc4.VirtuosoParameterMetaData;
import virtuoso.jdbc4.VirtuosoResultSet;
import virtuoso.jdbc4.VirtuosoResultSetMetaData;
import virtuoso.jdbc4.VirtuosoXAConnection;

public class VirtuosoStatement
implements Statement {
    protected Vector parameters;
    protected Vector objparams;
    protected LinkedList<Object> batch;
    private int concurrency;
    protected int type;
    protected int exec_type = -1;
    private int fetchDirection = 1000;
    protected VirtuosoConnection connection;
    private int maxFieldSize;
    protected int prefetch = 100;
    private int maxRows;
    protected int txn_timeout;
    protected int rpc_timeout;
    protected String statid;
    protected String cursorName;
    protected volatile boolean close_flag = false;
    protected boolean wait_result = false;
    protected boolean result_opened = false;
    protected boolean sparql_executed = false;
    protected static int req_no;
    protected volatile VirtuosoResultSet vresultSet;
    protected VirtuosoFuture future;
    protected VirtuosoResultSetMetaData metaData;
    protected boolean isCached = false;
    protected boolean closeOnCompletion = false;
    protected VirtuosoParameterMetaData paramsMetaData = null;
    private boolean isPoolable = true;

    VirtuosoStatement(VirtuosoConnection connection) throws VirtuosoException {
        this.connection = connection;
        this.type = 1003;
        this.concurrency = 1007;
        this.rpc_timeout = connection.timeout;
        this.txn_timeout = connection.txn_timeout;
        this.prefetch = connection.fbs;
    }

    VirtuosoStatement(VirtuosoConnection connection, int type, int concurrency) throws VirtuosoException {
        this.connection = connection;
        if (type != 1003 && type != 1005 && type != 1004) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.type = type;
        if (concurrency != 1007 && concurrency != 1008 && concurrency != 1009) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.concurrency = concurrency;
        this.rpc_timeout = connection.timeout;
        this.txn_timeout = connection.txn_timeout;
        this.prefetch = connection.fbs;
    }

    protected VectorOfLong getStmtOpts() throws VirtuosoException {
        Object[] arrLong = new Long[11];
        arrLong[0] = this.connection.isReadOnly() ? Long.valueOf(3L) : (this.concurrency == 1009 ? Long.valueOf(4L) : Long.valueOf(this.concurrency == 1007 ? 1L : 2L));
        arrLong[1] = 0L;
        arrLong[2] = this.maxRows;
        if (this.connection.getGlobalTransaction()) {
            VirtuosoXAConnection xac = this.connection.xa_connection;
            if (VirtuosoFuture.rpc_log != null) {
                VirtuosoFuture.rpc_log.println("VirtuosoStatement.getStmtOpts () xa_res=" + xac.getVirtuosoXAResource().hashCode() + " :" + this.hashCode());
            }
            arrLong[3] = xac.getVirtuosoXAResource().txn_timeout * 1000;
        } else {
            arrLong[3] = this.txn_timeout * 1000;
        }
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoStatement.getStmtOpts (txn_timeout=" + arrLong[3] + ") (con=" + this.connection.hashCode() + ") :" + this.hashCode());
        }
        arrLong[4] = this.prefetch;
        arrLong[5] = this.connection.getAutoCommit() ? 1L : 0L;
        arrLong[6] = this.rpc_timeout;
        int _type = this.sparql_executed ? 1003 : this.type;
        switch (_type) {
            case 1003: {
                arrLong[7] = 0L;
                break;
            }
            case 1005: {
                arrLong[7] = 2L;
                break;
            }
            case 1004: {
                arrLong[7] = 3L;
            }
        }
        arrLong[8] = 0L;
        arrLong[9] = 1L;
        arrLong[10] = this.connection.getTransactionIsolation();
        return new VectorOfLong(arrLong);
    }

    protected VirtuosoResultSet sendQuery(String sql) throws VirtuosoException {
        this.sparql_executed = sql.trim().regionMatches(true, 0, "sparql", 0, 6);
        try {
            if (this.close_flag) {
                throw new VirtuosoException("Statement is already closed", -13);
            }
            VirtuosoConnection virtuosoConnection = this.connection;
            synchronized (virtuosoConnection) {
                if (this.future != null) {
                    this.close();
                    this.close_flag = false;
                } else {
                    this.cancel_rs();
                }
                Object[] args = new Object[6];
                Vector vect = new Vector(1);
                args[0] = this.statid == null ? (this.statid = new String("s" + this.connection.hashCode() + req_no++)) : this.statid;
                args[2] = this.cursorName == null ? args[0] : this.cursorName;
                args[1] = this.connection.escapeSQL(sql);
                args[3] = vect;
                args[4] = null;
                try {
                    vect.addElement(new Vector(0));
                    args[5] = this.getStmtOpts();
                    this.future = this.connection.getFuture("EXEC", args, this.rpc_timeout);
                    this.result_opened = true;
                    VirtuosoResultSet rs = new VirtuosoResultSet(this, this.metaData, false);
                    rs.getMoreResults(false);
                    return rs;
                }
                catch (IOException e) {
                    throw new VirtuosoException("Problem during serialization : " + e.getMessage(), -3);
                }
            }
        }
        catch (Throwable e) {
            this.notify_error(e);
            return null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.connection.isClosed()) {
                return;
            }
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws VirtuosoException {
        VirtuosoStatement virtuosoStatement = this;
        synchronized (virtuosoStatement) {
            if (this.future != null && this.wait_result) {
                this.future.sendCancelFuture();
            }
        }
        this.cancel_rs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel_rs() throws VirtuosoException {
        if (this.vresultSet != null) {
            this.vresultSet = null;
        }
        if (this.future != null) {
            VirtuosoConnection virtuosoConnection = this.connection;
            synchronized (virtuosoConnection) {
                this.connection.removeFuture(this.future);
            }
            this.future = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close_rs(boolean close_stmt, boolean is_prepared) throws VirtuosoException {
        if (this.close_flag) {
            return;
        }
        if (this.statid == null) {
            return;
        }
        if (this.vresultSet != null) {
            this.vresultSet = null;
        }
        if (!close_stmt && !this.result_opened) {
            return;
        }
        VirtuosoConnection virtuosoConnection = this.connection;
        synchronized (virtuosoConnection) {
            try {
                if (this.close_flag) {
                    return;
                }
                Object[] args = new Object[]{this.statid, close_stmt ? Long.valueOf(1L) : Long.valueOf(0L)};
                this.future = this.connection.getFuture("FRST", args, this.rpc_timeout);
                this.future.nextResult();
                this.connection.removeFuture(this.future);
                if (close_stmt) {
                    this.close_flag = true;
                }
                this.future = null;
                this.result_opened = false;
                if (!is_prepared) {
                    this.metaData = null;
                }
            }
            catch (IOException e) {
                throw new VirtuosoException("Problem during closing : " + e.getMessage(), -3);
            }
        }
    }

    @Override
    public void clearWarnings() throws VirtuosoException {
    }

    @Override
    public void close() throws VirtuosoException {
        if (this.close_flag) {
            return;
        }
        this.connection.removeStmtFromClose(this);
        this.close_rs(true, false);
    }

    @Override
    public boolean execute(String sql) throws VirtuosoException {
        this.exec_type = -1;
        this.vresultSet = this.sendQuery(sql);
        VirtuosoResultSet rs = this.vresultSet;
        return rs.kindop() != 0;
    }

    @Override
    public ResultSet executeQuery(String sql) throws VirtuosoException {
        this.exec_type = 1;
        VirtuosoResultSet rs = this.vresultSet = this.sendQuery(sql);
        return rs;
    }

    @Override
    public int executeUpdate(String sql) throws VirtuosoException {
        this.exec_type = 0;
        VirtuosoResultSet rs = this.vresultSet = this.sendQuery(sql);
        return rs.getUpdateCount();
    }

    @Override
    public int getMaxFieldSize() throws VirtuosoException {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws VirtuosoException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.connection;
            synchronized (virtuosoConnection) {
                try {
                    if (this.vresultSet == null || this.vresultSet.isLastResult) {
                        if (this.vresultSet.isLastResult) {
                            this.vresultSet = null;
                        }
                        return false;
                    }
                    Object[] args = new Object[]{this.statid, (long)this.future.hashCode()};
                    this.future.send_message("FTCH", args);
                    this.vresultSet.getMoreResults(false);
                    return true;
                }
                catch (IOException e) {
                    throw new VirtuosoException("Problem during serialization : " + e.getMessage(), -3);
                }
            }
        }
        catch (Throwable e) {
            this.notify_error(e);
            return false;
        }
    }

    @Override
    public int getQueryTimeout() throws VirtuosoException {
        return this.rpc_timeout / 1000;
    }

    @Override
    public ResultSet getResultSet() throws VirtuosoException {
        return this.vresultSet != null && this.vresultSet.kindop() != 0 ? this.vresultSet : null;
    }

    @Override
    public int getUpdateCount() throws VirtuosoException {
        if (this.vresultSet != null) {
            switch (this.vresultSet.kindop()) {
                case 0: 
                case 2: {
                    return this.vresultSet.getUpdateCount();
                }
            }
            return -1;
        }
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws VirtuosoException {
        return null;
    }

    @Override
    public void setMaxFieldSize(int max) throws VirtuosoException {
        if (max < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.maxFieldSize = max;
    }

    @Override
    public void setMaxRows(int max) throws VirtuosoException {
        if (max < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.maxRows = max;
    }

    @Override
    public void setQueryTimeout(int seconds) throws VirtuosoException {
        if (seconds < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.rpc_timeout = seconds * 1000;
    }

    @Override
    public Connection getConnection() throws VirtuosoException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws VirtuosoException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws VirtuosoException {
        return this.prefetch;
    }

    @Override
    public int getResultSetConcurrency() throws VirtuosoException {
        return this.concurrency;
    }

    @Override
    public int getResultSetType() throws VirtuosoException {
        return this.type;
    }

    @Override
    public void setFetchDirection(int direction) throws VirtuosoException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int rows) throws VirtuosoException {
        if (rows < 0 || this.maxRows > 0 && rows > this.maxRows) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.prefetch = rows == 0 ? 100 : rows;
    }

    @Override
    public void setCursorName(String name) throws VirtuosoException {
        this.cursorName = name;
    }

    @Override
    public void addBatch(String sql) throws VirtuosoException {
        if (sql == null) {
            return;
        }
        if (this.batch == null) {
            this.batch = new LinkedList();
        }
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() throws VirtuosoException {
        if (this.batch != null) {
            this.batch.clear();
        }
    }

    @Override
    public int[] executeBatch() throws BatchUpdateException {
        if (this.batch == null) {
            return new int[0];
        }
        int[] result = new int[this.batch.size()];
        int[] outres = null;
        int outcount = 0;
        boolean error = false;
        VirtuosoException ex = null;
        int i = 0;
        ListIterator it = this.batch.listIterator();
        while (it.hasNext()) {
            try {
                String stmt = (String)it.next();
                VirtuosoResultSet rset = this.sendQuery(stmt);
                result[i] = rset.getUpdateCount();
                if (rset.kindop() == 1) {
                    error = true;
                    break;
                }
            }
            catch (VirtuosoException e) {
                error = true;
                result[i] = -3;
                ex = e;
            }
            ++outcount;
            ++i;
        }
        this.batch.clear();
        if (error) {
            outres = new int[outcount];
            for (i = 0; i < outcount; ++i) {
                outres[i] = result[i];
            }
            if (ex != null) {
                throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), outres);
            }
            throw new BatchUpdateException(outres);
        }
        return result;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws VirtuosoException {
    }

    public int getExecType() {
        return this.exec_type;
    }

    @Override
    public boolean isClosed() {
        return this.close_flag;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (current == 2) {
            throw new VirtuosoException("Keeping the current result open not supported", "IM001", -7);
        }
        return this.getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return new VirtuosoResultSet(this.connection);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    protected void notify_error(Throwable e) throws VirtuosoException {
        VirtuosoConnection c = this.connection;
        if (c != null) {
            throw c.notify_error(e);
        }
        VirtuosoException ve = new VirtuosoException(e.getMessage(), -3);
        ve.initCause(e);
        throw ve;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.isPoolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.isPoolable;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new VirtuosoException("Unable to unwrap to " + iface.toString(), "22023", -4);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

