/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoFuture;

public class VirtuosoDataSource
implements DataSource,
Referenceable,
Serializable {
    protected String logFileName = null;
    protected String dataSourceName = "VirtuosoDataSourceName";
    protected String description;
    protected String serverName = "localhost";
    protected String portNumber = "1111";
    protected String databaseName;
    protected String user = "dba";
    protected String password = "dba";
    protected String delegate;
    protected String charSet;
    protected int loginTimeout = 0;
    protected String pwdclear;
    protected int log_enable = -1;
    protected String certificate;
    protected String keystorepass;
    protected String keystorepath;
    protected String provider;
    protected String truststorepass;
    protected String truststorepath;
    protected boolean ssl = false;
    protected int fbs = 0;
    protected int sendbs = 0;
    protected int recvbs = 0;
    protected boolean roundrobin = false;
    protected boolean usepstmtpool = false;
    protected int pstmtpoolsize = 0;
    protected transient PrintWriter logWriter;
    static final String n_logFileName = "logFileName";
    static final String n_dataSourceName = "dataSourceName";
    static final String n_description = "description";
    static final String n_serverName = "serverName";
    static final String n_portNumber = "portNumber";
    static final String n_databaseName = "databaseName";
    static final String n_user = "user";
    static final String n_password = "password";
    static final String n_delegate = "delegate";
    static final String n_charset = "charset";
    static final String n_charSet = "charSet";
    static final String n_loginTimeout = "loginTimeout";
    static final String n_pwdclear = "pwdclear";
    static final String n_log_enable = "log_enable";
    static final String n_certificate = "certificate";
    static final String n_keystorepass = "keystorepass";
    static final String n_keystorepath = "keystorepath";
    static final String n_provider = "provider";
    static final String n_truststorepass = "truststorepass";
    static final String n_truststorepath = "truststorepath";
    static final String n_ssl = "ssl";
    static final String n_fbs = "fbs";
    static final String n_sendbs = "sendbs";
    static final String n_recvbs = "recvbs";
    static final String n_roundrobin = "roundrobin";
    static final String n_usepstmtpool = "usepstmtpool";
    static final String n_pstmtpoolsize = "pstmtpoolsize";

    protected void addProperties(Reference ref) {
        if (this.logFileName != null) {
            ref.add(new StringRefAddr(n_logFileName, this.logFileName));
        }
        if (this.dataSourceName != null) {
            ref.add(new StringRefAddr(n_dataSourceName, this.dataSourceName));
        }
        if (this.description != null) {
            ref.add(new StringRefAddr(n_description, this.description));
        }
        if (this.serverName != null) {
            ref.add(new StringRefAddr(n_serverName, this.serverName));
        }
        if (this.portNumber != null) {
            ref.add(new StringRefAddr(n_portNumber, this.portNumber));
        }
        if (this.databaseName != null) {
            ref.add(new StringRefAddr(n_databaseName, this.databaseName));
        }
        if (this.user != null) {
            ref.add(new StringRefAddr(n_user, this.user));
        }
        if (this.password != null) {
            ref.add(new StringRefAddr(n_password, this.password));
        }
        if (this.delegate != null) {
            ref.add(new StringRefAddr(n_delegate, this.delegate));
        }
        if (this.loginTimeout != 0) {
            ref.add(new StringRefAddr(n_loginTimeout, String.valueOf(this.loginTimeout)));
        }
        if (this.charSet != null) {
            ref.add(new StringRefAddr(n_charset, this.charSet));
        }
        if (this.pwdclear != null) {
            ref.add(new StringRefAddr(n_pwdclear, this.pwdclear));
        }
        if (this.log_enable != 1) {
            ref.add(new StringRefAddr(n_log_enable, String.valueOf(this.log_enable)));
        }
        if (this.certificate != null) {
            ref.add(new StringRefAddr(n_certificate, this.certificate));
        }
        if (this.keystorepass != null) {
            ref.add(new StringRefAddr(n_keystorepass, this.keystorepass));
        }
        if (this.keystorepath != null) {
            ref.add(new StringRefAddr(n_keystorepath, this.keystorepath));
        }
        if (this.provider != null) {
            ref.add(new StringRefAddr(n_provider, this.provider));
        }
        if (this.truststorepass != null) {
            ref.add(new StringRefAddr(n_truststorepass, this.truststorepass));
        }
        if (this.truststorepath != null) {
            ref.add(new StringRefAddr(n_truststorepath, this.truststorepath));
        }
        ref.add(new StringRefAddr(n_ssl, String.valueOf(this.ssl)));
        if (this.fbs != 0) {
            ref.add(new StringRefAddr(n_fbs, String.valueOf(this.fbs)));
        }
        if (this.sendbs != 0) {
            ref.add(new StringRefAddr(n_sendbs, String.valueOf(this.sendbs)));
        }
        if (this.recvbs != 0) {
            ref.add(new StringRefAddr(n_recvbs, String.valueOf(this.recvbs)));
        }
        ref.add(new StringRefAddr(n_roundrobin, String.valueOf(this.roundrobin)));
        ref.add(new StringRefAddr(n_usepstmtpool, String.valueOf(this.usepstmtpool)));
        if (this.pstmtpoolsize != 0) {
            ref.add(new StringRefAddr(n_pstmtpoolsize, String.valueOf(this.pstmtpoolsize)));
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "virtuoso.jdbc4.VirtuosoDataSourceFactory", null);
        this.addProperties(ref);
        return ref;
    }

    protected Properties createConnProperties() {
        Properties prop = new Properties();
        String vhost = this.serverName;
        if (this.serverName.indexOf(58) == -1 && this.serverName.indexOf(44) == -1 && this.portNumber != "1111") {
            vhost = vhost + ":" + this.portNumber;
        }
        prop.setProperty("_vhost", vhost);
        if (this.databaseName != null) {
            prop.setProperty("database", this.databaseName);
        }
        if (this.user != null) {
            prop.setProperty(n_user, this.user);
        }
        if (this.password != null) {
            prop.setProperty(n_password, this.password);
        }
        if (this.delegate != null) {
            prop.setProperty(n_delegate, this.delegate);
        }
        if (this.loginTimeout != 0) {
            prop.setProperty("timeout", String.valueOf(this.loginTimeout));
        }
        if (this.charSet != null) {
            prop.setProperty(n_charset, this.charSet);
        }
        if (this.pwdclear != null) {
            prop.setProperty(n_pwdclear, this.pwdclear);
        }
        if (this.log_enable != -1) {
            prop.setProperty(n_log_enable, String.valueOf(this.log_enable));
        }
        if (this.certificate != null) {
            prop.setProperty(n_certificate, this.certificate);
        }
        if (this.keystorepass != null) {
            prop.setProperty(n_keystorepass, this.keystorepass);
        }
        if (this.keystorepath != null) {
            prop.setProperty(n_keystorepath, this.keystorepath);
        }
        if (this.provider != null) {
            prop.setProperty(n_provider, this.provider);
        }
        if (this.truststorepass != null) {
            prop.setProperty(n_truststorepass, this.truststorepass);
        }
        if (this.truststorepath != null) {
            prop.setProperty(n_truststorepath, this.truststorepath);
        }
        if (this.ssl) {
            prop.setProperty(n_ssl, "1");
        }
        if (this.fbs != 0) {
            prop.setProperty(n_fbs, String.valueOf(this.fbs));
        }
        if (this.sendbs != 0) {
            prop.setProperty(n_sendbs, String.valueOf(this.sendbs));
        }
        if (this.recvbs != 0) {
            prop.setProperty(n_recvbs, String.valueOf(this.recvbs));
        }
        if (this.roundrobin) {
            prop.setProperty(n_roundrobin, "1");
        }
        if (this.usepstmtpool) {
            prop.setProperty(n_usepstmtpool, "1");
        }
        if (this.pstmtpoolsize != 0) {
            prop.setProperty(n_pstmtpoolsize, String.valueOf(this.pstmtpoolsize));
        }
        return prop;
    }

    protected String create_url_key(String base_conn_url, Properties info) {
        StringBuffer connKeyBuf = new StringBuffer(128);
        connKeyBuf.append(base_conn_url);
        Enumeration<?> en = info.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            connKeyBuf.append(key);
            connKeyBuf.append('=');
            connKeyBuf.append(info.getProperty(key));
            connKeyBuf.append('/');
        }
        return connKeyBuf.toString();
    }

    protected String create_url() {
        String url = "jdbc:virtuoso://" + this.serverName;
        if (this.serverName.indexOf(58) == -1 && this.serverName.indexOf(44) == -1 && this.portNumber != "1111") {
            url = url + ":" + this.portNumber;
        }
        return url;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        String url = this.create_url();
        Properties info = this.createConnProperties();
        if (this.user != null) {
            info.setProperty(n_user, this.user);
        }
        if (password != null) {
            info.setProperty(n_password, password);
        }
        return new VirtuosoConnection(url, "localhost", 1111, info);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        VirtuosoFuture.rpc_log = this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String parm) {
        this.logFileName = parm;
        if (this.logFileName != null) {
            try {
                this.setLogWriter(new PrintWriter(new FileOutputStream(this.logFileName), true));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String parm) {
        this.dataSourceName = parm;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getPortNumber() {
        return Integer.parseInt(this.portNumber);
    }

    public void setPortNumber(int parm) {
        this.portNumber = String.valueOf(parm);
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDelegate(String delgate) {
        this.delegate = this.delegate;
    }

    public String getDelgate() {
        return this.delegate;
    }

    public void setDatabaseName(String name) {
        this.databaseName = name;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setCharset(String name) {
        this.charSet = name;
    }

    public String getCharset() {
        return this.charSet;
    }

    public void setPwdClear(String value) {
        this.pwdclear = value;
    }

    public String getPwdClear() {
        return this.pwdclear;
    }

    public void setLog_Enable(int bits) {
        if (bits < -1 || bits > 3) {
            bits = 0;
        }
        this.log_enable = bits;
    }

    public int getLog_Enable() {
        return this.log_enable;
    }

    public void setCertificate(String value) {
        this.certificate = value;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setKeystorepass(String value) {
        this.keystorepass = value;
    }

    public String getKeystorepass() {
        return this.keystorepass;
    }

    public void setKeystorepath(String value) {
        this.keystorepath = value;
    }

    public String getKeystorepath() {
        return this.keystorepath;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setTruststorepass(String value) {
        this.truststorepass = value;
    }

    public String getTruststorepass() {
        return this.truststorepass;
    }

    public void setTruststorepath(String value) {
        this.truststorepath = value;
    }

    public String getTruststorepath() {
        return this.truststorepath;
    }

    public void setSsl(boolean value) {
        this.ssl = value;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    public void setFbs(int value) {
        this.fbs = value;
    }

    public int getFbs() {
        return this.fbs;
    }

    public void setSendbs(int value) {
        this.sendbs = value;
    }

    public int getSendbs() {
        return this.sendbs;
    }

    public void setRecvbs(int value) {
        this.recvbs = value;
    }

    public int getRecvbs() {
        return this.recvbs;
    }

    public void setRoundrobin(boolean value) {
        this.roundrobin = value;
    }

    public boolean getRoundrobin() {
        return this.roundrobin;
    }

    public void setUsepstmtpool(boolean value) {
        this.usepstmtpool = value;
    }

    public boolean getUsepstmtpool() {
        return this.usepstmtpool;
    }

    public void setPstmtpoolsize(int value) {
        this.pstmtpoolsize = value;
    }

    public int getPstmtpoolsize() {
        return this.pstmtpoolsize;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new VirtuosoException("Unable to unwrap to " + iface.toString(), 0);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

