// SPDX-License-Identifier: Apache-2.0
/*
Copyright (C) 2025 The Falco Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

#include "events_prog_table.h"
/*
 * For every exit event here we have the name of the corresponding bpf program.
 * We can have multiple names in case we need to check the right program
 * that needs to be loaded, eg: because of different bpf features.
 */
event_prog_t exit_event_progs_table[PPM_EVENT_MAX][MAX_FEATURE_CHECKS] = {
        [PPME_GENERIC_X] = {{"generic_x", 0}},
        [PPME_SYSCALL_GETCWD_X] = {{"getcwd_x", 0}},
        [PPME_SYSCALL_GETDENTS_X] = {{"getdents_x", 0}},
        [PPME_SYSCALL_GETDENTS64_X] = {{"getdents64_x", 0}},
        [PPME_SYSCALL_EPOLLWAIT_X] = {{"epoll_wait_x", 0}},
        [PPME_SOCKET_GETPEERNAME_X] = {{"getpeername_x", 0}},
        [PPME_SOCKET_GETSOCKNAME_X] = {{"getsockname_x", 0}},
        [PPME_SYSCALL_MKDIR_2_X] = {{"mkdir_x", 0}},
        [PPME_SYSCALL_MMAP_X] = {{"mmap_x", 0}},
        [PPME_SYSCALL_MUNMAP_X] = {{"munmap_x", 0}},
        [PPME_SYSCALL_OPEN_X] = {{"open_x", 0}},
        [PPME_SYSCALL_OPENAT_2_X] = {{"openat_x", 0}},
        [PPME_SYSCALL_OPENAT2_X] = {{"openat2_x", 0}},
        [PPME_SYSCALL_OPEN_BY_HANDLE_AT_X] = {{"open_by_handle_at_x", 0}},
        [PPME_SYSCALL_CLOSE_X] = {{"close_x", 0}},
        [PPME_SYSCALL_COPY_FILE_RANGE_X] = {{"copy_file_range_x", 0}},
        [PPME_SYSCALL_CREAT_X] = {{"creat_x", 0}},
        [PPME_SYSCALL_DUP_1_X] = {{"dup_x", 0}},
        [PPME_SYSCALL_DUP2_X] = {{"dup2_x", 0}},
        [PPME_SYSCALL_DUP3_X] = {{"dup3_x", 0}},
        [PPME_SYSCALL_CHDIR_X] = {{"chdir_x", 0}},
        [PPME_SYSCALL_CHMOD_X] = {{"chmod_x", 0}},
        [PPME_SYSCALL_CHROOT_X] = {{"chroot_x", 0}},
        [PPME_SYSCALL_FCHDIR_X] = {{"fchdir_x", 0}},
        [PPME_SYSCALL_FCHMOD_X] = {{"fchmod_x", 0}},
        [PPME_SYSCALL_FCHMODAT_X] = {{"fchmodat_x", 0}},
        [PPME_SYSCALL_MKDIRAT_X] = {{"mkdirat_x", 0}},
        [PPME_SYSCALL_RMDIR_2_X] = {{"rmdir_x", 0}},
        [PPME_SYSCALL_EVENTFD_X] = {{"eventfd_x", 0}},
        [PPME_SYSCALL_INOTIFY_INIT_X] = {{"inotify_init_x", 0}},
        [PPME_SYSCALL_TIMERFD_CREATE_X] = {{"timerfd_create_x", 0}},
        [PPME_SYSCALL_USERFAULTFD_X] = {{"userfaultfd_x", 0}},
        [PPME_SYSCALL_SIGNALFD_X] = {{"signalfd_x", 0}},
        [PPME_SYSCALL_KILL_X] = {{"kill_x", 0}},
        [PPME_SYSCALL_TGKILL_X] = {{"tgkill_x", 0}},
        [PPME_SYSCALL_TKILL_X] = {{"tkill_x", 0}},
        [PPME_SYSCALL_SECCOMP_X] = {{"seccomp_x", 0}},
        [PPME_SYSCALL_PTRACE_X] = {{"ptrace_x", 0}},
        [PPME_SYSCALL_CAPSET_X] = {{"capset_x", 0}},
        [PPME_SOCKET_SOCKET_X] = {{"socket_x", 0}},
        [PPME_SOCKET_CONNECT_X] = {{"connect_x", 0}},
        [PPME_SOCKET_SOCKETPAIR_X] = {{"socketpair_x", 0}},
        [PPME_SOCKET_ACCEPT_5_X] = {{"accept_x", 0}},
        [PPME_SOCKET_BIND_X] = {{"bind_x", 0}},
        [PPME_SOCKET_LISTEN_X] = {{"listen_x", 0}},
        [PPME_SYSCALL_EXECVE_19_X] = {{"execve_x", 0}},
        [PPME_SYSCALL_EXECVEAT_X] = {{"execveat_x", 0}},
        [PPME_SYSCALL_CLONE_20_X] = {{"clone_x", 0}},
        [PPME_SYSCALL_CLONE3_X] = {{"clone3_x", 0}},
        [PPME_SYSCALL_FORK_20_X] = {{"fork_x", 0}},
        [PPME_SYSCALL_VFORK_20_X] = {{"vfork_x", 0}},
        [PPME_SYSCALL_RENAME_X] = {{"rename_x", 0}},
        [PPME_SYSCALL_RENAMEAT_X] = {{"renameat_x", 0}},
        [PPME_SYSCALL_RENAMEAT2_X] = {{"renameat2_x", 0}},
        [PPME_SYSCALL_PIPE_X] = {{"pipe_x", 0}},
        [PPME_SYSCALL_READV_X] = {{"readv_x", 0}},
        [PPME_SYSCALL_PREADV_X] = {{"preadv_x", 0}},
        [PPME_SYSCALL_PREAD_X] = {{"pread64_x", 0}},
        [PPME_SYSCALL_BPF_2_X] = {{"bpf_x", 0}},
        [PPME_SYSCALL_FLOCK_X] = {{"flock_x", 0}},
        [PPME_SYSCALL_IOCTL_3_X] = {{"ioctl_x", 0}},
        [PPME_SYSCALL_QUOTACTL_X] = {{"quotactl_x", 0}},
        [PPME_SYSCALL_UNSHARE_X] = {{"unshare_x", 0}},
        [PPME_SYSCALL_MOUNT_X] = {{"mount_x", 0}},
        [PPME_SYSCALL_UMOUNT2_X] = {{"umount2_x", 0}},
        [PPME_SYSCALL_LINK_2_X] = {{"link_x", 0}},
        [PPME_SYSCALL_LINKAT_2_X] = {{"linkat_x", 0}},
        [PPME_SYSCALL_SYMLINK_X] = {{"symlink_x", 0}},
        [PPME_SYSCALL_SYMLINKAT_X] = {{"symlinkat_x", 0}},
        [PPME_SYSCALL_UNLINK_2_X] = {{"unlink_x", 0}},
        [PPME_SYSCALL_UNLINKAT_2_X] = {{"unlinkat_x", 0}},
        [PPME_SYSCALL_SETGID_X] = {{"setgid_x", 0}},
        [PPME_SYSCALL_SETUID_X] = {{"setuid_x", 0}},
        [PPME_SYSCALL_SETNS_X] = {{"setns_x", 0}},
        [PPME_SYSCALL_SETPGID_X] = {{"setpgid_x", 0}},
        [PPME_SYSCALL_SETRESGID_X] = {{"setresgid_x", 0}},
        [PPME_SYSCALL_SETRESUID_X] = {{"setresuid_x", 0}},
        [PPME_SYSCALL_SETSID_X] = {{"setsid_x", 0}},
        [PPME_SYSCALL_SETRLIMIT_X] = {{"setrlimit_x", 0}},
        [PPME_SYSCALL_PRLIMIT_X] = {{"prlimit64_x", 0}},
        [PPME_SOCKET_SETSOCKOPT_X] = {{"setsockopt_x", 0}},
        [PPME_SOCKET_SENDMSG_X] = {{"sendmsg_x", 0}},
        [PPME_SOCKET_SENDTO_X] = {{"sendto_x", 0}},
        [PPME_SOCKET_RECVMSG_X] = {{"recvmsg_x", 0}},
        [PPME_SOCKET_RECVFROM_X] = {{"recvfrom_x", 0}},
        [PPME_SYSCALL_FCNTL_X] = {{"fcntl_x", 0}},
        [PPME_SOCKET_SHUTDOWN_X] = {{"shutdown_x", 0}},
        [PPME_SYSCALL_FSCONFIG_X] = {{"fsconfig_x", 0}},
        [PPME_SYSCALL_EPOLL_CREATE_X] = {{"epoll_create_x", 0}},
        [PPME_SYSCALL_EPOLL_CREATE1_X] = {{"epoll_create1_x", 0}},
        [PPME_SYSCALL_ACCESS_X] = {{"access_x", 0}},
        [PPME_SOCKET_GETSOCKOPT_X] = {{"getsockopt_x", 0}},
        [PPME_SYSCALL_MPROTECT_X] = {{"mprotect_x", 0}},
        [PPME_SYSCALL_GETUID_X] = {{"getuid_x", 0}},
        [PPME_SYSCALL_GETGID_X] = {{"getgid_x", 0}},
        [PPME_SYSCALL_GETEUID_X] = {{"geteuid_x", 0}},
        [PPME_SYSCALL_GETEGID_X] = {{"getegid_x", 0}},
        [PPME_SYSCALL_MLOCK_X] = {{"mlock_x", 0}},
        [PPME_SYSCALL_MLOCK2_X] = {{"mlock2_x", 0}},
        [PPME_SYSCALL_MUNLOCK_X] = {{"munlock_x", 0}},
        [PPME_SYSCALL_MLOCKALL_X] = {{"mlockall_x", 0}},
        [PPME_SYSCALL_MUNLOCKALL_X] = {{"munlockall_x", 0}},
        [PPME_SYSCALL_READ_X] = {{"read_x", 0}},
        [PPME_SYSCALL_IO_URING_ENTER_X] = {{"io_uring_enter_x", 0}},
        [PPME_SYSCALL_IO_URING_REGISTER_X] = {{"io_uring_register_x", 0}},
        [PPME_SYSCALL_IO_URING_SETUP_X] = {{"io_uring_setup_x", 0}},
        [PPME_SYSCALL_POLL_X] = {{"poll_x", 0}},
        [PPME_SYSCALL_PPOLL_X] = {{"ppoll_x", 0}},
        [PPME_SYSCALL_MMAP2_X] = {{"mmap2_x", 0}},
        [PPME_SYSCALL_SEMGET_X] = {{"semget_x", 0}},
        [PPME_SYSCALL_SEMCTL_X] = {{"semctl_x", 0}},
        [PPME_SYSCALL_SELECT_X] = {{"select_x", 0}},
        [PPME_SYSCALL_SPLICE_X] = {{"splice_x", 0}},
        [PPME_SOCKET_RECVMMSG_X] = {{"recvmmsg_x", BPF_FUNC_loop}, {"recvmmsg_old_x", 0}},
        [PPME_SOCKET_SENDMMSG_X] = {{"sendmmsg_x", BPF_FUNC_loop}, {"sendmmsg_old_x", 0}},
        [PPME_SYSCALL_SEMOP_X] = {{"semop_x", 0}},
        [PPME_SYSCALL_GETRESUID_X] = {{"getresuid_x", 0}},
        [PPME_SYSCALL_SENDFILE_X] = {{"sendfile_x", 0}},
        [PPME_SYSCALL_FUTEX_X] = {{"futex_x", 0}},
        [PPME_SYSCALL_STAT_X] = {{"stat_x", 0}},
        [PPME_SYSCALL_LSTAT_X] = {{"lstat_x", 0}},
        [PPME_SYSCALL_FSTAT_X] = {{"fstat_x", 0}},
        [PPME_SYSCALL_LSEEK_X] = {{"lseek_x", 0}},
        [PPME_SYSCALL_LLSEEK_X] = {{"llseek_x", 0}},
        [PPME_SYSCALL_WRITE_X] = {{"write_x", 0}},
        [PPME_SYSCALL_WRITEV_X] = {{"writev_x", 0}},
        [PPME_SYSCALL_PWRITEV_X] = {{"pwritev_x", 0}},
        [PPME_SYSCALL_PWRITE_X] = {{"pwrite64_x", 0}},
        [PPME_SYSCALL_GETRESGID_X] = {{"getresgid_x", 0}},
        [PPME_SYSCALL_CHOWN_X] = {{"chown_x", 0}},
        [PPME_SYSCALL_LCHOWN_X] = {{"lchown_x", 0}},
        [PPME_SYSCALL_FCHOWN_X] = {{"fchown_x", 0}},
        [PPME_SYSCALL_FCHOWNAT_X] = {{"fchownat_x", 0}},
        [PPME_SYSCALL_BRK_4_X] = {{"brk_x", 0}},
        [PPME_SYSCALL_GETRLIMIT_X] = {{"getrlimit_x", 0}},
        [PPME_SOCKET_SEND_X] = {{"send_x", 0}},
        [PPME_SOCKET_RECV_X] = {{"recv_x", 0}},
        [PPME_SYSCALL_NANOSLEEP_X] = {{"nanosleep_x", 0}},
        [PPME_SYSCALL_UMOUNT_1_X] = {{"umount_x", 0}},
        [PPME_SOCKET_ACCEPT4_6_X] = {{"accept4_x", 0}},
        [PPME_SYSCALL_PIPE2_X] = {{"pipe2_x", 0}},
        [PPME_SYSCALL_INOTIFY_INIT1_X] = {{"inotify_init1_x", 0}},
        [PPME_SYSCALL_EVENTFD2_X] = {{"eventfd2_x", 0}},
        [PPME_SYSCALL_SIGNALFD4_X] = {{"signalfd4_x", 0}},
        [PPME_SYSCALL_PRCTL_X] = {{"prctl_x", 0}},
        [PPME_SYSCALL_MEMFD_CREATE_X] = {{"memfd_create_x", 0}},
        [PPME_SYSCALL_PIDFD_GETFD_X] = {{"pidfd_getfd_x", 0}},
        [PPME_SYSCALL_PIDFD_OPEN_X] = {{"pidfd_open_x", 0}},
        [PPME_SYSCALL_INIT_MODULE_X] = {{"init_module_x", 0}},
        [PPME_SYSCALL_FINIT_MODULE_X] = {{"finit_module_x", 0}},
        [PPME_SYSCALL_MKNOD_X] = {{"mknod_x", 0}},
        [PPME_SYSCALL_MKNODAT_X] = {{"mknodat_x", 0}},
        [PPME_SYSCALL_NEWFSTATAT_X] = {{"newfstatat_x", 0}},
        [PPME_SYSCALL_PROCESS_VM_READV_X] = {{"process_vm_readv_x", 0}},
        [PPME_SYSCALL_PROCESS_VM_WRITEV_X] = {{"process_vm_writev_x", 0}},
        [PPME_SYSCALL_DELETE_MODULE_X] = {{"delete_module_x", 0}},
        [PPME_SYSCALL_SETREUID_X] = {{"setreuid_x", 0}},
        [PPME_SYSCALL_SETREGID_X] = {{"setregid_x", 0}},
};

ttm_progs_t ttm_progs_table[TTM_MAX] = {
        [TTM_CONNECT] = {{"connect_e"},
                         {{"ia32_compat_connect_e", "__ia32_compat_sys_connect"},
                          {"ia32_connect_e", "__ia32_sys_connect"}}},
        [TTM_CREAT] = {{"creat_e"},
                       {{"ia32_compat_creat_e", "__ia32_compat_sys_creat"},
                        {"ia32_creat_e", "__ia32_sys_creat"}}},
        [TTM_OPEN] = {{"open_e"},
                      {{"ia32_compat_open_e", "__ia32_compat_sys_open"},
                       {"ia32_open_e", "__ia32_sys_open"}}},
        [TTM_OPENAT] = {{"openat_e"},
                        {{"ia32_compat_openat_e", "__ia32_compat_sys_openat"},
                         {"ia32_openat_e", "__ia32_sys_openat"}}},
        [TTM_OPENAT2] = {{"openat2_e"},
                         {{"ia32_compat_openat2_e", "__ia32_compat_sys_openat2"},
                          {"ia32_openat2_e", "__ia32_sys_openat2"}}},
};
