// SPDX-License-Identifier: GPL-2.0-only OR MIT
/*
 * Copyright (C) 2023 The Falco Authors.
 *
 * This file is dual licensed under either the MIT or GPL 2. See MIT.txt
 * or GPL2.txt for full copies of the license.
 */

#include <helpers/interfaces/fixed_size_event.h>

/*=============================== EXIT EVENT ===========================*/

SEC("tp_btf/sys_exit")
int BPF_PROG(splice_x, struct pt_regs *regs, long ret) {
	struct ringbuf_struct ringbuf;
	if(!ringbuf__reserve_space(&ringbuf, SPLICE_X_SIZE, PPME_SYSCALL_SPLICE_X)) {
		return 0;
	}

	ringbuf__store_event_header(&ringbuf);

	/*=============================== COLLECT PARAMETERS  ===========================*/

	/* Parameter 1: res (type: PT_ERRNO) */
	ringbuf__store_s64(&ringbuf, (int64_t)ret);

	/* Parameter 2: fd_in (type: PT_FD) */
	int64_t fd_in = (int64_t)(int32_t)extract__syscall_argument(regs, 0);
	ringbuf__store_s64(&ringbuf, fd_in);

	/* Parameter 3: fd_out (type: PT_FD) */
	int64_t fd_out = (int64_t)(int32_t)extract__syscall_argument(regs, 2);
	ringbuf__store_s64(&ringbuf, fd_out);

	/* Parameter 4: size (type: PT_UINT64) */
	uint64_t size = extract__syscall_argument(regs, 4);
	ringbuf__store_u64(&ringbuf, size);

	/* Parameter 5: flags (type: PT_FLAGS32) */
	uint32_t flags = extract__syscall_argument(regs, 5);
	ringbuf__store_u32(&ringbuf, splice_flags_to_scap(flags));

	/*=============================== COLLECT PARAMETERS  ===========================*/

	ringbuf__submit_event(&ringbuf);

	return 0;
}

/*=============================== EXIT EVENT ===========================*/
