#ifndef _torsmo_h_
#define _torsmo_h_

#include "config.h"
#include <stdio.h>

#define ERR(s, varargs...) \
  fprintf(stderr, "torsmo: " s "\n", ##varargs)

/* critical error */
#define CRIT_ERR(s, varargs...) \
  { fprintf(stderr, "torsmo: " s "\n", ##varargs); exit(EXIT_FAILURE); }

struct net_stat {
  const char *dev;
  long long last_read_recv, last_read_trans;
  long long recv, trans;
  double recv_speed, trans_speed;
};

/* system dependant */

void prepare_update(void);
double get_uptime(void);
void update_meminfo(void);
void update_net_stats(void);
void update_cpu_usage(void);
int get_total_processes(void);
int get_running_processes(void);
double get_i2c_info(int *fd, const char *dev, const char *type, int n);
void get_load_average(double v[3]);
double get_acpi_temperature(void);
void get_battery_stuff(char *buf, unsigned int n);

/* in torsmo.c */

extern double current_update_time, last_update_time;

extern int no_buffers;

/* memory information in kilobytes */
extern unsigned int mem, memmax, swap, swapmax, bufmem;

extern double cpu_usage;

double get_time(void);
FILE *open_file(const char *file, int *reported);
void format_time(char *buf, unsigned int n, long t);

struct net_stat *get_net_stat(const char *dev);

#endif
