#
# PloneExFile tests
#


__author__ = ''
__docformat__ = 'restructuredtext'

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from common import *

tests = []

class TestPloneExFile(PloneExFileTestCase):

    def testAddPloneExFile(self):
        """ test if PloneExFile is created """
        self.loginAsPortalMember()
        content_id = 'my_file'
        exfile = self.createEmptyFile(self.member_folder, content_id)
        self.failUnless(hasattr(aq_base(self.member_folder), content_id))

    def testIsIndexed(self):
        """ test if PloneExFile is indexed """
        self.loginAsPortalMember()
        content_id = 'my_file'
        exfile = self.createEmptyFile(self.member_folder, content_id)
        self.failUnless(self.cat_tool(id=content_id))

    def testReindexPloneExFile(self):
        """ Modify the title and re index PloneExFile """
        self.loginAsPortalMember()
        content_id = 'my_file'
        exfile = self.createEmptyFile(self.member_folder, content_id)
        self.failIf(self.cat_tool(id=content_id, Title='My File'))
        exfile.setTitle('My File')
        exfile.reindexObject()
        self.failUnless(self.cat_tool(id=content_id, Title='My File'))
    
    #Standard Plone tools
    
    def testDeletePloneExFile(self,):
        """ delete PloneExFile """
        self.loginAsPortalMember()
        content_id = 'my_file'
        exfile = self.createEmptyFile(self.member_folder, content_id)
        self.member_folder._delObject(content_id)
        self.failIf(self.cat_tool(id=content_id))
        Log(LOG_NOTICE, "PloneExFile deleted.")
    
    
    
    ###############################
    #PloneExFile related method#
    ###############################
    
    def testEditPloneExFile(self,):
        """ edit the PloneExFile """
        self.loginAsPortalMember()
        content_id = 'my_file'
        exfile = self.createEmptyFile(self.member_folder, content_id)
        title = 'My File'
        description = 'Document speaking of general economy'
        exfile.setTitle(title)
        exfile.setDescription(description)
        
        #edit our product with title and description
        self.assertEqual(exfile.Title(), title)
        self.assertEqual(exfile.Description(), description)
        Log(LOG_NOTICE, "PloneExFile edited.")
    
    def testAddFile(self,):
        """ 
        Add a file, 
        verify hasAttachment(), 
        verify if file is correctly uploaded.
        """
        self.loginAsPortalMember()
        content_id = 'my_file'
        exfile = self.createFullFile(self.member_folder, content_id)
        file_field = exfile.getField('file')
        file_field_content = file_field.get(exfile).get_data()
        
        self.failUnless(file_field.isIndexed(exfile))
        self.failUnless(len(file_field.getIndexableValue(exfile)) > 500)
        f = open("test.doc")
        file_content = f.read()
        f.close()
        
        self.assertEquals(len(file_field_content), len(file_content))
        self.failUnless(
            file_field_content == file_content,
            "File content is different.",
            )

    def testMassiveAddFile(self,):
        """ 
        Add many files, 
        """
        self.loginAsPortalMember()
        
        for x in range(0, 1):
            content_id = "exfile%03d" % (x,)
            exfile = self.createFullFile(self.member_folder, content_id)
            file_field = exfile.getField('file')
            file_field_content = file_field.get(exfile).get_data()
            
            f = open("test.doc")
            file_content = f.read()
            f.close()
            self.failUnless(
                file_field_content == file_content,
                "File content is different.",
                )
    
    
    def testDeleteFile(self,):
        """ Add a file and delete it """
        self.loginAsPortalMember()
        content_id = 'my_file'
        exfile = self.createFullFile(self.member_folder, content_id)
        file_field = exfile.getField('file')
        
        self.assertEqual(file_field.isEmpty(exfile), 0)
        
        file_field.set(exfile, 'DELETE_FILE')
        self.assertEqual(file_field.isEmpty(exfile), 1)
    
    ######
    #LOCK#
    ######
    def testLockPloneExFile(self,):
        """ lock an exfile """
        self.loginAsPortalMember()
        content_id = 'my_file'
        exfile = self.createFullFile(self.member_folder, content_id)
        file_field = exfile.getField('file')
        self.exfile_tool.use_lock = 1
        self.assertEqual(exfile.hasLockSupport(), True)
        self.assertEqual(exfile.isLocked(), False)
        self.assertEqual(exfile.canToggleLock(), True)
        
        # Lock file
        exfile.lock(True)
        
        self.assertEqual(exfile.canToggleLock(), True)
        Log(LOG_NOTICE, "lock by " + str(exfile.getLockUser()))
        Log(LOG_NOTICE, "lock date " + str(exfile.getLockDate()))
        self.assertEqual(exfile.isLocked(), True)
        
        return exfile
    
    def testUnlockExFile(self,):
        """ lock an exfile """
        exfile = self.testLockPloneExFile()
        exfile.lock(False)
        self.assertEqual(exfile.canToggleLock(), True)
        self.assertEqual(exfile.isLocked(), False)
        
    
    def testAccessAfterLock(self, ):
        """
        user1 locks an exfile and logout
        user2 has login, he must not be able to edit
        """
        exfile = self.testLockPloneExFile()
        self.logout()
        self.loginAsPortalMember2()
        self.assertEqual(exfile.canToggleLock(), False)
        
    def testAnotherUserLock(self, ):
        """
        user1 unlocks an exfile and logout
        user2 has login and locks the exfile
        user1 must not be able to edit the exfile
        """
        # must have a file in it, so user can lock it
        exfile = self.testLockPloneExFile()
        exfile.lock(False)
        self.logout()
        
        self.loginAsPortalMember2()
        # lock file
        result = exfile.lock(True)
        self.assertEqual(exfile.canToggleLock(), True)
        Log(LOG_NOTICE, "lock by " + str(exfile.getLockUser()))
        Log(LOG_NOTICE, "lock date " + str(exfile.getLockDate()))
        self.assertEqual(exfile.isLocked(), True)
        
        
    
    def testForceUnlockExFile(self,):
        """
        user1 locks an exfile and logout
        user2 has login, has the ExFile_forceUnlockPermission and force unlock.
        """
        exfile = self.testLockPloneExFile()
        self.logout()
        
        self.loginAsPortalMember2()
        self.assertEqual(exfile.canToggleLock(), False)
        self.logout()
        
        self.loginAsPortalMember()
        exfile.manage_addLocalRoles(userid = 'portal_member2', roles = ['LockOwner',])
        self.logout()
        
        self.loginAsPortalMember2()
        member = self.mb_tool.getAuthenticatedMember()
        self.assertEqual(exfile.canToggleLock(), True)

tests.append(TestPloneExFile)

if __name__ == '__main__':
    framework()
else:
    # While framework.py provides its own test_suite()
    # method the testrunner utility does not.
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        for test in tests:
            suite.addTest(unittest.makeSuite(test))
        return suite


