##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
$Id: Install.py,v 1.11 2004/12/27 11:22:17 pjgrizel Exp $
"""

__author__  = ''
__docformat__ = 'restructuredtext'

# Python imports
from StringIO import StringIO

# Zope imports
from Products.ExternalMethod.ExternalMethod import ExternalMethod, manage_addExternalMethod
from Products.StandardCacheManagers import RAMCacheManager

# CMF imports
from Products.CMFCore.utils import getToolByName

# Archetypes imports
from Products.Archetypes import listTypes
from Products.Archetypes.Extensions.utils import installTypes, install_subskin

# Products imports
from Products.PloneExFile.config import PROJECTNAME, GLOBALS, SKINS_DIR


def install(self):
    out = StringIO()
    
    # Install types
    typeInfo = listTypes(PROJECTNAME)
    installTypes(self, out,
                 typeInfo,
                 PROJECTNAME)

    # Install skin
    install_subskin(self, out, GLOBALS)
    
    # Register templates
    registerTemplates(self, typeInfo, out)
    
    # Install properties
    ptool = getToolByName(self, 'portal_properties')
    
    # Create property sheets
    if not hasattr(ptool, 'ploneexfile_properties'):
        ptool.addPropertySheet('ploneexfile_properties', 'PloneExFile properties')
    
    # Create PloneExFile properties
    props = ptool.ploneexfile_properties
    
    if not hasattr(props, 'use_lock'):
        props._setProperty('use_lock', 0, 'boolean')
    
    if not hasattr(props, 'show_smallpreview'):    
        props._setProperty('show_smallpreview', 0, 'boolean')
    
    # Add action icons
    addActionIcon(self,
                  category='plone',
                  action_id='unlock_lock',
                  icon_expr='lock.gif',
                  title="Lock (Currently not locked)",
                  priority=0)
    addActionIcon(self,
                  category='plone',
                  action_id='lock_unlock',
                  icon_expr='unlock.gif',
                  title="Unlock (Currently locked)",
                  priority=0)
    
    out.write('Installation completed.\n')
    return out.getvalue()

def uninstall(self):
    out = StringIO()
    
    out.write('Uninstallation completed.\n')
    return out.getvalue()
    
def addActionIcon(self, category, action_id, icon_expr, title=None, priority=0):
    # Add the action icon if and only if it's not already here
    ai=getToolByName(self, 'portal_actionicons')
    if ai.queryActionInfo( category, action_id ):
      ai.updateActionIcon(category, action_id, icon_expr, title, priority)
    else:
      ai.addActionIcon(category, action_id, icon_expr, title, priority)

def registerTemplates(self, typeInfo, out):
    """Registers templates in the archetypes tool
    """
    for t in typeInfo:
        klass          = t['klass']
        portal_type    = klass.portal_type
        registerTemplatesForClass(self, klass, portal_type)

def registerTemplatesForClass(self, klass, portal_type):
    atTool       = getToolByName(self, 'archetype_tool')
    default_view = getattr(klass, 'default_view', 'base_view')
    suppl_views  = getattr(klass, 'suppl_views', ())
    views        = ['base_view',]

    if default_view != 'base_view':
        atTool.registerTemplate(default_view)
        views.append(default_view)

    for view in suppl_views:
        atTool.registerTemplate(view)
        views.append(view)

    atTool.bindTemplate(portal_type, views)
