##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
$Id: ExFileLock.py,v 1.2 2004/12/27 11:22:17 pjgrizel Exp $
"""

# Zope imports
from AccessControl import ClassSecurityInfo
import Acquisition
from DateTime import DateTime
from Globals import InitializeClass

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName

# Archetypes imports
from Products.Archetypes.public import *

# ExFile imports
from Products.PloneExFile import Permissions
from Products.PloneExFile.LockMixin import LockMixin

#                                                                           #
#                           LOCKING SUPPORT                                 #
#                                                                           #

class LockWidget(BooleanWidget):
      """
      Visibility depends on Lock support
      """
      
      security = ClassSecurityInfo()
      
      security.declarePublic('isVisible')
      def isVisible(self, instance, mode='view'):
          state = BooleanWidget.isVisible(self, instance, mode)
          
          if mode == 'edit':
              # Return lock support
              portal_properties = getToolByName(self, "portal_properties")
              props = portal_properties.ploneexfile_properties
              
              if props.use_lock:
                  return 'hidden'
              else:
                  return 'hidden'
          else:
              return state

InitializeClass(LockWidget)

class ExFileLock(LockMixin):

    LockOwnerPermission = Permissions.LockExFile
    LockEditPermission = Permissions.EditExFile
    
    security = ClassSecurityInfo()

    schema = Schema((
        # Locked Mixin
        BooleanField('is_locked',
                    accessor='isLocked',
                    mutator='lock',
                    default=False,
                    widget=LockWidget(
                        visible={'view' : 'hidden',
                                 'edit' : 'hidden'},
            )),
        ))

    security.declareProtected(CMFCorePermissions.View, 'hasLockSupport')
    def hasLockSupport(self):
        # Return lock support
        portal_properties = getToolByName(self, "portal_properties")
        props = portal_properties.ploneexfile_properties
        
        return props.use_lock
