##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
$Id: ExFile.py,v 1.26 2005/03/03 10:17:31 clebeaupin Exp $
"""

__author__ = ''
__docformat__ = 'restructuredtext'

# Zope imports
from AccessControl import ClassSecurityInfo

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName
from ComputedAttribute import ComputedAttribute

# Archetypes imports
try:
    from Products.LinguaPlone.public import *
except ImportError:
    # No multilingual support
    from Products.Archetypes.public import *

# PloneExFile imports
from Products.AttachmentField.AttachmentField import AttachmentField
from Products.AttachmentField.AttachmentWidget import AttachmentWidget
from Products.PloneExFile.config import PROJECTNAME
from Products.PloneExFile.ATContentType import FileContent
from Products.PloneExFile import Permissions
from Products.PloneExFile.ExFileLock import ExFileLock

class PloneExFile(ExFileLock, FileContent):
    """PloneExFile class"""
    
    schema = FileContent.schema + \
        ExFileLock.schema + Schema((
        AttachmentField(
            'file',
            primary=True,
            searchable=True,
            #languageIndependent=True,
            widget = AttachmentWidget(
                description = "Select the file to be added by clicking the 'Browse' button.",
                description_msgid = "help_file",
                label= "File",
                label_msgid = "label_file",
                i18n_domain = "plone",
                show_content_type = False,
                ),
            ),
        ), marshall=PrimaryFieldMarshaller())
    
    content_icon   = 'ExFile.gif'
    meta_type      = 'ExFile'
    archetype_name = 'File'
    default_view = 'ExFile_view'
    immediate_view = 'ExFile_view'
    suppl_views    = ()
    newTypeFor     = ()
    typeDescription= ''
    typeDescMsgId  = ''
    assocMimetypes = ()
    assocFileExt   = ()
    
    use_folder_tabs = 0
    filter_content_types  = 0
    allowed_content_types = ()
    include_default_actions = 0
    
    actions = (
         {
          'id'          : 'view',
          'name'        : 'View',
          'action'      : 'string:${object_url}/view',
          'permissions' : (CMFCorePermissions.View,),
          'visible'     : 1,
         },
         {
          'id'          : 'edit',
          'name'        : 'Edit',
          'action'      : 'string:${object_url}/base_edit',
          'condition'     : 'python:not object.hasLockSupport() or object.canToggleLock()',
          'permissions' : (CMFCorePermissions.ModifyPortalContent,),
          'visible'     : 1,
         },
         {
          'id'            : 'lock_unlock',
          'name'          : 'Unlock (Currently locked)',
          'action'        : 'string:${object_url}/unlockExFile',
          'permissions'   : (CMFCorePermissions.View, ),
          'condition'     : 'python:object.isLocked() and object.canToggleLock()',
          'category'      : 'document_actions',
         },
         {
          'id'            : 'unlock_lock',
          'name'          : 'Lock (Currently not locked)',
          'action'        : 'string:${object_url}/lockExFile',
          'permissions'   : (CMFCorePermissions.View, ),
          'condition'     : 'python:not object.isLocked() and object.canToggleLock()',
          'category'      : 'document_actions',
         },
         {
          'id'          : 'metadata',
          'name'        : 'Properties',
          'action'      : 'string:${object_url}/base_metadata',
          'condition'     : 'python:not object.hasLockSupport() or object.canToggleLock()',
          'permissions' : (CMFCorePermissions.ModifyPortalContent,),
          'visible'     : 1,
         },
        )
    
    __implements__ = ( FileContent.__implements__, )

    security = ClassSecurityInfo()
    
    # Init method
    def __init__(self, oid, **kwargs):
        """__init__(self, oid, **kwargs)"""
        
        ExFileLock.__init__(self)
        FileContent.__init__(self, oid, **kwargs)
        
    security.declarePublic('getIcon')
    def getIcon(self, relative_to_portal=0):
        """Calculate the icon using the mime type of the file
        """
        
        field = self.getField('file')
        portal_url = getToolByName( self, 'portal_url' )
        
        # Find the proper icon
        icon = getattr(self, 'ExFile_small.gif')
        m = getattr(field, 'getSmallIcon', None)
        
        if m is not None:
            icon = m(self)
        
        # Return it
        if relative_to_portal:
            return portal_url.getRelativeContentURL(icon)
            
        # Relative to REQUEST['BASEPATH1']
        res = portal_url(relative=1) + '/' + icon.getId()
        while res[:1] == '/':
            res = res[1:]
        return res

def writePermission(self):
    return Permissions.EditExFile

def updateWritePermissions(klass):
    for field_id in klass.schema.keys():
        klass.schema[field_id].write_permission = Permissions.EditExFile 
        #schema['title'].write_permission = ComputedAttribute(writePermission, 0)
   
def registerPloneExFile(klass):
    # Change write permission
    updateWritePermissions(klass)
    
    # Archetypes registering
    registerType(klass, PROJECTNAME)


registerPloneExFile(PloneExFile)
