##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""AT Content type

$Id: ATContentType.py,v 1.2 2004/12/27 11:22:17 pjgrizel Exp $
"""

__author__ = ''
__docformat__ = 'restructuredtext'

# Zope imports
from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
from ComputedAttribute import ComputedAttribute
from ZPublisher.HTTPRequest import HTTPRequest
from Acquisition import aq_base, aq_inner, aq_parent

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName

# Archetypes imports
try:
    from Products.LinguaPlone.public import *
except ImportError:
    # No multilingual support
    from Products.Archetypes.public import *
    
from Products.Archetypes.TemplateMixin import TemplateMixin
from Products.Archetypes.debug import _zlogger

DEBUG = 1

MIME_ALIAS = {
    'plain' : 'text/plain',
    'stx'   : 'text/structured',
    'html'  : 'text/html',
    'rest'  : 'text/x-rst',
    'structured-text' : 'text/structured',
    'restructuredtext' : 'text/x-rst',
    }

def translateMimetypeAlias(alias):
    """Maps old CMF content types to real mime types
    """
    if alias.find('/') != -1:
        mime = alias
    else:
        mime = MIME_ALIAS.get(alias, None)
    assert(mime) # shouldn't be empty
    return mime

class ATCTMixin(TemplateMixin):
    """Mixin class for AT Content Types"""
    schema         =  BaseSchema + Schema((
        # TemplateMixin
        StringField('layout',
                    accessor="getLayout",
                    mutator="setLayout",
                    default_method="getDefaultLayout",
                    vocabulary="_voc_templates",
                    widget=SelectionWidget(
                        description="Choose a template that will be used for viewing this item.",
                        description_msgid = "help_template_mixin",
                        label = "View template",
                        label_msgid = "label_template_mixin",
                        i18n_domain = "plone",
                        visible={'view' : 'hidden',
                                 'edit' : 'hidden'},
        )),
    ))

    #content_icon   = 'document_icon.gif'
    meta_type      = 'ATContentType'
    archetype_name = 'AT Content Type'
    immediate_view = 'base_view'
    suppl_views    = ()
    newTypeFor     = ()
    typeDescription= ''
    typeDescMsgId  = ''
    assocMimetypes = ()
    assocFileExt   = ()
    cmf_edit_kws   = ()

    security       = ClassSecurityInfo()

    security.declareProtected(CMFCorePermissions.ModifyPortalContent,
                              'initializeArchetype')
    def initializeArchetype(self, **kwargs):
        """called by the generated addXXX factory in types tool

        Overwritten to call edit() instead of update() to have the cmf
        compatibility method.
        """
        try:
            self.initializeLayers()
            self.setDefaults()
            if kwargs:
                self.edit(**kwargs)
            self._signature = self.Schema().signature()
        except Exception, msg:
            _zlogger.log_exc()
            if DEBUG and str(msg) not in ('SESSION',):
                # XXX debug code
                raise
                #_default_logger.log_exc()

    def _getPortalTypeName(self):
        """
        """
        ptTool = getToolByName(self, 'portal_types', None)

        portal_type = self.portal_type
        if callable(portal_type):
                portal_type = portal_type()

        if ptTool is None:
            # this may when we don't have an acquisition context
            return portal_type

        # make it easy to derive from atct:
        newTypeFor = self.__class__.__dict__.get('newTypeFor', None)
        if newTypeFor:
            correct_pt = self.newTypeFor[0]
        else:
            correct_pt = portal_type

        fti = ptTool.getTypeInfo(correct_pt)
        if fti is None:
            # FTI is None which may happen in ATCT2CMF switching
            # script in this case the self.portal_type aka
            # self.__class__.__name__ is right but test to be sure
            assert(portal_type, self.__class__.__name__)
            return portal_type
        if fti.Metatype() == self.meta_type:
            return correct_pt
        else:
            return portal_type

    security.declareProtected(CMFCorePermissions.ModifyPortalContent, 'edit')
    def edit(self, *args, **kwargs):
        """Reimplementing edit() to have a compatibility method for the old
        cmf edit() method
        """
        if len(args) != 0:
            # use cmf edit method
            return self.cmf_edit(*args, **kwargs)
        
        # if kwargs is containing a key that is also in the list of cmf edit
        # keywords then we have to use the cmf_edit comp. method
        cmf_edit_kws = getattr(aq_inner(self).aq_explicit, 'cmf_edit_kws', ())
        for kwname in kwargs.keys():
            if kwname in cmf_edit_kws:
                return self.cmf_edit(**kwargs)
        # standard AT edit - redirect to update()
        return self.update(**kwargs)

    security.declarePrivate('cmf_edit')
    def cmf_edit(self, *args, **kwargs):
        """Overwrite this method to make AT compatible with the crappy CMF edit()
        """
        raise NotImplementedError("cmf_edit method isn't implemented")

InitializeClass(ATCTMixin)

class ATCTContent(ATCTMixin, BaseContent):
    """Base class for non folderish AT Content Types"""

    __implements__ = (BaseContent.__implements__, )

    security       = ClassSecurityInfo()

InitializeClass(ATCTContent)


class FileContent(ATCTContent):
    """Base class for content types containing a file like File

    The file field *must* be the exclusive primary field
    """

    schema = ATCTContent.schema + Schema((
        FileField('file',
              required=False,
              searchable=True,
              primary=True,
              widget = FileWidget(
                        description = "Select the file to be added by clicking the 'Browse' button.",
                        description_msgid = "help_file",
                        label= "File",
                        label_msgid = "label_file",
                        i18n_domain = "plone",
                        show_content_type = False,)),
        ))
    
    schema['description'].isMetadata = False
    schema['description'].schemata = 'default'
    
    __implements__ = ( ATCTContent.__implements__, )
    security       = ClassSecurityInfo()

    security.declareProtected(CMFCorePermissions.View, 'download')
    def download(self, REQUEST=None, RESPONSE=None):
        """Download the file (use default index_html)
        """
        if REQUEST is None:
            REQUEST = self.REQUEST
        if RESPONSE is None:
            RESPONSE = REQUEST.RESPONSE
        field = self.getPrimaryField()
        return field.download(self, REQUEST, RESPONSE)
    
    security.declareProtected(CMFCorePermissions.View, 'get_data')
    def get_data(self):
        """CMF compatibility method
        """
        data = aq_base(self.getPrimaryField().getAccessor(self)())
        return str(getattr(data, 'data', data))

    data = ComputedAttribute(get_data, 1)

    security.declareProtected(CMFCorePermissions.View, 'get_size')
    def get_size(self):
        """CMF compatibility method
        """
        f = self.getPrimaryField().getAccessor(self)()
        return f and f.get_size() or 0

    security.declareProtected(CMFCorePermissions.View, 'size')
    def size(self):
        """Get size (image_view.pt)
        """
        return self.get_size()

    security.declareProtected(CMFCorePermissions.View, 'get_content_type')
    def get_content_type(self):
        """CMF compatibility method
        """
        f = self.getPrimaryField().getAccessor(self)()
        return f and f.getContentType() or 'text/plain' #'application/octet-stream'

    content_type = ComputedAttribute(get_content_type, 1)
    
    def __str__(self):
        """cmf compatibility
        """
        return self.get_data()
        
    security.declareProtected(CMFCorePermissions.View, 'icon')
    def icon(self):
        """for ZMI
        """
        return self.getIcon()
        
    security.declarePrivate('cmf_edit')
    def cmf_edit(self, precondition='', file=None):
        if file is not None:
            self.setFile(file)

InitializeClass(FileContent)

