/*
 * Copyright (c) 2025, Mediatek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MT_SPM_VCOREFS_REG_H
#define MT_SPM_VCOREFS_REG_H

#include <platform_def.h>

#define DVFSRC_REG_SIZE	0x1000

#define DVFSRC_BASIC_CONTROL	      (DVFSRC_BASE + 0x0)
#define DVFSRC_BASIC_CONTROL_2        (DVFSRC_BASE + 0x4)
#define DVFSRC_BASIC_CONTROL_3        (DVFSRC_BASE + 0x8)
#define DVFSRC_BASIC_CONTROL_4        (DVFSRC_BASE + 0xC)
#define DVFSRC_SW_REQ1                (DVFSRC_BASE + 0x10)
#define DVFSRC_SW_REQ2                (DVFSRC_BASE + 0x14)
#define DVFSRC_SW_REQ3                (DVFSRC_BASE + 0x18)
#define DVFSRC_SW_REQ4                (DVFSRC_BASE + 0x1C)
#define DVFSRC_SW_REQ5                (DVFSRC_BASE + 0x20)
#define DVFSRC_SW_REQ6                (DVFSRC_BASE + 0x24)
#define DVFSRC_SW_REQ7                (DVFSRC_BASE + 0x28)
#define DVFSRC_SW_REQ8                (DVFSRC_BASE + 0x2C)
#define DVFSRC_VCORE_REQUEST          (DVFSRC_BASE + 0x80)
#define DVFSRC_VCORE_REQUEST2         (DVFSRC_BASE + 0x84)
#define DVFSRC_VCORE_REQUEST3         (DVFSRC_BASE + 0x88)
#define DVFSRC_VCORE_REQUEST4         (DVFSRC_BASE + 0x8C)
#define DVFSRC_MD_VSRAM_REMAP         (DVFSRC_BASE + 0xC0)
#define DVFSRC_INT                    (DVFSRC_BASE + 0xC8)
#define DVFSRC_INT_EN                 (DVFSRC_BASE + 0xCC)
#define DVFSRC_MD_TURBO               (DVFSRC_BASE + 0xE0)
#define DVFSRC_PCIE_VCORE_REQ         (DVFSRC_BASE + 0xE4)
#define DVFSRC_VCORE_USER_REQ         (DVFSRC_BASE + 0xE8)
#define DVFSRC_BW_USER_REQ            (DVFSRC_BASE + 0xEC)
#define DVFSRC_DEBOUNCE_FOUR          (DVFSRC_BASE + 0xF0)
#define DVFSRC_DEBOUNCE_RISE_FALL     (DVFSRC_BASE + 0xF4)
#define DVFSRC_TIMEOUT_NEXTREQ        (DVFSRC_BASE + 0xF8)
#define DVFSRC_LEVEL_LABEL_0_1        (DVFSRC_BASE + 0xFC)
#define DVFSRC_LEVEL_LABEL_2_3        (DVFSRC_BASE + 0x100)
#define DVFSRC_LEVEL_LABEL_4_5        (DVFSRC_BASE + 0x104)
#define DVFSRC_LEVEL_LABEL_6_7        (DVFSRC_BASE + 0x108)
#define DVFSRC_LEVEL_LABEL_8_9        (DVFSRC_BASE + 0x10C)
#define DVFSRC_LEVEL_LABEL_10_11      (DVFSRC_BASE + 0x110)
#define DVFSRC_LEVEL_LABEL_12_13      (DVFSRC_BASE + 0x114)
#define DVFSRC_LEVEL_LABEL_14_15      (DVFSRC_BASE + 0x118)
#define DVFSRC_LEVEL_LABEL_16_17      (DVFSRC_BASE + 0x11C)
#define DVFSRC_LEVEL_LABEL_18_19      (DVFSRC_BASE + 0x120)
#define DVFSRC_LEVEL_LABEL_20_21      (DVFSRC_BASE + 0x124)
#define DVFSRC_LEVEL_LABEL_22_23      (DVFSRC_BASE + 0x128)
#define DVFSRC_LEVEL_LABEL_24_25      (DVFSRC_BASE + 0x12C)
#define DVFSRC_LEVEL_LABEL_26_27      (DVFSRC_BASE + 0x130)
#define DVFSRC_LEVEL_LABEL_28_29      (DVFSRC_BASE + 0x134)
#define DVFSRC_LEVEL_LABEL_30_31      (DVFSRC_BASE + 0x138)
#define DVFSRC_LEVEL_LABEL_32_33      (DVFSRC_BASE + 0x13C)
#define DVFSRC_LEVEL_LABEL_34_35      (DVFSRC_BASE + 0x140)
#define DVFSRC_LEVEL_LABEL_36_37      (DVFSRC_BASE + 0x144)
#define DVFSRC_LEVEL_LABEL_38_39      (DVFSRC_BASE + 0x148)
#define DVFSRC_LEVEL_LABEL_40_41      (DVFSRC_BASE + 0x14C)
#define DVFSRC_LEVEL_LABEL_42_43      (DVFSRC_BASE + 0x150)
#define DVFSRC_LEVEL_LABEL_44_45      (DVFSRC_BASE + 0x154)
#define DVFSRC_LEVEL_LABEL_46_47      (DVFSRC_BASE + 0x158)
#define DVFSRC_LEVEL_LABEL_48_49      (DVFSRC_BASE + 0x15C)
#define DVFSRC_LEVEL_LABEL_50_51      (DVFSRC_BASE + 0x160)
#define DVFSRC_LEVEL_LABEL_52_53      (DVFSRC_BASE + 0x164)
#define DVFSRC_LEVEL_LABEL_54_55      (DVFSRC_BASE + 0x168)
#define DVFSRC_LEVEL_LABEL_56_57      (DVFSRC_BASE + 0x16C)
#define DVFSRC_LEVEL_LABEL_58_59      (DVFSRC_BASE + 0x170)
#define DVFSRC_LEVEL_LABEL_60_61      (DVFSRC_BASE + 0x174)
#define DVFSRC_LEVEL_LABEL_62_63      (DVFSRC_BASE + 0x178)
#define DVFSRC_SW_BW_0                (DVFSRC_BASE + 0x1DC)
#define DVFSRC_SW_BW_1                (DVFSRC_BASE + 0x1E0)
#define DVFSRC_SW_BW_2                (DVFSRC_BASE + 0x1E4)
#define DVFSRC_SW_BW_3                (DVFSRC_BASE + 0x1E8)
#define DVFSRC_SW_BW_4                (DVFSRC_BASE + 0x1EC)
#define DVFSRC_SW_BW_5                (DVFSRC_BASE + 0x1F0)
#define DVFSRC_SW_BW_6                (DVFSRC_BASE + 0x1F4)
#define DVFSRC_SW_BW_7                (DVFSRC_BASE + 0x1F8)
#define DVFSRC_SW_BW_8                (DVFSRC_BASE + 0x1FC)
#define DVFSRC_SW_BW_9                (DVFSRC_BASE + 0x200)
#define DVFSRC_QOS_EN                 (DVFSRC_BASE + 0x204)
#define DVFSRC_MD_BW_URG              (DVFSRC_BASE + 0x208)
#define DVFSRC_ISP_HRT                (DVFSRC_BASE + 0x20C)
#define DVFSRC_HRT_BW_BASE            (DVFSRC_BASE + 0x210)
#define DVFSRC_EMI_MON_DEBOUNCE_TIME  (DVFSRC_BASE + 0x218)
#define DVFSRC_MD_LATENCY_IMPROVE     (DVFSRC_BASE + 0x21C)
#define DVFSRC_DEBOUNCE_TIME          (DVFSRC_BASE + 0x220)
#define DVFSRC_LEVEL_MASK_1           (DVFSRC_BASE + 0x224)
#define DVFSRC_LEVEL_MASK_2           (DVFSRC_BASE + 0x228)
#define DVFSRC_DEFAULT_OPP_1          (DVFSRC_BASE + 0x22C)
#define DVFSRC_DEFAULT_OPP_2          (DVFSRC_BASE + 0x230)
#define DVFSRC_95MD_SCEN_EMI0         (DVFSRC_BASE + 0x234)
#define DVFSRC_95MD_SCEN_EMI1         (DVFSRC_BASE + 0x238)
#define DVFSRC_95MD_SCEN_EMI2         (DVFSRC_BASE + 0x23C)
#define DVFSRC_95MD_SCEN_EMI3         (DVFSRC_BASE + 0x240)
#define DVFSRC_95MD_SCEN_EMI0_T       (DVFSRC_BASE + 0x244)
#define DVFSRC_95MD_SCEN_EMI1_T       (DVFSRC_BASE + 0x248)
#define DVFSRC_95MD_SCEN_EMI2_T       (DVFSRC_BASE + 0x24C)
#define DVFSRC_95MD_SCEN_EMI3_T       (DVFSRC_BASE + 0x250)
#define DVFSRC_95MD_SCEN_EMI4         (DVFSRC_BASE + 0x254)
#define DVFSRC_95MD_SCEN_BW0          (DVFSRC_BASE + 0x258)
#define DVFSRC_95MD_SCEN_BW1          (DVFSRC_BASE + 0x25C)
#define DVFSRC_95MD_SCEN_BW2          (DVFSRC_BASE + 0x260)
#define DVFSRC_95MD_SCEN_BW3          (DVFSRC_BASE + 0x264)
#define DVFSRC_95MD_SCEN_BW0_T        (DVFSRC_BASE + 0x268)
#define DVFSRC_95MD_SCEN_BW1_T        (DVFSRC_BASE + 0x26C)
#define DVFSRC_95MD_SCEN_BW2_T        (DVFSRC_BASE + 0x270)
#define DVFSRC_95MD_SCEN_BW3_T        (DVFSRC_BASE + 0x274)
#define DVFSRC_95MD_SCEN_BWU          (DVFSRC_BASE + 0x278)
#define DVFSRC_MD_LEVEL_SW_REG        (DVFSRC_BASE + 0x27C)
#define DVFSRC_RSRV_0                 (DVFSRC_BASE + 0x280)
#define DVFSRC_RSRV_1                 (DVFSRC_BASE + 0x284)
#define DVFSRC_RSRV_2                 (DVFSRC_BASE + 0x288)
#define DVFSRC_RSRV_3                 (DVFSRC_BASE + 0x28C)
#define DVFSRC_RSRV_4                 (DVFSRC_BASE + 0x290)
#define DVFSRC_RSRV_5                 (DVFSRC_BASE + 0x294)
#define DVFSRC_SPM_RESEND             (DVFSRC_BASE + 0x298)
#define DVFSRC_DEBUG_STA_0            (DVFSRC_BASE + 0x29C)
#define DVFSRC_DEBUG_STA_1            (DVFSRC_BASE + 0x2A0)
#define DVFSRC_DEBUG_STA_2            (DVFSRC_BASE + 0x2A4)
#define DVFSRC_DEBUG_STA_3            (DVFSRC_BASE + 0x2A8)
#define DVFSRC_DEBUG_STA_4            (DVFSRC_BASE + 0x2AC)
#define DVFSRC_DEBUG_STA_5            (DVFSRC_BASE + 0x2B0)
#define DVFSRC_DEBUG_STA_6            (DVFSRC_BASE + 0x2B4)
#define DVFSRC_DEBUG_STA_7            (DVFSRC_BASE + 0x2B8)
#define DVFSRC_DEBUG_STA_8            (DVFSRC_BASE + 0x2BC)
#define DVFSRC_DEBUG_STA_9            (DVFSRC_BASE + 0x2C0)
#define DVFSRC_DDR_REQUEST            (DVFSRC_BASE + 0x2C8)
#define DVFSRC_DDR_REQUEST2           (DVFSRC_BASE + 0x2CC)
#define DVFSRC_DDR_REQUEST3           (DVFSRC_BASE + 0x2D0)
#define DVFSRC_DDR_REQUEST4           (DVFSRC_BASE + 0x2D4)
#define DVFSRC_DDR_REQUEST5           (DVFSRC_BASE + 0x2D8)
#define DVFSRC_DDR_REQUEST6           (DVFSRC_BASE + 0x2DC)
#define DVFSRC_DDR_HRT                (DVFSRC_BASE + 0x2E0)
#define DVFSRC_DDR_HRT_1              (DVFSRC_BASE + 0x2E4)
#define DVFSRC_DDR_QOS0               (DVFSRC_BASE + 0x2E8)
#define DVFSRC_DDR_QOS1               (DVFSRC_BASE + 0x2EC)
#define DVFSRC_DDR_QOS2               (DVFSRC_BASE + 0x2F0)
#define DVFSRC_DDR_QOS3               (DVFSRC_BASE + 0x2F4)
#define DVFSRC_DDR_QOS4               (DVFSRC_BASE + 0x2F8)
#define DVFSRC_DDR_QOS5               (DVFSRC_BASE + 0x2FC)
#define DVFSRC_DDR_QOS6               (DVFSRC_BASE + 0x300)
#define DVFSRC_HRT_REQ_UNIT           (DVFSRC_BASE + 0x31C)
#define DVFSRC_HRT_REQ_MD_URG         (DVFSRC_BASE + 0x320)
#define DVFSRC_HRT_REQ_MD_BW_0        (DVFSRC_BASE + 0x324)
#define DVFSRC_HRT_REQ_MD_BW_1        (DVFSRC_BASE + 0x328)
#define DVFSRC_HRT_REQ_MD_BW_2        (DVFSRC_BASE + 0x32C)
#define DVFSRC_HRT_REQ_MD_BW_3        (DVFSRC_BASE + 0x330)
#define DVFSRC_HRT_REQ_MD_BW_4        (DVFSRC_BASE + 0x334)
#define DVFSRC_HRT_REQ_MD_BW_5        (DVFSRC_BASE + 0x338)
#define DVFSRC_HRT_REQ_MD_BW_6        (DVFSRC_BASE + 0x33C)
#define DVFSRC_HRT_REQ_MD_BW_7        (DVFSRC_BASE + 0x340)
#define DVFSRC_HRT_REQ_MD_BW_8        (DVFSRC_BASE + 0x344)
#define DVFSRC_HRT_REQ_MD_BW_9        (DVFSRC_BASE + 0x348)
#define DVFSRC_HRT_REQ_MD_BW_10       (DVFSRC_BASE + 0x34C)
#define DVFSRC_HRT1_REQ_MD_BW_0       (DVFSRC_BASE + 0x350)
#define DVFSRC_HRT1_REQ_MD_BW_1       (DVFSRC_BASE + 0x354)
#define DVFSRC_HRT1_REQ_MD_BW_2       (DVFSRC_BASE + 0x358)
#define DVFSRC_HRT1_REQ_MD_BW_3       (DVFSRC_BASE + 0x35C)
#define DVFSRC_HRT1_REQ_MD_BW_4       (DVFSRC_BASE + 0x360)
#define DVFSRC_HRT1_REQ_MD_BW_5       (DVFSRC_BASE + 0x364)
#define DVFSRC_HRT1_REQ_MD_BW_6       (DVFSRC_BASE + 0x368)
#define DVFSRC_HRT1_REQ_MD_BW_7       (DVFSRC_BASE + 0x36C)
#define DVFSRC_HRT1_REQ_MD_BW_8       (DVFSRC_BASE + 0x370)
#define DVFSRC_HRT1_REQ_MD_BW_9       (DVFSRC_BASE + 0x374)
#define DVFSRC_HRT1_REQ_MD_BW_10      (DVFSRC_BASE + 0x378)
#define DVFSRC_HRT_REQ_BW_SW_REG      (DVFSRC_BASE + 0x37C)
#define DVFSRC_HRT_REQUEST            (DVFSRC_BASE + 0x380)
#define DVFSRC_HRT_HIGH_3             (DVFSRC_BASE + 0x384)
#define DVFSRC_HRT_HIGH_2             (DVFSRC_BASE + 0x388)
#define DVFSRC_HRT_HIGH_1             (DVFSRC_BASE + 0x38C)
#define DVFSRC_HRT_HIGH               (DVFSRC_BASE + 0x390)
#define DVFSRC_HRT_LOW_3              (DVFSRC_BASE + 0x394)
#define DVFSRC_HRT_LOW_2              (DVFSRC_BASE + 0x398)
#define DVFSRC_HRT_LOW_1              (DVFSRC_BASE + 0x39C)
#define DVFSRC_HRT_LOW                (DVFSRC_BASE + 0x3A0)
#define DVFSRC_DDR_ADD_REQUEST        (DVFSRC_BASE + 0x3A4)
#define DVFSRC_EMI_ADD_REQUEST        (DVFSRC_BASE + 0x3A8)
#define DVFSRC_MD_SCENARIO            (DVFSRC_BASE + 0x3B4)
#define DVFSRC_CURRENT_LEVEL_1        (DVFSRC_BASE + 0x5C4)
#define DVFSRC_CURRENT_LEVEL_2        (DVFSRC_BASE + 0x5C8)
#define DVFSRC_TARGET_LEVEL_1         (DVFSRC_BASE + 0x5CC)
#define DVFSRC_TARGET_LEVEL_2         (DVFSRC_BASE + 0x5D0)
#define DVFSRC_CURRENT_FORCE_1        (DVFSRC_BASE + 0x5D4)
#define DVFSRC_CURRENT_FORCE_2        (DVFSRC_BASE + 0x5D8)
#define DVFSRC_TARGET_FORCE_1         (DVFSRC_BASE + 0x5DC)
#define DVFSRC_TARGET_FORCE_2         (DVFSRC_BASE + 0x5E0)
#define DVFSRC_MD_DDR_FLOOR_REQUEST   (DVFSRC_BASE + 0x5E4)
#define DVFSRC_QOS_DDR_REQUEST        (DVFSRC_BASE + 0x5E8)
#define DVFSRC_FORCE_MASK             (DVFSRC_BASE + 0x5EC)
#define DVFSRC_LEVEL_HEX              (DVFSRC_BASE + 0x5F0)
#define DVFSRC_AVS_RETRY              (DVFSRC_BASE + 0x5F4)
#define DVFSRC_SW_REQ9                (DVFSRC_BASE + 0x5F8)
#define DVFSRC_SW_REQ10               (DVFSRC_BASE + 0x5FC)
#define DVFSRC_SW_REQ11               (DVFSRC_BASE + 0x600)
#define DVFSRC_SW_REQ12               (DVFSRC_BASE + 0x604)
#define DVFSRC_LEVEL_MASK_SW_1        (DVFSRC_BASE + 0x608)
#define DVFSRC_LEVEL_MASK_SW_2        (DVFSRC_BASE + 0x60C)
#define DVFSRC_ACCEPT_RETRY           (DVFSRC_BASE + 0x610)
#define DVFSRC_TARGET_LEVEL_SPM_1     (DVFSRC_BASE + 0x614)
#define DVFSRC_TARGET_LEVEL_SPM_2     (DVFSRC_BASE + 0x618)
#define DVFSRC_HRT_REQ_MD_BW_11       (DVFSRC_BASE + 0x61C)
#define DVFSRC_HRT_REQ_MD_BW_12       (DVFSRC_BASE + 0x620)
#define DVFSRC_HRT_REQ_MD_BW_13       (DVFSRC_BASE + 0x624)
#define DVFSRC_HRT_REQ_MD_BW_14       (DVFSRC_BASE + 0x628)
#define DVFSRC_HRT_REQ_MD_BW_15       (DVFSRC_BASE + 0x62C)
#define DVFSRC_HRT_REQ_MD_BW_16       (DVFSRC_BASE + 0x630)
#define DVFSRC_HRT_REQ_MD_BW_17       (DVFSRC_BASE + 0x634)
#define DVFSRC_HRT_REQ_MD_BW_18       (DVFSRC_BASE + 0x638)
#define DVFSRC_HRT_REQ_MD_BW_19       (DVFSRC_BASE + 0x63C)
#define DVFSRC_HRT_REQ_MD_BW_20       (DVFSRC_BASE + 0x640)
#define DVFSRC_HRT_REQ_MD_BW_21       (DVFSRC_BASE + 0x644)
#define DVFSRC_HRT1_REQ_MD_BW_11      (DVFSRC_BASE + 0x648)
#define DVFSRC_HRT1_REQ_MD_BW_12      (DVFSRC_BASE + 0x64C)
#define DVFSRC_HRT1_REQ_MD_BW_13      (DVFSRC_BASE + 0x650)
#define DVFSRC_HRT1_REQ_MD_BW_14      (DVFSRC_BASE + 0x654)
#define DVFSRC_HRT1_REQ_MD_BW_15      (DVFSRC_BASE + 0x658)
#define DVFSRC_HRT1_REQ_MD_BW_16      (DVFSRC_BASE + 0x65C)
#define DVFSRC_HRT1_REQ_MD_BW_17      (DVFSRC_BASE + 0x660)
#define DVFSRC_HRT1_REQ_MD_BW_18      (DVFSRC_BASE + 0x664)
#define DVFSRC_HRT1_REQ_MD_BW_19      (DVFSRC_BASE + 0x668)
#define DVFSRC_HRT1_REQ_MD_BW_20      (DVFSRC_BASE + 0x66C)
#define DVFSRC_HRT1_REQ_MD_BW_21      (DVFSRC_BASE + 0x670)
#define DVFSRC_95MD_SCEN_BW4          (DVFSRC_BASE + 0x6B4)
#define DVFSRC_95MD_SCEN_BW5          (DVFSRC_BASE + 0x6B8)
#define DVFSRC_95MD_SCEN_BW6          (DVFSRC_BASE + 0x6BC)
#define DVFSRC_95MD_SCEN_BW7          (DVFSRC_BASE + 0x6C0)
#define DVFSRC_95MD_SCEN_BW4_T        (DVFSRC_BASE + 0x6C4)
#define DVFSRC_95MD_SCEN_BW5_T        (DVFSRC_BASE + 0x6C8)
#define DVFSRC_95MD_SCEN_BW6_T        (DVFSRC_BASE + 0x6CC)
#define DVFSRC_95MD_SCEN_BW7_T        (DVFSRC_BASE + 0x6D0)
#define DVFSRC_DDR_ADD_REQUEST_1      (DVFSRC_BASE + 0x6D4)
#define DVFSRC_EMI_ADD_REQUEST_1      (DVFSRC_BASE + 0x6D8)

#define DVFSRC_TARGET_REQ_MASK (1 << 16)
#define DVFSRC_EN_MASK		1

#endif /* MT_SPM_VCOREFS_REG_H */
