/*
 * Copyright (c) 2025, MediaTek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef PLAT_DFD_H
#define PLAT_DFD_H

#include <lib/mmio.h>
#include <platform_def.h>

#define sync_writel(addr, val) do { mmio_write_32((addr), (val)); dsbsy(); } while (0)

#define PLAT_MTK_DFD_SETUP_MAGIC		(0x99716150)
#define PLAT_MTK_DFD_READ_MAGIC			(0x99716151)
#define PLAT_MTK_DFD_WRITE_MAGIC		(0x99716152)

#define MCU_BIU_BASE				(MCUCFG_BASE)
#define MISC1_CFG_BASE				(MCU_BIU_BASE + 0xE040)
#define DFD_CTRL				(MCU_BIU_BASE + 0X8040)
#define DFD_CNT_L				(MCU_BIU_BASE + 0X8044)
#define DFD_CNT_H				(MCU_BIU_BASE + 0X8048)
#define DFD_INTERNAL_CTL			(MCU_BIU_BASE + 0XE040)
#define DFD_INTERNAL_COUNTER			(MCU_BIU_BASE + 0XE044)
#define DFD_INTERNAL_PWR_ON			(MCU_BIU_BASE + 0XE048)
#define DFD_INTERNAL_CHAIN_LENGTH_0		(MCU_BIU_BASE + 0XE04C)
#define DFD_INTERNAL_SHIFT_CLK_RATIO		(MCU_BIU_BASE + 0XE050)
#define DFD_INTERNAL_COUNTER_RETURN		(MCU_BIU_BASE + 0XE054)
#define DFD_INTERNAL_SRAM_ACCESS		(MCU_BIU_BASE + 0XE058)
#define DFD_FINISH_WAIT_TIME			(MCU_BIU_BASE + 0XE05C)
#define DFD_INTERNAL_CHAIN_GROUP		(MCU_BIU_BASE + 0XE060)
#define DFD_INTERNAL_CHAIN_INV_INFO_LL		(MCU_BIU_BASE + 0XE064)
#define DFD_INTERNAL_CHAIN_INV_INFO_LH		(MCU_BIU_BASE + 0XE068)
#define DFD_INTERNAL_CHAIN_INV_INFO_HL		(MCU_BIU_BASE + 0XE06C)
#define DFD_INTERNAL_CHAIN_INV_INFO_HH		(MCU_BIU_BASE + 0XE070)
#define DFD_INTERNAL_TEST_SO_OVER_64		(MCU_BIU_BASE + 0XE074)
#define DFD_INTERNAL_MASK_OUT			(MCU_BIU_BASE + 0XE078)
#define DFD_INTERNAL_SW_NS_TRIGGER		(MCU_BIU_BASE + 0XE07C)
#define DFD_INTERNAL_MCSI			(MCU_BIU_BASE + 0XE080)
#define DFD_INTERNAL_MCSI_SEL_STATUS		(MCU_BIU_BASE + 0XE084)
#define DFD_V30_CTL				(MCU_BIU_BASE + 0XE088)
#define DFD_POWER_CTL				(MCU_BIU_BASE + 0XE090)
#define DFD_RESET_ON				(MCU_BIU_BASE + 0XE094)
#define DFD_TEST_SI_0				(MCU_BIU_BASE + 0XE098)
#define DFD_TEST_SI_1				(MCU_BIU_BASE + 0XE09C)
#define DFD_STATUS_CLEAN			(MCU_BIU_BASE + 0XE0A0)
#define DFD_STATUS_RETURN			(MCU_BIU_BASE + 0XE0A4)
#define DFD_V35_ENABLE				(MCU_BIU_BASE + 0XE0A8)
#define DFD_V35_TAP_NUMBER			(MCU_BIU_BASE + 0XE0AC)
#define DFD_V35_TAP_EN				(MCU_BIU_BASE + 0XE0B0)
#define DFD_V35_CTL				(MCU_BIU_BASE + 0XE0B4)
#define DFD_V35_TAP_SEQ0			(MCU_BIU_BASE + 0XE0B8)
#define DFD_V35_TAP_SEQ1			(MCU_BIU_BASE + 0XE0BC)
#define DFD_V35_SEQ0_0				(MCU_BIU_BASE + 0XE0C0)
#define DFD_V35_SEQ0_1				(MCU_BIU_BASE + 0XE0C4)
#define DFD_V35_SEQ1_0				(MCU_BIU_BASE + 0XE0C8)
#define DFD_V35_SEQ1_1				(MCU_BIU_BASE + 0XE0CC)
#define DFD_V35_SEQ2_0				(MCU_BIU_BASE + 0XE0D0)
#define DFD_V35_SEQ2_1				(MCU_BIU_BASE + 0XE0D4)
#define DFD_SOC_CLOCK_STOP_MASK			(MCU_BIU_BASE + 0XE0F0)
#define DFD_HW_TRIGGER_MASK			(MCU_BIU_BASE + 0XE0FC)
#define DFD_V50_ENABLE				(MCU_BIU_BASE + 0XE100)
#define DFD_V50_SELF_TRIGGER_ITERATION		(MCU_BIU_BASE + 0XE104)
#define DFD_V50_START_TRIGGER			(MCU_BIU_BASE + 0XE108)
#define DFD_V50_CPUCK_HALT			(MCU_BIU_BASE + 0XE10C)
#define DFD_V50_26M_RESUME			(MCU_BIU_BASE + 0XE110)
#define DFD_V50_26M_HALT_RELEASE		(MCU_BIU_BASE + 0XE114)
#define DFD_V50_SYSTEM_HALT_TIME		(MCU_BIU_BASE + 0XE118)
#define DFD_V50_GROUP_0_1_DIFF			(MCU_BIU_BASE + 0XE11C)
#define DFD_V50_GROUP_0_2_DIFF			(MCU_BIU_BASE + 0XE120)
#define DFD_V50_GROUP_0_3_DIFF			(MCU_BIU_BASE + 0XE124)
#define DFD_V50_GROUP_0_4_DIFF			(MCU_BIU_BASE + 0XE128)
#define DFD_V50_GROUP_0_5_DIFF			(MCU_BIU_BASE + 0XE12C)
#define DFD_V50_GROUP_0_6_DIFF			(MCU_BIU_BASE + 0XE130)
#define DFD_V50_GROUP_0_7_DIFF			(MCU_BIU_BASE + 0XE134)
#define DFD_V50_GROUP_0_8_DIFF			(MCU_BIU_BASE + 0XE138)
#define DFD_V50_GROUP_0_9_DIFF			(MCU_BIU_BASE + 0XE13C)
#define DFD_V50_GROUP_0_10_DIFF			(MCU_BIU_BASE + 0XE140)
#define DFD_V50_GROUP_0_11_DIFF			(MCU_BIU_BASE + 0XE144)
#define DFD_V50_GROUP_0_12_DIFF			(MCU_BIU_BASE + 0XE148)
#define DFD_V50_GROUP_0_13_DIFF			(MCU_BIU_BASE + 0XE14C)
#define DFD_V50_GROUP_0_14_DIFF			(MCU_BIU_BASE + 0XE150)
#define DFD_V50_GROUP_0_15_DIFF			(MCU_BIU_BASE + 0XE154)
#define DFD_V50_GROUP_0_16_DIFF			(MCU_BIU_BASE + 0XE158)
#define DFD_V50_GROUP_0_17_DIFF			(MCU_BIU_BASE + 0XE15C)
#define DFD_V50_GROUP_0_18_DIFF			(MCU_BIU_BASE + 0XE160)
#define DFD_V50_GROUP_0_19_DIFF			(MCU_BIU_BASE + 0XE164)
#define DFD_V50_GROUP_0_20_DIFF			(MCU_BIU_BASE + 0XE168)
#define DFD_V50_GROUP_0_21_DIFF			(MCU_BIU_BASE + 0XE16C)
#define DFD_V50_GROUP_0_22_DIFF			(MCU_BIU_BASE + 0XE170)
#define DFD_V50_GROUP_0_23_DIFF			(MCU_BIU_BASE + 0XE174)
#define DFD_V50_GROUP_0_24_DIFF			(MCU_BIU_BASE + 0XE178)
#define DFD_V50_GROUP_0_25_DIFF			(MCU_BIU_BASE + 0XE17C)
#define DFD_V50_GROUP_0_26_DIFF			(MCU_BIU_BASE + 0XE180)
#define DFD_V50_GROUP_0_27_DIFF			(MCU_BIU_BASE + 0XE184)
#define DFD_V50_GROUP_0_28_DIFF			(MCU_BIU_BASE + 0XE188)
#define DFD_V50_GROUP_0_29_DIFF			(MCU_BIU_BASE + 0XE18C)
#define DFD_V50_GROUP_0_30_DIFF			(MCU_BIU_BASE + 0XE190)
#define DFD_V50_GROUP_0_31_DIFF			(MCU_BIU_BASE + 0XE194)
#define DFD_V50_CHAIN_GROUP_3_0_INFO		(MCU_BIU_BASE + 0XE198)
#define DFD_V50_CHAIN_GROUP_7_4_INFO		(MCU_BIU_BASE + 0XE19C)
#define DFD_V50_CHAIN_GROUP_11_8_INFO		(MCU_BIU_BASE + 0XE1A0)
#define DFD_V50_CHAIN_GROUP_15_12_INFO		(MCU_BIU_BASE + 0XE1A4)
#define DFD_V50_CHAIN_GROUP_19_16_INFO		(MCU_BIU_BASE + 0XE1A8)
#define DFD_V50_CHAIN_GROUP_23_20_INFO		(MCU_BIU_BASE + 0XE1AC)
#define DFD_V50_CHAIN_GROUP_27_24_INFO		(MCU_BIU_BASE + 0XE1B0)
#define DFD_V50_CHAIN_GROUP_31_28_INFO		(MCU_BIU_BASE + 0XE1B4)
#define DFD_V50_CHAIN_GROUP_35_32_INFO		(MCU_BIU_BASE + 0XE1B8)
#define DFD_V50_CHAIN_GROUP_39_36_INFO		(MCU_BIU_BASE + 0XE1BC)
#define DFD_V50_CHAIN_GROUP_43_40_INFO		(MCU_BIU_BASE + 0XE1C0)
#define DFD_V50_CHAIN_GROUP_47_44_INFO		(MCU_BIU_BASE + 0XE1C4)
#define DFD_V50_CHAIN_GROUP_51_48_INFO		(MCU_BIU_BASE + 0XE1C8)
#define DFD_V50_CHAIN_GROUP_55_52_INFO		(MCU_BIU_BASE + 0XE1CC)
#define DFD_V50_CHAIN_GROUP_59_56_INFO		(MCU_BIU_BASE + 0XE1D0)
#define DFD_V50_CHAIN_GROUP_63_60_INFO		(MCU_BIU_BASE + 0XE1D4)
#define DFD_V50_CHAIN_GROUP_67_64_INFO		(MCU_BIU_BASE + 0XE1D8)
#define DFD_V50_CHAIN_GROUP_71_68_INFO		(MCU_BIU_BASE + 0XE1DC)
#define DFD_V50_CHAIN_GROUP_75_72_INFO		(MCU_BIU_BASE + 0XE1E0)
#define DFD_V50_CHAIN_GROUP_79_76_INFO		(MCU_BIU_BASE + 0XE1E4)
#define DFD_V50_CHAIN_GROUP_83_80_INFO		(MCU_BIU_BASE + 0XE1E8)
#define DFD_V50_CHAIN_GROUP_87_84_INFO		(MCU_BIU_BASE + 0XE1EC)
#define DFD_V50_CHAIN_GROUP_91_88_INFO		(MCU_BIU_BASE + 0XE1F0)
#define DFD_V50_CHAIN_GROUP_95_92_INFO		(MCU_BIU_BASE + 0XE1F4)
#define DFD_V50_CHAIN_GROUP_99_96_INFO		(MCU_BIU_BASE + 0XE1F8)
#define DFD_V50_CHAIN_GROUP_103_100_INFO	(MCU_BIU_BASE + 0XE1FC)
#define DFD_V50_CHAIN_GROUP_107_104_INFO	(MCU_BIU_BASE + 0XE200)
#define DFD_V50_CHAIN_GROUP_111_108_INFO	(MCU_BIU_BASE + 0XE204)
#define DFD_V50_CHAIN_GROUP_115_112_INFO	(MCU_BIU_BASE + 0XE208)
#define DFD_V50_CHAIN_GROUP_119_116_INFO	(MCU_BIU_BASE + 0XE20C)
#define DFD_V50_CHAIN_GROUP_123_120_INFO	(MCU_BIU_BASE + 0XE210)
#define DFD_V50_CHAIN_GROUP_127_124_INFO	(MCU_BIU_BASE + 0XE214)
#define DFD_TEST_SI_2				(MCU_BIU_BASE + 0XE218)
#define DFD_TEST_SI_3				(MCU_BIU_BASE + 0XE21C)
#define DFD_TEST_SO				(MCU_BIU_BASE + 0XE220)
#define DFD_BUS_HALT_TIME			(MCU_BIU_BASE + 0XE224)
#define DFD_READ_ADDR				(MCU_BIU_BASE + 0XE228)
#define DFD_V50_CLK_STOP_TIME			(MCU_BIU_BASE + 0XE22C)
#define DFD_V50_GROUP_0_32_DIFF			(MCU_BIU_BASE + 0XE230)
#define DFD_V50_GROUP_0_33_DIFF			(MCU_BIU_BASE + 0XE234)
#define DFD_V50_GROUP_0_34_DIFF			(MCU_BIU_BASE + 0XE238)
#define DFD_V50_GROUP_0_35_DIFF			(MCU_BIU_BASE + 0XE23C)
#define DFD_V50_GROUP_0_36_DIFF			(MCU_BIU_BASE + 0XE240)
#define DFD_V50_GROUP_0_37_DIFF			(MCU_BIU_BASE + 0XE244)
#define DFD_V50_GROUP_0_38_DIFF			(MCU_BIU_BASE + 0XE248)
#define DFD_V50_GROUP_0_39_DIFF			(MCU_BIU_BASE + 0XE24C)
#define DFD_V50_GROUP_0_40_DIFF			(MCU_BIU_BASE + 0XE250)
#define DFD_V50_GROUP_0_41_DIFF			(MCU_BIU_BASE + 0XE254)
#define DFD_V50_GROUP_0_42_DIFF			(MCU_BIU_BASE + 0XE258)
#define DFD_V50_GROUP_0_43_DIFF			(MCU_BIU_BASE + 0XE25C)
#define DFD_V50_GROUP_0_44_DIFF			(MCU_BIU_BASE + 0XE260)
#define DFD_V50_GROUP_0_45_DIFF			(MCU_BIU_BASE + 0XE264)
#define DFD_V50_GROUP_0_46_DIFF			(MCU_BIU_BASE + 0XE268)
#define DFD_V50_GROUP_0_47_DIFF			(MCU_BIU_BASE + 0XE26C)
#define DFD_V50_GROUP_0_48_DIFF			(MCU_BIU_BASE + 0XE270)
#define DFD_V50_GROUP_0_49_DIFF			(MCU_BIU_BASE + 0XE274)
#define DFD_V50_GROUP_0_50_DIFF			(MCU_BIU_BASE + 0XE278)
#define DFD_V50_GROUP_0_51_DIFF			(MCU_BIU_BASE + 0XE27C)
#define DFD_V50_GROUP_0_52_DIFF			(MCU_BIU_BASE + 0XE280)
#define DFD_V50_GROUP_0_53_DIFF			(MCU_BIU_BASE + 0XE284)
#define DFD_V50_GROUP_0_54_DIFF			(MCU_BIU_BASE + 0XE288)
#define DFD_V50_GROUP_0_55_DIFF			(MCU_BIU_BASE + 0XE28C)
#define DFD_V50_GROUP_0_56_DIFF			(MCU_BIU_BASE + 0XE290)
#define DFD_V50_GROUP_0_57_DIFF			(MCU_BIU_BASE + 0XE294)
#define DFD_V50_GROUP_0_58_DIFF			(MCU_BIU_BASE + 0XE298)
#define DFD_V50_GROUP_0_59_DIFF			(MCU_BIU_BASE + 0XE29C)
#define DFD_V50_GROUP_0_60_DIFF			(MCU_BIU_BASE + 0XE2A0)
#define DFD_V50_GROUP_0_61_DIFF			(MCU_BIU_BASE + 0XE2A4)
#define DFD_V50_GROUP_0_62_DIFF			(MCU_BIU_BASE + 0XE2A8)
#define DFD_V50_GROUP_0_63_DIFF			(MCU_BIU_BASE + 0XE2AC)

#define DFD_O_PROTECT_EN_REG			(0x10001220)
#define DFD_O_INTRF_MCU_PWR_CTL_MASK		(0x10001A3C)
#define DFD_O_SET_BASEADDR_REG			(0x10043010)
#define DFD_O_REG_0				(0x10001390)

#define DFD_CACHE_DUMP_ENABLE			(1U)

#define DFD_V35_TAP_EN_VAL			(0x43FF)
#define DFD_V35_SEQ0_0_VAL			(0x63668820)
#define DFD_READ_ADDR_VAL			(0x40000008)
#define DFD_CHAIN_LENGTH_VAL			(0xFFFFFFFF)

#endif /* PLAT_DFD_H */
