/*
 * Copyright (c) 2015-2025, STMicroelectronics - All Rights Reserved
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __USB_DWC3_REGS_H
#define __USB_DWC3_REGS_H

/*
 * USB3 Global Register Block
 */
#define _DWC3_GSBUSCFG0					U(0x0)
#define _DWC3_GSBUSCFG1					U(0x4)
#define _DWC3_GTXTHRCFG					U(0x8)
#define _DWC3_GRXTHRCFG					U(0xC)
#define _DWC3_GCTL					U(0x10)
#define _DWC3_GPMSTS					U(0x14)
#define _DWC3_GSTS					U(0x18)
#define _DWC3_GUCTL1					U(0x1C)
#define _DWC3_GSNPSID					U(0x20)
#define _DWC3_GGPIO					U(0x24)
#define _DWC3_GUID					U(0x28)
#define _DWC3_GUCTL					U(0x2C)
#define _DWC3_GBUSERRADDRLO				U(0x30)
#define _DWC3_GBUSERRADDRHI				U(0x34)
#define _DWC3_GPRTBIMAPLO				U(0x38)
#define _DWC3_GPRTBIMAPHI				U(0x3C)
#define _DWC3_GHWPARAMS0				U(0x40)
#define _DWC3_GHWPARAMS1				U(0x44)
#define _DWC3_GHWPARAMS2				U(0x48)
#define _DWC3_GHWPARAMS3				U(0x4C)
#define _DWC3_GHWPARAMS4				U(0x50)
#define _DWC3_GHWPARAMS5				U(0x54)
#define _DWC3_GHWPARAMS6				U(0x58)
#define _DWC3_GHWPARAMS7				U(0x5C)
#define _DWC3_GDBGFIFOSPACE				U(0x60)
#define _DWC3_GDBGLTSSM					U(0x64)
#define _DWC3_GDBGLNMCC					U(0x68)
#define _DWC3_GDBGBMU					U(0x6C)
#define _DWC3_GDBGLSPMUX_HST				U(0x70)
#define _DWC3_GDBGLSP					U(0x74)
#define _DWC3_GDBGEPINFO0				U(0x78)
#define _DWC3_GDBGEPINFO1				U(0x7C)
#define _DWC3_GPRTBIMAP_HSLO				U(0x80)
#define _DWC3_GPRTBIMAP_HSHI				U(0x84)
#define _DWC3_GPRTBIMAP_FSLO				U(0x88)
#define _DWC3_GPRTBIMAP_FSHI				U(0x8C)
#define _DWC3_GUCTL2					U(0x9C)
#define _DWC3_GUSB2PHYCFG				U(0x100)
#define _DWC3_GUSB2I2CCTL				U(0x140)
#define _DWC3_GUSB2PHYACC_ULPI				U(0x180)
#define _DWC3_GUSB3PIPECTL				U(0x1c0)
#define _DWC3_GTXFIFOSIZ0				U(0x200)
#define _DWC3_GTXFIFOSIZ1				U(0x204)
#define _DWC3_GTXFIFOSIZ2				U(0x208)
#define _DWC3_GTXFIFOSIZ3				U(0x20c)
#define _DWC3_GTXFIFOSIZ4				U(0x210)
#define _DWC3_GTXFIFOSIZ5				U(0x214)
#define _DWC3_GTXFIFOSIZ6				U(0x218)
#define _DWC3_GTXFIFOSIZ7				U(0x21c)
#define _DWC3_GTXFIFOSIZ8				U(0x220)
#define _DWC3_GTXFIFOSIZ9				U(0x224)
#define _DWC3_GTXFIFOSIZ10				U(0x228)
#define _DWC3_GTXFIFOSIZ11				U(0x22c)
#define _DWC3_GRXFIFOSIZ0				U(0x280)
#define _DWC3_GRXFIFOSIZ1				U(0x284)
#define _DWC3_GRXFIFOSIZ2				U(0x288)
#define _DWC3_GEVNTADRLO				U(0x300)
#define _DWC3_GEVNTADRHI				U(0x304)
#define _DWC3_GEVNTSIZ					U(0x308)
#define _DWC3_GEVNTCOUNT				U(0x30c)
#define _DWC3_GHWPARAMS8				U(0x500)
#define _DWC3_GTXFIFOPRIDEV				U(0x510)
#define _DWC3_GTXFIFOPRIHST				U(0x518)
#define _DWC3_GRXFIFOPRIHST				U(0x51C)
#define _DWC3_GDMAHLRATIO				U(0x524)
#define _DWC3_GFLADJ					U(0x530)

/* _DWC3_GSBUSCFG0 register fields */
#define _DWC3_GSBUSCFG0_INCRBRSTENA			BIT_32(0)
#define _DWC3_GSBUSCFG0_INCR4BRSTENA			BIT_32(1)
#define _DWC3_GSBUSCFG0_INCR8BRSTENA			BIT_32(2)
#define _DWC3_GSBUSCFG0_INCR16BRSTENA			BIT_32(3)
#define _DWC3_GSBUSCFG0_INCR32BRSTENA			BIT_32(4)
#define _DWC3_GSBUSCFG0_INCR64BRSTENA			BIT_32(5)
#define _DWC3_GSBUSCFG0_INCR128BRSTENA			BIT_32(6)
#define _DWC3_GSBUSCFG0_INCR256BRSTENA			BIT_32(7)
#define _DWC3_GSBUSCFG0_DESBIGEND			BIT_32(10)
#define _DWC3_GSBUSCFG0_DATBIGEND			BIT_32(11)
#define _DWC3_GSBUSCFG0_DESWRREQINFO_MASK		GENMASK_32(19, 16)
#define _DWC3_GSBUSCFG0_DESWRREQINFO_SHIFT		16
#define _DWC3_GSBUSCFG0_DATWRREQINFO_MASK		GENMASK_32(23, 20)
#define _DWC3_GSBUSCFG0_DATWRREQINFO_SHIFT		20
#define _DWC3_GSBUSCFG0_DESRDREQINFO_MASK		GENMASK_32(27, 24)
#define _DWC3_GSBUSCFG0_DESRDREQINFO_SHIFT		24
#define _DWC3_GSBUSCFG0_DATRDREQINFO_MASK		GENMASK_32(31, 28)
#define _DWC3_GSBUSCFG0_DATRDREQINFO_SHIFT		28

/* _DWC3_GSBUSCFG1 register fields */
#define _DWC3_GSBUSCFG1_PIPETRANSLIMIT_MASK		GENMASK_32(11, 8)
#define _DWC3_GSBUSCFG1_PIPETRANSLIMIT_SHIFT		8
#define _DWC3_GSBUSCFG1_EN1KPAGE			BIT_32(12)

/* _DWC3_GTXTHRCFG register fields */
#define _DWC3_GTXTHRCFG_USBMAXTXBURSTSIZE_MASK		GENMASK_32(23, 16)
#define _DWC3_GTXTHRCFG_USBMAXTXBURSTSIZE_SHIFT		16
#define _DWC3_GTXTHRCFG_USBTXPKTCNT_MASK		GENMASK_32(27, 24)
#define _DWC3_GTXTHRCFG_USBTXPKTCNT_SHIFT		24
#define _DWC3_GTXTHRCFG_USBTXPKTCNTSEL			BIT_32(29)

/* _DWC3_GRXTHRCFG register fields */
#define _DWC3_GRXTHRCFG_RESVISOCOUTSPC_MASK		GENMASK_32(12, 0)
#define _DWC3_GRXTHRCFG_RESVISOCOUTSPC_SHIFT		0
#define _DWC3_GRXTHRCFG_USBMAXRXBURSTSIZE_MASK		GENMASK_32(23, 19)
#define _DWC3_GRXTHRCFG_USBMAXRXBURSTSIZE_SHIFT		19
#define _DWC3_GRXTHRCFG_USBRXPKTCNT_MASK		GENMASK_32(27, 24)
#define _DWC3_GRXTHRCFG_USBRXPKTCNT_SHIFT		24
#define _DWC3_GRXTHRCFG_USBRXPKTCNTSEL			BIT_32(29)

/* _DWC3_GCTL register fields */
#define _DWC3_GCTL_DSBLCLKGTNG				BIT_32(0)
#define _DWC3_GCTL_GBLHIBERNATIONEN			BIT_32(1)
#define _DWC3_GCTL_U2EXIT_LFPS				BIT_32(2)
#define _DWC3_GCTL_DISSCRAMBLE				BIT_32(3)
#define _DWC3_GCTL_SCALEDOWN_MASK			GENMASK_32(5, 4)
#define _DWC3_GCTL_SCALEDOWN_SHIFT			4
#define _DWC3_GCTL_RAMCLKSEL_MASK			GENMASK_32(7, 6)
#define _DWC3_GCTL_RAMCLKSEL_SHIFT			6
#define _DWC3_GCTL_DEBUGATTACH				BIT_32(8)
#define _DWC3_GCTL_U1U2TIMERSCALE			BIT_32(9)
#define _DWC3_GCTL_SOFITPSYNC				BIT_32(10)
#define _DWC3_GCTL_CORESOFTRESET			BIT_32(11)
#define _DWC3_GCTL_PRTCAPDIR_MASK			GENMASK_32(13, 12)
#define _DWC3_GCTL_PRTCAPDIR_SHIFT			12
#define _DWC3_GCTL_FRMSCLDWN_MASK			GENMASK_32(15, 14)
#define _DWC3_GCTL_FRMSCLDWN_SHIFT			14
#define _DWC3_GCTL_U2RSTECN				BIT_32(16)
#define _DWC3_GCTL_BYPSSETADDR				BIT_32(17)
#define _DWC3_GCTL_MASTERFILTBYPASS			BIT_32(18)
#define _DWC3_GCTL_PWRDNSCALE_MASK			GENMASK_32(31, 19)
#define _DWC3_GCTL_PWRDNSCALE_SHIFT			19

/* _DWC3_GPMSTS register fields */
#define _DWC3_GPMSTS_U2WAKEUP_MASK			GENMASK_32(9, 0)
#define _DWC3_GPMSTS_U2WAKEUP_SHIFT			0
#define _DWC3_GPMSTS_U3WAKEUP_MASK			GENMASK_32(16, 12)
#define _DWC3_GPMSTS_U3WAKEUP_SHIFT			12
#define _DWC3_GPMSTS_PORTSEL_MASK			GENMASK_32(31, 28)
#define _DWC3_GPMSTS_PORTSEL_SHIFT			28

/* _DWC3_GSTS register fields */
#define _DWC3_GSTS_CURMOD_MASK				GENMASK_32(1, 0)
#define _DWC3_GSTS_CURMOD_SHIFT				0
#define _DWC3_GSTS_BUSERRADDRVLD			BIT_32(4)
#define _DWC3_GSTS_CSRTIMEOUT				BIT_32(5)
#define _DWC3_GSTS_DEVICE_IP				BIT_32(6)
#define _DWC3_GSTS_HOST_IP				BIT_32(7)
#define _DWC3_GSTS_ADP_IP				BIT_32(8)
#define _DWC3_GSTS_BC_IP				BIT_32(9)
#define _DWC3_GSTS_OTG_IP				BIT_32(10)
#define _DWC3_GSTS_SSIC_IP				BIT_32(11)
#define _DWC3_GSTS_CBELT_MASK				GENMASK_32(31, 20)
#define _DWC3_GSTS_CBELT_SHIFT				20

/* _DWC3_GUCTL1 register fields */
#define _DWC3_GUCTL1_LOA_FILTER_EN			BIT_32(0)
#define _DWC3_GUCTL1_OVRLD_L1_SUSP_COM			BIT_32(1)
#define _DWC3_GUCTL1_HC_PARCHK_DISABLE			BIT_32(2)
#define _DWC3_GUCTL1_HC_ERRATA_ENABLE			BIT_32(3)
#define _DWC3_GUCTL1_L1_SUSP_THRLD_FOR_HOST_MASK	GENMASK_32(7, 4)
#define _DWC3_GUCTL1_L1_SUSP_THRLD_FOR_HOST_SHIFT	4
#define _DWC3_GUCTL1_L1_SUSP_THRLD_EN_FOR_HOST		BIT_32(8)
#define _DWC3_GUCTL1_DEV_HS_NYET_BULK_SPR		BIT_32(9)
#define _DWC3_GUCTL1_RESUME_OPMODE_HS_HOST		BIT_32(10)
#define _DWC3_GUCTL1_PARKMODE_DISABLE_FSLS		BIT_32(15)
#define _DWC3_GUCTL1_PARKMODE_DISABLE_HS		BIT_32(16)
#define _DWC3_GUCTL1_PARKMODE_DISABLE_SS		BIT_32(17)
#define _DWC3_GUCTL1_NAK_PER_ENH_HS			BIT_32(18)
#define _DWC3_GUCTL1_NAK_PER_ENH_FS			BIT_32(19)
#define _DWC3_GUCTL1_DEV_LSP_TAIL_LOCK_DIS		BIT_32(20)
#define _DWC3_GUCTL1_IP_GAP_ADD_ON_MASK			GENMASK_32(23, 21)
#define _DWC3_GUCTL1_IP_GAP_ADD_ON_SHIFT		21
#define _DWC3_GUCTL1_DEV_L1_EXIT_BY_HW			BIT_32(24)
#define _DWC3_GUCTL1_P3_IN_U2				BIT_32(25)
#define _DWC3_GUCTL1_DEV_FORCE_20_CLK_FOR_30_CLK	BIT_32(26)
#define _DWC3_GUCTL1_DEV_TRB_OUT_SPR_IND		BIT_32(27)
#define _DWC3_GUCTL1_TX_IPGAP_LINECHECK_DIS		BIT_32(28)
#define _DWC3_GUCTL1_FILTER_SE0_FSLS_EOP		BIT_32(29)
#define _DWC3_GUCTL1_DS_RXDET_MAX_TOUT_CTRL		BIT_32(30)
#define _DWC3_GUCTL1_DEV_DECOUPLE_L1L2_EVT		BIT_32(31)

/* _DWC3_GGPIO register fields */
#define _DWC3_GGPIO_GPI_MASK				GENMASK_32(15, 0)
#define _DWC3_GGPIO_GPI_SHIFT				0
#define _DWC3_GGPIO_GPO_MASK				GENMASK_32(31, 16)
#define _DWC3_GGPIO_GPO_SHIFT				16

/* _DWC3_GUCTL register fields */
#define _DWC3_GUCTL_DTFT_MASK				GENMASK_32(8, 0)
#define _DWC3_GUCTL_DTFT_SHIFT				0
#define _DWC3_GUCTL_DTCT_MASK				GENMASK_32(10, 9)
#define _DWC3_GUCTL_DTCT_SHIFT				9
#define _DWC3_GUCTL_INSRTEXTRFSBODI			BIT_32(11)
#define _DWC3_GUCTL_EXTCAPSUPPTEN			BIT_32(12)
#define _DWC3_GUCTL_ENOVERLAPCHK			BIT_32(13)
#define _DWC3_GUCTL_USBHSTINAUTORETRYEN			BIT_32(14)
#define _DWC3_GUCTL_RESBWHSEPS				BIT_32(16)
#define _DWC3_GUCTL_SPRSCTRLTRANSEN			BIT_32(17)
#define _DWC3_GUCTL_NOEXTRDL				BIT_32(21)
#define _DWC3_GUCTL_REFCLKPER_MASK			GENMASK_32(31, 22)
#define _DWC3_GUCTL_REFCLKPER_SHIFT			22

/* _DWC3_GPRTBIMAPLO register fields */
#define _DWC3_GPRTBIMAPLO_BINUM1_MASK			GENMASK_32(3, 0)
#define _DWC3_GPRTBIMAPLO_BINUM1_SHIFT			0
#define _DWC3_GPRTBIMAPLO_BINUM2_MASK			GENMASK_32(7, 4)
#define _DWC3_GPRTBIMAPLO_BINUM2_SHIFT			4
#define _DWC3_GPRTBIMAPLO_BINUM3_MASK			GENMASK_32(11, 8)
#define _DWC3_GPRTBIMAPLO_BINUM3_SHIFT			8
#define _DWC3_GPRTBIMAPLO_BINUM4_MASK			GENMASK_32(15, 12)
#define _DWC3_GPRTBIMAPLO_BINUM4_SHIFT			12
#define _DWC3_GPRTBIMAPLO_BINUM5_MASK			GENMASK_32(19, 16)
#define _DWC3_GPRTBIMAPLO_BINUM5_SHIFT			16
#define _DWC3_GPRTBIMAPLO_BINUM6_MASK			GENMASK_32(23, 20)
#define _DWC3_GPRTBIMAPLO_BINUM6_SHIFT			20
#define _DWC3_GPRTBIMAPLO_BINUM7_MASK			GENMASK_32(27, 24)
#define _DWC3_GPRTBIMAPLO_BINUM7_SHIFT			24
#define _DWC3_GPRTBIMAPLO_BINUM8_MASK			GENMASK_32(31, 28)
#define _DWC3_GPRTBIMAPLO_BINUM8_SHIFT			28

/* _DWC3_GPRTBIMAPHI register fields */
#define _DWC3_GPRTBIMAPHI_BINUM9_MASK			GENMASK_32(3, 0)
#define _DWC3_GPRTBIMAPHI_BINUM9_SHIFT			0
#define _DWC3_GPRTBIMAPHI_BINUM10_MASK			GENMASK_32(7, 4)
#define _DWC3_GPRTBIMAPHI_BINUM10_SHIFT			4
#define _DWC3_GPRTBIMAPHI_BINUM11_MASK			GENMASK_32(11, 8)
#define _DWC3_GPRTBIMAPHI_BINUM11_SHIFT			8
#define _DWC3_GPRTBIMAPHI_BINUM12_MASK			GENMASK_32(15, 12)
#define _DWC3_GPRTBIMAPHI_BINUM12_SHIFT			12
#define _DWC3_GPRTBIMAPHI_BINUM13_MASK			GENMASK_32(19, 16)
#define _DWC3_GPRTBIMAPHI_BINUM13_SHIFT			16
#define _DWC3_GPRTBIMAPHI_BINUM14_MASK			GENMASK_32(23, 20)
#define _DWC3_GPRTBIMAPHI_BINUM14_SHIFT			20
#define _DWC3_GPRTBIMAPHI_BINUM15_MASK			GENMASK_32(27, 24)
#define _DWC3_GPRTBIMAPHI_BINUM15_SHIFT			24

/* _DWC3_GHWPARAMS0 register fields */
#define _DWC3_GHWPARAMS0_GHWPARAMS0_2_0_MASK		GENMASK_32(2, 0)
#define _DWC3_GHWPARAMS0_GHWPARAMS0_2_0_SHIFT		0
#define _DWC3_GHWPARAMS0_GHWPARAMS0_5_3_MASK		GENMASK_32(5, 3)
#define _DWC3_GHWPARAMS0_GHWPARAMS0_5_3_SHIFT		3
#define _DWC3_GHWPARAMS0_GHWPARAMS0_7_6_MASK		GENMASK_32(7, 6)
#define _DWC3_GHWPARAMS0_GHWPARAMS0_7_6_SHIFT		6
#define _DWC3_GHWPARAMS0_GHWPARAMS0_15_8_MASK		GENMASK_32(15, 8)
#define _DWC3_GHWPARAMS0_GHWPARAMS0_15_8_SHIFT		8
#define _DWC3_GHWPARAMS0_GHWPARAMS0_23_16_MASK		GENMASK_32(23, 16)
#define _DWC3_GHWPARAMS0_GHWPARAMS0_23_16_SHIFT		16
#define _DWC3_GHWPARAMS0_GHWPARAMS0_31_24_MASK		GENMASK_32(31, 24)
#define _DWC3_GHWPARAMS0_GHWPARAMS0_31_24_SHIFT		24

/* _DWC3_GHWPARAMS1 register fields */
#define _DWC3_GHWPARAMS1_GHWPARAMS1_2_0_MASK		GENMASK_32(2, 0)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_2_0_SHIFT		0
#define _DWC3_GHWPARAMS1_GHWPARAMS1_5_3_MASK		GENMASK_32(5, 3)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_5_3_SHIFT		3
#define _DWC3_GHWPARAMS1_GHWPARAMS1_8_6_MASK		GENMASK_32(8, 6)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_8_6_SHIFT		6
#define _DWC3_GHWPARAMS1_GHWPARAMS1_11_9_MASK		GENMASK_32(11, 9)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_11_9_SHIFT		9
#define _DWC3_GHWPARAMS1_GHWPARAMS1_14_12_MASK		GENMASK_32(14, 12)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_14_12_SHIFT		12
#define _DWC3_GHWPARAMS1_GHWPARAMS1_20_15_MASK		GENMASK_32(20, 15)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_20_15_SHIFT		15
#define _DWC3_GHWPARAMS1_GHWPARAMS1_22_21_MASK		GENMASK_32(22, 21)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_22_21_SHIFT		21
#define _DWC3_GHWPARAMS1_GHWPARAMS1_23			BIT_32(23)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_25_24_MASK		GENMASK_32(25, 24)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_25_24_SHIFT		24
#define _DWC3_GHWPARAMS1_GHWPARAMS1_26			BIT_32(26)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_27			BIT_32(27)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_28			BIT_32(28)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_29			BIT_32(29)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_30			BIT_32(30)
#define _DWC3_GHWPARAMS1_GHWPARAMS1_31			BIT_32(31)

/* _DWC3_GHWPARAMS3 register fields */
#define _DWC3_GHWPARAMS3_GHWPARAMS3_1_0_MASK		GENMASK_32(1, 0)
#define _DWC3_GHWPARAMS3_GHWPARAMS3_1_0_SHIFT		0
#define _DWC3_GHWPARAMS3_GHWPARAMS3_3_2_MASK		GENMASK_32(3, 2)
#define _DWC3_GHWPARAMS3_GHWPARAMS3_3_2_SHIFT		2
#define _DWC3_GHWPARAMS3_GHWPARAMS3_5_4_MASK		GENMASK_32(5, 4)
#define _DWC3_GHWPARAMS3_GHWPARAMS3_5_4_SHIFT		4
#define _DWC3_GHWPARAMS3_GHWPARAMS3_7_6_MASK		GENMASK_32(7, 6)
#define _DWC3_GHWPARAMS3_GHWPARAMS3_7_6_SHIFT		6
#define _DWC3_GHWPARAMS3_GHWPARAMS3_9_8_MASK		GENMASK_32(9, 8)
#define _DWC3_GHWPARAMS3_GHWPARAMS3_9_8_SHIFT		8
#define _DWC3_GHWPARAMS3_GHWPARAMS3_10			BIT_32(10)
#define _DWC3_GHWPARAMS3_GHWPARAMS3_11			BIT_32(11)
#define _DWC3_GHWPARAMS3_GHWPARAMS3_17_12_MASK		GENMASK_32(17, 12)
#define _DWC3_GHWPARAMS3_GHWPARAMS3_17_12_SHIFT		12
#define _DWC3_GHWPARAMS3_GHWPARAMS3_22_18_MASK		GENMASK_32(22, 18)
#define _DWC3_GHWPARAMS3_GHWPARAMS3_22_18_SHIFT		18
#define _DWC3_GHWPARAMS3_GHWPARAMS3_30_23_MASK		GENMASK_32(30, 23)
#define _DWC3_GHWPARAMS3_GHWPARAMS3_30_23_SHIFT		23
#define _DWC3_GHWPARAMS3_GHWPARAMS3_31			BIT_32(31)

/* _DWC3_GHWPARAMS4 register fields */
#define _DWC3_GHWPARAMS4_GHWPARAMS4_5_0_MASK		GENMASK_32(5, 0)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_5_0_SHIFT		0
#define _DWC3_GHWPARAMS4_GHWPARAMS4_6			BIT_32(6)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_8_7_MASK		GENMASK_32(8, 7)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_8_7_SHIFT		7
#define _DWC3_GHWPARAMS4_GHWPARAMS4_10_9_MASK		GENMASK_32(10, 9)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_10_9_SHIFT		9
#define _DWC3_GHWPARAMS4_GHWPARAMS4_11			BIT_32(11)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_12			BIT_32(12)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_16_13_MASK		GENMASK_32(16, 13)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_16_13_SHIFT		13
#define _DWC3_GHWPARAMS4_GHWPARAMS4_20_17_MASK		GENMASK_32(20, 17)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_20_17_SHIFT		17
#define _DWC3_GHWPARAMS4_GHWPARAMS4_21			BIT_32(21)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_22			BIT_32(22)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_23			BIT_32(23)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_27_24_MASK		GENMASK_32(27, 24)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_27_24_SHIFT		24
#define _DWC3_GHWPARAMS4_GHWPARAMS4_31_28_MASK		GENMASK_32(31, 28)
#define _DWC3_GHWPARAMS4_GHWPARAMS4_31_28_SHIFT		28

/* _DWC3_GHWPARAMS5 register fields */
#define _DWC3_GHWPARAMS5_GHWPARAMS5_3_0_MASK		GENMASK_32(3, 0)
#define _DWC3_GHWPARAMS5_GHWPARAMS5_3_0_SHIFT		0
#define _DWC3_GHWPARAMS5_GHWPARAMS5_9_4_MASK		GENMASK_32(9, 4)
#define _DWC3_GHWPARAMS5_GHWPARAMS5_9_4_SHIFT		4
#define _DWC3_GHWPARAMS5_GHWPARAMS5_15_10_MASK		GENMASK_32(15, 10)
#define _DWC3_GHWPARAMS5_GHWPARAMS5_15_10_SHIFT		10
#define _DWC3_GHWPARAMS5_GHWPARAMS5_21_16_MASK		GENMASK_32(21, 16)
#define _DWC3_GHWPARAMS5_GHWPARAMS5_21_16_SHIFT		16
#define _DWC3_GHWPARAMS5_GHWPARAMS5_27_22_MASK		GENMASK_32(27, 22)
#define _DWC3_GHWPARAMS5_GHWPARAMS5_27_22_SHIFT		22
#define _DWC3_GHWPARAMS5_GHWPARAMS5_31_28_MASK		GENMASK_32(31, 28)
#define _DWC3_GHWPARAMS5_GHWPARAMS5_31_28_SHIFT		28

/* _DWC3_GHWPARAMS6 register fields */
#define _DWC3_GHWPARAMS6_GHWPARAMS6_5_0_MASK		GENMASK_32(5, 0)
#define _DWC3_GHWPARAMS6_GHWPARAMS6_5_0_SHIFT		0
#define _DWC3_GHWPARAMS6_GHWPARAMS6_6			BIT_32(6)
#define _DWC3_GHWPARAMS6_GHWPARAMS6_7			BIT_32(7)
#define _DWC3_GHWPARAMS6_GHWPARAMS6_9_8_MASK		GENMASK_32(9, 8)
#define _DWC3_GHWPARAMS6_GHWPARAMS6_9_8_SHIFT		8
#define _DWC3_GHWPARAMS6_SRPSUPPORT			BIT_32(10)
#define _DWC3_GHWPARAMS6_HNPSUPPORT			BIT_32(11)
#define _DWC3_GHWPARAMS6_ADPSUPPORT			BIT_32(12)
#define _DWC3_GHWPARAMS6_OTG_SS_SUPPORT			BIT_32(13)
#define _DWC3_GHWPARAMS6_BCSUPPORT			BIT_32(14)
#define _DWC3_GHWPARAMS6_BUSFLTRSSUPPORT		BIT_32(15)
#define _DWC3_GHWPARAMS6_GHWPARAMS6_31_16_MASK		GENMASK_32(31, 16)
#define _DWC3_GHWPARAMS6_GHWPARAMS6_31_16_SHIFT		16

/* _DWC3_GHWPARAMS7 register fields */
#define _DWC3_GHWPARAMS7_GHWPARAMS7_15_0_MASK		GENMASK_32(15, 0)
#define _DWC3_GHWPARAMS7_GHWPARAMS7_15_0_SHIFT		0
#define _DWC3_GHWPARAMS7_GHWPARAMS7_31_16_MASK		GENMASK_32(31, 16)
#define _DWC3_GHWPARAMS7_GHWPARAMS7_31_16_SHIFT		16

/* _DWC3_GDBGFIFOSPACE register fields */
#define _DWC3_GDBGFIFOSPACE_FIFO_QUEUE_SELECT_MASK	GENMASK_32(8, 0)
#define _DWC3_GDBGFIFOSPACE_FIFO_QUEUE_SELECT_SHIFT	0
#define _DWC3_GDBGFIFOSPACE_SPACE_AVAILABLE_MASK	GENMASK_32(31, 16)
#define _DWC3_GDBGFIFOSPACE_SPACE_AVAILABLE_SHIFT	16

/* _DWC3_GDBGLTSSM register fields */
#define _DWC3_GDBGLTSSM_TXONESZEROS			BIT_32(0)
#define _DWC3_GDBGLTSSM_RXTERMINATION			BIT_32(1)
#define _DWC3_GDBGLTSSM_TXSWING				BIT_32(2)
#define _DWC3_GDBGLTSSM_LTDBCLKSTATE_MASK		GENMASK_32(5, 3)
#define _DWC3_GDBGLTSSM_LTDBCLKSTATE_SHIFT		3
#define _DWC3_GDBGLTSSM_TXDEEMPHASIS_MASK		GENMASK_32(7, 6)
#define _DWC3_GDBGLTSSM_TXDEEMPHASIS_SHIFT		6
#define _DWC3_GDBGLTSSM_RXEQTRAIN			BIT_32(8)
#define _DWC3_GDBGLTSSM_POWERDOWN_MASK			GENMASK_32(10, 9)
#define _DWC3_GDBGLTSSM_POWERDOWN_SHIFT			9
#define _DWC3_GDBGLTSSM_LTDBPHYCMDSTATE_MASK		GENMASK_32(13, 11)
#define _DWC3_GDBGLTSSM_LTDBPHYCMDSTATE_SHIFT		11
#define _DWC3_GDBGLTSSM_TXDETRXLOOPBACK			BIT_32(14)
#define _DWC3_GDBGLTSSM_RXPOLARITY			BIT_32(15)
#define _DWC3_GDBGLTSSM_TXELECLDLE			BIT_32(16)
#define _DWC3_GDBGLTSSM_ELASTICBUFFERMODE		BIT_32(17)
#define _DWC3_GDBGLTSSM_LTDBSUBSTATE_MASK		GENMASK_32(21, 18)
#define _DWC3_GDBGLTSSM_LTDBSUBSTATE_SHIFT		18
#define _DWC3_GDBGLTSSM_LTDBLINKSTATE_MASK		GENMASK_32(25, 22)
#define _DWC3_GDBGLTSSM_LTDBLINKSTATE_SHIFT		22
#define _DWC3_GDBGLTSSM_LTDBTIMEOUT			BIT_32(26)
#define _DWC3_GDBGLTSSM_PRTDIRECTION			BIT_32(27)
#define _DWC3_GDBGLTSSM_X3_DS_HOST_SHUTDOWN		BIT_32(28)
#define _DWC3_GDBGLTSSM_X3_XS_SWAPPING			BIT_32(29)
#define _DWC3_GDBGLTSSM_RXELECIDLE			BIT_32(30)

/* _DWC3_GDBGLNMCC register fields */
#define _DWC3_GDBGLNMCC_LNMCC_BERC_MASK			GENMASK_32(8, 0)
#define _DWC3_GDBGLNMCC_LNMCC_BERC_SHIFT		0

/* _DWC3_GDBGBMU register fields */
#define _DWC3_GDBGBMU_BMU_CCU_MASK			GENMASK_32(3, 0)
#define _DWC3_GDBGBMU_BMU_CCU_SHIFT			0
#define _DWC3_GDBGBMU_BMU_DCU_MASK			GENMASK_32(7, 4)
#define _DWC3_GDBGBMU_BMU_DCU_SHIFT			4
#define _DWC3_GDBGBMU_BMU_BCU_MASK			GENMASK_32(31, 8)
#define _DWC3_GDBGBMU_BMU_BCU_SHIFT			8

/* _DWC3_GDBGLSPMUX_HST register fields */
#define _DWC3_GDBGLSPMUX_HST_HOSTSELECT_MASK		GENMASK_32(13, 0)
#define _DWC3_GDBGLSPMUX_HST_HOSTSELECT_SHIFT		0
#define _DWC3_GDBGLSPMUX_HST_LOGIC_ANALYZER_TRACE_MASK	GENMASK_32(23, 16)
#define _DWC3_GDBGLSPMUX_HST_LOGIC_ANALYZER_TRACE_SHIFT	16

/* _DWC3_GPRTBIMAP_HSLO register fields */
#define _DWC3_GPRTBIMAP_HSLO_BINUM1_MASK		GENMASK_32(3, 0)
#define _DWC3_GPRTBIMAP_HSLO_BINUM1_SHIFT		0
#define _DWC3_GPRTBIMAP_HSLO_BINUM2_MASK		GENMASK_32(7, 4)
#define _DWC3_GPRTBIMAP_HSLO_BINUM2_SHIFT		4
#define _DWC3_GPRTBIMAP_HSLO_BINUM3_MASK		GENMASK_32(11, 8)
#define _DWC3_GPRTBIMAP_HSLO_BINUM3_SHIFT		8
#define _DWC3_GPRTBIMAP_HSLO_BINUM4_MASK		GENMASK_32(15, 12)
#define _DWC3_GPRTBIMAP_HSLO_BINUM4_SHIFT		12
#define _DWC3_GPRTBIMAP_HSLO_BINUM5_MASK		GENMASK_32(19, 16)
#define _DWC3_GPRTBIMAP_HSLO_BINUM5_SHIFT		16
#define _DWC3_GPRTBIMAP_HSLO_BINUM6_MASK		GENMASK_32(23, 20)
#define _DWC3_GPRTBIMAP_HSLO_BINUM6_SHIFT		20
#define _DWC3_GPRTBIMAP_HSLO_BINUM7_MASK		GENMASK_32(27, 24)
#define _DWC3_GPRTBIMAP_HSLO_BINUM7_SHIFT		24
#define _DWC3_GPRTBIMAP_HSLO_BINUM8_MASK		GENMASK_32(31, 28)
#define _DWC3_GPRTBIMAP_HSLO_BINUM8_SHIFT		28

/* _DWC3_GPRTBIMAP_HSHI register fields */
#define _DWC3_GPRTBIMAP_HSHI_BINUM9_MASK		GENMASK_32(3, 0)
#define _DWC3_GPRTBIMAP_HSHI_BINUM9_SHIFT		0
#define _DWC3_GPRTBIMAP_HSHI_BINUM10_MASK		GENMASK_32(7, 4)
#define _DWC3_GPRTBIMAP_HSHI_BINUM10_SHIFT		4
#define _DWC3_GPRTBIMAP_HSHI_BINUM11_MASK		GENMASK_32(11, 8)
#define _DWC3_GPRTBIMAP_HSHI_BINUM11_SHIFT		8
#define _DWC3_GPRTBIMAP_HSHI_BINUM12_MASK		GENMASK_32(15, 12)
#define _DWC3_GPRTBIMAP_HSHI_BINUM12_SHIFT		12
#define _DWC3_GPRTBIMAP_HSHI_BINUM13_MASK		GENMASK_32(19, 16)
#define _DWC3_GPRTBIMAP_HSHI_BINUM13_SHIFT		16
#define _DWC3_GPRTBIMAP_HSHI_BINUM14_MASK		GENMASK_32(23, 20)
#define _DWC3_GPRTBIMAP_HSHI_BINUM14_SHIFT		20
#define _DWC3_GPRTBIMAP_HSHI_BINUM15_MASK		GENMASK_32(27, 24)
#define _DWC3_GPRTBIMAP_HSHI_BINUM15_SHIFT		24

/* _DWC3_GPRTBIMAP_FSLO register fields */
#define _DWC3_GPRTBIMAP_FSLO_BINUM1_MASK		GENMASK_32(3, 0)
#define _DWC3_GPRTBIMAP_FSLO_BINUM1_SHIFT		0
#define _DWC3_GPRTBIMAP_FSLO_BINUM2_MASK		GENMASK_32(7, 4)
#define _DWC3_GPRTBIMAP_FSLO_BINUM2_SHIFT		4
#define _DWC3_GPRTBIMAP_FSLO_BINUM3_MASK		GENMASK_32(11, 8)
#define _DWC3_GPRTBIMAP_FSLO_BINUM3_SHIFT		8
#define _DWC3_GPRTBIMAP_FSLO_BINUM4_MASK		GENMASK_32(15, 12)
#define _DWC3_GPRTBIMAP_FSLO_BINUM4_SHIFT		12
#define _DWC3_GPRTBIMAP_FSLO_BINUM5_MASK		GENMASK_32(19, 16)
#define _DWC3_GPRTBIMAP_FSLO_BINUM5_SHIFT		16
#define _DWC3_GPRTBIMAP_FSLO_BINUM6_MASK		GENMASK_32(23, 20)
#define _DWC3_GPRTBIMAP_FSLO_BINUM6_SHIFT		20
#define _DWC3_GPRTBIMAP_FSLO_BINUM7_MASK		GENMASK_32(27, 24)
#define _DWC3_GPRTBIMAP_FSLO_BINUM7_SHIFT		24
#define _DWC3_GPRTBIMAP_FSLO_BINUM8_MASK		GENMASK_32(31, 28)
#define _DWC3_GPRTBIMAP_FSLO_BINUM8_SHIFT		28

/* _DWC3_GPRTBIMAP_FSHI register fields */
#define _DWC3_GPRTBIMAP_FSHI_BINUM9_MASK		GENMASK_32(3, 0)
#define _DWC3_GPRTBIMAP_FSHI_BINUM9_SHIFT		0
#define _DWC3_GPRTBIMAP_FSHI_BINUM10_MASK		GENMASK_32(7, 4)
#define _DWC3_GPRTBIMAP_FSHI_BINUM10_SHIFT		4
#define _DWC3_GPRTBIMAP_FSHI_BINUM11_MASK		GENMASK_32(11, 8)
#define _DWC3_GPRTBIMAP_FSHI_BINUM11_SHIFT		8
#define _DWC3_GPRTBIMAP_FSHI_BINUM12_MASK		GENMASK_32(15, 12)
#define _DWC3_GPRTBIMAP_FSHI_BINUM12_SHIFT		12
#define _DWC3_GPRTBIMAP_FSHI_BINUM13_MASK		GENMASK_32(19, 16)
#define _DWC3_GPRTBIMAP_FSHI_BINUM13_SHIFT		16
#define _DWC3_GPRTBIMAP_FSHI_BINUM14_MASK		GENMASK_32(23, 20)
#define _DWC3_GPRTBIMAP_FSHI_BINUM14_SHIFT		20
#define _DWC3_GPRTBIMAP_FSHI_BINUM15_MASK		GENMASK_32(27, 24)
#define _DWC3_GPRTBIMAP_FSHI_BINUM15_SHIFT		24

/* _DWC3_GUCTL2 register fields */
#define _DWC3_GUCTL2_TXPINGDURATION_MASK		GENMASK_32(4, 0)
#define _DWC3_GUCTL2_TXPINGDURATION_SHIFT		0
#define _DWC3_GUCTL2_RXPINGDURATION_MASK		GENMASK_32(10, 5)
#define _DWC3_GUCTL2_RXPINGDURATION_SHIFT		5
#define _DWC3_GUCTL2_DISABLECFC				BIT_32(11)
#define _DWC3_GUCTL2_ENABLEEPCACHEEVICT			BIT_32(12)
#define _DWC3_GUCTL2_RST_ACTBITLATER			BIT_32(14)
#define _DWC3_GUCTL2_NOLOWPWRDUR_MASK			GENMASK_32(18, 15)
#define _DWC3_GUCTL2_NOLOWPWRDUR_SHIFT			15
#define _DWC3_GUCTL2_EN_HP_PM_TIMER_MASK		GENMASK_32(25, 19)
#define _DWC3_GUCTL2_EN_HP_PM_TIMER_SHIFT		19

/* _DWC3_GTXFIFOPRIDEV register fields */
#define _DWC3_GTXFIFOPRIDEV_GTXFIFOPRIDEV_MASK		GENMASK_32(11, 0)
#define _DWC3_GTXFIFOPRIDEV_GTXFIFOPRIDEV_SHIFT		0

/* _DWC3_GTXFIFOPRIHST register fields */
#define _DWC3_GTXFIFOPRIHST_GTXFIFOPRIHST_MASK		GENMASK_32(2, 0)
#define _DWC3_GTXFIFOPRIHST_GTXFIFOPRIHST_SHIFT		0

/* _DWC3_GRXFIFOPRIHST register fields */
#define _DWC3_GRXFIFOPRIHST_GRXFIFOPRIHST_MASK		GENMASK_32(2, 0)
#define _DWC3_GRXFIFOPRIHST_GRXFIFOPRIHST_SHIFT		0

/* _DWC3_GDMAHLRATIO register fields */
#define _DWC3_GDMAHLRATIO_HSTTXFIFO_MASK		GENMASK_32(4, 0)
#define _DWC3_GDMAHLRATIO_HSTTXFIFO_SHIFT		0
#define _DWC3_GDMAHLRATIO_HSTRXFIFO_MASK		GENMASK_32(12, 8)
#define _DWC3_GDMAHLRATIO_HSTRXFIFO_SHIFT		8

/* _DWC3_GFLADJ register fields */
#define _DWC3_GFLADJ_GFLADJ_30MHZ_MASK			GENMASK_32(5, 0)
#define _DWC3_GFLADJ_GFLADJ_30MHZ_SHIFT			0
#define _DWC3_GFLADJ_GFLADJ_30MHZ_SDBND_SEL		BIT_32(7)
#define _DWC3_GFLADJ_GFLADJ_REFCLK_FLADJ_MASK		GENMASK_32(21, 8)
#define _DWC3_GFLADJ_GFLADJ_REFCLK_FLADJ_SHIFT		8
#define _DWC3_GFLADJ_GFLADJ_REFCLK_LPM_SEL		BIT_32(23)
#define _DWC3_GFLADJ_GFLADJ_REFCLK_240MHZ_DECR_MASK	GENMASK_32(30, 24)
#define _DWC3_GFLADJ_GFLADJ_REFCLK_240MHZ_DECR_SHIFT	24
#define _DWC3_GFLADJ_GFLADJ_REFCLK_240MHZDECR_PLS1	BIT_32(31)

/* _DWC3_GUSB2PHYCFG register fields */
#define _DWC3_GUSB2PHYCFG_TOUTCAL_MASK			GENMASK_32(2, 0)
#define _DWC3_GUSB2PHYCFG_TOUTCAL_SHIFT			0
#define _DWC3_GUSB2PHYCFG_PHYIF				BIT_32(3)
#define _DWC3_GUSB2PHYCFG_ULPI_UTMI_SEL			BIT_32(4)
#define _DWC3_GUSB2PHYCFG_FSINTF			BIT_32(5)
#define _DWC3_GUSB2PHYCFG_SUSPENDUSB20			BIT_32(6)
#define _DWC3_GUSB2PHYCFG_PHYSEL			BIT_32(7)
#define _DWC3_GUSB2PHYCFG_ENBLSLPM			BIT_32(8)
#define _DWC3_GUSB2PHYCFG_XCVRDLY			BIT_32(9)
#define _DWC3_GUSB2PHYCFG_USBTRDTIM_MASK		GENMASK_32(13, 10)
#define _DWC3_GUSB2PHYCFG_USBTRDTIM_SHIFT		10
#define _DWC3_GUSB2PHYCFG_ULPIAUTORES			BIT_32(15)
#define _DWC3_GUSB2PHYCFG_ULPIEXTVBUSDRV		BIT_32(17)
#define _DWC3_GUSB2PHYCFG_ULPIEXTVBUSINDIACTOR		BIT_32(18)
#define _DWC3_GUSB2PHYCFG_LSIPD_MASK			GENMASK_32(21, 19)
#define _DWC3_GUSB2PHYCFG_LSIPD_SHIFT			19
#define _DWC3_GUSB2PHYCFG_LSTRD_MASK			GENMASK_32(24, 22)
#define _DWC3_GUSB2PHYCFG_LSTRD_SHIFT			22
#define _DWC3_GUSB2PHYCFG_INV_SEL_HSIC			BIT_32(26)
#define _DWC3_GUSB2PHYCFG_HSIC_CON_WIDTH_ADJ_MASK	GENMASK_32(28, 27)
#define _DWC3_GUSB2PHYCFG_HSIC_CON_WIDTH_ADJ_SHIFT	27
#define _DWC3_GUSB2PHYCFG_ULPI_LPM_WITH_OPMODE_CHK	BIT_32(29)
#define _DWC3_GUSB2PHYCFG_U2_FREECLK_EXISTS		BIT_32(30)
#define _DWC3_GUSB2PHYCFG_PHYSOFTRST			BIT_32(31)

/* _DWC3_GUSB2PHYACC_ULPI register fields */
#define _DWC3_GUSB2PHYACC_ULPI_REGDATA_MASK		GENMASK_32(7, 0)
#define _DWC3_GUSB2PHYACC_ULPI_REGDATA_SHIFT		0
#define _DWC3_GUSB2PHYACC_ULPI_EXTREGADDR_MASK		GENMASK_32(15, 8)
#define _DWC3_GUSB2PHYACC_ULPI_EXTREGADDR_SHIFT		8
#define _DWC3_GUSB2PHYACC_ULPI_REGADDR_MASK		GENMASK_32(21, 16)
#define _DWC3_GUSB2PHYACC_ULPI_REGADDR_SHIFT		16
#define _DWC3_GUSB2PHYACC_ULPI_REGWR			BIT_32(22)
#define _DWC3_GUSB2PHYACC_ULPI_VSTSBSY			BIT_32(23)
#define _DWC3_GUSB2PHYACC_ULPI_VSTSDONE			BIT_32(24)
#define _DWC3_GUSB2PHYACC_ULPI_NEWREGREQ		BIT_32(25)
#define _DWC3_GUSB2PHYACC_ULPI_DISUIPIDRVR		BIT_32(26)

/* _DWC3_GUSB3PIPECTL register fields */
#define _DWC3_GUSB3PIPECTL_ELASTIC_BUFFER_MODE		BIT_32(0)
#define _DWC3_GUSB3PIPECTL_SS_TX_DE_EMPHASIS_MASK	GENMASK_32(2, 1)
#define _DWC3_GUSB3PIPECTL_SS_TX_DE_EMPHASIS_SHIFT	1
#define _DWC3_GUSB3PIPECTL_TX_MARGIN_MASK		GENMASK_32(5, 3)
#define _DWC3_GUSB3PIPECTL_TX_MARGIN_SHIFT		3
#define _DWC3_GUSB3PIPECTL_TX_SWING			BIT_32(6)
#define _DWC3_GUSB3PIPECTL_SSICEN			BIT_32(7)
#define _DWC3_GUSB3PIPECTL_RX_DETECT_TO_POLLING_LFPS_CONTROL	BIT_32(8)
#define _DWC3_GUSB3PIPECTL_LFPSFILTER			BIT_32(9)
#define _DWC3_GUSB3PIPECTL_P3EXSIGP2			BIT_32(10)
#define _DWC3_GUSB3PIPECTL_P3P2TRANOK			BIT_32(11)
#define _DWC3_GUSB3PIPECTL_LFPSP0ALGN			BIT_32(12)
#define _DWC3_GUSB3PIPECTL_SKIPRXDET			BIT_32(13)
#define _DWC3_GUSB3PIPECTL_ABORTRXDETINU2		BIT_32(14)
#define _DWC3_GUSB3PIPECTL_DATWIDTH_MASK		GENMASK_32(16, 15)
#define _DWC3_GUSB3PIPECTL_DATWIDTH_SHIFT		15
#define _DWC3_GUSB3PIPECTL_SUSPENDENABLE		BIT_32(17)
#define _DWC3_GUSB3PIPECTL_DELAYP1TRANS			BIT_32(18)
#define _DWC3_GUSB3PIPECTL_DELAYP1P2P3_MASK		GENMASK_32(21, 19)
#define _DWC3_GUSB3PIPECTL_DELAYP1P2P3_SHIFT		19
#define _DWC3_GUSB3PIPECTL_DISRXDETU3RXDET		BIT_32(22)
#define _DWC3_GUSB3PIPECTL_STARTRXDETU3RXDET		BIT_32(23)
#define _DWC3_GUSB3PIPECTL_REQUEST_P1P2P3		BIT_32(24)
#define _DWC3_GUSB3PIPECTL_U1U2EXITFAIL_TO_RECOV	BIT_32(25)
#define _DWC3_GUSB3PIPECTL_PING_ENHANCEMENT_EN		BIT_32(26)
#define _DWC3_GUSB3PIPECTL_UX_EXIT_IN_PX		BIT_32(27)
#define _DWC3_GUSB3PIPECTL_DISRXDETP3			BIT_32(28)
#define _DWC3_GUSB3PIPECTL_U2P3OK			BIT_32(29)
#define _DWC3_GUSB3PIPECTL_HSTPRTCMPL			BIT_32(30)
#define _DWC3_GUSB3PIPECTL_PHYSOFTRST			BIT_32(31)

/* _DWC3_GTXFIFOSIZ0 register fields */
#define _DWC3_GTXFIFOSIZ0_TXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ0_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ0_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ0_TXFSTADDR_N_SHIFT		16

/* _DWC3_GTXFIFOSIZ1 register fields */
#define _DWC3_GTXFIFOSIZ1_TXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ1_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ1_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ1_TXFSTADDR_N_SHIFT		16

/* _DWC3_GTXFIFOSIZ2 register fields */
#define _DWC3_GTXFIFOSIZ2_TXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ2_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ2_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ2_TXFSTADDR_N_SHIFT		16

/* _DWC3_GTXFIFOSIZ3 register fields */
#define _DWC3_GTXFIFOSIZ3_TXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ3_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ3_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ3_TXFSTADDR_N_SHIFT		16

/* _DWC3_GTXFIFOSIZ4 register fields */
#define _DWC3_GTXFIFOSIZ4_TXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ4_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ4_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ4_TXFSTADDR_N_SHIFT		16

/* _DWC3_GTXFIFOSIZ5 register fields */
#define _DWC3_GTXFIFOSIZ5_TXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ5_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ5_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ5_TXFSTADDR_N_SHIFT		16

/* _DWC3_GTXFIFOSIZ6 register fields */
#define _DWC3_GTXFIFOSIZ6_TXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ6_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ6_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ6_TXFSTADDR_N_SHIFT		16

/* _DWC3_GTXFIFOSIZ7 register fields */
#define _DWC3_GTXFIFOSIZ7_TXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ7_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ7_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ7_TXFSTADDR_N_SHIFT		16

/* _DWC3_GTXFIFOSIZ8 register fields */
#define _DWC3_GTXFIFOSIZ8_TXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ8_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ8_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ8_TXFSTADDR_N_SHIFT		16

/* _DWC3_GTXFIFOSIZ9 register fields */
#define _DWC3_GTXFIFOSIZ9_TXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ9_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ9_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ9_TXFSTADDR_N_SHIFT		16

/* _DWC3_GTXFIFOSIZ10 register fields */
#define _DWC3_GTXFIFOSIZ10_TXFDEP_N_MASK		GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ10_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ10_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ10_TXFSTADDR_N_SHIFT		16

/* _DWC3_GTXFIFOSIZ11 register fields */
#define _DWC3_GTXFIFOSIZ11_TXFDEP_N_MASK		GENMASK_32(15, 0)
#define _DWC3_GTXFIFOSIZ11_TXFDEP_N_SHIFT		0
#define _DWC3_GTXFIFOSIZ11_TXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GTXFIFOSIZ11_TXFSTADDR_N_SHIFT		16

/* _DWC3_GRXFIFOSIZ0 register fields */
#define _DWC3_GRXFIFOSIZ0_RXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GRXFIFOSIZ0_RXFDEP_N_SHIFT		0
#define _DWC3_GRXFIFOSIZ0_RXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GRXFIFOSIZ0_RXFSTADDR_N_SHIFT		16

/* _DWC3_GRXFIFOSIZ1 register fields */
#define _DWC3_GRXFIFOSIZ1_RXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GRXFIFOSIZ1_RXFDEP_N_SHIFT		0
#define _DWC3_GRXFIFOSIZ1_RXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GRXFIFOSIZ1_RXFSTADDR_N_SHIFT		16

/* _DWC3_GRXFIFOSIZ2 register fields */
#define _DWC3_GRXFIFOSIZ2_RXFDEP_N_MASK			GENMASK_32(15, 0)
#define _DWC3_GRXFIFOSIZ2_RXFDEP_N_SHIFT		0
#define _DWC3_GRXFIFOSIZ2_RXFSTADDR_N_MASK		GENMASK_32(31, 16)
#define _DWC3_GRXFIFOSIZ2_RXFSTADDR_N_SHIFT		16

/* _DWC3_GEVNTSIZ register fields */
#define _DWC3_GEVNTSIZ_EVENTSIZ_MASK			GENMASK_32(15, 0)
#define _DWC3_GEVNTSIZ_EVENTSIZ_SHIFT			0
#define _DWC3_GEVNTSIZ_EVNTINTRPTMASK			BIT_32(31)

/* _DWC3_GEVNTCOUNT register fields */
#define _DWC3_GEVNTCOUNT_EVNTCOUNT_MASK			GENMASK_32(15, 0)
#define _DWC3_GEVNTCOUNT_EVNTCOUNT_SHIFT		0
#define _DWC3_GEVNTCOUNT_EVNT_HANDLER_BUSY		BIT_32(31)

/*
 * USB3 Device Register Block
 */
#define _DWC3_DCFG					U(0x0)
#define _DWC3_DCTL					U(0x4)
#define _DWC3_DEVTEN					U(0x8)
#define _DWC3_DSTS					U(0xC)
#define _DWC3_DGCMDPAR					U(0x10)
#define _DWC3_DGCMD					U(0x14)
#define _DWC3_DALEPENA					U(0x20)
#define _DWC3_DEPCMDPAR2				U(0x100)
#define _DWC3_DEPCMDPAR1				U(0x104)
#define _DWC3_DEPCMDPAR0				U(0x108)
#define _DWC3_DEPCMD					U(0x10c)
#define _DWC3_DEV_IMOD					U(0x300)

/* _DWC3_DCFG register fields */
#define _DWC3_DCFG_DEVSPD_MASK				GENMASK_32(2, 0)
#define _DWC3_DCFG_DEVSPD_SHIFT				0
#define _DWC3_DCFG_DEVADDR_MASK				GENMASK_32(9, 3)
#define _DWC3_DCFG_DEVADDR_SHIFT			3
#define _DWC3_DCFG_INTRNUM_MASK				GENMASK_32(16, 12)
#define _DWC3_DCFG_INTRNUM_SHIFT			12
#define _DWC3_DCFG_NUMP_MASK				GENMASK_32(21, 17)
#define _DWC3_DCFG_NUMP_SHIFT				17
#define _DWC3_DCFG_LPMCAP				BIT_32(22)
#define _DWC3_DCFG_IGNSTRMPP				BIT_32(23)

/* _DWC3_DCTL register fields */
#define _DWC3_DCTL_TSTCTL_MASK				GENMASK_32(4, 1)
#define _DWC3_DCTL_TSTCTL_SHIFT				1
#define _DWC3_DCTL_ULSTCHNGREQ_MASK			GENMASK_32(8, 5)
#define _DWC3_DCTL_ULSTCHNGREQ_SHIFT			5
#define _DWC3_DCTL_ACCEPTU1ENA				BIT_32(9)
#define _DWC3_DCTL_INITU1ENA				BIT_32(10)
#define _DWC3_DCTL_ACCEPTU2ENA				BIT_32(11)
#define _DWC3_DCTL_INITU2ENA				BIT_32(12)
#define _DWC3_DCTL_CSS					BIT_32(16)
#define _DWC3_DCTL_CRS					BIT_32(17)
#define _DWC3_DCTL_L1HIBERNATIONEN			BIT_32(18)
#define _DWC3_DCTL_KEEPCONNECT				BIT_32(19)
#define _DWC3_DCTL_LPM_NYET_THRES_MASK			GENMASK_32(23, 20)
#define _DWC3_DCTL_LPM_NYET_THRES_SHIFT			20
#define _DWC3_DCTL_HIRDTHRES_MASK			GENMASK_32(28, 24)
#define _DWC3_DCTL_HIRDTHRES_SHIFT			24
#define _DWC3_DCTL_CSFTRST				BIT_32(30)
#define _DWC3_DCTL_RUN_STOP				BIT_32(31)

/* _DWC3_DEVTEN register fields */
#define _DWC3_DEVTEN_DISSCONNEVTEN			BIT_32(0)
#define _DWC3_DEVTEN_USBRSTEVTEN			BIT_32(1)
#define _DWC3_DEVTEN_CONNECTDONEEVTEN			BIT_32(2)
#define _DWC3_DEVTEN_ULSTCNGEN				BIT_32(3)
#define _DWC3_DEVTEN_WKUPEVTEN				BIT_32(4)
#define _DWC3_DEVTEN_HIBERNATIONREQEVTEN		BIT_32(5)
#define _DWC3_DEVTEN_U3L2L1SUSPEN			BIT_32(6)
#define _DWC3_DEVTEN_SOFTEVTEN				BIT_32(7)
#define _DWC3_DEVTEN_L1SUSPEN				BIT_32(8)
#define _DWC3_DEVTEN_ERRTICERREVTEN			BIT_32(9)
#define _DWC3_DEVTEN_CMDCMPLTEN				BIT_32(10)
#define _DWC3_DEVTEN_EVNTOVERFLOWEN			BIT_32(11)
#define _DWC3_DEVTEN_VENDEVTSTRCVDEN			BIT_32(12)
#define _DWC3_DEVTEN_L1WKUPEVTEN			BIT_32(14)
#define _DWC3_DEVTEN_ECCERREN				BIT_32(16)

/* _DWC3_DSTS register fields */
#define _DWC3_DSTS_CONNECTSPD_MASK			GENMASK_32(2, 0)
#define _DWC3_DSTS_CONNECTSPD_SHIFT			0
#define _DWC3_DSTS_SOFFN_MASK				GENMASK_32(16, 3)
#define _DWC3_DSTS_SOFFN_SHIFT				3
#define _DWC3_DSTS_RXFIFOEMPTY				BIT_32(17)
#define _DWC3_DSTS_USBLNKST_MASK			GENMASK_32(21, 18)
#define _DWC3_DSTS_USBLNKST_SHIFT			18
#define _DWC3_DSTS_DEVCTRLHLT				BIT_32(22)
#define _DWC3_DSTS_COREIDLE				BIT_32(23)
#define _DWC3_DSTS_SSS					BIT_32(24)
#define _DWC3_DSTS_RSS					BIT_32(25)
#define _DWC3_DSTS_SRE					BIT_32(28)
#define _DWC3_DSTS_DCNRD				BIT_32(29)

/* _DWC3_DGCMD register fields */
#define _DWC3_DGCMD_CMDTYP_MASK				GENMASK_32(7, 0)
#define _DWC3_DGCMD_CMDTYP_SHIFT			0
#define _DWC3_DGCMD_CMDIOC				BIT_32(8)
#define _DWC3_DGCMD_CMDACT				BIT_32(10)
#define _DWC3_DGCMD_CMDSTATUS_MASK			GENMASK_32(15, 12)
#define _DWC3_DGCMD_CMDSTATUS_SHIFT			12

/* _DWC3_DEPCMD register fields */
#define _DWC3_DEPCMD_CMDTYP_MASK			GENMASK_32(3, 0)
#define _DWC3_DEPCMD_CMDTYP_SHIFT			0
#define _DWC3_DEPCMD_CMDIOC				BIT_32(8)
#define _DWC3_DEPCMD_CMDACT				BIT_32(10)
#define _DWC3_DEPCMD_HIPRI_FORCERM			BIT_32(11)
#define _DWC3_DEPCMD_CMDSTATUS_MASK			GENMASK_32(15, 12)
#define _DWC3_DEPCMD_CMDSTATUS_SHIFT			12
#define _DWC3_DEPCMD_COMMANDPARAM_MASK			GENMASK_32(31, 16)
#define _DWC3_DEPCMD_COMMANDPARAM_SHIFT			16

/* _DWC3_DEV_IMOD register fields */
#define _DWC3_DEV_IMOD_DEVICE_IMODI_MASK		GENMASK_32(15, 0)
#define _DWC3_DEV_IMOD_DEVICE_IMODI_SHIFT		0
#define _DWC3_DEV_IMOD_DEVICE_IMODC_MASK		GENMASK_32(31, 16)
#define _DWC3_DEV_IMOD_DEVICE_IMODC_SHIFT		16

/*
 * USB3 BC Register Block
 */
#define _DWC3_BCFG					U(0x0)
#define _DWC3_BCEVT					U(0x8)
#define _DWC3_BCEVTEN					U(0xC)

/* _DWC3_BCFG register fields */
#define _DWC3_BCFG_CHIRP_EN				BIT_32(0)
#define _DWC3_BCFG_IDDIG_SEL				BIT_32(1)

/* _DWC3_BCEVT register fields */
#define _DWC3_BCEVT_MULTVALIDBC_MASK			GENMASK_32(4, 0)
#define _DWC3_BCEVT_MULTVALIDBC_SHIFT			0
#define _DWC3_BCEVT_MV_CHNGEVNT				BIT_32(24)

/* _DWC3_BCEVTEN register fields */
#define _DWC3_BCEVTEN_MV_CHNGEVNTENA			BIT_32(24)

/*
 * USB3 eXtensible Host Controller Capability Register Block
 */
#define _DWC3_CAPLENGTH					U(0x0)
#define _DWC3_HCSPARAMS1				U(0x4)
#define _DWC3_HCSPARAMS2				U(0x8)
#define _DWC3_HCSPARAMS3				U(0xC)
#define _DWC3_HCCPARAMS1				U(0x10)
#define _DWC3_DBOFF					U(0x14)
#define _DWC3_RTSOFF					U(0x18)
#define _DWC3_HCCPARAMS2				U(0x1C)

/* _DWC3_CAPLENGTH register fields */
#define _DWC3_CAPLENGTH_CAPLENGTH_MASK			GENMASK_32(7, 0)
#define _DWC3_CAPLENGTH_CAPLENGTH_SHIFT			0
#define _DWC3_CAPLENGTH_HCIVERSION_MASK			GENMASK_32(31, 16)
#define _DWC3_CAPLENGTH_HCIVERSION_SHIFT		16

/* _DWC3_HCSPARAMS1 register fields */
#define _DWC3_HCSPARAMS1_MAXSLOTS_MASK			GENMASK_32(7, 0)
#define _DWC3_HCSPARAMS1_MAXSLOTS_SHIFT			0
#define _DWC3_HCSPARAMS1_MAXINTRS_MASK			GENMASK_32(18, 8)
#define _DWC3_HCSPARAMS1_MAXINTRS_SHIFT			8
#define _DWC3_HCSPARAMS1_MAXPORTS_MASK			GENMASK_32(31, 24)
#define _DWC3_HCSPARAMS1_MAXPORTS_SHIFT			24

/* _DWC3_HCSPARAMS2 register fields */
#define _DWC3_HCSPARAMS2_IST_MASK			GENMASK_32(3, 0)
#define _DWC3_HCSPARAMS2_IST_SHIFT			0
#define _DWC3_HCSPARAMS2_ERSTMAX_MASK			GENMASK_32(7, 4)
#define _DWC3_HCSPARAMS2_ERSTMAX_SHIFT			4
#define _DWC3_HCSPARAMS2_MAXSCRATCHPADBUFS_HI_MASK	GENMASK_32(25, 21)
#define _DWC3_HCSPARAMS2_MAXSCRATCHPADBUFS_HI_SHIFT	21
#define _DWC3_HCSPARAMS2_SPR				BIT_32(26)
#define _DWC3_HCSPARAMS2_MAXSCRATCHPADBUFS_MASK		GENMASK_32(31, 27)
#define _DWC3_HCSPARAMS2_MAXSCRATCHPADBUFS_SHIFT	27

/* _DWC3_HCSPARAMS3 register fields */
#define _DWC3_HCSPARAMS3_U1_DEVICE_EXIT_LAT_MASK	GENMASK_32(7, 0)
#define _DWC3_HCSPARAMS3_U1_DEVICE_EXIT_LAT_SHIFT	0
#define _DWC3_HCSPARAMS3_U2_DEVICE_EXIT_LAT_MASK	GENMASK_32(31, 16)
#define _DWC3_HCSPARAMS3_U2_DEVICE_EXIT_LAT_SHIFT	16

/* _DWC3_HCCPARAMS1 register fields */
#define _DWC3_HCCPARAMS1_AC64				BIT_32(0)
#define _DWC3_HCCPARAMS1_BNC				BIT_32(1)
#define _DWC3_HCCPARAMS1_CSZ				BIT_32(2)
#define _DWC3_HCCPARAMS1_PPC				BIT_32(3)
#define _DWC3_HCCPARAMS1_PIND				BIT_32(4)
#define _DWC3_HCCPARAMS1_LHRC				BIT_32(5)
#define _DWC3_HCCPARAMS1_LTC				BIT_32(6)
#define _DWC3_HCCPARAMS1_NSS				BIT_32(7)
#define _DWC3_HCCPARAMS1_PAE				BIT_32(8)
#define _DWC3_HCCPARAMS1_SPC				BIT_32(9)
#define _DWC3_HCCPARAMS1_SEC				BIT_32(10)
#define _DWC3_HCCPARAMS1_CFC				BIT_32(11)
#define _DWC3_HCCPARAMS1_MAXPSASIZE_MASK		GENMASK_32(15, 12)
#define _DWC3_HCCPARAMS1_MAXPSASIZE_SHIFT		12
#define _DWC3_HCCPARAMS1_XECP_MASK			GENMASK_32(31, 16)
#define _DWC3_HCCPARAMS1_XECP_SHIFT			16

/* _DWC3_DBOFF register fields */
#define _DWC3_DBOFF_DOORBELL_ARRAY_OFFSET_MASK		GENMASK_32(31, 2)
#define _DWC3_DBOFF_DOORBELL_ARRAY_OFFSET_SHIFT		2

/* _DWC3_RTSOFF register fields */
#define _DWC3_RTSOFF_RUNTIME_REG_SPACE_OFFSET_MASK	GENMASK_32(31, 5)
#define _DWC3_RTSOFF_RUNTIME_REG_SPACE_OFFSET_SHIFT	5

/* _DWC3_HCCPARAMS2 register fields */
#define _DWC3_HCCPARAMS2_U3C				BIT_32(0)
#define _DWC3_HCCPARAMS2_CMC				BIT_32(1)
#define _DWC3_HCCPARAMS2_FSC				BIT_32(2)
#define _DWC3_HCCPARAMS2_CTC				BIT_32(3)
#define _DWC3_HCCPARAMS2_LEC				BIT_32(4)
#define _DWC3_HCCPARAMS2_CIC				BIT_32(5)

/*
 * USB3 Host Cntrl Oper Regs Block
 */
#define _DWC3_USBCMD					U(0x0)
#define _DWC3_USBSTS					U(0x4)
#define _DWC3_PAGESIZE					U(0x8)
#define _DWC3_DNCTRL					U(0x14)
#define _DWC3_CRCR_LO					U(0x18)
#define _DWC3_CRCR_HI					U(0x1C)
#define _DWC3_DCBAAP_LO					U(0x30)
#define _DWC3_DCBAAP_HI					U(0x34)
#define _DWC3_CONFIG					U(0x38)

/* _DWC3_USBCMD register fields */
#define _DWC3_USBCMD_R_S				BIT_32(0)
#define _DWC3_USBCMD_HCRST				BIT_32(1)
#define _DWC3_USBCMD_INTE				BIT_32(2)
#define _DWC3_USBCMD_HSEE				BIT_32(3)
#define _DWC3_USBCMD_LHCRST				BIT_32(7)
#define _DWC3_USBCMD_CSS				BIT_32(8)
#define _DWC3_USBCMD_CRS				BIT_32(9)
#define _DWC3_USBCMD_EWE				BIT_32(10)
#define _DWC3_USBCMD_EU3S				BIT_32(11)
#define _DWC3_USBCMD_CME				BIT_32(13)

/* _DWC3_USBSTS register fields */
#define _DWC3_USBSTS_HCH				BIT_32(0)
#define _DWC3_USBSTS_HSE				BIT_32(2)
#define _DWC3_USBSTS_EINT				BIT_32(3)
#define _DWC3_USBSTS_PCD				BIT_32(4)
#define _DWC3_USBSTS_SSS				BIT_32(8)
#define _DWC3_USBSTS_RSS				BIT_32(9)
#define _DWC3_USBSTS_SRE				BIT_32(10)
#define _DWC3_USBSTS_CNR				BIT_32(11)
#define _DWC3_USBSTS_HCE				BIT_32(12)

/* _DWC3_PAGESIZE register fields */
#define _DWC3_PAGESIZE_PAGE_SIZE_MASK			GENMASK_32(15, 0)
#define _DWC3_PAGESIZE_PAGE_SIZE_SHIFT			0

/* _DWC3_DNCTRL register fields */
#define _DWC3_DNCTRL_N0_N15_MASK			GENMASK_32(15, 0)
#define _DWC3_DNCTRL_N0_N15_SHIFT			0

/* _DWC3_CRCR_LO register fields */
#define _DWC3_CRCR_LO_RCS				BIT_32(0)
#define _DWC3_CRCR_LO_CS				BIT_32(1)
#define _DWC3_CRCR_LO_CA				BIT_32(2)
#define _DWC3_CRCR_LO_CRR				BIT_32(3)
#define _DWC3_CRCR_LO_CMD_RING_PNTR_MASK		GENMASK_32(31, 6)
#define _DWC3_CRCR_LO_CMD_RING_PNTR_SHIFT		6

/* _DWC3_DCBAAP_LO register fields */
#define _DWC3_DCBAAP_LO_DEVICE_CONTEXT_BAAP_MASK	GENMASK_32(31, 6)
#define _DWC3_DCBAAP_LO_DEVICE_CONTEXT_BAAP_SHIFT	6

/* _DWC3_CONFIG register fields */
#define _DWC3_CONFIG_MAXSLOTSEN_MASK			GENMASK_32(7, 0)
#define _DWC3_CONFIG_MAXSLOTSEN_SHIFT			0
#define _DWC3_CONFIG_U3E				BIT_32(8)
#define _DWC3_CONFIG_CIE				BIT_32(9)

/*
 * USB3 Host Cntrl Port Reg Set Block
 */
#define _DWC3_PORTSC_20					U(0x0)
#define _DWC3_PORTPMSC_20				U(0x4)
#define _DWC3_PORTLI_20					U(0x8)
#define _DWC3_PORTHLPMC_20				U(0xc)
#define _DWC3_PORTSC_30					U(0x10)
#define _DWC3_PORTPMSC_30				U(0x14)
#define _DWC3_PORTLI_30					U(0x18)
#define _DWC3_PORTHLPMC_30				U(0x1c)

/* _DWC3_PORTSC_20 register fields */
#define _DWC3_PORTSC_20_CCS				BIT_32(0)
#define _DWC3_PORTSC_20_PED				BIT_32(1)
#define _DWC3_PORTSC_20_OCA				BIT_32(3)
#define _DWC3_PORTSC_20_PR				BIT_32(4)
#define _DWC3_PORTSC_20_PLS_MASK			GENMASK_32(8, 5)
#define _DWC3_PORTSC_20_PLS_SHIFT			5
#define _DWC3_PORTSC_20_PP				BIT_32(9)
#define _DWC3_PORTSC_20_PORTSPEED_MASK			GENMASK_32(13, 10)
#define _DWC3_PORTSC_20_PORTSPEED_SHIFT			10
#define _DWC3_PORTSC_20_PIC_MASK			GENMASK_32(15, 14)
#define _DWC3_PORTSC_20_PIC_SHIFT			14
#define _DWC3_PORTSC_20_LWS				BIT_32(16)
#define _DWC3_PORTSC_20_CSC				BIT_32(17)
#define _DWC3_PORTSC_20_PEC				BIT_32(18)
#define _DWC3_PORTSC_20_OCC				BIT_32(20)
#define _DWC3_PORTSC_20_PRC				BIT_32(21)
#define _DWC3_PORTSC_20_PLC				BIT_32(22)
#define _DWC3_PORTSC_20_CAS				BIT_32(24)
#define _DWC3_PORTSC_20_WCE				BIT_32(25)
#define _DWC3_PORTSC_20_WDE				BIT_32(26)
#define _DWC3_PORTSC_20_WOE				BIT_32(27)
#define _DWC3_PORTSC_20_DR				BIT_32(30)

/* _DWC3_PORTPMSC_20 register fields */
#define _DWC3_PORTPMSC_20_L1S_MASK			GENMASK_32(2, 0)
#define _DWC3_PORTPMSC_20_L1S_SHIFT			0
#define _DWC3_PORTPMSC_20_RWE				BIT_32(3)
#define _DWC3_PORTPMSC_20_HIRD_MASK			GENMASK_32(7, 4)
#define _DWC3_PORTPMSC_20_HIRD_SHIFT			4
#define _DWC3_PORTPMSC_20_L1DSLOT_MASK			GENMASK_32(15, 8)
#define _DWC3_PORTPMSC_20_L1DSLOT_SHIFT			8
#define _DWC3_PORTPMSC_20_HLE				BIT_32(16)
#define _DWC3_PORTPMSC_20_PRTTSTCTRL_MASK		GENMASK_32(31, 28)
#define _DWC3_PORTPMSC_20_PRTTSTCTRL_SHIFT		28

/* _DWC3_PORTHLPMC_20 register fields */
#define _DWC3_PORTHLPMC_20_HIRDM_MASK			GENMASK_32(1, 0)
#define _DWC3_PORTHLPMC_20_HIRDM_SHIFT			0
#define _DWC3_PORTHLPMC_20_L1_TIMEOUT_MASK		GENMASK_32(9, 2)
#define _DWC3_PORTHLPMC_20_L1_TIMEOUT_SHIFT		2
#define _DWC3_PORTHLPMC_20_HIRDD_MASK			GENMASK_32(13, 10)
#define _DWC3_PORTHLPMC_20_HIRDD_SHIFT			10

/* _DWC3_PORTSC_30 register fields */
#define _DWC3_PORTSC_30_CCS				BIT_32(0)
#define _DWC3_PORTSC_30_PED				BIT_32(1)
#define _DWC3_PORTSC_30_OCA				BIT_32(3)
#define _DWC3_PORTSC_30_PR				BIT_32(4)
#define _DWC3_PORTSC_30_PLS_MASK			GENMASK_32(8, 5)
#define _DWC3_PORTSC_30_PLS_SHIFT			5
#define _DWC3_PORTSC_30_PP				BIT_32(9)
#define _DWC3_PORTSC_30_PORTSPEED_MASK			GENMASK_32(13, 10)
#define _DWC3_PORTSC_30_PORTSPEED_SHIFT			10
#define _DWC3_PORTSC_30_PIC_MASK			GENMASK_32(15, 14)
#define _DWC3_PORTSC_30_PIC_SHIFT			14
#define _DWC3_PORTSC_30_LWS				BIT_32(16)
#define _DWC3_PORTSC_30_CSC				BIT_32(17)
#define _DWC3_PORTSC_30_PEC				BIT_32(18)
#define _DWC3_PORTSC_30_WRC				BIT_32(19)
#define _DWC3_PORTSC_30_OCC				BIT_32(20)
#define _DWC3_PORTSC_30_PRC				BIT_32(21)
#define _DWC3_PORTSC_30_PLC				BIT_32(22)
#define _DWC3_PORTSC_30_CEC				BIT_32(23)
#define _DWC3_PORTSC_30_CAS				BIT_32(24)
#define _DWC3_PORTSC_30_WCE				BIT_32(25)
#define _DWC3_PORTSC_30_WDE				BIT_32(26)
#define _DWC3_PORTSC_30_WOE				BIT_32(27)
#define _DWC3_PORTSC_30_DR				BIT_32(30)
#define _DWC3_PORTSC_30_WPR				BIT_32(31)

/* _DWC3_PORTPMSC_30 register fields */
#define _DWC3_PORTPMSC_30_U1_TIMEOUT_MASK		GENMASK_32(7, 0)
#define _DWC3_PORTPMSC_30_U1_TIMEOUT_SHIFT		0
#define _DWC3_PORTPMSC_30_U2_TIMEOUT_MASK		GENMASK_32(15, 8)
#define _DWC3_PORTPMSC_30_U2_TIMEOUT_SHIFT		8
#define _DWC3_PORTPMSC_30_FLA				BIT_32(16)

/* _DWC3_PORTLI_30 register fields */
#define _DWC3_PORTLI_30_LINK_ERROR_COUNT_MASK		GENMASK_32(15, 0)
#define _DWC3_PORTLI_30_LINK_ERROR_COUNT_SHIFT		0

/*
 * USB3 Host Cntrl Runtime Regs Block
 */
#define _DWC3_MFINDEX					U(0x0)

/* _DWC3_MFINDEX register fields */
#define _DWC3_MFINDEX_MICROFRAME_INDEX_MASK		GENMASK_32(13, 0)
#define _DWC3_MFINDEX_MICROFRAME_INDEX_SHIFT		0

/*
 * USB3 Interrupter Regs Block
 */
#define _DWC3_IMAN					U(0x0)
#define _DWC3_IMOD					U(0x4)
#define _DWC3_ERSTSZ					U(0x8)
#define _DWC3_ERSTBA_LO					U(0x10)
#define _DWC3_ERSTBA_HI					U(0x14)
#define _DWC3_ERDP_LO					U(0x18)
#define _DWC3_ERDP_HI					U(0x1c)

/* _DWC3_IMAN register fields */
#define _DWC3_IMAN_IP					BIT_32(0)
#define _DWC3_IMAN_IE					BIT_32(1)

/* _DWC3_IMOD register fields */
#define _DWC3_IMOD_IMODI_MASK				GENMASK_32(15, 0)
#define _DWC3_IMOD_IMODI_SHIFT				0
#define _DWC3_IMOD_IMODC_MASK				GENMASK_32(31, 16)
#define _DWC3_IMOD_IMODC_SHIFT				16

/* _DWC3_ERSTSZ register fields */
#define _DWC3_ERSTSZ_ERS_TABLE_SIZE_MASK		GENMASK_32(15, 0)
#define _DWC3_ERSTSZ_ERS_TABLE_SIZE_SHIFT		0

/* _DWC3_ERSTBA_LO register fields */
#define _DWC3_ERSTBA_LO_ERS_TABLE_BAR_MASK		GENMASK_32(31, 6)
#define _DWC3_ERSTBA_LO_ERS_TABLE_BAR_SHIFT		6

/* _DWC3_ERDP_LO register fields */
#define _DWC3_ERDP_LO_DESI_MASK				GENMASK_32(2, 0)
#define _DWC3_ERDP_LO_DESI_SHIFT			0
#define _DWC3_ERDP_LO_EHB				BIT_32(3)
#define _DWC3_ERDP_LO_ERD_PNTR_MASK			GENMASK_32(31, 4)
#define _DWC3_ERDP_LO_ERD_PNTR_SHIFT			4

/*
 * USB3 Doorbell Reg Block
 */
#define _DWC3_DB					U(0x0)

/* _DWC3_DB register fields */
#define _DWC3_DB_DB_TARGET_MASK				GENMASK_32(7, 0)
#define _DWC3_DB_DB_TARGET_SHIFT			0
#define _DWC3_DB_DB_STREAM_ID_MASK			GENMASK_32(31, 16)
#define _DWC3_DB_DB_STREAM_ID_SHIFT			16

/*
 * USB3 internal RAM0 Register Block

 * For a description of this standard USB register field, see the eXtensible Host Controller
 * Interface for Universal Serial Bus (USB) Specification 3.0.

 */

/*
 * USB3 internal RAM1 Register Block

 * For a description of this standard USB register field, see the eXtensible Host Controller
 * Interface for Universal Serial Bus (USB) Specification 3.0.

 */

/*
 * USB3 internal RAM2 Register Block
 */

/*
 * USB3 HC Extended Capability Register Block
 */
#define _DWC3_USBLEGSUP					U(0x0)
#define _DWC3_USBLEGCTLSTS				U(0x4)

/* _DWC3_USBLEGSUP register fields */
#define _DWC3_USBLEGSUP_CAPABILITY_ID_MASK		GENMASK_32(7, 0)
#define _DWC3_USBLEGSUP_CAPABILITY_ID_SHIFT		0
#define _DWC3_USBLEGSUP_NEXT_CAPABILITY_POINTER_MASK	GENMASK_32(15, 8)
#define _DWC3_USBLEGSUP_NEXT_CAPABILITY_POINTER_SHIFT	8
#define _DWC3_USBLEGSUP_HC_BIOS_OWNED			BIT_32(16)
#define _DWC3_USBLEGSUP_HC_OS_OWNED			BIT_32(24)

/* _DWC3_USBLEGCTLSTS register fields */
#define _DWC3_USBLEGCTLSTS_USB_SMI_ENABLE		BIT_32(0)
#define _DWC3_USBLEGCTLSTS_SMI_ON_HOST_E		BIT_32(4)
#define _DWC3_USBLEGCTLSTS_SMI_ON_OS_E			BIT_32(13)
#define _DWC3_USBLEGCTLSTS_SMI_ON_PCI_E			BIT_32(14)
#define _DWC3_USBLEGCTLSTS_SMI_ON_BAR_E			BIT_32(15)
#define _DWC3_USBLEGCTLSTS_SMI_ON_EVENT			BIT_32(16)
#define _DWC3_USBLEGCTLSTS_SMI_ON_HOST			BIT_32(20)
#define _DWC3_USBLEGCTLSTS_SMI_ON_OS			BIT_32(29)
#define _DWC3_USBLEGCTLSTS_SMI_ON_PCI			BIT_32(30)
#define _DWC3_USBLEGCTLSTS_SMI_ON_BAR			BIT_32(31)

/*
 * USB3 xHCI Supported Protocol Capability (USB 2.0) Block
 */
#define _DWC3_SUPTPRT2_DW0				U(0x0)
#define _DWC3_SUPTPRT2_DW1				U(0x4)
#define _DWC3_SUPTPRT2_DW2				U(0x8)
#define _DWC3_SUPTPRT2_DW3				U(0xC)

/* _DWC3_SUPTPRT2_DW0 register fields */
#define _DWC3_SUPTPRT2_DW0_CAPABILITY_ID_MASK		GENMASK_32(7, 0)
#define _DWC3_SUPTPRT2_DW0_CAPABILITY_ID_SHIFT		0
#define _DWC3_SUPTPRT2_DW0_NEXT_CAPABILITY_POINTER_MASK	GENMASK_32(15, 8)
#define _DWC3_SUPTPRT2_DW0_NEXT_CAPABILITY_POINTER_SHIFT	8
#define _DWC3_SUPTPRT2_DW0_MINOR_REVISION_MASK		GENMASK_32(23, 16)
#define _DWC3_SUPTPRT2_DW0_MINOR_REVISION_SHIFT		16
#define _DWC3_SUPTPRT2_DW0_MAJOR_REVISION_MASK		GENMASK_32(31, 24)
#define _DWC3_SUPTPRT2_DW0_MAJOR_REVISION_SHIFT		24

/* _DWC3_SUPTPRT2_DW2 register fields */
#define _DWC3_SUPTPRT2_DW2_COMPATIBLE_PORT_OFFSET_MASK	GENMASK_32(7, 0)
#define _DWC3_SUPTPRT2_DW2_COMPATIBLE_PORT_OFFSET_SHIFT	0
#define _DWC3_SUPTPRT2_DW2_COMPATIBLE_PORT_COUNT_MASK	GENMASK_32(15, 8)
#define _DWC3_SUPTPRT2_DW2_COMPATIBLE_PORT_COUNT_SHIFT	8
#define _DWC3_SUPTPRT2_DW2_HSO				BIT_32(17)
#define _DWC3_SUPTPRT2_DW2_IHI				BIT_32(18)
#define _DWC3_SUPTPRT2_DW2_HLC				BIT_32(19)
#define _DWC3_SUPTPRT2_DW2_BLC				BIT_32(20)
#define _DWC3_SUPTPRT2_DW2_MHD_MASK			GENMASK_32(27, 25)
#define _DWC3_SUPTPRT2_DW2_MHD_SHIFT			25
#define _DWC3_SUPTPRT2_DW2_PSIC_MASK			GENMASK_32(31, 28)
#define _DWC3_SUPTPRT2_DW2_PSIC_SHIFT			28

/* _DWC3_SUPTPRT2_DW3 register fields */
#define _DWC3_SUPTPRT2_DW3_PROTCL_SLT_TY_MASK		GENMASK_32(4, 0)
#define _DWC3_SUPTPRT2_DW3_PROTCL_SLT_TY_SHIFT		0

/*
 * USB3 xHCI Supported Protocol Capability (USB 3.0) Block
 */
#define _DWC3_SUPTPRT3_DW0				U(0x0)
#define _DWC3_SUPTPRT3_DW1				U(0x4)
#define _DWC3_SUPTPRT3_DW2				U(0x8)
#define _DWC3_SUPTPRT3_DW3				U(0xC)

/* _DWC3_SUPTPRT3_DW0 register fields */
#define _DWC3_SUPTPRT3_DW0_CAPABILITY_ID_MASK		GENMASK_32(7, 0)
#define _DWC3_SUPTPRT3_DW0_CAPABILITY_ID_SHIFT		0
#define _DWC3_SUPTPRT3_DW0_NEXT_CAPABILITY_POINTER_MASK	GENMASK_32(15, 8)
#define _DWC3_SUPTPRT3_DW0_NEXT_CAPABILITY_POINTER_SHIFT	8
#define _DWC3_SUPTPRT3_DW0_MINOR_REVISION_MASK		GENMASK_32(23, 16)
#define _DWC3_SUPTPRT3_DW0_MINOR_REVISION_SHIFT		16
#define _DWC3_SUPTPRT3_DW0_MAJOR_REVISION_MASK		GENMASK_32(31, 24)
#define _DWC3_SUPTPRT3_DW0_MAJOR_REVISION_SHIFT		24

/* _DWC3_SUPTPRT3_DW2 register fields */
#define _DWC3_SUPTPRT3_DW2_COMPATIBLE_PORT_OFFSET_MASK	GENMASK_32(7, 0)
#define _DWC3_SUPTPRT3_DW2_COMPATIBLE_PORT_OFFSET_SHIFT	0
#define _DWC3_SUPTPRT3_DW2_COMPATIBLE_PORT_COUNT_MASK	GENMASK_32(15, 8)
#define _DWC3_SUPTPRT3_DW2_COMPATIBLE_PORT_COUNT_SHIFT	8
#define _DWC3_SUPTPRT3_DW2_MHD_MASK			GENMASK_32(27, 25)
#define _DWC3_SUPTPRT3_DW2_MHD_SHIFT			25
#define _DWC3_SUPTPRT3_DW2_PSIC_MASK			GENMASK_32(31, 28)
#define _DWC3_SUPTPRT3_DW2_PSIC_SHIFT			28

/* _DWC3_SUPTPRT3_DW3 register fields */
#define _DWC3_SUPTPRT3_DW3_PROTCL_SLT_TY_MASK		GENMASK_32(4, 0)
#define _DWC3_SUPTPRT3_DW3_PROTCL_SLT_TY_SHIFT		0

#endif /* __USB_DWC3_REGS_H */
