#include <graphics.h>
#include <stdio.h>

int
  xm, ym,
  font,
  direction,
  style,
  horiz, vert,
  size;

char
  *str = "Text String",
  *horiz_str[3] = {"LEFT_TEXT", "CENTER_TEXT", "RIGHT_TEXT"},
  *vert_str[3] =  {"BOTTOM_TEXT", "CENTER_TEXT", "TOP_TEXT"};

/* ----- */

void print_justification ()
{
  char tmp[100];
  
  sprintf (tmp, "height = %d", textheight (str));  
  settextstyle (DEFAULT_FONT, HORIZ_DIR, 0);
  settextjustify (HORIZ_DIR, TOP_TEXT);
  bar (0, 0, 200, 24);
  outtextxy (0, 0, horiz_str[horiz]);
  outtextxy (0, 8, vert_str[vert]);
  outtextxy (0, 16, tmp);
  settextstyle (font, direction, size);
  settextjustify (horiz, vert);
}

/* ----- */

void draw_axis ()
{
  line (0, ym, getmaxx (), ym);
  line (xm, 0, xm, getmaxy ());
}

void font_test ()
{

  direction = HORIZ_DIR;
  settextstyle (font, direction, size);

  /* these are OK */
  for (horiz = LEFT_TEXT; horiz < RIGHT_TEXT + 1; horiz++) {
    for (vert = BOTTOM_TEXT; vert < TOP_TEXT + 1; vert++) {
      settextjustify (horiz, vert);
      outtextxy (xm, ym, str);
      print_justification ();
      getch ();
      cleardevice ();
      draw_axis ();
    }
    /* cleardevice ();
    draw_axis (); */
  }

  direction = VERT_DIR;
  settextstyle (font, direction, size);

  for (horiz = LEFT_TEXT; horiz < RIGHT_TEXT + 1; horiz++) {
    for (vert = BOTTOM_TEXT; vert < TOP_TEXT + 1; vert++) {
      settextjustify (horiz, vert);
      outtextxy (xm, ym, str);
      print_justification ();
      getch ();
      cleardevice ();
      draw_axis ();
    }
    /* cleardevice ();
    draw_axis (); */
  }
  
} /* font_test () */

/* ----- */

int main(int argv, char **args)
{
  int
    gd = DETECT,
    gm = VGAHI;
  
  initgraph (&gd, &gm, NULL);
  cleardevice ();
  setfillstyle (SOLID_FILL, BLACK);
  xm = getmaxx () / 2;
  ym = getmaxy () / 2;
  draw_axis ();

  size = 2;
  font = DEFAULT_FONT;
  font_test ();

  size = 0;
  font = BOLD_FONT;
  font_test ();

  /*  add your own font here:
  size = 0;
  font = installuserfont ("FONT.CHR");
  font_test ();
  */
  
  restorecrtmode ();
  exit (0);
}

